/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import eu.hansolo.tilesfx.TimeSection;
import eu.hansolo.tilesfx.TimeSectionBuilder;
import eu.hansolo.tilesfx.addons.HappinessIndicator;
import eu.hansolo.tilesfx.addons.Indicator;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.RadarChartMode;
import eu.hansolo.tilesfx.chart.SunburstChart;
import eu.hansolo.tilesfx.chart.TilesFXSeries;
import eu.hansolo.tilesfx.colors.Bright;
import eu.hansolo.tilesfx.colors.ColorSkin;
import eu.hansolo.tilesfx.colors.Dark;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.icons.Flag;
import eu.hansolo.tilesfx.skins.BarChartItem;
import eu.hansolo.tilesfx.skins.LeaderBoardItem;
import eu.hansolo.tilesfx.tools.Country;
import eu.hansolo.tilesfx.tools.FlowGridPane;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Location;
import eu.hansolo.tilesfx.tools.MatrixIcon;
import eu.hansolo.tilesfx.tools.Rank;
import eu.hansolo.tilesfx.tools.Ranking;
import eu.hansolo.tilesfx.tools.TreeNode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static final Random RND = new Random();
    private static final double TILE_WIDTH = 150.0;
    private static final double TILE_HEIGHT = 150.0;
    private int noOfNodes = 0;
    private BarChartItem barChartItem1;
    private BarChartItem barChartItem2;
    private BarChartItem barChartItem3;
    private BarChartItem barChartItem4;
    private LeaderBoardItem leaderBoardItem1;
    private LeaderBoardItem leaderBoardItem2;
    private LeaderBoardItem leaderBoardItem3;
    private LeaderBoardItem leaderBoardItem4;
    private ChartData chartData1;
    private ChartData chartData2;
    private ChartData chartData3;
    private ChartData chartData4;
    private ChartData chartData5;
    private ChartData chartData6;
    private ChartData chartData7;
    private ChartData chartData8;
    private ChartData smoothChartData1;
    private ChartData smoothChartData2;
    private ChartData smoothChartData3;
    private ChartData smoothChartData4;
    private Rank firstRank;
    private Tile percentageTile;
    private Tile clockTile;
    private Tile gaugeTile;
    private Tile sparkLineTile;
    private Tile areaChartTile;
    private Tile lineChartTile;
    private Tile highLowTile;
    private Tile timerControlTile;
    private Tile numberTile;
    private Tile textTile;
    private Tile plusMinusTile;
    private Tile sliderTile;
    private Tile switchTile;
    private Tile worldTile;
    private Tile timeTile;
    private Tile barChartTile;
    private Tile customTile;
    private Tile leaderBoardTile;
    private Tile mapTile;
    private Tile radialChartTile;
    private Tile donutChartTile;
    private Tile circularProgressTile;
    private Tile stockTile;
    private Tile gaugeSparkLineTile;
    private Tile radarChartTile1;
    private Tile radarChartTile2;
    private Tile smoothAreaChartTile;
    private Tile countryTile;
    private Tile characterTile;
    private Tile flipTile;
    private Tile switchSliderTile;
    private Tile dateTile;
    private Tile calendarTile;
    private Tile sunburstTile;
    private Tile matrixTile;
    private Tile radialPercentageTile;
    private Tile statusTile;
    private Tile barGaugeTile;
    private Tile imageTile;
    private Tile timelineTile;
    private Tile imageCounterTile;
    private Tile ledTile;
    private Tile countdownTile;
    private Tile matrixIconTile;
    private Tile cycleStepTile;
    private Tile customFlagChartTile;
    private Tile colorTile;
    private Tile turnoverTile;
    private Tile fluidTile;
    private Tile fireSmokeTile;
    private Tile gauge2Tile;
    private Tile happinessTile;
    private Tile radialDistributionTile;
    private long lastTimerCall;
    private AnimationTimer timer;
    private DoubleProperty value;

    @Override
    public void init() {
        long start = System.currentTimeMillis();
        this.value = new SimpleDoubleProperty(0.0);
        final XYChart.Series series1 = new XYChart.Series();
        series1.setName("Whatever");
        series1.getData().add(new XYChart.Data<String, Integer>("MO", 23));
        series1.getData().add(new XYChart.Data<String, Integer>("TU", 21));
        series1.getData().add(new XYChart.Data<String, Integer>("WE", 20));
        series1.getData().add(new XYChart.Data<String, Integer>("TH", 22));
        series1.getData().add(new XYChart.Data<String, Integer>("FR", 24));
        series1.getData().add(new XYChart.Data<String, Integer>("SA", 22));
        series1.getData().add(new XYChart.Data<String, Integer>("SU", 20));
        final XYChart.Series series2 = new XYChart.Series();
        series2.setName("Inside");
        series2.getData().add(new XYChart.Data<String, Integer>("MO", 8));
        series2.getData().add(new XYChart.Data<String, Integer>("TU", 5));
        series2.getData().add(new XYChart.Data<String, Integer>("WE", 0));
        series2.getData().add(new XYChart.Data<String, Integer>("TH", 2));
        series2.getData().add(new XYChart.Data<String, Integer>("FR", 4));
        series2.getData().add(new XYChart.Data<String, Integer>("SA", 3));
        series2.getData().add(new XYChart.Data<String, Integer>("SU", 5));
        final XYChart.Series series3 = new XYChart.Series();
        series3.setName("Outside");
        series3.getData().add(new XYChart.Data<String, Integer>("MO", 8));
        series3.getData().add(new XYChart.Data<String, Integer>("TU", 5));
        series3.getData().add(new XYChart.Data<String, Integer>("WE", 0));
        series3.getData().add(new XYChart.Data<String, Integer>("TH", 2));
        series3.getData().add(new XYChart.Data<String, Integer>("FR", 4));
        series3.getData().add(new XYChart.Data<String, Integer>("SA", 3));
        series3.getData().add(new XYChart.Data<String, Integer>("SU", 5));
        for (int i = 0; i < Country.values().length; ++i) {
            double value = RND.nextInt(10);
            Color color = value > 8.0 ? Tile.RED : (value > 6.0 ? Tile.ORANGE : (value > 4.0 ? Tile.YELLOW_ORANGE : (value > 2.0 ? Tile.GREEN : Tile.BLUE)));
            Country.values()[i].setColor(color);
        }
        TimeSection timeSection = ((TimeSectionBuilder)((TimeSectionBuilder)((TimeSectionBuilder)((TimeSectionBuilder)TimeSectionBuilder.create().start(LocalTime.now().plusSeconds(20L))).stop(LocalTime.now().plusHours(1L))).color(Tile.GRAY)).highlightColor(Tile.RED)).build();
        timeSection.setOnTimeSectionEntered(e -> System.out.println("Section ACTIVE"));
        timeSection.setOnTimeSectionLeft(e -> System.out.println("Section INACTIVE"));
        this.barChartItem1 = new BarChartItem("Gerrit", 47.0, Tile.BLUE);
        this.barChartItem2 = new BarChartItem("Sandra", 43.0, Tile.RED);
        this.barChartItem3 = new BarChartItem("Lilli", 12.0, Tile.GREEN);
        this.barChartItem4 = new BarChartItem("Anton", 8.0, Tile.ORANGE);
        this.barChartItem1.setFormatString("%.1f kWh");
        this.leaderBoardItem1 = new LeaderBoardItem("Gerrit", 47.0);
        this.leaderBoardItem2 = new LeaderBoardItem("Sandra", 43.0);
        this.leaderBoardItem3 = new LeaderBoardItem("Lilli", 12.0);
        this.leaderBoardItem4 = new LeaderBoardItem("Anton", 8.0);
        this.chartData1 = new ChartData("Item 1", 24.0, Tile.GREEN);
        this.chartData2 = new ChartData("Item 2", 10.0, Tile.BLUE);
        this.chartData3 = new ChartData("Item 3", 12.0, Tile.RED);
        this.chartData4 = new ChartData("Item 4", 13.0, Tile.YELLOW_ORANGE);
        this.chartData5 = new ChartData("Item 5", 13.0, Tile.BLUE);
        this.chartData6 = new ChartData("Item 6", 13.0, Tile.BLUE);
        this.chartData7 = new ChartData("Item 7", 13.0, Tile.BLUE);
        this.chartData8 = new ChartData("Item 8", 13.0, Tile.BLUE);
        this.smoothChartData1 = new ChartData("Item 1", RND.nextDouble() * 25.0, Tile.BLUE);
        this.smoothChartData2 = new ChartData("Item 2", RND.nextDouble() * 25.0, Tile.BLUE);
        this.smoothChartData3 = new ChartData("Item 3", RND.nextDouble() * 25.0, Tile.BLUE);
        this.smoothChartData4 = new ChartData("Item 4", RND.nextDouble() * 25.0, Tile.BLUE);
        this.percentageTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.PERCENTAGE)).prefSize(150.0, 150.0)).title("Percentage Tile")).unit("%")).description("Test")).maxValue(60.0)).build();
        this.clockTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CLOCK)).prefSize(150.0, 150.0)).title("Clock Tile")).text("Whatever text")).dateVisible(true)).locale(Locale.US)).running(true)).build();
        this.gaugeTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.GAUGE)).prefSize(150.0, 150.0)).title("Gauge Tile")).unit("V")).threshold(75.0)).build();
        this.sparkLineTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SPARK_LINE)).prefSize(150.0, 150.0)).title("SparkLine Tile")).unit("mb")).gradientStops(new Stop(0.0, Tile.GREEN), new Stop(0.5, Tile.YELLOW), new Stop(1.0, Tile.RED))).strokeWithGradient(true)).build();
        this.areaChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SMOOTHED_CHART)).prefSize(150.0, 150.0)).title("SmoothedChart Tile")).chartType(Tile.ChartType.AREA)).smoothing(true)).tooltipTimeout(1000.0)).tilesFxSeries(new TilesFXSeries(series1, Tile.BLUE, new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Tile.BLUE), new Stop(1.0, Color.TRANSPARENT))))).build();
        this.lineChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SMOOTHED_CHART)).prefSize(150.0, 150.0)).title("SmoothedChart Tile")).smoothing(false)).series(series2, series3)).build();
        this.highLowTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.HIGH_LOW)).prefSize(150.0, 150.0)).title("HighLow Tile")).unit("\u20ac")).description("Test")).text("Whatever text")).referenceValue(6.7)).value(8.2)).build();
        this.timerControlTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TIMER_CONTROL)).prefSize(150.0, 150.0)).title("TimerControl Tile")).text("Whatever text")).secondsVisible(true)).dateVisible(true)).timeSections(timeSection)).running(true)).build();
        this.numberTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.NUMBER)).prefSize(150.0, 150.0)).title("Number Tile")).text("Whatever text")).value(13.0)).unit("mb")).description("Test")).textVisible(true)).build();
        this.textTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TEXT)).prefSize(150.0, 150.0)).title("Text Tile")).text("Whatever text")).description("May the force be with you\n...always")).descriptionAlignment(Pos.TOP_LEFT)).textVisible(true)).build();
        this.plusMinusTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.PLUS_MINUS)).prefSize(150.0, 150.0)).maxValue(30.0)).minValue(0.0)).title("PlusMinus Tile")).text("Whatever text")).description("Test")).unit("\u00b0C")).build();
        this.sliderTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SLIDER)).prefSize(150.0, 150.0)).title("Slider Tile")).text("Whatever text")).description("Test")).unit("\u00b0C")).barBackgroundColor(Tile.FOREGROUND)).build();
        this.switchTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SWITCH)).prefSize(150.0, 150.0)).title("Switch Tile")).text("Whatever text")).build();
        this.switchTile.setOnSwitchPressed(e -> System.out.println("Switch pressed"));
        this.switchTile.setOnSwitchReleased(e -> System.out.println("Switch released"));
        this.worldTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().prefSize(300.0, 150.0)).skinType(Tile.SkinType.WORLDMAP)).title("WorldMap Tile")).text("Whatever text")).textVisible(false)).build();
        this.timeTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TIME)).prefSize(150.0, 150.0)).title("Time Tile")).text("Whatever text")).duration(LocalTime.of(1, 22))).description("Average reply time")).textVisible(true)).build();
        this.barChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.BAR_CHART)).prefSize(150.0, 150.0)).title("BarChart Tile")).text("Whatever text")).barChartItems(this.barChartItem1, this.barChartItem2, this.barChartItem3, this.barChartItem4)).decimals(0)).build();
        this.customTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CUSTOM)).prefSize(150.0, 150.0)).title("Custom Tile")).text("Whatever text")).graphic(new Button("Click Me"))).roundedCorners(false)).build();
        this.leaderBoardTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.LEADER_BOARD)).prefSize(150.0, 150.0)).title("LeaderBoard Tile")).text("Whatever text")).leaderBoardItems(this.leaderBoardItem1, this.leaderBoardItem2, this.leaderBoardItem3, this.leaderBoardItem4)).build();
        this.mapTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.MAP)).prefSize(150.0, 150.0)).title("Map Tile")).text("Some text")).description("Description")).currentLocation(new Location(51.91178, 7.63379, "Home", Tile.TileColor.MAGENTA.color))).pointsOfInterest(new Location(51.914405, 7.635732, "POI 1", Tile.TileColor.RED.color), new Location(51.912529, 7.631752, "POI 2", Tile.TileColor.BLUE.color), new Location(51.923993, 7.628906, "POI 3", Tile.TileColor.YELLOW_ORANGE.color))).mapProvider(Tile.MapProvider.TOPO)).build();
        this.radialChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.RADIAL_CHART)).prefSize(150.0, 150.0)).title("RadialChart Tile")).text("Some text")).textVisible(false)).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4)).build();
        this.donutChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.DONUT_CHART)).prefSize(150.0, 150.0)).title("DonutChart Tile")).text("Some text")).textVisible(false)).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4)).build();
        this.circularProgressTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CIRCULAR_PROGRESS)).prefSize(150.0, 150.0)).title("CircularProgress Tile")).text("Some text")).unit("%")).build();
        this.stockTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.STOCK)).prefSize(150.0, 150.0)).title("Stock Tile")).minValue(0.0)).maxValue(1000.0)).averagingPeriod(100)).build();
        this.gaugeSparkLineTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.GAUGE_SPARK_LINE)).prefSize(150.0, 150.0)).title("GaugeSparkLine Tile")).animated(true)).textVisible(false)).averagingPeriod(25)).autoReferenceValue(true)).barColor(Tile.YELLOW_ORANGE)).barBackgroundColor(Color.rgb(255, 255, 255, 0.1))).sections(new Section(0.0, 33.0, Tile.LIGHT_GREEN), new Section(33.0, 67.0, Tile.YELLOW), new Section(67.0, 100.0, Tile.LIGHT_RED))).sectionsVisible(true)).highlightSections(true)).strokeWithGradient(true)).fixedYScale(true)).gradientStops(new Stop(0.0, Tile.LIGHT_GREEN), new Stop(0.33, Tile.LIGHT_GREEN), new Stop(0.33, Tile.YELLOW), new Stop(0.67, Tile.YELLOW), new Stop(0.67, Tile.LIGHT_RED), new Stop(1.0, Tile.LIGHT_RED))).build();
        this.radarChartTile1 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.RADAR_CHART)).prefSize(150.0, 150.0)).minValue(0.0)).maxValue(50.0)).title("RadarChartTileSkin Sector")).unit("Unit")).radarChartMode(RadarChartMode.SECTOR)).gradientStops(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0E-5, Color.web("#3552a0")), new Stop(0.0909, Color.web("#456acf")), new Stop(0.27272, Color.web("#45a1cf")), new Stop(0.36363, Color.web("#30c8c9")), new Stop(0.45454, Color.web("#30c9af")), new Stop(0.50909, Color.web("#56d483")), new Stop(0.72727, Color.web("#9adb49")), new Stop(0.81818, Color.web("#efd750")), new Stop(0.90909, Color.web("#ef9850")), new Stop(1.0, Color.web("#ef6050")))).text("Test")).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4, this.chartData5, this.chartData6, this.chartData7, this.chartData8)).tooltipText("")).animated(true)).build();
        this.radarChartTile2 = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.RADAR_CHART)).prefSize(150.0, 150.0)).minValue(0.0)).maxValue(50.0)).title("RadarChartTileSkin Polygon")).unit("Unit")).radarChartMode(RadarChartMode.POLYGON)).gradientStops(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0E-5, Color.web("#3552a0")), new Stop(0.0909, Color.web("#456acf")), new Stop(0.27272, Color.web("#45a1cf")), new Stop(0.36363, Color.web("#30c8c9")), new Stop(0.45454, Color.web("#30c9af")), new Stop(0.50909, Color.web("#56d483")), new Stop(0.72727, Color.web("#9adb49")), new Stop(0.81818, Color.web("#efd750")), new Stop(0.90909, Color.web("#ef9850")), new Stop(1.0, Color.web("#ef6050")))).text("Test")).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4, this.chartData5, this.chartData6, this.chartData7, this.chartData8)).tooltipText("")).animated(true)).build();
        this.smoothAreaChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SMOOTH_AREA_CHART)).prefSize(150.0, 150.0)).minValue(0.0)).maxValue(40.0)).title("SmoothAreaChart Tile")).unit("Unit")).text("Test")).chartData(this.smoothChartData1, this.smoothChartData2, this.smoothChartData3, this.smoothChartData4)).tooltipText("")).animated(true)).build();
        this.firstRank = new Rank(Ranking.FIRST, Tile.YELLOW_ORANGE);
        this.countryTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.COUNTRY)).prefSize(150.0, 150.0)).minValue(0.0)).maxValue(40.0)).title("Country Tile")).unit("Unit")).country(Country.DE)).tooltipText("")).animated(true)).build();
        this.characterTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CHARACTER)).prefSize(150.0, 150.0)).title("Character Tile")).titleAlignment(TextAlignment.CENTER)).description("G")).build();
        this.flipTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.FLIP)).prefSize(150.0, 150.0)).characters(Helper.TIME_0_TO_5)).flipTimeInMS(500L)).flipText(" ")).build();
        this.switchSliderTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SWITCH_SLIDER)).prefSize(150.0, 150.0)).title("SwitchSlider Tile")).text("Test")).build();
        this.dateTile = ((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.DATE)).prefSize(150.0, 150.0)).build();
        ZonedDateTime now = ZonedDateTime.now();
        ArrayList<ChartData> calendarData = new ArrayList<ChartData>(10);
        calendarData.add(new ChartData("Item 1", now.minusDays(1L).toInstant()));
        calendarData.add(new ChartData("Item 2", now.plusDays(2L).toInstant()));
        calendarData.add(new ChartData("Item 3", now.plusDays(10L).toInstant()));
        calendarData.add(new ChartData("Item 4", now.plusDays(15L).toInstant()));
        calendarData.add(new ChartData("Item 5", now.plusDays(15L).toInstant()));
        calendarData.add(new ChartData("Item 6", now.plusDays(20L).toInstant()));
        calendarData.add(new ChartData("Item 7", now.plusDays(7L).toInstant()));
        calendarData.add(new ChartData("Item 8", now.minusDays(1L).toInstant()));
        calendarData.add(new ChartData("Item 9", now.toInstant()));
        calendarData.add(new ChartData("Item 10", now.toInstant()));
        this.calendarTile = ((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CALENDAR)).prefSize(150.0, 150.0)).chartData(calendarData)).build();
        TreeNode<ChartData> tree = new TreeNode<ChartData>(new ChartData("ROOT"));
        TreeNode<ChartData> first = new TreeNode<ChartData>(new ChartData("1st", 8.3, Tile.BLUE), tree);
        TreeNode<ChartData> second = new TreeNode<ChartData>(new ChartData("2nd", 2.2, Tile.ORANGE), tree);
        TreeNode<ChartData> third = new TreeNode<ChartData>(new ChartData("3rd", 1.4, Tile.PINK), tree);
        TreeNode<ChartData> fourth = new TreeNode<ChartData>(new ChartData("4th", 1.2, Tile.LIGHT_GREEN), tree);
        TreeNode<ChartData> jan = new TreeNode<ChartData>(new ChartData("Jan", 3.5), first);
        TreeNode<ChartData> feb = new TreeNode<ChartData>(new ChartData("Feb", 3.1), first);
        TreeNode<ChartData> mar = new TreeNode<ChartData>(new ChartData("Mar", 1.7), first);
        TreeNode<ChartData> apr = new TreeNode<ChartData>(new ChartData("Apr", 1.1), second);
        TreeNode<ChartData> may = new TreeNode<ChartData>(new ChartData("May", 0.8), second);
        TreeNode<ChartData> jun = new TreeNode<ChartData>(new ChartData("Jun", 0.3), second);
        TreeNode<ChartData> jul = new TreeNode<ChartData>(new ChartData("Jul", 0.7), third);
        TreeNode<ChartData> aug = new TreeNode<ChartData>(new ChartData("Aug", 0.6), third);
        TreeNode<ChartData> sep = new TreeNode<ChartData>(new ChartData("Sep", 0.1), third);
        TreeNode<ChartData> oct = new TreeNode<ChartData>(new ChartData("Oct", 0.5), fourth);
        TreeNode<ChartData> nov = new TreeNode<ChartData>(new ChartData("Nov", 0.4), fourth);
        TreeNode<ChartData> dec = new TreeNode<ChartData>(new ChartData("Dec", 0.3), fourth);
        this.sunburstTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.SUNBURST)).prefSize(150.0, 150.0)).title("Sunburst Tile")).textVisible(false)).sunburstTree(tree)).sunburstBackgroundColor(Tile.BACKGROUND)).sunburstTextColor(Tile.BACKGROUND)).sunburstUseColorFromParent(true)).sunburstTextOrientation(SunburstChart.TextOrientation.TANGENT)).sunburstAutoTextColor(true)).sunburstUseChartDataTextColor(true)).sunburstInteractive(true)).build();
        this.matrixTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.MATRIX)).prefSize(150.0, 150.0)).title("Matrix Tile")).text("Any Text")).textVisible(false)).animated(true)).matrixSize(8, 50)).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4, this.chartData5, this.chartData6, this.chartData7, this.chartData8)).build();
        this.radialPercentageTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.RADIAL_PERCENTAGE)).prefSize(150.0, 150.0)).maxValue(1000.0)).title("RadialPercentage Tile")).description("Product 1")).textVisible(false)).chartData(this.chartData1, this.chartData2, this.chartData3)).animated(true)).referenceValue(100.0)).value(this.chartData1.getValue())).descriptionColor(Tile.GRAY)).barColor(Tile.BLUE)).decimals(0)).build();
        Indicator leftGraphics = new Indicator(Tile.RED);
        leftGraphics.setOn(true);
        Indicator middleGraphics = new Indicator(Tile.YELLOW);
        middleGraphics.setOn(true);
        Indicator rightGraphics = new Indicator(Tile.GREEN);
        rightGraphics.setOn(true);
        this.statusTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.STATUS)).prefSize(150.0, 150.0)).title("Status Tile")).description("Notifications")).leftText("CRITICAL")).middleText("WARNING")).rightText("INFORMATION")).leftGraphics(leftGraphics)).middleGraphics(middleGraphics)).rightGraphics(rightGraphics)).text("Text")).build();
        this.barGaugeTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.BAR_GAUGE)).prefSize(150.0, 150.0)).minValue(0.0)).maxValue(100.0)).startFromZero(true)).threshold(80.0)).thresholdVisible(true)).title("BarGauge Tile")).unit("F")).text("Whatever text")).gradientStops(new Stop(0.0, Bright.BLUE), new Stop(0.1, Bright.BLUE_GREEN), new Stop(0.2, Bright.GREEN), new Stop(0.3, Bright.GREEN_YELLOW), new Stop(0.4, Bright.YELLOW), new Stop(0.5, Bright.YELLOW_ORANGE), new Stop(0.6, Bright.ORANGE), new Stop(0.7, Bright.ORANGE_RED), new Stop(0.8, Bright.RED), new Stop(1.0, Dark.RED))).strokeWithGradient(true)).animated(true)).build();
        this.imageTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.IMAGE)).prefSize(150.0, 150.0)).title("Image Tile")).image(new Image(Demo.class.getResourceAsStream("HanSolo.png")))).imageMask(Tile.ImageMask.ROUND)).text("Whatever text")).textAlignment(TextAlignment.CENTER)).build();
        this.timelineTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TIMELINE)).prefSize(150.0, 150.0)).title("Timeline Tile")).unit("mg/dl")).minValue(0.0)).maxValue(350.0)).smoothing(true)).lowerThreshold(70.0)).lowerThresholdColor(Tile.TileColor.RED.color)).threshold(240.0)).thresholdColor(Tile.TileColor.RED.color)).thresholdVisible(true)).tickLabelColor(Helper.getColorWithOpacity(Tile.FOREGROUND, 0.5))).sections(new Section(0.0, 70.0, "Low", Helper.getColorWithOpacity(Dark.RED, 0.1)), new Section(70.0, 140.0, "Ok", Helper.getColorWithOpacity(Bright.GREEN, 0.15)), new Section(140.0, 350.0, "High", Helper.getColorWithOpacity(Dark.RED, 0.1)))).highlightSections(true)).sectionsVisible(true)).textAlignment(TextAlignment.CENTER)).timePeriod(Duration.ofMinutes(1L))).maxTimePeriod(Duration.ofMinutes(1L))).timePeriodResolution(TimeUnit.SECONDS)).numberOfValuesForTrendCalculation(5)).trendVisible(true)).maxTimePeriod(Duration.ofSeconds(60L))).gradientStops(new Stop(0.0, Dark.RED), new Stop(0.15, Dark.RED), new Stop(0.2, Bright.YELLOW_ORANGE), new Stop(0.25, Bright.GREEN), new Stop(0.3, Bright.GREEN), new Stop(0.35, Bright.GREEN), new Stop(0.45, Bright.YELLOW_ORANGE), new Stop(0.5, Bright.ORANGE), new Stop(0.685, Dark.RED), new Stop(1.0, Dark.RED))).strokeWithGradient(true)).averageVisible(true)).averagingPeriod(60)).timeoutMs(60000L)).build();
        this.imageCounterTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.IMAGE_COUNTER)).prefSize(150.0, 150.0)).title("ImageCounter Tile")).text("Whatever text")).description("Whatever\nnumbers")).image(new Image(Demo.class.getResourceAsStream("HanSolo.png")))).imageMask(Tile.ImageMask.ROUND)).build();
        this.ledTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.LED)).prefSize(150.0, 150.0)).title("Led Tile")).description("Description")).text("Whatever text")).build();
        this.countdownTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.COUNTDOWN_TIMER)).prefSize(150.0, 150.0)).title("CountdownTimer Tile")).description("Description")).text("Text")).barColor(Bright.ORANGE_RED)).timePeriod(Duration.ofSeconds(30L))).onAlarm(e -> System.out.println("Alarm"))).build();
        MatrixIcon matrixIcon1 = new MatrixIcon();
        matrixIcon1.fillPixels(2, 5, 1, Color.BLACK);
        matrixIcon1.setPixelAt(1, 2, Color.BLACK);
        matrixIcon1.fillPixels(2, 5, 2, Color.WHITE);
        matrixIcon1.setPixelAt(6, 2, Color.BLACK);
        matrixIcon1.setPixelAt(0, 3, Color.BLACK);
        matrixIcon1.fillPixels(1, 2, 3, Color.WHITE);
        matrixIcon1.fillPixels(3, 4, 3, Color.web("#4d79ff"));
        matrixIcon1.fillPixels(5, 6, 3, Color.WHITE);
        matrixIcon1.setPixelAt(7, 3, Color.BLACK);
        matrixIcon1.setPixelAt(0, 4, Color.BLACK);
        matrixIcon1.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon1.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon1.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon1.setPixelAt(7, 4, Color.BLACK);
        matrixIcon1.setPixelAt(1, 5, Color.BLACK);
        matrixIcon1.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon1.setPixelAt(6, 5, Color.BLACK);
        matrixIcon1.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon2 = new MatrixIcon();
        matrixIcon2.fillPixels(1, 6, 2, Color.BLACK);
        matrixIcon2.setPixelAt(0, 3, Color.BLACK);
        matrixIcon2.fillPixels(1, 2, 3, Color.WHITE);
        matrixIcon2.fillPixels(3, 4, 3, Color.web("#4d79ff"));
        matrixIcon2.fillPixels(5, 6, 3, Color.WHITE);
        matrixIcon2.setPixelAt(7, 3, Color.BLACK);
        matrixIcon2.setPixelAt(0, 4, Color.BLACK);
        matrixIcon2.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon2.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon2.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon2.setPixelAt(7, 4, Color.BLACK);
        matrixIcon2.setPixelAt(1, 5, Color.BLACK);
        matrixIcon2.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon2.setPixelAt(6, 5, Color.BLACK);
        matrixIcon2.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon3 = new MatrixIcon();
        matrixIcon3.fillPixels(0, 7, 3, Color.BLACK);
        matrixIcon3.setPixelAt(0, 4, Color.BLACK);
        matrixIcon3.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon3.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon3.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon3.setPixelAt(7, 4, Color.BLACK);
        matrixIcon3.setPixelAt(1, 5, Color.BLACK);
        matrixIcon3.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon3.setPixelAt(6, 5, Color.BLACK);
        matrixIcon3.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon4 = new MatrixIcon();
        matrixIcon4.setPixelAt(0, 3, Color.BLACK);
        matrixIcon4.setPixelAt(7, 3, Color.BLACK);
        matrixIcon4.fillPixels(0, 7, 4, Color.BLACK);
        matrixIcon4.setPixelAt(1, 5, Color.BLACK);
        matrixIcon4.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon4.setPixelAt(6, 5, Color.BLACK);
        matrixIcon4.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon5 = new MatrixIcon();
        matrixIcon5.setPixelAt(0, 3, Color.BLACK);
        matrixIcon5.setPixelAt(7, 3, Color.BLACK);
        matrixIcon5.setPixelAt(0, 4, Color.BLACK);
        matrixIcon5.setPixelAt(7, 4, Color.BLACK);
        matrixIcon5.setPixelAt(1, 5, Color.BLACK);
        matrixIcon5.fillPixels(2, 5, 5, Color.BLACK);
        matrixIcon5.setPixelAt(6, 5, Color.BLACK);
        matrixIcon5.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon6 = new MatrixIcon();
        matrixIcon6.setPixelAt(0, 3, Color.BLACK);
        matrixIcon6.setPixelAt(7, 3, Color.BLACK);
        matrixIcon6.fillPixels(0, 7, 4, Color.BLACK);
        matrixIcon6.setPixelAt(1, 5, Color.BLACK);
        matrixIcon6.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon6.setPixelAt(6, 5, Color.BLACK);
        matrixIcon6.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon7 = new MatrixIcon();
        matrixIcon7.fillPixels(0, 7, 3, Color.BLACK);
        matrixIcon7.setPixelAt(0, 4, Color.BLACK);
        matrixIcon7.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon7.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon7.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon7.setPixelAt(7, 4, Color.BLACK);
        matrixIcon7.setPixelAt(1, 5, Color.BLACK);
        matrixIcon7.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon7.setPixelAt(6, 5, Color.BLACK);
        matrixIcon7.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon8 = new MatrixIcon();
        matrixIcon8.fillPixels(1, 6, 2, Color.BLACK);
        matrixIcon8.setPixelAt(0, 3, Color.BLACK);
        matrixIcon8.fillPixels(1, 2, 3, Color.WHITE);
        matrixIcon8.fillPixels(3, 4, 3, Color.web("#4d79ff"));
        matrixIcon8.fillPixels(5, 6, 3, Color.WHITE);
        matrixIcon8.setPixelAt(7, 3, Color.BLACK);
        matrixIcon8.setPixelAt(0, 4, Color.BLACK);
        matrixIcon8.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon8.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon8.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon8.setPixelAt(7, 4, Color.BLACK);
        matrixIcon8.setPixelAt(1, 5, Color.BLACK);
        matrixIcon8.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon8.setPixelAt(6, 5, Color.BLACK);
        matrixIcon8.fillPixels(2, 5, 6, Color.BLACK);
        MatrixIcon matrixIcon9 = new MatrixIcon();
        matrixIcon9.fillPixels(2, 5, 1, Color.BLACK);
        matrixIcon9.setPixelAt(1, 2, Color.BLACK);
        matrixIcon9.fillPixels(2, 5, 2, Color.WHITE);
        matrixIcon9.setPixelAt(6, 2, Color.BLACK);
        matrixIcon9.setPixelAt(0, 3, Color.BLACK);
        matrixIcon9.fillPixels(1, 2, 3, Color.WHITE);
        matrixIcon9.fillPixels(3, 4, 3, Color.web("#4d79ff"));
        matrixIcon9.fillPixels(5, 6, 3, Color.WHITE);
        matrixIcon9.setPixelAt(7, 3, Color.BLACK);
        matrixIcon9.setPixelAt(0, 4, Color.BLACK);
        matrixIcon9.fillPixels(1, 2, 4, Color.WHITE);
        matrixIcon9.fillPixels(3, 4, 4, Color.web("#4d79ff"));
        matrixIcon9.fillPixels(5, 6, 4, Color.WHITE);
        matrixIcon9.setPixelAt(7, 4, Color.BLACK);
        matrixIcon9.setPixelAt(1, 5, Color.BLACK);
        matrixIcon9.fillPixels(2, 5, 5, Color.WHITE);
        matrixIcon9.setPixelAt(6, 5, Color.BLACK);
        matrixIcon9.fillPixels(2, 5, 6, Color.BLACK);
        this.matrixIconTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.MATRIX_ICON)).prefSize(150.0, 150.0)).title("MatrixIcon Tile")).matrixIcons(matrixIcon1, matrixIcon2, matrixIcon3, matrixIcon4, matrixIcon5, matrixIcon6, matrixIcon7, matrixIcon8, matrixIcon9)).animationDuration(50L)).animated(true)).build();
        this.cycleStepTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CYCLE_STEP)).prefSize(150.0, 150.0)).title("CycleStep Tile")).textVisible(false)).chartData(this.chartData1, this.chartData2, this.chartData3, this.chartData4, this.chartData5)).animated(true)).decimals(1)).build();
        Label name = new Label("Name");
        name.setTextFill(Tile.FOREGROUND);
        name.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow(name, Priority.NEVER);
        Region spacer = new Region();
        spacer.setPrefSize(5.0, 5.0);
        HBox.setHgrow(spacer, Priority.ALWAYS);
        Label views = new Label("Cases / Deaths");
        views.setTextFill(Tile.FOREGROUND);
        views.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(views, Priority.NEVER);
        HBox header = new HBox(5.0, name, spacer, views);
        header.setAlignment(Pos.CENTER_LEFT);
        header.setFillHeight(true);
        HBox usa = this.getCountryItem(Flag.UNITED_STATES_OF_AMERICA, "USA", "1.618.757 / 96.909");
        HBox brazil = this.getCountryItem(Flag.BRAZIL, "Brazil", "363.211 / 22.666");
        HBox uk = this.getCountryItem(Flag.UNITED_KINGDOM, "UK", "259.563 / 36.793");
        HBox spain = this.getCountryItem(Flag.SPAIN, "Spain", "235.772 / 28.752");
        HBox italy = this.getCountryItem(Flag.ITALY, "Italy", "229.585 / 32.785");
        HBox germany = this.getCountryItem(Flag.GERMANY, "Germany", "178.570 / 8.257");
        HBox france = this.getCountryItem(Flag.FRANCE, "France", "142.204 / 28.315");
        VBox dataTable = new VBox(0.0, header, usa, brazil, uk, spain, italy, germany, france);
        dataTable.setFillWidth(true);
        this.customFlagChartTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CUSTOM)).title("Custom Tile Covid-19")).text("Data from 26.05.2020")).graphic(dataTable)).build();
        this.colorTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.COLOR)).prefSize(150.0, 150.0)).title("Color Tile")).description("Whatever")).animated(false)).build();
        this.turnoverTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.TURNOVER)).prefSize(150.0, 150.0)).title("Turnover Tile")).text("Gerrit Grunwald")).decimals(0)).unit("$")).image(new Image(Demo.class.getResourceAsStream("HanSolo.png")))).animated(true)).checkThreshold(true)).onTileEvent(e -> {
            if (TileEvent.EventType.THRESHOLD_EXCEEDED == e.getEventType()) {
                this.turnoverTile.setRank(this.firstRank);
                this.turnoverTile.setValueColor(this.firstRank.getColor());
                this.turnoverTile.setUnitColor(this.firstRank.getColor());
            } else if (TileEvent.EventType.THRESHOLD_UNDERRUN == e.getEventType()) {
                this.turnoverTile.setRank(Rank.DEFAULT);
                this.turnoverTile.setValueColor(Tile.FOREGROUND);
                this.turnoverTile.setUnitColor(Tile.FOREGROUND);
            }
        })).threshold(70.0)).build();
        this.fluidTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.FLUID)).prefSize(150.0, 150.0)).title("Fluid Tile")).text("Waterlevel")).unit("%")).decimals(0)).barColor(Tile.BLUE)).animated(true)).build();
        this.fireSmokeTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.FIRE_SMOKE)).prefSize(150.0, 150.0)).title("FireSmoke Tile")).text("CPU temp")).unit("\u00b0C")).threshold(40.0)).decimals(0)).animated(true)).build();
        this.gauge2Tile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.GAUGE2)).prefSize(150.0, 150.0)).title("Gauge2 Tile")).text("Whatever")).unit("Unit")).textVisible(true)).value(0.0)).gradientStops(new Stop(0.0, Tile.BLUE), new Stop(0.25, Tile.GREEN), new Stop(0.5, Tile.YELLOW), new Stop(0.75, Tile.ORANGE), new Stop(1.0, Tile.RED))).strokeWithGradient(true)).animated(true)).build();
        HappinessIndicator happy = new HappinessIndicator(HappinessIndicator.Happiness.HAPPY, 0.67);
        HappinessIndicator neutral = new HappinessIndicator(HappinessIndicator.Happiness.NEUTRAL, 0.25);
        HappinessIndicator unhappy = new HappinessIndicator(HappinessIndicator.Happiness.UNHAPPY, 0.08);
        HBox happiness = new HBox(unhappy, neutral, happy);
        happiness.setFillHeight(true);
        HBox.setHgrow(happy, Priority.ALWAYS);
        HBox.setHgrow(neutral, Priority.ALWAYS);
        HBox.setHgrow(unhappy, Priority.ALWAYS);
        this.happinessTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.CUSTOM)).prefSize(150.0, 150.0)).title("Custom Tile Happiness")).text("Whatever")).textVisible(true)).graphic(happiness)).value(0.0)).animated(true)).build();
        ArrayList<ChartData> glucoseData = new ArrayList<ChartData>();
        for (int i = 0; i < 288; ++i) {
            glucoseData.add(new ChartData("", RND.nextDouble() * 300.0 + 50.0));
        }
        this.radialDistributionTile = ((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)((TileBuilder)TileBuilder.create().skinType(Tile.SkinType.RADIAL_DISTRIBUTION)).title("RadialDistribution Tile")).text("Whatever")).description("Description")).minValue(0.0)).maxValue(400.0)).lowerThreshold(70.0)).threshold(140.0)).tickLabelDecimals(0)).decimals(0)).chartData(glucoseData)).barColor(Color.rgb(254, 1, 154))).gradientStops(new Stop(0.0, Helper.getColorWithOpacity(Color.RED, 0.1)), new Stop(0.1375, Helper.getColorWithOpacity(Color.RED, 0.1)), new Stop(0.15625, Helper.getColorWithOpacity(Color.web("#FA711F"), 0.1)), new Stop(0.175, Helper.getColorWithOpacity(ColorSkin.GREEN, 0.1)), new Stop(0.2625, Helper.getColorWithOpacity(ColorSkin.GREEN, 0.1)), new Stop(0.35, Helper.getColorWithOpacity(ColorSkin.GREEN, 0.1)), new Stop(0.3501, Helper.getColorWithOpacity(ColorSkin.YELLOW, 0.1)), new Stop(0.45, Helper.getColorWithOpacity(Color.web("#FA711F"), 0.1)), new Stop(0.6625, Helper.getColorWithOpacity(Color.web("#FA711F"), 0.1)), new Stop(0.875, Helper.getColorWithOpacity(Color.RED, 0.1)), new Stop(1.0, Helper.getColorWithOpacity(Color.RED, 0.1)))).strokeWithGradient(true)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                if (now > Demo.this.lastTimerCall + 3500000000L) {
                    Demo.this.percentageTile.setValue(RND.nextDouble() * Demo.this.percentageTile.getRange() * 1.5 + Demo.this.percentageTile.getMinValue());
                    Demo.this.gaugeTile.setValue(RND.nextDouble() * Demo.this.gaugeTile.getRange() * 1.5 + Demo.this.gaugeTile.getMinValue());
                    Demo.this.gauge2Tile.setValue(RND.nextDouble() * Demo.this.gaugeTile.getRange() + Demo.this.gaugeTile.getMinValue());
                    Demo.this.sparkLineTile.setValue(RND.nextDouble() * Demo.this.sparkLineTile.getRange() * 1.5 + Demo.this.sparkLineTile.getMinValue());
                    Demo.this.highLowTile.setValue(RND.nextDouble() * 10.0);
                    series1.getData().forEach(data -> data.setYValue(RND.nextInt(100)));
                    series2.getData().forEach(data -> data.setYValue(RND.nextInt(30)));
                    series3.getData().forEach(data -> data.setYValue(RND.nextInt(10)));
                    Demo.this.chartData1.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData2.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData3.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData4.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData5.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData6.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData7.setValue(RND.nextDouble() * 50.0);
                    Demo.this.chartData8.setValue(RND.nextDouble() * 50.0);
                    ((BarChartItem)Demo.this.barChartTile.getBarChartItems().get(RND.nextInt(3))).setValue(RND.nextDouble() * 80.0);
                    ((LeaderBoardItem)Demo.this.leaderBoardTile.getLeaderBoardItems().get(RND.nextInt(3))).setValue(RND.nextDouble() * 80.0);
                    Demo.this.circularProgressTile.setValue(RND.nextDouble() * 120.0);
                    Demo.this.stockTile.setValue(RND.nextDouble() * 50.0 + 500.0);
                    Demo.this.gaugeSparkLineTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.countryTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.smoothChartData1.setValue(Demo.this.smoothChartData2.getValue());
                    Demo.this.smoothChartData2.setValue(Demo.this.smoothChartData3.getValue());
                    Demo.this.smoothChartData3.setValue(Demo.this.smoothChartData4.getValue());
                    Demo.this.smoothChartData4.setValue(RND.nextDouble() * 25.0);
                    Demo.this.characterTile.setDescription(Helper.ALPHANUMERIC[RND.nextInt(Helper.ALPHANUMERIC.length - 1)]);
                    Demo.this.flipTile.setFlipText(Helper.TIME_0_TO_5[RND.nextInt(Helper.TIME_0_TO_5.length - 1)]);
                    Demo.this.radialPercentageTile.setValue(Demo.this.chartData1.getValue());
                    if (Demo.this.statusTile.getLeftValue() > 1000.0) {
                        Demo.this.statusTile.setLeftValue(0.0);
                    }
                    if (Demo.this.statusTile.getMiddleValue() > 1000.0) {
                        Demo.this.statusTile.setMiddleValue(0.0);
                    }
                    if (Demo.this.statusTile.getRightValue() > 1000.0) {
                        Demo.this.statusTile.setRightValue(0.0);
                    }
                    Demo.this.statusTile.setLeftValue(Demo.this.statusTile.getLeftValue() + (double)RND.nextInt(4));
                    Demo.this.statusTile.setMiddleValue(Demo.this.statusTile.getMiddleValue() + (double)RND.nextInt(3));
                    Demo.this.statusTile.setRightValue(Demo.this.statusTile.getRightValue() + (double)RND.nextInt(3));
                    Demo.this.barGaugeTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.timelineTile.addChartData(new ChartData("", RND.nextDouble() * 300.0 + 50.0, Instant.now()));
                    Demo.this.imageCounterTile.increaseValue(1.0);
                    Demo.this.ledTile.setActive(!Demo.this.ledTile.isActive());
                    if (!Demo.this.countdownTile.isRunning()) {
                        Demo.this.countdownTile.setTimePeriod(Duration.ofSeconds(30L));
                        Demo.this.countdownTile.setRunning(true);
                    }
                    Demo.this.colorTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.turnoverTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.fluidTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.fireSmokeTile.setValue(RND.nextDouble() * 100.0);
                    Demo.this.lastTimerCall = now;
                }
            }
        };
        System.out.println("Initialization: " + (System.currentTimeMillis() - start) + "ms");
    }

    @Override
    public void start(Stage stage) {
        long start = System.currentTimeMillis();
        FlowGridPane pane = new FlowGridPane(8, 6, this.percentageTile, this.clockTile, this.gaugeTile, this.sparkLineTile, this.areaChartTile, this.lineChartTile, this.timerControlTile, this.numberTile, this.textTile, this.highLowTile, this.plusMinusTile, this.sliderTile, this.switchTile, this.timeTile, this.barChartTile, this.customTile, this.leaderBoardTile, this.worldTile, this.mapTile, this.radialChartTile, this.donutChartTile, this.circularProgressTile, this.stockTile, this.gaugeSparkLineTile, this.radarChartTile1, this.radarChartTile2, this.smoothAreaChartTile, this.countryTile, this.characterTile, this.flipTile, this.switchSliderTile, this.dateTile, this.calendarTile, this.sunburstTile, this.matrixTile, this.radialPercentageTile, this.statusTile, this.barGaugeTile, this.imageTile, this.timelineTile, this.imageCounterTile, this.ledTile, this.countdownTile, this.matrixIconTile, this.cycleStepTile, this.customFlagChartTile, this.colorTile, this.turnoverTile, this.fluidTile, this.fireSmokeTile, this.gauge2Tile, this.happinessTile, this.radialDistributionTile);
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        pane.setAlignment(Pos.CENTER);
        pane.setCenterShape(true);
        pane.setPadding(new Insets(5.0));
        pane.setBackground(new Background(new BackgroundFill(Color.web("#101214"), CornerRadii.EMPTY, Insets.EMPTY)));
        PerspectiveCamera camera = new PerspectiveCamera();
        camera.setFieldOfView(10.0);
        Scene scene = new Scene(pane);
        scene.setCamera(camera);
        stage.setTitle("TilesFX");
        stage.setScene(scene);
        stage.show();
        System.out.println("Rendering     : " + (System.currentTimeMillis() - start) + "ms");
        this.calcNoOfNodes(pane);
        System.out.println("Nodes in Scene: " + this.noOfNodes);
        this.timer.start();
        this.mapTile.addPoiLocation(new Location(51.85, 7.75, "Test"));
        this.mapTile.removePoiLocation(new Location(51.85, 7.75, "Test"));
        this.radialPercentageTile.setNotifyRegionTooltipText("tooltip");
        this.radialPercentageTile.showNotifyRegion(true);
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.clockTile.setRunning(false);
        this.timerControlTile.setRunning(false);
        System.exit(0);
    }

    private HBox getCountryItem(Flag flag, String text, String data) {
        ImageView imageView = new ImageView(flag.getImage(22.0));
        HBox.setHgrow(imageView, Priority.NEVER);
        Label name = new Label(text);
        name.setTextFill(Tile.FOREGROUND);
        name.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow(name, Priority.NEVER);
        Region spacer = new Region();
        spacer.setPrefSize(5.0, 5.0);
        HBox.setHgrow(spacer, Priority.ALWAYS);
        Label views = new Label(data);
        views.setTextFill(Tile.FOREGROUND);
        views.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow(views, Priority.NEVER);
        HBox hBox = new HBox(5.0, imageView, name, spacer, views);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setFillHeight(true);
        return hBox;
    }

    private void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList<Node> tempChildren = ((Parent)node).getChildrenUnmodifiable();
            this.noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                this.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args2) {
        Demo.launch(args2);
    }
}

