/* Utils.c generated by valac 0.56.0, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann, Rico Tzschichholz
 * Copyright 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <meta/display.h>
#include <meta/meta-window-actor.h>
#include <meta/boxes.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <meta/meta-shaped-texture.h>
#include <float.h>
#include <math.h>
#include <meta/prefs.h>
#include <gdk/gdk.h>
#include <meta/compositor.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_UTILS (greeter_compositor_utils_get_type ())
#define GREETER_COMPOSITOR_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtils))
#define GREETER_COMPOSITOR_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtilsClass))
#define GREETER_COMPOSITOR_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_UTILS))
#define GREETER_COMPOSITOR_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_UTILS))
#define GREETER_COMPOSITOR_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtilsClass))

typedef struct _GreeterCompositorUtils GreeterCompositorUtils;
typedef struct _GreeterCompositorUtilsClass GreeterCompositorUtilsClass;
typedef struct _GreeterCompositorUtilsPrivate GreeterCompositorUtilsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GreeterCompositorParamSpecUtils GreeterCompositorParamSpecUtils;

struct _GreeterCompositorUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GreeterCompositorUtilsPrivate * priv;
};

struct _GreeterCompositorUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (GreeterCompositorUtils *self);
};

struct _Block2Data {
	int _ref_count_;
	guint32* xids;
	gint xids_length1;
};

struct _Block3Data {
	int _ref_count_;
	cairo_surface_t* surface;
};

struct _GreeterCompositorParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer greeter_compositor_utils_parent_class = NULL;
static GHashTable* greeter_compositor_utils_xid_pixbuf_cache;
static GHashTable* greeter_compositor_utils_xid_pixbuf_cache = NULL;
static GHashTable* greeter_compositor_utils_icon_pixbuf_cache;
static GHashTable* greeter_compositor_utils_icon_pixbuf_cache = NULL;
static guint greeter_compositor_utils_cache_clear_timeout;
static guint greeter_compositor_utils_cache_clear_timeout = (guint) 0;

VALA_EXTERN gpointer greeter_compositor_utils_ref (gpointer instance);
VALA_EXTERN void greeter_compositor_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* greeter_compositor_param_spec_utils (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void greeter_compositor_value_set_utils (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void greeter_compositor_value_take_utils (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer greeter_compositor_value_get_utils (const GValue* value);
VALA_EXTERN GType greeter_compositor_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorUtils, greeter_compositor_utils_unref)
static GreeterCompositorUtils* greeter_compositor_utils_new (void);
static GreeterCompositorUtils* greeter_compositor_utils_construct (GType object_type);
static void greeter_compositor_utils_clean_icon_cache (guint32* xids,
                                                gint xids_length1);
static gboolean _vala_uint32_array_contains (guint32 * stack,
                                      gssize stack_length,
                                      const guint32 needle);
VALA_EXTERN void greeter_compositor_utils_request_clean_icon_cache (guint32* xids,
                                                        gint xids_length1);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda32_ (Block2Data* _data2_);
static gboolean __lambda33_ (Block2Data* _data2_);
static gboolean ___lambda33__gsource_func (gpointer self);
static gboolean ___lambda32__gsource_func (gpointer self);
VALA_EXTERN MetaWindow* greeter_compositor_utils_get_next_window (MetaWorkspace* workspace,
                                                      gboolean backward);
VALA_EXTERN guint greeter_compositor_utils_get_n_windows (MetaWorkspace* workspace);
VALA_EXTERN ClutterActor* greeter_compositor_utils_get_window_actor_snapshot (MetaWindowActor* actor,
                                                                  MetaRectangle* inner_rect,
                                                                  MetaRectangle* outer_rect);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda34_ (Block3Data* _data3_,
                      cairo_t* cr);
static gboolean ___lambda34__clutter_canvas_draw (ClutterCanvas* _sender,
                                           cairo_t* cr,
                                           gint width,
                                           gint height,
                                           gpointer self);
VALA_EXTERN void greeter_compositor_utils_bell (MetaDisplay* display);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void greeter_compositor_utils_finalize (GreeterCompositorUtils * obj);
static GType greeter_compositor_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GreeterCompositorUtils*
greeter_compositor_utils_construct (GType object_type)
{
	GreeterCompositorUtils* self = NULL;
	self = (GreeterCompositorUtils*) g_type_create_instance (object_type);
	return self;
}

static GreeterCompositorUtils*
greeter_compositor_utils_new (void)
{
	return greeter_compositor_utils_construct (GREETER_COMPOSITOR_TYPE_UTILS);
}

/**
         * Clean icon caches
         */
static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gboolean
_vala_uint32_array_contains (guint32 * stack,
                             gssize stack_length,
                             const guint32 needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_utils_clean_icon_cache (guint32* xids,
                                           gint xids_length1)
{
	GList* list = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* pixbuf_list = NULL;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GList* icon_list = NULL;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	_tmp0_ = greeter_compositor_utils_xid_pixbuf_cache;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	list = _tmp1_;
	_tmp2_ = greeter_compositor_utils_icon_pixbuf_cache;
	_tmp3_ = g_hash_table_get_values (_tmp2_);
	pixbuf_list = _tmp3_;
	_tmp4_ = greeter_compositor_utils_icon_pixbuf_cache;
	_tmp5_ = g_hash_table_get_keys (_tmp4_);
	icon_list = _tmp5_;
	_tmp6_ = list;
	{
		GList* xid_key_collection = NULL;
		GList* xid_key_it = NULL;
		xid_key_collection = _tmp6_;
		for (xid_key_it = xid_key_collection; xid_key_it != NULL; xid_key_it = xid_key_it->next) {
			const gchar* xid_key = NULL;
			xid_key = (const gchar*) xid_key_it->data;
			{
				guint32 xid = 0U;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				guint32 _tmp12_;
				_tmp7_ = xid_key;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "::", 0);
				_tmp10_ = _tmp9_;
				_tmp10__length1 = _vala_array_length (_tmp8_);
				_tmp11_ = _tmp10_[0];
				_tmp12_ = (guint32) uint64_parse (_tmp11_, (guint) 0);
				_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
				xid = _tmp12_;
				if (!_vala_uint32_array_contains (xids, xids_length1, xid)) {
					GdkPixbuf* pixbuf = NULL;
					GHashTable* _tmp13_;
					const gchar* _tmp14_;
					gconstpointer _tmp15_;
					GdkPixbuf* _tmp16_;
					GHashTable* _tmp26_;
					const gchar* _tmp27_;
					_tmp13_ = greeter_compositor_utils_xid_pixbuf_cache;
					_tmp14_ = xid_key;
					_tmp15_ = g_hash_table_lookup (_tmp13_, _tmp14_);
					_tmp16_ = _g_object_ref0 ((GdkPixbuf*) _tmp15_);
					pixbuf = _tmp16_;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp17_ = FALSE;
							_tmp17_ = TRUE;
							while (TRUE) {
								GList* _tmp19_;
								GList* _tmp20_;
								gconstpointer _tmp21_;
								GdkPixbuf* _tmp22_;
								if (!_tmp17_) {
									gint _tmp18_;
									_tmp18_ = j;
									j = _tmp18_ + 1;
								}
								_tmp17_ = FALSE;
								_tmp19_ = pixbuf_list;
								if (!(((guint) j) < g_list_length (_tmp19_))) {
									break;
								}
								_tmp20_ = pixbuf_list;
								_tmp21_ = g_list_nth_data (_tmp20_, (guint) j);
								_tmp22_ = pixbuf;
								if (((GdkPixbuf*) _tmp21_) == _tmp22_) {
									GHashTable* _tmp23_;
									GList* _tmp24_;
									gconstpointer _tmp25_;
									_tmp23_ = greeter_compositor_utils_xid_pixbuf_cache;
									_tmp24_ = icon_list;
									_tmp25_ = g_list_nth_data (_tmp24_, (guint) j);
									g_hash_table_remove (_tmp23_, (const gchar*) _tmp25_);
								}
							}
						}
					}
					_tmp26_ = greeter_compositor_utils_xid_pixbuf_cache;
					_tmp27_ = xid_key;
					g_hash_table_remove (_tmp26_, _tmp27_);
					_g_object_unref0 (pixbuf);
				}
			}
		}
	}
	(icon_list == NULL) ? NULL : (icon_list = (g_list_free (icon_list), NULL));
	(pixbuf_list == NULL) ? NULL : (pixbuf_list = (g_list_free (pixbuf_list), NULL));
	(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
}

/**
         * Marks the given xids as no longer needed, the corresponding icons
         * may be freed now. Mainly for internal purposes.
         *
         * @param xids The xids of the window that no longer need icons
         */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda33_ (Block2Data* _data2_)
{
	gboolean result;
	greeter_compositor_utils_clean_icon_cache (_data2_->xids, (gint) _data2_->xids_length1);
	result = FALSE;
	return result;
}

static gboolean
___lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda33_ (self);
	return result;
}

static gboolean
__lambda32_ (Block2Data* _data2_)
{
	gboolean result;
	greeter_compositor_utils_cache_clear_timeout = (guint) 0;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda33__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	result = FALSE;
	return result;
}

static gboolean
___lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda32_ (self);
	return result;
}

void
greeter_compositor_utils_request_clean_icon_cache (guint32* xids,
                                                   gint xids_length1)
{
	Block2Data* _data2_;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->xids = xids;
	_data2_->xids_length1 = xids_length1;
	if (greeter_compositor_utils_cache_clear_timeout > ((guint) 0)) {
		g_source_remove (greeter_compositor_utils_cache_clear_timeout);
	}
	greeter_compositor_utils_cache_clear_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda32__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
         * Get the next window that should be active on a workspace right now. Based on
         * stacking order
         *
         * @param workspace The workspace on which to find the window
         * @param backward  Whether to get the previous one instead
         */
MetaWindow*
greeter_compositor_utils_get_next_window (MetaWorkspace* workspace,
                                          gboolean backward)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWindow* window = NULL;
	MetaDisplay* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* result;
	g_return_val_if_fail (workspace != NULL, NULL);
	_tmp0_ = meta_workspace_get_display (workspace);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_tab_next (_tmp2_, META_TAB_LIST_NORMAL, workspace, NULL, backward);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	window = _tmp4_;
	_tmp5_ = window;
	if (_tmp5_ == NULL) {
		MetaDisplay* _tmp6_;
		MetaWindow* _tmp7_;
		MetaWindow* _tmp8_;
		_tmp6_ = display;
		_tmp7_ = meta_display_get_tab_current (_tmp6_, META_TAB_LIST_NORMAL, workspace);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (window);
		window = _tmp8_;
	}
	result = window;
	_g_object_unref0 (display);
	return result;
}

/**
         * Get the number of toplevel windows on a workspace excluding those that are
         * on all workspaces
         *
         * @param workspace The workspace on which to count the windows
         */
guint
greeter_compositor_utils_get_n_windows (MetaWorkspace* workspace)
{
	gint n = 0;
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (workspace != NULL, 0U);
	n = 0;
	_tmp0_ = meta_workspace_list_windows (workspace);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp1_;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				MetaWindow* _tmp4_;
				MetaWindowType _tmp5_;
				MetaWindowType _tmp6_;
				_tmp1_ = window;
				if (meta_window_is_on_all_workspaces (_tmp1_)) {
					continue;
				}
				_tmp4_ = window;
				_tmp5_ = meta_window_get_window_type (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == META_WINDOW_NORMAL) {
					_tmp3_ = TRUE;
				} else {
					MetaWindow* _tmp7_;
					MetaWindowType _tmp8_;
					MetaWindowType _tmp9_;
					_tmp7_ = window;
					_tmp8_ = meta_window_get_window_type (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = _tmp9_ == META_WINDOW_DIALOG;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					MetaWindow* _tmp10_;
					MetaWindowType _tmp11_;
					MetaWindowType _tmp12_;
					_tmp10_ = window;
					_tmp11_ = meta_window_get_window_type (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp2_ = _tmp12_ == META_WINDOW_MODAL_DIALOG;
				}
				if (_tmp2_) {
					gint _tmp13_;
					_tmp13_ = n;
					n = _tmp13_ + 1;
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	result = (guint) n;
	return result;
}

/**
         * Creates an actor showing the current contents of the given WindowActor.
         *
         * @param actor      The actor from which to create a shnapshot
         * @param inner_rect The inner (actually visible) rectangle of the window
         * @param outer_rect The outer (input region) rectangle of the window
         *
         * @return           A copy of the actor at that time or %NULL
         */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_cairo_surface_destroy0 (_data3_->surface);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda34_ (Block3Data* _data3_,
             cairo_t* cr)
{
	cairo_surface_t* _tmp0_;
	gboolean result;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = _data3_->surface;
	cairo_set_source_surface (cr, _tmp0_, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
	result = FALSE;
	return result;
}

static gboolean
___lambda34__clutter_canvas_draw (ClutterCanvas* _sender,
                                  cairo_t* cr,
                                  gint width,
                                  gint height,
                                  gpointer self)
{
	gboolean result;
	result = __lambda34_ (self, cr);
	return result;
}

ClutterActor*
greeter_compositor_utils_get_window_actor_snapshot (MetaWindowActor* actor,
                                                    MetaRectangle* inner_rect,
                                                    MetaRectangle* outer_rect)
{
	Block3Data* _data3_;
	MetaShapedTexture* texture = NULL;
	MetaShapedTexture* _tmp0_;
	MetaShapedTexture* _tmp1_;
	MetaShapedTexture* _tmp2_;
	MetaShapedTexture* _tmp3_;
	MetaRectangle _tmp4_;
	MetaRectangle _tmp5_;
	MetaRectangle _tmp6_;
	MetaRectangle _tmp7_;
	MetaRectangle _tmp8_;
	MetaRectangle _tmp9_;
	cairo_rectangle_int_t _tmp10_ = {0};
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	ClutterCanvas* canvas = NULL;
	ClutterCanvas* _tmp13_;
	gulong handler = 0UL;
	ClutterCanvas* _tmp14_;
	gulong _tmp15_;
	ClutterCanvas* _tmp16_;
	MetaRectangle _tmp17_;
	MetaRectangle _tmp18_;
	ClutterCanvas* _tmp19_;
	ClutterActor* container = NULL;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	MetaRectangle _tmp22_;
	MetaRectangle _tmp23_;
	ClutterActor* _tmp24_;
	ClutterCanvas* _tmp25_;
	ClutterActor* result;
	g_return_val_if_fail (actor != NULL, NULL);
	g_return_val_if_fail (inner_rect != NULL, NULL);
	g_return_val_if_fail (outer_rect != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = meta_window_actor_get_texture (actor);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, meta_shaped_texture_get_type ()) ? ((MetaShapedTexture*) _tmp0_) : NULL);
	texture = _tmp1_;
	_tmp2_ = texture;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (texture);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp3_ = texture;
	_tmp4_ = *inner_rect;
	_tmp5_ = *outer_rect;
	_tmp6_ = *inner_rect;
	_tmp7_ = *outer_rect;
	_tmp8_ = *inner_rect;
	_tmp9_ = *inner_rect;
	_tmp10_.x = _tmp4_.x - _tmp5_.x;
	_tmp10_.y = _tmp6_.y - _tmp7_.y;
	_tmp10_.width = _tmp8_.width;
	_tmp10_.height = _tmp9_.height;
	_tmp11_ = meta_shaped_texture_get_image (_tmp3_, &_tmp10_);
	_data3_->surface = _tmp11_;
	_tmp12_ = _data3_->surface;
	if (_tmp12_ == NULL) {
		result = NULL;
		_g_object_unref0 (texture);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp13_ = (ClutterCanvas*) clutter_canvas_new ();
	canvas = _tmp13_;
	_tmp14_ = canvas;
	_tmp15_ = g_signal_connect_data (_tmp14_, "draw", (GCallback) ___lambda34__clutter_canvas_draw, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	handler = _tmp15_;
	_tmp16_ = canvas;
	_tmp17_ = *inner_rect;
	_tmp18_ = *inner_rect;
	clutter_canvas_set_size (_tmp16_, _tmp17_.width, _tmp18_.height);
	_tmp19_ = canvas;
	g_signal_handler_disconnect (_tmp19_, handler);
	_tmp20_ = clutter_actor_new ();
	g_object_ref_sink (_tmp20_);
	container = _tmp20_;
	_tmp21_ = container;
	_tmp22_ = *inner_rect;
	_tmp23_ = *inner_rect;
	clutter_actor_set_size (_tmp21_, (gfloat) _tmp22_.width, (gfloat) _tmp23_.height);
	_tmp24_ = container;
	_tmp25_ = canvas;
	clutter_actor_set_content (_tmp24_, (ClutterContent*) _tmp25_);
	result = container;
	_g_object_unref0 (canvas);
	_g_object_unref0 (texture);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

/**
        * Ring the system bell, will most likely emit a <beep> error sound or, if the
        * audible bell is disabled, flash the display
        *
        * @param display The display to flash, if necessary
        */
void
greeter_compositor_utils_bell (MetaDisplay* display)
{
	g_return_if_fail (display != NULL);
	if (meta_prefs_bell_is_audible ()) {
		gdk_beep ();
	} else {
		MetaCompositor* _tmp0_;
		_tmp0_ = meta_display_get_compositor (display);
		meta_compositor_flash_display (_tmp0_, display);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
greeter_compositor_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
greeter_compositor_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		greeter_compositor_utils_unref (value->data[0].v_pointer);
	}
}

static void
greeter_compositor_value_utils_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = greeter_compositor_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
greeter_compositor_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
greeter_compositor_value_utils_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GreeterCompositorUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = greeter_compositor_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
greeter_compositor_value_utils_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	GreeterCompositorUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = greeter_compositor_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
greeter_compositor_param_spec_utils (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	GreeterCompositorParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GREETER_COMPOSITOR_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
greeter_compositor_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
greeter_compositor_value_set_utils (GValue* value,
                                    gpointer v_object)
{
	GreeterCompositorUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		greeter_compositor_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_utils_unref (old);
	}
}

void
greeter_compositor_value_take_utils (GValue* value,
                                     gpointer v_object)
{
	GreeterCompositorUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_utils_unref (old);
	}
}

static void
greeter_compositor_utils_base_init (GreeterCompositorUtilsClass * klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (greeter_compositor_utils_xid_pixbuf_cache);
	greeter_compositor_utils_xid_pixbuf_cache = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (greeter_compositor_utils_icon_pixbuf_cache);
	greeter_compositor_utils_icon_pixbuf_cache = _tmp5_;
}

static void
greeter_compositor_utils_class_init (GreeterCompositorUtilsClass * klass,
                                     gpointer klass_data)
{
	greeter_compositor_utils_parent_class = g_type_class_peek_parent (klass);
	((GreeterCompositorUtilsClass *) klass)->finalize = greeter_compositor_utils_finalize;
}

static void
greeter_compositor_utils_instance_init (GreeterCompositorUtils * self,
                                        gpointer klass)
{
	self->ref_count = 1;
}

static void
greeter_compositor_utils_finalize (GreeterCompositorUtils * obj)
{
	GreeterCompositorUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_UTILS, GreeterCompositorUtils);
	g_signal_handlers_destroy (self);
}

static GType
greeter_compositor_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { greeter_compositor_value_utils_init, greeter_compositor_value_utils_free_value, greeter_compositor_value_utils_copy_value, greeter_compositor_value_utils_peek_pointer, "p", greeter_compositor_value_utils_collect_value, "p", greeter_compositor_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorUtilsClass), (GBaseInitFunc) greeter_compositor_utils_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorUtils), 0, (GInstanceInitFunc) greeter_compositor_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType greeter_compositor_utils_type_id;
	greeter_compositor_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GreeterCompositorUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return greeter_compositor_utils_type_id;
}

GType
greeter_compositor_utils_get_type (void)
{
	static volatile gsize greeter_compositor_utils_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_utils_type_id__once)) {
		GType greeter_compositor_utils_type_id;
		greeter_compositor_utils_type_id = greeter_compositor_utils_get_type_once ();
		g_once_init_leave (&greeter_compositor_utils_type_id__once, greeter_compositor_utils_type_id);
	}
	return greeter_compositor_utils_type_id__once;
}

gpointer
greeter_compositor_utils_ref (gpointer instance)
{
	GreeterCompositorUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
greeter_compositor_utils_unref (gpointer instance)
{
	GreeterCompositorUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GREETER_COMPOSITOR_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

