/* DBusAccelerator.c generated by valac 0.56.0, the Vala compiler
 * generated from DBusAccelerator.vala, do not modify */

/*
 * Copyright 2015 Nicolas Bruguier, Corentin Noël
 * Copyright 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/prefs.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GREETER_COMPOSITOR_ACTION_MODE_NONE = 0,
	GREETER_COMPOSITOR_ACTION_MODE_NORMAL = 1 << 0,
	GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW = 1 << 1,
	GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN = 1 << 2,
	GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN = 1 << 3,
	GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN = 1 << 4,
	GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL = 1 << 5,
	GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS = 1 << 6,
	GREETER_COMPOSITOR_ACTION_MODE_POPUP = 1 << 7
} GreeterCompositorActionMode;

#define GREETER_COMPOSITOR_TYPE_ACTION_MODE (greeter_compositor_action_mode_get_type ())

#define GREETER_COMPOSITOR_TYPE_ACCELERATOR (greeter_compositor_accelerator_get_type ())
typedef struct _GreeterCompositorAccelerator GreeterCompositorAccelerator;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GreeterCompositorGrabbedAccelerator GreeterCompositorGrabbedAccelerator;

#define GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR (greeter_compositor_dbus_accelerator_get_type ())
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAccelerator))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_IS_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR))
#define GREETER_COMPOSITOR_DBUS_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAcceleratorClass))

typedef struct _GreeterCompositorDBusAccelerator GreeterCompositorDBusAccelerator;
typedef struct _GreeterCompositorDBusAcceleratorClass GreeterCompositorDBusAcceleratorClass;
typedef struct _GreeterCompositorDBusAcceleratorPrivate GreeterCompositorDBusAcceleratorPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _greeter_compositor_dbus_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_dbus_accelerator_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _greeter_compositor_grabbed_accelerator_free0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_grabbed_accelerator_free (var), NULL)))
typedef struct _GreeterCompositorParamSpecDBusAccelerator GreeterCompositorParamSpecDBusAccelerator;
enum  {
	GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL,
	GREETER_COMPOSITOR_DBUS_ACCELERATOR_NUM_SIGNALS
};
static guint greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_NUM_SIGNALS] = {0};

struct _GreeterCompositorAccelerator {
	gchar* name;
	GreeterCompositorActionMode flags;
	MetaKeyBindingFlags grab_flags;
};

struct _GreeterCompositorGrabbedAccelerator {
	GreeterCompositorAccelerator accelerator;
	guint action;
};

struct _GreeterCompositorDBusAccelerator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GreeterCompositorDBusAcceleratorPrivate * priv;
};

struct _GreeterCompositorDBusAcceleratorClass {
	GTypeClass parent_class;
	void (*finalize) (GreeterCompositorDBusAccelerator *self);
};

struct _GreeterCompositorDBusAcceleratorPrivate {
	GreeterCompositorWindowManager* wm;
	GList* grabbed_accelerators;
};

struct _GreeterCompositorParamSpecDBusAccelerator {
	GParamSpec parent_instance;
};

static gint GreeterCompositorDBusAccelerator_private_offset;
static gpointer greeter_compositor_dbus_accelerator_parent_class = NULL;
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_instance;
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_instance = NULL;

VALA_EXTERN GType greeter_compositor_action_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType greeter_compositor_accelerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorAccelerator* greeter_compositor_accelerator_dup (const GreeterCompositorAccelerator* self);
VALA_EXTERN void greeter_compositor_accelerator_free (GreeterCompositorAccelerator* self);
VALA_EXTERN void greeter_compositor_accelerator_copy (const GreeterCompositorAccelerator* self,
                                          GreeterCompositorAccelerator* dest);
VALA_EXTERN void greeter_compositor_accelerator_destroy (GreeterCompositorAccelerator* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GreeterCompositorAccelerator, greeter_compositor_accelerator_destroy)
VALA_EXTERN void greeter_compositor_grabbed_accelerator_free (GreeterCompositorGrabbedAccelerator * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorGrabbedAccelerator, greeter_compositor_grabbed_accelerator_free)
static void greeter_compositor_grabbed_accelerator_instance_init (GreeterCompositorGrabbedAccelerator * self);
VALA_EXTERN GreeterCompositorGrabbedAccelerator* greeter_compositor_grabbed_accelerator_new (void);
VALA_EXTERN gpointer greeter_compositor_dbus_accelerator_ref (gpointer instance);
VALA_EXTERN void greeter_compositor_dbus_accelerator_unref (gpointer instance);
VALA_EXTERN GParamSpec* greeter_compositor_param_spec_dbus_accelerator (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags);
VALA_EXTERN void greeter_compositor_value_set_dbus_accelerator (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN void greeter_compositor_value_take_dbus_accelerator (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN gpointer greeter_compositor_value_get_dbus_accelerator (const GValue* value);
VALA_EXTERN GType greeter_compositor_dbus_accelerator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorDBusAccelerator, greeter_compositor_dbus_accelerator_unref)
VALA_EXTERN guint greeter_compositor_dbus_accelerator_register_object (void* object,
                                                           GDBusConnection* connection,
                                                           const gchar* path,
                                                           GError** error);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
static void _greeter_compositor_grabbed_accelerator_free0_ (gpointer var);
static inline void _g_list_free__greeter_compositor_grabbed_accelerator_free0_ (GList* self);
VALA_EXTERN GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_init (GreeterCompositorWindowManager* wm);
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_new (GreeterCompositorWindowManager* _wm);
static GreeterCompositorDBusAccelerator* greeter_compositor_dbus_accelerator_construct (GType object_type,
                                                                                 GreeterCompositorWindowManager* _wm);
static void greeter_compositor_dbus_accelerator_on_accelerator_activated (GreeterCompositorDBusAccelerator* self,
                                                                   guint action,
                                                                   ClutterInputDevice* device,
                                                                   guint timestamp);
static void _greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                                       guint object,
                                                                                                       ClutterInputDevice* p0,
                                                                                                       guint p1,
                                                                                                       gpointer self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static guint greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                            GreeterCompositorAccelerator* accelerator);
VALA_EXTERN guint* greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                              GreeterCompositorAccelerator* accelerators,
                                                              gint accelerators_length1,
                                                              gint* result_length1,
                                                              GError** error);
static void _vala_array_add1 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
VALA_EXTERN gboolean greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                                 guint action,
                                                                 GError** error);
VALA_EXTERN gboolean greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                  guint* actions,
                                                                  gint actions_length1,
                                                                  GError** error);
VALA_EXTERN void greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                   GHashTable* parameters,
                                                   GError** error);
VALA_EXTERN void greeter_compositor_media_feedback_send (const gchar* icon,
                                             gint val);
static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void greeter_compositor_dbus_accelerator_finalize (GreeterCompositorDBusAccelerator * obj);
static GType greeter_compositor_dbus_accelerator_get_type_once (void);
static void _vala_GreeterCompositorAccelerator_array_free (GreeterCompositorAccelerator * array,
                                                    gssize array_length);
static void _dbus_greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                                    GVariant* _parameters_,
                                                                    GDBusMethodInvocation* invocation);
static void _dbus_greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void greeter_compositor_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* method_name,
                                                                     GVariant* parameters,
                                                                     GDBusMethodInvocation* invocation,
                                                                     gpointer user_data);
static GVariant* greeter_compositor_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GError** error,
                                                                           gpointer user_data);
static gboolean greeter_compositor_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                                          const gchar* sender,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          const gchar* property_name,
                                                                          GVariant* value,
                                                                          GError** error,
                                                                          gpointer user_data);
static void _dbus_greeter_compositor_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                                      guint action,
                                                                      GHashTable* parameters,
                                                                      gpointer* _data);
static void _greeter_compositor_dbus_accelerator_unregister_object (gpointer user_data);

static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators = {-1, "accelerators", "a(suu)", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_result = {-1, "result", "au", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerators = {-1, "GrabAccelerators", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_grab_accelerators_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerator = {-1, "UngrabAccelerator", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions = {-1, "actions", "au", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result, NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerators = {-1, "UngrabAccelerators", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out), NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_in[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_parameters, NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_out[] = {NULL};
static const GDBusMethodInfo _greeter_compositor_dbus_accelerator_dbus_method_info_show_osd = {-1, "ShowOSD", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_in), (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_show_osd_out), NULL};
static const GDBusMethodInfo * const _greeter_compositor_dbus_accelerator_dbus_method_info[] = {&_greeter_compositor_dbus_accelerator_dbus_method_info_grab_accelerators, &_greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerator, &_greeter_compositor_dbus_accelerator_dbus_method_info_ungrab_accelerators, &_greeter_compositor_dbus_accelerator_dbus_method_info_show_osd, NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated[] = {&_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_action, &_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters, NULL};
static const GDBusSignalInfo _greeter_compositor_dbus_accelerator_dbus_signal_info_accelerator_activated = {-1, "AcceleratorActivated", (GDBusArgInfo **) (&_greeter_compositor_dbus_accelerator_dbus_arg_info_accelerator_activated), NULL};
static const GDBusSignalInfo * const _greeter_compositor_dbus_accelerator_dbus_signal_info[] = {&_greeter_compositor_dbus_accelerator_dbus_signal_info_accelerator_activated, NULL};
static const GDBusPropertyInfo * const _greeter_compositor_dbus_accelerator_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _greeter_compositor_dbus_accelerator_dbus_interface_info = {-1, "org.gnome.Shell", (GDBusMethodInfo **) (&_greeter_compositor_dbus_accelerator_dbus_method_info), (GDBusSignalInfo **) (&_greeter_compositor_dbus_accelerator_dbus_signal_info), (GDBusPropertyInfo **) (&_greeter_compositor_dbus_accelerator_dbus_property_info), NULL};
static const GDBusInterfaceVTable _greeter_compositor_dbus_accelerator_dbus_interface_vtable = {greeter_compositor_dbus_accelerator_dbus_interface_method_call, greeter_compositor_dbus_accelerator_dbus_interface_get_property, greeter_compositor_dbus_accelerator_dbus_interface_set_property};

/**
     * ActionMode:
     * @NONE: block action
     * @NORMAL: allow action when in window mode, e.g. when the focus is in an application window
     * @OVERVIEW: allow action while the overview is active
     * @LOCK_SCREEN: allow action when the screen is locked, e.g. when the screen shield is shown
     * @UNLOCK_SCREEN: allow action in the unlock dialog
     * @LOGIN_SCREEN: allow action in the login screen
     * @SYSTEM_MODAL: allow action when a system modal dialog (e.g. authentification or session dialogs) is open
     * @LOOKING_GLASS: allow action in looking glass
     * @POPUP: allow action while a shell menu is open
     */
static GType
greeter_compositor_action_mode_get_type_once (void)
{
	static const GFlagsValue values[] = {{GREETER_COMPOSITOR_ACTION_MODE_NONE, "GREETER_COMPOSITOR_ACTION_MODE_NONE", "none"}, {GREETER_COMPOSITOR_ACTION_MODE_NORMAL, "GREETER_COMPOSITOR_ACTION_MODE_NORMAL", "normal"}, {GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW, "GREETER_COMPOSITOR_ACTION_MODE_OVERVIEW", "overview"}, {GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_LOCK_SCREEN", "lock-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_UNLOCK_SCREEN", "unlock-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN, "GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN", "login-screen"}, {GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL, "GREETER_COMPOSITOR_ACTION_MODE_SYSTEM_MODAL", "system-modal"}, {GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS, "GREETER_COMPOSITOR_ACTION_MODE_LOOKING_GLASS", "looking-glass"}, {GREETER_COMPOSITOR_ACTION_MODE_POPUP, "GREETER_COMPOSITOR_ACTION_MODE_POPUP", "popup"}, {0, NULL, NULL}};
	GType greeter_compositor_action_mode_type_id;
	greeter_compositor_action_mode_type_id = g_flags_register_static ("GreeterCompositorActionMode", values);
	return greeter_compositor_action_mode_type_id;
}

GType
greeter_compositor_action_mode_get_type (void)
{
	static volatile gsize greeter_compositor_action_mode_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_action_mode_type_id__once)) {
		GType greeter_compositor_action_mode_type_id;
		greeter_compositor_action_mode_type_id = greeter_compositor_action_mode_get_type_once ();
		g_once_init_leave (&greeter_compositor_action_mode_type_id__once, greeter_compositor_action_mode_type_id);
	}
	return greeter_compositor_action_mode_type_id__once;
}

void
greeter_compositor_accelerator_copy (const GreeterCompositorAccelerator* self,
                                     GreeterCompositorAccelerator* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).flags = (*self).flags;
	(*dest).grab_flags = (*self).grab_flags;
}

void
greeter_compositor_accelerator_destroy (GreeterCompositorAccelerator* self)
{
	_g_free0 ((*self).name);
}

GreeterCompositorAccelerator*
greeter_compositor_accelerator_dup (const GreeterCompositorAccelerator* self)
{
	GreeterCompositorAccelerator* dup;
	dup = g_new0 (GreeterCompositorAccelerator, 1);
	greeter_compositor_accelerator_copy (self, dup);
	return dup;
}

void
greeter_compositor_accelerator_free (GreeterCompositorAccelerator* self)
{
	greeter_compositor_accelerator_destroy (self);
	g_free (self);
}

static GType
greeter_compositor_accelerator_get_type_once (void)
{
	GType greeter_compositor_accelerator_type_id;
	greeter_compositor_accelerator_type_id = g_boxed_type_register_static ("GreeterCompositorAccelerator", (GBoxedCopyFunc) greeter_compositor_accelerator_dup, (GBoxedFreeFunc) greeter_compositor_accelerator_free);
	return greeter_compositor_accelerator_type_id;
}

GType
greeter_compositor_accelerator_get_type (void)
{
	static volatile gsize greeter_compositor_accelerator_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_accelerator_type_id__once)) {
		GType greeter_compositor_accelerator_type_id;
		greeter_compositor_accelerator_type_id = greeter_compositor_accelerator_get_type_once ();
		g_once_init_leave (&greeter_compositor_accelerator_type_id__once, greeter_compositor_accelerator_type_id);
	}
	return greeter_compositor_accelerator_type_id__once;
}

GreeterCompositorGrabbedAccelerator*
greeter_compositor_grabbed_accelerator_new (void)
{
	GreeterCompositorGrabbedAccelerator* self;
	self = g_slice_new0 (GreeterCompositorGrabbedAccelerator);
	greeter_compositor_grabbed_accelerator_instance_init (self);
	return self;
}

static void
greeter_compositor_grabbed_accelerator_instance_init (GreeterCompositorGrabbedAccelerator * self)
{
}

void
greeter_compositor_grabbed_accelerator_free (GreeterCompositorGrabbedAccelerator * self)
{
	greeter_compositor_accelerator_destroy (&self->accelerator);
	g_slice_free (GreeterCompositorGrabbedAccelerator, self);
}

static inline gpointer
greeter_compositor_dbus_accelerator_get_instance_private (GreeterCompositorDBusAccelerator* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorDBusAccelerator_private_offset);
}

static void
_greeter_compositor_grabbed_accelerator_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (greeter_compositor_grabbed_accelerator_free (var), NULL));
}

static inline void
_g_list_free__greeter_compositor_grabbed_accelerator_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _greeter_compositor_grabbed_accelerator_free0_);
}

GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_init (GreeterCompositorWindowManager* wm)
{
	GreeterCompositorDBusAccelerator* _tmp0_;
	GreeterCompositorDBusAccelerator* _tmp2_;
	GreeterCompositorDBusAccelerator* result;
	g_return_val_if_fail (wm != NULL, NULL);
	_tmp0_ = greeter_compositor_dbus_accelerator_instance;
	if (_tmp0_ == NULL) {
		GreeterCompositorDBusAccelerator* _tmp1_;
		_tmp1_ = greeter_compositor_dbus_accelerator_new (wm);
		_greeter_compositor_dbus_accelerator_unref0 (greeter_compositor_dbus_accelerator_instance);
		greeter_compositor_dbus_accelerator_instance = _tmp1_;
	}
	_tmp2_ = greeter_compositor_dbus_accelerator_instance;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                                  guint object,
                                                                                                  ClutterInputDevice* p0,
                                                                                                  guint p1,
                                                                                                  gpointer self)
{
	greeter_compositor_dbus_accelerator_on_accelerator_activated ((GreeterCompositorDBusAccelerator*) self, object, p0, p1);
}

static GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_construct (GType object_type,
                                               GreeterCompositorWindowManager* _wm)
{
	GreeterCompositorDBusAccelerator* self = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	GreeterCompositorWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	g_return_val_if_fail (_wm != NULL, NULL);
	self = (GreeterCompositorDBusAccelerator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (self->priv->wm);
	self->priv->wm = _tmp0_;
	(self->priv->grabbed_accelerators == NULL) ? NULL : (self->priv->grabbed_accelerators = (_g_list_free__greeter_compositor_grabbed_accelerator_free0_ (self->priv->grabbed_accelerators), NULL));
	self->priv->grabbed_accelerators = NULL;
	_tmp1_ = self->priv->wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	g_signal_connect (_tmp2_, "accelerator-activated", (GCallback) _greeter_compositor_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated, self);
	return self;
}

static GreeterCompositorDBusAccelerator*
greeter_compositor_dbus_accelerator_new (GreeterCompositorWindowManager* _wm)
{
	return greeter_compositor_dbus_accelerator_construct (GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, _wm);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
greeter_compositor_dbus_accelerator_on_accelerator_activated (GreeterCompositorDBusAccelerator* self,
                                                              guint action,
                                                              ClutterInputDevice* device,
                                                              guint timestamp)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->grabbed_accelerators;
	{
		GList* accel_collection = NULL;
		GList* accel_it = NULL;
		accel_collection = _tmp0_;
		for (accel_it = accel_collection; accel_it != NULL; accel_it = accel_it->next) {
			GreeterCompositorGrabbedAccelerator* accel = NULL;
			accel = (GreeterCompositorGrabbedAccelerator*) accel_it->data;
			{
				GreeterCompositorGrabbedAccelerator* _tmp1_;
				_tmp1_ = accel;
				if (_tmp1_->action == action) {
					GreeterCompositorGrabbedAccelerator* _tmp2_;
					GreeterCompositorAccelerator _tmp3_;
					_tmp2_ = accel;
					_tmp3_ = _tmp2_->accelerator;
					if ((_tmp3_.flags & GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN) == GREETER_COMPOSITOR_ACTION_MODE_LOGIN_SCREEN) {
						GHashTable* parameters = NULL;
						GHashTable* _tmp4_;
						GHashTable* _tmp5_;
						gchar* _tmp6_;
						GVariant* _tmp7_;
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						GHashTable* _tmp15_;
						_tmp4_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
						parameters = _tmp4_;
						_tmp5_ = parameters;
						_tmp6_ = g_strdup ("timestamp");
						_tmp7_ = g_variant_new_uint32 ((guint32) timestamp);
						g_variant_ref_sink (_tmp7_);
						g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
						_tmp8_ = clutter_input_device_get_device_node (device);
						_tmp9_ = _tmp8_;
						if (_tmp9_ != NULL) {
							GHashTable* _tmp10_;
							gchar* _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							GVariant* _tmp14_;
							_tmp10_ = parameters;
							_tmp11_ = g_strdup ("device-node");
							_tmp12_ = clutter_input_device_get_device_node (device);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_variant_new_string (_tmp13_);
							g_variant_ref_sink (_tmp14_);
							g_hash_table_insert (_tmp10_, _tmp11_, _tmp14_);
						}
						_tmp15_ = parameters;
						g_signal_emit (self, greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL], 0, action, _tmp15_);
						_g_hash_table_unref0 (parameters);
					}
					return;
				}
			}
		}
	}
}

static guint
greeter_compositor_dbus_accelerator_grab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                      GreeterCompositorAccelerator* accelerator)
{
	GList* _tmp0_;
	guint action = 0U;
	GreeterCompositorWindowManager* _tmp7_;
	MetaDisplay* _tmp8_;
	GreeterCompositorAccelerator _tmp9_;
	const gchar* _tmp10_;
	GreeterCompositorAccelerator _tmp11_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (accelerator != NULL, 0U);
	_tmp0_ = self->priv->grabbed_accelerators;
	{
		GList* accel_collection = NULL;
		GList* accel_it = NULL;
		accel_collection = _tmp0_;
		for (accel_it = accel_collection; accel_it != NULL; accel_it = accel_it->next) {
			GreeterCompositorGrabbedAccelerator* accel = NULL;
			accel = (GreeterCompositorGrabbedAccelerator*) accel_it->data;
			{
				GreeterCompositorGrabbedAccelerator* _tmp1_;
				GreeterCompositorAccelerator _tmp2_;
				const gchar* _tmp3_;
				GreeterCompositorAccelerator _tmp4_;
				const gchar* _tmp5_;
				_tmp1_ = accel;
				_tmp2_ = _tmp1_->accelerator;
				_tmp3_ = _tmp2_.name;
				_tmp4_ = *accelerator;
				_tmp5_ = _tmp4_.name;
				if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
					GreeterCompositorGrabbedAccelerator* _tmp6_;
					_tmp6_ = accel;
					result = _tmp6_->action;
					return result;
				}
			}
		}
	}
	_tmp7_ = self->priv->wm;
	_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _tmp7_);
	_tmp9_ = *accelerator;
	_tmp10_ = _tmp9_.name;
	_tmp11_ = *accelerator;
	action = meta_display_grab_accelerator (_tmp8_, _tmp10_, _tmp11_.grab_flags);
	if (action > ((guint) 0)) {
		GreeterCompositorGrabbedAccelerator* accel = NULL;
		GreeterCompositorGrabbedAccelerator* _tmp12_;
		GreeterCompositorGrabbedAccelerator* _tmp13_;
		GreeterCompositorGrabbedAccelerator* _tmp14_;
		GreeterCompositorAccelerator _tmp15_;
		GreeterCompositorAccelerator _tmp16_;
		GreeterCompositorAccelerator _tmp17_ = {0};
		GreeterCompositorGrabbedAccelerator* _tmp18_;
		_tmp12_ = greeter_compositor_grabbed_accelerator_new ();
		accel = _tmp12_;
		_tmp13_ = accel;
		_tmp13_->action = action;
		_tmp14_ = accel;
		_tmp15_ = *accelerator;
		_tmp16_ = _tmp15_;
		greeter_compositor_accelerator_copy (&_tmp16_, &_tmp17_);
		greeter_compositor_accelerator_destroy (&_tmp14_->accelerator);
		_tmp14_->accelerator = _tmp17_;
		_tmp18_ = accel;
		accel = NULL;
		self->priv->grabbed_accelerators = g_list_append (self->priv->grabbed_accelerators, _tmp18_);
		_greeter_compositor_grabbed_accelerator_free0 (accel);
	}
	result = action;
	return result;
}

static void
_vala_array_add1 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

guint*
greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                       GreeterCompositorAccelerator* accelerators,
                                                       gint accelerators_length1,
                                                       gint* result_length1,
                                                       GError** error)
{
	guint* actions = NULL;
	guint* _tmp0_;
	gint actions_length1;
	gint _actions_size_;
	guint* _tmp2_;
	gint _tmp2__length1;
	guint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint, 0);
	actions = _tmp0_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	{
		GreeterCompositorAccelerator* accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = accelerators;
		accelerator_collection_length1 = accelerators_length1;
		for (accelerator_it = 0; accelerator_it < accelerator_collection_length1; accelerator_it = accelerator_it + 1) {
			GreeterCompositorAccelerator accelerator = {0};
			accelerator = accelerator_collection[accelerator_it];
			{
				GreeterCompositorAccelerator _tmp1_;
				_tmp1_ = accelerator;
				_vala_array_add1 (&actions, &actions_length1, &_actions_size_, greeter_compositor_dbus_accelerator_grab_accelerator (self, &_tmp1_));
			}
		}
	}
	_tmp2_ = actions;
	_tmp2__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

gboolean
greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                        guint action,
                                                        GError** error)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->grabbed_accelerators;
	{
		GList* accel_collection = NULL;
		GList* accel_it = NULL;
		accel_collection = _tmp0_;
		for (accel_it = accel_collection; accel_it != NULL; accel_it = accel_it->next) {
			GreeterCompositorGrabbedAccelerator* accel = NULL;
			accel = (GreeterCompositorGrabbedAccelerator*) accel_it->data;
			{
				GreeterCompositorGrabbedAccelerator* _tmp1_;
				_tmp1_ = accel;
				if (_tmp1_->action == action) {
					gboolean ret = FALSE;
					GreeterCompositorWindowManager* _tmp2_;
					MetaDisplay* _tmp3_;
					GreeterCompositorGrabbedAccelerator* _tmp4_;
					_tmp2_ = self->priv->wm;
					_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
					ret = meta_display_ungrab_accelerator (_tmp3_, action);
					_tmp4_ = accel;
					self->priv->grabbed_accelerators = vala_g_list_remove_full (self->priv->grabbed_accelerators, _tmp4_, _greeter_compositor_grabbed_accelerator_free0_);
					result = ret;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                         guint* actions,
                                                         gint actions_length1,
                                                         GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint* action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = actions;
		action_collection_length1 = actions_length1;
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			guint action = 0U;
			action = action_collection[action_it];
			{
				greeter_compositor_dbus_accelerator_ungrab_accelerator (self, action, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp0_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp0_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

void
greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                              GHashTable* parameters,
                                              GError** error)
{
	gint32 monitor_index = 0;
	gchar* icon = NULL;
	gchar* _tmp1_;
	gchar* label = NULL;
	gchar* _tmp5_;
	gint32 level = 0;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameters != NULL);
	monitor_index = (gint32) -1;
	if (g_hash_table_contains (parameters, "monitor")) {
		gconstpointer _tmp0_;
		_tmp0_ = g_hash_table_lookup (parameters, "monitor");
		monitor_index = g_variant_get_int32 ((GVariant*) _tmp0_);
	}
	_tmp1_ = g_strdup ("");
	icon = _tmp1_;
	if (g_hash_table_contains (parameters, "icon")) {
		gconstpointer _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_hash_table_lookup (parameters, "icon");
		_tmp3_ = g_variant_get_string ((GVariant*) _tmp2_, NULL);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (icon);
		icon = _tmp4_;
	}
	_tmp5_ = g_strdup ("");
	label = _tmp5_;
	if (g_hash_table_contains (parameters, "label")) {
		gconstpointer _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_hash_table_lookup (parameters, "label");
		_tmp7_ = g_variant_get_string ((GVariant*) _tmp6_, NULL);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (label);
		label = _tmp8_;
	}
	level = (gint32) 0;
	if (g_hash_table_contains (parameters, "level")) {
		gdouble double_level = 0.0;
		gconstpointer _tmp9_;
		_tmp9_ = g_hash_table_lookup (parameters, "level");
		double_level = g_variant_get_double ((GVariant*) _tmp9_);
		level = (gint32) ((gint) (double_level * 100));
	}
	_tmp10_ = icon;
	greeter_compositor_media_feedback_send (_tmp10_, (gint) level);
	_g_free0 (label);
	_g_free0 (icon);
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
greeter_compositor_value_dbus_accelerator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
greeter_compositor_value_dbus_accelerator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		greeter_compositor_dbus_accelerator_unref (value->data[0].v_pointer);
	}
}

static void
greeter_compositor_value_dbus_accelerator_copy_value (const GValue* src_value,
                                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = greeter_compositor_dbus_accelerator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
greeter_compositor_value_dbus_accelerator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
greeter_compositor_value_dbus_accelerator_collect_value (GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GreeterCompositorDBusAccelerator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = greeter_compositor_dbus_accelerator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
greeter_compositor_value_dbus_accelerator_lcopy_value (const GValue* value,
                                                       guint n_collect_values,
                                                       GTypeCValue* collect_values,
                                                       guint collect_flags)
{
	GreeterCompositorDBusAccelerator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = greeter_compositor_dbus_accelerator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
greeter_compositor_param_spec_dbus_accelerator (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags)
{
	GreeterCompositorParamSpecDBusAccelerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
greeter_compositor_value_get_dbus_accelerator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR), NULL);
	return value->data[0].v_pointer;
}

void
greeter_compositor_value_set_dbus_accelerator (GValue* value,
                                               gpointer v_object)
{
	GreeterCompositorDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		greeter_compositor_dbus_accelerator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_dbus_accelerator_unref (old);
	}
}

void
greeter_compositor_value_take_dbus_accelerator (GValue* value,
                                                gpointer v_object)
{
	GreeterCompositorDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		greeter_compositor_dbus_accelerator_unref (old);
	}
}

static void
greeter_compositor_dbus_accelerator_class_init (GreeterCompositorDBusAcceleratorClass * klass,
                                                gpointer klass_data)
{
	greeter_compositor_dbus_accelerator_parent_class = g_type_class_peek_parent (klass);
	((GreeterCompositorDBusAcceleratorClass *) klass)->finalize = greeter_compositor_dbus_accelerator_finalize;
	g_type_class_adjust_private_offset (klass, &GreeterCompositorDBusAccelerator_private_offset);
	greeter_compositor_dbus_accelerator_signals[GREETER_COMPOSITOR_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL] = g_signal_new ("accelerator-activated", GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_HASH_TABLE);
}

static void
greeter_compositor_dbus_accelerator_instance_init (GreeterCompositorDBusAccelerator * self,
                                                   gpointer klass)
{
	self->priv = greeter_compositor_dbus_accelerator_get_instance_private (self);
	self->ref_count = 1;
}

static void
greeter_compositor_dbus_accelerator_finalize (GreeterCompositorDBusAccelerator * obj)
{
	GreeterCompositorDBusAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_DBUS_ACCELERATOR, GreeterCompositorDBusAccelerator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->wm);
	(self->priv->grabbed_accelerators == NULL) ? NULL : (self->priv->grabbed_accelerators = (_g_list_free__greeter_compositor_grabbed_accelerator_free0_ (self->priv->grabbed_accelerators), NULL));
}

static GType
greeter_compositor_dbus_accelerator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { greeter_compositor_value_dbus_accelerator_init, greeter_compositor_value_dbus_accelerator_free_value, greeter_compositor_value_dbus_accelerator_copy_value, greeter_compositor_value_dbus_accelerator_peek_pointer, "p", greeter_compositor_value_dbus_accelerator_collect_value, "p", greeter_compositor_value_dbus_accelerator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorDBusAcceleratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_dbus_accelerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorDBusAccelerator), 0, (GInstanceInitFunc) greeter_compositor_dbus_accelerator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType greeter_compositor_dbus_accelerator_type_id;
	greeter_compositor_dbus_accelerator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GreeterCompositorDBusAccelerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (greeter_compositor_dbus_accelerator_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) greeter_compositor_dbus_accelerator_register_object);
	GreeterCompositorDBusAccelerator_private_offset = g_type_add_instance_private (greeter_compositor_dbus_accelerator_type_id, sizeof (GreeterCompositorDBusAcceleratorPrivate));
	return greeter_compositor_dbus_accelerator_type_id;
}

GType
greeter_compositor_dbus_accelerator_get_type (void)
{
	static volatile gsize greeter_compositor_dbus_accelerator_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_dbus_accelerator_type_id__once)) {
		GType greeter_compositor_dbus_accelerator_type_id;
		greeter_compositor_dbus_accelerator_type_id = greeter_compositor_dbus_accelerator_get_type_once ();
		g_once_init_leave (&greeter_compositor_dbus_accelerator_type_id__once, greeter_compositor_dbus_accelerator_type_id);
	}
	return greeter_compositor_dbus_accelerator_type_id__once;
}

gpointer
greeter_compositor_dbus_accelerator_ref (gpointer instance)
{
	GreeterCompositorDBusAccelerator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
greeter_compositor_dbus_accelerator_unref (gpointer instance)
{
	GreeterCompositorDBusAccelerator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GREETER_COMPOSITOR_DBUS_ACCELERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_GreeterCompositorAccelerator_array_free (GreeterCompositorAccelerator * array,
                                               gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			greeter_compositor_accelerator_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_greeter_compositor_dbus_accelerator_grab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GreeterCompositorAccelerator* accelerators = NULL;
	gint accelerators_length1 = 0;
	GVariant* _tmp0_;
	GreeterCompositorAccelerator* _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	gint result_length1 = 0;
	guint* _tmp9_;
	GVariantBuilder _tmp10_;
	gint _tmp11_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (GreeterCompositorAccelerator, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		GreeterCompositorAccelerator _tmp4_;
		GVariantIter _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (GreeterCompositorAccelerator, _tmp1_, _tmp1__size + 1);
		}
		g_variant_iter_init (&_tmp5_, _tmp3_);
		_tmp6_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.name = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
		_tmp7_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.flags = g_variant_get_uint32 (_tmp7_);
		g_variant_unref (_tmp7_);
		_tmp8_ = g_variant_iter_next_value (&_tmp5_);
		_tmp4_.grab_flags = g_variant_get_uint32 (_tmp8_);
		g_variant_unref (_tmp8_);
		_tmp1_[_tmp1__length++] = _tmp4_;
		g_variant_unref (_tmp3_);
	}
	accelerators_length1 = _tmp1__length1;
	accelerators = _tmp1_;
	g_variant_unref (_tmp0_);
	result = greeter_compositor_dbus_accelerator_grab_accelerators (self, accelerators, accelerators_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp9_ = result;
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("au"));
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		g_variant_builder_add_value (&_tmp10_, g_variant_new_uint32 (*_tmp9_));
		_tmp9_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp10_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	accelerators = (_vala_GreeterCompositorAccelerator_array_free (accelerators, accelerators_length1), NULL);
	;
}

static void
_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (GreeterCompositorDBusAccelerator* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint action = 0U;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_uint32 (_tmp12_);
	g_variant_unref (_tmp12_);
	result = greeter_compositor_dbus_accelerator_ungrab_accelerator (self, action, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (GreeterCompositorDBusAccelerator* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint* actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp13_;
	guint* _tmp14_;
	gint _tmp14__length;
	gint _tmp14__size;
	gint _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp14_ = g_new (guint, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _tmp13_);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (guint, _tmp14_, _tmp14__size + 1);
		}
		_tmp14_[_tmp14__length++] = g_variant_get_uint32 (_tmp16_);
		g_variant_unref (_tmp16_);
	}
	actions_length1 = _tmp14__length1;
	actions = _tmp14_;
	g_variant_unref (_tmp13_);
	result = greeter_compositor_dbus_accelerator_ungrab_accelerators (self, actions, actions_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	actions = (g_free (actions), NULL);
	;
}

static void
_dbus_greeter_compositor_dbus_accelerator_show_osd (GreeterCompositorDBusAccelerator* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* parameters = NULL;
	GVariant* _tmp17_;
	GHashTable* _tmp18_;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp18_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp19_, _tmp17_);
	while (g_variant_iter_loop (&_tmp19_, "{?*}", &_tmp20_, &_tmp21_)) {
		g_hash_table_insert (_tmp18_, g_variant_dup_string (_tmp20_, NULL), g_variant_get_variant (_tmp21_));
	}
	parameters = _tmp18_;
	g_variant_unref (_tmp17_);
	greeter_compositor_dbus_accelerator_show_osd (self, parameters, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (parameters);
	;
}

static void
greeter_compositor_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GrabAccelerators") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_grab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerator") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerators") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_ungrab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_greeter_compositor_dbus_accelerator_show_osd (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
greeter_compositor_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
greeter_compositor_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_greeter_compositor_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                                 guint action,
                                                                 GHashTable* parameters,
                                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp22_;
	GHashTableIter _tmp23_;
	gpointer _tmp24_;
	gpointer _tmp25_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action));
	g_hash_table_iter_init (&_tmp23_, parameters);
	g_variant_builder_init (&_tmp22_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp23_, &_tmp24_, &_tmp25_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp24_;
		_value = (GVariant*) _tmp25_;
		g_variant_builder_add (&_tmp22_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp22_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Shell", "AcceleratorActivated", _arguments, NULL);
}

guint
greeter_compositor_dbus_accelerator_register_object (gpointer object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = greeter_compositor_dbus_accelerator_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_greeter_compositor_dbus_accelerator_dbus_interface_info), &_greeter_compositor_dbus_accelerator_dbus_interface_vtable, data, _greeter_compositor_dbus_accelerator_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "accelerator-activated", (GCallback) _dbus_greeter_compositor_dbus_accelerator_accelerator_activated, data);
	return result;
}

static void
_greeter_compositor_dbus_accelerator_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_greeter_compositor_dbus_accelerator_accelerator_activated, data);
	greeter_compositor_dbus_accelerator_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

