/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.modelset.Orientation;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Connections;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.Scene;
import org.jmol.viewer.Viewer;

public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 7;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    private static final int MAX_UNDO_DEFAULT = 20;
    private int maxUndo = 20;
    protected final Viewer vwr;
    protected Map<String, Object> saved = new Hashtable<String, Object>();
    private String lastOrientation = "";
    private String lastContext = "";
    private String lastConnections = "";
    private String lastScene = "";
    private String lastSelected = "";
    private String lastState = "";
    private String lastShape = "";
    private String lastCoordinates = "";
    Lst<String> undoStateStack;
    Lst<String> redoStateStack;

    public static String getVariableList(Map<String, SV> htVariables, int nMax, boolean withSites, boolean definedOnly) {
        SB sb = new SB();
        int n = 0;
        Object[] list = new String[htVariables.size()];
        for (Map.Entry<String, SV> entry : htVariables.entrySet()) {
            String key = entry.getKey();
            SV var = entry.getValue();
            if (!withSites && key.startsWith("site_") || definedOnly && key.charAt(0) != '@') continue;
            list[n++] = key + (key.charAt(0) == '@' ? " " + var.asString() : " = " + StateManager.varClip(key, var.escape(), nMax));
        }
        Arrays.sort(list, 0, n);
        for (int i = 0; i < n; ++i) {
            if (list[i] == null) continue;
            sb.append("  ").append((String)list[i]).append(";\n");
        }
        if (n == 0 && !definedOnly) {
            sb.append("# --no global user variables defined--;\n");
        }
        return sb.toString();
    }

    public static int getObjectIdFromName(String name) {
        if (name == null) {
            return -1;
        }
        int objID = objectNameList.indexOf(name.toLowerCase());
        return objID < 0 ? objID : objID / 11;
    }

    static String getObjectNameFromId(int objId) {
        if (objId < 0 || objId >= 7) {
            return null;
        }
        return objectNameList.substring(objId * 11, objId * 11 + 11).trim();
    }

    StateManager(Viewer vwr) {
        this.vwr = vwr;
    }

    void clear(GlobalSettings global) {
        this.vwr.setShowAxes(false);
        this.vwr.setShowBbcage(false);
        this.vwr.setShowUnitCell(false);
        global.clear();
    }

    public void resetLighting() {
        this.vwr.setIntProperty("ambientPercent", 45);
        this.vwr.setIntProperty("celShadingPower", 10);
        this.vwr.setIntProperty("diffusePercent", 84);
        this.vwr.setIntProperty("phongExponent", 64);
        this.vwr.setIntProperty("specularExponent", 6);
        this.vwr.setIntProperty("specularPercent", 22);
        this.vwr.setIntProperty("specularPower", 40);
        this.vwr.setIntProperty("zDepth", 0);
        this.vwr.setIntProperty("zShadePower", 3);
        this.vwr.setIntProperty("zSlab", 50);
        this.vwr.setBooleanProperty("specular", true);
        this.vwr.setBooleanProperty("celShading", false);
        this.vwr.setBooleanProperty("zshade", false);
    }

    void setCrystallographicDefaults() {
        this.vwr.setAxesMode(0x24000020);
        this.vwr.setShowAxes(true);
        this.vwr.setShowUnitCell(true);
        this.vwr.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.vwr.setBooleanProperty("perspectiveDepth", true);
        this.vwr.setFloatProperty("bondTolerance", 0.45f);
        this.vwr.setFloatProperty("minBondDistance", 0.4f);
        this.vwr.setIntProperty("bondingVersion", 0);
        this.vwr.setBooleanProperty("translucent", true);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("defaultColorScheme", "Jmol");
        this.vwr.setBooleanProperty("axesOrientationRasmol", false);
        this.vwr.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.vwr.setIntProperty("percentVdwAtom", 23);
        this.vwr.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.vwr.setVdwStr("auto");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("defaultColorScheme", "RasMol");
        this.vwr.setBooleanProperty("axesOrientationRasmol", true);
        this.vwr.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.vwr.setIntProperty("percentVdwAtom", 0);
        this.vwr.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.vwr.setVdwStr("Rasmol");
    }

    void setPyMOLDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("measurementUnits", "ANGSTROMS");
        this.vwr.setBooleanProperty("zoomHeight", true);
    }

    private static Object getNoCase(Map<String, Object> saved, String name) {
        for (Map.Entry<String, Object> e : saved.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(name)) continue;
            return e.getValue();
        }
        return null;
    }

    public String listSavedStates() {
        String names = "";
        for (String name : this.saved.keySet()) {
            names = names + "\n" + name;
        }
        return names;
    }

    private void deleteSavedType(String type) {
        Iterator<String> e = this.saved.keySet().iterator();
        while (e.hasNext()) {
            if (!e.next().startsWith(type)) continue;
            e.remove();
        }
    }

    public void deleteSaved(String namelike) {
        Iterator<String> e = this.saved.keySet().iterator();
        while (e.hasNext()) {
            String name = e.next();
            if (!name.startsWith(namelike) && (!name.endsWith("_" + namelike) || name.indexOf("_") != name.lastIndexOf("_" + namelike))) continue;
            e.remove();
        }
    }

    public void saveSelection(String saveName, BS bsSelected) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Selected_");
            return;
        }
        saveName = this.lastSelected = "Selected_" + saveName;
        this.saved.put(saveName, BSUtil.copy(bsSelected));
    }

    public boolean restoreSelection(String saveName) {
        String name = saveName.length() > 0 ? "Selected_" + saveName : this.lastSelected;
        BS bsSelected = (BS)StateManager.getNoCase(this.saved, name);
        if (bsSelected == null) {
            this.vwr.selectStatus(new BS(), false, 0, false, false);
            return false;
        }
        this.vwr.selectStatus(bsSelected, false, 0, false, false);
        return true;
    }

    public void saveState(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("State_");
            this.clearStateStack();
            return;
        }
        if (saveName.length() == 0) {
            this.vwr.setBooleanProperty("undoAuto", false);
            this.appendState(this.getStack(603984065));
            this.redoStateStack.clear();
            return;
        }
        saveName = this.lastState = "State_" + saveName;
        this.saved.put(saveName, this.vwr.getStateInfo());
    }

    public String getSavedState(String saveName) {
        if (saveName.length() == 0) {
            Lst<String> stack = this.getStack(603984065);
            return stack.size() > 0 ? (String)stack.get(stack.size() - 1) : null;
        }
        String name = saveName.length() > 0 ? "State_" + saveName : this.lastState;
        String script = (String)StateManager.getNoCase(this.saved, name);
        return script == null ? "" : script;
    }

    public String popStack(int type) {
        String state;
        Lst<String> stack = this.getStack(type);
        String string = state = stack.size() > 0 ? stack.remove(stack.size() - 1) : null;
        if (state != null) {
            this.appendState(this.getStack(type == 603984065 ? 4139 : 603984065));
        }
        this.checkStack(this.getStack(603984065));
        return state;
    }

    private void appendState(Lst<String> stack) {
        this.checkStack(stack);
        if (this.maxUndo > 0) {
            stack.addLast(this.vwr.getStateInfo());
        }
    }

    private void checkStack(Lst<String> stack) {
        while (stack.size() > this.maxUndo) {
            stack.removeItemAt(0);
        }
    }

    private Lst<String> getStack(int type) {
        if (this.undoStateStack == null) {
            this.undoStateStack = new Lst();
            this.redoStateStack = new Lst();
        }
        return type == 603984065 ? this.undoStateStack : this.redoStateStack;
    }

    private void clearStateStack() {
        if (this.undoStateStack == null) {
            return;
        }
        this.undoStateStack.clear();
        this.redoStateStack.clear();
    }

    public void saveStructure(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Shape_");
            return;
        }
        saveName = this.lastShape = "Shape_" + saveName;
        this.saved.put(saveName, this.vwr.getStructureState());
    }

    public String getSavedStructure(String saveName) {
        String name = saveName.length() > 0 ? "Shape_" + saveName : this.lastShape;
        String script = (String)StateManager.getNoCase(this.saved, name);
        return script == null ? "" : script;
    }

    public void saveCoordinates(String saveName, BS bsSelected) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Coordinates_");
            return;
        }
        saveName = this.lastCoordinates = "Coordinates_" + saveName;
        this.saved.put(saveName, this.vwr.getCoordinateState(bsSelected));
    }

    public String getSavedCoordinates(String saveName) {
        String name = saveName.length() > 0 ? "Coordinates_" + saveName : this.lastCoordinates;
        String script = (String)StateManager.getNoCase(this.saved, name);
        return script == null ? "" : script;
    }

    Orientation getOrientation() {
        return new Orientation(this.vwr, false, null);
    }

    String getSavedOrientationText(String saveName) {
        if (saveName != null) {
            Orientation o = this.getOrientationFor(saveName);
            return o == null ? "" : o.getMoveToText(true);
        }
        SB sb = new SB();
        for (Map.Entry<String, Object> e : this.saved.entrySet()) {
            String name = e.getKey();
            if (!name.startsWith("Orientation_")) continue;
            sb.append(((Orientation)e.getValue()).getMoveToText(true));
        }
        return sb.toString();
    }

    public void saveScene(String saveName, Map<String, Object> scene) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Scene_");
            return;
        }
        Scene o = new Scene(scene);
        o.saveName = this.lastScene = "Scene_" + saveName;
        this.saved.put(o.saveName, o);
    }

    public boolean restoreScene(String saveName, float timeSeconds) {
        Scene o = (Scene)StateManager.getNoCase(this.saved, saveName.length() > 0 ? "Scene_" + saveName : this.lastScene);
        return o != null && o.restore(this.vwr, timeSeconds);
    }

    public void saveOrientation(String saveName, float[] pymolView) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Orientation_");
            return;
        }
        Orientation o = new Orientation(this.vwr, saveName.equalsIgnoreCase("default"), pymolView);
        o.saveName = this.lastOrientation = "Orientation_" + saveName;
        this.saved.put(o.saveName, o);
    }

    public boolean restoreOrientation(String saveName, float timeSeconds, boolean isAll) {
        Orientation o = this.getOrientationFor(saveName);
        return o != null && o.restore(timeSeconds, isAll);
    }

    private Orientation getOrientationFor(String saveName) {
        String name = saveName.length() > 0 ? "Orientation_" + saveName : this.lastOrientation;
        return (Orientation)StateManager.getNoCase(this.saved, name);
    }

    public void saveContext(String saveName, Object context) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Context_");
            return;
        }
        this.lastContext = "Context_" + saveName;
        this.saved.put(this.lastContext, context);
    }

    public Object getContext(String saveName) {
        return this.saved.get(saveName.length() == 0 ? this.lastContext : "Context_" + saveName);
    }

    public void saveBonds(String saveName) {
        if (saveName.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Bonds_");
            return;
        }
        Connections b = new Connections(this.vwr);
        b.saveName = this.lastConnections = "Bonds_" + saveName;
        this.saved.put(b.saveName, b);
    }

    public boolean restoreBonds(String saveName) {
        this.vwr.clearModelDependentObjects();
        String name = saveName.length() > 0 ? "Bonds_" + saveName : this.lastConnections;
        Connections c = (Connections)StateManager.getNoCase(this.saved, name);
        return c != null && c.restore();
    }

    public static String varClip(String name, String sv, int nMax) {
        if (nMax > 0 && sv.length() > nMax) {
            sv = sv.substring(0, nMax) + " #...more (" + sv.length() + " bytes -- use SHOW " + name + " or MESSAGE @" + name + " to view)";
        }
        return sv;
    }

    public int getUndoMax() {
        return this.maxUndo;
    }

    public void setUndoMax(int n) {
        this.maxUndo = Math.max(n, 0);
        this.checkStack(this.getStack(603984065));
        this.checkStack(this.getStack(4139));
    }

    public String getUndoRedoState(int tok) {
        return this.popStack(tok);
    }

    public boolean canDo(int type) {
        return this.maxUndo > 0 && this.vwr.getBoolean(603979898) && !this.getStack(type).isEmpty();
    }

    public String getUndoInfo() {
        boolean auto = this.vwr.getBooleanProperty("undoAuto");
        return this.vwr.getBoolean(603979898) ? "undoAuto=" + auto + (!auto ? "; user stack sizes: UNDO=" + this.getStack(603984065).size() + ", REDO=" + this.getStack(4139).size() : "") : "SET preserveState = FALSE -- undo/redo is disabled";
    }
}

