/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.load.TextFileLoader;

public class PasteCoordinateList
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextArea _coordArea = null;
    private JButton _okButton = null;

    public PasteCoordinateList(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.pastecoordinatelist";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._coordArea.setText("");
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pastecoordinatelist.desc")), "North");
        this._coordArea = new JTextArea(8, 35);
        this._coordArea.setLineWrap(true);
        this._coordArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this._coordArea);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PasteCoordinateList.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    PasteCoordinateList.this._dialog.dispose();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PasteCoordinateList.this.enableOK();
            }
        };
        this._coordArea.addKeyListener(keyAdapter);
        this._coordArea.addMouseListener(mouseAdapter);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PasteCoordinateList.this._okButton.isEnabled()) {
                    PasteCoordinateList.this.finish();
                }
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel2.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasteCoordinateList.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        String string = this._coordArea.getText();
        this._okButton.setEnabled(string != null && string.length() > 6 && (string.indexOf(32) >= 0 || string.indexOf(44) >= 0));
    }

    private void finish() {
        new TextFileLoader(this._app, this._parentFrame).loadText(this._coordArea.getText());
        this._dialog.dispose();
    }
}

