/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.general.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.columns.merge.AttributeColumnsMergeStrategy;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.components.richtooltip.RichTooltip;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MergeColumnsUI
extends JPanel {
    private final DefaultListModel availableColumnsModel;
    private final DefaultListModel columnsToMergeModel;
    private JButton okButton;
    private Mode mode = Mode.NODES_TABLE;
    private Table table;
    private AttributeColumnsMergeStrategy[] availableMergeStrategies;
    private JButton addColumnButton;
    private JLabel availableColumnsLabel;
    private JList availableColumnsList;
    private JComboBox availableStrategiesComboBox;
    private JLabel availableStrategiesLabel;
    private JLabel columnsToMergeLabel;
    private JList columnsToMergeList;
    private JLabel description;
    private JLabel infoLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton removeColumnButton;

    public MergeColumnsUI() {
        this.initComponents();
        this.infoLabel.addMouseListener(new MouseAdapter(){
            RichTooltip richTooltip;

            @Override
            public void mouseEntered(MouseEvent e) {
                int index = MergeColumnsUI.this.availableStrategiesComboBox.getSelectedIndex();
                if (MergeColumnsUI.this.infoLabel.isEnabled() && index != -1) {
                    this.richTooltip = this.buildTooltip(MergeColumnsUI.this.availableMergeStrategies[index]);
                }
                if (this.richTooltip != null) {
                    this.richTooltip.showTooltip((JComponent)MergeColumnsUI.this.infoLabel);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.richTooltip != null) {
                    this.richTooltip.hideTooltip();
                    this.richTooltip = null;
                }
            }

            private RichTooltip buildTooltip(AttributeColumnsMergeStrategy strategy) {
                if (strategy.getDescription() != null && !strategy.getDescription().isEmpty()) {
                    RichTooltip tooltip = new RichTooltip(strategy.getName(), strategy.getDescription());
                    if (strategy.getIcon() != null) {
                        tooltip.setMainImage(ImageUtilities.icon2Image((Icon)strategy.getIcon()));
                    }
                    return tooltip;
                }
                return null;
            }
        });
        this.availableColumnsModel = new DefaultListModel();
        this.columnsToMergeModel = new DefaultListModel();
        this.columnsToMergeModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                MergeColumnsUI.this.refreshAvailableMergeStrategies();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MergeColumnsUI.this.refreshAvailableMergeStrategies();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MergeColumnsUI.this.refreshAvailableMergeStrategies();
            }
        });
    }

    public static ValidationPanel createValidationPanel(MergeColumnsUI innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        if (innerPanel == null) {
            innerPanel = new MergeColumnsUI();
        }
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add(innerPanel.availableStrategiesComboBox, (Validator)new MergeStrategyValidator(innerPanel));
        return validationPanel;
    }

    private void loadColumns() {
        Column[] columns;
        this.availableColumnsModel.clear();
        this.columnsToMergeModel.clear();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        if (this.mode == Mode.NODES_TABLE) {
            this.table = am.getNodeTable();
            columns = this.table.toArray();
        } else {
            this.table = am.getEdgeTable();
            columns = this.table.toArray();
        }
        for (Column column : columns) {
            this.availableColumnsModel.addElement(new ColumnWrapper(column));
        }
        this.availableColumnsList.setModel(this.availableColumnsModel);
        this.columnsToMergeList.setModel(this.columnsToMergeModel);
    }

    private void refreshAvailableMergeStrategies() {
        int selectedStrategyIndex = this.availableStrategiesComboBox.getSelectedIndex();
        this.availableStrategiesComboBox.removeAllItems();
        Column[] columnsToMerge = this.getColumnsToMerge();
        if (columnsToMerge.length < 1) {
            return;
        }
        AttributeColumnsMergeStrategy[] strategies = DataLaboratoryHelper.getDefault().getAttributeColumnsMergeStrategies();
        ArrayList<AttributeColumnsMergeStrategy> availableStrategiesList = new ArrayList<AttributeColumnsMergeStrategy>();
        for (AttributeColumnsMergeStrategy strategy : strategies) {
            strategy.setup(this.table, columnsToMerge);
            availableStrategiesList.add(strategy);
        }
        this.availableMergeStrategies = availableStrategiesList.toArray(new AttributeColumnsMergeStrategy[0]);
        for (AttributeColumnsMergeStrategy s : this.availableMergeStrategies) {
            this.availableStrategiesComboBox.addItem(s.getName());
        }
        if (selectedStrategyIndex >= 0 && selectedStrategyIndex < this.availableStrategiesComboBox.getItemCount()) {
            this.availableStrategiesComboBox.setSelectedIndex(selectedStrategyIndex);
        }
    }

    private void refreshOkButton() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.canExecuteSelectedStrategy());
        }
    }

    public boolean canExecuteSelectedStrategy() {
        int index = this.availableStrategiesComboBox.getSelectedIndex();
        boolean result = index != -1 ? this.availableMergeStrategies[index].canExecute() : false;
        return result;
    }

    private Column[] getColumnsToMerge() {
        Object[] elements = this.columnsToMergeModel.toArray();
        Column[] columns = new Column[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            columns[i] = ((ColumnWrapper)elements[i]).getColumn();
        }
        return columns;
    }

    public void setup(Mode mode) {
        this.mode = mode;
        this.loadColumns();
    }

    public void execute() {
        int index = this.availableStrategiesComboBox.getSelectedIndex();
        if (index != -1) {
            DataLaboratoryHelper.getDefault().executeManipulator((Manipulator)this.availableMergeStrategies[index]);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.title");
    }

    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
        this.refreshOkButton();
    }

    private void moveElementsFromListToOtherList(JList sourceList, JList targetList) {
        Object[] selection;
        DefaultListModel sourceModel = (DefaultListModel)sourceList.getModel();
        DefaultListModel targetModel = (DefaultListModel)targetList.getModel();
        for (Object element : selection = sourceList.getSelectedValues()) {
            sourceModel.removeElement(element);
            targetModel.addElement(element);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.columnsToMergeList = new JList();
        this.description = new JLabel();
        this.addColumnButton = new JButton();
        this.removeColumnButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.availableColumnsList = new JList();
        this.availableColumnsLabel = new JLabel();
        this.columnsToMergeLabel = new JLabel();
        this.availableStrategiesLabel = new JLabel();
        this.availableStrategiesComboBox = new JComboBox();
        this.infoLabel = new JLabel();
        this.columnsToMergeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MergeColumnsUI.this.columnsToMergeListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.columnsToMergeList);
        this.description.setHorizontalAlignment(0);
        this.description.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.description.text"));
        this.addColumnButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/datalab/resources/arrow.png")));
        this.addColumnButton.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.addColumnButton.text"));
        this.addColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeColumnsUI.this.addColumnButtonActionPerformed(evt);
            }
        });
        this.removeColumnButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/datalab/resources/arrow-180.png")));
        this.removeColumnButton.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.removeColumnButton.text"));
        this.removeColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeColumnsUI.this.removeColumnButtonActionPerformed(evt);
            }
        });
        this.availableColumnsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MergeColumnsUI.this.availableColumnsListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.availableColumnsList);
        this.availableColumnsLabel.setHorizontalAlignment(0);
        this.availableColumnsLabel.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.availableColumnsLabel.text"));
        this.columnsToMergeLabel.setHorizontalAlignment(0);
        this.columnsToMergeLabel.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.columnsToMergeLabel.text"));
        this.availableStrategiesLabel.setHorizontalAlignment(0);
        this.availableStrategiesLabel.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.availableStrategiesLabel.text"));
        this.availableStrategiesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MergeColumnsUI.this.availableStrategiesComboBoxItemStateChanged(evt);
            }
        });
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/datalab/resources/info.png")));
        this.infoLabel.setText(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.infoLabel.text"));
        this.infoLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.description, -1, 394, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availableColumnsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addComponent(this.availableStrategiesLabel, -1, 152, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addColumnButton).addComponent(this.removeColumnButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.columnsToMergeLabel, -1, 149, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 153, Short.MAX_VALUE))).addGap(30, 30, 30)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.availableStrategiesComboBox, 0, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addContainerGap()))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.description, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availableColumnsLabel).addComponent(this.columnsToMergeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 204, -2).addComponent(this.jScrollPane1, -2, 204, -2)).addGap(12, 12, 12)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.addColumnButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeColumnButton).addGap(94, 94, 94))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availableStrategiesComboBox, GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel, -2, 20, -2).addComponent(this.availableStrategiesLabel)).addContainerGap()));
    }

    private void addColumnButtonActionPerformed(ActionEvent evt) {
        this.moveElementsFromListToOtherList(this.availableColumnsList, this.columnsToMergeList);
    }

    private void removeColumnButtonActionPerformed(ActionEvent evt) {
        this.moveElementsFromListToOtherList(this.columnsToMergeList, this.availableColumnsList);
    }

    private void availableStrategiesComboBoxItemStateChanged(ItemEvent evt) {
        this.refreshOkButton();
        this.infoLabel.setEnabled(this.availableStrategiesComboBox.getSelectedIndex() != -1);
    }

    private void availableColumnsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.availableColumnsList.locationToIndex(evt.getPoint());
            this.availableColumnsList.setSelectedIndex(index);
            this.moveElementsFromListToOtherList(this.availableColumnsList, this.columnsToMergeList);
        }
    }

    private void columnsToMergeListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.columnsToMergeList.locationToIndex(evt.getPoint());
            this.columnsToMergeList.setSelectedIndex(index);
            this.moveElementsFromListToOtherList(this.columnsToMergeList, this.availableColumnsList);
        }
    }

    class ColumnWrapper {
        private Column column;

        public ColumnWrapper(Column column) {
            this.column = column;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
            this.column = column;
        }

        public String toString() {
            return this.column.getTitle() + " -- " + this.column.getTypeClass().getSimpleName();
        }
    }

    private static class MergeStrategyValidator
    implements Validator<ComboBoxModel> {
        private final MergeColumnsUI ui;

        public MergeStrategyValidator(MergeColumnsUI ui) {
            this.ui = ui;
        }

        public boolean validate(Problems problems, String string, ComboBoxModel t) {
            if (t.getSelectedItem() != null) {
                if (this.ui.canExecuteSelectedStrategy()) {
                    return true;
                }
                problems.add(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.problems.not_executable_strategy"));
                return false;
            }
            problems.add(NbBundle.getMessage(MergeColumnsUI.class, (String)"MergeColumnsUI.problems.less_than_2_columns_selected"));
            return false;
        }
    }

    public static enum Mode {
        NODES_TABLE,
        EDGES_TABLE;

    }
}

