/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyCycle;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.impl.collect.NodeStack;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

final class DefaultDependencyCycle
implements DependencyCycle {
    private final List<Dependency> dependencies;
    private final int cycleEntry;

    DefaultDependencyCycle(NodeStack nodes2, int cycleEntry, Dependency dependency) {
        int offset = cycleEntry > 0 && nodes2.get(0).getDependency() == null ? 1 : 0;
        Dependency[] dependencies = new Dependency[nodes2.size() - offset + 1];
        int n = dependencies.length - 1;
        for (int i = 0; i < n; ++i) {
            DependencyNode node2 = nodes2.get(i + offset);
            dependencies[i] = node2.getDependency();
            if (dependencies[i] != null) continue;
            dependencies[i] = new Dependency(node2.getArtifact(), null);
        }
        dependencies[dependencies.length - 1] = dependency;
        this.dependencies = Collections.unmodifiableList(Arrays.asList(dependencies));
        this.cycleEntry = cycleEntry;
    }

    @Override
    public List<Dependency> getPrecedingDependencies() {
        return this.dependencies.subList(0, this.cycleEntry);
    }

    @Override
    public List<Dependency> getCyclicDependencies() {
        return this.dependencies.subList(this.cycleEntry, this.dependencies.size());
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder(256);
        int n = this.dependencies.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buffer2.append(" -> ");
            }
            buffer2.append(ArtifactIdUtils.toVersionlessId(this.dependencies.get(i).getArtifact()));
        }
        return buffer2.toString();
    }
}

