/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key2, Object value) {
        if (key2 == null) {
            String string2 = String.valueOf(value);
            throw new NullPointerException(new StringBuilder(24 + String.valueOf(string2).length()).append("null key in entry: null=").append(string2).toString());
        }
        if (value == null) {
            String string3 = String.valueOf(key2);
            throw new NullPointerException(new StringBuilder(26 + String.valueOf(string3).length()).append("null value in entry: ").append(string3).append("=null").toString());
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name2) {
        if (value < 0) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(name2).length()).append(name2).append(" cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name2) {
        if (value < 0L) {
            throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(name2).length()).append(name2).append(" cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    static void checkPositive(int value, String name2) {
        if (value <= 0) {
            throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(name2).length()).append(name2).append(" must be positive but was: ").append(value).toString());
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

