/* wm.c generated by valac 0.56.0, the Vala compiler
 * generated from wm.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <meta/main.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <meta/meta-plugin.h>
#include <meta/meta-background-group.h>
#include <meta/meta-window-actor.h>
#include <meta/window.h>
#include <meta/workspace.h>
#include <graphene-gobject.h>
#include <glib/gstdio.h>
#include <meta/meta-background.h>
#include <meta/display.h>
#include <meta/util.h>
#include <cogl/cogl.h>
#include <meta/compositor-mutter.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-backend.h>
#include <meta/meta-settings.h>
#include <budgie-config.h>

#define BUDGIE_MUTTER_EDGE_TILING "edge-tiling"
#define BUDGIE_MUTTER_MODAL_ATTACH "attach-modal-dialogs"
#define BUDGIE_MUTTER_BUTTON_LAYOUT "button-layout"
#define BUDGIE_EXPERIMENTAL_DIALOG "experimental-enable-run-dialog-as-menu"
#define BUDGIE_WM_FORCE_UNREDIRECT "force-unredirect"
#define BUDGIE_WM_SCHEMA "com.solus-project.budgie-wm"
#define BUDGIE_CLUTTER_EVENT_PROPAGATE FALSE
#define BUDGIE_CLUTTER_EVENT_STOP TRUE
#define BUDGIE_RAVEN_DBUS_NAME "org.budgie_desktop.Raven"
#define BUDGIE_RAVEN_DBUS_OBJECT_PATH "/org/budgie_desktop/Raven"
#define BUDGIE_PANEL_DBUS_NAME "org.budgie_desktop.Panel"
#define BUDGIE_PANEL_DBUS_OBJECT_PATH "/org/budgie_desktop/Panel"
#define BUDGIE_LOGIND_DBUS_NAME "org.freedesktop.login1"
#define BUDGIE_LOGIND_DBUS_OBJECT_PATH "/org/freedesktop/login1"
#define BUDGIE_MENU_DBUS_NAME "org.budgie_desktop.MenuManager"
#define BUDGIE_MENU_DBUS_OBJECT_PATH "/org/budgie_desktop/MenuManager"
#define BUDGIE_SWITCHER_DBUS_NAME "org.budgie_desktop.TabSwitcher"
#define BUDGIE_SWITCHER_DBUS_OBJECT_PATH "/org/budgie_desktop/TabSwitcher"
#define BUDGIE_BUDGIE_WM_GL_VENDOR ((guint) 0x1F00)
#define BUDGIE_BUDGIE_WM_MAP_TIMEOUT 100
#define BUDGIE_BUDGIE_WM_MENU_MAP_TIMEOUT 120
#define BUDGIE_BUDGIE_WM_MAP_SCALE 0.94f
#define BUDGIE_BUDGIE_WM_MENU_MAP_SCALE_X 0.98f
#define BUDGIE_BUDGIE_WM_MENU_MAP_SCALE_Y 0.95f
#define BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_X 0.5f
#define BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_Y 0.8f
#define BUDGIE_BUDGIE_WM_FADE_TIMEOUT 145
#define BUDGIE_BUDGIE_WM_MINIMIZE_TIMEOUT 225
#define BUDGIE_BUDGIE_WM_UNMINIMIZE_TIMEOUT 200
#define BUDGIE_BUDGIE_WM_DESTROY_TIMEOUT 120
#define BUDGIE_BUDGIE_WM_DESTROY_SCALE 0.88
#define BUDGIE_BUDGIE_WM_MAX_TAB_ELAPSE ((guint32) 2000)
#define BUDGIE_BUDGIE_WM_SWITCH_TIMEOUT 250
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BUDGIE_PANEL_ACTION_NONE = 1 << 0,
	BUDGIE_PANEL_ACTION_MENU = 1 << 1,
	BUDGIE_PANEL_ACTION_MAX = 1 << 2
} BudgiePanelAction;

#define BUDGIE_TYPE_PANEL_ACTION (budgie_panel_action_get_type ())
typedef enum  {
	BUDGIE_ANIMATION_STATE_MAP = 1 << 0,
	BUDGIE_ANIMATION_STATE_MINIMIZE = 1 << 1,
	BUDGIE_ANIMATION_STATE_UNMINIMIZE = 1 << 2,
	BUDGIE_ANIMATION_STATE_DESTROY = 1 << 3
} BudgieAnimationState;

#define BUDGIE_TYPE_ANIMATION_STATE (budgie_animation_state_get_type ())

#define BUDGIE_TYPE_SCREEN_TILE_PREVIEW (budgie_screen_tile_preview_get_type ())
#define BUDGIE_SCREEN_TILE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREEN_TILE_PREVIEW, BudgieScreenTilePreview))
#define BUDGIE_SCREEN_TILE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREEN_TILE_PREVIEW, BudgieScreenTilePreviewClass))
#define BUDGIE_IS_SCREEN_TILE_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREEN_TILE_PREVIEW))
#define BUDGIE_IS_SCREEN_TILE_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREEN_TILE_PREVIEW))
#define BUDGIE_SCREEN_TILE_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREEN_TILE_PREVIEW, BudgieScreenTilePreviewClass))

typedef struct _BudgieScreenTilePreview BudgieScreenTilePreview;
typedef struct _BudgieScreenTilePreviewClass BudgieScreenTilePreviewClass;
typedef struct _BudgieScreenTilePreviewPrivate BudgieScreenTilePreviewPrivate;
enum  {
	BUDGIE_SCREEN_TILE_PREVIEW_0_PROPERTY,
	BUDGIE_SCREEN_TILE_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* budgie_screen_tile_preview_properties[BUDGIE_SCREEN_TILE_PREVIEW_NUM_PROPERTIES];

#define BUDGIE_TYPE_RAVEN_REMOTE (budgie_raven_remote_get_type ())
#define BUDGIE_RAVEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_REMOTE, BudgieRavenRemote))
#define BUDGIE_IS_RAVEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_REMOTE))
#define BUDGIE_RAVEN_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_RAVEN_REMOTE, BudgieRavenRemoteIface))

typedef struct _BudgieRavenRemote BudgieRavenRemote;
typedef struct _BudgieRavenRemoteIface BudgieRavenRemoteIface;

#define BUDGIE_TYPE_RAVEN_REMOTE_PROXY (budgie_raven_remote_proxy_get_type ())
typedef GDBusProxy BudgieRavenRemoteProxy;
typedef GDBusProxyClass BudgieRavenRemoteProxyClass;
typedef struct _budgie_raven_remote_ToggleReadyData budgie_raven_remote_ToggleReadyData;
typedef struct _budgie_raven_remote_ToggleNotificationsViewReadyData budgie_raven_remote_ToggleNotificationsViewReadyData;
typedef struct _budgie_raven_remote_ClearNotificationsReadyData budgie_raven_remote_ClearNotificationsReadyData;
typedef struct _budgie_raven_remote_ToggleAppletViewReadyData budgie_raven_remote_ToggleAppletViewReadyData;
typedef struct _budgie_raven_remote_DismissReadyData budgie_raven_remote_DismissReadyData;

#define BUDGIE_TYPE_PANEL_REMOTE (budgie_panel_remote_get_type ())
#define BUDGIE_PANEL_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_REMOTE, BudgiePanelRemote))
#define BUDGIE_IS_PANEL_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_REMOTE))
#define BUDGIE_PANEL_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_PANEL_REMOTE, BudgiePanelRemoteIface))

typedef struct _BudgiePanelRemote BudgiePanelRemote;
typedef struct _BudgiePanelRemoteIface BudgiePanelRemoteIface;

#define BUDGIE_TYPE_PANEL_REMOTE_PROXY (budgie_panel_remote_proxy_get_type ())
typedef GDBusProxy BudgiePanelRemoteProxy;
typedef GDBusProxyClass BudgiePanelRemoteProxyClass;
typedef struct _budgie_panel_remote_ActivateActionReadyData budgie_panel_remote_ActivateActionReadyData;

#define BUDGIE_TYPE_LOGIN_DREMOTE (budgie_login_dremote_get_type ())
#define BUDGIE_LOGIN_DREMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_LOGIN_DREMOTE, BudgieLoginDRemote))
#define BUDGIE_IS_LOGIN_DREMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_LOGIN_DREMOTE))
#define BUDGIE_LOGIN_DREMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_LOGIN_DREMOTE, BudgieLoginDRemoteIface))

typedef struct _BudgieLoginDRemote BudgieLoginDRemote;
typedef struct _BudgieLoginDRemoteIface BudgieLoginDRemoteIface;

#define BUDGIE_TYPE_LOGIN_DREMOTE_PROXY (budgie_login_dremote_proxy_get_type ())
enum  {
	BUDGIE_LOGIN_DREMOTE_PREPARE_FOR_SLEEP_SIGNAL,
	BUDGIE_LOGIN_DREMOTE_NUM_SIGNALS
};
static guint budgie_login_dremote_signals[BUDGIE_LOGIN_DREMOTE_NUM_SIGNALS] = {0};
typedef GDBusProxy BudgieLoginDRemoteProxy;
typedef GDBusProxyClass BudgieLoginDRemoteProxyClass;

#define BUDGIE_TYPE_MENU_MANAGER (budgie_menu_manager_get_type ())
#define BUDGIE_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManager))
#define BUDGIE_IS_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MENU_MANAGER))
#define BUDGIE_MENU_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManagerIface))

typedef struct _BudgieMenuManager BudgieMenuManager;
typedef struct _BudgieMenuManagerIface BudgieMenuManagerIface;

#define BUDGIE_TYPE_MENU_MANAGER_PROXY (budgie_menu_manager_proxy_get_type ())
typedef GDBusProxy BudgieMenuManagerProxy;
typedef GDBusProxyClass BudgieMenuManagerProxyClass;
typedef struct _budgie_menu_manager_ShowDesktopMenuReadyData budgie_menu_manager_ShowDesktopMenuReadyData;
typedef struct _budgie_menu_manager_ShowWindowMenuReadyData budgie_menu_manager_ShowWindowMenuReadyData;

#define BUDGIE_TYPE_SWITCHER (budgie_switcher_get_type ())
#define BUDGIE_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SWITCHER, BudgieSwitcher))
#define BUDGIE_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SWITCHER))
#define BUDGIE_SWITCHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SWITCHER, BudgieSwitcherIface))

typedef struct _BudgieSwitcher BudgieSwitcher;
typedef struct _BudgieSwitcherIface BudgieSwitcherIface;

#define BUDGIE_TYPE_SWITCHER_PROXY (budgie_switcher_proxy_get_type ())
typedef GDBusProxy BudgieSwitcherProxy;
typedef GDBusProxyClass BudgieSwitcherProxyClass;
typedef struct _budgie_switcher_PassItemReadyData budgie_switcher_PassItemReadyData;
typedef struct _budgie_switcher_ShowSwitcherReadyData budgie_switcher_ShowSwitcherReadyData;
typedef struct _budgie_switcher_StopSwitcherReadyData budgie_switcher_StopSwitcherReadyData;

#define BUDGIE_TYPE_MINIMIZE_DATA (budgie_minimize_data_get_type ())
#define BUDGIE_MINIMIZE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MINIMIZE_DATA, BudgieMinimizeData))
#define BUDGIE_MINIMIZE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_MINIMIZE_DATA, BudgieMinimizeDataClass))
#define BUDGIE_IS_MINIMIZE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MINIMIZE_DATA))
#define BUDGIE_IS_MINIMIZE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_MINIMIZE_DATA))
#define BUDGIE_MINIMIZE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_MINIMIZE_DATA, BudgieMinimizeDataClass))

typedef struct _BudgieMinimizeData BudgieMinimizeData;
typedef struct _BudgieMinimizeDataClass BudgieMinimizeDataClass;
typedef struct _BudgieMinimizeDataPrivate BudgieMinimizeDataPrivate;
typedef struct _BudgieParamSpecMinimizeData BudgieParamSpecMinimizeData;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;
typedef struct _BudgieBudgieWMPrivate BudgieBudgieWMPrivate;

#define BUDGIE_TYPE_KEYBOARD_MANAGER (budgie_keyboard_manager_get_type ())
#define BUDGIE_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager))
#define BUDGIE_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))
#define BUDGIE_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))

typedef struct _BudgieKeyboardManager BudgieKeyboardManager;
typedef struct _BudgieKeyboardManagerClass BudgieKeyboardManagerClass;

#define BUDGIE_TYPE_SHELL_SHIM (budgie_shell_shim_get_type ())
#define BUDGIE_SHELL_SHIM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShim))
#define BUDGIE_SHELL_SHIM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShimClass))
#define BUDGIE_IS_SHELL_SHIM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SHELL_SHIM))
#define BUDGIE_IS_SHELL_SHIM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SHELL_SHIM))
#define BUDGIE_SHELL_SHIM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShimClass))

typedef struct _BudgieShellShim BudgieShellShim;
typedef struct _BudgieShellShimClass BudgieShellShimClass;

#define BUDGIE_TYPE_BUDGIE_WMDBUS (budgie_budgie_wmdbus_get_type ())
#define BUDGIE_BUDGIE_WMDBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WMDBUS, BudgieBudgieWMDBUS))
#define BUDGIE_BUDGIE_WMDBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WMDBUS, BudgieBudgieWMDBUSClass))
#define BUDGIE_IS_BUDGIE_WMDBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WMDBUS))
#define BUDGIE_IS_BUDGIE_WMDBUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WMDBUS))
#define BUDGIE_BUDGIE_WMDBUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WMDBUS, BudgieBudgieWMDBUSClass))

typedef struct _BudgieBudgieWMDBUS BudgieBudgieWMDBUS;
typedef struct _BudgieBudgieWMDBUSClass BudgieBudgieWMDBUSClass;
enum  {
	BUDGIE_BUDGIE_WM_0_PROPERTY,
	BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY,
	BUDGIE_BUDGIE_WM_NUM_PROPERTIES
};
static GParamSpec* budgie_budgie_wm_properties[BUDGIE_BUDGIE_WM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef const gchar* (*BudgieBudgieWMGlQueryFunc) (guint id, gpointer user_data);
typedef struct _Block4Data Block4Data;

#define BUDGIE_TYPE_BUDGIE_BACKGROUND (budgie_budgie_background_get_type ())
#define BUDGIE_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground))
#define BUDGIE_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))
#define BUDGIE_IS_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_IS_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))

typedef struct _BudgieBudgieBackground BudgieBudgieBackground;
typedef struct _BudgieBudgieBackgroundClass BudgieBudgieBackgroundClass;
#define _budgie_minimize_data_unref0(var) ((var == NULL) ? NULL : (var = (budgie_minimize_data_unref (var), NULL)))
typedef struct _BudgieBudgieWMDBUSPrivate BudgieBudgieWMDBUSPrivate;
enum  {
	BUDGIE_BUDGIE_WMDBUS_0_PROPERTY,
	BUDGIE_BUDGIE_WMDBUS_NUM_PROPERTIES
};
static GParamSpec* budgie_budgie_wmdbus_properties[BUDGIE_BUDGIE_WMDBUS_NUM_PROPERTIES];

struct _BudgieScreenTilePreview {
	ClutterActor parent_instance;
	BudgieScreenTilePreviewPrivate * priv;
	MetaRectangle tile_rect;
};

struct _BudgieScreenTilePreviewClass {
	ClutterActorClass parent_class;
};

struct _BudgieRavenRemoteIface {
	GTypeInterface parent_iface;
	gboolean (*GetExpanded) (BudgieRavenRemote* self, GError** error);
	void (*Toggle) (BudgieRavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Toggle_finish) (BudgieRavenRemote* self, GAsyncResult* _res_, GError** error);
	void (*ToggleNotificationsView) (BudgieRavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ToggleNotificationsView_finish) (BudgieRavenRemote* self, GAsyncResult* _res_, GError** error);
	void (*ClearNotifications) (BudgieRavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ClearNotifications_finish) (BudgieRavenRemote* self, GAsyncResult* _res_, GError** error);
	void (*ToggleAppletView) (BudgieRavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ToggleAppletView_finish) (BudgieRavenRemote* self, GAsyncResult* _res_, GError** error);
	void (*Dismiss) (BudgieRavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Dismiss_finish) (BudgieRavenRemote* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_raven_remote_ToggleReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _budgie_raven_remote_ToggleNotificationsViewReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _budgie_raven_remote_ClearNotificationsReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _budgie_raven_remote_ToggleAppletViewReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _budgie_raven_remote_DismissReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgiePanelRemoteIface {
	GTypeInterface parent_iface;
	void (*ActivateAction) (BudgiePanelRemote* self, gint flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ActivateAction_finish) (BudgiePanelRemote* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_panel_remote_ActivateActionReadyData {
	GDBusMethodInvocation* _invocation_;
	gint flags;
};

struct _BudgieLoginDRemoteIface {
	GTypeInterface parent_iface;
};

struct _BudgieMenuManagerIface {
	GTypeInterface parent_iface;
	void (*ShowDesktopMenu) (BudgieMenuManager* self, guint button, guint32 timestamp, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ShowDesktopMenu_finish) (BudgieMenuManager* self, GAsyncResult* _res_, GError** error);
	void (*ShowWindowMenu) (BudgieMenuManager* self, guint32 xid, guint button, guint32 timestamp, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ShowWindowMenu_finish) (BudgieMenuManager* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_menu_manager_ShowDesktopMenuReadyData {
	GDBusMethodInvocation* _invocation_;
	guint button;
	guint32 timestamp;
};

struct _budgie_menu_manager_ShowWindowMenuReadyData {
	GDBusMethodInvocation* _invocation_;
	guint32 xid;
	guint button;
	guint32 timestamp;
};

struct _BudgieSwitcherIface {
	GTypeInterface parent_iface;
	void (*PassItem) (BudgieSwitcher* self, guint32 xid, guint32 timestamp, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*PassItem_finish) (BudgieSwitcher* self, GAsyncResult* _res_, GError** error);
	void (*ShowSwitcher) (BudgieSwitcher* self, guint32 curr_xid, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ShowSwitcher_finish) (BudgieSwitcher* self, GAsyncResult* _res_, GError** error);
	void (*StopSwitcher) (BudgieSwitcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*StopSwitcher_finish) (BudgieSwitcher* self, GAsyncResult* _res_, GError** error);
};

struct _budgie_switcher_PassItemReadyData {
	GDBusMethodInvocation* _invocation_;
	guint32 xid;
	guint32 timestamp;
};

struct _budgie_switcher_ShowSwitcherReadyData {
	GDBusMethodInvocation* _invocation_;
	guint32 curr_xid;
};

struct _budgie_switcher_StopSwitcherReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgieMinimizeData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieMinimizeDataPrivate * priv;
	gfloat scale_x;
	gfloat scale_y;
	gfloat place_x;
	gfloat place_y;
	gfloat old_x;
	gfloat old_y;
};

struct _BudgieMinimizeDataClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieMinimizeData *self);
};

struct _BudgieParamSpecMinimizeData {
	GParamSpec parent_instance;
};

struct _BudgieBudgieWM {
	MetaPlugin parent_instance;
	BudgieBudgieWMPrivate * priv;
};

struct _BudgieBudgieWMClass {
	MetaPluginClass parent_class;
};

struct _BudgieBudgieWMPrivate {
	gboolean _use_animations;
	MetaBackgroundGroup* background_group;
	BudgieKeyboardManager* keyboard;
	GSettings* settings;
	GSettings* gnome_desktop_prefs;
	BudgieRavenRemote* raven_proxy;
	BudgieShellShim* shim;
	BudgieBudgieWMDBUS* focus_interface;
	BudgiePanelRemote* panel_proxy;
	BudgieLoginDRemote* logind_proxy;
	BudgieMenuManager* menu_proxy;
	BudgieSwitcher* switcher_proxy;
	GSettings* iface_settings;
	gboolean force_unredirect;
	GHashTable* state_map;
	ClutterActor* display_group;
	gboolean enabled_experimental_run_diag_as_menu;
	MetaWindow* focused_window;
	BudgieScreenTilePreview* tile_preview;
	guint8* default_tile_opacity;
	MetaWorkspace* cur_workspace;
	GList* cur_tabs;
	gint cur_index;
	guint32 last_time;
	ClutterActor* out_group;
	ClutterActor* in_group;
};

struct _Block4Data {
	int _ref_count_;
	BudgieBudgieWM* self;
	MetaWindow* window;
};

struct _BudgieBudgieWMDBUS {
	GObject parent_instance;
	BudgieBudgieWMDBUSPrivate * priv;
};

struct _BudgieBudgieWMDBUSClass {
	GObjectClass parent_class;
};

struct _BudgieBudgieWMDBUSPrivate {
	BudgieBudgieWM* wm;
};

static gpointer budgie_screen_tile_preview_parent_class = NULL;
static gpointer budgie_minimize_data_parent_class = NULL;
static gint BudgieBudgieWM_private_offset;
static gpointer budgie_budgie_wm_parent_class = NULL;
static MetaPluginInfo budgie_budgie_wm_info;
static MetaPluginInfo budgie_budgie_wm_info = {0};
VALA_EXTERN gchar** budgie_budgie_wm_old_args;
VALA_EXTERN gint budgie_budgie_wm_old_args_length1;
gchar** budgie_budgie_wm_old_args = NULL;
gint budgie_budgie_wm_old_args_length1 = 0;
VALA_EXTERN gboolean budgie_budgie_wm_wayland;
gboolean budgie_budgie_wm_wayland = FALSE;
static graphene_point_t budgie_budgie_wm_PV_CENTER;
static graphene_point_t budgie_budgie_wm_PV_CENTER = {0};
static graphene_point_t budgie_budgie_wm_PV_NORM;
static graphene_point_t budgie_budgie_wm_PV_NORM = {0};
static gint BudgieBudgieWMDBUS_private_offset;
static gpointer budgie_budgie_wmdbus_parent_class = NULL;

VALA_EXTERN GType budgie_panel_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType budgie_animation_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType budgie_screen_tile_preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenTilePreview, g_object_unref)
VALA_EXTERN BudgieScreenTilePreview* budgie_screen_tile_preview_new (void);
VALA_EXTERN BudgieScreenTilePreview* budgie_screen_tile_preview_construct (GType object_type);
static GObject * budgie_screen_tile_preview_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void budgie_screen_tile_preview_finalize (GObject * obj);
static GType budgie_screen_tile_preview_get_type_once (void);
VALA_EXTERN GType budgie_raven_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_raven_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType budgie_raven_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRavenRemote, g_object_unref)
VALA_EXTERN gboolean budgie_raven_remote_GetExpanded (BudgieRavenRemote* self,
                                          GError** error);
VALA_EXTERN void budgie_raven_remote_Toggle (BudgieRavenRemote* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void budgie_raven_remote_Toggle_finish (BudgieRavenRemote* self,
                                        GAsyncResult* _res_,
                                        GError** error);
VALA_EXTERN void budgie_raven_remote_ToggleNotificationsView (BudgieRavenRemote* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void budgie_raven_remote_ToggleNotificationsView_finish (BudgieRavenRemote* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
VALA_EXTERN void budgie_raven_remote_ClearNotifications (BudgieRavenRemote* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void budgie_raven_remote_ClearNotifications_finish (BudgieRavenRemote* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
VALA_EXTERN void budgie_raven_remote_ToggleAppletView (BudgieRavenRemote* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void budgie_raven_remote_ToggleAppletView_finish (BudgieRavenRemote* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN void budgie_raven_remote_Dismiss (BudgieRavenRemote* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void budgie_raven_remote_Dismiss_finish (BudgieRavenRemote* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static GType budgie_raven_remote_get_type_once (void);
static void budgie_raven_remote_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static gboolean budgie_raven_remote_proxy_GetExpanded (BudgieRavenRemote* self,
                                                GError** error);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_raven_remote_proxy_Toggle_async (BudgieRavenRemote* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void budgie_raven_remote_proxy_Toggle_finish (BudgieRavenRemote* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void budgie_raven_remote_proxy_ToggleNotificationsView_async (BudgieRavenRemote* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void budgie_raven_remote_proxy_ToggleNotificationsView_finish (BudgieRavenRemote* self,
                                                               GAsyncResult* _res_,
                                                               GError** error);
static void budgie_raven_remote_proxy_ClearNotifications_async (BudgieRavenRemote* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static void budgie_raven_remote_proxy_ClearNotifications_finish (BudgieRavenRemote* self,
                                                          GAsyncResult* _res_,
                                                          GError** error);
static void budgie_raven_remote_proxy_ToggleAppletView_async (BudgieRavenRemote* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void budgie_raven_remote_proxy_ToggleAppletView_finish (BudgieRavenRemote* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void budgie_raven_remote_proxy_Dismiss_async (BudgieRavenRemote* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void budgie_raven_remote_proxy_Dismiss_finish (BudgieRavenRemote* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void budgie_raven_remote_proxy_budgie_raven_remote_interface_init (BudgieRavenRemoteIface* iface);
static void _dbus_budgie_raven_remote_GetExpanded (BudgieRavenRemote* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_Toggle (BudgieRavenRemote* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_Toggle_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_);
static void _dbus_budgie_raven_remote_ToggleNotificationsView (BudgieRavenRemote* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_ToggleNotificationsView_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_);
static void _dbus_budgie_raven_remote_ClearNotifications (BudgieRavenRemote* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_ClearNotifications_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_);
static void _dbus_budgie_raven_remote_ToggleAppletView (BudgieRavenRemote* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_ToggleAppletView_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_budgie_raven_remote_Dismiss (BudgieRavenRemote* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_remote_Dismiss_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_);
static void budgie_raven_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_raven_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_raven_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_raven_remote_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_panel_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_panel_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType budgie_panel_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelRemote, g_object_unref)
VALA_EXTERN void budgie_panel_remote_ActivateAction (BudgiePanelRemote* self,
                                         gint flags,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void budgie_panel_remote_ActivateAction_finish (BudgiePanelRemote* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static GType budgie_panel_remote_get_type_once (void);
static void budgie_panel_remote_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void budgie_panel_remote_proxy_ActivateAction_async (BudgiePanelRemote* self,
                                                     gint flags,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void budgie_panel_remote_proxy_ActivateAction_finish (BudgiePanelRemote* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void budgie_panel_remote_proxy_budgie_panel_remote_interface_init (BudgiePanelRemoteIface* iface);
static void _dbus_budgie_panel_remote_ActivateAction (BudgiePanelRemote* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_panel_remote_ActivateAction_ready (GObject * source_object,
                                                     GAsyncResult * _res_,
                                                     gpointer _user_data_);
static void budgie_panel_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_panel_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_panel_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_panel_remote_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_login_dremote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieLoginDRemote, g_object_unref)
VALA_EXTERN GType budgie_login_dremote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_login_dremote_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
static GType budgie_login_dremote_get_type_once (void);
static void budgie_login_dremote_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static void _dbus_handle_budgie_login_dremote_prepare_for_sleep (BudgieLoginDRemote* self,
                                                          GVariant* parameters);
static void budgie_login_dremote_proxy_budgie_login_dremote_interface_init (BudgieLoginDRemoteIface* iface);
static void budgie_login_dremote_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* budgie_login_dremote_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean budgie_login_dremote_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_budgie_login_dremote_prepare_for_sleep (GObject* _sender,
                                                   gboolean suspending,
                                                   gpointer* _data);
static void _budgie_login_dremote_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_menu_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_menu_manager_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType budgie_menu_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieMenuManager, g_object_unref)
VALA_EXTERN void budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                          guint button,
                                          guint32 timestamp,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void budgie_menu_manager_ShowDesktopMenu_finish (BudgieMenuManager* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
VALA_EXTERN void budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                         guint32 xid,
                                         guint button,
                                         guint32 timestamp,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void budgie_menu_manager_ShowWindowMenu_finish (BudgieMenuManager* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static GType budgie_menu_manager_get_type_once (void);
static void budgie_menu_manager_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void budgie_menu_manager_proxy_ShowDesktopMenu_async (BudgieMenuManager* self,
                                                      guint button,
                                                      guint32 timestamp,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void budgie_menu_manager_proxy_ShowDesktopMenu_finish (BudgieMenuManager* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void budgie_menu_manager_proxy_ShowWindowMenu_async (BudgieMenuManager* self,
                                                     guint32 xid,
                                                     guint button,
                                                     guint32 timestamp,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void budgie_menu_manager_proxy_ShowWindowMenu_finish (BudgieMenuManager* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void budgie_menu_manager_proxy_budgie_menu_manager_interface_init (BudgieMenuManagerIface* iface);
static void _dbus_budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_budgie_menu_manager_ShowDesktopMenu_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_);
static void _dbus_budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_menu_manager_ShowWindowMenu_ready (GObject * source_object,
                                                     GAsyncResult * _res_,
                                                     gpointer _user_data_);
static void budgie_menu_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_menu_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_menu_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_menu_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_switcher_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_switcher_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
VALA_EXTERN GType budgie_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSwitcher, g_object_unref)
VALA_EXTERN void budgie_switcher_PassItem (BudgieSwitcher* self,
                               guint32 xid,
                               guint32 timestamp,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void budgie_switcher_PassItem_finish (BudgieSwitcher* self,
                                      GAsyncResult* _res_,
                                      GError** error);
VALA_EXTERN void budgie_switcher_ShowSwitcher (BudgieSwitcher* self,
                                   guint32 curr_xid,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void budgie_switcher_ShowSwitcher_finish (BudgieSwitcher* self,
                                          GAsyncResult* _res_,
                                          GError** error);
VALA_EXTERN void budgie_switcher_StopSwitcher (BudgieSwitcher* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void budgie_switcher_StopSwitcher_finish (BudgieSwitcher* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static GType budgie_switcher_get_type_once (void);
static void budgie_switcher_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters);
static void budgie_switcher_proxy_PassItem_async (BudgieSwitcher* self,
                                           guint32 xid,
                                           guint32 timestamp,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void budgie_switcher_proxy_PassItem_finish (BudgieSwitcher* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void budgie_switcher_proxy_ShowSwitcher_async (BudgieSwitcher* self,
                                               guint32 curr_xid,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void budgie_switcher_proxy_ShowSwitcher_finish (BudgieSwitcher* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void budgie_switcher_proxy_StopSwitcher_async (BudgieSwitcher* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void budgie_switcher_proxy_StopSwitcher_finish (BudgieSwitcher* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static void budgie_switcher_proxy_budgie_switcher_interface_init (BudgieSwitcherIface* iface);
static void _dbus_budgie_switcher_PassItem (BudgieSwitcher* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_budgie_switcher_PassItem_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_budgie_switcher_ShowSwitcher (BudgieSwitcher* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_budgie_switcher_ShowSwitcher_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_);
static void _dbus_budgie_switcher_StopSwitcher (BudgieSwitcher* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_budgie_switcher_StopSwitcher_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_);
static void budgie_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* budgie_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean budgie_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _budgie_switcher_unregister_object (gpointer user_data);
VALA_EXTERN gpointer budgie_minimize_data_ref (gpointer instance);
VALA_EXTERN void budgie_minimize_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_minimize_data (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void budgie_value_set_minimize_data (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void budgie_value_take_minimize_data (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_minimize_data (const GValue* value);
VALA_EXTERN GType budgie_minimize_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieMinimizeData, budgie_minimize_data_unref)
VALA_EXTERN BudgieMinimizeData* budgie_minimize_data_new (gfloat sx,
                                              gfloat sy,
                                              gfloat px,
                                              gfloat py,
                                              gfloat ox,
                                              gfloat oy);
VALA_EXTERN BudgieMinimizeData* budgie_minimize_data_construct (GType object_type,
                                                    gfloat sx,
                                                    gfloat sy,
                                                    gfloat px,
                                                    gfloat py,
                                                    gfloat ox,
                                                    gfloat oy);
static void budgie_minimize_data_finalize (BudgieMinimizeData * obj);
static GType budgie_minimize_data_get_type_once (void);
VALA_EXTERN GType budgie_budgie_wm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieWM, g_object_unref)
VALA_EXTERN GType budgie_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieKeyboardManager, g_object_unref)
VALA_EXTERN GType budgie_shell_shim_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieShellShim, g_object_unref)
VALA_EXTERN guint budgie_shell_shim_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType budgie_budgie_wmdbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieWMDBUS, g_object_unref)
VALA_EXTERN guint budgie_budgie_wmdbus_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
static gboolean budgie_budgie_wm_have_logind (BudgieBudgieWM* self);
static void budgie_budgie_wm_on_raven_get (BudgieBudgieWM* self,
                                    GObject* o,
                                    GAsyncResult* res);
static void budgie_budgie_wm_on_panel_get (BudgieBudgieWM* self,
                                    GObject* o,
                                    GAsyncResult* res);
static void budgie_budgie_wm_lost_panel (BudgieBudgieWM* self);
static void budgie_budgie_wm_has_panel (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_panel_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self);
static void budgie_budgie_wm_on_menu_get (BudgieBudgieWM* self,
                                   GObject* o,
                                   GAsyncResult* res);
static void budgie_budgie_wm_lost_menu (BudgieBudgieWM* self);
static void budgie_budgie_wm_has_menu (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_menu_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void budgie_budgie_wm_on_logind_get (BudgieBudgieWM* self,
                                     GObject* o,
                                     GAsyncResult* res);
static gboolean budgie_budgie_wm_is_nvidia (BudgieBudgieWM* self);
static void budgie_budgie_wm_prepare_for_sleep (BudgieBudgieWM* self,
                                         gboolean suspending);
static void _budgie_budgie_wm_prepare_for_sleep_budgie_login_dremote_prepare_for_sleep (BudgieLoginDRemote* _sender,
                                                                                 gboolean suspending,
                                                                                 gpointer self);
static void budgie_budgie_wm_get_logind (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_logind_get_gasync_ready_callback (GObject* source_object,
                                                            GAsyncResult* res,
                                                            gpointer self);
static void budgie_budgie_wm_lost_switcher (BudgieBudgieWM* self);
static void budgie_budgie_wm_on_switcher_get (BudgieBudgieWM* self,
                                       GObject* o,
                                       GAsyncResult* res);
static void budgie_budgie_wm_has_switcher (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_switcher_get_gasync_ready_callback (GObject* source_object,
                                                              GAsyncResult* res,
                                                              gpointer self);
static void budgie_budgie_wm_on_take_full_screenshot (BudgieBudgieWM* self,
                                               MetaDisplay* display,
                                               MetaWindow* window,
                                               ClutterKeyEvent* event,
                                               MetaKeyBinding* binding);
static void budgie_budgie_wm_on_take_region_screenshot (BudgieBudgieWM* self,
                                                 MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding);
static void budgie_budgie_wm_on_take_window_screenshot (BudgieBudgieWM* self,
                                                 MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding);
static void budgie_budgie_wm_on_raven_notification_clear (BudgieBudgieWM* self,
                                                   MetaDisplay* display,
                                                   MetaWindow* window,
                                                   ClutterKeyEvent* event,
                                                   MetaKeyBinding* binding);
static void budgie_budgie_wm_on_raven_main_toggle (BudgieBudgieWM* self,
                                            MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding);
static void budgie_budgie_wm_on_raven_notification_toggle (BudgieBudgieWM* self,
                                                    MetaDisplay* display,
                                                    MetaWindow* window,
                                                    ClutterKeyEvent* event,
                                                    MetaKeyBinding* binding);
static void budgie_budgie_wm_has_raven (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self);
static void budgie_budgie_wm_lost_raven (BudgieBudgieWM* self);
static MetaPluginInfo* budgie_budgie_wm_real_plugin_info (MetaPlugin* base);
static void budgie_budgie_wm_on_overlay_key (BudgieBudgieWM* self);
static gboolean ___lambda10_ (BudgieBudgieWM* self);
static gboolean ____lambda10__gsource_func (gpointer self);
static void budgie_budgie_wm_launch_menu (BudgieBudgieWM* self,
                                   MetaDisplay* display,
                                   MetaWindow* window,
                                   ClutterKeyEvent* event,
                                   MetaKeyBinding* binding);
static void budgie_budgie_wm_launch_rundialog (BudgieBudgieWM* self,
                                        MetaDisplay* display,
                                        MetaWindow* window,
                                        ClutterKeyEvent* event,
                                        MetaKeyBinding* binding);
static void budgie_budgie_wm_on_dialog_closed (BudgieBudgieWM* self,
                                        GPid pid,
                                        gint status);
static void budgie_budgie_wm_real_confirm_display_change (MetaPlugin* base);
static void _budgie_budgie_wm_on_dialog_closed_gchild_watch_func (GPid pid,
                                                           gint status,
                                                           gpointer self);
static void budgie_budgie_wm_real_start (MetaPlugin* base);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void budgie_budgie_wm_on_wm_schema_changed (BudgieBudgieWM* self,
                                            const gchar* key);
static void _budgie_budgie_wm_on_wm_schema_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
VALA_EXTERN void budgie_budgie_wm_update_workspace_count (BudgieBudgieWM* self);
static void _budgie_budgie_wm_update_workspace_count_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self);
static void _budgie_budgie_wm_on_raven_notification_clear_meta_key_handler_func (MetaDisplay* display,
                                                                          MetaWindow* window,
                                                                          ClutterKeyEvent* event,
                                                                          MetaKeyBinding* binding,
                                                                          gpointer self);
static void _budgie_budgie_wm_on_take_full_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                      MetaWindow* window,
                                                                      ClutterKeyEvent* event,
                                                                      MetaKeyBinding* binding,
                                                                      gpointer self);
static void _budgie_budgie_wm_on_take_region_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                        MetaWindow* window,
                                                                        ClutterKeyEvent* event,
                                                                        MetaKeyBinding* binding,
                                                                        gpointer self);
static void _budgie_budgie_wm_on_take_window_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                        MetaWindow* window,
                                                                        ClutterKeyEvent* event,
                                                                        MetaKeyBinding* binding,
                                                                        gpointer self);
static void _budgie_budgie_wm_on_raven_main_toggle_meta_key_handler_func (MetaDisplay* display,
                                                                   MetaWindow* window,
                                                                   ClutterKeyEvent* event,
                                                                   MetaKeyBinding* binding,
                                                                   gpointer self);
static void _budgie_budgie_wm_on_raven_notification_toggle_meta_key_handler_func (MetaDisplay* display,
                                                                           MetaWindow* window,
                                                                           ClutterKeyEvent* event,
                                                                           MetaKeyBinding* binding,
                                                                           gpointer self);
static void _budgie_budgie_wm_on_overlay_key_meta_display_overlay_key (MetaDisplay* _sender,
                                                                gpointer self);
static void _budgie_budgie_wm_has_raven_gbus_name_appeared_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              const gchar* name_owner,
                                                              gpointer self);
static void _budgie_budgie_wm_lost_raven_gbus_name_vanished_callback (GDBusConnection* connection,
                                                               const gchar* name,
                                                               gpointer self);
static void _budgie_budgie_wm_has_panel_gbus_name_appeared_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              const gchar* name_owner,
                                                              gpointer self);
static void _budgie_budgie_wm_lost_panel_gbus_name_vanished_callback (GDBusConnection* connection,
                                                               const gchar* name,
                                                               gpointer self);
static void _budgie_budgie_wm_has_menu_gbus_name_appeared_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             const gchar* name_owner,
                                                             gpointer self);
static void _budgie_budgie_wm_lost_menu_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
static void _budgie_budgie_wm_has_switcher_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                 const gchar* name,
                                                                 const gchar* name_owner,
                                                                 gpointer self);
static void _budgie_budgie_wm_lost_switcher_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self);
static void _budgie_budgie_wm_launch_menu_meta_key_handler_func (MetaDisplay* display,
                                                          MetaWindow* window,
                                                          ClutterKeyEvent* event,
                                                          MetaKeyBinding* binding,
                                                          gpointer self);
static void _budgie_budgie_wm_launch_rundialog_meta_key_handler_func (MetaDisplay* display,
                                                               MetaWindow* window,
                                                               ClutterKeyEvent* event,
                                                               MetaKeyBinding* binding,
                                                               gpointer self);
VALA_EXTERN void budgie_budgie_wm_switch_windows (BudgieBudgieWM* self,
                                      MetaDisplay* display,
                                      MetaWindow* window,
                                      ClutterKeyEvent* event,
                                      MetaKeyBinding* binding);
static void _budgie_budgie_wm_switch_windows_meta_key_handler_func (MetaDisplay* display,
                                                             MetaWindow* window,
                                                             ClutterKeyEvent* event,
                                                             MetaKeyBinding* binding,
                                                             gpointer self);
VALA_EXTERN void budgie_budgie_wm_switch_windows_backward (BudgieBudgieWM* self,
                                               MetaDisplay* display,
                                               MetaWindow* window,
                                               ClutterKeyEvent* event,
                                               MetaKeyBinding* binding);
static void _budgie_budgie_wm_switch_windows_backward_meta_key_handler_func (MetaDisplay* display,
                                                                      MetaWindow* window,
                                                                      ClutterKeyEvent* event,
                                                                      MetaKeyBinding* binding,
                                                                      gpointer self);
VALA_EXTERN BudgieShellShim* budgie_shell_shim_new (BudgieBudgieWM* wm);
VALA_EXTERN BudgieShellShim* budgie_shell_shim_construct (GType object_type,
                                              BudgieBudgieWM* wm);
VALA_EXTERN void budgie_shell_shim_serve (BudgieShellShim* self);
VALA_EXTERN BudgieBudgieWMDBUS* budgie_budgie_wmdbus_new (BudgieBudgieWM* wm);
VALA_EXTERN BudgieBudgieWMDBUS* budgie_budgie_wmdbus_construct (GType object_type,
                                                    BudgieBudgieWM* wm);
VALA_EXTERN void budgie_budgie_wmdbus_serve (BudgieBudgieWMDBUS* self);
static gboolean budgie_budgie_wm_on_background_click (BudgieBudgieWM* self,
                                               ClutterButtonEvent* event);
static gboolean _budgie_budgie_wm_on_background_click_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                   ClutterButtonEvent* event,
                                                                                   gpointer self);
static void budgie_budgie_wm_on_monitors_changed (BudgieBudgieWM* self);
static void _budgie_budgie_wm_on_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                  gpointer self);
VALA_EXTERN BudgieKeyboardManager* budgie_keyboard_manager_new (BudgieBudgieWM* wm);
VALA_EXTERN BudgieKeyboardManager* budgie_keyboard_manager_construct (GType object_type,
                                                          BudgieBudgieWM* wm);
VALA_EXTERN void budgie_keyboard_manager_hook_extra (BudgieKeyboardManager* self);
static void budgie_budgie_wm_dismiss_raven (BudgieBudgieWM* self);
static void budgie_budgie_wm_real_show_window_menu (MetaPlugin* base,
                                             MetaWindow* window,
                                             MetaWindowMenuType type,
                                             gint x,
                                             gint y);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block4Data* _data4_);
static gboolean ___lambda11__gsource_func (gpointer self);
VALA_EXTERN GType budgie_budgie_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieBackground, g_object_unref)
VALA_EXTERN BudgieBudgieBackground* budgie_budgie_background_new (MetaDisplay* display,
                                                      gint index,
                                                      BudgieBudgieWM* wm);
VALA_EXTERN BudgieBudgieBackground* budgie_budgie_background_construct (GType object_type,
                                                            MetaDisplay* display,
                                                            gint index,
                                                            BudgieBudgieWM* wm);
static void budgie_budgie_wm_finalize_animations (BudgieBudgieWM* self,
                                           MetaWindowActor* actor);
static void budgie_budgie_wm_map_done (BudgieBudgieWM* self,
                                ClutterActor* actor);
VALA_EXTERN void budgie_budgie_wm_store_focused (BudgieBudgieWM* self);
VALA_EXTERN void budgie_budgie_wm_restore_focused (BudgieBudgieWM* self);
static void budgie_budgie_wm_real_map (MetaPlugin* base,
                                MetaWindowActor* actor);
VALA_EXTERN gboolean budgie_budgie_wm_get_use_animations (BudgieBudgieWM* self);
static void _budgie_budgie_wm_map_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                     gpointer self);
static BudgieAnimationState* _budgie_animation_state_dup (BudgieAnimationState* self);
static void budgie_budgie_wm_minimize_done (BudgieBudgieWM* self,
                                     ClutterActor* actor);
static void budgie_budgie_wm_real_minimize (MetaPlugin* base,
                                     MetaWindowActor* actor);
static void _budgie_budgie_wm_minimize_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                          gpointer self);
static void budgie_budgie_wm_unminimize_done (BudgieBudgieWM* self,
                                       ClutterActor* actor);
static void budgie_budgie_wm_real_unminimize (MetaPlugin* base,
                                       MetaWindowActor* actor);
static void _budgie_budgie_wm_unminimize_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                            gpointer self);
static void budgie_budgie_wm_destroy_done (BudgieBudgieWM* self,
                                    ClutterActor* actor);
static void budgie_budgie_wm_real_destroy (MetaPlugin* base,
                                    MetaWindowActor* actor);
static void _budgie_budgie_wm_destroy_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                         gpointer self);
static void budgie_budgie_wm_real_show_tile_preview (MetaPlugin* base,
                                              MetaWindow* window,
                                              MetaRectangle* tile_rect,
                                              gint tile_monitor_num);
static void budgie_budgie_wm_tile_preview_transition_complete (BudgieBudgieWM* self);
static void _budgie_budgie_wm_tile_preview_transition_complete_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                                             gpointer self);
static guint8* _uint8_dup (guint8* self);
static void budgie_budgie_wm_real_hide_tile_preview (MetaPlugin* base);
static gint budgie_budgie_wm_tab_sort (MetaWindow* a,
                                MetaWindow* b);
static gint budgie_budgie_wm_tab_sort_reverse (MetaWindow* a,
                                        MetaWindow* b);
static void budgie_budgie_wm_invalidate_tab (BudgieBudgieWM* self,
                                      MetaWorkspace* space,
                                      MetaWindow* window);
static void _budgie_budgie_wm_invalidate_tab_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void _budgie_budgie_wm_invalidate_tab_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                     MetaWindow* object,
                                                                     gpointer self);
static GList* budgie_budgie_wm_get_current_tabs (BudgieBudgieWM* self,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace,
                                          gboolean getTabsForAllWindows);
VALA_EXTERN void budgie_budgie_wm_switch_switcher (BudgieBudgieWM* self,
                                       gboolean backward);
static gint _budgie_budgie_wm_tab_sort_reverse_gcompare_func (gconstpointer a,
                                                       gconstpointer b);
VALA_EXTERN void budgie_budgie_wm_stop_switch_windows (BudgieBudgieWM* self);
static void budgie_budgie_wm_real_kill_switch_workspace (MetaPlugin* base);
static void budgie_budgie_wm_switch_workspace_done (BudgieBudgieWM* self);
static void budgie_budgie_wm_real_switch_workspace (MetaPlugin* base,
                                             gint from,
                                             gint to,
                                             MetaMotionDirection direction);
static gboolean ____lambda12_ (BudgieBudgieWM* self);
static gboolean _____lambda12__gsource_func (gpointer self);
static void _budgie_budgie_wm_switch_workspace_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                                  gpointer self);
VALA_EXTERN BudgieBudgieWM* budgie_budgie_wm_new (void);
VALA_EXTERN BudgieBudgieWM* budgie_budgie_wm_construct (GType object_type);
VALA_EXTERN void budgie_budgie_wm_set_use_animations (BudgieBudgieWM* self,
                                          gboolean value);
static GObject * budgie_budgie_wm_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void budgie_budgie_wm_finalize (GObject * obj);
static GType budgie_budgie_wm_get_type_once (void);
static void _vala_budgie_budgie_wm_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_budgie_budgie_wm_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void budgie_budgie_wmdbus_on_bus_acquired (BudgieBudgieWMDBUS* self,
                                           GDBusConnection* conn);
static void _budgie_budgie_wmdbus_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self);
VALA_EXTERN void budgie_budgie_wmdbus_store_focused (BudgieBudgieWMDBUS* self,
                                         GError** error);
VALA_EXTERN void budgie_budgie_wmdbus_restore_focused (BudgieBudgieWMDBUS* self,
                                           GError** error);
VALA_EXTERN void budgie_budgie_wmdbus_RemoveWorkspaceByIndex (BudgieBudgieWMDBUS* self,
                                                  gint index,
                                                  guint32 time,
                                                  GError** error);
VALA_EXTERN gint budgie_budgie_wmdbus_AppendNewWorkspace (BudgieBudgieWMDBUS* self,
                                              guint32 time,
                                              GError** error);
static void budgie_budgie_wmdbus_finalize (GObject * obj);
static GType budgie_budgie_wmdbus_get_type_once (void);
static void _dbus_budgie_budgie_wmdbus_store_focused (BudgieBudgieWMDBUS* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_budgie_wmdbus_restore_focused (BudgieBudgieWMDBUS* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_budgie_wmdbus_RemoveWorkspaceByIndex (BudgieBudgieWMDBUS* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_budgie_wmdbus_AppendNewWorkspace (BudgieBudgieWMDBUS* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void budgie_budgie_wmdbus_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* budgie_budgie_wmdbus_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean budgie_budgie_wmdbus_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _budgie_budgie_wmdbus_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_raven_remote_dbus_arg_info_GetExpanded_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_GetExpanded_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_GetExpanded_out[] = {&_budgie_raven_remote_dbus_arg_info_GetExpanded_result, NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_GetExpanded = {-1, "GetExpanded", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_GetExpanded_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_GetExpanded_out), NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_Toggle_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_Toggle_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_Toggle = {-1, "Toggle", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_Toggle_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_Toggle_out), NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ToggleNotificationsView_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ToggleNotificationsView_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_ToggleNotificationsView = {-1, "ToggleNotificationsView", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ToggleNotificationsView_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ToggleNotificationsView_out), NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ClearNotifications_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ClearNotifications_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_ClearNotifications = {-1, "ClearNotifications", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ClearNotifications_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ClearNotifications_out), NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ToggleAppletView_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_ToggleAppletView_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_ToggleAppletView = {-1, "ToggleAppletView", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ToggleAppletView_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_ToggleAppletView_out), NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_Dismiss_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_remote_dbus_arg_info_Dismiss_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_remote_dbus_method_info_Dismiss = {-1, "Dismiss", (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_Dismiss_in), (GDBusArgInfo **) (&_budgie_raven_remote_dbus_arg_info_Dismiss_out), NULL};
static const GDBusMethodInfo * const _budgie_raven_remote_dbus_method_info[] = {&_budgie_raven_remote_dbus_method_info_GetExpanded, &_budgie_raven_remote_dbus_method_info_Toggle, &_budgie_raven_remote_dbus_method_info_ToggleNotificationsView, &_budgie_raven_remote_dbus_method_info_ClearNotifications, &_budgie_raven_remote_dbus_method_info_ToggleAppletView, &_budgie_raven_remote_dbus_method_info_Dismiss, NULL};
static const GDBusSignalInfo * const _budgie_raven_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_raven_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_raven_remote_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_budgie_raven_remote_dbus_method_info), (GDBusSignalInfo **) (&_budgie_raven_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_raven_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_raven_remote_dbus_interface_vtable = {budgie_raven_remote_dbus_interface_method_call, budgie_raven_remote_dbus_interface_get_property, budgie_raven_remote_dbus_interface_set_property};
static const GDBusArgInfo _budgie_panel_remote_dbus_arg_info_ActivateAction_flags = {-1, "flags", "i", NULL};
static const GDBusArgInfo * const _budgie_panel_remote_dbus_arg_info_ActivateAction_in[] = {&_budgie_panel_remote_dbus_arg_info_ActivateAction_flags, NULL};
static const GDBusArgInfo * const _budgie_panel_remote_dbus_arg_info_ActivateAction_out[] = {NULL};
static const GDBusMethodInfo _budgie_panel_remote_dbus_method_info_ActivateAction = {-1, "ActivateAction", (GDBusArgInfo **) (&_budgie_panel_remote_dbus_arg_info_ActivateAction_in), (GDBusArgInfo **) (&_budgie_panel_remote_dbus_arg_info_ActivateAction_out), NULL};
static const GDBusMethodInfo * const _budgie_panel_remote_dbus_method_info[] = {&_budgie_panel_remote_dbus_method_info_ActivateAction, NULL};
static const GDBusSignalInfo * const _budgie_panel_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_panel_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_panel_remote_dbus_interface_info = {-1, "org.budgie_desktop.Panel", (GDBusMethodInfo **) (&_budgie_panel_remote_dbus_method_info), (GDBusSignalInfo **) (&_budgie_panel_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_panel_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_panel_remote_dbus_interface_vtable = {budgie_panel_remote_dbus_interface_method_call, budgie_panel_remote_dbus_interface_get_property, budgie_panel_remote_dbus_interface_set_property};
static const GDBusMethodInfo * const _budgie_login_dremote_dbus_method_info[] = {NULL};
static const GDBusArgInfo _budgie_login_dremote_dbus_arg_info_prepare_for_sleep_suspending = {-1, "suspending", "b", NULL};
static const GDBusArgInfo * const _budgie_login_dremote_dbus_arg_info_prepare_for_sleep[] = {&_budgie_login_dremote_dbus_arg_info_prepare_for_sleep_suspending, NULL};
static const GDBusSignalInfo _budgie_login_dremote_dbus_signal_info_prepare_for_sleep = {-1, "PrepareForSleep", (GDBusArgInfo **) (&_budgie_login_dremote_dbus_arg_info_prepare_for_sleep), NULL};
static const GDBusSignalInfo * const _budgie_login_dremote_dbus_signal_info[] = {&_budgie_login_dremote_dbus_signal_info_prepare_for_sleep, NULL};
static const GDBusPropertyInfo * const _budgie_login_dremote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_login_dremote_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_budgie_login_dremote_dbus_method_info), (GDBusSignalInfo **) (&_budgie_login_dremote_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_login_dremote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_login_dremote_dbus_interface_vtable = {budgie_login_dremote_dbus_interface_method_call, budgie_login_dremote_dbus_interface_get_property, budgie_login_dremote_dbus_interface_set_property};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_button = {-1, "button", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_in[] = {&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_button, &_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_timestamp, NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_out[] = {NULL};
static const GDBusMethodInfo _budgie_menu_manager_dbus_method_info_ShowDesktopMenu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_in), (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_out), NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_xid = {-1, "xid", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_button = {-1, "button", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_in[] = {&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_xid, &_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_button, &_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_timestamp, NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_out[] = {NULL};
static const GDBusMethodInfo _budgie_menu_manager_dbus_method_info_ShowWindowMenu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_in), (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_out), NULL};
static const GDBusMethodInfo * const _budgie_menu_manager_dbus_method_info[] = {&_budgie_menu_manager_dbus_method_info_ShowDesktopMenu, &_budgie_menu_manager_dbus_method_info_ShowWindowMenu, NULL};
static const GDBusSignalInfo * const _budgie_menu_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_menu_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_menu_manager_dbus_interface_info = {-1, "org.budgie_desktop.MenuManager", (GDBusMethodInfo **) (&_budgie_menu_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_menu_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_menu_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_menu_manager_dbus_interface_vtable = {budgie_menu_manager_dbus_interface_method_call, budgie_menu_manager_dbus_interface_get_property, budgie_menu_manager_dbus_interface_set_property};
static const GDBusArgInfo _budgie_switcher_dbus_arg_info_PassItem_xid = {-1, "xid", "u", NULL};
static const GDBusArgInfo _budgie_switcher_dbus_arg_info_PassItem_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_PassItem_in[] = {&_budgie_switcher_dbus_arg_info_PassItem_xid, &_budgie_switcher_dbus_arg_info_PassItem_timestamp, NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_PassItem_out[] = {NULL};
static const GDBusMethodInfo _budgie_switcher_dbus_method_info_PassItem = {-1, "PassItem", (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_PassItem_in), (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_PassItem_out), NULL};
static const GDBusArgInfo _budgie_switcher_dbus_arg_info_ShowSwitcher_curr_xid = {-1, "curr_xid", "u", NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_ShowSwitcher_in[] = {&_budgie_switcher_dbus_arg_info_ShowSwitcher_curr_xid, NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_ShowSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_switcher_dbus_method_info_ShowSwitcher = {-1, "ShowSwitcher", (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_ShowSwitcher_in), (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_ShowSwitcher_out), NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_StopSwitcher_in[] = {NULL};
static const GDBusArgInfo * const _budgie_switcher_dbus_arg_info_StopSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_switcher_dbus_method_info_StopSwitcher = {-1, "StopSwitcher", (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_StopSwitcher_in), (GDBusArgInfo **) (&_budgie_switcher_dbus_arg_info_StopSwitcher_out), NULL};
static const GDBusMethodInfo * const _budgie_switcher_dbus_method_info[] = {&_budgie_switcher_dbus_method_info_PassItem, &_budgie_switcher_dbus_method_info_ShowSwitcher, &_budgie_switcher_dbus_method_info_StopSwitcher, NULL};
static const GDBusSignalInfo * const _budgie_switcher_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_switcher_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_switcher_dbus_interface_info = {-1, "org.budgie_desktop.TabSwitcher", (GDBusMethodInfo **) (&_budgie_switcher_dbus_method_info), (GDBusSignalInfo **) (&_budgie_switcher_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_switcher_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_switcher_dbus_interface_vtable = {budgie_switcher_dbus_interface_method_call, budgie_switcher_dbus_interface_get_property, budgie_switcher_dbus_interface_set_property};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_store_focused_in[] = {NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_store_focused_out[] = {NULL};
static const GDBusMethodInfo _budgie_budgie_wmdbus_dbus_method_info_store_focused = {-1, "StoreFocused", (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_store_focused_in), (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_store_focused_out), NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_restore_focused_in[] = {NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_restore_focused_out[] = {NULL};
static const GDBusMethodInfo _budgie_budgie_wmdbus_dbus_method_info_restore_focused = {-1, "RestoreFocused", (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_restore_focused_in), (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_restore_focused_out), NULL};
static const GDBusArgInfo _budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_index = {-1, "index", "i", NULL};
static const GDBusArgInfo _budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_time = {-1, "time", "u", NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_in[] = {&_budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_index, &_budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_time, NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_out[] = {NULL};
static const GDBusMethodInfo _budgie_budgie_wmdbus_dbus_method_info_RemoveWorkspaceByIndex = {-1, "RemoveWorkspaceByIndex", (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_in), (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_RemoveWorkspaceByIndex_out), NULL};
static const GDBusArgInfo _budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_time = {-1, "time", "u", NULL};
static const GDBusArgInfo _budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_in[] = {&_budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_time, NULL};
static const GDBusArgInfo * const _budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_out[] = {&_budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_result, NULL};
static const GDBusMethodInfo _budgie_budgie_wmdbus_dbus_method_info_AppendNewWorkspace = {-1, "AppendNewWorkspace", (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_in), (GDBusArgInfo **) (&_budgie_budgie_wmdbus_dbus_arg_info_AppendNewWorkspace_out), NULL};
static const GDBusMethodInfo * const _budgie_budgie_wmdbus_dbus_method_info[] = {&_budgie_budgie_wmdbus_dbus_method_info_store_focused, &_budgie_budgie_wmdbus_dbus_method_info_restore_focused, &_budgie_budgie_wmdbus_dbus_method_info_RemoveWorkspaceByIndex, &_budgie_budgie_wmdbus_dbus_method_info_AppendNewWorkspace, NULL};
static const GDBusSignalInfo * const _budgie_budgie_wmdbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_budgie_wmdbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_budgie_wmdbus_dbus_interface_info = {-1, "org.budgie_desktop.BudgieWM", (GDBusMethodInfo **) (&_budgie_budgie_wmdbus_dbus_method_info), (GDBusSignalInfo **) (&_budgie_budgie_wmdbus_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_budgie_wmdbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_budgie_wmdbus_dbus_interface_vtable = {budgie_budgie_wmdbus_dbus_interface_method_call, budgie_budgie_wmdbus_dbus_interface_get_property, budgie_budgie_wmdbus_dbus_interface_set_property};

static GType
budgie_panel_action_get_type_once (void)
{
	static const GFlagsValue values[] = {{BUDGIE_PANEL_ACTION_NONE, "BUDGIE_PANEL_ACTION_NONE", "none"}, {BUDGIE_PANEL_ACTION_MENU, "BUDGIE_PANEL_ACTION_MENU", "menu"}, {BUDGIE_PANEL_ACTION_MAX, "BUDGIE_PANEL_ACTION_MAX", "max"}, {0, NULL, NULL}};
	GType budgie_panel_action_type_id;
	budgie_panel_action_type_id = g_flags_register_static ("BudgiePanelAction", values);
	return budgie_panel_action_type_id;
}

GType
budgie_panel_action_get_type (void)
{
	static volatile gsize budgie_panel_action_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_action_type_id__once)) {
		GType budgie_panel_action_type_id;
		budgie_panel_action_type_id = budgie_panel_action_get_type_once ();
		g_once_init_leave (&budgie_panel_action_type_id__once, budgie_panel_action_type_id);
	}
	return budgie_panel_action_type_id__once;
}

static GType
budgie_animation_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_ANIMATION_STATE_MAP, "BUDGIE_ANIMATION_STATE_MAP", "map"}, {BUDGIE_ANIMATION_STATE_MINIMIZE, "BUDGIE_ANIMATION_STATE_MINIMIZE", "minimize"}, {BUDGIE_ANIMATION_STATE_UNMINIMIZE, "BUDGIE_ANIMATION_STATE_UNMINIMIZE", "unminimize"}, {BUDGIE_ANIMATION_STATE_DESTROY, "BUDGIE_ANIMATION_STATE_DESTROY", "destroy"}, {0, NULL, NULL}};
	GType budgie_animation_state_type_id;
	budgie_animation_state_type_id = g_enum_register_static ("BudgieAnimationState", values);
	return budgie_animation_state_type_id;
}

GType
budgie_animation_state_get_type (void)
{
	static volatile gsize budgie_animation_state_type_id__once = 0;
	if (g_once_init_enter (&budgie_animation_state_type_id__once)) {
		GType budgie_animation_state_type_id;
		budgie_animation_state_type_id = budgie_animation_state_get_type_once ();
		g_once_init_leave (&budgie_animation_state_type_id__once, budgie_animation_state_type_id);
	}
	return budgie_animation_state_type_id__once;
}

BudgieScreenTilePreview*
budgie_screen_tile_preview_construct (GType object_type)
{
	BudgieScreenTilePreview * self = NULL;
	self = (BudgieScreenTilePreview*) g_object_new (object_type, NULL);
	return self;
}

BudgieScreenTilePreview*
budgie_screen_tile_preview_new (void)
{
	return budgie_screen_tile_preview_construct (BUDGIE_TYPE_SCREEN_TILE_PREVIEW);
}

static GObject *
budgie_screen_tile_preview_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieScreenTilePreview * self;
	parent_class = G_OBJECT_CLASS (budgie_screen_tile_preview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREEN_TILE_PREVIEW, BudgieScreenTilePreview);
	clutter_actor_set_background_color ((ClutterActor*) self, clutter_color_get_static (CLUTTER_COLOR_SKY_BLUE));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 100);
	memset (&self->tile_rect, 0, sizeof (MetaRectangle));
	return obj;
}

static void
budgie_screen_tile_preview_class_init (BudgieScreenTilePreviewClass * klass,
                                       gpointer klass_data)
{
	budgie_screen_tile_preview_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = budgie_screen_tile_preview_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_screen_tile_preview_finalize;
}

static void
budgie_screen_tile_preview_instance_init (BudgieScreenTilePreview * self,
                                          gpointer klass)
{
}

static void
budgie_screen_tile_preview_finalize (GObject * obj)
{
	BudgieScreenTilePreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREEN_TILE_PREVIEW, BudgieScreenTilePreview);
	G_OBJECT_CLASS (budgie_screen_tile_preview_parent_class)->finalize (obj);
}

static GType
budgie_screen_tile_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenTilePreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screen_tile_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreenTilePreview), 0, (GInstanceInitFunc) budgie_screen_tile_preview_instance_init, NULL };
	GType budgie_screen_tile_preview_type_id;
	budgie_screen_tile_preview_type_id = g_type_register_static (clutter_actor_get_type (), "BudgieScreenTilePreview", &g_define_type_info, 0);
	return budgie_screen_tile_preview_type_id;
}

GType
budgie_screen_tile_preview_get_type (void)
{
	static volatile gsize budgie_screen_tile_preview_type_id__once = 0;
	if (g_once_init_enter (&budgie_screen_tile_preview_type_id__once)) {
		GType budgie_screen_tile_preview_type_id;
		budgie_screen_tile_preview_type_id = budgie_screen_tile_preview_get_type_once ();
		g_once_init_leave (&budgie_screen_tile_preview_type_id__once, budgie_screen_tile_preview_type_id);
	}
	return budgie_screen_tile_preview_type_id__once;
}

gboolean
budgie_raven_remote_GetExpanded (BudgieRavenRemote* self,
                                 GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->GetExpanded) {
		return _iface_->GetExpanded (self, error);
	}
	return FALSE;
}

void
budgie_raven_remote_Toggle (BudgieRavenRemote* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->Toggle) {
		_iface_->Toggle (self, _callback_, _user_data_);
	}
}

void
budgie_raven_remote_Toggle_finish (BudgieRavenRemote* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->Toggle_finish) {
		_iface_->Toggle_finish (self, _res_, error);
	}
}

void
budgie_raven_remote_ToggleNotificationsView (BudgieRavenRemote* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleNotificationsView) {
		_iface_->ToggleNotificationsView (self, _callback_, _user_data_);
	}
}

void
budgie_raven_remote_ToggleNotificationsView_finish (BudgieRavenRemote* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleNotificationsView_finish) {
		_iface_->ToggleNotificationsView_finish (self, _res_, error);
	}
}

void
budgie_raven_remote_ClearNotifications (BudgieRavenRemote* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ClearNotifications) {
		_iface_->ClearNotifications (self, _callback_, _user_data_);
	}
}

void
budgie_raven_remote_ClearNotifications_finish (BudgieRavenRemote* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ClearNotifications_finish) {
		_iface_->ClearNotifications_finish (self, _res_, error);
	}
}

void
budgie_raven_remote_ToggleAppletView (BudgieRavenRemote* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleAppletView) {
		_iface_->ToggleAppletView (self, _callback_, _user_data_);
	}
}

void
budgie_raven_remote_ToggleAppletView_finish (BudgieRavenRemote* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->ToggleAppletView_finish) {
		_iface_->ToggleAppletView_finish (self, _res_, error);
	}
}

void
budgie_raven_remote_Dismiss (BudgieRavenRemote* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->Dismiss) {
		_iface_->Dismiss (self, _callback_, _user_data_);
	}
}

void
budgie_raven_remote_Dismiss_finish (BudgieRavenRemote* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	BudgieRavenRemoteIface* _iface_;
	_iface_ = BUDGIE_RAVEN_REMOTE_GET_INTERFACE (self);
	if (_iface_->Dismiss_finish) {
		_iface_->Dismiss_finish (self, _res_, error);
	}
}

static void
budgie_raven_remote_default_init (BudgieRavenRemoteIface * iface,
                                  gpointer iface_data)
{
}

static GType
budgie_raven_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_raven_remote_type_id;
	budgie_raven_remote_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieRavenRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_raven_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_raven_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_raven_remote_proxy_get_type);
	g_type_set_qdata (budgie_raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (budgie_raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_raven_remote_dbus_interface_info));
	g_type_set_qdata (budgie_raven_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_raven_remote_register_object);
	return budgie_raven_remote_type_id;
}

GType
budgie_raven_remote_get_type (void)
{
	static volatile gsize budgie_raven_remote_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_remote_type_id__once)) {
		GType budgie_raven_remote_type_id;
		budgie_raven_remote_type_id = budgie_raven_remote_get_type_once ();
		g_once_init_leave (&budgie_raven_remote_type_id__once, budgie_raven_remote_type_id);
	}
	return budgie_raven_remote_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieRavenRemoteProxy, budgie_raven_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_RAVEN_REMOTE, budgie_raven_remote_proxy_budgie_raven_remote_interface_init) )
static void
budgie_raven_remote_proxy_class_init (BudgieRavenRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_raven_remote_proxy_g_signal;
}

static void
budgie_raven_remote_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
budgie_raven_remote_proxy_init (BudgieRavenRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_raven_remote_dbus_interface_info));
}

static gboolean
budgie_raven_remote_proxy_GetExpanded (BudgieRavenRemote* self,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp72_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "GetExpanded");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp70_ = FALSE;
		return _tmp70_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp71_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp71_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp72_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp72_);
	g_variant_unref (_tmp72_);
	g_object_unref (_reply_message);
	return _result;
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_raven_remote_proxy_Toggle_async (BudgieRavenRemote* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "Toggle");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_raven_remote_proxy_Toggle_finish (BudgieRavenRemote* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_raven_remote_proxy_ToggleNotificationsView_async (BudgieRavenRemote* self,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "ToggleNotificationsView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_raven_remote_proxy_ToggleNotificationsView_finish (BudgieRavenRemote* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_raven_remote_proxy_ClearNotifications_async (BudgieRavenRemote* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "ClearNotifications");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_raven_remote_proxy_ClearNotifications_finish (BudgieRavenRemote* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_raven_remote_proxy_ToggleAppletView_async (BudgieRavenRemote* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "ToggleAppletView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_raven_remote_proxy_ToggleAppletView_finish (BudgieRavenRemote* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_raven_remote_proxy_Dismiss_async (BudgieRavenRemote* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "Dismiss");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_raven_remote_proxy_Dismiss_finish (BudgieRavenRemote* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_raven_remote_proxy_budgie_raven_remote_interface_init (BudgieRavenRemoteIface* iface)
{
	iface->GetExpanded = budgie_raven_remote_proxy_GetExpanded;
	iface->Toggle = budgie_raven_remote_proxy_Toggle_async;
	iface->Toggle_finish = budgie_raven_remote_proxy_Toggle_finish;
	iface->ToggleNotificationsView = budgie_raven_remote_proxy_ToggleNotificationsView_async;
	iface->ToggleNotificationsView_finish = budgie_raven_remote_proxy_ToggleNotificationsView_finish;
	iface->ClearNotifications = budgie_raven_remote_proxy_ClearNotifications_async;
	iface->ClearNotifications_finish = budgie_raven_remote_proxy_ClearNotifications_finish;
	iface->ToggleAppletView = budgie_raven_remote_proxy_ToggleAppletView_async;
	iface->ToggleAppletView_finish = budgie_raven_remote_proxy_ToggleAppletView_finish;
	iface->Dismiss = budgie_raven_remote_proxy_Dismiss_async;
	iface->Dismiss_finish = budgie_raven_remote_proxy_Dismiss_finish;
}

static void
_dbus_budgie_raven_remote_GetExpanded (BudgieRavenRemote* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_raven_remote_GetExpanded (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_remote_Toggle (BudgieRavenRemote* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_raven_remote_ToggleReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_raven_remote_ToggleReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_raven_remote_Toggle (self, (GAsyncReadyCallback) _dbus_budgie_raven_remote_Toggle_ready, _ready_data);
}

static void
_dbus_budgie_raven_remote_Toggle_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_)
{
	budgie_raven_remote_ToggleReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_raven_remote_Toggle_finish ((BudgieRavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_raven_remote_ToggleReadyData, _ready_data);
}

static void
_dbus_budgie_raven_remote_ToggleNotificationsView (BudgieRavenRemote* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_raven_remote_ToggleNotificationsViewReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_raven_remote_ToggleNotificationsViewReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_raven_remote_ToggleNotificationsView (self, (GAsyncReadyCallback) _dbus_budgie_raven_remote_ToggleNotificationsView_ready, _ready_data);
}

static void
_dbus_budgie_raven_remote_ToggleNotificationsView_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_)
{
	budgie_raven_remote_ToggleNotificationsViewReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_raven_remote_ToggleNotificationsView_finish ((BudgieRavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_raven_remote_ToggleNotificationsViewReadyData, _ready_data);
}

static void
_dbus_budgie_raven_remote_ClearNotifications (BudgieRavenRemote* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_raven_remote_ClearNotificationsReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_raven_remote_ClearNotificationsReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_raven_remote_ClearNotifications (self, (GAsyncReadyCallback) _dbus_budgie_raven_remote_ClearNotifications_ready, _ready_data);
}

static void
_dbus_budgie_raven_remote_ClearNotifications_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_)
{
	budgie_raven_remote_ClearNotificationsReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_raven_remote_ClearNotifications_finish ((BudgieRavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_raven_remote_ClearNotificationsReadyData, _ready_data);
}

static void
_dbus_budgie_raven_remote_ToggleAppletView (BudgieRavenRemote* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_raven_remote_ToggleAppletViewReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_raven_remote_ToggleAppletViewReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_raven_remote_ToggleAppletView (self, (GAsyncReadyCallback) _dbus_budgie_raven_remote_ToggleAppletView_ready, _ready_data);
}

static void
_dbus_budgie_raven_remote_ToggleAppletView_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	budgie_raven_remote_ToggleAppletViewReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_raven_remote_ToggleAppletView_finish ((BudgieRavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_raven_remote_ToggleAppletViewReadyData, _ready_data);
}

static void
_dbus_budgie_raven_remote_Dismiss (BudgieRavenRemote* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_raven_remote_DismissReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_raven_remote_DismissReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_raven_remote_Dismiss (self, (GAsyncReadyCallback) _dbus_budgie_raven_remote_Dismiss_ready, _ready_data);
}

static void
_dbus_budgie_raven_remote_Dismiss_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_)
{
	budgie_raven_remote_DismissReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_raven_remote_Dismiss_finish ((BudgieRavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_raven_remote_DismissReadyData, _ready_data);
}

static void
budgie_raven_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetExpanded") == 0) {
		_dbus_budgie_raven_remote_GetExpanded (object, parameters, invocation);
	} else if (strcmp (method_name, "Toggle") == 0) {
		_dbus_budgie_raven_remote_Toggle (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleNotificationsView") == 0) {
		_dbus_budgie_raven_remote_ToggleNotificationsView (object, parameters, invocation);
	} else if (strcmp (method_name, "ClearNotifications") == 0) {
		_dbus_budgie_raven_remote_ClearNotifications (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleAppletView") == 0) {
		_dbus_budgie_raven_remote_ToggleAppletView (object, parameters, invocation);
	} else if (strcmp (method_name, "Dismiss") == 0) {
		_dbus_budgie_raven_remote_Dismiss (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_raven_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_raven_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_raven_remote_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_raven_remote_dbus_interface_info), &_budgie_raven_remote_dbus_interface_vtable, data, _budgie_raven_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_raven_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
budgie_panel_remote_ActivateAction (BudgiePanelRemote* self,
                                    gint flags,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	BudgiePanelRemoteIface* _iface_;
	_iface_ = BUDGIE_PANEL_REMOTE_GET_INTERFACE (self);
	if (_iface_->ActivateAction) {
		_iface_->ActivateAction (self, flags, _callback_, _user_data_);
	}
}

void
budgie_panel_remote_ActivateAction_finish (BudgiePanelRemote* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	BudgiePanelRemoteIface* _iface_;
	_iface_ = BUDGIE_PANEL_REMOTE_GET_INTERFACE (self);
	if (_iface_->ActivateAction_finish) {
		_iface_->ActivateAction_finish (self, _res_, error);
	}
}

static void
budgie_panel_remote_default_init (BudgiePanelRemoteIface * iface,
                                  gpointer iface_data)
{
}

static GType
budgie_panel_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_panel_remote_type_id;
	budgie_panel_remote_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgiePanelRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_panel_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_panel_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_panel_remote_proxy_get_type);
	g_type_set_qdata (budgie_panel_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Panel");
	g_type_set_qdata (budgie_panel_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_panel_remote_dbus_interface_info));
	g_type_set_qdata (budgie_panel_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_panel_remote_register_object);
	return budgie_panel_remote_type_id;
}

GType
budgie_panel_remote_get_type (void)
{
	static volatile gsize budgie_panel_remote_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_remote_type_id__once)) {
		GType budgie_panel_remote_type_id;
		budgie_panel_remote_type_id = budgie_panel_remote_get_type_once ();
		g_once_init_leave (&budgie_panel_remote_type_id__once, budgie_panel_remote_type_id);
	}
	return budgie_panel_remote_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgiePanelRemoteProxy, budgie_panel_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_PANEL_REMOTE, budgie_panel_remote_proxy_budgie_panel_remote_interface_init) )
static void
budgie_panel_remote_proxy_class_init (BudgiePanelRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_panel_remote_proxy_g_signal;
}

static void
budgie_panel_remote_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
budgie_panel_remote_proxy_init (BudgiePanelRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_panel_remote_dbus_interface_info));
}

static void
budgie_panel_remote_proxy_ActivateAction_async (BudgiePanelRemote* self,
                                                gint flags,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Panel", "ActivateAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_panel_remote_proxy_ActivateAction_finish (BudgiePanelRemote* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_panel_remote_proxy_budgie_panel_remote_interface_init (BudgiePanelRemoteIface* iface)
{
	iface->ActivateAction = budgie_panel_remote_proxy_ActivateAction_async;
	iface->ActivateAction_finish = budgie_panel_remote_proxy_ActivateAction_finish;
}

static void
_dbus_budgie_panel_remote_ActivateAction (BudgiePanelRemote* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_panel_remote_ActivateActionReadyData* _ready_data;
	GVariant* _tmp73_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_panel_remote_ActivateActionReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp73_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flags = g_variant_get_int32 (_tmp73_);
	g_variant_unref (_tmp73_);
	budgie_panel_remote_ActivateAction (self, _ready_data->flags, (GAsyncReadyCallback) _dbus_budgie_panel_remote_ActivateAction_ready, _ready_data);
}

static void
_dbus_budgie_panel_remote_ActivateAction_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_)
{
	budgie_panel_remote_ActivateActionReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_panel_remote_ActivateAction_finish ((BudgiePanelRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_panel_remote_ActivateActionReadyData, _ready_data);
}

static void
budgie_panel_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ActivateAction") == 0) {
		_dbus_budgie_panel_remote_ActivateAction (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_panel_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_panel_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_panel_remote_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_panel_remote_dbus_interface_info), &_budgie_panel_remote_dbus_interface_vtable, data, _budgie_panel_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_panel_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
budgie_login_dremote_default_init (BudgieLoginDRemoteIface * iface,
                                   gpointer iface_data)
{
	budgie_login_dremote_signals[BUDGIE_LOGIN_DREMOTE_PREPARE_FOR_SLEEP_SIGNAL] = g_signal_new ("prepare-for-sleep", BUDGIE_TYPE_LOGIN_DREMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static GType
budgie_login_dremote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieLoginDRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_login_dremote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_login_dremote_type_id;
	budgie_login_dremote_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieLoginDRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_login_dremote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_login_dremote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_login_dremote_proxy_get_type);
	g_type_set_qdata (budgie_login_dremote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (budgie_login_dremote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_login_dremote_dbus_interface_info));
	g_type_set_qdata (budgie_login_dremote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_login_dremote_register_object);
	return budgie_login_dremote_type_id;
}

GType
budgie_login_dremote_get_type (void)
{
	static volatile gsize budgie_login_dremote_type_id__once = 0;
	if (g_once_init_enter (&budgie_login_dremote_type_id__once)) {
		GType budgie_login_dremote_type_id;
		budgie_login_dremote_type_id = budgie_login_dremote_get_type_once ();
		g_once_init_leave (&budgie_login_dremote_type_id__once, budgie_login_dremote_type_id);
	}
	return budgie_login_dremote_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieLoginDRemoteProxy, budgie_login_dremote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_LOGIN_DREMOTE, budgie_login_dremote_proxy_budgie_login_dremote_interface_init) )
static void
budgie_login_dremote_proxy_class_init (BudgieLoginDRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_login_dremote_proxy_g_signal;
}

static void
_dbus_handle_budgie_login_dremote_prepare_for_sleep (BudgieLoginDRemote* self,
                                                     GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean suspending = FALSE;
	GVariant* _tmp74_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp74_ = g_variant_iter_next_value (&_arguments_iter);
	suspending = g_variant_get_boolean (_tmp74_);
	g_variant_unref (_tmp74_);
	g_signal_emit_by_name (self, "prepare-for-sleep", suspending);
}

static void
budgie_login_dremote_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
	if (strcmp (signal_name, "PrepareForSleep") == 0) {
		_dbus_handle_budgie_login_dremote_prepare_for_sleep ((BudgieLoginDRemote*) proxy, parameters);
	}
}

static void
budgie_login_dremote_proxy_init (BudgieLoginDRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_login_dremote_dbus_interface_info));
}

static void
budgie_login_dremote_proxy_budgie_login_dremote_interface_init (BudgieLoginDRemoteIface* iface)
{
}

static void
budgie_login_dremote_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
budgie_login_dremote_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_login_dremote_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_login_dremote_prepare_for_sleep (GObject* _sender,
                                              gboolean suspending,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (suspending));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "PrepareForSleep", _arguments, NULL);
}

guint
budgie_login_dremote_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_login_dremote_dbus_interface_info), &_budgie_login_dremote_dbus_interface_vtable, data, _budgie_login_dremote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "prepare-for-sleep", (GCallback) _dbus_budgie_login_dremote_prepare_for_sleep, data);
	return result;
}

static void
_budgie_login_dremote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_login_dremote_prepare_for_sleep, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                     guint button,
                                     guint32 timestamp,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BudgieMenuManagerIface* _iface_;
	_iface_ = BUDGIE_MENU_MANAGER_GET_INTERFACE (self);
	if (_iface_->ShowDesktopMenu) {
		_iface_->ShowDesktopMenu (self, button, timestamp, _callback_, _user_data_);
	}
}

void
budgie_menu_manager_ShowDesktopMenu_finish (BudgieMenuManager* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	BudgieMenuManagerIface* _iface_;
	_iface_ = BUDGIE_MENU_MANAGER_GET_INTERFACE (self);
	if (_iface_->ShowDesktopMenu_finish) {
		_iface_->ShowDesktopMenu_finish (self, _res_, error);
	}
}

void
budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                    guint32 xid,
                                    guint button,
                                    guint32 timestamp,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	BudgieMenuManagerIface* _iface_;
	_iface_ = BUDGIE_MENU_MANAGER_GET_INTERFACE (self);
	if (_iface_->ShowWindowMenu) {
		_iface_->ShowWindowMenu (self, xid, button, timestamp, _callback_, _user_data_);
	}
}

void
budgie_menu_manager_ShowWindowMenu_finish (BudgieMenuManager* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	BudgieMenuManagerIface* _iface_;
	_iface_ = BUDGIE_MENU_MANAGER_GET_INTERFACE (self);
	if (_iface_->ShowWindowMenu_finish) {
		_iface_->ShowWindowMenu_finish (self, _res_, error);
	}
}

static void
budgie_menu_manager_default_init (BudgieMenuManagerIface * iface,
                                  gpointer iface_data)
{
}

/**
* Allows us to invoke desktop menus without directly using GTK+ ourselves
*/
static GType
budgie_menu_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_menu_manager_type_id;
	budgie_menu_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieMenuManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_menu_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_menu_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_menu_manager_proxy_get_type);
	g_type_set_qdata (budgie_menu_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.MenuManager");
	g_type_set_qdata (budgie_menu_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_menu_manager_dbus_interface_info));
	g_type_set_qdata (budgie_menu_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_menu_manager_register_object);
	return budgie_menu_manager_type_id;
}

GType
budgie_menu_manager_get_type (void)
{
	static volatile gsize budgie_menu_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_menu_manager_type_id__once)) {
		GType budgie_menu_manager_type_id;
		budgie_menu_manager_type_id = budgie_menu_manager_get_type_once ();
		g_once_init_leave (&budgie_menu_manager_type_id__once, budgie_menu_manager_type_id);
	}
	return budgie_menu_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieMenuManagerProxy, budgie_menu_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_MENU_MANAGER, budgie_menu_manager_proxy_budgie_menu_manager_interface_init) )
static void
budgie_menu_manager_proxy_class_init (BudgieMenuManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_menu_manager_proxy_g_signal;
}

static void
budgie_menu_manager_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
budgie_menu_manager_proxy_init (BudgieMenuManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_menu_manager_dbus_interface_info));
}

static void
budgie_menu_manager_proxy_ShowDesktopMenu_async (BudgieMenuManager* self,
                                                 guint button,
                                                 guint32 timestamp,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.MenuManager", "ShowDesktopMenu");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (button));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_menu_manager_proxy_ShowDesktopMenu_finish (BudgieMenuManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_menu_manager_proxy_ShowWindowMenu_async (BudgieMenuManager* self,
                                                guint32 xid,
                                                guint button,
                                                guint32 timestamp,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.MenuManager", "ShowWindowMenu");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (xid));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (button));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_menu_manager_proxy_ShowWindowMenu_finish (BudgieMenuManager* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_menu_manager_proxy_budgie_menu_manager_interface_init (BudgieMenuManagerIface* iface)
{
	iface->ShowDesktopMenu = budgie_menu_manager_proxy_ShowDesktopMenu_async;
	iface->ShowDesktopMenu_finish = budgie_menu_manager_proxy_ShowDesktopMenu_finish;
	iface->ShowWindowMenu = budgie_menu_manager_proxy_ShowWindowMenu_async;
	iface->ShowWindowMenu_finish = budgie_menu_manager_proxy_ShowWindowMenu_finish;
}

static void
_dbus_budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_menu_manager_ShowDesktopMenuReadyData* _ready_data;
	GVariant* _tmp75_;
	GVariant* _tmp76_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_menu_manager_ShowDesktopMenuReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp75_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->button = g_variant_get_uint32 (_tmp75_);
	g_variant_unref (_tmp75_);
	_tmp76_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->timestamp = g_variant_get_uint32 (_tmp76_);
	g_variant_unref (_tmp76_);
	budgie_menu_manager_ShowDesktopMenu (self, _ready_data->button, _ready_data->timestamp, (GAsyncReadyCallback) _dbus_budgie_menu_manager_ShowDesktopMenu_ready, _ready_data);
}

static void
_dbus_budgie_menu_manager_ShowDesktopMenu_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_)
{
	budgie_menu_manager_ShowDesktopMenuReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_menu_manager_ShowDesktopMenu_finish ((BudgieMenuManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_menu_manager_ShowDesktopMenuReadyData, _ready_data);
}

static void
_dbus_budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_menu_manager_ShowWindowMenuReadyData* _ready_data;
	GVariant* _tmp77_;
	GVariant* _tmp78_;
	GVariant* _tmp79_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_menu_manager_ShowWindowMenuReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp77_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->xid = g_variant_get_uint32 (_tmp77_);
	g_variant_unref (_tmp77_);
	_tmp78_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->button = g_variant_get_uint32 (_tmp78_);
	g_variant_unref (_tmp78_);
	_tmp79_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->timestamp = g_variant_get_uint32 (_tmp79_);
	g_variant_unref (_tmp79_);
	budgie_menu_manager_ShowWindowMenu (self, _ready_data->xid, _ready_data->button, _ready_data->timestamp, (GAsyncReadyCallback) _dbus_budgie_menu_manager_ShowWindowMenu_ready, _ready_data);
}

static void
_dbus_budgie_menu_manager_ShowWindowMenu_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_)
{
	budgie_menu_manager_ShowWindowMenuReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_menu_manager_ShowWindowMenu_finish ((BudgieMenuManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_menu_manager_ShowWindowMenuReadyData, _ready_data);
}

static void
budgie_menu_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_budgie_menu_manager_ShowDesktopMenu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_budgie_menu_manager_ShowWindowMenu (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_menu_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_menu_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_menu_manager_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_menu_manager_dbus_interface_info), &_budgie_menu_manager_dbus_interface_vtable, data, _budgie_menu_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_menu_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
budgie_switcher_PassItem (BudgieSwitcher* self,
                          guint32 xid,
                          guint32 timestamp,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->PassItem) {
		_iface_->PassItem (self, xid, timestamp, _callback_, _user_data_);
	}
}

void
budgie_switcher_PassItem_finish (BudgieSwitcher* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->PassItem_finish) {
		_iface_->PassItem_finish (self, _res_, error);
	}
}

void
budgie_switcher_ShowSwitcher (BudgieSwitcher* self,
                              guint32 curr_xid,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->ShowSwitcher) {
		_iface_->ShowSwitcher (self, curr_xid, _callback_, _user_data_);
	}
}

void
budgie_switcher_ShowSwitcher_finish (BudgieSwitcher* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->ShowSwitcher_finish) {
		_iface_->ShowSwitcher_finish (self, _res_, error);
	}
}

void
budgie_switcher_StopSwitcher (BudgieSwitcher* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->StopSwitcher) {
		_iface_->StopSwitcher (self, _callback_, _user_data_);
	}
}

void
budgie_switcher_StopSwitcher_finish (BudgieSwitcher* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	BudgieSwitcherIface* _iface_;
	_iface_ = BUDGIE_SWITCHER_GET_INTERFACE (self);
	if (_iface_->StopSwitcher_finish) {
		_iface_->StopSwitcher_finish (self, _res_, error);
	}
}

static void
budgie_switcher_default_init (BudgieSwitcherIface * iface,
                              gpointer iface_data)
{
}

/**
* Allows us to display the tab switcher without Gtk
*/
static GType
budgie_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSwitcherIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_switcher_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_switcher_type_id;
	budgie_switcher_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieSwitcher", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_switcher_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_switcher_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_switcher_proxy_get_type);
	g_type_set_qdata (budgie_switcher_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.TabSwitcher");
	g_type_set_qdata (budgie_switcher_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_switcher_dbus_interface_info));
	g_type_set_qdata (budgie_switcher_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_switcher_register_object);
	return budgie_switcher_type_id;
}

GType
budgie_switcher_get_type (void)
{
	static volatile gsize budgie_switcher_type_id__once = 0;
	if (g_once_init_enter (&budgie_switcher_type_id__once)) {
		GType budgie_switcher_type_id;
		budgie_switcher_type_id = budgie_switcher_get_type_once ();
		g_once_init_leave (&budgie_switcher_type_id__once, budgie_switcher_type_id);
	}
	return budgie_switcher_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieSwitcherProxy, budgie_switcher_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SWITCHER, budgie_switcher_proxy_budgie_switcher_interface_init) )
static void
budgie_switcher_proxy_class_init (BudgieSwitcherProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_switcher_proxy_g_signal;
}

static void
budgie_switcher_proxy_g_signal (GDBusProxy* proxy,
                                const gchar* sender_name,
                                const gchar* signal_name,
                                GVariant* parameters)
{
}

static void
budgie_switcher_proxy_init (BudgieSwitcherProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_switcher_dbus_interface_info));
}

static void
budgie_switcher_proxy_PassItem_async (BudgieSwitcher* self,
                                      guint32 xid,
                                      guint32 timestamp,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.TabSwitcher", "PassItem");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (xid));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_switcher_proxy_PassItem_finish (BudgieSwitcher* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_switcher_proxy_ShowSwitcher_async (BudgieSwitcher* self,
                                          guint32 curr_xid,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.TabSwitcher", "ShowSwitcher");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (curr_xid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_switcher_proxy_ShowSwitcher_finish (BudgieSwitcher* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_switcher_proxy_StopSwitcher_async (BudgieSwitcher* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.TabSwitcher", "StopSwitcher");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
budgie_switcher_proxy_StopSwitcher_finish (BudgieSwitcher* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
budgie_switcher_proxy_budgie_switcher_interface_init (BudgieSwitcherIface* iface)
{
	iface->PassItem = budgie_switcher_proxy_PassItem_async;
	iface->PassItem_finish = budgie_switcher_proxy_PassItem_finish;
	iface->ShowSwitcher = budgie_switcher_proxy_ShowSwitcher_async;
	iface->ShowSwitcher_finish = budgie_switcher_proxy_ShowSwitcher_finish;
	iface->StopSwitcher = budgie_switcher_proxy_StopSwitcher_async;
	iface->StopSwitcher_finish = budgie_switcher_proxy_StopSwitcher_finish;
}

static void
_dbus_budgie_switcher_PassItem (BudgieSwitcher* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_switcher_PassItemReadyData* _ready_data;
	GVariant* _tmp80_;
	GVariant* _tmp81_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_switcher_PassItemReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp80_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->xid = g_variant_get_uint32 (_tmp80_);
	g_variant_unref (_tmp80_);
	_tmp81_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->timestamp = g_variant_get_uint32 (_tmp81_);
	g_variant_unref (_tmp81_);
	budgie_switcher_PassItem (self, _ready_data->xid, _ready_data->timestamp, (GAsyncReadyCallback) _dbus_budgie_switcher_PassItem_ready, _ready_data);
}

static void
_dbus_budgie_switcher_PassItem_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	budgie_switcher_PassItemReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_switcher_PassItem_finish ((BudgieSwitcher*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_switcher_PassItemReadyData, _ready_data);
}

static void
_dbus_budgie_switcher_ShowSwitcher (BudgieSwitcher* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_switcher_ShowSwitcherReadyData* _ready_data;
	GVariant* _tmp82_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_switcher_ShowSwitcherReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp82_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->curr_xid = g_variant_get_uint32 (_tmp82_);
	g_variant_unref (_tmp82_);
	budgie_switcher_ShowSwitcher (self, _ready_data->curr_xid, (GAsyncReadyCallback) _dbus_budgie_switcher_ShowSwitcher_ready, _ready_data);
}

static void
_dbus_budgie_switcher_ShowSwitcher_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_)
{
	budgie_switcher_ShowSwitcherReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_switcher_ShowSwitcher_finish ((BudgieSwitcher*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_switcher_ShowSwitcherReadyData, _ready_data);
}

static void
_dbus_budgie_switcher_StopSwitcher (BudgieSwitcher* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	budgie_switcher_StopSwitcherReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (budgie_switcher_StopSwitcherReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_switcher_StopSwitcher (self, (GAsyncReadyCallback) _dbus_budgie_switcher_StopSwitcher_ready, _ready_data);
}

static void
_dbus_budgie_switcher_StopSwitcher_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_)
{
	budgie_switcher_StopSwitcherReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_switcher_StopSwitcher_finish ((BudgieSwitcher*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (budgie_switcher_StopSwitcherReadyData, _ready_data);
}

static void
budgie_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PassItem") == 0) {
		_dbus_budgie_switcher_PassItem (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowSwitcher") == 0) {
		_dbus_budgie_switcher_ShowSwitcher (object, parameters, invocation);
	} else if (strcmp (method_name, "StopSwitcher") == 0) {
		_dbus_budgie_switcher_StopSwitcher (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_switcher_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_switcher_dbus_interface_info), &_budgie_switcher_dbus_interface_vtable, data, _budgie_switcher_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_switcher_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

BudgieMinimizeData*
budgie_minimize_data_construct (GType object_type,
                                gfloat sx,
                                gfloat sy,
                                gfloat px,
                                gfloat py,
                                gfloat ox,
                                gfloat oy)
{
	BudgieMinimizeData* self = NULL;
	self = (BudgieMinimizeData*) g_type_create_instance (object_type);
	self->scale_x = sx;
	self->scale_y = sy;
	self->place_x = px;
	self->place_y = py;
	self->old_x = ox;
	self->old_y = oy;
	return self;
}

BudgieMinimizeData*
budgie_minimize_data_new (gfloat sx,
                          gfloat sy,
                          gfloat px,
                          gfloat py,
                          gfloat ox,
                          gfloat oy)
{
	return budgie_minimize_data_construct (BUDGIE_TYPE_MINIMIZE_DATA, sx, sy, px, py, ox, oy);
}

static void
budgie_value_minimize_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_minimize_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_minimize_data_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_minimize_data_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_minimize_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_minimize_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_minimize_data_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieMinimizeData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_minimize_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_minimize_data_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	BudgieMinimizeData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_minimize_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_minimize_data (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	BudgieParamSpecMinimizeData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_MINIMIZE_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_minimize_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MINIMIZE_DATA), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_minimize_data (GValue* value,
                                gpointer v_object)
{
	BudgieMinimizeData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MINIMIZE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_MINIMIZE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_minimize_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_minimize_data_unref (old);
	}
}

void
budgie_value_take_minimize_data (GValue* value,
                                 gpointer v_object)
{
	BudgieMinimizeData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MINIMIZE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_MINIMIZE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_minimize_data_unref (old);
	}
}

static void
budgie_minimize_data_class_init (BudgieMinimizeDataClass * klass,
                                 gpointer klass_data)
{
	budgie_minimize_data_parent_class = g_type_class_peek_parent (klass);
	((BudgieMinimizeDataClass *) klass)->finalize = budgie_minimize_data_finalize;
}

static void
budgie_minimize_data_instance_init (BudgieMinimizeData * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
budgie_minimize_data_finalize (BudgieMinimizeData * obj)
{
	BudgieMinimizeData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_MINIMIZE_DATA, BudgieMinimizeData);
	g_signal_handlers_destroy (self);
}

static GType
budgie_minimize_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_minimize_data_init, budgie_value_minimize_data_free_value, budgie_value_minimize_data_copy_value, budgie_value_minimize_data_peek_pointer, "p", budgie_value_minimize_data_collect_value, "p", budgie_value_minimize_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMinimizeDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_minimize_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMinimizeData), 0, (GInstanceInitFunc) budgie_minimize_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_minimize_data_type_id;
	budgie_minimize_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieMinimizeData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return budgie_minimize_data_type_id;
}

GType
budgie_minimize_data_get_type (void)
{
	static volatile gsize budgie_minimize_data_type_id__once = 0;
	if (g_once_init_enter (&budgie_minimize_data_type_id__once)) {
		GType budgie_minimize_data_type_id;
		budgie_minimize_data_type_id = budgie_minimize_data_get_type_once ();
		g_once_init_leave (&budgie_minimize_data_type_id__once, budgie_minimize_data_type_id);
	}
	return budgie_minimize_data_type_id__once;
}

gpointer
budgie_minimize_data_ref (gpointer instance)
{
	BudgieMinimizeData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_minimize_data_unref (gpointer instance)
{
	BudgieMinimizeData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_MINIMIZE_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
budgie_budgie_wm_get_instance_private (BudgieBudgieWM* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBudgieWM_private_offset);
}

static gboolean
budgie_budgie_wm_have_logind (BudgieBudgieWM* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = g_file_test ("/run/systemd/seats", G_FILE_TEST_EXISTS);
	return result;
}

static void
budgie_budgie_wm_on_raven_get (BudgieBudgieWM* self,
                               GObject* o,
                               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieRavenRemote* _tmp0_ = NULL;
		BudgieRavenRemote* _tmp1_;
		BudgieRavenRemote* _tmp2_;
		BudgieRavenRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieRavenRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieRavenRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("wm.vala:179: Failed to gain Raven proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_panel_get (BudgieBudgieWM* self,
                               GObject* o,
                               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgiePanelRemote* _tmp0_ = NULL;
		BudgiePanelRemote* _tmp1_;
		BudgiePanelRemote* _tmp2_;
		BudgiePanelRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgiePanelRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgiePanelRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->panel_proxy);
		self->priv->panel_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("wm.vala:188: Failed to get Panel proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_lost_panel (BudgieBudgieWM* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->panel_proxy);
	self->priv->panel_proxy = NULL;
}

static void
_budgie_budgie_wm_on_panel_get_gasync_ready_callback (GObject* source_object,
                                                      GAsyncResult* res,
                                                      gpointer self)
{
	budgie_budgie_wm_on_panel_get ((BudgieBudgieWM*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_budgie_wm_has_panel (BudgieBudgieWM* self)
{
	BudgiePanelRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->panel_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (BUDGIE_TYPE_PANEL_REMOTE_PROXY, 0, NULL, _budgie_budgie_wm_on_panel_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_PANEL_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_PANEL_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Panel", NULL);
	}
}

static void
budgie_budgie_wm_on_menu_get (BudgieBudgieWM* self,
                              GObject* o,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieMenuManager* _tmp0_ = NULL;
		BudgieMenuManager* _tmp1_;
		BudgieMenuManager* _tmp2_;
		BudgieMenuManager* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieMenuManager*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieMenuManager*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->menu_proxy);
		self->priv->menu_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("wm.vala:207: Failed to get Menu proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_lost_menu (BudgieBudgieWM* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->menu_proxy);
	self->priv->menu_proxy = NULL;
}

static void
_budgie_budgie_wm_on_menu_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	budgie_budgie_wm_on_menu_get ((BudgieBudgieWM*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_budgie_wm_has_menu (BudgieBudgieWM* self)
{
	BudgieMenuManager* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (BUDGIE_TYPE_MENU_MANAGER_PROXY, 0, NULL, _budgie_budgie_wm_on_menu_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_MENU_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_MENU_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.MenuManager", NULL);
	}
}

static void
_budgie_budgie_wm_prepare_for_sleep_budgie_login_dremote_prepare_for_sleep (BudgieLoginDRemote* _sender,
                                                                            gboolean suspending,
                                                                            gpointer self)
{
	budgie_budgie_wm_prepare_for_sleep ((BudgieBudgieWM*) self, suspending);
}

static void
budgie_budgie_wm_on_logind_get (BudgieBudgieWM* self,
                                GObject* o,
                                GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieLoginDRemote* _tmp0_ = NULL;
		BudgieLoginDRemote* _tmp1_;
		BudgieLoginDRemote* _tmp2_;
		BudgieLoginDRemote* _tmp3_;
		BudgieLoginDRemote* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieLoginDRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieLoginDRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->logind_proxy);
		self->priv->logind_proxy = _tmp3_;
		_tmp4_ = self->priv->logind_proxy;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (_tmp0_);
			return;
		}
		if (budgie_budgie_wm_is_nvidia (self)) {
			BudgieLoginDRemote* _tmp5_;
			_tmp5_ = self->priv->logind_proxy;
			g_signal_connect_object (_tmp5_, "prepare-for-sleep", (GCallback) _budgie_budgie_wm_prepare_for_sleep_budgie_login_dremote_prepare_for_sleep, self, 0);
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("wm.vala:232: Failed to get LoginD proxy: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_prepare_for_sleep (BudgieBudgieWM* self,
                                    gboolean suspending)
{
	g_return_if_fail (self != NULL);
	if (suspending) {
		return;
	}
	meta_background_refresh_all ();
}

static void
_budgie_budgie_wm_on_logind_get_gasync_ready_callback (GObject* source_object,
                                                       GAsyncResult* res,
                                                       gpointer self)
{
	budgie_budgie_wm_on_logind_get ((BudgieBudgieWM*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_budgie_wm_get_logind (BudgieBudgieWM* self)
{
	BudgieLoginDRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logind_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (BUDGIE_TYPE_LOGIN_DREMOTE_PROXY, 0, NULL, _budgie_budgie_wm_on_logind_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_LOGIND_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", BUDGIE_LOGIND_DBUS_OBJECT_PATH, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
	}
}

static void
budgie_budgie_wm_lost_switcher (BudgieBudgieWM* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->switcher_proxy);
	self->priv->switcher_proxy = NULL;
}

static void
budgie_budgie_wm_on_switcher_get (BudgieBudgieWM* self,
                                  GObject* o,
                                  GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieSwitcher* _tmp0_ = NULL;
		BudgieSwitcher* _tmp1_;
		BudgieSwitcher* _tmp2_;
		BudgieSwitcher* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieSwitcher*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieSwitcher*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->switcher_proxy);
		self->priv->switcher_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("wm.vala:258: Failed to get Switcher proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_budgie_budgie_wm_on_switcher_get_gasync_ready_callback (GObject* source_object,
                                                         GAsyncResult* res,
                                                         gpointer self)
{
	budgie_budgie_wm_on_switcher_get ((BudgieBudgieWM*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_budgie_wm_has_switcher (BudgieBudgieWM* self)
{
	BudgieSwitcher* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (BUDGIE_TYPE_SWITCHER_PROXY, 0, NULL, _budgie_budgie_wm_on_switcher_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_SWITCHER_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_SWITCHER_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.TabSwitcher", NULL);
	}
}

static void
budgie_budgie_wm_on_take_full_screenshot (BudgieBudgieWM* self,
                                          MetaDisplay* display,
                                          MetaWindow* window,
                                          ClutterKeyEvent* event,
                                          MetaKeyBinding* binding)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	{
		gchar* cmd = NULL;
		GSettings* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_string (_tmp0_, "full-screenshot-cmd");
		cmd = _tmp1_;
		_tmp2_ = cmd;
		if (g_strcmp0 (_tmp2_, "") != 0) {
			const gchar* _tmp3_;
			_tmp3_ = cmd;
			g_spawn_command_line_async (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (cmd);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (cmd);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_print ("Error: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_take_region_screenshot (BudgieBudgieWM* self,
                                            MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	{
		gchar* cmd = NULL;
		GSettings* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_string (_tmp0_, "take-region-screenshot-cmd");
		cmd = _tmp1_;
		_tmp2_ = cmd;
		if (g_strcmp0 (_tmp2_, "") != 0) {
			const gchar* _tmp3_;
			_tmp3_ = cmd;
			g_spawn_command_line_async (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (cmd);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (cmd);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_print ("Error: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_take_window_screenshot (BudgieBudgieWM* self,
                                            MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	{
		gchar* cmd = NULL;
		GSettings* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_string (_tmp0_, "take-window-screenshot-cmd");
		cmd = _tmp1_;
		_tmp2_ = cmd;
		if (g_strcmp0 (_tmp2_, "") != 0) {
			const gchar* _tmp3_;
			_tmp3_ = cmd;
			g_spawn_command_line_async (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (cmd);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (cmd);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_print ("Error: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_raven_notification_clear (BudgieBudgieWM* self,
                                              MetaDisplay* display,
                                              MetaWindow* window,
                                              ClutterKeyEvent* event,
                                              MetaKeyBinding* binding)
{
	BudgieRavenRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("wm.vala:306: Raven does not appear to be running!");
		return;
	}
	{
		BudgieRavenRemote* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		budgie_raven_remote_ClearNotifications (_tmp1_, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("wm.vala:312: Unable to ClearNotifications() in Raven: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_raven_main_toggle (BudgieBudgieWM* self,
                                       MetaDisplay* display,
                                       MetaWindow* window,
                                       ClutterKeyEvent* event,
                                       MetaKeyBinding* binding)
{
	BudgieRavenRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("wm.vala:321: Raven does not appear to be running!");
		return;
	}
	{
		BudgieRavenRemote* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		budgie_raven_remote_ToggleAppletView (_tmp1_, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("wm.vala:327: Unable to ToggleAppletView() in Raven: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_raven_notification_toggle (BudgieBudgieWM* self,
                                               MetaDisplay* display,
                                               MetaWindow* window,
                                               ClutterKeyEvent* event,
                                               MetaKeyBinding* binding)
{
	BudgieRavenRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_warning ("wm.vala:336: Raven does not appear to be running!");
		return;
	}
	{
		BudgieRavenRemote* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		budgie_raven_remote_ToggleNotificationsView (_tmp1_, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("wm.vala:342: Unable to ToggleNotificationsView() in Raven: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_budgie_budgie_wm_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                      GAsyncResult* res,
                                                      gpointer self)
{
	budgie_budgie_wm_on_raven_get ((BudgieBudgieWM*) self, source_object, res);
	g_object_unref (self);
}

static void
budgie_budgie_wm_has_raven (BudgieBudgieWM* self)
{
	BudgieRavenRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (BUDGIE_TYPE_RAVEN_REMOTE_PROXY, 0, NULL, _budgie_budgie_wm_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", BUDGIE_RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", BUDGIE_RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	}
}

static void
budgie_budgie_wm_lost_raven (BudgieBudgieWM* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->raven_proxy);
	self->priv->raven_proxy = NULL;
}

static MetaPluginInfo*
budgie_budgie_wm_real_plugin_info (MetaPlugin* base)
{
	BudgieBudgieWM * self;
	MetaPluginInfo _tmp0_;
	MetaPluginInfo* result;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = budgie_budgie_wm_info;
	result = &_tmp0_;
	return result;
}

static gboolean
___lambda10_ (BudgieBudgieWM* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		BudgiePanelRemote* _tmp0_;
		_tmp0_ = self->priv->panel_proxy;
		budgie_panel_remote_ActivateAction (_tmp0_, (gint) BUDGIE_PANEL_ACTION_MENU, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("wm.vala:376: Unable to ActivateAction for menu: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda10_ ((BudgieBudgieWM*) self);
	return result;
}

static void
budgie_budgie_wm_on_overlay_key (BudgieBudgieWM* self)
{
	BudgiePanelRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->panel_proxy;
	if (_tmp0_ == NULL) {
		return;
	}
	if (self->priv->enabled_experimental_run_diag_as_menu) {
		{
			g_spawn_command_line_async ("budgie-run-dialog", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_message ("wm.vala:369: Failed to launch Budgie Run Dialog: %s", _tmp2_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda10__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
budgie_budgie_wm_launch_menu (BudgieBudgieWM* self,
                              MetaDisplay* display,
                              MetaWindow* window,
                              ClutterKeyEvent* event,
                              MetaKeyBinding* binding)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	budgie_budgie_wm_on_overlay_key (self);
}

static void
budgie_budgie_wm_launch_rundialog (BudgieBudgieWM* self,
                                   MetaDisplay* display,
                                   MetaWindow* window,
                                   ClutterKeyEvent* event,
                                   MetaKeyBinding* binding)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	{
		g_spawn_command_line_async ("budgie-run-dialog", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
budgie_budgie_wm_on_dialog_closed (BudgieBudgieWM* self,
                                   GPid pid,
                                   gint status)
{
	gboolean ok = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	ok = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_spawn_check_exit_status (status, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		ok = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	meta_plugin_complete_display_change ((MetaPlugin*) self, ok);
}

static void
_budgie_budgie_wm_on_dialog_closed_gchild_watch_func (GPid pid,
                                                      gint status,
                                                      gpointer self)
{
	budgie_budgie_wm_on_dialog_closed ((BudgieBudgieWM*) self, pid, status);
}

static void
budgie_budgie_wm_real_confirm_display_change (MetaPlugin* base)
{
	BudgieBudgieWM * self;
	GPid pid = 0;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GPid _tmp2_;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_tmp2_ = meta_show_dialog ("--question", "Does the display look OK?", "20", "", "_Keep This Configuration", "_Restore Previous Configuration", "preferences-desktop-display", 0, _tmp0_, _tmp1_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (g_slist_free (_tmp1_), NULL));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (g_slist_free (_tmp0_), NULL));
	pid = _tmp2_;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, _budgie_budgie_wm_on_dialog_closed_gchild_watch_func, g_object_ref (self), g_object_unref);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
budgie_budgie_wm_is_nvidia (BudgieBudgieWM* self)
{
	BudgieBudgieWMGlQueryFunc ptr = NULL;
	GCallback _tmp0_;
	gpointer ptr_target;
	GDestroyNotify ptr_target_destroy_notify;
	BudgieBudgieWMGlQueryFunc _tmp1_;
	gpointer _tmp1__target;
	const gchar* ret = NULL;
	BudgieBudgieWMGlQueryFunc _tmp2_;
	gpointer _tmp2__target;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = cogl_get_proc_address ("glGetString");
	ptr = (BudgieBudgieWMGlQueryFunc) _tmp0_;
	ptr_target = NULL;
	ptr_target_destroy_notify = NULL;
	_tmp1_ = ptr;
	_tmp1__target = ptr_target;
	if (_tmp1_ == NULL) {
		result = FALSE;
		(ptr_target_destroy_notify == NULL) ? NULL : (ptr_target_destroy_notify (ptr_target), NULL);
		ptr = NULL;
		ptr_target = NULL;
		ptr_target_destroy_notify = NULL;
		return result;
	}
	_tmp2_ = ptr;
	_tmp2__target = ptr_target;
	_tmp3_ = _tmp2_ (BUDGIE_BUDGIE_WM_GL_VENDOR, _tmp2__target);
	ret = _tmp3_;
	_tmp5_ = ret;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = ret;
		_tmp4_ = string_contains (_tmp6_, "NVIDIA Corporation");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		(ptr_target_destroy_notify == NULL) ? NULL : (ptr_target_destroy_notify (ptr_target), NULL);
		ptr = NULL;
		ptr_target = NULL;
		ptr_target_destroy_notify = NULL;
		return result;
	}
	result = FALSE;
	(ptr_target_destroy_notify == NULL) ? NULL : (ptr_target_destroy_notify (ptr_target), NULL);
	ptr = NULL;
	ptr_target = NULL;
	ptr_target_destroy_notify = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
_budgie_budgie_wm_on_wm_schema_changed_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	budgie_budgie_wm_on_wm_schema_changed ((BudgieBudgieWM*) self, key);
}

static void
_budgie_budgie_wm_update_workspace_count_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self)
{
	budgie_budgie_wm_update_workspace_count ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_on_raven_notification_clear_meta_key_handler_func (MetaDisplay* display,
                                                                     MetaWindow* window,
                                                                     ClutterKeyEvent* event,
                                                                     MetaKeyBinding* binding,
                                                                     gpointer self)
{
	budgie_budgie_wm_on_raven_notification_clear ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_take_full_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                 MetaWindow* window,
                                                                 ClutterKeyEvent* event,
                                                                 MetaKeyBinding* binding,
                                                                 gpointer self)
{
	budgie_budgie_wm_on_take_full_screenshot ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_take_region_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                   MetaWindow* window,
                                                                   ClutterKeyEvent* event,
                                                                   MetaKeyBinding* binding,
                                                                   gpointer self)
{
	budgie_budgie_wm_on_take_region_screenshot ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_take_window_screenshot_meta_key_handler_func (MetaDisplay* display,
                                                                   MetaWindow* window,
                                                                   ClutterKeyEvent* event,
                                                                   MetaKeyBinding* binding,
                                                                   gpointer self)
{
	budgie_budgie_wm_on_take_window_screenshot ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_raven_main_toggle_meta_key_handler_func (MetaDisplay* display,
                                                              MetaWindow* window,
                                                              ClutterKeyEvent* event,
                                                              MetaKeyBinding* binding,
                                                              gpointer self)
{
	budgie_budgie_wm_on_raven_main_toggle ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_raven_notification_toggle_meta_key_handler_func (MetaDisplay* display,
                                                                      MetaWindow* window,
                                                                      ClutterKeyEvent* event,
                                                                      MetaKeyBinding* binding,
                                                                      gpointer self)
{
	budgie_budgie_wm_on_raven_notification_toggle ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_on_overlay_key_meta_display_overlay_key (MetaDisplay* _sender,
                                                           gpointer self)
{
	budgie_budgie_wm_on_overlay_key ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_has_raven_gbus_name_appeared_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         const gchar* name_owner,
                                                         gpointer self)
{
	budgie_budgie_wm_has_raven ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_lost_raven_gbus_name_vanished_callback (GDBusConnection* connection,
                                                          const gchar* name,
                                                          gpointer self)
{
	budgie_budgie_wm_lost_raven ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_has_panel_gbus_name_appeared_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         const gchar* name_owner,
                                                         gpointer self)
{
	budgie_budgie_wm_has_panel ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_lost_panel_gbus_name_vanished_callback (GDBusConnection* connection,
                                                          const gchar* name,
                                                          gpointer self)
{
	budgie_budgie_wm_lost_panel ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_has_menu_gbus_name_appeared_callback (GDBusConnection* connection,
                                                        const gchar* name,
                                                        const gchar* name_owner,
                                                        gpointer self)
{
	budgie_budgie_wm_has_menu ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_lost_menu_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	budgie_budgie_wm_lost_menu ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_has_switcher_gbus_name_appeared_callback (GDBusConnection* connection,
                                                            const gchar* name,
                                                            const gchar* name_owner,
                                                            gpointer self)
{
	budgie_budgie_wm_has_switcher ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_lost_switcher_gbus_name_vanished_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             gpointer self)
{
	budgie_budgie_wm_lost_switcher ((BudgieBudgieWM*) self);
}

static void
_budgie_budgie_wm_launch_menu_meta_key_handler_func (MetaDisplay* display,
                                                     MetaWindow* window,
                                                     ClutterKeyEvent* event,
                                                     MetaKeyBinding* binding,
                                                     gpointer self)
{
	budgie_budgie_wm_launch_menu ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_launch_rundialog_meta_key_handler_func (MetaDisplay* display,
                                                          MetaWindow* window,
                                                          ClutterKeyEvent* event,
                                                          MetaKeyBinding* binding,
                                                          gpointer self)
{
	budgie_budgie_wm_launch_rundialog ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_switch_windows_meta_key_handler_func (MetaDisplay* display,
                                                        MetaWindow* window,
                                                        ClutterKeyEvent* event,
                                                        MetaKeyBinding* binding,
                                                        gpointer self)
{
	budgie_budgie_wm_switch_windows ((BudgieBudgieWM*) self, display, window, event, binding);
}

static void
_budgie_budgie_wm_switch_windows_backward_meta_key_handler_func (MetaDisplay* display,
                                                                 MetaWindow* window,
                                                                 ClutterKeyEvent* event,
                                                                 MetaKeyBinding* binding,
                                                                 gpointer self)
{
	budgie_budgie_wm_switch_windows_backward ((BudgieBudgieWM*) self, display, window, event, binding);
}

static gboolean
_budgie_budgie_wm_on_background_click_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                          ClutterButtonEvent* event,
                                                                          gpointer self)
{
	gboolean result;
	result = budgie_budgie_wm_on_background_click ((BudgieBudgieWM*) self, event);
	return result;
}

static void
_budgie_budgie_wm_on_monitors_changed_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                             gpointer self)
{
	budgie_budgie_wm_on_monitors_changed ((BudgieBudgieWM*) self);
}

static void
budgie_budgie_wm_real_start (MetaPlugin* base)
{
	BudgieBudgieWM * self;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* stage = NULL;
	MetaDisplay* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	MetaDisplay* _tmp17_;
	GSettings* _tmp18_;
	MetaDisplay* _tmp19_;
	GSettings* _tmp20_;
	MetaDisplay* _tmp21_;
	GSettings* _tmp22_;
	MetaDisplay* _tmp23_;
	GSettings* _tmp24_;
	MetaDisplay* _tmp25_;
	GSettings* _tmp26_;
	MetaDisplay* _tmp27_;
	GSettings* _tmp28_;
	MetaDisplay* _tmp29_;
	BudgieShellShim* _tmp30_;
	BudgieShellShim* _tmp31_;
	BudgieBudgieWMDBUS* _tmp32_;
	BudgieBudgieWMDBUS* _tmp33_;
	MetaBackgroundGroup* _tmp34_;
	MetaBackgroundGroup* _tmp35_;
	ClutterActor* _tmp36_;
	MetaBackgroundGroup* _tmp37_;
	MetaBackgroundGroup* _tmp38_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaMonitorManager* _tmp39_;
	MetaMonitorManager* _tmp40_;
	MetaBackgroundGroup* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	BudgieKeyboardManager* _tmp44_;
	BudgieKeyboardManager* _tmp45_;
	MetaDisplay* _tmp46_;
	MetaWorkspaceManager* _tmp47_;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_get_window_group_for_display (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->display_group);
	self->priv->display_group = _tmp4_;
	_tmp5_ = display;
	_tmp6_ = meta_get_stage_for_display (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	stage = _tmp7_;
	_tmp8_ = g_direct_hash;
	_tmp9_ = g_direct_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->state_map);
	self->priv->state_map = _tmp10_;
	_tmp11_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->iface_settings);
	self->priv->iface_settings = _tmp11_;
	_tmp12_ = self->priv->iface_settings;
	g_settings_bind (_tmp12_, "enable-animations", (GObject*) self, "use-animations", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = g_settings_new (BUDGIE_WM_SCHEMA);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp13_;
	_tmp14_ = g_settings_new ("org.gnome.desktop.wm.preferences");
	_g_object_unref0 (self->priv->gnome_desktop_prefs);
	self->priv->gnome_desktop_prefs = _tmp14_;
	_tmp15_ = self->priv->settings;
	g_signal_connect_object (_tmp15_, "changed", (GCallback) _budgie_budgie_wm_on_wm_schema_changed_g_settings_changed, self, 0);
	budgie_budgie_wm_on_wm_schema_changed (self, BUDGIE_EXPERIMENTAL_DIALOG);
	budgie_budgie_wm_on_wm_schema_changed (self, BUDGIE_WM_FORCE_UNREDIRECT);
	budgie_budgie_wm_update_workspace_count (self);
	_tmp16_ = self->priv->gnome_desktop_prefs;
	g_signal_connect_object (_tmp16_, "changed::num-workspaces", (GCallback) _budgie_budgie_wm_update_workspace_count_g_settings_changed, self, 0);
	_tmp17_ = display;
	_tmp18_ = self->priv->settings;
	meta_display_add_keybinding (_tmp17_, "clear-notifications", _tmp18_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_raven_notification_clear_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp19_ = display;
	_tmp20_ = self->priv->settings;
	meta_display_add_keybinding (_tmp19_, "take-full-screenshot", _tmp20_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_take_full_screenshot_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp21_ = display;
	_tmp22_ = self->priv->settings;
	meta_display_add_keybinding (_tmp21_, "take-region-screenshot", _tmp22_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_take_region_screenshot_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp23_ = display;
	_tmp24_ = self->priv->settings;
	meta_display_add_keybinding (_tmp23_, "take-window-screenshot", _tmp24_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_take_window_screenshot_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp25_ = display;
	_tmp26_ = self->priv->settings;
	meta_display_add_keybinding (_tmp25_, "toggle-raven", _tmp26_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_raven_main_toggle_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp27_ = display;
	_tmp28_ = self->priv->settings;
	meta_display_add_keybinding (_tmp27_, "toggle-notifications", _tmp28_, META_KEY_BINDING_NONE, _budgie_budgie_wm_on_raven_notification_toggle_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp29_ = display;
	g_signal_connect_object (_tmp29_, "overlay-key", (GCallback) _budgie_budgie_wm_on_overlay_key_meta_display_overlay_key, self, 0);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_RAVEN_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_budgie_wm_has_raven_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_has_raven_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_budgie_wm_lost_raven_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_lost_raven_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_PANEL_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_budgie_wm_has_panel_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_has_panel_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_budgie_wm_lost_panel_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_lost_panel_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_MENU_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_budgie_wm_has_menu_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_has_menu_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_budgie_wm_lost_menu_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_lost_menu_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_SWITCHER_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_budgie_wm_has_switcher_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_has_switcher_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_budgie_budgie_wm_lost_switcher_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wm_lost_switcher_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	if (budgie_budgie_wm_have_logind (self)) {
		budgie_budgie_wm_get_logind (self);
	}
	meta_keybindings_set_custom_handler ("panel-main-menu", _budgie_budgie_wm_launch_menu_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("panel-run-dialog", _budgie_budgie_wm_launch_rundialog_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-windows", _budgie_budgie_wm_switch_windows_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-windows-backward", _budgie_budgie_wm_switch_windows_backward_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-applications", _budgie_budgie_wm_switch_windows_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_keybindings_set_custom_handler ("switch-applications-backward", _budgie_budgie_wm_switch_windows_backward_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_tmp30_ = budgie_shell_shim_new (self);
	_g_object_unref0 (self->priv->shim);
	self->priv->shim = _tmp30_;
	_tmp31_ = self->priv->shim;
	budgie_shell_shim_serve (_tmp31_);
	_tmp32_ = budgie_budgie_wmdbus_new (self);
	_g_object_unref0 (self->priv->focus_interface);
	self->priv->focus_interface = _tmp32_;
	_tmp33_ = self->priv->focus_interface;
	budgie_budgie_wmdbus_serve (_tmp33_);
	_tmp34_ = (MetaBackgroundGroup*) meta_background_group_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->background_group);
	self->priv->background_group = _tmp34_;
	_tmp35_ = self->priv->background_group;
	clutter_actor_set_reactive ((ClutterActor*) _tmp35_, TRUE);
	_tmp36_ = self->priv->display_group;
	_tmp37_ = self->priv->background_group;
	clutter_actor_insert_child_below (_tmp36_, (ClutterActor*) _tmp37_, NULL);
	_tmp38_ = self->priv->background_group;
	g_signal_connect_object ((ClutterActor*) _tmp38_, "button-release-event", (GCallback) _budgie_budgie_wm_on_background_click_clutter_actor_button_release_event, self, 0);
	_tmp39_ = meta_monitor_manager_get ();
	_tmp40_ = _g_object_ref0 (_tmp39_);
	monitor_manager = _tmp40_;
	g_signal_connect_object (monitor_manager, "monitors-changed", (GCallback) _budgie_budgie_wm_on_monitors_changed_meta_monitor_manager_monitors_changed, self, 0);
	budgie_budgie_wm_on_monitors_changed (self);
	_tmp41_ = self->priv->background_group;
	clutter_actor_show ((ClutterActor*) _tmp41_);
	_tmp42_ = self->priv->display_group;
	clutter_actor_show (_tmp42_);
	_tmp43_ = stage;
	clutter_actor_show (_tmp43_);
	_tmp44_ = budgie_keyboard_manager_new (self);
	_g_object_unref0 (self->priv->keyboard);
	self->priv->keyboard = _tmp44_;
	_tmp45_ = self->priv->keyboard;
	budgie_keyboard_manager_hook_extra (_tmp45_);
	_tmp46_ = display;
	_tmp47_ = meta_display_get_workspace_manager (_tmp46_);
	meta_workspace_manager_override_workspace_layout (_tmp47_, META_DISPLAY_TOPLEFT, FALSE, 1, -1);
	_g_object_unref0 (monitor_manager);
	_g_object_unref0 (stage);
	_g_object_unref0 (display);
}

/**
* Launch menu manager with our wallpaper
*/
static gboolean
budgie_budgie_wm_on_background_click (BudgieBudgieWM* self,
                                      ClutterButtonEvent* event)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (event->button == ((guint32) 1)) {
		budgie_budgie_wm_dismiss_raven (self);
	} else {
		if (event->button == ((guint32) 3)) {
			BudgieMenuManager* _tmp0_;
			_tmp0_ = self->priv->menu_proxy;
			if (_tmp0_ == NULL) {
				result = BUDGIE_CLUTTER_EVENT_STOP;
				return result;
			}
			{
				BudgieMenuManager* _tmp1_;
				_tmp1_ = self->priv->menu_proxy;
				budgie_menu_manager_ShowDesktopMenu (_tmp1_, (guint) 3, (guint32) 0, NULL, NULL);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp2_;
				const gchar* _tmp3_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp2_ = e;
				_tmp3_ = _tmp2_->message;
				g_message ("wm.vala:531: Error invoking MenuManager: %s", _tmp3_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp4_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp4_;
			}
		} else {
			result = BUDGIE_CLUTTER_EVENT_PROPAGATE;
			return result;
		}
	}
	result = BUDGIE_CLUTTER_EVENT_STOP;
	return result;
}

static void
budgie_budgie_wm_on_wm_schema_changed (BudgieBudgieWM* self,
                                       const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, BUDGIE_EXPERIMENTAL_DIALOG) == 0) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->settings;
		self->priv->enabled_experimental_run_diag_as_menu = g_settings_get_boolean (_tmp0_, key);
	} else {
		if (g_strcmp0 (key, BUDGIE_WM_FORCE_UNREDIRECT) == 0) {
			gboolean enab = FALSE;
			GSettings* _tmp1_;
			MetaDisplay* display = NULL;
			MetaDisplay* _tmp2_;
			MetaDisplay* _tmp3_;
			_tmp1_ = self->priv->settings;
			enab = g_settings_get_boolean (_tmp1_, key);
			if (enab == self->priv->force_unredirect) {
				return;
			}
			_tmp2_ = meta_plugin_get_display ((MetaPlugin*) self);
			_tmp3_ = _g_object_ref0 (_tmp2_);
			display = _tmp3_;
			if (enab) {
				MetaDisplay* _tmp4_;
				_tmp4_ = display;
				meta_enable_unredirect_for_display (_tmp4_);
			} else {
				MetaDisplay* _tmp5_;
				_tmp5_ = display;
				meta_disable_unredirect_for_display (_tmp5_);
			}
			self->priv->force_unredirect = enab;
			_g_object_unref0 (display);
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieBudgieWM* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->window);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda11_ (Block4Data* _data4_)
{
	BudgieBudgieWM* self;
	guint32 xid = 0U;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data4_->self;
	xid = (guint32) meta_window_get_xwindow (_data4_->window);
	{
		BudgieMenuManager* _tmp0_;
		_tmp0_ = self->priv->menu_proxy;
		budgie_menu_manager_ShowWindowMenu (_tmp0_, xid, (guint) 3, (guint32) 0, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("wm.vala:572: Error invoking MenuManager: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
	return result;
}

static void
budgie_budgie_wm_real_show_window_menu (MetaPlugin* base,
                                        MetaWindow* window,
                                        MetaWindowMenuType type,
                                        gint x,
                                        gint y)
{
	BudgieBudgieWM * self;
	Block4Data* _data4_;
	MetaWindow* _tmp0_;
	BudgieMenuManager* _tmp1_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (window != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data4_->window);
	_data4_->window = _tmp0_;
	if (type != META_WINDOW_MENU_WM) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp1_ = self->priv->menu_proxy;
	if (_tmp1_ == NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda11__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

/**
* update_workspace_count will update our workspace count trigger workspace creation / removal
*/
void
budgie_budgie_wm_update_workspace_count (BudgieBudgieWM* self)
{
	MetaWorkspaceManager* wsm = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gint current_workspace_count = 0;
	MetaWorkspaceManager* _tmp2_;
	gint new_workspace_count = 0;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	wsm = _tmp1_;
	_tmp2_ = wsm;
	current_workspace_count = meta_workspace_manager_get_n_workspaces (_tmp2_);
	_tmp3_ = self->priv->gnome_desktop_prefs;
	new_workspace_count = g_settings_get_int (_tmp3_, "num-workspaces");
	if (new_workspace_count > 8) {
		GSettings* _tmp4_;
		_tmp4_ = self->priv->gnome_desktop_prefs;
		g_settings_set_int (_tmp4_, "num-workspaces", 8);
	}
	if (new_workspace_count != current_workspace_count) {
		if (new_workspace_count > current_workspace_count) {
			while (TRUE) {
				MetaWorkspaceManager* _tmp5_;
				MetaWorkspaceManager* _tmp6_;
				MetaDisplay* _tmp7_;
				_tmp5_ = wsm;
				if (!(meta_workspace_manager_get_n_workspaces (_tmp5_) < new_workspace_count)) {
					break;
				}
				_tmp6_ = wsm;
				_tmp7_ = meta_plugin_get_display ((MetaPlugin*) self);
				meta_workspace_manager_append_new_workspace (_tmp6_, FALSE, meta_display_get_current_time (_tmp7_));
			}
		} else {
			while (TRUE) {
				MetaWorkspaceManager* _tmp8_;
				MetaWorkspace* last_workspace = NULL;
				MetaWorkspaceManager* _tmp9_;
				MetaWorkspaceManager* _tmp10_;
				MetaWorkspace* _tmp11_;
				MetaWorkspace* _tmp12_;
				MetaWorkspace* _tmp13_;
				_tmp8_ = wsm;
				if (!(meta_workspace_manager_get_n_workspaces (_tmp8_) > new_workspace_count)) {
					break;
				}
				_tmp9_ = wsm;
				_tmp10_ = wsm;
				_tmp11_ = meta_workspace_manager_get_workspace_by_index (_tmp9_, meta_workspace_manager_get_n_workspaces (_tmp10_) - 1);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				last_workspace = _tmp12_;
				_tmp13_ = last_workspace;
				if (_tmp13_ != NULL) {
					MetaWorkspaceManager* _tmp14_;
					MetaWorkspace* _tmp15_;
					MetaDisplay* _tmp16_;
					_tmp14_ = wsm;
					_tmp15_ = last_workspace;
					_tmp16_ = meta_plugin_get_display ((MetaPlugin*) self);
					meta_workspace_manager_remove_workspace (_tmp14_, _tmp15_, meta_display_get_current_time (_tmp16_));
				}
				_g_object_unref0 (last_workspace);
			}
		}
	}
}

static void
budgie_budgie_wm_dismiss_raven (BudgieBudgieWM* self)
{
	BudgieRavenRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ != NULL) {
		BudgieRavenRemote* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		budgie_raven_remote_Dismiss (_tmp1_, NULL, NULL);
	}
}

static void
budgie_budgie_wm_on_monitors_changed (BudgieBudgieWM* self)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaBackgroundGroup* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->background_group;
	clutter_actor_destroy_all_children ((ClutterActor*) _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				MetaDisplay* _tmp5_;
				BudgieBudgieBackground* actor = NULL;
				MetaDisplay* _tmp6_;
				BudgieBudgieBackground* _tmp7_;
				MetaBackgroundGroup* _tmp8_;
				BudgieBudgieBackground* _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = display;
				if (!(i < meta_display_get_n_monitors (_tmp5_))) {
					break;
				}
				_tmp6_ = display;
				_tmp7_ = budgie_budgie_background_new (_tmp6_, i, self);
				g_object_ref_sink (_tmp7_);
				actor = _tmp7_;
				_tmp8_ = self->priv->background_group;
				_tmp9_ = actor;
				clutter_actor_add_child ((ClutterActor*) _tmp8_, (ClutterActor*) _tmp9_);
				_g_object_unref0 (actor);
			}
		}
	}
	_g_object_unref0 (display);
}

static void
budgie_budgie_wm_finalize_animations (BudgieBudgieWM* self,
                                      MetaWindowActor* actor)
{
	GHashTable* _tmp0_;
	BudgieAnimationState* state = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	BudgieAnimationState* _tmp3_;
	GHashTable* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state_map;
	if (!g_hash_table_contains (_tmp0_, actor)) {
		return;
	}
	clutter_actor_remove_all_transitions ((ClutterActor*) actor);
	_tmp1_ = self->priv->state_map;
	_tmp2_ = g_hash_table_lookup (_tmp1_, actor);
	state = (BudgieAnimationState*) _tmp2_;
	_tmp3_ = state;
	switch (*_tmp3_) {
		case BUDGIE_ANIMATION_STATE_MAP:
		{
			graphene_point_t _tmp4_;
			_tmp4_ = budgie_budgie_wm_PV_NORM;
			g_object_set ((GObject*) actor, "pivot-point", &_tmp4_, "opacity", 255U, NULL);
			meta_plugin_map_completed ((MetaPlugin*) self, actor);
			break;
		}
		case BUDGIE_ANIMATION_STATE_DESTROY:
		{
			meta_plugin_destroy_completed ((MetaPlugin*) self, actor);
			break;
		}
		case BUDGIE_ANIMATION_STATE_MINIMIZE:
		{
			graphene_point_t _tmp5_;
			_tmp5_ = budgie_budgie_wm_PV_NORM;
			g_object_set ((GObject*) actor, "pivot-point", &_tmp5_, "opacity", 255U, "scale-x", 1.0, "scale-y", 1.0, NULL);
			clutter_actor_hide ((ClutterActor*) actor);
			meta_plugin_minimize_completed ((MetaPlugin*) self, actor);
			break;
		}
		case BUDGIE_ANIMATION_STATE_UNMINIMIZE:
		{
			graphene_point_t _tmp6_;
			_tmp6_ = budgie_budgie_wm_PV_NORM;
			g_object_set ((GObject*) actor, "pivot-point", &_tmp6_, "opacity", 255U, "scale-x", 1.0, "scale-y", 1.0, NULL);
			meta_plugin_unminimize_completed ((MetaPlugin*) self, actor);
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp7_ = self->priv->state_map;
	g_hash_table_remove (_tmp7_, actor);
}

static void
budgie_budgie_wm_map_done (BudgieBudgieWM* self,
                           ClutterActor* actor)
{
	g_return_if_fail (self != NULL);
	g_signal_handlers_disconnect_by_func (actor, (void*) budgie_budgie_wm_map_done, self);
	budgie_budgie_wm_finalize_animations (self, G_TYPE_CHECK_INSTANCE_TYPE (actor, meta_window_actor_get_type ()) ? ((MetaWindowActor*) actor) : NULL);
}

/**
* Store the focused window
*/
void
budgie_budgie_wm_store_focused (BudgieBudgieWM* self)
{
	MetaWorkspace* workspace = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	_tmp2_ = meta_workspace_manager_get_active_workspace (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	workspace = _tmp3_;
	_tmp4_ = workspace;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (workspace);
		return;
	}
	_tmp5_ = workspace;
	_tmp6_ = meta_workspace_list_windows (_tmp5_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp7_;
				_tmp7_ = window;
				if (meta_window_has_focus (_tmp7_)) {
					MetaWindow* _tmp8_;
					_tmp8_ = window;
					self->priv->focused_window = _tmp8_;
					break;
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	_g_object_unref0 (workspace);
}

/**
* Restore the focused window
*/
void
budgie_budgie_wm_restore_focused (BudgieBudgieWM* self)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaDisplay* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->focused_window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->focused_window;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) self);
	meta_window_focus (_tmp1_, meta_display_get_current_time (_tmp2_));
	self->priv->focused_window = NULL;
}

static void
_budgie_budgie_wm_map_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                gpointer self)
{
	budgie_budgie_wm_map_done ((BudgieBudgieWM*) self, _sender);
}

static BudgieAnimationState*
_budgie_animation_state_dup (BudgieAnimationState* self)
{
	BudgieAnimationState* dup;
	dup = g_new0 (BudgieAnimationState, 1);
	memcpy (dup, self, sizeof (BudgieAnimationState));
	return dup;
}

static gpointer
__budgie_animation_state_dup0 (gpointer self)
{
	return self ? _budgie_animation_state_dup (self) : NULL;
}

static void
budgie_budgie_wm_real_map (MetaPlugin* base,
                           MetaWindowActor* actor)
{
	BudgieBudgieWM * self;
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	gboolean _tmp2_;
	MetaWindow* _tmp3_;
	GHashTable* _tmp9_;
	MetaWindowActor* _tmp10_;
	BudgieAnimationState _tmp11_;
	BudgieAnimationState* _tmp12_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (actor != NULL);
	_tmp0_ = meta_window_actor_get_meta_window (actor);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = self->priv->_use_animations;
	if (!_tmp2_) {
		meta_plugin_map_completed ((MetaPlugin*) self, actor);
		_g_object_unref0 (window);
		return;
	}
	_tmp3_ = window;
	switch (meta_window_get_window_type (_tmp3_)) {
		case META_WINDOW_POPUP_MENU:
		case META_WINDOW_DROPDOWN_MENU:
		case META_WINDOW_MENU:
		{
			graphene_point_t _tmp4_;
			_tmp4_ = budgie_budgie_wm_PV_CENTER;
			g_object_set ((GObject*) actor, "opacity", 0U, "scale-x", BUDGIE_BUDGIE_WM_MENU_MAP_SCALE_X, "scale-y", BUDGIE_BUDGIE_WM_MENU_MAP_SCALE_Y, "pivot-point", &_tmp4_, NULL);
			clutter_actor_show ((ClutterActor*) actor);
			clutter_actor_save_easing_state ((ClutterActor*) actor);
			clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_CIRC);
			clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_MENU_MAP_TIMEOUT);
			g_object_set ((GObject*) actor, "scale-x", 1.0, "scale-y", 1.0, "opacity", 255U, NULL);
			break;
		}
		case META_WINDOW_NOTIFICATION:
		{
			MetaWindow* _tmp5_;
			const gchar* _tmp6_;
			graphene_point_t _tmp7_;
			_tmp5_ = window;
			_tmp6_ = meta_window_get_wm_class (_tmp5_);
			if (g_strcmp0 (_tmp6_, "raven") == 0) {
				meta_plugin_map_completed ((MetaPlugin*) self, actor);
				_g_object_unref0 (window);
				return;
			}
			_tmp7_ = budgie_budgie_wm_PV_CENTER;
			g_object_set ((GObject*) actor, "opacity", 0U, "scale-x", BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_X, "scale-y", BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_Y, "pivot-point", &_tmp7_, NULL);
			clutter_actor_show ((ClutterActor*) actor);
			clutter_actor_save_easing_state ((ClutterActor*) actor);
			clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_QUART);
			clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_MAP_TIMEOUT);
			g_object_set ((GObject*) actor, "scale-x", 1.0, "scale-y", 1.0, "opacity", 255U, NULL);
			break;
		}
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		{
			graphene_point_t _tmp8_;
			_tmp8_ = budgie_budgie_wm_PV_CENTER;
			g_object_set ((GObject*) actor, "opacity", 0U, "scale-x", BUDGIE_BUDGIE_WM_MAP_SCALE, "scale-y", BUDGIE_BUDGIE_WM_MAP_SCALE, "pivot-point", &_tmp8_, NULL);
			clutter_actor_show ((ClutterActor*) actor);
			clutter_actor_save_easing_state ((ClutterActor*) actor);
			clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_QUAD);
			clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_MAP_TIMEOUT);
			g_object_set ((GObject*) actor, "scale-x", 1.0, "scale-y", 1.0, "opacity", 255U, NULL);
			break;
		}
		default:
		{
			meta_plugin_map_completed ((MetaPlugin*) self, actor);
			_g_object_unref0 (window);
			return;
		}
	}
	g_signal_connect_object ((ClutterActor*) actor, "transitions-completed", (GCallback) _budgie_budgie_wm_map_done_clutter_actor_transitions_completed, self, 0);
	_tmp9_ = self->priv->state_map;
	_tmp10_ = _g_object_ref0 (actor);
	_tmp11_ = BUDGIE_ANIMATION_STATE_MAP;
	_tmp12_ = __budgie_animation_state_dup0 (&_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, (gpointer) ((gintptr) _tmp12_));
	clutter_actor_restore_easing_state ((ClutterActor*) actor);
	_g_object_unref0 (window);
}

static void
budgie_budgie_wm_minimize_done (BudgieBudgieWM* self,
                                ClutterActor* actor)
{
	g_return_if_fail (self != NULL);
	g_signal_handlers_disconnect_by_func (actor, (void*) budgie_budgie_wm_minimize_done, self);
	budgie_budgie_wm_finalize_animations (self, G_TYPE_CHECK_INSTANCE_TYPE (actor, meta_window_actor_get_type ()) ? ((MetaWindowActor*) actor) : NULL);
}

static void
_budgie_budgie_wm_minimize_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                     gpointer self)
{
	budgie_budgie_wm_minimize_done ((BudgieBudgieWM*) self, _sender);
}

static gpointer
_budgie_minimize_data_ref0 (gpointer self)
{
	return self ? budgie_minimize_data_ref (self) : NULL;
}

static void
budgie_budgie_wm_real_minimize (MetaPlugin* base,
                                MetaWindowActor* actor)
{
	BudgieBudgieWM * self;
	gboolean _tmp0_;
	MetaRectangle icon = {0};
	MetaWindow* window = NULL;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaRectangle _tmp5_ = {0};
	gboolean _tmp6_;
	GHashTable* _tmp7_;
	MetaWindowActor* _tmp8_;
	BudgieAnimationState _tmp9_;
	BudgieAnimationState* _tmp10_;
	gint scale_factor = 0;
	MetaBackend* _tmp11_;
	MetaSettings* _tmp12_;
	gfloat scale_x = 0.0F;
	MetaRectangle _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat scale_y = 0.0F;
	MetaRectangle _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gfloat place_x = 0.0F;
	MetaRectangle _tmp19_;
	gfloat place_y = 0.0F;
	MetaRectangle _tmp20_;
	gfloat old_x = 0.0F;
	gfloat _tmp21_;
	gfloat _tmp22_;
	gfloat old_y = 0.0F;
	gfloat _tmp23_;
	gfloat _tmp24_;
	BudgieMinimizeData* d = NULL;
	BudgieMinimizeData* _tmp25_;
	BudgieMinimizeData* _tmp26_;
	BudgieMinimizeData* _tmp27_;
	BudgieMinimizeData* _tmp28_;
	BudgieMinimizeData* _tmp29_;
	BudgieMinimizeData* _tmp30_;
	BudgieMinimizeData* _tmp31_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_use_animations;
	if (!_tmp0_) {
		meta_plugin_minimize_completed ((MetaPlugin*) self, actor);
		return;
	}
	_tmp1_ = meta_window_actor_get_meta_window (actor);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	if (meta_window_get_window_type (_tmp3_) != META_WINDOW_NORMAL) {
		meta_plugin_minimize_completed ((MetaPlugin*) self, actor);
		_g_object_unref0 (window);
		return;
	}
	_tmp4_ = window;
	_tmp6_ = meta_window_get_icon_geometry (_tmp4_, &_tmp5_);
	icon = _tmp5_;
	if (!_tmp6_) {
		icon.x = 0;
		icon.y = 0;
	}
	budgie_budgie_wm_finalize_animations (self, actor);
	_tmp7_ = self->priv->state_map;
	_tmp8_ = _g_object_ref0 (actor);
	_tmp9_ = BUDGIE_ANIMATION_STATE_MINIMIZE;
	_tmp10_ = __budgie_animation_state_dup0 (&_tmp9_);
	g_hash_table_insert (_tmp7_, _tmp8_, (gpointer) ((gintptr) _tmp10_));
	clutter_actor_save_easing_state ((ClutterActor*) actor);
	clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_MINIMIZE_TIMEOUT);
	g_signal_connect_object ((ClutterActor*) actor, "transitions-completed", (GCallback) _budgie_budgie_wm_minimize_done_clutter_actor_transitions_completed, self, 0);
	_tmp11_ = meta_get_backend ();
	_tmp12_ = meta_backend_get_settings (_tmp11_);
	scale_factor = meta_settings_get_ui_scaling_factor (_tmp12_);
	_tmp13_ = icon;
	_tmp14_ = clutter_actor_get_width ((ClutterActor*) actor);
	_tmp15_ = _tmp14_;
	scale_x = (gfloat) ((_tmp13_.width * scale_factor) / _tmp15_);
	_tmp16_ = icon;
	_tmp17_ = clutter_actor_get_height ((ClutterActor*) actor);
	_tmp18_ = _tmp17_;
	scale_y = (gfloat) ((_tmp16_.height * scale_factor) / _tmp18_);
	_tmp19_ = icon;
	place_x = ((gfloat) _tmp19_.x) * scale_factor;
	_tmp20_ = icon;
	place_y = ((gfloat) _tmp20_.y) * scale_factor;
	_tmp21_ = clutter_actor_get_x ((ClutterActor*) actor);
	_tmp22_ = _tmp21_;
	old_x = (gfloat) _tmp22_;
	_tmp23_ = clutter_actor_get_y ((ClutterActor*) actor);
	_tmp24_ = _tmp23_;
	old_y = (gfloat) _tmp24_;
	_tmp25_ = budgie_minimize_data_new (scale_x, scale_y, place_x, place_y, old_x, old_y);
	d = _tmp25_;
	_tmp26_ = d;
	_tmp27_ = _budgie_minimize_data_ref0 (_tmp26_);
	g_object_set_data_full ((GObject*) actor, "_minimize_data", _tmp27_, budgie_minimize_data_unref);
	_tmp28_ = d;
	_tmp29_ = d;
	clutter_actor_set_scale ((ClutterActor*) actor, (gdouble) _tmp28_->scale_x, (gdouble) _tmp29_->scale_y);
	_tmp30_ = d;
	clutter_actor_set_x ((ClutterActor*) actor, _tmp30_->place_x);
	_tmp31_ = d;
	clutter_actor_set_y ((ClutterActor*) actor, _tmp31_->place_y);
	clutter_actor_set_opacity ((ClutterActor*) actor, 0U);
	clutter_actor_set_content_gravity ((ClutterActor*) actor, CLUTTER_CONTENT_GRAVITY_TOP_LEFT);
	clutter_actor_set_pivot_point ((ClutterActor*) actor, 0.f, 0.f);
	clutter_actor_restore_easing_state ((ClutterActor*) actor);
	_budgie_minimize_data_unref0 (d);
	_g_object_unref0 (window);
}

/**
* Unminimize now done
*/
static void
budgie_budgie_wm_unminimize_done (BudgieBudgieWM* self,
                                  ClutterActor* actor)
{
	g_return_if_fail (self != NULL);
	g_signal_handlers_disconnect_by_func (actor, (void*) budgie_budgie_wm_unminimize_done, self);
	budgie_budgie_wm_finalize_animations (self, G_TYPE_CHECK_INSTANCE_TYPE (actor, meta_window_actor_get_type ()) ? ((MetaWindowActor*) actor) : NULL);
}

/**
* Handle unminimize animation
*/
static void
_budgie_budgie_wm_unminimize_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                       gpointer self)
{
	budgie_budgie_wm_unminimize_done ((BudgieBudgieWM*) self, _sender);
}

static void
budgie_budgie_wm_real_unminimize (MetaPlugin* base,
                                  MetaWindowActor* actor)
{
	BudgieBudgieWM * self;
	gboolean _tmp0_;
	BudgieMinimizeData* d = NULL;
	gconstpointer _tmp1_;
	BudgieMinimizeData* _tmp2_;
	BudgieMinimizeData* _tmp3_;
	BudgieMinimizeData* _tmp4_;
	BudgieMinimizeData* _tmp5_;
	BudgieMinimizeData* _tmp6_;
	BudgieMinimizeData* _tmp7_;
	BudgieMinimizeData* _tmp8_;
	BudgieMinimizeData* _tmp9_;
	GHashTable* _tmp10_;
	MetaWindowActor* _tmp11_;
	BudgieAnimationState _tmp12_;
	BudgieAnimationState* _tmp13_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_use_animations;
	if (!_tmp0_) {
		meta_plugin_unminimize_completed ((MetaPlugin*) self, actor);
		return;
	}
	_tmp1_ = g_object_get_data ((GObject*) actor, "_minimize_data");
	_tmp2_ = _budgie_minimize_data_ref0 ((BudgieMinimizeData*) _tmp1_);
	d = _tmp2_;
	_tmp3_ = d;
	if (_tmp3_ == NULL) {
		meta_plugin_unminimize_completed ((MetaPlugin*) self, actor);
		_budgie_minimize_data_unref0 (d);
		return;
	}
	budgie_budgie_wm_finalize_animations (self, actor);
	clutter_actor_set_pivot_point ((ClutterActor*) actor, 0.f, 0.f);
	_tmp4_ = d;
	_tmp5_ = d;
	clutter_actor_set_scale ((ClutterActor*) actor, (gdouble) _tmp4_->scale_x, (gdouble) _tmp5_->scale_y);
	_tmp6_ = d;
	clutter_actor_set_x ((ClutterActor*) actor, _tmp6_->place_x);
	_tmp7_ = d;
	clutter_actor_set_y ((ClutterActor*) actor, _tmp7_->place_y);
	clutter_actor_set_opacity ((ClutterActor*) actor, 0U);
	clutter_actor_show ((ClutterActor*) actor);
	clutter_actor_save_easing_state ((ClutterActor*) actor);
	clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_UNMINIMIZE_TIMEOUT);
	clutter_actor_set_scale ((ClutterActor*) actor, (gdouble) 1.0f, (gdouble) 1.0f);
	clutter_actor_set_opacity ((ClutterActor*) actor, 255U);
	_tmp8_ = d;
	clutter_actor_set_x ((ClutterActor*) actor, _tmp8_->old_x);
	_tmp9_ = d;
	clutter_actor_set_y ((ClutterActor*) actor, _tmp9_->old_y);
	g_signal_connect_object ((ClutterActor*) actor, "transitions-completed", (GCallback) _budgie_budgie_wm_unminimize_done_clutter_actor_transitions_completed, self, 0);
	_tmp10_ = self->priv->state_map;
	_tmp11_ = _g_object_ref0 (actor);
	_tmp12_ = BUDGIE_ANIMATION_STATE_UNMINIMIZE;
	_tmp13_ = __budgie_animation_state_dup0 (&_tmp12_);
	g_hash_table_insert (_tmp10_, _tmp11_, (gpointer) ((gintptr) _tmp13_));
	clutter_actor_restore_easing_state ((ClutterActor*) actor);
	g_object_set_data_full ((GObject*) actor, "_minimize_data", NULL, NULL);
	_budgie_minimize_data_unref0 (d);
}

static void
budgie_budgie_wm_destroy_done (BudgieBudgieWM* self,
                               ClutterActor* actor)
{
	g_return_if_fail (self != NULL);
	g_signal_handlers_disconnect_by_func (actor, (void*) budgie_budgie_wm_destroy_done, self);
	budgie_budgie_wm_finalize_animations (self, G_TYPE_CHECK_INSTANCE_TYPE (actor, meta_window_actor_get_type ()) ? ((MetaWindowActor*) actor) : NULL);
}

static void
_budgie_budgie_wm_destroy_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                    gpointer self)
{
	budgie_budgie_wm_destroy_done ((BudgieBudgieWM*) self, _sender);
}

static void
budgie_budgie_wm_real_destroy (MetaPlugin* base,
                               MetaWindowActor* actor)
{
	BudgieBudgieWM * self;
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	gboolean _tmp4_;
	MetaWindow* _tmp5_;
	GHashTable* _tmp8_;
	MetaWindowActor* _tmp9_;
	BudgieAnimationState _tmp10_;
	BudgieAnimationState* _tmp11_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (actor != NULL);
	_tmp0_ = meta_window_actor_get_meta_window (actor);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = self->priv->focused_window;
	_tmp3_ = window;
	if (_tmp2_ == _tmp3_) {
		self->priv->focused_window = NULL;
	}
	_tmp4_ = self->priv->_use_animations;
	if (!_tmp4_) {
		meta_plugin_destroy_completed ((MetaPlugin*) self, actor);
		_g_object_unref0 (window);
		return;
	}
	budgie_budgie_wm_finalize_animations (self, actor);
	_tmp5_ = window;
	switch (meta_window_get_window_type (_tmp5_)) {
		case META_WINDOW_NOTIFICATION:
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		{
			graphene_point_t _tmp6_;
			_tmp6_ = budgie_budgie_wm_PV_CENTER;
			g_object_set ((GObject*) actor, "pivot-point", &_tmp6_, NULL);
			clutter_actor_save_easing_state ((ClutterActor*) actor);
			clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_QUAD);
			clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_DESTROY_TIMEOUT);
			g_object_set ((GObject*) actor, "scale-x", BUDGIE_BUDGIE_WM_DESTROY_SCALE, "scale-y", BUDGIE_BUDGIE_WM_DESTROY_SCALE, "opacity", 0U, NULL);
			break;
		}
		case META_WINDOW_MENU:
		case META_WINDOW_POPUP_MENU:
		case META_WINDOW_DROPDOWN_MENU:
		{
			graphene_point_t _tmp7_;
			_tmp7_ = budgie_budgie_wm_PV_CENTER;
			g_object_set ((GObject*) actor, "pivot-point", &_tmp7_, NULL);
			clutter_actor_save_easing_state ((ClutterActor*) actor);
			clutter_actor_set_easing_mode ((ClutterActor*) actor, CLUTTER_EASE_OUT_QUAD);
			clutter_actor_set_easing_duration ((ClutterActor*) actor, (guint) BUDGIE_BUDGIE_WM_DESTROY_TIMEOUT);
			g_object_set ((GObject*) actor, "opacity", 0U, NULL);
			break;
		}
		default:
		{
			meta_plugin_destroy_completed ((MetaPlugin*) self, actor);
			_g_object_unref0 (window);
			return;
		}
	}
	g_signal_connect_object ((ClutterActor*) actor, "transitions-completed", (GCallback) _budgie_budgie_wm_destroy_done_clutter_actor_transitions_completed, self, 0);
	_tmp8_ = self->priv->state_map;
	_tmp9_ = _g_object_ref0 (actor);
	_tmp10_ = BUDGIE_ANIMATION_STATE_DESTROY;
	_tmp11_ = __budgie_animation_state_dup0 (&_tmp10_);
	g_hash_table_insert (_tmp8_, _tmp9_, (gpointer) ((gintptr) _tmp11_));
	clutter_actor_restore_easing_state ((ClutterActor*) actor);
	_g_object_unref0 (window);
}

static void
_budgie_budgie_wm_tile_preview_transition_complete_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                                        gpointer self)
{
	budgie_budgie_wm_tile_preview_transition_complete ((BudgieBudgieWM*) self);
}

static guint8*
_uint8_dup (guint8* self)
{
	guint8* dup;
	dup = g_new0 (guint8, 1);
	memcpy (dup, self, sizeof (guint8));
	return dup;
}

static gpointer
__uint8_dup0 (gpointer self)
{
	return self ? _uint8_dup (self) : NULL;
}

static void
budgie_budgie_wm_real_show_tile_preview (MetaPlugin* base,
                                         MetaWindow* window,
                                         MetaRectangle* tile_rect,
                                         gint tile_monitor_num)
{
	BudgieBudgieWM * self;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	BudgieScreenTilePreview* _tmp2_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	BudgieScreenTilePreview* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ClutterActor* win_actor = NULL;
	GObject* _tmp32_;
	ClutterActor* _tmp33_;
	BudgieScreenTilePreview* _tmp34_;
	BudgieScreenTilePreview* _tmp35_;
	ClutterActor* _tmp36_;
	gfloat _tmp37_;
	gfloat _tmp38_;
	ClutterActor* _tmp39_;
	gfloat _tmp40_;
	gfloat _tmp41_;
	BudgieScreenTilePreview* _tmp42_;
	ClutterActor* _tmp43_;
	gfloat _tmp44_;
	gfloat _tmp45_;
	ClutterActor* _tmp46_;
	gfloat _tmp47_;
	gfloat _tmp48_;
	BudgieScreenTilePreview* _tmp49_;
	guint8* _tmp50_;
	BudgieScreenTilePreview* _tmp51_;
	graphene_point_t _tmp52_;
	BudgieScreenTilePreview* _tmp53_;
	MetaRectangle _tmp54_;
	BudgieScreenTilePreview* _tmp55_;
	BudgieScreenTilePreview* _tmp56_;
	BudgieScreenTilePreview* _tmp57_;
	BudgieScreenTilePreview* _tmp58_;
	BudgieScreenTilePreview* _tmp59_;
	MetaRectangle _tmp60_;
	MetaRectangle _tmp61_;
	BudgieScreenTilePreview* _tmp62_;
	MetaRectangle _tmp63_;
	MetaRectangle _tmp64_;
	BudgieScreenTilePreview* _tmp65_;
	BudgieScreenTilePreview* _tmp66_;
	self = (BudgieBudgieWM*) base;
	g_return_if_fail (window != NULL);
	g_return_if_fail (tile_rect != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->tile_preview;
	if (_tmp2_ == NULL) {
		BudgieScreenTilePreview* _tmp3_;
		BudgieScreenTilePreview* _tmp4_;
		ClutterActor* display_group = NULL;
		MetaDisplay* _tmp5_;
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		BudgieScreenTilePreview* _tmp9_;
		BudgieScreenTilePreview* _tmp10_;
		guint8 _tmp11_;
		guint8* _tmp12_;
		_tmp3_ = budgie_screen_tile_preview_new ();
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->tile_preview);
		self->priv->tile_preview = _tmp3_;
		_tmp4_ = self->priv->tile_preview;
		g_signal_connect_object ((ClutterActor*) _tmp4_, "transitions-completed", (GCallback) _budgie_budgie_wm_tile_preview_transition_complete_clutter_actor_transitions_completed, self, 0);
		_tmp5_ = display;
		_tmp6_ = meta_get_window_group_for_display (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		display_group = _tmp7_;
		_tmp8_ = display_group;
		_tmp9_ = self->priv->tile_preview;
		clutter_actor_add_child (_tmp8_, (ClutterActor*) _tmp9_);
		_tmp10_ = self->priv->tile_preview;
		_tmp11_ = clutter_actor_get_opacity ((ClutterActor*) _tmp10_);
		_tmp12_ = __uint8_dup0 (&_tmp11_);
		_g_free0 (self->priv->default_tile_opacity);
		self->priv->default_tile_opacity = _tmp12_;
		_g_object_unref0 (display_group);
	}
	_tmp17_ = self->priv->tile_preview;
	g_object_get ((ClutterActor*) _tmp17_, "visible", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		BudgieScreenTilePreview* _tmp20_;
		MetaRectangle _tmp21_;
		MetaRectangle _tmp22_;
		_tmp20_ = self->priv->tile_preview;
		_tmp21_ = _tmp20_->tile_rect;
		_tmp22_ = *tile_rect;
		_tmp16_ = _tmp21_.x == _tmp22_.x;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		BudgieScreenTilePreview* _tmp23_;
		MetaRectangle _tmp24_;
		MetaRectangle _tmp25_;
		_tmp23_ = self->priv->tile_preview;
		_tmp24_ = _tmp23_->tile_rect;
		_tmp25_ = *tile_rect;
		_tmp15_ = _tmp24_.y == _tmp25_.y;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		BudgieScreenTilePreview* _tmp26_;
		MetaRectangle _tmp27_;
		MetaRectangle _tmp28_;
		_tmp26_ = self->priv->tile_preview;
		_tmp27_ = _tmp26_->tile_rect;
		_tmp28_ = *tile_rect;
		_tmp14_ = _tmp27_.width == _tmp28_.width;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		BudgieScreenTilePreview* _tmp29_;
		MetaRectangle _tmp30_;
		MetaRectangle _tmp31_;
		_tmp29_ = self->priv->tile_preview;
		_tmp30_ = _tmp29_->tile_rect;
		_tmp31_ = *tile_rect;
		_tmp13_ = _tmp30_.height == _tmp31_.height;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_g_object_unref0 (display);
		return;
	}
	_tmp32_ = meta_window_get_compositor_private (window);
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp32_) : NULL);
	win_actor = _tmp33_;
	_tmp34_ = self->priv->tile_preview;
	clutter_actor_remove_all_transitions ((ClutterActor*) _tmp34_);
	_tmp35_ = self->priv->tile_preview;
	_tmp36_ = win_actor;
	_tmp37_ = clutter_actor_get_x (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = win_actor;
	_tmp40_ = clutter_actor_get_y (_tmp39_);
	_tmp41_ = _tmp40_;
	clutter_actor_set_position ((ClutterActor*) _tmp35_, _tmp38_, _tmp41_);
	_tmp42_ = self->priv->tile_preview;
	_tmp43_ = win_actor;
	_tmp44_ = clutter_actor_get_width (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = win_actor;
	_tmp47_ = clutter_actor_get_height (_tmp46_);
	_tmp48_ = _tmp47_;
	clutter_actor_set_size ((ClutterActor*) _tmp42_, _tmp45_, _tmp48_);
	_tmp49_ = self->priv->tile_preview;
	_tmp50_ = self->priv->default_tile_opacity;
	clutter_actor_set_opacity ((ClutterActor*) _tmp49_, *_tmp50_);
	_tmp51_ = self->priv->tile_preview;
	_tmp52_ = budgie_budgie_wm_PV_CENTER;
	g_object_set ((GObject*) _tmp51_, "scale-x", BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_X, "scale-y", BUDGIE_BUDGIE_WM_NOTIFICATION_MAP_SCALE_Y, "pivot-point", &_tmp52_, NULL);
	_tmp53_ = self->priv->tile_preview;
	_tmp54_ = *tile_rect;
	_tmp53_->tile_rect = _tmp54_;
	_tmp55_ = self->priv->tile_preview;
	clutter_actor_show ((ClutterActor*) _tmp55_);
	_tmp56_ = self->priv->tile_preview;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp56_);
	_tmp57_ = self->priv->tile_preview;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp57_, CLUTTER_EASE_OUT_QUAD);
	_tmp58_ = self->priv->tile_preview;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp58_, (guint) BUDGIE_BUDGIE_WM_MAP_TIMEOUT);
	_tmp59_ = self->priv->tile_preview;
	_tmp60_ = *tile_rect;
	_tmp61_ = *tile_rect;
	clutter_actor_set_position ((ClutterActor*) _tmp59_, (gfloat) _tmp60_.x, (gfloat) _tmp61_.y);
	_tmp62_ = self->priv->tile_preview;
	_tmp63_ = *tile_rect;
	_tmp64_ = *tile_rect;
	clutter_actor_set_size ((ClutterActor*) _tmp62_, (gfloat) _tmp63_.width, (gfloat) _tmp64_.height);
	_tmp65_ = self->priv->tile_preview;
	g_object_set ((GObject*) _tmp65_, "scale-x", 1.0, "scale-y", 1.0, NULL);
	_tmp66_ = self->priv->tile_preview;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp66_);
	_g_object_unref0 (win_actor);
	_g_object_unref0 (display);
}

static void
budgie_budgie_wm_real_hide_tile_preview (MetaPlugin* base)
{
	BudgieBudgieWM * self;
	BudgieScreenTilePreview* _tmp0_;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = self->priv->tile_preview;
	if (_tmp0_ != NULL) {
		BudgieScreenTilePreview* _tmp1_;
		BudgieScreenTilePreview* _tmp2_;
		BudgieScreenTilePreview* _tmp3_;
		BudgieScreenTilePreview* _tmp4_;
		BudgieScreenTilePreview* _tmp5_;
		BudgieScreenTilePreview* _tmp6_;
		_tmp1_ = self->priv->tile_preview;
		clutter_actor_remove_all_transitions ((ClutterActor*) _tmp1_);
		_tmp2_ = self->priv->tile_preview;
		clutter_actor_save_easing_state ((ClutterActor*) _tmp2_);
		_tmp3_ = self->priv->tile_preview;
		clutter_actor_set_easing_mode ((ClutterActor*) _tmp3_, CLUTTER_EASE_OUT_QUAD);
		_tmp4_ = self->priv->tile_preview;
		clutter_actor_set_easing_duration ((ClutterActor*) _tmp4_, (guint) BUDGIE_BUDGIE_WM_FADE_TIMEOUT);
		_tmp5_ = self->priv->tile_preview;
		clutter_actor_set_opacity ((ClutterActor*) _tmp5_, (guint8) 0);
		_tmp6_ = self->priv->tile_preview;
		clutter_actor_restore_easing_state ((ClutterActor*) _tmp6_);
	}
}

static void
budgie_budgie_wm_tile_preview_transition_complete (BudgieBudgieWM* self)
{
	BudgieScreenTilePreview* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tile_preview;
	if (((gint) clutter_actor_get_opacity ((ClutterActor*) _tmp0_)) == 0x00) {
		BudgieScreenTilePreview* _tmp1_;
		_tmp1_ = self->priv->tile_preview;
		clutter_actor_hide ((ClutterActor*) _tmp1_);
	}
}

static gint
budgie_budgie_wm_tab_sort (MetaWindow* a,
                           MetaWindow* b)
{
	guint32 at = 0U;
	guint32 bt = 0U;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	at = meta_window_get_user_time (a);
	bt = meta_window_get_user_time (a);
	if (at < bt) {
		result = -1;
		return result;
	}
	if (at > bt) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static gint
budgie_budgie_wm_tab_sort_reverse (MetaWindow* a,
                                   MetaWindow* b)
{
	guint32 at = 0U;
	guint32 bt = 0U;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	at = meta_window_get_user_time (a);
	bt = meta_window_get_user_time (a);
	if (at < bt) {
		result = 1;
		return result;
	}
	if (at > bt) {
		result = -1;
		return result;
	}
	result = 0;
	return result;
}

static void
budgie_budgie_wm_invalidate_tab (BudgieBudgieWM* self,
                                 MetaWorkspace* space,
                                 MetaWindow* window)
{
	MetaWorkspace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (space != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->cur_workspace;
	if (space == _tmp0_) {
		(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
		self->priv->cur_tabs = NULL;
		self->priv->cur_index = 0;
		self->priv->last_time = (guint32) -1;
	}
}

static void
_budgie_budgie_wm_invalidate_tab_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	budgie_budgie_wm_invalidate_tab ((BudgieBudgieWM*) self, _sender, object);
}

static void
_budgie_budgie_wm_invalidate_tab_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                MetaWindow* object,
                                                                gpointer self)
{
	budgie_budgie_wm_invalidate_tab ((BudgieBudgieWM*) self, _sender, object);
}

void
budgie_budgie_wm_switch_windows_backward (BudgieBudgieWM* self,
                                          MetaDisplay* display,
                                          MetaWindow* window,
                                          ClutterKeyEvent* event,
                                          MetaKeyBinding* binding)
{
	guint32 cur_time = 0U;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	MetaWorkspace* _tmp3_;
	gchar* data = NULL;
	MetaWorkspace* _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp12_ = FALSE;
	MetaWorkspace* _tmp13_;
	MetaWorkspace* _tmp14_;
	GList* _tmp16_;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	cur_time = meta_display_get_current_time (display);
	_tmp0_ = meta_display_get_workspace_manager (display);
	_tmp1_ = meta_workspace_manager_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	workspace = _tmp2_;
	_tmp3_ = workspace;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (workspace);
		return;
	}
	data = NULL;
	_tmp4_ = workspace;
	_tmp5_ = g_object_get_data ((GObject*) _tmp4_, "__flagged");
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	_g_free0 (data);
	data = _tmp6_;
	_tmp7_ = data;
	if (_tmp7_ == NULL) {
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		MetaWorkspace* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = workspace;
		g_signal_connect_object (_tmp8_, "window-added", (GCallback) _budgie_budgie_wm_invalidate_tab_meta_workspace_window_added, self, 0);
		_tmp9_ = workspace;
		g_signal_connect_object (_tmp9_, "window-removed", (GCallback) _budgie_budgie_wm_invalidate_tab_meta_workspace_window_removed, self, 0);
		_tmp10_ = workspace;
		_tmp11_ = g_strdup ("yes");
		g_object_set_data_full ((GObject*) _tmp10_, "__flagged", _tmp11_, g_free);
	}
	_tmp13_ = workspace;
	_tmp14_ = self->priv->cur_workspace;
	if (_tmp13_ != _tmp14_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = (cur_time - self->priv->last_time) >= BUDGIE_BUDGIE_WM_MAX_TAB_ELAPSE;
	}
	if (_tmp12_) {
		MetaWorkspace* _tmp15_;
		_tmp15_ = workspace;
		self->priv->cur_workspace = _tmp15_;
		(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
		self->priv->cur_tabs = NULL;
		self->priv->cur_index = 0;
	}
	self->priv->last_time = cur_time;
	_tmp16_ = self->priv->cur_tabs;
	if (_tmp16_ == NULL) {
		MetaWorkspace* _tmp17_;
		GSettings* _tmp18_;
		GList* _tmp19_;
		_tmp17_ = workspace;
		_tmp18_ = self->priv->settings;
		_tmp19_ = budgie_budgie_wm_get_current_tabs (self, display, _tmp17_, g_settings_get_boolean (_tmp18_, "show-all-windows-tabswitcher"));
		(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
		self->priv->cur_tabs = _tmp19_;
	}
	_tmp20_ = self->priv->cur_tabs;
	if (_tmp20_ == NULL) {
		_g_free0 (data);
		_g_object_unref0 (workspace);
		return;
	}
	budgie_budgie_wm_switch_switcher (self, TRUE);
	_g_free0 (data);
	_g_object_unref0 (workspace);
}

void
budgie_budgie_wm_switch_windows (BudgieBudgieWM* self,
                                 MetaDisplay* display,
                                 MetaWindow* window,
                                 ClutterKeyEvent* event,
                                 MetaKeyBinding* binding)
{
	guint32 cur_time = 0U;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	MetaWorkspace* _tmp3_;
	gchar* data = NULL;
	MetaWorkspace* _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp12_ = FALSE;
	MetaWorkspace* _tmp13_;
	MetaWorkspace* _tmp14_;
	GList* _tmp16_;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (binding != NULL);
	cur_time = meta_display_get_current_time (display);
	_tmp0_ = meta_display_get_workspace_manager (display);
	_tmp1_ = meta_workspace_manager_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	workspace = _tmp2_;
	_tmp3_ = workspace;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (workspace);
		return;
	}
	data = NULL;
	_tmp4_ = workspace;
	_tmp5_ = g_object_get_data ((GObject*) _tmp4_, "__flagged");
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	_g_free0 (data);
	data = _tmp6_;
	_tmp7_ = data;
	if (_tmp7_ == NULL) {
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		MetaWorkspace* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = workspace;
		g_signal_connect_object (_tmp8_, "window-added", (GCallback) _budgie_budgie_wm_invalidate_tab_meta_workspace_window_added, self, 0);
		_tmp9_ = workspace;
		g_signal_connect_object (_tmp9_, "window-removed", (GCallback) _budgie_budgie_wm_invalidate_tab_meta_workspace_window_removed, self, 0);
		_tmp10_ = workspace;
		_tmp11_ = g_strdup ("yes");
		g_object_set_data_full ((GObject*) _tmp10_, "__flagged", _tmp11_, g_free);
	}
	_tmp13_ = workspace;
	_tmp14_ = self->priv->cur_workspace;
	if (_tmp13_ != _tmp14_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = (cur_time - self->priv->last_time) >= BUDGIE_BUDGIE_WM_MAX_TAB_ELAPSE;
	}
	if (_tmp12_) {
		MetaWorkspace* _tmp15_;
		_tmp15_ = workspace;
		self->priv->cur_workspace = _tmp15_;
		(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
		self->priv->cur_tabs = NULL;
		self->priv->cur_index = 0;
	}
	self->priv->last_time = cur_time;
	_tmp16_ = self->priv->cur_tabs;
	if (_tmp16_ == NULL) {
		MetaWorkspace* _tmp17_;
		GSettings* _tmp18_;
		GList* _tmp19_;
		_tmp17_ = workspace;
		_tmp18_ = self->priv->settings;
		_tmp19_ = budgie_budgie_wm_get_current_tabs (self, display, _tmp17_, g_settings_get_boolean (_tmp18_, "show-all-windows-tabswitcher"));
		(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
		self->priv->cur_tabs = _tmp19_;
	}
	_tmp20_ = self->priv->cur_tabs;
	if (_tmp20_ == NULL) {
		_g_free0 (data);
		_g_object_unref0 (workspace);
		return;
	}
	budgie_budgie_wm_switch_switcher (self, FALSE);
	_g_free0 (data);
	_g_object_unref0 (workspace);
}

void
budgie_budgie_wm_switch_switcher (BudgieBudgieWM* self,
                                  gboolean backward)
{
	GList* _tmp0_;
	MetaWindow* win = NULL;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	MetaWindow* _tmp10_;
	MetaWindow* _tmp11_;
	guint32 curr_xid = 0U;
	MetaWindow* _tmp12_;
	BudgieSwitcher* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cur_tabs;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			MetaWindow* child = NULL;
			child = (MetaWindow*) child_it->data;
			{
				guint32 xid = 0U;
				MetaWindow* _tmp1_;
				BudgieSwitcher* _tmp2_;
				MetaWindow* _tmp3_;
				_tmp1_ = child;
				xid = (guint32) meta_window_get_xwindow (_tmp1_);
				_tmp2_ = self->priv->switcher_proxy;
				_tmp3_ = child;
				budgie_switcher_PassItem (_tmp2_, xid, meta_window_get_user_time (_tmp3_), NULL, NULL);
			}
		}
	}
	if (backward) {
		gint _tmp4_;
		_tmp4_ = self->priv->cur_index;
		self->priv->cur_index = _tmp4_ - 1;
		if (self->priv->cur_index < 0) {
			GList* _tmp5_;
			_tmp5_ = self->priv->cur_tabs;
			self->priv->cur_index = ((gint) g_list_length (_tmp5_)) - 1;
		}
	} else {
		gint _tmp6_;
		GList* _tmp7_;
		_tmp6_ = self->priv->cur_index;
		self->priv->cur_index = _tmp6_ + 1;
		_tmp7_ = self->priv->cur_tabs;
		if (((guint) self->priv->cur_index) > (g_list_length (_tmp7_) - 1)) {
			self->priv->cur_index = 0;
		}
	}
	_tmp8_ = self->priv->cur_tabs;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) self->priv->cur_index);
	_tmp10_ = _g_object_ref0 ((MetaWindow*) _tmp9_);
	win = _tmp10_;
	_tmp11_ = win;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (win);
		return;
	}
	_tmp12_ = win;
	curr_xid = (guint32) meta_window_get_xwindow (_tmp12_);
	_tmp13_ = self->priv->switcher_proxy;
	budgie_switcher_ShowSwitcher (_tmp13_, curr_xid, NULL, NULL);
	_g_object_unref0 (win);
}

static gint
_budgie_budgie_wm_tab_sort_reverse_gcompare_func (gconstpointer a,
                                                  gconstpointer b)
{
	gint result;
	result = budgie_budgie_wm_tab_sort_reverse ((MetaWindow*) a, (MetaWindow*) b);
	return result;
}

static GList*
budgie_budgie_wm_get_current_tabs (BudgieBudgieWM* self,
                                   MetaDisplay* display,
                                   MetaWorkspace* workspace,
                                   gboolean getTabsForAllWindows)
{
	GList* tabs = NULL;
	GCompareFunc cm = NULL;
	GCompareFunc _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	cm = _budgie_budgie_wm_tab_sort_reverse_gcompare_func;
	if (getTabsForAllWindows) {
		GList* _tmp0_;
		_tmp0_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, NULL);
		(tabs == NULL) ? NULL : (tabs = (g_list_free (tabs), NULL));
		tabs = _tmp0_;
	} else {
		GList* _tmp1_;
		_tmp1_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
		(tabs == NULL) ? NULL : (tabs = (g_list_free (tabs), NULL));
		tabs = _tmp1_;
	}
	_tmp2_ = cm;
	tabs = g_list_sort (tabs, _tmp2_);
	result = tabs;
	return result;
}

void
budgie_budgie_wm_stop_switch_windows (BudgieBudgieWM* self)
{
	BudgieSwitcher* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_proxy;
	budgie_switcher_StopSwitcher (_tmp0_, NULL, NULL);
}

static void
budgie_budgie_wm_real_kill_switch_workspace (MetaPlugin* base)
{
	BudgieBudgieWM * self;
	ClutterActor* _tmp0_;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = self->priv->out_group;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_;
		_tmp1_ = self->priv->out_group;
		g_signal_emit_by_name (_tmp1_, "transitions-completed");
	}
}

static void
budgie_budgie_wm_switch_workspace_done (BudgieBudgieWM* self)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	GList* _tmp3_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	ClutterActor* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_get_window_actors (_tmp2_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp3_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp4_;
			ClutterActor* actor = NULL;
			_tmp4_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp4_;
			{
				ClutterActor* _tmp5_;
				ClutterActor* orig_parent = NULL;
				ClutterActor* _tmp6_;
				gconstpointer _tmp7_;
				ClutterActor* _tmp8_;
				ClutterActor* _tmp9_;
				ClutterActor* _tmp10_;
				ClutterActor* _tmp11_;
				ClutterActor* _tmp12_;
				ClutterActor* _tmp13_;
				ClutterActor* _tmp14_;
				ClutterActor* _tmp15_;
				ClutterActor* _tmp16_;
				ClutterActor* _tmp17_;
				_tmp5_ = actor;
				clutter_actor_show (_tmp5_);
				_tmp6_ = actor;
				_tmp7_ = g_object_get_data ((GObject*) _tmp6_, "orig-parent");
				_tmp8_ = _g_object_ref0 ((ClutterActor*) _tmp7_);
				orig_parent = _tmp8_;
				_tmp9_ = orig_parent;
				if (_tmp9_ == NULL) {
					_g_object_unref0 (orig_parent);
					_g_object_unref0 (actor);
					continue;
				}
				_tmp10_ = actor;
				g_object_ref ((GObject*) _tmp10_);
				_tmp11_ = actor;
				_tmp12_ = clutter_actor_get_parent (_tmp11_);
				_tmp13_ = actor;
				clutter_actor_remove_child (_tmp12_, _tmp13_);
				_tmp14_ = orig_parent;
				_tmp15_ = actor;
				clutter_actor_add_child (_tmp14_, _tmp15_);
				_tmp16_ = actor;
				g_object_unref ((GObject*) _tmp16_);
				_tmp17_ = actor;
				g_object_set_data_full ((GObject*) _tmp17_, "orig-parent", NULL, NULL);
				_g_object_unref0 (orig_parent);
				_g_object_unref0 (actor);
			}
		}
	}
	_tmp18_ = self->priv->out_group;
	g_signal_handlers_disconnect_by_func (_tmp18_, (void*) budgie_budgie_wm_switch_workspace_done, self);
	_tmp19_ = self->priv->out_group;
	clutter_actor_remove_all_transitions (_tmp19_);
	_tmp20_ = self->priv->in_group;
	clutter_actor_remove_all_transitions (_tmp20_);
	_tmp21_ = self->priv->out_group;
	clutter_actor_destroy (_tmp21_);
	_g_object_unref0 (self->priv->out_group);
	self->priv->out_group = NULL;
	_tmp22_ = self->priv->in_group;
	clutter_actor_destroy (_tmp22_);
	_g_object_unref0 (self->priv->in_group);
	self->priv->in_group = NULL;
	meta_plugin_switch_workspace_completed ((MetaPlugin*) self);
	_g_object_unref0 (display);
}

static gboolean
____lambda12_ (BudgieBudgieWM* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

static gboolean
_____lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda12_ ((BudgieBudgieWM*) self);
	return result;
}

static void
_budgie_budgie_wm_switch_workspace_done_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                             gpointer self)
{
	budgie_budgie_wm_switch_workspace_done ((BudgieBudgieWM*) self);
}

static void
budgie_budgie_wm_real_switch_workspace (MetaPlugin* base,
                                        gint from,
                                        gint to,
                                        MetaMotionDirection direction)
{
	BudgieBudgieWM * self;
	BudgieRavenRemote* _tmp0_;
	gboolean use_animations = FALSE;
	GSettings* _tmp4_;
	gint screen_width = 0;
	gint screen_height = 0;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp5_;
	MetaDisplay* _tmp6_;
	ClutterActor* stage = NULL;
	MetaDisplay* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	MetaDisplay* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	gint y_dest = 0;
	gint x_dest = 0;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ClutterActor* _tmp59_;
	ClutterActor* _tmp60_;
	ClutterActor* _tmp63_;
	ClutterActor* _tmp64_;
	ClutterActor* _tmp65_;
	ClutterActor* _tmp66_;
	ClutterActor* _tmp69_;
	ClutterActor* _tmp70_;
	GError* _inner_error0_ = NULL;
	self = (BudgieBudgieWM*) base;
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ != NULL) {
		{
			BudgieRavenRemote* _tmp1_;
			_tmp1_ = self->priv->raven_proxy;
			budgie_raven_remote_Dismiss (_tmp1_, NULL, NULL);
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _____lambda12__gsource_func, g_object_ref (self), g_object_unref);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("wm.vala:1203: Failed to dismiss Raven: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = self->priv->iface_settings;
	use_animations = g_settings_get_boolean (_tmp4_, "enable-animations");
	budgie_budgie_wm_stop_switch_windows (self);
	if (from == to) {
		meta_plugin_switch_workspace_completed ((MetaPlugin*) self);
		return;
	}
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	display = _tmp6_;
	_tmp7_ = display;
	_tmp8_ = meta_get_stage_for_display (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	stage = _tmp9_;
	_tmp10_ = display;
	meta_display_get_size (_tmp10_, &_tmp11_, &_tmp12_);
	screen_width = _tmp11_;
	screen_height = _tmp12_;
	_tmp13_ = clutter_actor_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->out_group);
	self->priv->out_group = _tmp13_;
	_tmp14_ = clutter_actor_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->in_group);
	self->priv->in_group = _tmp14_;
	_tmp15_ = stage;
	_tmp16_ = self->priv->in_group;
	clutter_actor_add_child (_tmp15_, _tmp16_);
	_tmp17_ = stage;
	_tmp18_ = self->priv->out_group;
	clutter_actor_add_child (_tmp17_, _tmp18_);
	_tmp19_ = stage;
	_tmp20_ = self->priv->in_group;
	clutter_actor_set_child_above_sibling (_tmp19_, _tmp20_, NULL);
	if (use_animations) {
		MetaDisplay* _tmp21_;
		GList* _tmp22_;
		_tmp21_ = display;
		_tmp22_ = meta_get_window_actors (_tmp21_);
		{
			GList* actor_collection = NULL;
			GList* actor_it = NULL;
			actor_collection = _tmp22_;
			for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
				ClutterActor* _tmp23_;
				ClutterActor* actor = NULL;
				_tmp23_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
				actor = _tmp23_;
				{
					MetaWindow* window = NULL;
					ClutterActor* _tmp24_;
					MetaWindow* _tmp25_;
					MetaWindow* _tmp26_;
					gboolean _tmp27_ = FALSE;
					MetaWindow* _tmp28_;
					MetaWorkspace* space = NULL;
					MetaWindow* _tmp30_;
					MetaWorkspace* _tmp31_;
					MetaWorkspace* _tmp32_;
					gint win_space = 0;
					MetaWorkspace* _tmp33_;
					gboolean _tmp34_ = FALSE;
					_tmp24_ = actor;
					_tmp25_ = meta_window_actor_get_meta_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, meta_window_actor_get_type (), MetaWindowActor));
					_tmp26_ = _g_object_ref0 (_tmp25_);
					window = _tmp26_;
					_tmp28_ = window;
					if (!meta_window_showing_on_its_workspace (_tmp28_)) {
						_tmp27_ = TRUE;
					} else {
						MetaWindow* _tmp29_;
						_tmp29_ = window;
						_tmp27_ = meta_window_is_on_all_workspaces (_tmp29_);
					}
					if (_tmp27_) {
						_g_object_unref0 (window);
						_g_object_unref0 (actor);
						continue;
					}
					_tmp30_ = window;
					_tmp31_ = meta_window_get_workspace (_tmp30_);
					_tmp32_ = _g_object_ref0 (_tmp31_);
					space = _tmp32_;
					_tmp33_ = space;
					win_space = meta_workspace_index (_tmp33_);
					if (win_space == to) {
						_tmp34_ = TRUE;
					} else {
						_tmp34_ = win_space == from;
					}
					if (_tmp34_) {
						ClutterActor* orig_parent = NULL;
						ClutterActor* _tmp35_;
						ClutterActor* _tmp36_;
						ClutterActor* _tmp37_;
						ClutterActor* _tmp38_ = NULL;
						ClutterActor* new_parent = NULL;
						ClutterActor* _tmp41_;
						ClutterActor* _tmp42_;
						ClutterActor* _tmp43_;
						ClutterActor* _tmp44_;
						ClutterActor* _tmp45_;
						ClutterActor* _tmp46_;
						ClutterActor* _tmp47_;
						ClutterActor* _tmp48_;
						ClutterActor* _tmp49_;
						_tmp35_ = actor;
						_tmp36_ = clutter_actor_get_parent (_tmp35_);
						_tmp37_ = _g_object_ref0 (_tmp36_);
						orig_parent = _tmp37_;
						if (win_space == to) {
							ClutterActor* _tmp39_;
							_tmp39_ = self->priv->in_group;
							_tmp38_ = _tmp39_;
						} else {
							ClutterActor* _tmp40_;
							_tmp40_ = self->priv->out_group;
							_tmp38_ = _tmp40_;
						}
						new_parent = _tmp38_;
						_tmp41_ = actor;
						_tmp42_ = orig_parent;
						_tmp43_ = _g_object_ref0 (_tmp42_);
						g_object_set_data_full ((GObject*) _tmp41_, "orig-parent", _tmp43_, g_object_unref);
						_tmp44_ = actor;
						g_object_ref ((GObject*) _tmp44_);
						_tmp45_ = orig_parent;
						_tmp46_ = actor;
						clutter_actor_remove_child (_tmp45_, _tmp46_);
						_tmp47_ = new_parent;
						_tmp48_ = actor;
						clutter_actor_add_child (_tmp47_, _tmp48_);
						_tmp49_ = actor;
						g_object_unref ((GObject*) _tmp49_);
						_g_object_unref0 (orig_parent);
					} else {
						ClutterActor* _tmp50_;
						_tmp50_ = actor;
						clutter_actor_hide (_tmp50_);
					}
					_g_object_unref0 (space);
					_g_object_unref0 (window);
					_g_object_unref0 (actor);
				}
			}
		}
	}
	y_dest = 0;
	x_dest = 0;
	if (direction == META_MOTION_UP) {
		_tmp52_ = TRUE;
	} else {
		_tmp52_ = direction == META_MOTION_UP_LEFT;
	}
	if (_tmp52_) {
		_tmp51_ = TRUE;
	} else {
		_tmp51_ = direction == META_MOTION_UP_RIGHT;
	}
	if (_tmp51_) {
		y_dest = screen_height;
	} else {
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_ = FALSE;
		if (direction == META_MOTION_DOWN) {
			_tmp54_ = TRUE;
		} else {
			_tmp54_ = direction == META_MOTION_DOWN_LEFT;
		}
		if (_tmp54_) {
			_tmp53_ = TRUE;
		} else {
			_tmp53_ = direction == META_MOTION_DOWN_RIGHT;
		}
		if (_tmp53_) {
			y_dest = -screen_height;
		}
	}
	if (direction == META_MOTION_LEFT) {
		_tmp56_ = TRUE;
	} else {
		_tmp56_ = direction == META_MOTION_UP_LEFT;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = direction == META_MOTION_DOWN_LEFT;
	}
	if (_tmp55_) {
		x_dest = screen_width;
	} else {
		gboolean _tmp57_ = FALSE;
		gboolean _tmp58_ = FALSE;
		if (direction == META_MOTION_RIGHT) {
			_tmp58_ = TRUE;
		} else {
			_tmp58_ = direction == META_MOTION_UP_RIGHT;
		}
		if (_tmp58_) {
			_tmp57_ = TRUE;
		} else {
			_tmp57_ = direction == META_MOTION_DOWN_RIGHT;
		}
		if (_tmp57_) {
			x_dest = -screen_width;
		}
	}
	_tmp59_ = self->priv->in_group;
	clutter_actor_set_position (_tmp59_, (gfloat) (-x_dest), (gfloat) (-y_dest));
	_tmp60_ = self->priv->in_group;
	clutter_actor_save_easing_state (_tmp60_);
	if (use_animations) {
		ClutterActor* _tmp61_;
		ClutterActor* _tmp62_;
		_tmp61_ = self->priv->in_group;
		clutter_actor_set_easing_mode (_tmp61_, CLUTTER_EASE_OUT_QUAD);
		_tmp62_ = self->priv->in_group;
		clutter_actor_set_easing_duration (_tmp62_, (guint) BUDGIE_BUDGIE_WM_SWITCH_TIMEOUT);
	}
	_tmp63_ = self->priv->in_group;
	clutter_actor_set_position (_tmp63_, (gfloat) 0, (gfloat) 0);
	_tmp64_ = self->priv->in_group;
	clutter_actor_restore_easing_state (_tmp64_);
	_tmp65_ = self->priv->out_group;
	g_signal_connect_object (_tmp65_, "transitions-completed", (GCallback) _budgie_budgie_wm_switch_workspace_done_clutter_actor_transitions_completed, self, 0);
	_tmp66_ = self->priv->out_group;
	clutter_actor_save_easing_state (_tmp66_);
	if (use_animations) {
		ClutterActor* _tmp67_;
		ClutterActor* _tmp68_;
		_tmp67_ = self->priv->out_group;
		clutter_actor_set_easing_mode (_tmp67_, CLUTTER_EASE_OUT_QUAD);
		_tmp68_ = self->priv->out_group;
		clutter_actor_set_easing_duration (_tmp68_, (guint) BUDGIE_BUDGIE_WM_SWITCH_TIMEOUT);
	}
	_tmp69_ = self->priv->out_group;
	clutter_actor_set_position (_tmp69_, (gfloat) x_dest, (gfloat) y_dest);
	_tmp70_ = self->priv->out_group;
	clutter_actor_restore_easing_state (_tmp70_);
	_g_object_unref0 (stage);
	_g_object_unref0 (display);
}

BudgieBudgieWM*
budgie_budgie_wm_construct (GType object_type)
{
	BudgieBudgieWM * self = NULL;
	self = (BudgieBudgieWM*) g_object_new (object_type, NULL);
	return self;
}

BudgieBudgieWM*
budgie_budgie_wm_new (void)
{
	return budgie_budgie_wm_construct (BUDGIE_TYPE_BUDGIE_WM);
}

gboolean
budgie_budgie_wm_get_use_animations (BudgieBudgieWM* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_animations;
	return result;
}

void
budgie_budgie_wm_set_use_animations (BudgieBudgieWM* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_budgie_wm_get_use_animations (self);
	if (old_value != value) {
		self->priv->_use_animations = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_budgie_wm_properties[BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY]);
	}
}

static GObject *
budgie_budgie_wm_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieBudgieWM * self;
	MetaPluginInfo _tmp0_ = {0};
	parent_class = G_OBJECT_CLASS (budgie_budgie_wm_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM);
	memset (&_tmp0_, 0, sizeof (MetaPluginInfo));
	_tmp0_.name = "Budgie WM";
	_tmp0_.version = BUDGIE_VERSION;
	_tmp0_.author = "Buddies of Budgie";
	_tmp0_.license = "GPL-2.0-only";
	_tmp0_.description = "Budgie Window Manager";
	budgie_budgie_wm_info = _tmp0_;
	memset (&budgie_budgie_wm_PV_CENTER, 0, sizeof (graphene_point_t));
	memset (&budgie_budgie_wm_PV_NORM, 0, sizeof (graphene_point_t));
	budgie_budgie_wm_PV_CENTER.x = 0.5f;
	budgie_budgie_wm_PV_CENTER.y = 0.5f;
	budgie_budgie_wm_PV_NORM.x = 0.0f;
	budgie_budgie_wm_PV_NORM.y = 0.0f;
	return obj;
}

static void
budgie_budgie_wm_class_init (BudgieBudgieWMClass * klass,
                             gpointer klass_data)
{
	budgie_budgie_wm_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBudgieWM_private_offset);
	((MetaPluginClass *) klass)->plugin_info = (MetaPluginInfo* (*) (MetaPlugin*)) budgie_budgie_wm_real_plugin_info;
	((MetaPluginClass *) klass)->confirm_display_change = (void (*) (MetaPlugin*)) budgie_budgie_wm_real_confirm_display_change;
	((MetaPluginClass *) klass)->start = (void (*) (MetaPlugin*)) budgie_budgie_wm_real_start;
	((MetaPluginClass *) klass)->show_window_menu = (void (*) (MetaPlugin*, MetaWindow*, MetaWindowMenuType, gint, gint)) budgie_budgie_wm_real_show_window_menu;
	((MetaPluginClass *) klass)->map = (void (*) (MetaPlugin*, MetaWindowActor*)) budgie_budgie_wm_real_map;
	((MetaPluginClass *) klass)->minimize = (void (*) (MetaPlugin*, MetaWindowActor*)) budgie_budgie_wm_real_minimize;
	((MetaPluginClass *) klass)->unminimize = (void (*) (MetaPlugin*, MetaWindowActor*)) budgie_budgie_wm_real_unminimize;
	((MetaPluginClass *) klass)->destroy = (void (*) (MetaPlugin*, MetaWindowActor*)) budgie_budgie_wm_real_destroy;
	((MetaPluginClass *) klass)->show_tile_preview = (void (*) (MetaPlugin*, MetaWindow*, MetaRectangle*, gint)) budgie_budgie_wm_real_show_tile_preview;
	((MetaPluginClass *) klass)->hide_tile_preview = (void (*) (MetaPlugin*)) budgie_budgie_wm_real_hide_tile_preview;
	((MetaPluginClass *) klass)->kill_switch_workspace = (void (*) (MetaPlugin*)) budgie_budgie_wm_real_kill_switch_workspace;
	((MetaPluginClass *) klass)->switch_workspace = (void (*) (MetaPlugin*, gint, gint, MetaMotionDirection)) budgie_budgie_wm_real_switch_workspace;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_budgie_wm_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_budgie_wm_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_budgie_wm_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_budgie_wm_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY, budgie_budgie_wm_properties[BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY] = g_param_spec_boolean ("use-animations", "use-animations", "use-animations", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_budgie_wm_instance_init (BudgieBudgieWM * self,
                                gpointer klass)
{
	self->priv = budgie_budgie_wm_get_instance_private (self);
	self->priv->_use_animations = TRUE;
	self->priv->keyboard = NULL;
	self->priv->settings = NULL;
	self->priv->gnome_desktop_prefs = NULL;
	self->priv->raven_proxy = NULL;
	self->priv->shim = NULL;
	self->priv->focus_interface = NULL;
	self->priv->panel_proxy = NULL;
	self->priv->logind_proxy = NULL;
	self->priv->menu_proxy = NULL;
	self->priv->switcher_proxy = NULL;
	self->priv->iface_settings = NULL;
	self->priv->force_unredirect = FALSE;
	self->priv->enabled_experimental_run_diag_as_menu = FALSE;
	self->priv->focused_window = NULL;
	self->priv->tile_preview = NULL;
	self->priv->default_tile_opacity = NULL;
	self->priv->cur_workspace = NULL;
	self->priv->cur_tabs = NULL;
	self->priv->cur_index = 0;
	self->priv->last_time = (guint32) -1;
	self->priv->out_group = NULL;
	self->priv->in_group = NULL;
}

static void
budgie_budgie_wm_finalize (GObject * obj)
{
	BudgieBudgieWM * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM);
	_g_object_unref0 (self->priv->background_group);
	_g_object_unref0 (self->priv->keyboard);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->gnome_desktop_prefs);
	_g_object_unref0 (self->priv->raven_proxy);
	_g_object_unref0 (self->priv->shim);
	_g_object_unref0 (self->priv->focus_interface);
	_g_object_unref0 (self->priv->panel_proxy);
	_g_object_unref0 (self->priv->logind_proxy);
	_g_object_unref0 (self->priv->menu_proxy);
	_g_object_unref0 (self->priv->switcher_proxy);
	_g_object_unref0 (self->priv->iface_settings);
	_g_hash_table_unref0 (self->priv->state_map);
	_g_object_unref0 (self->priv->display_group);
	_g_object_unref0 (self->priv->tile_preview);
	_g_free0 (self->priv->default_tile_opacity);
	(self->priv->cur_tabs == NULL) ? NULL : (self->priv->cur_tabs = (g_list_free (self->priv->cur_tabs), NULL));
	_g_object_unref0 (self->priv->out_group);
	_g_object_unref0 (self->priv->in_group);
	G_OBJECT_CLASS (budgie_budgie_wm_parent_class)->finalize (obj);
}

static GType
budgie_budgie_wm_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBudgieWMClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_budgie_wm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBudgieWM), 0, (GInstanceInitFunc) budgie_budgie_wm_instance_init, NULL };
	GType budgie_budgie_wm_type_id;
	budgie_budgie_wm_type_id = g_type_register_static (meta_plugin_get_type (), "BudgieBudgieWM", &g_define_type_info, 0);
	BudgieBudgieWM_private_offset = g_type_add_instance_private (budgie_budgie_wm_type_id, sizeof (BudgieBudgieWMPrivate));
	return budgie_budgie_wm_type_id;
}

GType
budgie_budgie_wm_get_type (void)
{
	static volatile gsize budgie_budgie_wm_type_id__once = 0;
	if (g_once_init_enter (&budgie_budgie_wm_type_id__once)) {
		GType budgie_budgie_wm_type_id;
		budgie_budgie_wm_type_id = budgie_budgie_wm_get_type_once ();
		g_once_init_leave (&budgie_budgie_wm_type_id__once, budgie_budgie_wm_type_id);
	}
	return budgie_budgie_wm_type_id__once;
}

static void
_vala_budgie_budgie_wm_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BudgieBudgieWM * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM);
	switch (property_id) {
		case BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY:
		g_value_set_boolean (value, budgie_budgie_wm_get_use_animations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_budgie_wm_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	BudgieBudgieWM * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM);
	switch (property_id) {
		case BUDGIE_BUDGIE_WM_USE_ANIMATIONS_PROPERTY:
		budgie_budgie_wm_set_use_animations (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_budgie_wmdbus_get_instance_private (BudgieBudgieWMDBUS* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBudgieWMDBUS_private_offset);
}

BudgieBudgieWMDBUS*
budgie_budgie_wmdbus_construct (GType object_type,
                                BudgieBudgieWM* wm)
{
	BudgieBudgieWMDBUS * self = NULL;
	self = (BudgieBudgieWMDBUS*) g_object_new (object_type, NULL);
	self->priv->wm = wm;
	return self;
}

BudgieBudgieWMDBUS*
budgie_budgie_wmdbus_new (BudgieBudgieWM* wm)
{
	return budgie_budgie_wmdbus_construct (BUDGIE_TYPE_BUDGIE_WMDBUS, wm);
}

static void
budgie_budgie_wmdbus_on_bus_acquired (BudgieBudgieWMDBUS* self,
                                      GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_budgie_wmdbus_register_object (self, conn, "/org/budgie_desktop/BudgieWM", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_message ("wm.vala:1327: Unable to register BudgieWMDBUS: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_budgie_budgie_wmdbus_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self)
{
	budgie_budgie_wmdbus_on_bus_acquired ((BudgieBudgieWMDBUS*) self, connection);
}

void
budgie_budgie_wmdbus_serve (BudgieBudgieWMDBUS* self)
{
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.budgie_desktop.BudgieWM", G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_budgie_wmdbus_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_budgie_wmdbus_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
}

void
budgie_budgie_wmdbus_store_focused (BudgieBudgieWMDBUS* self,
                                    GError** error)
{
	BudgieBudgieWM* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm;
	budgie_budgie_wm_store_focused (_tmp0_);
}

void
budgie_budgie_wmdbus_restore_focused (BudgieBudgieWMDBUS* self,
                                      GError** error)
{
	BudgieBudgieWM* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm;
	budgie_budgie_wm_restore_focused (_tmp0_);
}

void
budgie_budgie_wmdbus_RemoveWorkspaceByIndex (BudgieBudgieWMDBUS* self,
                                             gint index,
                                             guint32 time,
                                             GError** error)
{
	MetaWorkspaceManager* wsm = NULL;
	BudgieBudgieWM* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	MetaWorkspace* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	wsm = _tmp2_;
	_tmp3_ = wsm;
	_tmp4_ = meta_workspace_manager_get_workspace_by_index (_tmp3_, index);
	workspace = _tmp4_;
	_tmp5_ = workspace;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = wsm;
	_tmp7_ = workspace;
	meta_workspace_manager_remove_workspace (_tmp6_, _tmp7_, time);
}

gint
budgie_budgie_wmdbus_AppendNewWorkspace (BudgieBudgieWMDBUS* self,
                                         guint32 time,
                                         GError** error)
{
	MetaWorkspaceManager* wsm = NULL;
	BudgieBudgieWM* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gint current_count = 0;
	MetaWorkspaceManager* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	wsm = _tmp2_;
	_tmp3_ = wsm;
	current_count = meta_workspace_manager_get_n_workspaces (_tmp3_);
	if (current_count < 8) {
		MetaWorkspace* space = NULL;
		MetaWorkspaceManager* _tmp4_;
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp4_ = wsm;
		_tmp5_ = meta_workspace_manager_append_new_workspace (_tmp4_, FALSE, time);
		space = _tmp5_;
		_tmp6_ = space;
		result = meta_workspace_index (_tmp6_);
		return result;
	}
	result = -1;
	return result;
}

static void
budgie_budgie_wmdbus_class_init (BudgieBudgieWMDBUSClass * klass,
                                 gpointer klass_data)
{
	budgie_budgie_wmdbus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBudgieWMDBUS_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_budgie_wmdbus_finalize;
}

static void
budgie_budgie_wmdbus_instance_init (BudgieBudgieWMDBUS * self,
                                    gpointer klass)
{
	self->priv = budgie_budgie_wmdbus_get_instance_private (self);
}

static void
budgie_budgie_wmdbus_finalize (GObject * obj)
{
	BudgieBudgieWMDBUS * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BUDGIE_WMDBUS, BudgieBudgieWMDBUS);
	G_OBJECT_CLASS (budgie_budgie_wmdbus_parent_class)->finalize (obj);
}

/**
* Store/restore focused window for use of the popover manager in budgie.
* This part of the equation is inspired by wingpanel, which uses our
* popover manager.
*/
static GType
budgie_budgie_wmdbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBudgieWMDBUSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_budgie_wmdbus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBudgieWMDBUS), 0, (GInstanceInitFunc) budgie_budgie_wmdbus_instance_init, NULL };
	GType budgie_budgie_wmdbus_type_id;
	budgie_budgie_wmdbus_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieBudgieWMDBUS", &g_define_type_info, 0);
	g_type_set_qdata (budgie_budgie_wmdbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_budgie_wmdbus_register_object);
	BudgieBudgieWMDBUS_private_offset = g_type_add_instance_private (budgie_budgie_wmdbus_type_id, sizeof (BudgieBudgieWMDBUSPrivate));
	return budgie_budgie_wmdbus_type_id;
}

GType
budgie_budgie_wmdbus_get_type (void)
{
	static volatile gsize budgie_budgie_wmdbus_type_id__once = 0;
	if (g_once_init_enter (&budgie_budgie_wmdbus_type_id__once)) {
		GType budgie_budgie_wmdbus_type_id;
		budgie_budgie_wmdbus_type_id = budgie_budgie_wmdbus_get_type_once ();
		g_once_init_leave (&budgie_budgie_wmdbus_type_id__once, budgie_budgie_wmdbus_type_id);
	}
	return budgie_budgie_wmdbus_type_id__once;
}

static void
_dbus_budgie_budgie_wmdbus_store_focused (BudgieBudgieWMDBUS* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_budgie_wmdbus_store_focused (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_budgie_wmdbus_restore_focused (BudgieBudgieWMDBUS* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_budgie_wmdbus_restore_focused (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_budgie_wmdbus_RemoveWorkspaceByIndex (BudgieBudgieWMDBUS* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint index = 0;
	GVariant* _tmp83_;
	guint32 time = 0U;
	GVariant* _tmp84_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp83_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_int32 (_tmp83_);
	g_variant_unref (_tmp83_);
	_tmp84_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_uint32 (_tmp84_);
	g_variant_unref (_tmp84_);
	budgie_budgie_wmdbus_RemoveWorkspaceByIndex (self, index, time, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_budgie_wmdbus_AppendNewWorkspace (BudgieBudgieWMDBUS* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 time = 0U;
	GVariant* _tmp85_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp85_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_uint32 (_tmp85_);
	g_variant_unref (_tmp85_);
	result = budgie_budgie_wmdbus_AppendNewWorkspace (self, time, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_budgie_wmdbus_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "StoreFocused") == 0) {
		_dbus_budgie_budgie_wmdbus_store_focused (object, parameters, invocation);
	} else if (strcmp (method_name, "RestoreFocused") == 0) {
		_dbus_budgie_budgie_wmdbus_restore_focused (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveWorkspaceByIndex") == 0) {
		_dbus_budgie_budgie_wmdbus_RemoveWorkspaceByIndex (object, parameters, invocation);
	} else if (strcmp (method_name, "AppendNewWorkspace") == 0) {
		_dbus_budgie_budgie_wmdbus_AppendNewWorkspace (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_budgie_wmdbus_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_budgie_wmdbus_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_budgie_wmdbus_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_budgie_wmdbus_dbus_interface_info), &_budgie_budgie_wmdbus_dbus_interface_vtable, data, _budgie_budgie_wmdbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_budgie_wmdbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

