/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;

public class AnnotationEntry {
    private final int typeIndex;
    private final ConstantPool constantPool;
    private final List<ElementValuePair> element_value_pairs;

    AnnotationEntry(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.typeIndex = dataInput.readUnsignedShort();
        int n = dataInput.readUnsignedShort();
        this.element_value_pairs = new ArrayList<ElementValuePair>(n);
        for (int i = 0; i < n; ++i) {
            this.element_value_pairs.add(new ElementValuePair(dataInput, constantPool));
        }
    }

    public String getAnnotationType() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.typeIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public List<ElementValuePair> getElementValuePairs() {
        return this.element_value_pairs;
    }
}

