/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class UserMBean
extends BaseModelMBean {
    private static final StringManager sm = StringManager.getManager(UserMBean.class);
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("User");

    public String[] getGroups() {
        User user = (User)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = user.getGroups();
        while (iterator.hasNext()) {
            Group group = null;
            try {
                group = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), group);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.group", new Object[]{group}), malformedObjectNameException);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRoles() {
        User user = (User)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = user.getRoles();
        while (iterator.hasNext()) {
            Role role = null;
            try {
                role = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), role);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.role", new Object[]{role}), malformedObjectNameException);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void addGroup(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(string);
        if (group == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidGroup", new Object[]{string}));
        }
        user.addGroup(group);
    }

    public void addRole(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", new Object[]{string}));
        }
        user.addRole(role);
    }

    public void removeGroup(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(string);
        if (group == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidGroup", new Object[]{string}));
        }
        user.removeGroup(group);
    }

    public void removeRole(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", new Object[]{string}));
        }
        user.removeRole(role);
    }
}

