// third_party/blink/public/mojom/gpu/gpu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/gpu/gpu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/gpu/gpu.mojom-params-data.h"
#include "third_party/blink/public/mojom/gpu/gpu.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/gpu/gpu.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_GPU_GPU_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_GPU_GPU_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char GpuDataManager::Name_[] = "blink.mojom.GpuDataManager";
bool GpuDataManager::Are3DAPIsBlockedForUrl(const ::GURL& url, bool* out_blocked) {
  NOTREACHED();
  return false;
}
class GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse(
      bool* result, bool* out_blocked)
      : result_(result), out_blocked_(out_blocked) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_blocked_;DISALLOW_COPY_AND_ASSIGN(GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse);
};

class GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback(
      GpuDataManager::Are3DAPIsBlockedForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuDataManager::Are3DAPIsBlockedForUrlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback);
};

GpuDataManagerProxy::GpuDataManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GpuDataManagerProxy::Are3DAPIsBlockedForUrl(
    const ::GURL& param_url, bool* out_param_blocked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(param_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuDataManager.Are3DAPIsBlockedForUrl request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse(
          &result, out_param_blocked));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_blocked) {
        raw_value->SetBoolean("blocked", (*out_param_blocked));
      } else {
        raw_value->SetString("blocked", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void GpuDataManagerProxy::Are3DAPIsBlockedForUrl(
    const ::GURL& in_url, Are3DAPIsBlockedForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in GpuDataManager.Are3DAPIsBlockedForUrl request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder {
 public:
  static GpuDataManager::Are3DAPIsBlockedForUrlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder> proxy(
        new GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuDataManager::Are3DAPIsBlockedForUrlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_blocked);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder);
};

bool GpuDataManager_Are3DAPIsBlockedForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrlCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_blocked{};
  GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_blocked = input_data_view.blocked();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuDataManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_blocked));
  return true;
}

void GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::Run(
    bool in_blocked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrlCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("blocked", in_blocked);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->blocked = in_blocked;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuDataManager::Name_);
  message.set_method_name("Are3DAPIsBlockedForUrl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuDataManager_Are3DAPIsBlockedForUrl_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_blocked{};
  GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_blocked = input_data_view.blocked();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuDataManager::Name_, 0, true);
    return false;
  }
  *out_blocked_ = std::move(p_blocked);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool GpuDataManagerStubDispatch::Accept(
    GpuDataManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name: {
      break;
    }
  }
  return false;
}

// static
bool GpuDataManagerStubDispatch::AcceptWithResponder(
    GpuDataManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::GpuDataManager::Are3DAPIsBlockedForUrl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data* params =
          reinterpret_cast<
              internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      GpuDataManager_Are3DAPIsBlockedForUrl_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuDataManager::Name_, 0, false);
        return false;
      }
      GpuDataManager::Are3DAPIsBlockedForUrlCallback callback =
          GpuDataManager_Are3DAPIsBlockedForUrl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Are3DAPIsBlockedForUrl(
std::move(p_url), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuDataManagerValidationInfo[] = {
    {internal::kGpuDataManager_Are3DAPIsBlockedForUrl_Name,
     {&internal::GpuDataManager_Are3DAPIsBlockedForUrl_Params_Data::Validate,
      &internal::GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams_Data::Validate}},
};

bool GpuDataManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::GpuDataManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuDataManagerValidationInfo);
}

bool GpuDataManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::GpuDataManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuDataManagerValidationInfo);

}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif