// third_party/blink/public/mojom/frame/fullscreen.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/fullscreen.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/fullscreen.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/fullscreen.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FULLSCREEN_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FULLSCREEN_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
FullscreenOptions::FullscreenOptions()
    : prefers_navigation_bar(false),
      display_id(-1),
      is_prefixed(false),
      is_xr_overlay(false) {}

FullscreenOptions::FullscreenOptions(
    bool prefers_navigation_bar_in,
    int64_t display_id_in,
    bool is_prefixed_in,
    bool is_xr_overlay_in)
    : prefers_navigation_bar(std::move(prefers_navigation_bar_in)),
      display_id(std::move(display_id_in)),
      is_prefixed(std::move(is_prefixed_in)),
      is_xr_overlay(std::move(is_xr_overlay_in)) {}

FullscreenOptions::~FullscreenOptions() = default;
size_t FullscreenOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->prefers_navigation_bar);
  seed = mojo::internal::WTFHash(seed, this->display_id);
  seed = mojo::internal::WTFHash(seed, this->is_prefixed);
  seed = mojo::internal::WTFHash(seed, this->is_xr_overlay);
  return seed;
}

void FullscreenOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("prefers_navigation_bar", this->prefers_navigation_bar);
  value->SetString("display_id", base::NumberToString(this->display_id));
  value->SetBoolean("is_prefixed", this->is_prefixed);
  value->SetBoolean("is_xr_overlay", this->is_xr_overlay);
}

bool FullscreenOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FullscreenOptions::DataView, ::blink::mojom::blink::FullscreenOptionsPtr>::Read(
    ::blink::mojom::blink::FullscreenOptions::DataView input,
    ::blink::mojom::blink::FullscreenOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FullscreenOptionsPtr result(::blink::mojom::blink::FullscreenOptions::New());
  
      if (success)
        result->prefers_navigation_bar = input.prefers_navigation_bar();
      if (success)
        result->display_id = input.display_id();
      if (success)
        result->is_prefixed = input.is_prefixed();
      if (success)
        result->is_xr_overlay = input.is_xr_overlay();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif