// third_party/blink/public/mojom/frame/frame.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/frame.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_JUMBO_H_
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
namespace blink {
SavableSubframe::SavableSubframe()
    : original_url(),
      subframe_token() {}

SavableSubframe::SavableSubframe(
    const ::blink::KURL& original_url_in,
    const ::base::UnguessableToken& subframe_token_in)
    : original_url(std::move(original_url_in)),
      subframe_token(std::move(subframe_token_in)) {}

SavableSubframe::~SavableSubframe() = default;

void SavableSubframe::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("original_url", base::trace_event::ValueToString(this->original_url, "<value of type const ::blink::KURL&>"));
  value->SetString("subframe_token", base::trace_event::ValueToString(this->subframe_token, "<value of type const ::base::UnguessableToken&>"));
}

bool SavableSubframe::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetSavableResourceLinksReply::GetSavableResourceLinksReply()
    : resources_list(),
      referrer(),
      subframes() {}

GetSavableResourceLinksReply::GetSavableResourceLinksReply(
    WTF::Vector<::blink::KURL> resources_list_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    WTF::Vector<SavableSubframePtr> subframes_in)
    : resources_list(std::move(resources_list_in)),
      referrer(std::move(referrer_in)),
      subframes(std::move(subframes_in)) {}

GetSavableResourceLinksReply::~GetSavableResourceLinksReply() = default;

void GetSavableResourceLinksReply::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("resources_list");
  for (const auto& item0 : this->resources_list) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::KURL&>"));
  }
  value->EndArray();
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("subframes");
  for (const auto& item0 : this->subframes) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool GetSavableResourceLinksReply::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FindInPageResultAXParams::FindInPageResultAXParams()
    : request_id(),
      match_index(),
      start_id(),
      start_offset(),
      end_id(),
      end_offset() {}

FindInPageResultAXParams::FindInPageResultAXParams(
    int32_t request_id_in,
    int32_t match_index_in,
    int32_t start_id_in,
    int32_t start_offset_in,
    int32_t end_id_in,
    int32_t end_offset_in)
    : request_id(std::move(request_id_in)),
      match_index(std::move(match_index_in)),
      start_id(std::move(start_id_in)),
      start_offset(std::move(start_offset_in)),
      end_id(std::move(end_id_in)),
      end_offset(std::move(end_offset_in)) {}

FindInPageResultAXParams::~FindInPageResultAXParams() = default;
size_t FindInPageResultAXParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->request_id);
  seed = mojo::internal::WTFHash(seed, this->match_index);
  seed = mojo::internal::WTFHash(seed, this->start_id);
  seed = mojo::internal::WTFHash(seed, this->start_offset);
  seed = mojo::internal::WTFHash(seed, this->end_id);
  seed = mojo::internal::WTFHash(seed, this->end_offset);
  return seed;
}

void FindInPageResultAXParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("request_id", this->request_id);
  value->SetInteger("match_index", this->match_index);
  value->SetInteger("start_id", this->start_id);
  value->SetInteger("start_offset", this->start_offset);
  value->SetInteger("end_id", this->end_id);
  value->SetInteger("end_offset", this->end_offset);
}

bool FindInPageResultAXParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DownloadURLParams::DownloadURLParams()
    : url(),
      referrer(),
      initiator_origin(),
      suggested_name(),
      cross_origin_redirects(),
      blob_url_token(),
      data_url_blob() {}

DownloadURLParams::DownloadURLParams(
    const ::blink::KURL& url_in,
    ::blink::mojom::blink::ReferrerPtr referrer_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& initiator_origin_in,
    const ::WTF::String& suggested_name_in,
    ::network::mojom::blink::RedirectMode cross_origin_redirects_in,
    ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> blob_url_token_in,
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> data_url_blob_in)
    : url(std::move(url_in)),
      referrer(std::move(referrer_in)),
      initiator_origin(std::move(initiator_origin_in)),
      suggested_name(std::move(suggested_name_in)),
      cross_origin_redirects(std::move(cross_origin_redirects_in)),
      blob_url_token(std::move(blob_url_token_in)),
      data_url_blob(std::move(data_url_blob_in)) {}

DownloadURLParams::~DownloadURLParams() = default;

void DownloadURLParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::blink::KURL&>"));
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("initiator_origin", base::trace_event::ValueToString(this->initiator_origin, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
  value->SetString("suggested_name", base::trace_event::ValueToString(this->suggested_name, "<value of type const ::WTF::String&>"));
  value->SetString("cross_origin_redirects", base::trace_event::ValueToString(this->cross_origin_redirects));
  value->SetBoolean("blob_url_token", this->blob_url_token.is_valid());
  value->SetBoolean("data_url_blob", this->data_url_blob.is_valid());
}

bool DownloadURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextAutosizerPageInfo::TextAutosizerPageInfo()
    : main_frame_width(),
      main_frame_layout_width(),
      device_scale_adjustment() {}

TextAutosizerPageInfo::TextAutosizerPageInfo(
    int32_t main_frame_width_in,
    int32_t main_frame_layout_width_in,
    float device_scale_adjustment_in)
    : main_frame_width(std::move(main_frame_width_in)),
      main_frame_layout_width(std::move(main_frame_layout_width_in)),
      device_scale_adjustment(std::move(device_scale_adjustment_in)) {}

TextAutosizerPageInfo::~TextAutosizerPageInfo() = default;
size_t TextAutosizerPageInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->main_frame_width);
  seed = mojo::internal::WTFHash(seed, this->main_frame_layout_width);
  seed = mojo::internal::WTFHash(seed, this->device_scale_adjustment);
  return seed;
}

void TextAutosizerPageInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("main_frame_width", this->main_frame_width);
  value->SetInteger("main_frame_layout_width", this->main_frame_layout_width);
  value->SetDouble("device_scale_adjustment", this->device_scale_adjustment);
}

bool TextAutosizerPageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char LocalFrameHost::Name_[] = "blink.mojom.LocalFrameHost";
bool LocalFrameHost::RunModalAlertDialog(const ::WTF::String& alert_message) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunModalConfirmDialog(const ::WTF::String& alert_message, bool* out_success) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunModalPromptDialog(const ::WTF::String& alert_message, const ::WTF::String& default_value, bool* out_success, ::WTF::String* out_result) {
  NOTREACHED();
  return false;
}
bool LocalFrameHost::RunBeforeUnloadConfirm(bool is_reload, bool* out_success) {
  NOTREACHED();
  return false;
}

class LocalFrameHost_EnterFullscreen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_EnterFullscreen_ForwardToCallback(
      LocalFrameHost::EnterFullscreenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::EnterFullscreenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_EnterFullscreen_ForwardToCallback);
};
class LocalFrameHost_RunModalAlertDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalAlertDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
      LocalFrameHost::RunModalAlertDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalAlertDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_ForwardToCallback);
};
class LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalConfirmDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
      LocalFrameHost::RunModalConfirmDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalConfirmDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_ForwardToCallback);
};
class LocalFrameHost_RunModalPromptDialog_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
      bool* result, bool* out_success, ::WTF::String* out_result)
      : result_(result), out_success_(out_success), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  ::WTF::String* out_result_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_HandleSyncResponse);
};

class LocalFrameHost_RunModalPromptDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
      LocalFrameHost::RunModalPromptDialogCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunModalPromptDialogCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_ForwardToCallback);
};
class LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse);
};

class LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
      LocalFrameHost::RunBeforeUnloadConfirmCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RunBeforeUnloadConfirmCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback);
};

LocalFrameHostProxy::LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameHostProxy::EnterFullscreen(
    ::blink::mojom::blink::FullscreenOptionsPtr in_options, EnterFullscreenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnterFullscreen", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnterFullscreen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in LocalFrameHost.EnterFullscreen request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_EnterFullscreen_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::ExitFullscreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::ExitFullscreen");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_ExitFullscreen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_ExitFullscreen_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ExitFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::FullscreenStateChanged(
    bool in_is_fullscreen) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::FullscreenStateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_fullscreen", in_is_fullscreen);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_FullscreenStateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_FullscreenStateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_fullscreen = in_is_fullscreen;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FullscreenStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::RegisterProtocolHandler(
    const WTF::String& in_scheme, const ::blink::KURL& in_url, const ::WTF::String& in_title, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RegisterProtocolHandler", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("scheme", in_scheme.Utf8());
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("title", base::trace_event::ValueToString(in_title, "<value of type const ::WTF::String&>"));
      raw_value->SetBoolean("user_gesture", in_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RegisterProtocolHandler_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RegisterProtocolHandler_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->scheme)::BaseType::BufferWriter
      scheme_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme, buffer, &scheme_writer, &serialization_context);
  params->scheme.Set(
      scheme_writer.is_null() ? nullptr : scheme_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scheme.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in LocalFrameHost.RegisterProtocolHandler request");
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.RegisterProtocolHandler request");
  typename decltype(params->title)::BaseType::BufferWriter
      title_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title, buffer, &title_writer, &serialization_context);
  params->title.Set(
      title_writer.is_null() ? nullptr : title_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->title.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in LocalFrameHost.RegisterProtocolHandler request");
  params->user_gesture = in_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RegisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UnregisterProtocolHandler(
    const WTF::String& in_scheme, const ::blink::KURL& in_url, bool in_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UnregisterProtocolHandler", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("scheme", in_scheme.Utf8());
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetBoolean("user_gesture", in_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_UnregisterProtocolHandler_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->scheme)::BaseType::BufferWriter
      scheme_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme, buffer, &scheme_writer, &serialization_context);
  params->scheme.Set(
      scheme_writer.is_null() ? nullptr : scheme_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->scheme.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in LocalFrameHost.UnregisterProtocolHandler request");
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.UnregisterProtocolHandler request");
  params->user_gesture = in_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UnregisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidDisplayInsecureContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidDisplayInsecureContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidDisplayInsecureContent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidDisplayInsecureContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidContainInsecureFormAction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidContainInsecureFormAction");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidContainInsecureFormAction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidContainInsecureFormAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DocumentAvailableInMainFrame(
    bool in_uses_temporary_zoom_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("uses_temporary_zoom_level", in_uses_temporary_zoom_level);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->uses_temporary_zoom_level = in_uses_temporary_zoom_level;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DocumentAvailableInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("needs_tracking", in_needs_tracking);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->needs_tracking = in_needs_tracking;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SetVirtualKeyboardOverlayPolicy(
    bool in_vk_overlays_content) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("vk_overlays_content", in_vk_overlays_content);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->vk_overlays_content = in_vk_overlays_content;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SetVirtualKeyboardOverlayPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::VisibilityChanged(
    ::blink::mojom::blink::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::VisibilityChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("visibility", base::trace_event::ValueToString(in_visibility));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_VisibilityChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_VisibilityChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
      in_visibility, &params->visibility);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeThemeColor(
    const base::Optional<::SkColor>& in_theme_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeThemeColor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("theme_color", base::trace_event::ValueToString(in_theme_color, "<value of type const base::Optional<::SkColor>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeThemeColor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeThemeColor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->theme_color)::BaseType::BufferWriter
      theme_color_writer;
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_theme_color, buffer, &theme_color_writer, &serialization_context);
  params->theme_color.Set(
      theme_color_writer.is_null() ? nullptr : theme_color_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeThemeColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeBackgroundColor(
    const ::SkColor& in_background_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeBackgroundColor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("background_color", base::trace_event::ValueToString(in_background_color, "<value of type const ::SkColor&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeBackgroundColor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->background_color)::BaseType::BufferWriter
      background_color_writer;
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color, buffer, &background_color_writer, &serialization_context);
  params->background_color.Set(
      background_color_writer.is_null() ? nullptr : background_color_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->background_color.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in LocalFrameHost.DidChangeBackgroundColor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFailLoadWithError(
    const ::blink::KURL& in_url, int32_t in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidFailLoadWithError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetInteger("error_code", in_error_code);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFailLoadWithError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidFailLoadWithError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.DidFailLoadWithError request");
  params->error_code = in_error_code;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFailLoadWithError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidFocusFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFocusFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidFocusFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidCallFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidCallFocus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidCallFocus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidCallFocus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidCallFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidAddContentSecurityPolicies(
    WTF::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> in_policies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidAddContentSecurityPolicies", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("policies");
      for (const auto& item0 : in_policies) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidAddContentSecurityPolicies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidAddContentSecurityPolicies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->policies)::BaseType::BufferWriter
      policies_writer;
  const mojo::internal::ContainerValidateParams policies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
      in_policies, buffer, &policies_writer, &policies_validate_params,
      &serialization_context);
  params->policies.Set(
      policies_writer.is_null() ? nullptr : policies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->policies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null policies in LocalFrameHost.DidAddContentSecurityPolicies request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidAddContentSecurityPolicies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::blink::InsecureRequestPolicy in_policy_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("policy_bitmap", base::trace_event::ValueToString(in_policy_bitmap));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      in_policy_bitmap, &params->policy_bitmap);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::EnforceInsecureNavigationsSet(
    const WTF::Vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("set");
      for (const auto& item0 : in_set) {
        raw_value->AppendString(base::NumberToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->set)::BaseType::BufferWriter
      set_writer;
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_set, buffer, &set_writer, &set_validate_params,
      &serialization_context);
  params->set.Set(
      set_writer.is_null() ? nullptr : set_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null set in LocalFrameHost.EnforceInsecureNavigationsSet request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeActiveSchedulerTrackedFeatures(
    uint64_t in_features_mask) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("features_mask", base::NumberToString(in_features_mask));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->features_mask = in_features_mask;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeActiveSchedulerTrackedFeatures");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::SuddenTerminationDisablerChanged(
    bool in_present, ::blink::mojom::blink::SuddenTerminationDisablerType in_disabler_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("present", in_present);
      raw_value->SetString("disabler_type", base::trace_event::ValueToString(in_disabler_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->present = in_present;
  mojo::internal::Serialize<::blink::mojom::SuddenTerminationDisablerType>(
      in_disabler_type, &params->disabler_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("SuddenTerminationDisablerChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HadStickyUserActivationBeforeNavigationChanged(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("has_gesture", in_has_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->has_gesture = in_has_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HadStickyUserActivationBeforeNavigationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ScrollRectToVisibleInParentFrame(
    const ::gfx::Rect& in_rect_to_scroll, ::blink::mojom::blink::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("rect_to_scroll", base::trace_event::ValueToString(in_rect_to_scroll, "<value of type const ::gfx::Rect&>"));
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rect_to_scroll)::BaseType::BufferWriter
      rect_to_scroll_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_to_scroll, buffer, &rect_to_scroll_writer, &serialization_context);
  params->rect_to_scroll.Set(
      rect_to_scroll_writer.is_null() ? nullptr : rect_to_scroll_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_to_scroll.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_to_scroll in LocalFrameHost.ScrollRectToVisibleInParentFrame request");
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.ScrollRectToVisibleInParentFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ScrollRectToVisibleInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::BubbleLogicalScrollInParentFrame(
    ::blink::mojom::blink::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("direction", base::trace_event::ValueToString(in_direction));
      raw_value->SetInteger("granularity", static_cast<int>(in_granularity));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
      in_direction, &params->direction);
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
      in_granularity, &params->granularity);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("BubbleLogicalScrollInParentFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidAccessInitialDocument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidAccessInitialDocument");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidAccessInitialDocument_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidAccessInitialDocument_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidAccessInitialDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidBlockNavigation(
    const ::blink::KURL& in_blocked_url, const ::blink::KURL& in_initiator_url, ::blink::mojom::blink::NavigationBlockedReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidBlockNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("blocked_url", base::trace_event::ValueToString(in_blocked_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("initiator_url", base::trace_event::ValueToString(in_initiator_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("reason", base::trace_event::ValueToString(in_reason));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidBlockNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidBlockNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->blocked_url)::BaseType::BufferWriter
      blocked_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url, buffer, &blocked_url_writer, &serialization_context);
  params->blocked_url.Set(
      blocked_url_writer.is_null() ? nullptr : blocked_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blocked_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_url in LocalFrameHost.DidBlockNavigation request");
  typename decltype(params->initiator_url)::BaseType::BufferWriter
      initiator_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_url, buffer, &initiator_url_writer, &serialization_context);
  params->initiator_url.Set(
      initiator_url_writer.is_null() ? nullptr : initiator_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_url in LocalFrameHost.DidBlockNavigation request");
  mojo::internal::Serialize<::blink::mojom::NavigationBlockedReason>(
      in_reason, &params->reason);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidBlockNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeLoadProgress(
    double in_load_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeLoadProgress", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("load_progress", in_load_progress);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeLoadProgress_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeLoadProgress_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->load_progress = in_load_progress;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeLoadProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFinishLoad(
    const ::blink::KURL& in_validated_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidFinishLoad", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("validated_url", base::trace_event::ValueToString(in_validated_url, "<value of type const ::blink::KURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFinishLoad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidFinishLoad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->validated_url)::BaseType::BufferWriter
      validated_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_validated_url, buffer, &validated_url_writer, &serialization_context);
  params->validated_url.Set(
      validated_url_writer.is_null() ? nullptr : validated_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->validated_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null validated_url in LocalFrameHost.DidFinishLoad request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFinishLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DispatchLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DispatchLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DispatchLoad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DispatchLoad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DispatchLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::GoToEntryAtOffset(
    int32_t in_offset, bool in_has_user_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::GoToEntryAtOffset", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("offset", in_offset);
      raw_value->SetBoolean("has_user_gesture", in_has_user_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_GoToEntryAtOffset_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_GoToEntryAtOffset_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->offset = in_offset;
  params->has_user_gesture = in_has_user_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GoToEntryAtOffset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::RenderFallbackContentInParentProcess(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::RenderFallbackContentInParentProcess");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RenderFallbackContentInParentProcess_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RenderFallbackContentInParentProcess_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RenderFallbackContentInParentProcess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UpdateTitle(
    const ::WTF::String& in_title, ::base::i18n::TextDirection in_title_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateTitle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("title", base::trace_event::ValueToString(in_title, "<value of type const ::WTF::String&>"));
      raw_value->SetInteger("title_direction", static_cast<int>(in_title_direction));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateTitle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_UpdateTitle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->title)::BaseType::BufferWriter
      title_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title, buffer, &title_writer, &serialization_context);
  params->title.Set(
      title_writer.is_null() ? nullptr : title_writer.data());
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_title_direction, &params->title_direction);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::UpdateUserActivationState(
    ::blink::mojom::blink::UserActivationUpdateType in_update_type, ::blink::mojom::blink::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateUserActivationState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      raw_value->SetString("notification_type", base::trace_event::ValueToString(in_notification_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateUserActivationState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_UpdateUserActivationState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageResult(
    FindInPageResultAXParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::FindInPageResultAXParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.HandleAccessibilityFindInPageResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::HandleAccessibilityFindInPageTermination(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("HandleAccessibilityFindInPageTermination");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DocumentOnLoadCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DocumentOnLoadCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DocumentOnLoadCompleted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DocumentOnLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ForwardResourceTimingToParent(
    ::blink::mojom::blink::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ForwardResourceTimingToParent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_timing.is_null()) {
        raw_value->SetString("timing", "nullptr");
      } else {
        raw_value->BeginDictionary("timing");
        in_timing->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_ForwardResourceTimingToParent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->timing)::BaseType::BufferWriter
      timing_writer;
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, buffer, &timing_writer, &serialization_context);
  params->timing.Set(
      timing_writer.is_null() ? nullptr : timing_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in LocalFrameHost.ForwardResourceTimingToParent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ForwardResourceTimingToParent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidFinishDocumentLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::DidFinishDocumentLoad");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidFinishDocumentLoad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidFinishDocumentLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool LocalFrameHostProxy::RunModalAlertDialog(
    const ::WTF::String& param_alert_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(param_alert_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalAlertDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog");
#endif
  return result;
}

void LocalFrameHostProxy::RunModalAlertDialog(
    const ::WTF::String& in_alert_message, RunModalAlertDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(in_alert_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalAlertDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalAlertDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunModalConfirmDialog(
    const ::WTF::String& param_alert_message, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(param_alert_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalConfirmDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void LocalFrameHostProxy::RunModalConfirmDialog(
    const ::WTF::String& in_alert_message, RunModalConfirmDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(in_alert_message, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalConfirmDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalConfirmDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunModalPromptDialog(
    const ::WTF::String& param_alert_message, const ::WTF::String& param_default_value, bool* out_param_success, ::WTF::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(param_alert_message, "<value of type const ::WTF::String&>"));
      raw_value->SetString("default_value", base::trace_event::ValueToString(param_default_value, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  typename decltype(params->default_value)::BaseType::BufferWriter
      default_value_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      param_default_value, buffer, &default_value_writer, &serialization_context);
  params->default_value.Set(
      default_value_writer.is_null() ? nullptr : default_value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_value in LocalFrameHost.RunModalPromptDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_HandleSyncResponse(
          &result, out_param_success, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      if (out_param_result) {
        raw_value->SetString("result", base::trace_event::ValueToString((*out_param_result), "<value of type const ::WTF::String&>"));
      } else {
        raw_value->SetString("result", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void LocalFrameHostProxy::RunModalPromptDialog(
    const ::WTF::String& in_alert_message, const ::WTF::String& in_default_value, RunModalPromptDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialog", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("alert_message", base::trace_event::ValueToString(in_alert_message, "<value of type const ::WTF::String&>"));
      raw_value->SetString("default_value", base::trace_event::ValueToString(in_default_value, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->alert_message)::BaseType::BufferWriter
      alert_message_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_alert_message, buffer, &alert_message_writer, &serialization_context);
  params->alert_message.Set(
      alert_message_writer.is_null() ? nullptr : alert_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->alert_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_message in LocalFrameHost.RunModalPromptDialog request");
  typename decltype(params->default_value)::BaseType::BufferWriter
      default_value_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_default_value, buffer, &default_value_writer, &serialization_context);
  params->default_value.Set(
      default_value_writer.is_null() ? nullptr : default_value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->default_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_value in LocalFrameHost.RunModalPromptDialog request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunModalPromptDialog_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool param_is_reload, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_reload", param_is_reload);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_reload = param_is_reload;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void LocalFrameHostProxy::RunBeforeUnloadConfirm(
    bool in_is_reload, RunBeforeUnloadConfirmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_reload", in_is_reload);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_reload = in_is_reload;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameHostProxy::UpdateFaviconURL(
    WTF::Vector<::blink::mojom::blink::FaviconURLPtr> in_favicon_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::UpdateFaviconURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("favicon_urls");
      for (const auto& item0 : in_favicon_urls) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_UpdateFaviconURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_UpdateFaviconURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->favicon_urls)::BaseType::BufferWriter
      favicon_urls_writer;
  const mojo::internal::ContainerValidateParams favicon_urls_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FaviconURLDataView>>(
      in_favicon_urls, buffer, &favicon_urls_writer, &favicon_urls_validate_params,
      &serialization_context);
  params->favicon_urls.Set(
      favicon_urls_writer.is_null() ? nullptr : favicon_urls_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->favicon_urls.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_urls in LocalFrameHost.UpdateFaviconURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("UpdateFaviconURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DownloadURL(
    DownloadURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DownloadURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DownloadURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DownloadURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::DownloadURLParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in LocalFrameHost.DownloadURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DownloadURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::FocusedElementChanged(
    bool in_is_editable_element, const ::gfx::Rect& in_bounds_in_frame_widget, ::blink::mojom::blink::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::FocusedElementChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_editable_element", in_is_editable_element);
      raw_value->SetString("bounds_in_frame_widget", base::trace_event::ValueToString(in_bounds_in_frame_widget, "<value of type const ::gfx::Rect&>"));
      raw_value->SetString("focus_type", base::trace_event::ValueToString(in_focus_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_FocusedElementChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_FocusedElementChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_editable_element = in_is_editable_element;
  typename decltype(params->bounds_in_frame_widget)::BaseType::BufferWriter
      bounds_in_frame_widget_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds_in_frame_widget, buffer, &bounds_in_frame_widget_writer, &serialization_context);
  params->bounds_in_frame_widget.Set(
      bounds_in_frame_widget_writer.is_null() ? nullptr : bounds_in_frame_widget_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds_in_frame_widget.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds_in_frame_widget in LocalFrameHost.FocusedElementChanged request");
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("FocusedElementChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::TextSelectionChanged(
    const ::WTF::String& in_text, uint32_t in_offset, const ::gfx::Range& in_range, bool in_user_initiated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::TextSelectionChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("text", base::trace_event::ValueToString(in_text, "<value of type const ::WTF::String&>"));
      raw_value->SetString("offset", base::NumberToString(in_offset));
      raw_value->SetString("range", base::trace_event::ValueToString(in_range, "<value of type const ::gfx::Range&>"));
      raw_value->SetBoolean("user_initiated", in_user_initiated);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_TextSelectionChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_TextSelectionChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->text)::BaseType::BufferWriter
      text_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text, buffer, &text_writer, &serialization_context);
  params->text.Set(
      text_writer.is_null() ? nullptr : text_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in LocalFrameHost.TextSelectionChanged request");
  params->offset = in_offset;
  typename decltype(params->range)::BaseType::BufferWriter
      range_writer;
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range, buffer, &range_writer, &serialization_context);
  params->range.Set(
      range_writer.is_null() ? nullptr : range_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->range.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in LocalFrameHost.TextSelectionChanged request");
  params->user_initiated = in_user_initiated;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("TextSelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::ShowPopupMenu(
    ::mojo::PendingRemote<::blink::mojom::blink::PopupMenuClient> in_popup_client, const ::gfx::Rect& in_bounds, int32_t in_item_height, double in_font_size, int32_t in_selected_item, WTF::Vector<::blink::mojom::blink::MenuItemPtr> in_menu_items, bool in_right_aligned, bool in_allow_multiple_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::ShowPopupMenu", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("popup_client", in_popup_client.is_valid());
      raw_value->SetString("bounds", base::trace_event::ValueToString(in_bounds, "<value of type const ::gfx::Rect&>"));
      raw_value->SetInteger("item_height", in_item_height);
      raw_value->SetDouble("font_size", in_font_size);
      raw_value->SetInteger("selected_item", in_selected_item);
      raw_value->BeginArray("menu_items");
      for (const auto& item0 : in_menu_items) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetBoolean("right_aligned", in_right_aligned);
      raw_value->SetBoolean("allow_multiple_selection", in_allow_multiple_selection);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_ShowPopupMenu_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_ShowPopupMenu_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PopupMenuClientInterfaceBase>>(
      in_popup_client, &params->popup_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->popup_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid popup_client in LocalFrameHost.ShowPopupMenu request");
  typename decltype(params->bounds)::BaseType::BufferWriter
      bounds_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds, buffer, &bounds_writer, &serialization_context);
  params->bounds.Set(
      bounds_writer.is_null() ? nullptr : bounds_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in LocalFrameHost.ShowPopupMenu request");
  params->item_height = in_item_height;
  params->font_size = in_font_size;
  params->selected_item = in_selected_item;
  typename decltype(params->menu_items)::BaseType::BufferWriter
      menu_items_writer;
  const mojo::internal::ContainerValidateParams menu_items_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
      in_menu_items, buffer, &menu_items_writer, &menu_items_validate_params,
      &serialization_context);
  params->menu_items.Set(
      menu_items_writer.is_null() ? nullptr : menu_items_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->menu_items.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null menu_items in LocalFrameHost.ShowPopupMenu request");
  params->right_aligned = in_right_aligned;
  params->allow_multiple_selection = in_allow_multiple_selection;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ShowPopupMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidLoadResourceFromMemoryCache(
    const ::blink::KURL& in_url, const WTF::String& in_http_method, const WTF::String& in_mime_type, ::network::mojom::blink::RequestDestination in_request_destination) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      raw_value->SetString("http_method", in_http_method.Utf8());
      raw_value->SetString("mime_type", in_mime_type.Utf8());
      raw_value->SetString("request_destination", base::trace_event::ValueToString(in_request_destination));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  typename decltype(params->http_method)::BaseType::BufferWriter
      http_method_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_http_method, buffer, &http_method_writer, &serialization_context);
  params->http_method.Set(
      http_method_writer.is_null() ? nullptr : http_method_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_method in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  typename decltype(params->mime_type)::BaseType::BufferWriter
      mime_type_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type, buffer, &mime_type_writer, &serialization_context);
  params->mime_type.Set(
      mime_type_writer.is_null() ? nullptr : mime_type_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->mime_type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in LocalFrameHost.DidLoadResourceFromMemoryCache request");
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
      in_request_destination, &params->request_destination);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidLoadResourceFromMemoryCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeFrameOwnerProperties(
    const ::base::UnguessableToken& in_child_frame_token, ::blink::mojom::blink::FrameOwnerPropertiesPtr in_frame_owner_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("child_frame_token", base::trace_event::ValueToString(in_child_frame_token, "<value of type const ::base::UnguessableToken&>"));
      if (in_frame_owner_properties.is_null()) {
        raw_value->SetString("frame_owner_properties", "nullptr");
      } else {
        raw_value->BeginDictionary("frame_owner_properties");
        in_frame_owner_properties->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->child_frame_token)::BaseType::BufferWriter
      child_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_child_frame_token, buffer, &child_frame_token_writer, &serialization_context);
  params->child_frame_token.Set(
      child_frame_token_writer.is_null() ? nullptr : child_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeFrameOwnerProperties request");
  typename decltype(params->frame_owner_properties)::BaseType::BufferWriter
      frame_owner_properties_writer;
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_frame_owner_properties, buffer, &frame_owner_properties_writer, &serialization_context);
  params->frame_owner_properties.Set(
      frame_owner_properties_writer.is_null() ? nullptr : frame_owner_properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_owner_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_owner_properties in LocalFrameHost.DidChangeFrameOwnerProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeOpener(
    const base::Optional<::base::UnguessableToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeOpener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("opener_frame", base::trace_event::ValueToString(in_opener_frame, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeOpener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeOpener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->opener_frame)::BaseType::BufferWriter
      opener_frame_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_opener_frame, buffer, &opener_frame_writer, &serialization_context);
  params->opener_frame.Set(
      opener_frame_writer.is_null() ? nullptr : opener_frame_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeFramePolicy(
    const ::base::UnguessableToken& in_child_frame_token, const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeFramePolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("child_frame_token", base::trace_event::ValueToString(in_child_frame_token, "<value of type const ::base::UnguessableToken&>"));
      raw_value->SetString("frame_policy", base::trace_event::ValueToString(in_frame_policy, "<value of type const ::blink::FramePolicy&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeFramePolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeFramePolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->child_frame_token)::BaseType::BufferWriter
      child_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_child_frame_token, buffer, &child_frame_token_writer, &serialization_context);
  params->child_frame_token.Set(
      child_frame_token_writer.is_null() ? nullptr : child_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeFramePolicy request");
  typename decltype(params->frame_policy)::BaseType::BufferWriter
      frame_policy_writer;
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, buffer, &frame_policy_writer, &serialization_context);
  params->frame_policy.Set(
      frame_policy_writer.is_null() ? nullptr : frame_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in LocalFrameHost.DidChangeFramePolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::DidChangeCSPAttribute(
    const ::base::UnguessableToken& in_child_frame_token, ::network::mojom::blink::ContentSecurityPolicyPtr in_parsed_csp_attribute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::DidChangeCSPAttribute", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("child_frame_token", base::trace_event::ValueToString(in_child_frame_token, "<value of type const ::base::UnguessableToken&>"));
      if (in_parsed_csp_attribute.is_null()) {
        raw_value->SetString("parsed_csp_attribute", "nullptr");
      } else {
        raw_value->BeginDictionary("parsed_csp_attribute");
        in_parsed_csp_attribute->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_DidChangeCSPAttribute_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_DidChangeCSPAttribute_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->child_frame_token)::BaseType::BufferWriter
      child_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_child_frame_token, buffer, &child_frame_token_writer, &serialization_context);
  params->child_frame_token.Set(
      child_frame_token_writer.is_null() ? nullptr : child_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->child_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_frame_token in LocalFrameHost.DidChangeCSPAttribute request");
  typename decltype(params->parsed_csp_attribute)::BaseType::BufferWriter
      parsed_csp_attribute_writer;
  mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyDataView>(
      in_parsed_csp_attribute, buffer, &parsed_csp_attribute_writer, &serialization_context);
  params->parsed_csp_attribute.Set(
      parsed_csp_attribute_writer.is_null() ? nullptr : parsed_csp_attribute_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DidChangeCSPAttribute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::CapturePaintPreviewOfSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("clip_rect", base::trace_event::ValueToString(in_clip_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetString("guid", base::trace_event::ValueToString(in_guid, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->clip_rect)::BaseType::BufferWriter
      clip_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_clip_rect, buffer, &clip_rect_writer, &serialization_context);
  params->clip_rect.Set(
      clip_rect_writer.is_null() ? nullptr : clip_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clip_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_rect in LocalFrameHost.CapturePaintPreviewOfSubframe request");
  typename decltype(params->guid)::BaseType::BufferWriter
      guid_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_guid, buffer, &guid_writer, &serialization_context);
  params->guid.Set(
      guid_writer.is_null() ? nullptr : guid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in LocalFrameHost.CapturePaintPreviewOfSubframe request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrameHost::Detach");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_Detach_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_Detach_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalFrameHost_EnterFullscreen_ProxyToResponder {
 public:
  static LocalFrameHost::EnterFullscreenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_EnterFullscreen_ProxyToResponder> proxy(
        new LocalFrameHost_EnterFullscreen_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_EnterFullscreen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_EnterFullscreen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_EnterFullscreen_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::EnterFullscreenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_granted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_EnterFullscreen_ProxyToResponder);
};

bool LocalFrameHost_EnterFullscreen_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::EnterFullscreenCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_granted{};
  LocalFrameHost_EnterFullscreen_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_granted = input_data_view.granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_granted));
  return true;
}

void LocalFrameHost_EnterFullscreen_ProxyToResponder::Run(
    bool in_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::EnterFullscreenCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("granted", in_granted);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_EnterFullscreen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->granted = in_granted;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::EnterFullscreenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("EnterFullscreen");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_RunModalAlertDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalAlertDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalAlertDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalAlertDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalAlertDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalAlertDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalAlertDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalAlertDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalAlertDialogCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalFrameHost_RunModalAlertDialog_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialogCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalAlertDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalAlertDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalAlertDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  LocalFrameHost_RunModalAlertDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 38, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalConfirmDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalConfirmDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalConfirmDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalConfirmDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalConfirmDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalConfirmDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalConfirmDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalConfirmDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalConfirmDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalConfirmDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalConfirmDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunModalConfirmDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 39, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunModalPromptDialog_ProxyToResponder {
 public:
  static LocalFrameHost::RunModalPromptDialogCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunModalPromptDialog_ProxyToResponder> proxy(
        new LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunModalPromptDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunModalPromptDialog_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunModalPromptDialogCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::WTF::String& in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunModalPromptDialog_ProxyToResponder);
};

bool LocalFrameHost_RunModalPromptDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunModalPromptDialogCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ::WTF::String p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_result));
  return true;
}

void LocalFrameHost_RunModalPromptDialog_ProxyToResponder::Run(
    bool in_success, const ::WTF::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialogCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type const ::WTF::String&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunModalPromptDialog_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialogCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunModalPromptDialog");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunModalPromptDialog_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ::WTF::String p_result{};
  LocalFrameHost_RunModalPromptDialog_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 40, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder {
 public:
  static LocalFrameHost::RunBeforeUnloadConfirmCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder> proxy(
        new LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrameHost::RunBeforeUnloadConfirmCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder);
};

bool LocalFrameHost_RunBeforeUnloadConfirm_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 41, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirmCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RunBeforeUnloadConfirm");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool LocalFrameHost_RunBeforeUnloadConfirm_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data* params =
      reinterpret_cast<internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  LocalFrameHost_RunBeforeUnloadConfirm_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 41, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool LocalFrameHostStubDispatch::Accept(
    LocalFrameHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kLocalFrameHost_EnterFullscreen_Name: {
      break;
    }
    case internal::kLocalFrameHost_ExitFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ExitFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ExitFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ExitFullscreen_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ExitFullscreen_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_ExitFullscreen_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitFullscreen();
      return true;
    }
    case internal::kLocalFrameHost_FullscreenStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::FullscreenStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::FullscreenStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FullscreenStateChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FullscreenStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_fullscreen{};
      LocalFrameHost_FullscreenStateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_fullscreen = input_data_view.is_fullscreen();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FullscreenStateChanged(
std::move(p_is_fullscreen));
      return true;
    }
    case internal::kLocalFrameHost_RegisterProtocolHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RegisterProtocolHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RegisterProtocolHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_RegisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_RegisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_scheme{};
      ::blink::KURL p_url{};
      ::WTF::String p_title{};
      bool p_user_gesture{};
      LocalFrameHost_RegisterProtocolHandler_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterProtocolHandler(
std::move(p_scheme), 
std::move(p_url), 
std::move(p_title), 
std::move(p_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_UnregisterProtocolHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UnregisterProtocolHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UnregisterProtocolHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_scheme{};
      ::blink::KURL p_url{};
      bool p_user_gesture{};
      LocalFrameHost_UnregisterProtocolHandler_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterProtocolHandler(
std::move(p_scheme), 
std::move(p_url), 
std::move(p_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_DidDisplayInsecureContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidDisplayInsecureContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidDisplayInsecureContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidDisplayInsecureContent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDisplayInsecureContent();
      return true;
    }
    case internal::kLocalFrameHost_DidContainInsecureFormAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidContainInsecureFormAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidContainInsecureFormAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidContainInsecureFormAction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidContainInsecureFormAction();
      return true;
    }
    case internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DocumentAvailableInMainFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_uses_temporary_zoom_level{};
      LocalFrameHost_DocumentAvailableInMainFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_uses_temporary_zoom_level = input_data_view.uses_temporary_zoom_level();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentAvailableInMainFrame(
std::move(p_uses_temporary_zoom_level));
      return true;
    }
    case internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SetNeedsOcclusionTracking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_tracking{};
      LocalFrameHost_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(
std::move(p_needs_tracking));
      return true;
    }
    case internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SetVirtualKeyboardOverlayPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_vk_overlays_content{};
      LocalFrameHost_SetVirtualKeyboardOverlayPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_vk_overlays_content = input_data_view.vk_overlays_content();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVirtualKeyboardOverlayPolicy(
std::move(p_vk_overlays_content));
      return true;
    }
    case internal::kLocalFrameHost_VisibilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::VisibilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::VisibilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FrameVisibility p_visibility{};
      LocalFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(
std::move(p_visibility));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeThemeColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeThemeColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeThemeColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeThemeColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeThemeColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::SkColor> p_theme_color{};
      LocalFrameHost_DidChangeThemeColor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadThemeColor(&p_theme_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeThemeColor(
std::move(p_theme_color));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeBackgroundColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeBackgroundColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeBackgroundColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::SkColor p_background_color{};
      LocalFrameHost_DidChangeBackgroundColor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBackgroundColor(&p_background_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeBackgroundColor(
std::move(p_background_color));
      return true;
    }
    case internal::kLocalFrameHost_DidFailLoadWithError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFailLoadWithError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFailLoadWithError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFailLoadWithError_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFailLoadWithError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      int32_t p_error_code{};
      LocalFrameHost_DidFailLoadWithError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_error_code = input_data_view.error_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFailLoadWithError(
std::move(p_url), 
std::move(p_error_code));
      return true;
    }
    case internal::kLocalFrameHost_DidFocusFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFocusFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFocusFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame();
      return true;
    }
    case internal::kLocalFrameHost_DidCallFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidCallFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidCallFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidCallFocus_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidCallFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidCallFocus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCallFocus();
      return true;
    }
    case internal::kLocalFrameHost_DidAddContentSecurityPolicies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidAddContentSecurityPolicies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidAddContentSecurityPolicies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidAddContentSecurityPolicies_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidAddContentSecurityPolicies_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> p_policies{};
      LocalFrameHost_DidAddContentSecurityPolicies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPolicies(&p_policies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAddContentSecurityPolicies(
std::move(p_policies));
      return true;
    }
    case internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureRequestPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::InsecureRequestPolicy p_policy_bitmap{};
      LocalFrameHost_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPolicyBitmap(&p_policy_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(
std::move(p_policy_bitmap));
      return true;
    }
    case internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnforceInsecureNavigationsSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<uint32_t> p_set{};
      LocalFrameHost_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(
std::move(p_set));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeActiveSchedulerTrackedFeatures");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_features_mask{};
      LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_features_mask = input_data_view.features_mask();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeActiveSchedulerTrackedFeatures(
std::move(p_features_mask));
      return true;
    }
    case internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::SuddenTerminationDisablerChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_present{};
      ::blink::mojom::blink::SuddenTerminationDisablerType p_disabler_type{};
      LocalFrameHost_SuddenTerminationDisablerChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_present = input_data_view.present();
      if (success && !input_data_view.ReadDisablerType(&p_disabler_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuddenTerminationDisablerChanged(
std::move(p_present), 
std::move(p_disabler_type));
      return true;
    }
    case internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HadStickyUserActivationBeforeNavigationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_gesture{};
      LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HadStickyUserActivationBeforeNavigationChanged(
std::move(p_has_gesture));
      return true;
    }
    case internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ScrollRectToVisibleInParentFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect_to_scroll{};
      ::blink::mojom::blink::ScrollIntoViewParamsPtr p_params{};
      LocalFrameHost_ScrollRectToVisibleInParentFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRectToScroll(&p_rect_to_scroll))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisibleInParentFrame(
std::move(p_rect_to_scroll), 
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::BubbleLogicalScrollInParentFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      LocalFrameHost_BubbleLogicalScrollInParentFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScrollInParentFrame(
std::move(p_direction), 
std::move(p_granularity));
      return true;
    }
    case internal::kLocalFrameHost_DidAccessInitialDocument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidAccessInitialDocument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidAccessInitialDocument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidAccessInitialDocument_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidAccessInitialDocument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidAccessInitialDocument_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAccessInitialDocument();
      return true;
    }
    case internal::kLocalFrameHost_DidBlockNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidBlockNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidBlockNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidBlockNavigation_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidBlockNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_blocked_url{};
      ::blink::KURL p_initiator_url{};
      ::blink::mojom::blink::NavigationBlockedReason p_reason{};
      LocalFrameHost_DidBlockNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadInitiatorUrl(&p_initiator_url))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidBlockNavigation(
std::move(p_blocked_url), 
std::move(p_initiator_url), 
std::move(p_reason));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeLoadProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeLoadProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeLoadProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeLoadProgress_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeLoadProgress_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_load_progress{};
      LocalFrameHost_DidChangeLoadProgress_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_load_progress = input_data_view.load_progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeLoadProgress(
std::move(p_load_progress));
      return true;
    }
    case internal::kLocalFrameHost_DidFinishLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFinishLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFinishLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFinishLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFinishLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_validated_url{};
      LocalFrameHost_DidFinishLoad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValidatedUrl(&p_validated_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishLoad(
std::move(p_validated_url));
      return true;
    }
    case internal::kLocalFrameHost_DispatchLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DispatchLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DispatchLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DispatchLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DispatchLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DispatchLoad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoad();
      return true;
    }
    case internal::kLocalFrameHost_GoToEntryAtOffset_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::GoToEntryAtOffset",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::GoToEntryAtOffset");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_GoToEntryAtOffset_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_GoToEntryAtOffset_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_offset{};
      bool p_has_user_gesture{};
      LocalFrameHost_GoToEntryAtOffset_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoToEntryAtOffset(
std::move(p_offset), 
std::move(p_has_user_gesture));
      return true;
    }
    case internal::kLocalFrameHost_RenderFallbackContentInParentProcess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RenderFallbackContentInParentProcess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RenderFallbackContentInParentProcess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_RenderFallbackContentInParentProcess_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_RenderFallbackContentInParentProcess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_RenderFallbackContentInParentProcess_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContentInParentProcess();
      return true;
    }
    case internal::kLocalFrameHost_UpdateTitle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateTitle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateTitle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateTitle_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateTitle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_title{};
      ::base::i18n::TextDirection p_title_direction{};
      LocalFrameHost_UpdateTitle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadTitleDirection(&p_title_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTitle(
std::move(p_title), 
std::move(p_title_direction));
      return true;
    }
    case internal::kLocalFrameHost_UpdateUserActivationState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateUserActivationState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateUserActivationState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::UserActivationUpdateType p_update_type{};
      ::blink::mojom::blink::UserActivationNotificationType p_notification_type{};
      LocalFrameHost_UpdateUserActivationState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(
std::move(p_update_type), 
std::move(p_notification_type));
      return true;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FindInPageResultAXParamsPtr p_params{};
      LocalFrameHost_HandleAccessibilityFindInPageResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageResult(
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::HandleAccessibilityFindInPageTermination");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_HandleAccessibilityFindInPageTermination_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAccessibilityFindInPageTermination();
      return true;
    }
    case internal::kLocalFrameHost_DocumentOnLoadCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DocumentOnLoadCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DocumentOnLoadCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DocumentOnLoadCompleted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DocumentOnLoadCompleted();
      return true;
    }
    case internal::kLocalFrameHost_ForwardResourceTimingToParent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ForwardResourceTimingToParent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ForwardResourceTimingToParent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ResourceTimingInfoPtr p_timing{};
      LocalFrameHost_ForwardResourceTimingToParent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardResourceTimingToParent(
std::move(p_timing));
      return true;
    }
    case internal::kLocalFrameHost_DidFinishDocumentLoad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidFinishDocumentLoad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidFinishDocumentLoad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_DidFinishDocumentLoad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishDocumentLoad();
      return true;
    }
    case internal::kLocalFrameHost_RunModalAlertDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalConfirmDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalPromptDialog_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateFaviconURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::UpdateFaviconURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::UpdateFaviconURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_UpdateFaviconURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_UpdateFaviconURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::mojom::blink::FaviconURLPtr> p_favicon_urls{};
      LocalFrameHost_UpdateFaviconURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFaviconUrls(&p_favicon_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 42, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFaviconURL(
std::move(p_favicon_urls));
      return true;
    }
    case internal::kLocalFrameHost_DownloadURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DownloadURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DownloadURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DownloadURL_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DownloadURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DownloadURLParamsPtr p_params{};
      LocalFrameHost_DownloadURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadURL(
std::move(p_params));
      return true;
    }
    case internal::kLocalFrameHost_FocusedElementChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::FocusedElementChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::FocusedElementChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_FocusedElementChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_FocusedElementChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_editable_element{};
      ::gfx::Rect p_bounds_in_frame_widget{};
      ::blink::mojom::blink::FocusType p_focus_type{};
      LocalFrameHost_FocusedElementChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_editable_element = input_data_view.is_editable_element();
      if (success && !input_data_view.ReadBoundsInFrameWidget(&p_bounds_in_frame_widget))
        success = false;
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusedElementChanged(
std::move(p_is_editable_element), 
std::move(p_bounds_in_frame_widget), 
std::move(p_focus_type));
      return true;
    }
    case internal::kLocalFrameHost_TextSelectionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::TextSelectionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::TextSelectionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_TextSelectionChanged_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_TextSelectionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_text{};
      uint32_t p_offset{};
      ::gfx::Range p_range{};
      bool p_user_initiated{};
      LocalFrameHost_TextSelectionChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_user_initiated = input_data_view.user_initiated();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextSelectionChanged(
std::move(p_text), 
std::move(p_offset), 
std::move(p_range), 
std::move(p_user_initiated));
      return true;
    }
    case internal::kLocalFrameHost_ShowPopupMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::ShowPopupMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::ShowPopupMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ShowPopupMenu_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ShowPopupMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::PopupMenuClient> p_popup_client{};
      ::gfx::Rect p_bounds{};
      int32_t p_item_height{};
      double p_font_size{};
      int32_t p_selected_item{};
      WTF::Vector<::blink::mojom::blink::MenuItemPtr> p_menu_items{};
      bool p_right_aligned{};
      bool p_allow_multiple_selection{};
      LocalFrameHost_ShowPopupMenu_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_popup_client =
            input_data_view.TakePopupClient<decltype(p_popup_client)>();
      }
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (success)
        p_item_height = input_data_view.item_height();
      if (success)
        p_font_size = input_data_view.font_size();
      if (success)
        p_selected_item = input_data_view.selected_item();
      if (success && !input_data_view.ReadMenuItems(&p_menu_items))
        success = false;
      if (success)
        p_right_aligned = input_data_view.right_aligned();
      if (success)
        p_allow_multiple_selection = input_data_view.allow_multiple_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 46, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPopupMenu(
std::move(p_popup_client), 
std::move(p_bounds), 
std::move(p_item_height), 
std::move(p_font_size), 
std::move(p_selected_item), 
std::move(p_menu_items), 
std::move(p_right_aligned), 
std::move(p_allow_multiple_selection));
      return true;
    }
    case internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidLoadResourceFromMemoryCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_http_method{};
      WTF::String p_mime_type{};
      ::network::mojom::blink::RequestDestination p_request_destination{};
      LocalFrameHost_DidLoadResourceFromMemoryCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHttpMethod(&p_http_method))
        success = false;
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 47, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidLoadResourceFromMemoryCache(
std::move(p_url), 
std::move(p_http_method), 
std::move(p_mime_type), 
std::move(p_request_destination));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_child_frame_token{};
      ::blink::mojom::blink::FrameOwnerPropertiesPtr p_frame_owner_properties{};
      LocalFrameHost_DidChangeFrameOwnerProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFrameOwnerProperties(&p_frame_owner_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFrameOwnerProperties(
std::move(p_child_frame_token), 
std::move(p_frame_owner_properties));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_opener_frame{};
      LocalFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(
std::move(p_opener_frame));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_child_frame_token{};
      ::blink::FramePolicy p_frame_policy{};
      LocalFrameHost_DidChangeFramePolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFramePolicy(
std::move(p_child_frame_token), 
std::move(p_frame_policy));
      return true;
    }
    case internal::kLocalFrameHost_DidChangeCSPAttribute_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::DidChangeCSPAttribute",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::DidChangeCSPAttribute");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DidChangeCSPAttribute_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DidChangeCSPAttribute_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_child_frame_token{};
      ::network::mojom::blink::ContentSecurityPolicyPtr p_parsed_csp_attribute{};
      LocalFrameHost_DidChangeCSPAttribute_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChildFrameToken(&p_child_frame_token))
        success = false;
      if (success && !input_data_view.ReadParsedCspAttribute(&p_parsed_csp_attribute))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeCSPAttribute(
std::move(p_child_frame_token), 
std::move(p_parsed_csp_attribute));
      return true;
    }
    case internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::CapturePaintPreviewOfSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      LocalFrameHost_CapturePaintPreviewOfSubframe_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfSubframe(
std::move(p_clip_rect), 
std::move(p_guid));
      return true;
    }
    case internal::kLocalFrameHost_Detach_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::Detach",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::Detach");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrameHost_Detach_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach();
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameHostStubDispatch::AcceptWithResponder(
    LocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrameHost_EnterFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::EnterFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::EnterFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_EnterFullscreen_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_EnterFullscreen_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FullscreenOptionsPtr p_options{};
      LocalFrameHost_EnterFullscreen_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 0, false);
        return false;
      }
      LocalFrameHost::EnterFullscreenCallback callback =
          LocalFrameHost_EnterFullscreen_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterFullscreen(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_ExitFullscreen_Name: {
      break;
    }
    case internal::kLocalFrameHost_FullscreenStateChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_RegisterProtocolHandler_Name: {
      break;
    }
    case internal::kLocalFrameHost_UnregisterProtocolHandler_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidDisplayInsecureContent_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidContainInsecureFormAction_Name: {
      break;
    }
    case internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name: {
      break;
    }
    case internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_VisibilityChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeThemeColor_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeBackgroundColor_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFailLoadWithError_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFocusFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidCallFocus_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidAddContentSecurityPolicies_Name: {
      break;
    }
    case internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name: {
      break;
    }
    case internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidAccessInitialDocument_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidBlockNavigation_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeLoadProgress_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFinishLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_DispatchLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_GoToEntryAtOffset_Name: {
      break;
    }
    case internal::kLocalFrameHost_RenderFallbackContentInParentProcess_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateTitle_Name: {
      break;
    }
    case internal::kLocalFrameHost_UpdateUserActivationState_Name: {
      break;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name: {
      break;
    }
    case internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name: {
      break;
    }
    case internal::kLocalFrameHost_DocumentOnLoadCompleted_Name: {
      break;
    }
    case internal::kLocalFrameHost_ForwardResourceTimingToParent_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidFinishDocumentLoad_Name: {
      break;
    }
    case internal::kLocalFrameHost_RunModalAlertDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalAlertDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalAlertDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalAlertDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_alert_message{};
      LocalFrameHost_RunModalAlertDialog_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 38, false);
        return false;
      }
      LocalFrameHost::RunModalAlertDialogCallback callback =
          LocalFrameHost_RunModalAlertDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalAlertDialog(
std::move(p_alert_message), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunModalConfirmDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalConfirmDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalConfirmDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalConfirmDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_alert_message{};
      LocalFrameHost_RunModalConfirmDialog_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 39, false);
        return false;
      }
      LocalFrameHost::RunModalConfirmDialogCallback callback =
          LocalFrameHost_RunModalConfirmDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalConfirmDialog(
std::move(p_alert_message), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunModalPromptDialog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunModalPromptDialog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunModalPromptDialog_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunModalPromptDialog_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_alert_message{};
      ::WTF::String p_default_value{};
      LocalFrameHost_RunModalPromptDialog_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAlertMessage(&p_alert_message))
        success = false;
      if (success && !input_data_view.ReadDefaultValue(&p_default_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 40, false);
        return false;
      }
      LocalFrameHost::RunModalPromptDialogCallback callback =
          LocalFrameHost_RunModalPromptDialog_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunModalPromptDialog(
std::move(p_alert_message), 
std::move(p_default_value), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrameHost::RunBeforeUnloadConfirm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      LocalFrameHost_RunBeforeUnloadConfirm_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 41, false);
        return false;
      }
      LocalFrameHost::RunBeforeUnloadConfirmCallback callback =
          LocalFrameHost_RunBeforeUnloadConfirm_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunBeforeUnloadConfirm(
std::move(p_is_reload), std::move(callback));
      return true;
    }
    case internal::kLocalFrameHost_UpdateFaviconURL_Name: {
      break;
    }
    case internal::kLocalFrameHost_DownloadURL_Name: {
      break;
    }
    case internal::kLocalFrameHost_FocusedElementChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_TextSelectionChanged_Name: {
      break;
    }
    case internal::kLocalFrameHost_ShowPopupMenu_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeOpener_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeFramePolicy_Name: {
      break;
    }
    case internal::kLocalFrameHost_DidChangeCSPAttribute_Name: {
      break;
    }
    case internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name: {
      break;
    }
    case internal::kLocalFrameHost_Detach_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameHostValidationInfo[] = {
    {internal::kLocalFrameHost_EnterFullscreen_Name,
     {&internal::LocalFrameHost_EnterFullscreen_Params_Data::Validate,
      &internal::LocalFrameHost_EnterFullscreen_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_ExitFullscreen_Name,
     {&internal::LocalFrameHost_ExitFullscreen_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_FullscreenStateChanged_Name,
     {&internal::LocalFrameHost_FullscreenStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_RegisterProtocolHandler_Name,
     {&internal::LocalFrameHost_RegisterProtocolHandler_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UnregisterProtocolHandler_Name,
     {&internal::LocalFrameHost_UnregisterProtocolHandler_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidDisplayInsecureContent_Name,
     {&internal::LocalFrameHost_DidDisplayInsecureContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidContainInsecureFormAction_Name,
     {&internal::LocalFrameHost_DidContainInsecureFormAction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DocumentAvailableInMainFrame_Name,
     {&internal::LocalFrameHost_DocumentAvailableInMainFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SetNeedsOcclusionTracking_Name,
     {&internal::LocalFrameHost_SetNeedsOcclusionTracking_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SetVirtualKeyboardOverlayPolicy_Name,
     {&internal::LocalFrameHost_SetVirtualKeyboardOverlayPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_VisibilityChanged_Name,
     {&internal::LocalFrameHost_VisibilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeThemeColor_Name,
     {&internal::LocalFrameHost_DidChangeThemeColor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeBackgroundColor_Name,
     {&internal::LocalFrameHost_DidChangeBackgroundColor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFailLoadWithError_Name,
     {&internal::LocalFrameHost_DidFailLoadWithError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFocusFrame_Name,
     {&internal::LocalFrameHost_DidFocusFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidCallFocus_Name,
     {&internal::LocalFrameHost_DidCallFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidAddContentSecurityPolicies_Name,
     {&internal::LocalFrameHost_DidAddContentSecurityPolicies_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_EnforceInsecureRequestPolicy_Name,
     {&internal::LocalFrameHost_EnforceInsecureRequestPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_EnforceInsecureNavigationsSet_Name,
     {&internal::LocalFrameHost_EnforceInsecureNavigationsSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Name,
     {&internal::LocalFrameHost_DidChangeActiveSchedulerTrackedFeatures_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_SuddenTerminationDisablerChanged_Name,
     {&internal::LocalFrameHost_SuddenTerminationDisablerChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Name,
     {&internal::LocalFrameHost_HadStickyUserActivationBeforeNavigationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ScrollRectToVisibleInParentFrame_Name,
     {&internal::LocalFrameHost_ScrollRectToVisibleInParentFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_BubbleLogicalScrollInParentFrame_Name,
     {&internal::LocalFrameHost_BubbleLogicalScrollInParentFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidAccessInitialDocument_Name,
     {&internal::LocalFrameHost_DidAccessInitialDocument_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidBlockNavigation_Name,
     {&internal::LocalFrameHost_DidBlockNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeLoadProgress_Name,
     {&internal::LocalFrameHost_DidChangeLoadProgress_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFinishLoad_Name,
     {&internal::LocalFrameHost_DidFinishLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DispatchLoad_Name,
     {&internal::LocalFrameHost_DispatchLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_GoToEntryAtOffset_Name,
     {&internal::LocalFrameHost_GoToEntryAtOffset_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_RenderFallbackContentInParentProcess_Name,
     {&internal::LocalFrameHost_RenderFallbackContentInParentProcess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UpdateTitle_Name,
     {&internal::LocalFrameHost_UpdateTitle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_UpdateUserActivationState_Name,
     {&internal::LocalFrameHost_UpdateUserActivationState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HandleAccessibilityFindInPageResult_Name,
     {&internal::LocalFrameHost_HandleAccessibilityFindInPageResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_HandleAccessibilityFindInPageTermination_Name,
     {&internal::LocalFrameHost_HandleAccessibilityFindInPageTermination_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DocumentOnLoadCompleted_Name,
     {&internal::LocalFrameHost_DocumentOnLoadCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ForwardResourceTimingToParent_Name,
     {&internal::LocalFrameHost_ForwardResourceTimingToParent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidFinishDocumentLoad_Name,
     {&internal::LocalFrameHost_DidFinishDocumentLoad_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_RunModalAlertDialog_Name,
     {&internal::LocalFrameHost_RunModalAlertDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalAlertDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunModalConfirmDialog_Name,
     {&internal::LocalFrameHost_RunModalConfirmDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalConfirmDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunModalPromptDialog_Name,
     {&internal::LocalFrameHost_RunModalPromptDialog_Params_Data::Validate,
      &internal::LocalFrameHost_RunModalPromptDialog_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_RunBeforeUnloadConfirm_Name,
     {&internal::LocalFrameHost_RunBeforeUnloadConfirm_Params_Data::Validate,
      &internal::LocalFrameHost_RunBeforeUnloadConfirm_ResponseParams_Data::Validate}},
    {internal::kLocalFrameHost_UpdateFaviconURL_Name,
     {&internal::LocalFrameHost_UpdateFaviconURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DownloadURL_Name,
     {&internal::LocalFrameHost_DownloadURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_FocusedElementChanged_Name,
     {&internal::LocalFrameHost_FocusedElementChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_TextSelectionChanged_Name,
     {&internal::LocalFrameHost_TextSelectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_ShowPopupMenu_Name,
     {&internal::LocalFrameHost_ShowPopupMenu_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidLoadResourceFromMemoryCache_Name,
     {&internal::LocalFrameHost_DidLoadResourceFromMemoryCache_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeFrameOwnerProperties_Name,
     {&internal::LocalFrameHost_DidChangeFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeOpener_Name,
     {&internal::LocalFrameHost_DidChangeOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeFramePolicy_Name,
     {&internal::LocalFrameHost_DidChangeFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_DidChangeCSPAttribute_Name,
     {&internal::LocalFrameHost_DidChangeCSPAttribute_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_CapturePaintPreviewOfSubframe_Name,
     {&internal::LocalFrameHost_CapturePaintPreviewOfSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrameHost_Detach_Name,
     {&internal::LocalFrameHost_Detach_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameHostValidationInfo);
}

bool LocalFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameHostValidationInfo);

}
const char LocalFrame::Name_[] = "blink.mojom.LocalFrame";

class LocalFrame_GetTextSurroundingSelection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
      LocalFrame::GetTextSurroundingSelectionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetTextSurroundingSelectionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetTextSurroundingSelection_ForwardToCallback);
};

class LocalFrame_BeforeUnload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_BeforeUnload_ForwardToCallback(
      LocalFrame::BeforeUnloadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::BeforeUnloadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_BeforeUnload_ForwardToCallback);
};

class LocalFrame_GetSavableResourceLinks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_GetSavableResourceLinks_ForwardToCallback(
      LocalFrame::GetSavableResourceLinksCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::GetSavableResourceLinksCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetSavableResourceLinks_ForwardToCallback);
};

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::GetTextSurroundingSelection(
    uint32_t in_max_length, GetTextSurroundingSelectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::GetTextSurroundingSelection", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("max_length", base::NumberToString(in_max_length));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_GetTextSurroundingSelection_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->max_length = in_max_length;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetTextSurroundingSelection_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::SendInterventionReport(
    const WTF::String& in_id, const WTF::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SendInterventionReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", in_id.Utf8());
      raw_value->SetString("message", in_message.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SendInterventionReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_SendInterventionReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LocalFrame.SendInterventionReport request");
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.SendInterventionReport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SendInterventionReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::blink::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SetFrameOwnerProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_properties.is_null()) {
        raw_value->SetString("properties", "nullptr");
      } else {
        raw_value->BeginDictionary("properties");
        in_properties->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SetFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_SetFrameOwnerProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->properties)::BaseType::BufferWriter
      properties_writer;
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_properties, buffer, &properties_writer, &serialization_context);
  params->properties.Set(
      properties_writer.is_null() ? nullptr : properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in LocalFrame.SetFrameOwnerProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::NotifyUserActivation(
    ::blink::mojom::blink::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::NotifyUserActivation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("notification_type", base::trace_event::ValueToString(in_notification_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_NotifyUserActivation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_NotifyUserActivation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyUserActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::NotifyVirtualKeyboardOverlayRect(
    const ::gfx::Rect& in_keyboard_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("keyboard_rect", base::trace_event::ValueToString(in_keyboard_rect, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->keyboard_rect)::BaseType::BufferWriter
      keyboard_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_keyboard_rect, buffer, &keyboard_rect_writer, &serialization_context);
  params->keyboard_rect.Set(
      keyboard_rect_writer.is_null() ? nullptr : keyboard_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keyboard_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keyboard_rect in LocalFrame.NotifyVirtualKeyboardOverlayRect request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyVirtualKeyboardOverlayRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AddMessageToConsole(
    ::blink::mojom::blink::ConsoleMessageLevel in_level, const WTF::String& in_message, bool in_discard_duplicates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AddMessageToConsole", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("level", base::trace_event::ValueToString(in_level));
      raw_value->SetString("message", in_message.Utf8());
      raw_value->SetBoolean("discard_duplicates", in_discard_duplicates);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_AddMessageToConsole_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_AddMessageToConsole_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
      in_level, &params->level);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.AddMessageToConsole request");
  params->discard_duplicates = in_discard_duplicates;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AddInspectorIssue(
    ::blink::mojom::blink::InspectorIssueInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AddInspectorIssue", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_info.is_null()) {
        raw_value->SetString("info", "nullptr");
      } else {
        raw_value->BeginDictionary("info");
        in_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_AddInspectorIssue_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_AddInspectorIssue_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::blink::mojom::InspectorIssueInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in LocalFrame.AddInspectorIssue request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AddInspectorIssue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::CheckCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_CheckCompleted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_CheckCompleted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::StopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::StopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_StopLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_StopLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("StopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::Collapse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("collapsed", in_collapsed);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_Collapse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_Collapse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->collapsed = in_collapsed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::EnableViewSourceMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::EnableViewSourceMode");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_EnableViewSourceMode_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_EnableViewSourceMode_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("EnableViewSourceMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::Focus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_Focus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_Focus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ClearFocusedElement(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::ClearFocusedElement");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_ClearFocusedElement_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_ClearFocusedElement_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ClearFocusedElement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::GetResourceSnapshotForWebBundle(
    ::mojo::PendingReceiver<::data_decoder::mojom::blink::ResourceSnapshotForWebBundle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in LocalFrame.GetResourceSnapshotForWebBundle request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetResourceSnapshotForWebBundle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::CopyImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::CopyImageAt", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("window_point", base::trace_event::ValueToString(in_window_point, "<value of type const ::gfx::Point&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_CopyImageAt_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_CopyImageAt_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->window_point)::BaseType::BufferWriter
      window_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_window_point, buffer, &window_point_writer, &serialization_context);
  params->window_point.Set(
      window_point_writer.is_null() ? nullptr : window_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_point in LocalFrame.CopyImageAt request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("CopyImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::SaveImageAt(
    const ::gfx::Point& in_window_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::SaveImageAt", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("window_point", base::trace_event::ValueToString(in_window_point, "<value of type const ::gfx::Point&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_SaveImageAt_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_SaveImageAt_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->window_point)::BaseType::BufferWriter
      window_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_window_point, buffer, &window_point_writer, &serialization_context);
  params->window_point.Set(
      window_point_writer.is_null() ? nullptr : window_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_point in LocalFrame.SaveImageAt request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SaveImageAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ReportBlinkFeatureUsage(
    const WTF::Vector<::blink::mojom::blink::WebFeature>& in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::ReportBlinkFeatureUsage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("features");
      for (const auto& item0 : in_features) {
        raw_value->AppendString(base::trace_event::ValueToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_ReportBlinkFeatureUsage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->features)::BaseType::BufferWriter
      features_writer;
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, ::blink::mojom::internal::WebFeature_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_features, buffer, &features_writer, &features_validate_params,
      &serialization_context);
  params->features.Set(
      features_writer.is_null() ? nullptr : features_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LocalFrame.ReportBlinkFeatureUsage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportBlinkFeatureUsage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::RenderFallbackContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_RenderFallbackContent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_RenderFallbackContent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::BeforeUnload(
    bool in_is_reload, BeforeUnloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::BeforeUnload", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_reload", in_is_reload);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_BeforeUnload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_BeforeUnload_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_reload = in_is_reload;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_BeforeUnload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalFrameProxy::MediaPlayerActionAt(
    const ::gfx::Point& in_location, ::blink::mojom::blink::MediaPlayerActionPtr in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::MediaPlayerActionAt", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("location", base::trace_event::ValueToString(in_location, "<value of type const ::gfx::Point&>"));
      if (in_action.is_null()) {
        raw_value->SetString("action", "nullptr");
      } else {
        raw_value->BeginDictionary("action");
        in_action->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_MediaPlayerActionAt_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_MediaPlayerActionAt_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->location)::BaseType::BufferWriter
      location_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location, buffer, &location_writer, &serialization_context);
  params->location.Set(
      location_writer.is_null() ? nullptr : location_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in LocalFrame.MediaPlayerActionAt request");
  typename decltype(params->action)::BaseType::BufferWriter
      action_writer;
  mojo::internal::Serialize<::blink::mojom::MediaPlayerActionDataView>(
      in_action, buffer, &action_writer, &serialization_context);
  params->action.Set(
      action_writer.is_null() ? nullptr : action_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in LocalFrame.MediaPlayerActionAt request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MediaPlayerActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AdvanceFocusInFrame(
    ::blink::mojom::blink::FocusType in_focus_type, const base::Optional<::base::UnguessableToken>& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AdvanceFocusInFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("focus_type", base::trace_event::ValueToString(in_focus_type));
      raw_value->SetString("source_frame_token", base::trace_event::ValueToString(in_source_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_AdvanceFocusInFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_AdvanceFocusInFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  typename decltype(params->source_frame_token)::BaseType::BufferWriter
      source_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_frame_token, buffer, &source_frame_token_writer, &serialization_context);
  params->source_frame_token.Set(
      source_frame_token_writer.is_null() ? nullptr : source_frame_token_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusInFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::AdvanceFocusInForm(
    ::blink::mojom::blink::FocusType in_focus_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::AdvanceFocusInForm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("focus_type", base::trace_event::ValueToString(in_focus_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_AdvanceFocusInForm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_AdvanceFocusInForm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AdvanceFocusInForm");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::ReportContentSecurityPolicyViolation(
    ::network::mojom::blink::CSPViolationPtr in_violation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_violation.is_null()) {
        raw_value->SetString("violation", "nullptr");
      } else {
        raw_value->BeginDictionary("violation");
        in_violation->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->violation)::BaseType::BufferWriter
      violation_writer;
  mojo::internal::Serialize<::network::mojom::CSPViolationDataView>(
      in_violation, buffer, &violation_writer, &serialization_context);
  params->violation.Set(
      violation_writer.is_null() ? nullptr : violation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->violation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null violation in LocalFrame.ReportContentSecurityPolicyViolation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ReportContentSecurityPolicyViolation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::DidUpdateFramePolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_policy", base::trace_event::ValueToString(in_frame_policy, "<value of type const ::blink::FramePolicy&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_DidUpdateFramePolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_DidUpdateFramePolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_policy)::BaseType::BufferWriter
      frame_policy_writer;
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, buffer, &frame_policy_writer, &serialization_context);
  params->frame_policy.Set(
      frame_policy_writer.is_null() ? nullptr : frame_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in LocalFrame.DidUpdateFramePolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::OnScreensChange(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::OnScreensChange");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_OnScreensChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_OnScreensChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("OnScreensChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::PostMessageEvent(
    const base::Optional<::base::UnguessableToken>& in_source_frame_token, const ::WTF::String& in_source_origin, const ::WTF::String& in_target_origin, ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::PostMessageEvent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("source_frame_token", base::trace_event::ValueToString(in_source_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetString("source_origin", base::trace_event::ValueToString(in_source_origin, "<value of type const ::WTF::String&>"));
      raw_value->SetString("target_origin", base::trace_event::ValueToString(in_target_origin, "<value of type const ::WTF::String&>"));
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_PostMessageEvent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_PostMessageEvent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->source_frame_token)::BaseType::BufferWriter
      source_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_frame_token, buffer, &source_frame_token_writer, &serialization_context);
  params->source_frame_token.Set(
      source_frame_token_writer.is_null() ? nullptr : source_frame_token_writer.data());
  typename decltype(params->source_origin)::BaseType::BufferWriter
      source_origin_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_origin, buffer, &source_origin_writer, &serialization_context);
  params->source_origin.Set(
      source_origin_writer.is_null() ? nullptr : source_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in LocalFrame.PostMessageEvent request");
  typename decltype(params->target_origin)::BaseType::BufferWriter
      target_origin_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_target_origin, buffer, &target_origin_writer, &serialization_context);
  params->target_origin.Set(
      target_origin_writer.is_null() ? nullptr : target_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_origin in LocalFrame.PostMessageEvent request");
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalFrame.PostMessageEvent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("PostMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::BindReportingObserver(
    ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::BindReportingObserver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_BindReportingObserver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_BindReportingObserver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ReportingObserverInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in LocalFrame.BindReportingObserver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BindReportingObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::UpdateOpener(
    const base::Optional<::base::UnguessableToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalFrame::UpdateOpener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("opener_frame_token", base::trace_event::ValueToString(in_opener_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_UpdateOpener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_UpdateOpener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->opener_frame_token)::BaseType::BufferWriter
      opener_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_opener_frame_token, buffer, &opener_frame_token_writer, &serialization_context);
  params->opener_frame_token.Set(
      opener_frame_token_writer.is_null() ? nullptr : opener_frame_token_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalFrameProxy::GetSavableResourceLinks(
    GetSavableResourceLinksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalFrame::GetSavableResourceLinks");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_GetSavableResourceLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_GetSavableResourceLinks_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LocalFrame_GetTextSurroundingSelection_ProxyToResponder {
 public:
  static LocalFrame::GetTextSurroundingSelectionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_GetTextSurroundingSelection_ProxyToResponder> proxy(
        new LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetTextSurroundingSelection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_GetTextSurroundingSelection_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::GetTextSurroundingSelectionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::WTF::String& in_content, uint32_t in_start_offset, uint32_t in_end_offset);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetTextSurroundingSelection_ProxyToResponder);
};

bool LocalFrame_GetTextSurroundingSelection_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::WTF::String p_content{};
  uint32_t p_start_offset{};
  uint32_t p_end_offset{};
  LocalFrame_GetTextSurroundingSelection_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadContent(&p_content))
    success = false;
  if (success)
    p_start_offset = input_data_view.start_offset();
  if (success)
    p_end_offset = input_data_view.end_offset();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_content), 
std::move(p_start_offset), 
std::move(p_end_offset));
  return true;
}

void LocalFrame_GetTextSurroundingSelection_ProxyToResponder::Run(
    const ::WTF::String& in_content, uint32_t in_start_offset, uint32_t in_end_offset) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("content", base::trace_event::ValueToString(in_content, "<value of type const ::WTF::String&>"));
      raw_value->SetString("start_offset", base::NumberToString(in_start_offset));
      raw_value->SetString("end_offset", base::NumberToString(in_end_offset));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_GetTextSurroundingSelection_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->content)::BaseType::BufferWriter
      content_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_content, buffer, &content_writer, &serialization_context);
  params->content.Set(
      content_writer.is_null() ? nullptr : content_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in ");
  params->start_offset = in_start_offset;
  params->end_offset = in_end_offset;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelectionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetTextSurroundingSelection");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_BeforeUnload_ProxyToResponder {
 public:
  static LocalFrame::BeforeUnloadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_BeforeUnload_ProxyToResponder> proxy(
        new LocalFrame_BeforeUnload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_BeforeUnload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_BeforeUnload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_BeforeUnload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::BeforeUnloadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_BeforeUnload_ProxyToResponder);
};

bool LocalFrame_BeforeUnload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::BeforeUnloadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrame_BeforeUnload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_BeforeUnload_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_proceed{};
  ::base::TimeTicks p_before_unload_start_time{};
  ::base::TimeTicks p_before_unload_end_time{};
  LocalFrame_BeforeUnload_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success && !input_data_view.ReadBeforeUnloadStartTime(&p_before_unload_start_time))
    success = false;
  if (success && !input_data_view.ReadBeforeUnloadEndTime(&p_before_unload_end_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_before_unload_start_time), 
std::move(p_before_unload_end_time));
  return true;
}

void LocalFrame_BeforeUnload_ProxyToResponder::Run(
    bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::BeforeUnloadCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("proceed", in_proceed);
      raw_value->SetString("before_unload_start_time", base::trace_event::ValueToString(in_before_unload_start_time, "<value of type ::base::TimeTicks>"));
      raw_value->SetString("before_unload_end_time", base::trace_event::ValueToString(in_before_unload_end_time, "<value of type ::base::TimeTicks>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_BeforeUnload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_BeforeUnload_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->proceed = in_proceed;
  typename decltype(params->before_unload_start_time)::BaseType::BufferWriter
      before_unload_start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_start_time, buffer, &before_unload_start_time_writer, &serialization_context);
  params->before_unload_start_time.Set(
      before_unload_start_time_writer.is_null() ? nullptr : before_unload_start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_start_time in ");
  typename decltype(params->before_unload_end_time)::BaseType::BufferWriter
      before_unload_end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_end_time, buffer, &before_unload_end_time_writer, &serialization_context);
  params->before_unload_end_time.Set(
      before_unload_end_time_writer.is_null() ? nullptr : before_unload_end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_end_time in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::BeforeUnloadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("BeforeUnload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_GetSavableResourceLinks_ProxyToResponder {
 public:
  static LocalFrame::GetSavableResourceLinksCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalFrame_GetSavableResourceLinks_ProxyToResponder> proxy(
        new LocalFrame_GetSavableResourceLinks_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_GetSavableResourceLinks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalFrame_GetSavableResourceLinks_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalFrame::GetSavableResourceLinksCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetSavableResourceLinksReplyPtr in_reply);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalFrame_GetSavableResourceLinks_ProxyToResponder);
};

bool LocalFrame_GetSavableResourceLinks_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalFrame::GetSavableResourceLinksCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  GetSavableResourceLinksReplyPtr p_reply{};
  LocalFrame_GetSavableResourceLinks_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_reply));
  return true;
}

void LocalFrame_GetSavableResourceLinks_ProxyToResponder::Run(
    GetSavableResourceLinksReplyPtr in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinksCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_reply.is_null()) {
        raw_value->SetString("reply", "nullptr");
      } else {
        raw_value->BeginDictionary("reply");
        in_reply->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalFrame_GetSavableResourceLinks_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->reply)::BaseType::BufferWriter
      reply_writer;
  mojo::internal::Serialize<::blink::mojom::GetSavableResourceLinksReplyDataView>(
      in_reply, buffer, &reply_writer, &serialization_context);
  params->reply.Set(
      reply_writer.is_null() ? nullptr : reply_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinksCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("GetSavableResourceLinks");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kLocalFrame_GetTextSurroundingSelection_Name: {
      break;
    }
    case internal::kLocalFrame_SendInterventionReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SendInterventionReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SendInterventionReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SendInterventionReport_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SendInterventionReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_id{};
      WTF::String p_message{};
      LocalFrame_SendInterventionReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendInterventionReport(
std::move(p_id), 
std::move(p_message));
      return true;
    }
    case internal::kLocalFrame_SetFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SetFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SetFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FrameOwnerPropertiesPtr p_properties{};
      LocalFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(
std::move(p_properties));
      return true;
    }
    case internal::kLocalFrame_NotifyUserActivation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::NotifyUserActivation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::NotifyUserActivation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyUserActivation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyUserActivation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::UserActivationNotificationType p_notification_type{};
      LocalFrame_NotifyUserActivation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUserActivation(
std::move(p_notification_type));
      return true;
    }
    case internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::NotifyVirtualKeyboardOverlayRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_keyboard_rect{};
      LocalFrame_NotifyVirtualKeyboardOverlayRect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadKeyboardRect(&p_keyboard_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyVirtualKeyboardOverlayRect(
std::move(p_keyboard_rect));
      return true;
    }
    case internal::kLocalFrame_AddMessageToConsole_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AddMessageToConsole",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AddMessageToConsole");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ConsoleMessageLevel p_level{};
      WTF::String p_message{};
      bool p_discard_duplicates{};
      LocalFrame_AddMessageToConsole_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_discard_duplicates = input_data_view.discard_duplicates();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMessageToConsole(
std::move(p_level), 
std::move(p_message), 
std::move(p_discard_duplicates));
      return true;
    }
    case internal::kLocalFrame_AddInspectorIssue_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AddInspectorIssue",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AddInspectorIssue");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AddInspectorIssue_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AddInspectorIssue_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::InspectorIssueInfoPtr p_info{};
      LocalFrame_AddInspectorIssue_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddInspectorIssue(
std::move(p_info));
      return true;
    }
    case internal::kLocalFrame_CheckCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::CheckCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::CheckCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_CheckCompleted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted();
      return true;
    }
    case internal::kLocalFrame_StopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::StopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::StopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_StopLoading_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_StopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_StopLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopLoading();
      return true;
    }
    case internal::kLocalFrame_Collapse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::Collapse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::Collapse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_collapsed{};
      LocalFrame_Collapse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(
std::move(p_collapsed));
      return true;
    }
    case internal::kLocalFrame_EnableViewSourceMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::EnableViewSourceMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::EnableViewSourceMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_EnableViewSourceMode_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_EnableViewSourceMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_EnableViewSourceMode_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableViewSourceMode();
      return true;
    }
    case internal::kLocalFrame_Focus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::Focus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::Focus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_Focus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_Focus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus();
      return true;
    }
    case internal::kLocalFrame_ClearFocusedElement_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ClearFocusedElement",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ClearFocusedElement");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ClearFocusedElement_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ClearFocusedElement_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_ClearFocusedElement_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearFocusedElement();
      return true;
    }
    case internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetResourceSnapshotForWebBundle");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::blink::ResourceSnapshotForWebBundle> p_receiver{};
      LocalFrame_GetResourceSnapshotForWebBundle_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetResourceSnapshotForWebBundle(
std::move(p_receiver));
      return true;
    }
    case internal::kLocalFrame_CopyImageAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::CopyImageAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::CopyImageAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_CopyImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_CopyImageAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_CopyImageAt_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyImageAt(
std::move(p_window_point));
      return true;
    }
    case internal::kLocalFrame_SaveImageAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::SaveImageAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::SaveImageAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_SaveImageAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SaveImageAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_window_point{};
      LocalFrame_SaveImageAt_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWindowPoint(&p_window_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveImageAt(
std::move(p_window_point));
      return true;
    }
    case internal::kLocalFrame_ReportBlinkFeatureUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ReportBlinkFeatureUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ReportBlinkFeatureUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::blink::mojom::blink::WebFeature> p_features{};
      LocalFrame_ReportBlinkFeatureUsage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportBlinkFeatureUsage(
std::move(p_features));
      return true;
    }
    case internal::kLocalFrame_RenderFallbackContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::RenderFallbackContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::RenderFallbackContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_RenderFallbackContent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent();
      return true;
    }
    case internal::kLocalFrame_BeforeUnload_Name: {
      break;
    }
    case internal::kLocalFrame_MediaPlayerActionAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::MediaPlayerActionAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::MediaPlayerActionAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_MediaPlayerActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MediaPlayerActionAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_location{};
      ::blink::mojom::blink::MediaPlayerActionPtr p_action{};
      LocalFrame_MediaPlayerActionAt_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaPlayerActionAt(
std::move(p_location), 
std::move(p_action));
      return true;
    }
    case internal::kLocalFrame_AdvanceFocusInFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AdvanceFocusInFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AdvanceFocusInFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusInFrame_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusInFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FocusType p_focus_type{};
      base::Optional<::base::UnguessableToken> p_source_frame_token{};
      LocalFrame_AdvanceFocusInFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusInFrame(
std::move(p_focus_type), 
std::move(p_source_frame_token));
      return true;
    }
    case internal::kLocalFrame_AdvanceFocusInForm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::AdvanceFocusInForm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::AdvanceFocusInForm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_AdvanceFocusInForm_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AdvanceFocusInForm_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FocusType p_focus_type{};
      LocalFrame_AdvanceFocusInForm_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocusInForm(
std::move(p_focus_type));
      return true;
    }
    case internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::ReportContentSecurityPolicyViolation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::CSPViolationPtr p_violation{};
      LocalFrame_ReportContentSecurityPolicyViolation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadViolation(&p_violation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportContentSecurityPolicyViolation(
std::move(p_violation));
      return true;
    }
    case internal::kLocalFrame_DidUpdateFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::DidUpdateFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::DidUpdateFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      LocalFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(
std::move(p_frame_policy));
      return true;
    }
    case internal::kLocalFrame_OnScreensChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::OnScreensChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::OnScreensChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_OnScreensChange_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_OnScreensChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalFrame_OnScreensChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreensChange();
      return true;
    }
    case internal::kLocalFrame_PostMessageEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::PostMessageEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::PostMessageEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_PostMessageEvent_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_PostMessageEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_source_frame_token{};
      ::WTF::String p_source_origin{};
      ::WTF::String p_target_origin{};
      ::blink::BlinkTransferableMessage p_message{};
      LocalFrame_PostMessageEvent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageEvent(
std::move(p_source_frame_token), 
std::move(p_source_origin), 
std::move(p_target_origin), 
std::move(p_message));
      return true;
    }
    case internal::kLocalFrame_BindReportingObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::BindReportingObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::BindReportingObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_BindReportingObserver_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_BindReportingObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> p_receiver{};
      LocalFrame_BindReportingObserver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReportingObserver(
std::move(p_receiver));
      return true;
    }
    case internal::kLocalFrame_UpdateOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::UpdateOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::UpdateOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_opener_frame_token{};
      LocalFrame_UpdateOpener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(
std::move(p_opener_frame_token));
      return true;
    }
    case internal::kLocalFrame_GetSavableResourceLinks_Name: {
      break;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalFrame_GetTextSurroundingSelection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetTextSurroundingSelection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_GetTextSurroundingSelection_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetTextSurroundingSelection_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_max_length{};
      LocalFrame_GetTextSurroundingSelection_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_max_length = input_data_view.max_length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      LocalFrame::GetTextSurroundingSelectionCallback callback =
          LocalFrame_GetTextSurroundingSelection_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTextSurroundingSelection(
std::move(p_max_length), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_SendInterventionReport_Name: {
      break;
    }
    case internal::kLocalFrame_SetFrameOwnerProperties_Name: {
      break;
    }
    case internal::kLocalFrame_NotifyUserActivation_Name: {
      break;
    }
    case internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name: {
      break;
    }
    case internal::kLocalFrame_AddMessageToConsole_Name: {
      break;
    }
    case internal::kLocalFrame_AddInspectorIssue_Name: {
      break;
    }
    case internal::kLocalFrame_CheckCompleted_Name: {
      break;
    }
    case internal::kLocalFrame_StopLoading_Name: {
      break;
    }
    case internal::kLocalFrame_Collapse_Name: {
      break;
    }
    case internal::kLocalFrame_EnableViewSourceMode_Name: {
      break;
    }
    case internal::kLocalFrame_Focus_Name: {
      break;
    }
    case internal::kLocalFrame_ClearFocusedElement_Name: {
      break;
    }
    case internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name: {
      break;
    }
    case internal::kLocalFrame_CopyImageAt_Name: {
      break;
    }
    case internal::kLocalFrame_SaveImageAt_Name: {
      break;
    }
    case internal::kLocalFrame_ReportBlinkFeatureUsage_Name: {
      break;
    }
    case internal::kLocalFrame_RenderFallbackContent_Name: {
      break;
    }
    case internal::kLocalFrame_BeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::BeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::BeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_BeforeUnload_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_BeforeUnload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      LocalFrame_BeforeUnload_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 18, false);
        return false;
      }
      LocalFrame::BeforeUnloadCallback callback =
          LocalFrame_BeforeUnload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeforeUnload(
std::move(p_is_reload), std::move(callback));
      return true;
    }
    case internal::kLocalFrame_MediaPlayerActionAt_Name: {
      break;
    }
    case internal::kLocalFrame_AdvanceFocusInFrame_Name: {
      break;
    }
    case internal::kLocalFrame_AdvanceFocusInForm_Name: {
      break;
    }
    case internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name: {
      break;
    }
    case internal::kLocalFrame_DidUpdateFramePolicy_Name: {
      break;
    }
    case internal::kLocalFrame_OnScreensChange_Name: {
      break;
    }
    case internal::kLocalFrame_PostMessageEvent_Name: {
      break;
    }
    case internal::kLocalFrame_BindReportingObserver_Name: {
      break;
    }
    case internal::kLocalFrame_UpdateOpener_Name: {
      break;
    }
    case internal::kLocalFrame_GetSavableResourceLinks_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinks",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalFrame::GetSavableResourceLinks");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalFrame_GetSavableResourceLinks_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_GetSavableResourceLinks_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalFrame_GetSavableResourceLinks_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 28, false);
        return false;
      }
      LocalFrame::GetSavableResourceLinksCallback callback =
          LocalFrame_GetSavableResourceLinks_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSavableResourceLinks(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalFrameValidationInfo[] = {
    {internal::kLocalFrame_GetTextSurroundingSelection_Name,
     {&internal::LocalFrame_GetTextSurroundingSelection_Params_Data::Validate,
      &internal::LocalFrame_GetTextSurroundingSelection_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_SendInterventionReport_Name,
     {&internal::LocalFrame_SendInterventionReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SetFrameOwnerProperties_Name,
     {&internal::LocalFrame_SetFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_NotifyUserActivation_Name,
     {&internal::LocalFrame_NotifyUserActivation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_NotifyVirtualKeyboardOverlayRect_Name,
     {&internal::LocalFrame_NotifyVirtualKeyboardOverlayRect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AddMessageToConsole_Name,
     {&internal::LocalFrame_AddMessageToConsole_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AddInspectorIssue_Name,
     {&internal::LocalFrame_AddInspectorIssue_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_CheckCompleted_Name,
     {&internal::LocalFrame_CheckCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_StopLoading_Name,
     {&internal::LocalFrame_StopLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_Collapse_Name,
     {&internal::LocalFrame_Collapse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_EnableViewSourceMode_Name,
     {&internal::LocalFrame_EnableViewSourceMode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_Focus_Name,
     {&internal::LocalFrame_Focus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ClearFocusedElement_Name,
     {&internal::LocalFrame_ClearFocusedElement_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_GetResourceSnapshotForWebBundle_Name,
     {&internal::LocalFrame_GetResourceSnapshotForWebBundle_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_CopyImageAt_Name,
     {&internal::LocalFrame_CopyImageAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_SaveImageAt_Name,
     {&internal::LocalFrame_SaveImageAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ReportBlinkFeatureUsage_Name,
     {&internal::LocalFrame_ReportBlinkFeatureUsage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_RenderFallbackContent_Name,
     {&internal::LocalFrame_RenderFallbackContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_BeforeUnload_Name,
     {&internal::LocalFrame_BeforeUnload_Params_Data::Validate,
      &internal::LocalFrame_BeforeUnload_ResponseParams_Data::Validate}},
    {internal::kLocalFrame_MediaPlayerActionAt_Name,
     {&internal::LocalFrame_MediaPlayerActionAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AdvanceFocusInFrame_Name,
     {&internal::LocalFrame_AdvanceFocusInFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_AdvanceFocusInForm_Name,
     {&internal::LocalFrame_AdvanceFocusInForm_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_ReportContentSecurityPolicyViolation_Name,
     {&internal::LocalFrame_ReportContentSecurityPolicyViolation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_DidUpdateFramePolicy_Name,
     {&internal::LocalFrame_DidUpdateFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_OnScreensChange_Name,
     {&internal::LocalFrame_OnScreensChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_PostMessageEvent_Name,
     {&internal::LocalFrame_PostMessageEvent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_BindReportingObserver_Name,
     {&internal::LocalFrame_BindReportingObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_UpdateOpener_Name,
     {&internal::LocalFrame_UpdateOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalFrame_GetSavableResourceLinks_Name,
     {&internal::LocalFrame_GetSavableResourceLinks_Params_Data::Validate,
      &internal::LocalFrame_GetSavableResourceLinks_ResponseParams_Data::Validate}},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalFrameValidationInfo);
}

bool LocalFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalFrameValidationInfo);

}
const char HighPriorityLocalFrame::Name_[] = "blink.mojom.HighPriorityLocalFrame";

class HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback(
      HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback);
};

HighPriorityLocalFrameProxy::HighPriorityLocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HighPriorityLocalFrameProxy::DispatchBeforeUnload(
    bool in_is_reload, DispatchBeforeUnloadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_reload", in_is_reload);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_reload = in_is_reload;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HighPriorityLocalFrame::Name_);
  message.set_method_name("DispatchBeforeUnload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder {
 public:
  static HighPriorityLocalFrame::DispatchBeforeUnloadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder> proxy(
        new HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HighPriorityLocalFrame::DispatchBeforeUnloadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder);
};

bool HighPriorityLocalFrame_DispatchBeforeUnload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_proceed{};
  ::base::TimeTicks p_before_unload_start_time{};
  ::base::TimeTicks p_before_unload_end_time{};
  HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success && !input_data_view.ReadBeforeUnloadStartTime(&p_before_unload_start_time))
    success = false;
  if (success && !input_data_view.ReadBeforeUnloadEndTime(&p_before_unload_end_time))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HighPriorityLocalFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_before_unload_start_time), 
std::move(p_before_unload_end_time));
  return true;
}

void HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::Run(
    bool in_proceed, ::base::TimeTicks in_before_unload_start_time, ::base::TimeTicks in_before_unload_end_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("proceed", in_proceed);
      raw_value->SetString("before_unload_start_time", base::trace_event::ValueToString(in_before_unload_start_time, "<value of type ::base::TimeTicks>"));
      raw_value->SetString("before_unload_end_time", base::trace_event::ValueToString(in_before_unload_end_time, "<value of type ::base::TimeTicks>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->proceed = in_proceed;
  typename decltype(params->before_unload_start_time)::BaseType::BufferWriter
      before_unload_start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_start_time, buffer, &before_unload_start_time_writer, &serialization_context);
  params->before_unload_start_time.Set(
      before_unload_start_time_writer.is_null() ? nullptr : before_unload_start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_start_time in ");
  typename decltype(params->before_unload_end_time)::BaseType::BufferWriter
      before_unload_end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_before_unload_end_time, buffer, &before_unload_end_time_writer, &serialization_context);
  params->before_unload_end_time.Set(
      before_unload_end_time_writer.is_null() ? nullptr : before_unload_end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->before_unload_end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null before_unload_end_time in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnloadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HighPriorityLocalFrame::Name_);
  message.set_method_name("DispatchBeforeUnload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HighPriorityLocalFrameStubDispatch::Accept(
    HighPriorityLocalFrame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name: {
      break;
    }
  }
  return false;
}

// static
bool HighPriorityLocalFrameStubDispatch::AcceptWithResponder(
    HighPriorityLocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::HighPriorityLocalFrame::DispatchBeforeUnload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data* params =
          reinterpret_cast<
              internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_is_reload{};
      HighPriorityLocalFrame_DispatchBeforeUnload_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HighPriorityLocalFrame::Name_, 0, false);
        return false;
      }
      HighPriorityLocalFrame::DispatchBeforeUnloadCallback callback =
          HighPriorityLocalFrame_DispatchBeforeUnload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchBeforeUnload(
std::move(p_is_reload), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHighPriorityLocalFrameValidationInfo[] = {
    {internal::kHighPriorityLocalFrame_DispatchBeforeUnload_Name,
     {&internal::HighPriorityLocalFrame_DispatchBeforeUnload_Params_Data::Validate,
      &internal::HighPriorityLocalFrame_DispatchBeforeUnload_ResponseParams_Data::Validate}},
};

bool HighPriorityLocalFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::HighPriorityLocalFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHighPriorityLocalFrameValidationInfo);
}

bool HighPriorityLocalFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::HighPriorityLocalFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHighPriorityLocalFrameValidationInfo);

}
const char RemoteFrameHost::Name_[] = "blink.mojom.RemoteFrameHost";

RemoteFrameHostProxy::RemoteFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameHostProxy::SetInheritedEffectiveTouchAction(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("touch_action", static_cast<int>(in_touch_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
      in_touch_action, &params->touch_action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetInheritedEffectiveTouchAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::UpdateRenderThrottlingStatus(
    bool in_is_throttled, bool in_subtree_throttled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_throttled", in_is_throttled);
      raw_value->SetBoolean("subtree_throttled", in_subtree_throttled);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_throttled = in_is_throttled;
  params->subtree_throttled = in_subtree_throttled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("UpdateRenderThrottlingStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::VisibilityChanged(
    ::blink::mojom::blink::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::VisibilityChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("visibility", base::trace_event::ValueToString(in_visibility));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_VisibilityChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_VisibilityChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
      in_visibility, &params->visibility);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::DidFocusFrame");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_DidFocusFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_DidFocusFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::CheckCompleted");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_CheckCompleted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_CheckCompleted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::CapturePaintPreviewOfCrossProcessSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("clip_rect", base::trace_event::ValueToString(in_clip_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetString("guid", base::trace_event::ValueToString(in_guid, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->clip_rect)::BaseType::BufferWriter
      clip_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_clip_rect, buffer, &clip_rect_writer, &serialization_context);
  params->clip_rect.Set(
      clip_rect_writer.is_null() ? nullptr : clip_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->clip_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clip_rect in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");
  typename decltype(params->guid)::BaseType::BufferWriter
      guid_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_guid, buffer, &guid_writer, &serialization_context);
  params->guid.Set(
      guid_writer.is_null() ? nullptr : guid_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::SetIsInert(
    bool in_inert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::SetIsInert", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("inert", in_inert);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_SetIsInert_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_SetIsInert_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->inert = in_inert;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetIsInert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::DidChangeOpener(
    const base::Optional<::base::UnguessableToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::DidChangeOpener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("opener_frame", base::trace_event::ValueToString(in_opener_frame, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_DidChangeOpener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_DidChangeOpener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->opener_frame)::BaseType::BufferWriter
      opener_frame_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_opener_frame, buffer, &opener_frame_writer, &serialization_context);
  params->opener_frame.Set(
      opener_frame_writer.is_null() ? nullptr : opener_frame_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::AdvanceFocus(
    ::blink::mojom::blink::FocusType in_focus_type, const ::base::UnguessableToken& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::AdvanceFocus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("focus_type", base::trace_event::ValueToString(in_focus_type));
      raw_value->SetString("source_frame_token", base::trace_event::ValueToString(in_source_frame_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_AdvanceFocus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_AdvanceFocus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::FocusType>(
      in_focus_type, &params->focus_type);
  typename decltype(params->source_frame_token)::BaseType::BufferWriter
      source_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_frame_token, buffer, &source_frame_token_writer, &serialization_context);
  params->source_frame_token.Set(
      source_frame_token_writer.is_null() ? nullptr : source_frame_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_frame_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_frame_token in RemoteFrameHost.AdvanceFocus request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("AdvanceFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::RouteMessageEvent(
    const base::Optional<::base::UnguessableToken>& in_source_frame_token, const ::WTF::String& in_source_origin, const ::WTF::String& in_target_origin, ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::RouteMessageEvent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("source_frame_token", base::trace_event::ValueToString(in_source_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetString("source_origin", base::trace_event::ValueToString(in_source_origin, "<value of type const ::WTF::String&>"));
      raw_value->SetString("target_origin", base::trace_event::ValueToString(in_target_origin, "<value of type const ::WTF::String&>"));
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_RouteMessageEvent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_RouteMessageEvent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->source_frame_token)::BaseType::BufferWriter
      source_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_frame_token, buffer, &source_frame_token_writer, &serialization_context);
  params->source_frame_token.Set(
      source_frame_token_writer.is_null() ? nullptr : source_frame_token_writer.data());
  typename decltype(params->source_origin)::BaseType::BufferWriter
      source_origin_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_source_origin, buffer, &source_origin_writer, &serialization_context);
  params->source_origin.Set(
      source_origin_writer.is_null() ? nullptr : source_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in RemoteFrameHost.RouteMessageEvent request");
  typename decltype(params->target_origin)::BaseType::BufferWriter
      target_origin_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_target_origin, buffer, &target_origin_writer, &serialization_context);
  params->target_origin.Set(
      target_origin_writer.is_null() ? nullptr : target_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->target_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_origin in RemoteFrameHost.RouteMessageEvent request");
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in RemoteFrameHost.RouteMessageEvent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("RouteMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::PrintCrossProcessSubframe(
    const ::gfx::Rect& in_frame_content_rect, int32_t in_document_cookie) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_content_rect", base::trace_event::ValueToString(in_frame_content_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetInteger("document_cookie", in_document_cookie);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_content_rect)::BaseType::BufferWriter
      frame_content_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_frame_content_rect, buffer, &frame_content_rect_writer, &serialization_context);
  params->frame_content_rect.Set(
      frame_content_rect_writer.is_null() ? nullptr : frame_content_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_content_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_content_rect in RemoteFrameHost.PrintCrossProcessSubframe request");
  params->document_cookie = in_document_cookie;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("PrintCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrameHost::Detach");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrameHost_Detach_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrameHost_Detach_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteFrameHostStubDispatch::Accept(
    RemoteFrameHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInheritedEffectiveTouchAction(
std::move(p_touch_action));
      return true;
    }
    case internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_throttled{};
      bool p_subtree_throttled{};
      RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_throttled = input_data_view.is_throttled();
      if (success)
        p_subtree_throttled = input_data_view.subtree_throttled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRenderThrottlingStatus(
std::move(p_is_throttled), 
std::move(p_subtree_throttled));
      return true;
    }
    case internal::kRemoteFrameHost_VisibilityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::VisibilityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::VisibilityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FrameVisibility p_visibility{};
      RemoteFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(
std::move(p_visibility));
      return true;
    }
    case internal::kRemoteFrameHost_DidFocusFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::DidFocusFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::DidFocusFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame();
      return true;
    }
    case internal::kRemoteFrameHost_CheckCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::CheckCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::CheckCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_CheckCompleted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted();
      return true;
    }
    case internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfCrossProcessSubframe(
std::move(p_clip_rect), 
std::move(p_guid));
      return true;
    }
    case internal::kRemoteFrameHost_SetIsInert_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::SetIsInert",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::SetIsInert");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetIsInert_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetIsInert_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_inert{};
      RemoteFrameHost_SetIsInert_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_inert = input_data_view.inert();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsInert(
std::move(p_inert));
      return true;
    }
    case internal::kRemoteFrameHost_DidChangeOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::DidChangeOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::DidChangeOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_opener_frame{};
      RemoteFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(
std::move(p_opener_frame));
      return true;
    }
    case internal::kRemoteFrameHost_AdvanceFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::AdvanceFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::AdvanceFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_AdvanceFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_AdvanceFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FocusType p_focus_type{};
      ::base::UnguessableToken p_source_frame_token{};
      RemoteFrameHost_AdvanceFocus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocus(
std::move(p_focus_type), 
std::move(p_source_frame_token));
      return true;
    }
    case internal::kRemoteFrameHost_RouteMessageEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::RouteMessageEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::RouteMessageEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_RouteMessageEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_RouteMessageEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_source_frame_token{};
      ::WTF::String p_source_origin{};
      ::WTF::String p_target_origin{};
      ::blink::BlinkTransferableMessage p_message{};
      RemoteFrameHost_RouteMessageEvent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteMessageEvent(
std::move(p_source_frame_token), 
std::move(p_source_origin), 
std::move(p_target_origin), 
std::move(p_message));
      return true;
    }
    case internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_frame_content_rect{};
      int32_t p_document_cookie{};
      RemoteFrameHost_PrintCrossProcessSubframe_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFrameContentRect(&p_frame_content_rect))
        success = false;
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintCrossProcessSubframe(
std::move(p_frame_content_rect), 
std::move(p_document_cookie));
      return true;
    }
    case internal::kRemoteFrameHost_Detach_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrameHost::Detach",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrameHost::Detach");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrameHost_Detach_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach();
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameHostStubDispatch::AcceptWithResponder(
    RemoteFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name: {
      break;
    }
    case internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name: {
      break;
    }
    case internal::kRemoteFrameHost_VisibilityChanged_Name: {
      break;
    }
    case internal::kRemoteFrameHost_DidFocusFrame_Name: {
      break;
    }
    case internal::kRemoteFrameHost_CheckCompleted_Name: {
      break;
    }
    case internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name: {
      break;
    }
    case internal::kRemoteFrameHost_SetIsInert_Name: {
      break;
    }
    case internal::kRemoteFrameHost_DidChangeOpener_Name: {
      break;
    }
    case internal::kRemoteFrameHost_AdvanceFocus_Name: {
      break;
    }
    case internal::kRemoteFrameHost_RouteMessageEvent_Name: {
      break;
    }
    case internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name: {
      break;
    }
    case internal::kRemoteFrameHost_Detach_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteFrameHostValidationInfo[] = {
    {internal::kRemoteFrameHost_SetInheritedEffectiveTouchAction_Name,
     {&internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_UpdateRenderThrottlingStatus_Name,
     {&internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_VisibilityChanged_Name,
     {&internal::RemoteFrameHost_VisibilityChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_DidFocusFrame_Name,
     {&internal::RemoteFrameHost_DidFocusFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_CheckCompleted_Name,
     {&internal::RemoteFrameHost_CheckCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Name,
     {&internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_SetIsInert_Name,
     {&internal::RemoteFrameHost_SetIsInert_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_DidChangeOpener_Name,
     {&internal::RemoteFrameHost_DidChangeOpener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_AdvanceFocus_Name,
     {&internal::RemoteFrameHost_AdvanceFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_RouteMessageEvent_Name,
     {&internal::RemoteFrameHost_RouteMessageEvent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_PrintCrossProcessSubframe_Name,
     {&internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrameHost_Detach_Name,
     {&internal::RemoteFrameHost_Detach_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RemoteFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteFrameHostValidationInfo);
}

const char RemoteFrame::Name_[] = "blink.mojom.RemoteFrame";

RemoteFrameProxy::RemoteFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameProxy::WillEnterFullscreen(
    ::blink::mojom::blink::FullscreenOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::WillEnterFullscreen", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_WillEnterFullscreen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_WillEnterFullscreen_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in RemoteFrame.WillEnterFullscreen request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("WillEnterFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::AddReplicatedContentSecurityPolicies(
    WTF::Vector<::network::mojom::blink::ContentSecurityPolicyHeaderPtr> in_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::AddReplicatedContentSecurityPolicies", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("headers");
      for (const auto& item0 : in_headers) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_AddReplicatedContentSecurityPolicies_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_AddReplicatedContentSecurityPolicies_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyHeaderDataView>>(
      in_headers, buffer, &headers_writer, &headers_validate_params,
      &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in RemoteFrame.AddReplicatedContentSecurityPolicies request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("AddReplicatedContentSecurityPolicies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::ResetReplicatedContentSecurityPolicy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::ResetReplicatedContentSecurityPolicy");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_ResetReplicatedContentSecurityPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_ResetReplicatedContentSecurityPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ResetReplicatedContentSecurityPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::EnforceInsecureNavigationsSet(
    const WTF::Vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("set");
      for (const auto& item0 : in_set) {
        raw_value->AppendString(base::NumberToString(item0));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->set)::BaseType::BufferWriter
      set_writer;
  const mojo::internal::ContainerValidateParams set_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_set, buffer, &set_writer, &set_validate_params,
      &serialization_context);
  params->set.Set(
      set_writer.is_null() ? nullptr : set_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null set in RemoteFrame.EnforceInsecureNavigationsSet request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::blink::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetFrameOwnerProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_properties.is_null()) {
        raw_value->SetString("properties", "nullptr");
      } else {
        raw_value->BeginDictionary("properties");
        in_properties->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetFrameOwnerProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetFrameOwnerProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->properties)::BaseType::BufferWriter
      properties_writer;
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
      in_properties, buffer, &properties_writer, &serialization_context);
  params->properties.Set(
      properties_writer.is_null() ? nullptr : properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in RemoteFrame.SetFrameOwnerProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::blink::InsecureRequestPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("policy", base::trace_event::ValueToString(in_policy));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
      in_policy, &params->policy);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedOrigin(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, bool in_is_potentially_trustworthy_unique_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedOrigin", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
      raw_value->SetBoolean("is_potentially_trustworthy_unique_origin", in_is_potentially_trustworthy_unique_origin);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetReplicatedOrigin_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in RemoteFrame.SetReplicatedOrigin request");
  params->is_potentially_trustworthy_unique_origin = in_is_potentially_trustworthy_unique_origin;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedAdFrameType(
    ::blink::mojom::blink::AdFrameType in_ad_frame_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedAdFrameType", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("ad_frame_type", base::trace_event::ValueToString(in_ad_frame_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedAdFrameType_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetReplicatedAdFrameType_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::AdFrameType>(
      in_ad_frame_type, &params->ad_frame_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedAdFrameType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetReplicatedName(
    const WTF::String& in_name, const WTF::String& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetReplicatedName", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", in_name.Utf8());
      raw_value->SetString("unique_name", in_unique_name.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetReplicatedName_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetReplicatedName_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in RemoteFrame.SetReplicatedName request");
  typename decltype(params->unique_name)::BaseType::BufferWriter
      unique_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_unique_name, buffer, &unique_name_writer, &serialization_context);
  params->unique_name.Set(
      unique_name_writer.is_null() ? nullptr : unique_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unique_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unique_name in RemoteFrame.SetReplicatedName request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DispatchLoadEventForFrameOwner(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DispatchLoadEventForFrameOwner");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetNeedsOcclusionTracking", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("needs_tracking", in_needs_tracking);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetNeedsOcclusionTracking_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->needs_tracking = in_needs_tracking;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::Collapse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("collapsed", in_collapsed);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_Collapse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_Collapse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->collapsed = in_collapsed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::Focus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_Focus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_Focus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetHadStickyUserActivationBeforeNavigation(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("has_gesture", in_has_gesture);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->has_gesture = in_has_gesture;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetHadStickyUserActivationBeforeNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::BubbleLogicalScroll(
    ::blink::mojom::blink::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::BubbleLogicalScroll", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("direction", base::trace_event::ValueToString(in_direction));
      raw_value->SetInteger("granularity", static_cast<int>(in_granularity));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_BubbleLogicalScroll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_BubbleLogicalScroll_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
      in_direction, &params->direction);
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
      in_granularity, &params->granularity);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("BubbleLogicalScroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::UpdateUserActivationState(
    ::blink::mojom::blink::UserActivationUpdateType in_state_update_type, ::blink::mojom::blink::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::UpdateUserActivationState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state_update_type", base::trace_event::ValueToString(in_state_update_type));
      raw_value->SetString("notification_type", base::trace_event::ValueToString(in_notification_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_UpdateUserActivationState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_UpdateUserActivationState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
      in_state_update_type, &params->state_update_type);
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
      in_notification_type, &params->notification_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetEmbeddingToken(
    const ::base::UnguessableToken& in_embedding_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetEmbeddingToken", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("embedding_token", base::trace_event::ValueToString(in_embedding_token, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetEmbeddingToken_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetEmbeddingToken_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->embedding_token)::BaseType::BufferWriter
      embedding_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_embedding_token, buffer, &embedding_token_writer, &serialization_context);
  params->embedding_token.Set(
      embedding_token_writer.is_null() ? nullptr : embedding_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->embedding_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embedding_token in RemoteFrame.SetEmbeddingToken request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetEmbeddingToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::SetPageFocus(
    bool in_is_focused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::SetPageFocus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_focused", in_is_focused);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_SetPageFocus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_SetPageFocus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_focused = in_is_focused;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetPageFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::RenderFallbackContent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_RenderFallbackContent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_RenderFallbackContent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::AddResourceTimingFromChild(
    ::blink::mojom::blink::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::AddResourceTimingFromChild", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_timing.is_null()) {
        raw_value->SetString("timing", "nullptr");
      } else {
        raw_value->BeginDictionary("timing");
        in_timing->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_AddResourceTimingFromChild_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_AddResourceTimingFromChild_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->timing)::BaseType::BufferWriter
      timing_writer;
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
      in_timing, buffer, &timing_writer, &serialization_context);
  params->timing.Set(
      timing_writer.is_null() ? nullptr : timing_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing in RemoteFrame.AddResourceTimingFromChild request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("AddResourceTimingFromChild");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::ScrollRectToVisible(
    const ::gfx::Rect& in_rect, ::blink::mojom::blink::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::ScrollRectToVisible", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("rect", base::trace_event::ValueToString(in_rect, "<value of type const ::gfx::Rect&>"));
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_ScrollRectToVisible_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_ScrollRectToVisible_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rect)::BaseType::BufferWriter
      rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, buffer, &rect_writer, &serialization_context);
  params->rect.Set(
      rect_writer.is_null() ? nullptr : rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in RemoteFrame.ScrollRectToVisible request");
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in RemoteFrame.ScrollRectToVisible request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ScrollRectToVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidStartLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DidStartLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_DidStartLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_DidStartLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStartLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteFrame::DidStopLoading");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_DidStopLoading_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_DidStopLoading_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::IntrinsicSizingInfoOfChildChanged(
    ::blink::mojom::blink::IntrinsicSizingInfoPtr in_sizing_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_sizing_info.is_null()) {
        raw_value->SetString("sizing_info", "nullptr");
      } else {
        raw_value->BeginDictionary("sizing_info");
        in_sizing_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->sizing_info)::BaseType::BufferWriter
      sizing_info_writer;
  mojo::internal::Serialize<::blink::mojom::IntrinsicSizingInfoDataView>(
      in_sizing_info, buffer, &sizing_info_writer, &serialization_context);
  params->sizing_info.Set(
      sizing_info_writer.is_null() ? nullptr : sizing_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sizing_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sizing_info in RemoteFrame.IntrinsicSizingInfoOfChildChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("IntrinsicSizingInfoOfChildChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidSetFramePolicyHeaders(
    ::network::mojom::blink::WebSandboxFlags in_sandbox_flags, const WTF::Vector<::blink::ParsedFeaturePolicyDeclaration>& in_parsed_feature_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::DidSetFramePolicyHeaders", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("sandbox_flags", base::trace_event::ValueToString(in_sandbox_flags));
      raw_value->BeginArray("parsed_feature_policy");
      for (const auto& item0 : in_parsed_feature_policy) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::blink::ParsedFeaturePolicyDeclaration&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_DidSetFramePolicyHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      in_sandbox_flags, &params->sandbox_flags);
  typename decltype(params->parsed_feature_policy)::BaseType::BufferWriter
      parsed_feature_policy_writer;
  const mojo::internal::ContainerValidateParams parsed_feature_policy_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ParsedFeaturePolicyDeclarationDataView>>(
      in_parsed_feature_policy, buffer, &parsed_feature_policy_writer, &parsed_feature_policy_validate_params,
      &serialization_context);
  params->parsed_feature_policy.Set(
      parsed_feature_policy_writer.is_null() ? nullptr : parsed_feature_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parsed_feature_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsed_feature_policy in RemoteFrame.DidSetFramePolicyHeaders request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidSetFramePolicyHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::DidUpdateFramePolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("frame_policy", base::trace_event::ValueToString(in_frame_policy, "<value of type const ::blink::FramePolicy&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_DidUpdateFramePolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_DidUpdateFramePolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->frame_policy)::BaseType::BufferWriter
      frame_policy_writer;
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
      in_frame_policy, buffer, &frame_policy_writer, &serialization_context);
  params->frame_policy.Set(
      frame_policy_writer.is_null() ? nullptr : frame_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_policy in RemoteFrame.DidUpdateFramePolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteFrameProxy::UpdateOpener(
    const base::Optional<::base::UnguessableToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteFrame::UpdateOpener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("opener_frame_token", base::trace_event::ValueToString(in_opener_frame_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteFrame_UpdateOpener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteFrame_UpdateOpener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->opener_frame_token)::BaseType::BufferWriter
      opener_frame_token_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_opener_frame_token, buffer, &opener_frame_token_writer, &serialization_context);
  params->opener_frame_token.Set(
      opener_frame_token_writer.is_null() ? nullptr : opener_frame_token_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteFrameStubDispatch::Accept(
    RemoteFrame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRemoteFrame_WillEnterFullscreen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::WillEnterFullscreen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::WillEnterFullscreen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_WillEnterFullscreen_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_WillEnterFullscreen_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FullscreenOptionsPtr p_options{};
      RemoteFrame_WillEnterFullscreen_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WillEnterFullscreen(
std::move(p_options));
      return true;
    }
    case internal::kRemoteFrame_AddReplicatedContentSecurityPolicies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::AddReplicatedContentSecurityPolicies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::AddReplicatedContentSecurityPolicies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_AddReplicatedContentSecurityPolicies_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_AddReplicatedContentSecurityPolicies_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::network::mojom::blink::ContentSecurityPolicyHeaderPtr> p_headers{};
      RemoteFrame_AddReplicatedContentSecurityPolicies_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddReplicatedContentSecurityPolicies(
std::move(p_headers));
      return true;
    }
    case internal::kRemoteFrame_ResetReplicatedContentSecurityPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::ResetReplicatedContentSecurityPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::ResetReplicatedContentSecurityPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_ResetReplicatedContentSecurityPolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ResetReplicatedContentSecurityPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_ResetReplicatedContentSecurityPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetReplicatedContentSecurityPolicy();
      return true;
    }
    case internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<uint32_t> p_set{};
      RemoteFrame_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(
std::move(p_set));
      return true;
    }
    case internal::kRemoteFrame_SetFrameOwnerProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetFrameOwnerProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetFrameOwnerProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FrameOwnerPropertiesPtr p_properties{};
      RemoteFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(
std::move(p_properties));
      return true;
    }
    case internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::InsecureRequestPolicy p_policy{};
      RemoteFrame_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(
std::move(p_policy));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedOrigin_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedOrigin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      bool p_is_potentially_trustworthy_unique_origin{};
      RemoteFrame_SetReplicatedOrigin_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_is_potentially_trustworthy_unique_origin = input_data_view.is_potentially_trustworthy_unique_origin();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedOrigin(
std::move(p_origin), 
std::move(p_is_potentially_trustworthy_unique_origin));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedAdFrameType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedAdFrameType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedAdFrameType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedAdFrameType_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedAdFrameType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::AdFrameType p_ad_frame_type{};
      RemoteFrame_SetReplicatedAdFrameType_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAdFrameType(&p_ad_frame_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedAdFrameType(
std::move(p_ad_frame_type));
      return true;
    }
    case internal::kRemoteFrame_SetReplicatedName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetReplicatedName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetReplicatedName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedName_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_name{};
      WTF::String p_unique_name{};
      RemoteFrame_SetReplicatedName_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedName(
std::move(p_name), 
std::move(p_unique_name));
      return true;
    }
    case internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DispatchLoadEventForFrameOwner_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoadEventForFrameOwner();
      return true;
    }
    case internal::kRemoteFrame_SetNeedsOcclusionTracking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetNeedsOcclusionTracking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetNeedsOcclusionTracking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_tracking{};
      RemoteFrame_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(
std::move(p_needs_tracking));
      return true;
    }
    case internal::kRemoteFrame_Collapse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::Collapse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::Collapse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_collapsed{};
      RemoteFrame_Collapse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(
std::move(p_collapsed));
      return true;
    }
    case internal::kRemoteFrame_Focus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::Focus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::Focus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Focus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_Focus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus();
      return true;
    }
    case internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_has_gesture{};
      RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadStickyUserActivationBeforeNavigation(
std::move(p_has_gesture));
      return true;
    }
    case internal::kRemoteFrame_BubbleLogicalScroll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::BubbleLogicalScroll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::BubbleLogicalScroll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_BubbleLogicalScroll_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_BubbleLogicalScroll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      RemoteFrame_BubbleLogicalScroll_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScroll(
std::move(p_direction), 
std::move(p_granularity));
      return true;
    }
    case internal::kRemoteFrame_UpdateUserActivationState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::UpdateUserActivationState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::UpdateUserActivationState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::UserActivationUpdateType p_state_update_type{};
      ::blink::mojom::blink::UserActivationNotificationType p_notification_type{};
      RemoteFrame_UpdateUserActivationState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStateUpdateType(&p_state_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(
std::move(p_state_update_type), 
std::move(p_notification_type));
      return true;
    }
    case internal::kRemoteFrame_SetEmbeddingToken_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetEmbeddingToken",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetEmbeddingToken");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetEmbeddingToken_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetEmbeddingToken_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_embedding_token{};
      RemoteFrame_SetEmbeddingToken_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadEmbeddingToken(&p_embedding_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEmbeddingToken(
std::move(p_embedding_token));
      return true;
    }
    case internal::kRemoteFrame_SetPageFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::SetPageFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::SetPageFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetPageFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetPageFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_focused{};
      RemoteFrame_SetPageFocus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_focused = input_data_view.is_focused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageFocus(
std::move(p_is_focused));
      return true;
    }
    case internal::kRemoteFrame_RenderFallbackContent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::RenderFallbackContent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::RenderFallbackContent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_RenderFallbackContent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent();
      return true;
    }
    case internal::kRemoteFrame_AddResourceTimingFromChild_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::AddResourceTimingFromChild",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::AddResourceTimingFromChild");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_AddResourceTimingFromChild_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_AddResourceTimingFromChild_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::ResourceTimingInfoPtr p_timing{};
      RemoteFrame_AddResourceTimingFromChild_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddResourceTimingFromChild(
std::move(p_timing));
      return true;
    }
    case internal::kRemoteFrame_ScrollRectToVisible_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::ScrollRectToVisible",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::ScrollRectToVisible");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_ScrollRectToVisible_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ScrollRectToVisible_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect{};
      ::blink::mojom::blink::ScrollIntoViewParamsPtr p_params{};
      RemoteFrame_ScrollRectToVisible_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisible(
std::move(p_rect), 
std::move(p_params));
      return true;
    }
    case internal::kRemoteFrame_DidStartLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidStartLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidStartLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStartLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStartLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DidStartLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartLoading();
      return true;
    }
    case internal::kRemoteFrame_DidStopLoading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidStopLoading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidStopLoading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteFrame_DidStopLoading_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading();
      return true;
    }
    case internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::IntrinsicSizingInfoPtr p_sizing_info{};
      RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSizingInfo(&p_sizing_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntrinsicSizingInfoOfChildChanged(
std::move(p_sizing_info));
      return true;
    }
    case internal::kRemoteFrame_DidSetFramePolicyHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidSetFramePolicyHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidSetFramePolicyHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::WebSandboxFlags p_sandbox_flags{};
      WTF::Vector<::blink::ParsedFeaturePolicyDeclaration> p_parsed_feature_policy{};
      RemoteFrame_DidSetFramePolicyHeaders_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSandboxFlags(&p_sandbox_flags))
        success = false;
      if (success && !input_data_view.ReadParsedFeaturePolicy(&p_parsed_feature_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidSetFramePolicyHeaders(
std::move(p_sandbox_flags), 
std::move(p_parsed_feature_policy));
      return true;
    }
    case internal::kRemoteFrame_DidUpdateFramePolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::DidUpdateFramePolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::DidUpdateFramePolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      RemoteFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(
std::move(p_frame_policy));
      return true;
    }
    case internal::kRemoteFrame_UpdateOpener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteFrame::UpdateOpener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteFrame::UpdateOpener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_opener_frame_token{};
      RemoteFrame_UpdateOpener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(
std::move(p_opener_frame_token));
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameStubDispatch::AcceptWithResponder(
    RemoteFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteFrame_WillEnterFullscreen_Name: {
      break;
    }
    case internal::kRemoteFrame_AddReplicatedContentSecurityPolicies_Name: {
      break;
    }
    case internal::kRemoteFrame_ResetReplicatedContentSecurityPolicy_Name: {
      break;
    }
    case internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name: {
      break;
    }
    case internal::kRemoteFrame_SetFrameOwnerProperties_Name: {
      break;
    }
    case internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedOrigin_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedAdFrameType_Name: {
      break;
    }
    case internal::kRemoteFrame_SetReplicatedName_Name: {
      break;
    }
    case internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name: {
      break;
    }
    case internal::kRemoteFrame_SetNeedsOcclusionTracking_Name: {
      break;
    }
    case internal::kRemoteFrame_Collapse_Name: {
      break;
    }
    case internal::kRemoteFrame_Focus_Name: {
      break;
    }
    case internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name: {
      break;
    }
    case internal::kRemoteFrame_BubbleLogicalScroll_Name: {
      break;
    }
    case internal::kRemoteFrame_UpdateUserActivationState_Name: {
      break;
    }
    case internal::kRemoteFrame_SetEmbeddingToken_Name: {
      break;
    }
    case internal::kRemoteFrame_SetPageFocus_Name: {
      break;
    }
    case internal::kRemoteFrame_RenderFallbackContent_Name: {
      break;
    }
    case internal::kRemoteFrame_AddResourceTimingFromChild_Name: {
      break;
    }
    case internal::kRemoteFrame_ScrollRectToVisible_Name: {
      break;
    }
    case internal::kRemoteFrame_DidStartLoading_Name: {
      break;
    }
    case internal::kRemoteFrame_DidStopLoading_Name: {
      break;
    }
    case internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name: {
      break;
    }
    case internal::kRemoteFrame_DidSetFramePolicyHeaders_Name: {
      break;
    }
    case internal::kRemoteFrame_DidUpdateFramePolicy_Name: {
      break;
    }
    case internal::kRemoteFrame_UpdateOpener_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteFrameValidationInfo[] = {
    {internal::kRemoteFrame_WillEnterFullscreen_Name,
     {&internal::RemoteFrame_WillEnterFullscreen_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_AddReplicatedContentSecurityPolicies_Name,
     {&internal::RemoteFrame_AddReplicatedContentSecurityPolicies_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_ResetReplicatedContentSecurityPolicy_Name,
     {&internal::RemoteFrame_ResetReplicatedContentSecurityPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_EnforceInsecureNavigationsSet_Name,
     {&internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetFrameOwnerProperties_Name,
     {&internal::RemoteFrame_SetFrameOwnerProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_EnforceInsecureRequestPolicy_Name,
     {&internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedOrigin_Name,
     {&internal::RemoteFrame_SetReplicatedOrigin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedAdFrameType_Name,
     {&internal::RemoteFrame_SetReplicatedAdFrameType_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetReplicatedName_Name,
     {&internal::RemoteFrame_SetReplicatedName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DispatchLoadEventForFrameOwner_Name,
     {&internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetNeedsOcclusionTracking_Name,
     {&internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_Collapse_Name,
     {&internal::RemoteFrame_Collapse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_Focus_Name,
     {&internal::RemoteFrame_Focus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetHadStickyUserActivationBeforeNavigation_Name,
     {&internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_BubbleLogicalScroll_Name,
     {&internal::RemoteFrame_BubbleLogicalScroll_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_UpdateUserActivationState_Name,
     {&internal::RemoteFrame_UpdateUserActivationState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetEmbeddingToken_Name,
     {&internal::RemoteFrame_SetEmbeddingToken_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_SetPageFocus_Name,
     {&internal::RemoteFrame_SetPageFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_RenderFallbackContent_Name,
     {&internal::RemoteFrame_RenderFallbackContent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_AddResourceTimingFromChild_Name,
     {&internal::RemoteFrame_AddResourceTimingFromChild_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_ScrollRectToVisible_Name,
     {&internal::RemoteFrame_ScrollRectToVisible_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidStartLoading_Name,
     {&internal::RemoteFrame_DidStartLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidStopLoading_Name,
     {&internal::RemoteFrame_DidStopLoading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_IntrinsicSizingInfoOfChildChanged_Name,
     {&internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidSetFramePolicyHeaders_Name,
     {&internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_DidUpdateFramePolicy_Name,
     {&internal::RemoteFrame_DidUpdateFramePolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteFrame_UpdateOpener_Name,
     {&internal::RemoteFrame_UpdateOpener_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RemoteFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteFrameValidationInfo);
}

const char LocalMainFrame::Name_[] = "blink.mojom.LocalMainFrame";

class LocalMainFrame_ClosePage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_ClosePage_ForwardToCallback(
      LocalMainFrame::ClosePageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::ClosePageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_ClosePage_ForwardToCallback);
};

class LocalMainFrame_OnPortalActivated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrame_OnPortalActivated_ForwardToCallback(
      LocalMainFrame::OnPortalActivatedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrame::OnPortalActivatedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_OnPortalActivated_ForwardToCallback);
};

LocalMainFrameProxy::LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalMainFrameProxy::AnimateDoubleTapZoom(
    const ::gfx::Point& in_point, const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::AnimateDoubleTapZoom", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("point", base::trace_event::ValueToString(in_point, "<value of type const ::gfx::Point&>"));
      raw_value->SetString("rect", base::trace_event::ValueToString(in_rect, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_AnimateDoubleTapZoom_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->point)::BaseType::BufferWriter
      point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_point, buffer, &point_writer, &serialization_context);
  params->point.Set(
      point_writer.is_null() ? nullptr : point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point in LocalMainFrame.AnimateDoubleTapZoom request");
  typename decltype(params->rect)::BaseType::BufferWriter
      rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect, buffer, &rect_writer, &serialization_context);
  params->rect.Set(
      rect_writer.is_null() ? nullptr : rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in LocalMainFrame.AnimateDoubleTapZoom request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("AnimateDoubleTapZoom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::SetScaleFactor(
    float in_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::SetScaleFactor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("scale", in_scale);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_SetScaleFactor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_SetScaleFactor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->scale = in_scale;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetScaleFactor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::ClosePage(
    ClosePageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrame::ClosePage");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_ClosePage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_ClosePage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_ClosePage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameProxy::PluginActionAt(
    const ::gfx::Point& in_location, PluginActionType in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::PluginActionAt", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("location", base::trace_event::ValueToString(in_location, "<value of type const ::gfx::Point&>"));
      raw_value->SetString("action", base::trace_event::ValueToString(in_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_PluginActionAt_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_PluginActionAt_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->location)::BaseType::BufferWriter
      location_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location, buffer, &location_writer, &serialization_context);
  params->location.Set(
      location_writer.is_null() ? nullptr : location_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in LocalMainFrame.PluginActionAt request");
  mojo::internal::Serialize<::blink::mojom::PluginActionType>(
      in_action, &params->action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("PluginActionAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::SetInitialFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::SetInitialFocus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("reverse", in_reverse);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_SetInitialFocus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_SetInitialFocus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->reverse = in_reverse;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("SetInitialFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::EnablePreferredSizeChangedMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("EnablePreferredSizeChangedMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::ZoomToFindInPageRect(
    const ::gfx::Rect& in_rect_in_root_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::ZoomToFindInPageRect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("rect_in_root_frame", base::trace_event::ValueToString(in_rect_in_root_frame, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_ZoomToFindInPageRect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rect_in_root_frame)::BaseType::BufferWriter
      rect_in_root_frame_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_in_root_frame, buffer, &rect_in_root_frame_writer, &serialization_context);
  params->rect_in_root_frame.Set(
      rect_in_root_frame_writer.is_null() ? nullptr : rect_in_root_frame_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_in_root_frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_in_root_frame in LocalMainFrame.ZoomToFindInPageRect request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ZoomToFindInPageRect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::InstallCoopAccessMonitor(
    ::network::mojom::blink::CoopAccessReportType in_report_type, const ::base::UnguessableToken& in_accessed_window, ::mojo::PendingRemote<::network::mojom::blink::CrossOriginOpenerPolicyReporter> in_reporter, bool in_endpoint_defined, const WTF::String& in_reported_window_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::InstallCoopAccessMonitor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("report_type", base::trace_event::ValueToString(in_report_type));
      raw_value->SetString("accessed_window", base::trace_event::ValueToString(in_accessed_window, "<value of type const ::base::UnguessableToken&>"));
      raw_value->SetBoolean("reporter", in_reporter.is_valid());
      raw_value->SetBoolean("endpoint_defined", in_endpoint_defined);
      raw_value->SetString("reported_window_url", in_reported_window_url.Utf8());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_InstallCoopAccessMonitor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
      in_report_type, &params->report_type);
  typename decltype(params->accessed_window)::BaseType::BufferWriter
      accessed_window_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_accessed_window, buffer, &accessed_window_writer, &serialization_context);
  params->accessed_window.Set(
      accessed_window_writer.is_null() ? nullptr : accessed_window_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accessed_window.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accessed_window in LocalMainFrame.InstallCoopAccessMonitor request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginOpenerPolicyReporterInterfaceBase>>(
      in_reporter, &params->reporter, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->reporter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reporter in LocalMainFrame.InstallCoopAccessMonitor request");
  params->endpoint_defined = in_endpoint_defined;
  typename decltype(params->reported_window_url)::BaseType::BufferWriter
      reported_window_url_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reported_window_url, buffer, &reported_window_url_writer, &serialization_context);
  params->reported_window_url.Set(
      reported_window_url_writer.is_null() ? nullptr : reported_window_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reported_window_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reported_window_url in LocalMainFrame.InstallCoopAccessMonitor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("InstallCoopAccessMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameProxy::OnPortalActivated(
    const ::blink::PortalToken& in_portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::Portal> in_portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::PortalClient> in_portal_client, ::blink::BlinkTransferableMessage in_data, OnPortalActivatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::OnPortalActivated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("portal_token", base::trace_event::ValueToString(in_portal_token, "<value of type const ::blink::PortalToken&>"));
      raw_value->SetBoolean("portal", in_portal.is_valid());
      raw_value->SetBoolean("portal_client", in_portal_client.is_valid());
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_OnPortalActivated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_OnPortalActivated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->portal_token)::BaseType::BufferWriter
      portal_token_writer;
  mojo::internal::Serialize<::blink::mojom::PortalTokenDataView>(
      in_portal_token, buffer, &portal_token_writer, &serialization_context);
  params->portal_token.Set(
      portal_token_writer.is_null() ? nullptr : portal_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->portal_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null portal_token in LocalMainFrame.OnPortalActivated request");
  mojo::internal::Serialize<::blink::mojom::PortalAssociatedPtrInfoDataView>(
      in_portal, &params->portal, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal in LocalMainFrame.OnPortalActivated request");
  mojo::internal::Serialize<::blink::mojom::PortalClientAssociatedRequestDataView>(
      in_portal_client, &params->portal_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->portal_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid portal_client in LocalMainFrame.OnPortalActivated request");
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in LocalMainFrame.OnPortalActivated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("OnPortalActivated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrame_OnPortalActivated_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void LocalMainFrameProxy::ForwardMessageFromHost(
    ::blink::BlinkTransferableMessage in_message, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_source_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrame::ForwardMessageFromHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      raw_value->SetString("source_origin", base::trace_event::ValueToString(in_source_origin, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_ForwardMessageFromHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_ForwardMessageFromHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in LocalMainFrame.ForwardMessageFromHost request");
  typename decltype(params->source_origin)::BaseType::BufferWriter
      source_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_source_origin, buffer, &source_origin_writer, &serialization_context);
  params->source_origin.Set(
      source_origin_writer.is_null() ? nullptr : source_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in LocalMainFrame.ForwardMessageFromHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ForwardMessageFromHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class LocalMainFrame_ClosePage_ProxyToResponder {
 public:
  static LocalMainFrame::ClosePageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrame_ClosePage_ProxyToResponder> proxy(
        new LocalMainFrame_ClosePage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrame_ClosePage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_ClosePage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrame_ClosePage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrame::ClosePageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_ClosePage_ProxyToResponder);
};

bool LocalMainFrame_ClosePage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrame::ClosePageCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalMainFrame_ClosePage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_ClosePage_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  LocalMainFrame_ClosePage_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrame_ClosePage_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrame::ClosePageCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_ClosePage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_ClosePage_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrame::ClosePageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("ClosePage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalMainFrame_OnPortalActivated_ProxyToResponder {
 public:
  static LocalMainFrame::OnPortalActivatedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrame_OnPortalActivated_ProxyToResponder> proxy(
        new LocalMainFrame_OnPortalActivated_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrame_OnPortalActivated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrame_OnPortalActivated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrame_OnPortalActivated_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrame::OnPortalActivatedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PortalActivateResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrame_OnPortalActivated_ProxyToResponder);
};

bool LocalMainFrame_OnPortalActivated_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrame::OnPortalActivatedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::PortalActivateResult p_result{};
  LocalMainFrame_OnPortalActivated_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrame::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void LocalMainFrame_OnPortalActivated_ProxyToResponder::Run(
    ::blink::mojom::blink::PortalActivateResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::LocalMainFrame::OnPortalActivatedCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrame_OnPortalActivated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PortalActivateResult>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrame::OnPortalActivatedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrame::Name_);
  message.set_method_name("OnPortalActivated");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalMainFrameStubDispatch::Accept(
    LocalMainFrame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kLocalMainFrame_AnimateDoubleTapZoom_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::AnimateDoubleTapZoom",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::AnimateDoubleTapZoom");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_point{};
      ::gfx::Rect p_rect{};
      LocalMainFrame_AnimateDoubleTapZoom_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnimateDoubleTapZoom(
std::move(p_point), 
std::move(p_rect));
      return true;
    }
    case internal::kLocalMainFrame_SetScaleFactor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::SetScaleFactor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::SetScaleFactor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetScaleFactor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetScaleFactor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      float p_scale{};
      LocalMainFrame_SetScaleFactor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_scale = input_data_view.scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScaleFactor(
std::move(p_scale));
      return true;
    }
    case internal::kLocalMainFrame_ClosePage_Name: {
      break;
    }
    case internal::kLocalMainFrame_PluginActionAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::PluginActionAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::PluginActionAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_PluginActionAt_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_PluginActionAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_location{};
      PluginActionType p_action{};
      LocalMainFrame_PluginActionAt_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PluginActionAt(
std::move(p_location), 
std::move(p_action));
      return true;
    }
    case internal::kLocalMainFrame_SetInitialFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::SetInitialFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::SetInitialFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_SetInitialFocus_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_SetInitialFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_reverse{};
      LocalMainFrame_SetInitialFocus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInitialFocus(
std::move(p_reverse));
      return true;
    }
    case internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::EnablePreferredSizeChangedMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrame_EnablePreferredSizeChangedMode_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnablePreferredSizeChangedMode();
      return true;
    }
    case internal::kLocalMainFrame_ZoomToFindInPageRect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ZoomToFindInPageRect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ZoomToFindInPageRect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect_in_root_frame{};
      LocalMainFrame_ZoomToFindInPageRect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRectInRootFrame(&p_rect_in_root_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomToFindInPageRect(
std::move(p_rect_in_root_frame));
      return true;
    }
    case internal::kLocalMainFrame_InstallCoopAccessMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::InstallCoopAccessMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::InstallCoopAccessMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::CoopAccessReportType p_report_type{};
      ::base::UnguessableToken p_accessed_window{};
      ::mojo::PendingRemote<::network::mojom::blink::CrossOriginOpenerPolicyReporter> p_reporter{};
      bool p_endpoint_defined{};
      WTF::String p_reported_window_url{};
      LocalMainFrame_InstallCoopAccessMonitor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadReportType(&p_report_type))
        success = false;
      if (success && !input_data_view.ReadAccessedWindow(&p_accessed_window))
        success = false;
      if (success) {
        p_reporter =
            input_data_view.TakeReporter<decltype(p_reporter)>();
      }
      if (success)
        p_endpoint_defined = input_data_view.endpoint_defined();
      if (success && !input_data_view.ReadReportedWindowUrl(&p_reported_window_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallCoopAccessMonitor(
std::move(p_report_type), 
std::move(p_accessed_window), 
std::move(p_reporter), 
std::move(p_endpoint_defined), 
std::move(p_reported_window_url));
      return true;
    }
    case internal::kLocalMainFrame_OnPortalActivated_Name: {
      break;
    }
    case internal::kLocalMainFrame_ForwardMessageFromHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ForwardMessageFromHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ForwardMessageFromHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrame_ForwardMessageFromHost_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrame_ForwardMessageFromHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_message{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_source_origin{};
      LocalMainFrame_ForwardMessageFromHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardMessageFromHost(
std::move(p_message), 
std::move(p_source_origin));
      return true;
    }
  }
  return false;
}

// static
bool LocalMainFrameStubDispatch::AcceptWithResponder(
    LocalMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalMainFrame_AnimateDoubleTapZoom_Name: {
      break;
    }
    case internal::kLocalMainFrame_SetScaleFactor_Name: {
      break;
    }
    case internal::kLocalMainFrame_ClosePage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::ClosePage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::ClosePage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrame_ClosePage_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_ClosePage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      LocalMainFrame_ClosePage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 2, false);
        return false;
      }
      LocalMainFrame::ClosePageCallback callback =
          LocalMainFrame_ClosePage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePage(std::move(callback));
      return true;
    }
    case internal::kLocalMainFrame_PluginActionAt_Name: {
      break;
    }
    case internal::kLocalMainFrame_SetInitialFocus_Name: {
      break;
    }
    case internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name: {
      break;
    }
    case internal::kLocalMainFrame_ZoomToFindInPageRect_Name: {
      break;
    }
    case internal::kLocalMainFrame_InstallCoopAccessMonitor_Name: {
      break;
    }
    case internal::kLocalMainFrame_OnPortalActivated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrame::OnPortalActivated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrame::OnPortalActivated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrame_OnPortalActivated_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrame_OnPortalActivated_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::PortalToken p_portal_token{};
      ::mojo::PendingAssociatedRemote<::blink::mojom::blink::Portal> p_portal{};
      ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::PortalClient> p_portal_client{};
      ::blink::BlinkTransferableMessage p_data{};
      LocalMainFrame_OnPortalActivated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPortalToken(&p_portal_token))
        success = false;
      if (success) {
        p_portal =
            input_data_view.TakePortal<decltype(p_portal)>();
      }
      if (success) {
        p_portal_client =
            input_data_view.TakePortalClient<decltype(p_portal_client)>();
      }
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrame::Name_, 8, false);
        return false;
      }
      LocalMainFrame::OnPortalActivatedCallback callback =
          LocalMainFrame_OnPortalActivated_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortalActivated(
std::move(p_portal_token), 
std::move(p_portal), 
std::move(p_portal_client), 
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kLocalMainFrame_ForwardMessageFromHost_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalMainFrameValidationInfo[] = {
    {internal::kLocalMainFrame_AnimateDoubleTapZoom_Name,
     {&internal::LocalMainFrame_AnimateDoubleTapZoom_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_SetScaleFactor_Name,
     {&internal::LocalMainFrame_SetScaleFactor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_ClosePage_Name,
     {&internal::LocalMainFrame_ClosePage_Params_Data::Validate,
      &internal::LocalMainFrame_ClosePage_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrame_PluginActionAt_Name,
     {&internal::LocalMainFrame_PluginActionAt_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_SetInitialFocus_Name,
     {&internal::LocalMainFrame_SetInitialFocus_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_EnablePreferredSizeChangedMode_Name,
     {&internal::LocalMainFrame_EnablePreferredSizeChangedMode_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_ZoomToFindInPageRect_Name,
     {&internal::LocalMainFrame_ZoomToFindInPageRect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_InstallCoopAccessMonitor_Name,
     {&internal::LocalMainFrame_InstallCoopAccessMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrame_OnPortalActivated_Name,
     {&internal::LocalMainFrame_OnPortalActivated_Params_Data::Validate,
      &internal::LocalMainFrame_OnPortalActivated_ResponseParams_Data::Validate}},
    {internal::kLocalMainFrame_ForwardMessageFromHost_Name,
     {&internal::LocalMainFrame_ForwardMessageFromHost_Params_Data::Validate,
      nullptr /* no response */}},
};

bool LocalMainFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalMainFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalMainFrameValidationInfo);
}

bool LocalMainFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalMainFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalMainFrameValidationInfo);

}
const char RemoteMainFrame::Name_[] = "blink.mojom.RemoteMainFrame";

RemoteMainFrameProxy::RemoteMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameProxy::UpdateTextAutosizerPageInfo(
    TextAutosizerPageInfoPtr in_page_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_page_info.is_null()) {
        raw_value->SetString("page_info", "nullptr");
      } else {
        raw_value->BeginDictionary("page_info");
        in_page_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->page_info)::BaseType::BufferWriter
      page_info_writer;
  mojo::internal::Serialize<::blink::mojom::TextAutosizerPageInfoDataView>(
      in_page_info, buffer, &page_info_writer, &serialization_context);
  params->page_info.Set(
      page_info_writer.is_null() ? nullptr : page_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_info in RemoteMainFrame.UpdateTextAutosizerPageInfo request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrame::Name_);
  message.set_method_name("UpdateTextAutosizerPageInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool RemoteMainFrameStubDispatch::Accept(
    RemoteMainFrame* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TextAutosizerPageInfoPtr p_page_info{};
      RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPageInfo(&p_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTextAutosizerPageInfo(
std::move(p_page_info));
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameStubDispatch::AcceptWithResponder(
    RemoteMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteMainFrameValidationInfo[] = {
    {internal::kRemoteMainFrame_UpdateTextAutosizerPageInfo_Name,
     {&internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteMainFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RemoteMainFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteMainFrameValidationInfo);
}

const char LocalMainFrameHost::Name_[] = "blink.mojom.LocalMainFrameHost";

class LocalMainFrameHost_UpdateTargetURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalMainFrameHost_UpdateTargetURL_ForwardToCallback(
      LocalMainFrameHost::UpdateTargetURLCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  LocalMainFrameHost::UpdateTargetURLCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_UpdateTargetURL_ForwardToCallback);
};

LocalMainFrameHostProxy::LocalMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalMainFrameHostProxy::ScaleFactorChanged(
    float in_scale) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::ScaleFactorChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("scale", in_scale);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ScaleFactorChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->scale = in_scale;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ScaleFactorChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::ContentsPreferredSizeChanged(
    const ::gfx::Size& in_pref_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("pref_size", base::trace_event::ValueToString(in_pref_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->pref_size)::BaseType::BufferWriter
      pref_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_pref_size, buffer, &pref_size_writer, &serialization_context);
  params->pref_size.Set(
      pref_size_writer.is_null() ? nullptr : pref_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pref_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pref_size in LocalMainFrameHost.ContentsPreferredSizeChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("ContentsPreferredSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::TextAutosizerPageInfoChanged(
    TextAutosizerPageInfoPtr in_page_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_page_info.is_null()) {
        raw_value->SetString("page_info", "nullptr");
      } else {
        raw_value->BeginDictionary("page_info");
        in_page_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->page_info)::BaseType::BufferWriter
      page_info_writer;
  mojo::internal::Serialize<::blink::mojom::TextAutosizerPageInfoDataView>(
      in_page_info, buffer, &page_info_writer, &serialization_context);
  params->page_info.Set(
      page_info_writer.is_null() ? nullptr : page_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->page_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_info in LocalMainFrameHost.TextAutosizerPageInfoChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("TextAutosizerPageInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::FocusPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::LocalMainFrameHost::FocusPage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_FocusPage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_FocusPage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("FocusPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void LocalMainFrameHostProxy::UpdateTargetURL(
    const ::blink::KURL& in_url, UpdateTargetURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::LocalMainFrameHost::UpdateTargetURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_UpdateTargetURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in LocalMainFrameHost.UpdateTargetURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalMainFrameHost_UpdateTargetURL_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class LocalMainFrameHost_UpdateTargetURL_ProxyToResponder {
 public:
  static LocalMainFrameHost::UpdateTargetURLCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<LocalMainFrameHost_UpdateTargetURL_ProxyToResponder> proxy(
        new LocalMainFrameHost_UpdateTargetURL_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalMainFrameHost_UpdateTargetURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  LocalMainFrameHost_UpdateTargetURL_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LocalMainFrameHost::UpdateTargetURLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(LocalMainFrameHost_UpdateTargetURL_ProxyToResponder);
};

bool LocalMainFrameHost_UpdateTargetURL_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  LocalMainFrameHost_UpdateTargetURL_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalMainFrameHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kLocalMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURLCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalMainFrameHostStubDispatch::Accept(
    LocalMainFrameHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kLocalMainFrameHost_ScaleFactorChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::ScaleFactorChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::ScaleFactorChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      float p_scale{};
      LocalMainFrameHost_ScaleFactorChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_scale = input_data_view.scale();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScaleFactorChanged(
std::move(p_scale));
      return true;
    }
    case internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::ContentsPreferredSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_pref_size{};
      LocalMainFrameHost_ContentsPreferredSizeChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPrefSize(&p_pref_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContentsPreferredSizeChanged(
std::move(p_pref_size));
      return true;
    }
    case internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::TextAutosizerPageInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      TextAutosizerPageInfoPtr p_page_info{};
      LocalMainFrameHost_TextAutosizerPageInfoChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPageInfo(&p_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextAutosizerPageInfoChanged(
std::move(p_page_info));
      return true;
    }
    case internal::kLocalMainFrameHost_FocusPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::FocusPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::FocusPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::LocalMainFrameHost_FocusPage_Params_Data* params =
          reinterpret_cast<internal::LocalMainFrameHost_FocusPage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      LocalMainFrameHost_FocusPage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusPage();
      return true;
    }
    case internal::kLocalMainFrameHost_UpdateTargetURL_Name: {
      break;
    }
  }
  return false;
}

// static
bool LocalMainFrameHostStubDispatch::AcceptWithResponder(
    LocalMainFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kLocalMainFrameHost_ScaleFactorChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_FocusPage_Name: {
      break;
    }
    case internal::kLocalMainFrameHost_UpdateTargetURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::LocalMainFrameHost::UpdateTargetURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::LocalMainFrameHost_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<
              internal::LocalMainFrameHost_UpdateTargetURL_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      LocalMainFrameHost_UpdateTargetURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalMainFrameHost::Name_, 4, false);
        return false;
      }
      LocalMainFrameHost::UpdateTargetURLCallback callback =
          LocalMainFrameHost_UpdateTargetURL_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(
std::move(p_url), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLocalMainFrameHostValidationInfo[] = {
    {internal::kLocalMainFrameHost_ScaleFactorChanged_Name,
     {&internal::LocalMainFrameHost_ScaleFactorChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_ContentsPreferredSizeChanged_Name,
     {&internal::LocalMainFrameHost_ContentsPreferredSizeChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_TextAutosizerPageInfoChanged_Name,
     {&internal::LocalMainFrameHost_TextAutosizerPageInfoChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_FocusPage_Name,
     {&internal::LocalMainFrameHost_FocusPage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kLocalMainFrameHost_UpdateTargetURL_Name,
     {&internal::LocalMainFrameHost_UpdateTargetURL_Params_Data::Validate,
      &internal::LocalMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate}},
};

bool LocalMainFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalMainFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLocalMainFrameHostValidationInfo);
}

bool LocalMainFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::LocalMainFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLocalMainFrameHostValidationInfo);

}
const char RemoteMainFrameHost::Name_[] = "blink.mojom.RemoteMainFrameHost";

class RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
      RemoteMainFrameHost::UpdateTargetURLCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RemoteMainFrameHost::UpdateTargetURLCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback);
};

RemoteMainFrameHostProxy::RemoteMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameHostProxy::FocusPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteMainFrameHost::FocusPage");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_FocusPage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteMainFrameHost_FocusPage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("FocusPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void RemoteMainFrameHostProxy::UpdateTargetURL(
    const ::blink::KURL& in_url, UpdateTargetURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::RemoteMainFrameHost::UpdateTargetURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RemoteMainFrameHost.UpdateTargetURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RemoteMainFrameHostProxy::RouteCloseEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::RemoteMainFrameHost::RouteCloseEvent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_RouteCloseEvent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("RouteCloseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder {
 public:
  static RemoteMainFrameHost::UpdateTargetURLCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder> proxy(
        new RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RemoteMainFrameHost::UpdateTargetURLCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder);
};

bool RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  RemoteMainFrameHost_UpdateTargetURL_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RemoteMainFrameHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRemoteMainFrameHost_UpdateTargetURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURLCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemoteMainFrameHostStubDispatch::Accept(
    RemoteMainFrameHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRemoteMainFrameHost_FocusPage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::FocusPage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::FocusPage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_FocusPage_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_FocusPage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteMainFrameHost_FocusPage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusPage();
      return true;
    }
    case internal::kRemoteMainFrameHost_UpdateTargetURL_Name: {
      break;
    }
    case internal::kRemoteMainFrameHost_RouteCloseEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::RouteCloseEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::RouteCloseEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RemoteMainFrameHost_RouteCloseEvent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteCloseEvent();
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameHostStubDispatch::AcceptWithResponder(
    RemoteMainFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRemoteMainFrameHost_FocusPage_Name: {
      break;
    }
    case internal::kRemoteMainFrameHost_UpdateTargetURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::RemoteMainFrameHost::UpdateTargetURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<
              internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      RemoteMainFrameHost_UpdateTargetURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 1, false);
        return false;
      }
      RemoteMainFrameHost::UpdateTargetURLCallback callback =
          RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(
std::move(p_url), std::move(callback));
      return true;
    }
    case internal::kRemoteMainFrameHost_RouteCloseEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRemoteMainFrameHostValidationInfo[] = {
    {internal::kRemoteMainFrameHost_FocusPage_Name,
     {&internal::RemoteMainFrameHost_FocusPage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kRemoteMainFrameHost_UpdateTargetURL_Name,
     {&internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data::Validate,
      &internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate}},
    {internal::kRemoteMainFrameHost_RouteCloseEvent_Name,
     {&internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool RemoteMainFrameHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RemoteMainFrameHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRemoteMainFrameHostValidationInfo);
}

bool RemoteMainFrameHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::RemoteMainFrameHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRemoteMainFrameHostValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SavableSubframe::DataView, ::blink::mojom::blink::SavableSubframePtr>::Read(
    ::blink::mojom::blink::SavableSubframe::DataView input,
    ::blink::mojom::blink::SavableSubframePtr* output) {
  bool success = true;
  ::blink::mojom::blink::SavableSubframePtr result(::blink::mojom::blink::SavableSubframe::New());
  
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadSubframeToken(&result->subframe_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::GetSavableResourceLinksReply::DataView, ::blink::mojom::blink::GetSavableResourceLinksReplyPtr>::Read(
    ::blink::mojom::blink::GetSavableResourceLinksReply::DataView input,
    ::blink::mojom::blink::GetSavableResourceLinksReplyPtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetSavableResourceLinksReplyPtr result(::blink::mojom::blink::GetSavableResourceLinksReply::New());
  
      if (success && !input.ReadResourcesList(&result->resources_list))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadSubframes(&result->subframes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FindInPageResultAXParams::DataView, ::blink::mojom::blink::FindInPageResultAXParamsPtr>::Read(
    ::blink::mojom::blink::FindInPageResultAXParams::DataView input,
    ::blink::mojom::blink::FindInPageResultAXParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FindInPageResultAXParamsPtr result(::blink::mojom::blink::FindInPageResultAXParams::New());
  
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->match_index = input.match_index();
      if (success)
        result->start_id = input.start_id();
      if (success)
        result->start_offset = input.start_offset();
      if (success)
        result->end_id = input.end_id();
      if (success)
        result->end_offset = input.end_offset();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DownloadURLParams::DataView, ::blink::mojom::blink::DownloadURLParamsPtr>::Read(
    ::blink::mojom::blink::DownloadURLParams::DataView input,
    ::blink::mojom::blink::DownloadURLParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DownloadURLParamsPtr result(::blink::mojom::blink::DownloadURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadSuggestedName(&result->suggested_name))
        success = false;
      if (success && !input.ReadCrossOriginRedirects(&result->cross_origin_redirects))
        success = false;
      if (success) {
        result->blob_url_token =
            input.TakeBlobUrlToken<decltype(result->blob_url_token)>();
      }
      if (success) {
        result->data_url_blob =
            input.TakeDataUrlBlob<decltype(result->data_url_blob)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TextAutosizerPageInfo::DataView, ::blink::mojom::blink::TextAutosizerPageInfoPtr>::Read(
    ::blink::mojom::blink::TextAutosizerPageInfo::DataView input,
    ::blink::mojom::blink::TextAutosizerPageInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TextAutosizerPageInfoPtr result(::blink::mojom::blink::TextAutosizerPageInfo::New());
  
      if (success)
        result->main_frame_width = input.main_frame_width();
      if (success)
        result->main_frame_layout_width = input.main_frame_layout_width();
      if (success)
        result->device_scale_adjustment = input.device_scale_adjustment();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif