// services/network/public/mojom/restricted_cookie_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/restricted_cookie_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-params-data.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
CookieManagerGetOptions::CookieManagerGetOptions()
    : name(),
      match_type() {}

CookieManagerGetOptions::CookieManagerGetOptions(
    const std::string& name_in,
    CookieMatchType match_type_in)
    : name(std::move(name_in)),
      match_type(std::move(match_type_in)) {}

CookieManagerGetOptions::~CookieManagerGetOptions() = default;
size_t CookieManagerGetOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->match_type);
  return seed;
}

void CookieManagerGetOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", this->name);
  value->SetString("match_type", base::trace_event::ValueToString(this->match_type));
}

bool CookieManagerGetOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char RestrictedCookieManager::Name_[] = "network.mojom.RestrictedCookieManager";
bool RestrictedCookieManager::SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie) {
  NOTREACHED();
  return false;
}
bool RestrictedCookieManager::GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, std::string* out_cookies) {
  NOTREACHED();
  return false;
}
bool RestrictedCookieManager::CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_cookies_enabled) {
  NOTREACHED();
  return false;
}

class RestrictedCookieManager_GetAllForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetAllForUrl_ForwardToCallback(
      RestrictedCookieManager::GetAllForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::GetAllForUrlCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_GetAllForUrl_ForwardToCallback);
};

class RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback(
      RestrictedCookieManager::SetCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::SetCanonicalCookieCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback);
};

class RestrictedCookieManager_AddChangeListener_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_AddChangeListener_ForwardToCallback(
      RestrictedCookieManager::AddChangeListenerCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::AddChangeListenerCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_AddChangeListener_ForwardToCallback);
};
class RestrictedCookieManager_SetCookieFromString_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCookieFromString_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_SetCookieFromString_HandleSyncResponse);
};

class RestrictedCookieManager_SetCookieFromString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCookieFromString_ForwardToCallback(
      RestrictedCookieManager::SetCookieFromStringCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::SetCookieFromStringCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_SetCookieFromString_ForwardToCallback);
};
class RestrictedCookieManager_GetCookiesString_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetCookiesString_HandleSyncResponse(
      bool* result, std::string* out_cookies)
      : result_(result), out_cookies_(out_cookies) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::string* out_cookies_;DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_GetCookiesString_HandleSyncResponse);
};

class RestrictedCookieManager_GetCookiesString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetCookiesString_ForwardToCallback(
      RestrictedCookieManager::GetCookiesStringCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::GetCookiesStringCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_GetCookiesString_ForwardToCallback);
};
class RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse(
      bool* result, bool* out_cookies_enabled)
      : result_(result), out_cookies_enabled_(out_cookies_enabled) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_cookies_enabled_;DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse);
};

class RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback(
      RestrictedCookieManager::CookiesEnabledForCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::CookiesEnabledForCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback);
};

RestrictedCookieManagerProxy::RestrictedCookieManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RestrictedCookieManagerProxy::GetAllForUrl(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, CookieManagerGetOptionsPtr in_options, GetAllForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::GetAllForUrl", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_GetAllForUrl_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_GetAllForUrl_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.GetAllForUrl request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.GetAllForUrl request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.GetAllForUrl request");
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::network::mojom::CookieManagerGetOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in RestrictedCookieManager.GetAllForUrl request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetAllForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetAllForUrl_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RestrictedCookieManagerProxy::SetCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, SetCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::SetCanonicalCookie", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cookie", base::trace_event::ValueToString(in_cookie, "<value of type const ::net::CanonicalCookie&>"));
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookie)::BaseType::BufferWriter
      cookie_writer;
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie, buffer, &cookie_writer, &serialization_context);
  params->cookie.Set(
      cookie_writer.is_null() ? nullptr : cookie_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in RestrictedCookieManager.SetCanonicalCookie request");
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.SetCanonicalCookie request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.SetCanonicalCookie request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.SetCanonicalCookie request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void RestrictedCookieManagerProxy::AddChangeListener(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> in_listener, AddChangeListenerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::AddChangeListener", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetBoolean("listener", in_listener.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_AddChangeListener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_AddChangeListener_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.AddChangeListener request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.AddChangeListener request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.AddChangeListener request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
      in_listener, &params->listener, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in RestrictedCookieManager.AddChangeListener request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("AddChangeListener");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_AddChangeListener_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool RestrictedCookieManagerProxy::SetCookieFromString(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, const std::string& param_cookie) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::RestrictedCookieManager::SetCookieFromString", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(param_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(param_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(param_top_frame_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("cookie", param_cookie);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_SetCookieFromString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      param_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->cookie)::BaseType::BufferWriter
      cookie_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_cookie, buffer, &cookie_writer, &serialization_context);
  params->cookie.Set(
      cookie_writer.is_null() ? nullptr : cookie_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in RestrictedCookieManager.SetCookieFromString request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCookieFromString_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::RestrictedCookieManager::SetCookieFromString");
#endif
  return result;
}

void RestrictedCookieManagerProxy::SetCookieFromString(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, const std::string& in_cookie, SetCookieFromStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::SetCookieFromString", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("cookie", in_cookie);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_SetCookieFromString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.SetCookieFromString request");
  typename decltype(params->cookie)::BaseType::BufferWriter
      cookie_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_cookie, buffer, &cookie_writer, &serialization_context);
  params->cookie.Set(
      cookie_writer.is_null() ? nullptr : cookie_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in RestrictedCookieManager.SetCookieFromString request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCookieFromString_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool RestrictedCookieManagerProxy::GetCookiesString(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, std::string* out_param_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::RestrictedCookieManager::GetCookiesString", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(param_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(param_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(param_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_GetCookiesString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.GetCookiesString request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      param_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.GetCookiesString request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.GetCookiesString request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetCookiesString_HandleSyncResponse(
          &result, out_param_cookies));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::RestrictedCookieManager::GetCookiesString", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_cookies) {
        raw_value->SetString("cookies", (*out_param_cookies));
      } else {
        raw_value->SetString("cookies", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void RestrictedCookieManagerProxy::GetCookiesString(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, GetCookiesStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::GetCookiesString", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_GetCookiesString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.GetCookiesString request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.GetCookiesString request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.GetCookiesString request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetCookiesString_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool RestrictedCookieManagerProxy::CookiesEnabledFor(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, bool* out_param_cookies_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::RestrictedCookieManager::CookiesEnabledFor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(param_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(param_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(param_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_CookiesEnabledFor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.CookiesEnabledFor request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      param_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.CookiesEnabledFor request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      param_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.CookiesEnabledFor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse(
          &result, out_param_cookies_enabled));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::RestrictedCookieManager::CookiesEnabledFor", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_cookies_enabled) {
        raw_value->SetBoolean("cookies_enabled", (*out_param_cookies_enabled));
      } else {
        raw_value->SetString("cookies_enabled", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void RestrictedCookieManagerProxy::CookiesEnabledFor(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, CookiesEnabledForCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::RestrictedCookieManager::CookiesEnabledFor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_CookiesEnabledFor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RestrictedCookieManager.CookiesEnabledFor request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in RestrictedCookieManager.CookiesEnabledFor request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in RestrictedCookieManager.CookiesEnabledFor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class RestrictedCookieManager_GetAllForUrl_ProxyToResponder {
 public:
  static RestrictedCookieManager::GetAllForUrlCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_GetAllForUrl_ProxyToResponder> proxy(
        new RestrictedCookieManager_GetAllForUrl_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_GetAllForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_GetAllForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_GetAllForUrl_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::GetAllForUrlCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::CookieWithAccessResult>& in_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_GetAllForUrl_ProxyToResponder);
};

bool RestrictedCookieManager_GetAllForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::GetAllForUrlCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<::net::CookieWithAccessResult> p_cookies{};
  RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies));
  return true;
}

void RestrictedCookieManager_GetAllForUrl_ProxyToResponder::Run(
    const std::vector<::net::CookieWithAccessResult>& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::RestrictedCookieManager::GetAllForUrlCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("cookies");
      for (const auto& item0 : in_cookies) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::net::CookieWithAccessResult&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_GetAllForUrl_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookies)::BaseType::BufferWriter
      cookies_writer;
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_cookies, buffer, &cookies_writer, &cookies_validate_params,
      &serialization_context);
  params->cookies.Set(
      cookies_writer.is_null() ? nullptr : cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::GetAllForUrlCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetAllForUrl");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder {
 public:
  static RestrictedCookieManager::SetCanonicalCookieCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder> proxy(
        new RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::SetCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder);
};

bool RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::SetCanonicalCookieCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  RestrictedCookieManager_SetCanonicalCookie_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::RestrictedCookieManager::SetCanonicalCookieCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::SetCanonicalCookieCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_AddChangeListener_ProxyToResponder {
 public:
  static RestrictedCookieManager::AddChangeListenerCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_AddChangeListener_ProxyToResponder> proxy(
        new RestrictedCookieManager_AddChangeListener_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_AddChangeListener_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_AddChangeListener_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_AddChangeListener_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::AddChangeListenerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_AddChangeListener_ProxyToResponder);
};

bool RestrictedCookieManager_AddChangeListener_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::AddChangeListenerCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  RestrictedCookieManager_AddChangeListener_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void RestrictedCookieManager_AddChangeListener_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::RestrictedCookieManager::AddChangeListenerCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_AddChangeListener_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::AddChangeListenerCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("AddChangeListener");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_SetCookieFromString_ProxyToResponder {
 public:
  static RestrictedCookieManager::SetCookieFromStringCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_SetCookieFromString_ProxyToResponder> proxy(
        new RestrictedCookieManager_SetCookieFromString_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_SetCookieFromString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_SetCookieFromString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_SetCookieFromString_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::SetCookieFromStringCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_SetCookieFromString_ProxyToResponder);
};

bool RestrictedCookieManager_SetCookieFromString_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::SetCookieFromStringCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void RestrictedCookieManager_SetCookieFromString_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::RestrictedCookieManager::SetCookieFromStringCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_SetCookieFromString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::SetCookieFromStringCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_SetCookieFromString_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 3, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class RestrictedCookieManager_GetCookiesString_ProxyToResponder {
 public:
  static RestrictedCookieManager::GetCookiesStringCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_GetCookiesString_ProxyToResponder> proxy(
        new RestrictedCookieManager_GetCookiesString_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_GetCookiesString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_GetCookiesString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_GetCookiesString_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::GetCookiesStringCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_GetCookiesString_ProxyToResponder);
};

bool RestrictedCookieManager_GetCookiesString_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::GetCookiesStringCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::string p_cookies{};
  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies));
  return true;
}

void RestrictedCookieManager_GetCookiesString_ProxyToResponder::Run(
    const std::string& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::RestrictedCookieManager::GetCookiesStringCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cookies", in_cookies);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_GetCookiesString_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cookies)::BaseType::BufferWriter
      cookies_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_cookies, buffer, &cookies_writer, &serialization_context);
  params->cookies.Set(
      cookies_writer.is_null() ? nullptr : cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::GetCookiesStringCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_GetCookiesString_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::string p_cookies{};
  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 4, true);
    return false;
  }
  *out_cookies_ = std::move(p_cookies);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder {
 public:
  static RestrictedCookieManager::CookiesEnabledForCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder> proxy(
        new RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RestrictedCookieManager::CookiesEnabledForCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_cookies_enabled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder);
};

bool RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::RestrictedCookieManager::CookiesEnabledForCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_cookies_enabled{};
  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_cookies_enabled = input_data_view.cookies_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies_enabled));
  return true;
}

void RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::Run(
    bool in_cookies_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::RestrictedCookieManager::CookiesEnabledForCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("cookies_enabled", in_cookies_enabled);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kRestrictedCookieManager_CookiesEnabledFor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->cookies_enabled = in_cookies_enabled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::RestrictedCookieManager::CookiesEnabledForCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_cookies_enabled{};
  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_cookies_enabled = input_data_view.cookies_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 5, true);
    return false;
  }
  *out_cookies_enabled_ = std::move(p_cookies_enabled);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool RestrictedCookieManagerStubDispatch::Accept(
    RestrictedCookieManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kRestrictedCookieManager_GetAllForUrl_Name: {
      break;
    }
    case internal::kRestrictedCookieManager_SetCanonicalCookie_Name: {
      break;
    }
    case internal::kRestrictedCookieManager_AddChangeListener_Name: {
      break;
    }
    case internal::kRestrictedCookieManager_SetCookieFromString_Name: {
      break;
    }
    case internal::kRestrictedCookieManager_GetCookiesString_Name: {
      break;
    }
    case internal::kRestrictedCookieManager_CookiesEnabledFor_Name: {
      break;
    }
  }
  return false;
}

// static
bool RestrictedCookieManagerStubDispatch::AcceptWithResponder(
    RestrictedCookieManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kRestrictedCookieManager_GetAllForUrl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::GetAllForUrl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::GetAllForUrl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_GetAllForUrl_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_GetAllForUrl_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      CookieManagerGetOptionsPtr p_options{};
      RestrictedCookieManager_GetAllForUrl_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 0, false);
        return false;
      }
      RestrictedCookieManager::GetAllForUrlCallback callback =
          RestrictedCookieManager_GetAllForUrl_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllForUrl(
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), 
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kRestrictedCookieManager_SetCanonicalCookie_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::SetCanonicalCookie",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::SetCanonicalCookie");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      RestrictedCookieManager_SetCanonicalCookie_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 1, false);
        return false;
      }
      RestrictedCookieManager::SetCanonicalCookieCallback callback =
          RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanonicalCookie(
std::move(p_cookie), 
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), std::move(callback));
      return true;
    }
    case internal::kRestrictedCookieManager_AddChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::AddChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::AddChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_AddChangeListener_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_AddChangeListener_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::mojo::PendingRemote<::network::mojom::CookieChangeListener> p_listener{};
      RestrictedCookieManager_AddChangeListener_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 2, false);
        return false;
      }
      RestrictedCookieManager::AddChangeListenerCallback callback =
          RestrictedCookieManager_AddChangeListener_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddChangeListener(
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), 
std::move(p_listener), std::move(callback));
      return true;
    }
    case internal::kRestrictedCookieManager_SetCookieFromString_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::SetCookieFromString",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::SetCookieFromString");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_SetCookieFromString_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_SetCookieFromString_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      std::string p_cookie{};
      RestrictedCookieManager_SetCookieFromString_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 3, false);
        return false;
      }
      RestrictedCookieManager::SetCookieFromStringCallback callback =
          RestrictedCookieManager_SetCookieFromString_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCookieFromString(
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), 
std::move(p_cookie), std::move(callback));
      return true;
    }
    case internal::kRestrictedCookieManager_GetCookiesString_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::GetCookiesString",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::GetCookiesString");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_GetCookiesString_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_GetCookiesString_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      RestrictedCookieManager_GetCookiesString_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 4, false);
        return false;
      }
      RestrictedCookieManager::GetCookiesStringCallback callback =
          RestrictedCookieManager_GetCookiesString_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookiesString(
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), std::move(callback));
      return true;
    }
    case internal::kRestrictedCookieManager_CookiesEnabledFor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::RestrictedCookieManager::CookiesEnabledFor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::RestrictedCookieManager::CookiesEnabledFor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      RestrictedCookieManager_CookiesEnabledFor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 5, false);
        return false;
      }
      RestrictedCookieManager::CookiesEnabledForCallback callback =
          RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CookiesEnabledFor(
std::move(p_url), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRestrictedCookieManagerValidationInfo[] = {
    {internal::kRestrictedCookieManager_GetAllForUrl_Name,
     {&internal::RestrictedCookieManager_GetAllForUrl_Params_Data::Validate,
      &internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data::Validate}},
    {internal::kRestrictedCookieManager_SetCanonicalCookie_Name,
     {&internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data::Validate,
      &internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data::Validate}},
    {internal::kRestrictedCookieManager_AddChangeListener_Name,
     {&internal::RestrictedCookieManager_AddChangeListener_Params_Data::Validate,
      &internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data::Validate}},
    {internal::kRestrictedCookieManager_SetCookieFromString_Name,
     {&internal::RestrictedCookieManager_SetCookieFromString_Params_Data::Validate,
      &internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data::Validate}},
    {internal::kRestrictedCookieManager_GetCookiesString_Name,
     {&internal::RestrictedCookieManager_GetCookiesString_Params_Data::Validate,
      &internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data::Validate}},
    {internal::kRestrictedCookieManager_CookiesEnabledFor_Name,
     {&internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data::Validate,
      &internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data::Validate}},
};

bool RestrictedCookieManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::RestrictedCookieManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRestrictedCookieManagerValidationInfo);
}

bool RestrictedCookieManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::RestrictedCookieManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRestrictedCookieManagerValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CookieManagerGetOptions::DataView, ::network::mojom::CookieManagerGetOptionsPtr>::Read(
    ::network::mojom::CookieManagerGetOptions::DataView input,
    ::network::mojom::CookieManagerGetOptionsPtr* output) {
  bool success = true;
  ::network::mojom::CookieManagerGetOptionsPtr result(::network::mojom::CookieManagerGetOptions::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMatchType(&result->match_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif