// media/mojo/mojom/speech_recognition_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/speech_recognition_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-params-data.h"
#include "media/mojo/mojom/speech_recognition_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
SpeechRecognitionResult::SpeechRecognitionResult()
    : transcription(),
      is_final() {}

SpeechRecognitionResult::SpeechRecognitionResult(
    const std::string& transcription_in,
    bool is_final_in)
    : transcription(std::move(transcription_in)),
      is_final(std::move(is_final_in)) {}

SpeechRecognitionResult::~SpeechRecognitionResult() = default;
size_t SpeechRecognitionResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->transcription);
  seed = mojo::internal::Hash(seed, this->is_final);
  return seed;
}

void SpeechRecognitionResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("transcription", this->transcription);
  value->SetBoolean("is_final", this->is_final);
}

bool SpeechRecognitionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SpeechRecognitionContext::Name_[] = "media.mojom.SpeechRecognitionContext";

class SpeechRecognitionContext_BindRecognizer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
      SpeechRecognitionContext::BindRecognizerCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SpeechRecognitionContext::BindRecognizerCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindRecognizer_ForwardToCallback);
};

SpeechRecognitionContextProxy::SpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionContextProxy::BindRecognizer(
    ::mojo::PendingReceiver<SpeechRecognitionRecognizer> in_receiver, ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> in_client, BindRecognizerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionContext::BindRecognizer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindRecognizer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionRecognizerInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in SpeechRecognitionContext.BindRecognizer request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionRecognizerClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechRecognitionContext.BindRecognizer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SpeechRecognitionContext_BindRecognizer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SpeechRecognitionContext_BindRecognizer_ProxyToResponder {
 public:
  static SpeechRecognitionContext::BindRecognizerCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SpeechRecognitionContext_BindRecognizer_ProxyToResponder> proxy(
        new SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SpeechRecognitionContext_BindRecognizer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SpeechRecognitionContext_BindRecognizer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SpeechRecognitionContext::BindRecognizerCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_multichannel_supported);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SpeechRecognitionContext_BindRecognizer_ProxyToResponder);
};

bool SpeechRecognitionContext_BindRecognizer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::SpeechRecognitionContext::BindRecognizerCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_is_multichannel_supported{};
  SpeechRecognitionContext_BindRecognizer_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_is_multichannel_supported = input_data_view.is_multichannel_supported();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SpeechRecognitionContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_multichannel_supported));
  return true;
}

void SpeechRecognitionContext_BindRecognizer_ProxyToResponder::Run(
    bool in_is_multichannel_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizerCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_multichannel_supported", in_is_multichannel_supported);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionContext_BindRecognizer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_multichannel_supported = in_is_multichannel_supported;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizerCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionContext::Name_);
  message.set_method_name("BindRecognizer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SpeechRecognitionContextStubDispatch::Accept(
    SpeechRecognitionContext* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionContext_BindRecognizer_Name: {
      break;
    }
  }
  return false;
}

// static
bool SpeechRecognitionContextStubDispatch::AcceptWithResponder(
    SpeechRecognitionContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionContext_BindRecognizer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionContext::BindRecognizer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SpeechRecognitionContext_BindRecognizer_Params_Data* params =
          reinterpret_cast<
              internal::SpeechRecognitionContext_BindRecognizer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<SpeechRecognitionRecognizer> p_receiver{};
      ::mojo::PendingRemote<SpeechRecognitionRecognizerClient> p_client{};
      SpeechRecognitionContext_BindRecognizer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionContext::Name_, 0, false);
        return false;
      }
      SpeechRecognitionContext::BindRecognizerCallback callback =
          SpeechRecognitionContext_BindRecognizer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindRecognizer(
std::move(p_receiver), 
std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionContextValidationInfo[] = {
    {internal::kSpeechRecognitionContext_BindRecognizer_Name,
     {&internal::SpeechRecognitionContext_BindRecognizer_Params_Data::Validate,
      &internal::SpeechRecognitionContext_BindRecognizer_ResponseParams_Data::Validate}},
};

bool SpeechRecognitionContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionContextValidationInfo);
}

bool SpeechRecognitionContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSpeechRecognitionContextValidationInfo);

}
const char SpeechRecognitionService::Name_[] = "media.mojom.SpeechRecognitionService";

SpeechRecognitionServiceProxy::SpeechRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionServiceProxy::BindContext(
    ::mojo::PendingReceiver<SpeechRecognitionContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::BindContext", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("context", in_context.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_BindContext_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionService_BindContext_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::SpeechRecognitionContextInterfaceBase>>(
      in_context, &params->context, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->context),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid context in SpeechRecognitionService.BindContext request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::SetUrlLoaderFactory(
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> in_url_loader_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::SetUrlLoaderFactory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("url_loader_factory", in_url_loader_factory.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in SpeechRecognitionService.SetUrlLoaderFactory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetUrlLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::SetSodaPath(
    const ::base::FilePath& in_binary_path, const ::base::FilePath& in_config_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::SetSodaPath", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("binary_path", base::trace_event::ValueToString(in_binary_path, "<value of type const ::base::FilePath&>"));
      raw_value->SetString("config_path", base::trace_event::ValueToString(in_config_path, "<value of type const ::base::FilePath&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_SetSodaPath_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionService_SetSodaPath_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->binary_path)::BaseType::BufferWriter
      binary_path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_binary_path, buffer, &binary_path_writer, &serialization_context);
  params->binary_path.Set(
      binary_path_writer.is_null() ? nullptr : binary_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binary_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binary_path in SpeechRecognitionService.SetSodaPath request");
  typename decltype(params->config_path)::BaseType::BufferWriter
      config_path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_config_path, buffer, &config_path_writer, &serialization_context);
  params->config_path.Set(
      config_path_writer.is_null() ? nullptr : config_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config_path in SpeechRecognitionService.SetSodaPath request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("SetSodaPath");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SpeechRecognitionServiceProxy::BindSpeechRecognitionServiceClient(
    ::mojo::PendingRemote<SpeechRecognitionServiceClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::SpeechRecognitionServiceClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SpeechRecognitionService.BindSpeechRecognitionServiceClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionService::Name_);
  message.set_method_name("BindSpeechRecognitionServiceClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionServiceStubDispatch::Accept(
    SpeechRecognitionService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionService_BindContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::BindContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::BindContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindContext_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<SpeechRecognitionContext> p_context{};
      SpeechRecognitionService_BindContext_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindContext(
std::move(p_context));
      return true;
    }
    case internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::SetUrlLoaderFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::SetUrlLoaderFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      SpeechRecognitionService_SetUrlLoaderFactory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUrlLoaderFactory(
std::move(p_url_loader_factory));
      return true;
    }
    case internal::kSpeechRecognitionService_SetSodaPath_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::SetSodaPath",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::SetSodaPath");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_SetSodaPath_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_SetSodaPath_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_binary_path{};
      ::base::FilePath p_config_path{};
      SpeechRecognitionService_SetSodaPath_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBinaryPath(&p_binary_path))
        success = false;
      if (success && !input_data_view.ReadConfigPath(&p_config_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSodaPath(
std::move(p_binary_path), 
std::move(p_config_path));
      return true;
    }
    case internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionService::BindSpeechRecognitionServiceClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SpeechRecognitionServiceClient> p_client{};
      SpeechRecognitionService_BindSpeechRecognitionServiceClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSpeechRecognitionServiceClient(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionServiceStubDispatch::AcceptWithResponder(
    SpeechRecognitionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionService_BindContext_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_SetSodaPath_Name: {
      break;
    }
    case internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionServiceValidationInfo[] = {
    {internal::kSpeechRecognitionService_BindContext_Name,
     {&internal::SpeechRecognitionService_BindContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_SetUrlLoaderFactory_Name,
     {&internal::SpeechRecognitionService_SetUrlLoaderFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_SetSodaPath_Name,
     {&internal::SpeechRecognitionService_SetSodaPath_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSpeechRecognitionService_BindSpeechRecognitionServiceClient_Name,
     {&internal::SpeechRecognitionService_BindSpeechRecognitionServiceClient_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionServiceValidationInfo);
}

const char SpeechRecognitionServiceClient::Name_[] = "media.mojom.SpeechRecognitionServiceClient";

SpeechRecognitionServiceClientProxy::SpeechRecognitionServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionServiceClientProxy::OnNetworkServiceDisconnect(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionServiceClient::Name_);
  message.set_method_name("OnNetworkServiceDisconnect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionServiceClientStubDispatch::Accept(
    SpeechRecognitionServiceClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionServiceClient::OnNetworkServiceDisconnect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionServiceClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkServiceDisconnect();
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionServiceClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionServiceClientValidationInfo[] = {
    {internal::kSpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Name,
     {&internal::SpeechRecognitionServiceClient_OnNetworkServiceDisconnect_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionServiceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionServiceClientValidationInfo);
}

const char SpeechRecognitionRecognizer::Name_[] = "media.mojom.SpeechRecognitionRecognizer";

SpeechRecognitionRecognizerProxy::SpeechRecognitionRecognizerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerProxy::SendAudioToSpeechRecognitionService(
    ::media::mojom::AudioDataS16Ptr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_buffer.is_null()) {
        raw_value->SetString("buffer", "nullptr");
      } else {
        raw_value->BeginDictionary("buffer");
        in_buffer->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->buffer)::BaseType::BufferWriter
      buffer_writer;
  mojo::internal::Serialize<::media::mojom::AudioDataS16DataView>(
      in_buffer, buffer, &buffer_writer, &serialization_context);
  params->buffer.Set(
      buffer_writer.is_null() ? nullptr : buffer_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer in SpeechRecognitionRecognizer.SendAudioToSpeechRecognitionService request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizer::Name_);
  message.set_method_name("SendAudioToSpeechRecognitionService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionRecognizerStubDispatch::Accept(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizer::SendAudioToSpeechRecognitionService");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::AudioDataS16Ptr p_buffer{};
      SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendAudioToSpeechRecognitionService(
std::move(p_buffer));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionRecognizerValidationInfo[] = {
    {internal::kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name,
     {&internal::SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionRecognizerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionRecognizer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionRecognizerValidationInfo);
}

const char SpeechRecognitionRecognizerClient::Name_[] = "media.mojom.SpeechRecognitionRecognizerClient";

SpeechRecognitionRecognizerClientProxy::SpeechRecognitionRecognizerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SpeechRecognitionRecognizerClientProxy::OnSpeechRecognitionRecognitionEvent(
    SpeechRecognitionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::media::mojom::SpeechRecognitionResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in SpeechRecognitionRecognizerClient.OnSpeechRecognitionRecognitionEvent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SpeechRecognitionRecognizerClient::Name_);
  message.set_method_name("OnSpeechRecognitionRecognitionEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::Accept(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::SpeechRecognitionRecognizerClient::OnSpeechRecognitionRecognitionEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data* params =
          reinterpret_cast<internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpeechRecognitionResultPtr p_result{};
      SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SpeechRecognitionRecognizerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSpeechRecognitionRecognitionEvent(
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool SpeechRecognitionRecognizerClientStubDispatch::AcceptWithResponder(
    SpeechRecognitionRecognizerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSpeechRecognitionRecognizerClientValidationInfo[] = {
    {internal::kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name,
     {&internal::SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SpeechRecognitionRecognizerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::SpeechRecognitionRecognizerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSpeechRecognitionRecognizerClientValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::SpeechRecognitionResult::DataView, ::media::mojom::SpeechRecognitionResultPtr>::Read(
    ::media::mojom::SpeechRecognitionResult::DataView input,
    ::media::mojom::SpeechRecognitionResultPtr* output) {
  bool success = true;
  ::media::mojom::SpeechRecognitionResultPtr result(::media::mojom::SpeechRecognitionResult::New());
  
      if (success && !input.ReadTranscription(&result->transcription))
        success = false;
      if (success)
        result->is_final = input.is_final();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif