// Copyright (c) 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/browser/api/generated_api_registration.h"

#include "build/build_config.h"
#include "build/chromeos_buildflags.h"

#include "extensions/browser/api/alarms/alarms_api.h"
#include "extensions/browser/api/app_current_window_internal/app_current_window_internal_api.h"
#include "extensions/browser/api/app_runtime/app_runtime_api.h"
#include "extensions/browser/api/guest_view/app_view/app_view_guest_internal_api.h"
#include "extensions/browser/api/app_window/app_window_api.h"
#include "extensions/browser/api/audio/audio_api.h"
#include "extensions/browser/api/automation_internal/automation_internal_api.h"
#if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/cec_private/cec_private_api.h"
#endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/clipboard/clipboard_api.h"
#endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/declarative_net_request/declarative_net_request_api.h"
#include "extensions/browser/api/display_source/display_source_api.h"
#include "extensions/browser/api/dns/dns_api.h"
#include "extensions/browser/api/declarative/declarative_api.h"
#include "extensions/browser/api/file_system/file_system_api.h"
#include "extensions/browser/api/guest_view/guest_view_internal_api.h"
#include "extensions/browser/api/management/management_api.h"
#include "extensions/browser/api/hid/hid_api.h"
#include "extensions/browser/api/idle/idle_api.h"
#include "extensions/browser/api/metrics_private/metrics_private_api.h"
#include "extensions/browser/api/networking_private/networking_private_api.h"
#include "extensions/browser/api/power/power_api.h"
#include "extensions/browser/api/printer_provider/printer_provider_api.h"
#include "extensions/browser/api/printer_provider_internal/printer_provider_internal_api.h"
#include "extensions/browser/api/runtime/runtime_api.h"
#include "extensions/browser/api/serial/serial_api.h"
#include "extensions/browser/api/socket/socket_api.h"
#include "extensions/browser/api/sockets_tcp/sockets_tcp_api.h"
#include "extensions/browser/api/sockets_tcp_server/sockets_tcp_server_api.h"
#include "extensions/browser/api/sockets_udp/sockets_udp_api.h"
#include "extensions/browser/api/storage/storage_api.h"
#include "extensions/browser/api/system_cpu/system_cpu_api.h"
#include "extensions/browser/api/system_display/system_display_api.h"
#include "extensions/browser/api/system_memory/system_memory_api.h"
#include "extensions/browser/api/system_network/system_network_api.h"
#if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/system_power_source/system_power_source_api.h"
#endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/system_storage/system_storage_api.h"
#include "extensions/browser/api/test/test_api.h"
#include "extensions/browser/api/usb/usb_api.h"
#if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/virtual_keyboard/virtual_keyboard_api.h"
#endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/virtual_keyboard_private/virtual_keyboard_private_api.h"
#endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
#include "extensions/browser/api/web_request/web_request_api.h"
#include "extensions/browser/api/guest_view/web_view/web_view_internal_api.h"
#include "extensions/browser/api/web_request/web_request_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void GeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<AlarmsCreateFunction>,
      AlarmsCreateFunction::function_name(),
      AlarmsCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsGetFunction>,
      AlarmsGetFunction::function_name(),
      AlarmsGetFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsGetAllFunction>,
      AlarmsGetAllFunction::function_name(),
      AlarmsGetAllFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsClearFunction>,
      AlarmsClearFunction::function_name(),
      AlarmsClearFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AlarmsClearAllFunction>,
      AlarmsClearAllFunction::function_name(),
      AlarmsClearAllFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalFocusFunction>,
      AppCurrentWindowInternalFocusFunction::function_name(),
      AppCurrentWindowInternalFocusFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalFullscreenFunction>,
      AppCurrentWindowInternalFullscreenFunction::function_name(),
      AppCurrentWindowInternalFullscreenFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalMinimizeFunction>,
      AppCurrentWindowInternalMinimizeFunction::function_name(),
      AppCurrentWindowInternalMinimizeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalMaximizeFunction>,
      AppCurrentWindowInternalMaximizeFunction::function_name(),
      AppCurrentWindowInternalMaximizeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalRestoreFunction>,
      AppCurrentWindowInternalRestoreFunction::function_name(),
      AppCurrentWindowInternalRestoreFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalDrawAttentionFunction>,
      AppCurrentWindowInternalDrawAttentionFunction::function_name(),
      AppCurrentWindowInternalDrawAttentionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalClearAttentionFunction>,
      AppCurrentWindowInternalClearAttentionFunction::function_name(),
      AppCurrentWindowInternalClearAttentionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalShowFunction>,
      AppCurrentWindowInternalShowFunction::function_name(),
      AppCurrentWindowInternalShowFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalHideFunction>,
      AppCurrentWindowInternalHideFunction::function_name(),
      AppCurrentWindowInternalHideFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetBoundsFunction>,
      AppCurrentWindowInternalSetBoundsFunction::function_name(),
      AppCurrentWindowInternalSetBoundsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetSizeConstraintsFunction>,
      AppCurrentWindowInternalSetSizeConstraintsFunction::function_name(),
      AppCurrentWindowInternalSetSizeConstraintsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetIconFunction>,
      AppCurrentWindowInternalSetIconFunction::function_name(),
      AppCurrentWindowInternalSetIconFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetShapeFunction>,
      AppCurrentWindowInternalSetShapeFunction::function_name(),
      AppCurrentWindowInternalSetShapeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetAlwaysOnTopFunction>,
      AppCurrentWindowInternalSetAlwaysOnTopFunction::function_name(),
      AppCurrentWindowInternalSetAlwaysOnTopFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction>,
      AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction::function_name(),
      AppCurrentWindowInternalSetVisibleOnAllWorkspacesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppCurrentWindowInternalSetActivateOnPointerFunction>,
      AppCurrentWindowInternalSetActivateOnPointerFunction::function_name(),
      AppCurrentWindowInternalSetActivateOnPointerFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppViewGuestInternalAttachFrameFunction>,
      AppViewGuestInternalAttachFrameFunction::function_name(),
      AppViewGuestInternalAttachFrameFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppViewGuestInternalDenyRequestFunction>,
      AppViewGuestInternalDenyRequestFunction::function_name(),
      AppViewGuestInternalDenyRequestFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AppWindowCreateFunction>,
      AppWindowCreateFunction::function_name(),
      AppWindowCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioGetDevicesFunction>,
      AudioGetDevicesFunction::function_name(),
      AudioGetDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetActiveDevicesFunction>,
      AudioSetActiveDevicesFunction::function_name(),
      AudioSetActiveDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetPropertiesFunction>,
      AudioSetPropertiesFunction::function_name(),
      AudioSetPropertiesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioGetMuteFunction>,
      AudioGetMuteFunction::function_name(),
      AudioGetMuteFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioSetMuteFunction>,
      AudioSetMuteFunction::function_name(),
      AudioSetMuteFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AudioGetInfoFunction>,
      AudioGetInfoFunction::function_name(),
      AudioGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalEnableTabFunction>,
      AutomationInternalEnableTabFunction::function_name(),
      AutomationInternalEnableTabFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalEnableTreeFunction>,
      AutomationInternalEnableTreeFunction::function_name(),
      AutomationInternalEnableTreeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalEnableDesktopFunction>,
      AutomationInternalEnableDesktopFunction::function_name(),
      AutomationInternalEnableDesktopFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalPerformActionFunction>,
      AutomationInternalPerformActionFunction::function_name(),
      AutomationInternalPerformActionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<AutomationInternalQuerySelectorFunction>,
      AutomationInternalQuerySelectorFunction::function_name(),
      AutomationInternalQuerySelectorFunction::histogram_value(),
    },
    #if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<CecPrivateSendStandByFunction>,
      CecPrivateSendStandByFunction::function_name(),
      CecPrivateSendStandByFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<CecPrivateSendWakeUpFunction>,
      CecPrivateSendWakeUpFunction::function_name(),
      CecPrivateSendWakeUpFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<CecPrivateQueryDisplayCecPowerStateFunction>,
      CecPrivateQueryDisplayCecPowerStateFunction::function_name(),
      CecPrivateQueryDisplayCecPowerStateFunction::histogram_value(),
    },
    #endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    #if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<ClipboardSetImageDataFunction>,
      ClipboardSetImageDataFunction::function_name(),
      ClipboardSetImageDataFunction::histogram_value(),
    },
    #endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateDynamicRulesFunction>,
      DeclarativeNetRequestUpdateDynamicRulesFunction::function_name(),
      DeclarativeNetRequestUpdateDynamicRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetDynamicRulesFunction>,
      DeclarativeNetRequestGetDynamicRulesFunction::function_name(),
      DeclarativeNetRequestGetDynamicRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestUpdateEnabledRulesetsFunction>,
      DeclarativeNetRequestUpdateEnabledRulesetsFunction::function_name(),
      DeclarativeNetRequestUpdateEnabledRulesetsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetEnabledRulesetsFunction>,
      DeclarativeNetRequestGetEnabledRulesetsFunction::function_name(),
      DeclarativeNetRequestGetEnabledRulesetsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestGetMatchedRulesFunction>,
      DeclarativeNetRequestGetMatchedRulesFunction::function_name(),
      DeclarativeNetRequestGetMatchedRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestSetActionCountAsBadgeTextFunction>,
      DeclarativeNetRequestSetActionCountAsBadgeTextFunction::function_name(),
      DeclarativeNetRequestSetActionCountAsBadgeTextFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DeclarativeNetRequestIsRegexSupportedFunction>,
      DeclarativeNetRequestIsRegexSupportedFunction::function_name(),
      DeclarativeNetRequestIsRegexSupportedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DisplaySourceGetAvailableSinksFunction>,
      DisplaySourceGetAvailableSinksFunction::function_name(),
      DisplaySourceGetAvailableSinksFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DisplaySourceRequestAuthenticationFunction>,
      DisplaySourceRequestAuthenticationFunction::function_name(),
      DisplaySourceRequestAuthenticationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<DnsResolveFunction>,
      DnsResolveFunction::function_name(),
      DnsResolveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventAddRulesFunction>,
      EventsEventAddRulesFunction::function_name(),
      EventsEventAddRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventGetRulesFunction>,
      EventsEventGetRulesFunction::function_name(),
      EventsEventGetRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<EventsEventRemoveRulesFunction>,
      EventsEventRemoveRulesFunction::function_name(),
      EventsEventRemoveRulesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemGetDisplayPathFunction>,
      FileSystemGetDisplayPathFunction::function_name(),
      FileSystemGetDisplayPathFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemGetWritableEntryFunction>,
      FileSystemGetWritableEntryFunction::function_name(),
      FileSystemGetWritableEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemIsWritableEntryFunction>,
      FileSystemIsWritableEntryFunction::function_name(),
      FileSystemIsWritableEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemChooseEntryFunction>,
      FileSystemChooseEntryFunction::function_name(),
      FileSystemChooseEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRestoreEntryFunction>,
      FileSystemRestoreEntryFunction::function_name(),
      FileSystemRestoreEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemIsRestorableFunction>,
      FileSystemIsRestorableFunction::function_name(),
      FileSystemIsRestorableFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRetainEntryFunction>,
      FileSystemRetainEntryFunction::function_name(),
      FileSystemRetainEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemRequestFileSystemFunction>,
      FileSystemRequestFileSystemFunction::function_name(),
      FileSystemRequestFileSystemFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<FileSystemGetVolumeListFunction>,
      FileSystemGetVolumeListFunction::function_name(),
      FileSystemGetVolumeListFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalCreateGuestFunction>,
      GuestViewInternalCreateGuestFunction::function_name(),
      GuestViewInternalCreateGuestFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalDestroyGuestFunction>,
      GuestViewInternalDestroyGuestFunction::function_name(),
      GuestViewInternalDestroyGuestFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<GuestViewInternalSetSizeFunction>,
      GuestViewInternalSetSizeFunction::function_name(),
      GuestViewInternalSetSizeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetAllFunction>,
      ManagementGetAllFunction::function_name(),
      ManagementGetAllFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetFunction>,
      ManagementGetFunction::function_name(),
      ManagementGetFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetSelfFunction>,
      ManagementGetSelfFunction::function_name(),
      ManagementGetSelfFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetPermissionWarningsByIdFunction>,
      ManagementGetPermissionWarningsByIdFunction::function_name(),
      ManagementGetPermissionWarningsByIdFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGetPermissionWarningsByManifestFunction>,
      ManagementGetPermissionWarningsByManifestFunction::function_name(),
      ManagementGetPermissionWarningsByManifestFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementSetEnabledFunction>,
      ManagementSetEnabledFunction::function_name(),
      ManagementSetEnabledFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementUninstallFunction>,
      ManagementUninstallFunction::function_name(),
      ManagementUninstallFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementUninstallSelfFunction>,
      ManagementUninstallSelfFunction::function_name(),
      ManagementUninstallSelfFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementLaunchAppFunction>,
      ManagementLaunchAppFunction::function_name(),
      ManagementLaunchAppFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementCreateAppShortcutFunction>,
      ManagementCreateAppShortcutFunction::function_name(),
      ManagementCreateAppShortcutFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementSetLaunchTypeFunction>,
      ManagementSetLaunchTypeFunction::function_name(),
      ManagementSetLaunchTypeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementGenerateAppForLinkFunction>,
      ManagementGenerateAppForLinkFunction::function_name(),
      ManagementGenerateAppForLinkFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementCanInstallReplacementAndroidAppFunction>,
      ManagementCanInstallReplacementAndroidAppFunction::function_name(),
      ManagementCanInstallReplacementAndroidAppFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementInstallReplacementAndroidAppFunction>,
      ManagementInstallReplacementAndroidAppFunction::function_name(),
      ManagementInstallReplacementAndroidAppFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<ManagementInstallReplacementWebAppFunction>,
      ManagementInstallReplacementWebAppFunction::function_name(),
      ManagementInstallReplacementWebAppFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidGetDevicesFunction>,
      HidGetDevicesFunction::function_name(),
      HidGetDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidGetUserSelectedDevicesFunction>,
      HidGetUserSelectedDevicesFunction::function_name(),
      HidGetUserSelectedDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidConnectFunction>,
      HidConnectFunction::function_name(),
      HidConnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidDisconnectFunction>,
      HidDisconnectFunction::function_name(),
      HidDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidReceiveFunction>,
      HidReceiveFunction::function_name(),
      HidReceiveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidSendFunction>,
      HidSendFunction::function_name(),
      HidSendFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidReceiveFeatureReportFunction>,
      HidReceiveFeatureReportFunction::function_name(),
      HidReceiveFeatureReportFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<HidSendFeatureReportFunction>,
      HidSendFeatureReportFunction::function_name(),
      HidSendFeatureReportFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<IdleQueryStateFunction>,
      IdleQueryStateFunction::function_name(),
      IdleQueryStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<IdleSetDetectionIntervalFunction>,
      IdleSetDetectionIntervalFunction::function_name(),
      IdleSetDetectionIntervalFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<IdleGetAutoLockDelayFunction>,
      IdleGetAutoLockDelayFunction::function_name(),
      IdleGetAutoLockDelayFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetHistogramFunction>,
      MetricsPrivateGetHistogramFunction::function_name(),
      MetricsPrivateGetHistogramFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetIsCrashReportingEnabledFunction>,
      MetricsPrivateGetIsCrashReportingEnabledFunction::function_name(),
      MetricsPrivateGetIsCrashReportingEnabledFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetFieldTrialFunction>,
      MetricsPrivateGetFieldTrialFunction::function_name(),
      MetricsPrivateGetFieldTrialFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateGetVariationParamsFunction>,
      MetricsPrivateGetVariationParamsFunction::function_name(),
      MetricsPrivateGetVariationParamsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordUserActionFunction>,
      MetricsPrivateRecordUserActionFunction::function_name(),
      MetricsPrivateRecordUserActionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordPercentageFunction>,
      MetricsPrivateRecordPercentageFunction::function_name(),
      MetricsPrivateRecordPercentageFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordCountFunction>,
      MetricsPrivateRecordCountFunction::function_name(),
      MetricsPrivateRecordCountFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSmallCountFunction>,
      MetricsPrivateRecordSmallCountFunction::function_name(),
      MetricsPrivateRecordSmallCountFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordMediumCountFunction>,
      MetricsPrivateRecordMediumCountFunction::function_name(),
      MetricsPrivateRecordMediumCountFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordTimeFunction>,
      MetricsPrivateRecordTimeFunction::function_name(),
      MetricsPrivateRecordTimeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordMediumTimeFunction>,
      MetricsPrivateRecordMediumTimeFunction::function_name(),
      MetricsPrivateRecordMediumTimeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordLongTimeFunction>,
      MetricsPrivateRecordLongTimeFunction::function_name(),
      MetricsPrivateRecordLongTimeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSparseHashableFunction>,
      MetricsPrivateRecordSparseHashableFunction::function_name(),
      MetricsPrivateRecordSparseHashableFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordSparseValueFunction>,
      MetricsPrivateRecordSparseValueFunction::function_name(),
      MetricsPrivateRecordSparseValueFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordValueFunction>,
      MetricsPrivateRecordValueFunction::function_name(),
      MetricsPrivateRecordValueFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordBooleanFunction>,
      MetricsPrivateRecordBooleanFunction::function_name(),
      MetricsPrivateRecordBooleanFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<MetricsPrivateRecordEnumerationValueFunction>,
      MetricsPrivateRecordEnumerationValueFunction::function_name(),
      MetricsPrivateRecordEnumerationValueFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetPropertiesFunction>,
      NetworkingPrivateGetPropertiesFunction::function_name(),
      NetworkingPrivateGetPropertiesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetManagedPropertiesFunction>,
      NetworkingPrivateGetManagedPropertiesFunction::function_name(),
      NetworkingPrivateGetManagedPropertiesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetStateFunction>,
      NetworkingPrivateGetStateFunction::function_name(),
      NetworkingPrivateGetStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSetPropertiesFunction>,
      NetworkingPrivateSetPropertiesFunction::function_name(),
      NetworkingPrivateSetPropertiesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateCreateNetworkFunction>,
      NetworkingPrivateCreateNetworkFunction::function_name(),
      NetworkingPrivateCreateNetworkFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateForgetNetworkFunction>,
      NetworkingPrivateForgetNetworkFunction::function_name(),
      NetworkingPrivateForgetNetworkFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetNetworksFunction>,
      NetworkingPrivateGetNetworksFunction::function_name(),
      NetworkingPrivateGetNetworksFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetVisibleNetworksFunction>,
      NetworkingPrivateGetVisibleNetworksFunction::function_name(),
      NetworkingPrivateGetVisibleNetworksFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetEnabledNetworkTypesFunction>,
      NetworkingPrivateGetEnabledNetworkTypesFunction::function_name(),
      NetworkingPrivateGetEnabledNetworkTypesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetDeviceStatesFunction>,
      NetworkingPrivateGetDeviceStatesFunction::function_name(),
      NetworkingPrivateGetDeviceStatesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateEnableNetworkTypeFunction>,
      NetworkingPrivateEnableNetworkTypeFunction::function_name(),
      NetworkingPrivateEnableNetworkTypeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateDisableNetworkTypeFunction>,
      NetworkingPrivateDisableNetworkTypeFunction::function_name(),
      NetworkingPrivateDisableNetworkTypeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateRequestNetworkScanFunction>,
      NetworkingPrivateRequestNetworkScanFunction::function_name(),
      NetworkingPrivateRequestNetworkScanFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartConnectFunction>,
      NetworkingPrivateStartConnectFunction::function_name(),
      NetworkingPrivateStartConnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartDisconnectFunction>,
      NetworkingPrivateStartDisconnectFunction::function_name(),
      NetworkingPrivateStartDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateStartActivateFunction>,
      NetworkingPrivateStartActivateFunction::function_name(),
      NetworkingPrivateStartActivateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateVerifyDestinationFunction>,
      NetworkingPrivateVerifyDestinationFunction::function_name(),
      NetworkingPrivateVerifyDestinationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateVerifyAndEncryptDataFunction>,
      NetworkingPrivateVerifyAndEncryptDataFunction::function_name(),
      NetworkingPrivateVerifyAndEncryptDataFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSetWifiTDLSEnabledStateFunction>,
      NetworkingPrivateSetWifiTDLSEnabledStateFunction::function_name(),
      NetworkingPrivateSetWifiTDLSEnabledStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetWifiTDLSStatusFunction>,
      NetworkingPrivateGetWifiTDLSStatusFunction::function_name(),
      NetworkingPrivateGetWifiTDLSStatusFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetCaptivePortalStatusFunction>,
      NetworkingPrivateGetCaptivePortalStatusFunction::function_name(),
      NetworkingPrivateGetCaptivePortalStatusFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateUnlockCellularSimFunction>,
      NetworkingPrivateUnlockCellularSimFunction::function_name(),
      NetworkingPrivateUnlockCellularSimFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSetCellularSimStateFunction>,
      NetworkingPrivateSetCellularSimStateFunction::function_name(),
      NetworkingPrivateSetCellularSimStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateSelectCellularMobileNetworkFunction>,
      NetworkingPrivateSelectCellularMobileNetworkFunction::function_name(),
      NetworkingPrivateSelectCellularMobileNetworkFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetGlobalPolicyFunction>,
      NetworkingPrivateGetGlobalPolicyFunction::function_name(),
      NetworkingPrivateGetGlobalPolicyFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<NetworkingPrivateGetCertificateListsFunction>,
      NetworkingPrivateGetCertificateListsFunction::function_name(),
      NetworkingPrivateGetCertificateListsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PowerRequestKeepAwakeFunction>,
      PowerRequestKeepAwakeFunction::function_name(),
      PowerRequestKeepAwakeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PowerReleaseKeepAwakeFunction>,
      PowerReleaseKeepAwakeFunction::function_name(),
      PowerReleaseKeepAwakeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrintersFunction>,
      PrinterProviderInternalReportPrintersFunction::function_name(),
      PrinterProviderInternalReportPrintersFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportUsbPrinterInfoFunction>,
      PrinterProviderInternalReportUsbPrinterInfoFunction::function_name(),
      PrinterProviderInternalReportUsbPrinterInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrinterCapabilityFunction>,
      PrinterProviderInternalReportPrinterCapabilityFunction::function_name(),
      PrinterProviderInternalReportPrinterCapabilityFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalReportPrintResultFunction>,
      PrinterProviderInternalReportPrintResultFunction::function_name(),
      PrinterProviderInternalReportPrintResultFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<PrinterProviderInternalGetPrintDataFunction>,
      PrinterProviderInternalGetPrintDataFunction::function_name(),
      PrinterProviderInternalGetPrintDataFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetBackgroundPageFunction>,
      RuntimeGetBackgroundPageFunction::function_name(),
      RuntimeGetBackgroundPageFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeOpenOptionsPageFunction>,
      RuntimeOpenOptionsPageFunction::function_name(),
      RuntimeOpenOptionsPageFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeSetUninstallURLFunction>,
      RuntimeSetUninstallURLFunction::function_name(),
      RuntimeSetUninstallURLFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeReloadFunction>,
      RuntimeReloadFunction::function_name(),
      RuntimeReloadFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRequestUpdateCheckFunction>,
      RuntimeRequestUpdateCheckFunction::function_name(),
      RuntimeRequestUpdateCheckFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRestartFunction>,
      RuntimeRestartFunction::function_name(),
      RuntimeRestartFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeRestartAfterDelayFunction>,
      RuntimeRestartAfterDelayFunction::function_name(),
      RuntimeRestartAfterDelayFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetPlatformInfoFunction>,
      RuntimeGetPlatformInfoFunction::function_name(),
      RuntimeGetPlatformInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<RuntimeGetPackageDirectoryEntryFunction>,
      RuntimeGetPackageDirectoryEntryFunction::function_name(),
      RuntimeGetPackageDirectoryEntryFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetDevicesFunction>,
      SerialGetDevicesFunction::function_name(),
      SerialGetDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialConnectFunction>,
      SerialConnectFunction::function_name(),
      SerialConnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialUpdateFunction>,
      SerialUpdateFunction::function_name(),
      SerialUpdateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialDisconnectFunction>,
      SerialDisconnectFunction::function_name(),
      SerialDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetPausedFunction>,
      SerialSetPausedFunction::function_name(),
      SerialSetPausedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetInfoFunction>,
      SerialGetInfoFunction::function_name(),
      SerialGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetConnectionsFunction>,
      SerialGetConnectionsFunction::function_name(),
      SerialGetConnectionsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSendFunction>,
      SerialSendFunction::function_name(),
      SerialSendFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialFlushFunction>,
      SerialFlushFunction::function_name(),
      SerialFlushFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialGetControlSignalsFunction>,
      SerialGetControlSignalsFunction::function_name(),
      SerialGetControlSignalsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetControlSignalsFunction>,
      SerialSetControlSignalsFunction::function_name(),
      SerialSetControlSignalsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialSetBreakFunction>,
      SerialSetBreakFunction::function_name(),
      SerialSetBreakFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SerialClearBreakFunction>,
      SerialClearBreakFunction::function_name(),
      SerialClearBreakFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketCreateFunction>,
      SocketCreateFunction::function_name(),
      SocketCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketDestroyFunction>,
      SocketDestroyFunction::function_name(),
      SocketDestroyFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketConnectFunction>,
      SocketConnectFunction::function_name(),
      SocketConnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketBindFunction>,
      SocketBindFunction::function_name(),
      SocketBindFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketDisconnectFunction>,
      SocketDisconnectFunction::function_name(),
      SocketDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketReadFunction>,
      SocketReadFunction::function_name(),
      SocketReadFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketWriteFunction>,
      SocketWriteFunction::function_name(),
      SocketWriteFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketRecvFromFunction>,
      SocketRecvFromFunction::function_name(),
      SocketRecvFromFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSendToFunction>,
      SocketSendToFunction::function_name(),
      SocketSendToFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketListenFunction>,
      SocketListenFunction::function_name(),
      SocketListenFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketAcceptFunction>,
      SocketAcceptFunction::function_name(),
      SocketAcceptFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetKeepAliveFunction>,
      SocketSetKeepAliveFunction::function_name(),
      SocketSetKeepAliveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetNoDelayFunction>,
      SocketSetNoDelayFunction::function_name(),
      SocketSetNoDelayFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetInfoFunction>,
      SocketGetInfoFunction::function_name(),
      SocketGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetNetworkListFunction>,
      SocketGetNetworkListFunction::function_name(),
      SocketGetNetworkListFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketJoinGroupFunction>,
      SocketJoinGroupFunction::function_name(),
      SocketJoinGroupFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketLeaveGroupFunction>,
      SocketLeaveGroupFunction::function_name(),
      SocketLeaveGroupFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetMulticastTimeToLiveFunction>,
      SocketSetMulticastTimeToLiveFunction::function_name(),
      SocketSetMulticastTimeToLiveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSetMulticastLoopbackModeFunction>,
      SocketSetMulticastLoopbackModeFunction::function_name(),
      SocketSetMulticastLoopbackModeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketGetJoinedGroupsFunction>,
      SocketGetJoinedGroupsFunction::function_name(),
      SocketGetJoinedGroupsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketSecureFunction>,
      SocketSecureFunction::function_name(),
      SocketSecureFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpCreateFunction>,
      SocketsTcpCreateFunction::function_name(),
      SocketsTcpCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpUpdateFunction>,
      SocketsTcpUpdateFunction::function_name(),
      SocketsTcpUpdateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetPausedFunction>,
      SocketsTcpSetPausedFunction::function_name(),
      SocketsTcpSetPausedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetKeepAliveFunction>,
      SocketsTcpSetKeepAliveFunction::function_name(),
      SocketsTcpSetKeepAliveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSetNoDelayFunction>,
      SocketsTcpSetNoDelayFunction::function_name(),
      SocketsTcpSetNoDelayFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpConnectFunction>,
      SocketsTcpConnectFunction::function_name(),
      SocketsTcpConnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpDisconnectFunction>,
      SocketsTcpDisconnectFunction::function_name(),
      SocketsTcpDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSecureFunction>,
      SocketsTcpSecureFunction::function_name(),
      SocketsTcpSecureFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpSendFunction>,
      SocketsTcpSendFunction::function_name(),
      SocketsTcpSendFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpCloseFunction>,
      SocketsTcpCloseFunction::function_name(),
      SocketsTcpCloseFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpGetInfoFunction>,
      SocketsTcpGetInfoFunction::function_name(),
      SocketsTcpGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpGetSocketsFunction>,
      SocketsTcpGetSocketsFunction::function_name(),
      SocketsTcpGetSocketsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerCreateFunction>,
      SocketsTcpServerCreateFunction::function_name(),
      SocketsTcpServerCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerUpdateFunction>,
      SocketsTcpServerUpdateFunction::function_name(),
      SocketsTcpServerUpdateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerSetPausedFunction>,
      SocketsTcpServerSetPausedFunction::function_name(),
      SocketsTcpServerSetPausedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerListenFunction>,
      SocketsTcpServerListenFunction::function_name(),
      SocketsTcpServerListenFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerDisconnectFunction>,
      SocketsTcpServerDisconnectFunction::function_name(),
      SocketsTcpServerDisconnectFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerCloseFunction>,
      SocketsTcpServerCloseFunction::function_name(),
      SocketsTcpServerCloseFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerGetInfoFunction>,
      SocketsTcpServerGetInfoFunction::function_name(),
      SocketsTcpServerGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsTcpServerGetSocketsFunction>,
      SocketsTcpServerGetSocketsFunction::function_name(),
      SocketsTcpServerGetSocketsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpCreateFunction>,
      SocketsUdpCreateFunction::function_name(),
      SocketsUdpCreateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpUpdateFunction>,
      SocketsUdpUpdateFunction::function_name(),
      SocketsUdpUpdateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetPausedFunction>,
      SocketsUdpSetPausedFunction::function_name(),
      SocketsUdpSetPausedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpBindFunction>,
      SocketsUdpBindFunction::function_name(),
      SocketsUdpBindFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSendFunction>,
      SocketsUdpSendFunction::function_name(),
      SocketsUdpSendFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpCloseFunction>,
      SocketsUdpCloseFunction::function_name(),
      SocketsUdpCloseFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetInfoFunction>,
      SocketsUdpGetInfoFunction::function_name(),
      SocketsUdpGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetSocketsFunction>,
      SocketsUdpGetSocketsFunction::function_name(),
      SocketsUdpGetSocketsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpJoinGroupFunction>,
      SocketsUdpJoinGroupFunction::function_name(),
      SocketsUdpJoinGroupFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpLeaveGroupFunction>,
      SocketsUdpLeaveGroupFunction::function_name(),
      SocketsUdpLeaveGroupFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetMulticastTimeToLiveFunction>,
      SocketsUdpSetMulticastTimeToLiveFunction::function_name(),
      SocketsUdpSetMulticastTimeToLiveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetMulticastLoopbackModeFunction>,
      SocketsUdpSetMulticastLoopbackModeFunction::function_name(),
      SocketsUdpSetMulticastLoopbackModeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpGetJoinedGroupsFunction>,
      SocketsUdpGetJoinedGroupsFunction::function_name(),
      SocketsUdpGetJoinedGroupsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SocketsUdpSetBroadcastFunction>,
      SocketsUdpSetBroadcastFunction::function_name(),
      SocketsUdpSetBroadcastFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaGetFunction>,
      StorageStorageAreaGetFunction::function_name(),
      StorageStorageAreaGetFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaGetBytesInUseFunction>,
      StorageStorageAreaGetBytesInUseFunction::function_name(),
      StorageStorageAreaGetBytesInUseFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaSetFunction>,
      StorageStorageAreaSetFunction::function_name(),
      StorageStorageAreaSetFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaRemoveFunction>,
      StorageStorageAreaRemoveFunction::function_name(),
      StorageStorageAreaRemoveFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<StorageStorageAreaClearFunction>,
      StorageStorageAreaClearFunction::function_name(),
      StorageStorageAreaClearFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemCpuGetInfoFunction>,
      SystemCpuGetInfoFunction::function_name(),
      SystemCpuGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayGetInfoFunction>,
      SystemDisplayGetInfoFunction::function_name(),
      SystemDisplayGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayGetDisplayLayoutFunction>,
      SystemDisplayGetDisplayLayoutFunction::function_name(),
      SystemDisplayGetDisplayLayoutFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetDisplayPropertiesFunction>,
      SystemDisplaySetDisplayPropertiesFunction::function_name(),
      SystemDisplaySetDisplayPropertiesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetDisplayLayoutFunction>,
      SystemDisplaySetDisplayLayoutFunction::function_name(),
      SystemDisplaySetDisplayLayoutFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayEnableUnifiedDesktopFunction>,
      SystemDisplayEnableUnifiedDesktopFunction::function_name(),
      SystemDisplayEnableUnifiedDesktopFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationStartFunction>,
      SystemDisplayOverscanCalibrationStartFunction::function_name(),
      SystemDisplayOverscanCalibrationStartFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationAdjustFunction>,
      SystemDisplayOverscanCalibrationAdjustFunction::function_name(),
      SystemDisplayOverscanCalibrationAdjustFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationResetFunction>,
      SystemDisplayOverscanCalibrationResetFunction::function_name(),
      SystemDisplayOverscanCalibrationResetFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayOverscanCalibrationCompleteFunction>,
      SystemDisplayOverscanCalibrationCompleteFunction::function_name(),
      SystemDisplayOverscanCalibrationCompleteFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayShowNativeTouchCalibrationFunction>,
      SystemDisplayShowNativeTouchCalibrationFunction::function_name(),
      SystemDisplayShowNativeTouchCalibrationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayStartCustomTouchCalibrationFunction>,
      SystemDisplayStartCustomTouchCalibrationFunction::function_name(),
      SystemDisplayStartCustomTouchCalibrationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayCompleteCustomTouchCalibrationFunction>,
      SystemDisplayCompleteCustomTouchCalibrationFunction::function_name(),
      SystemDisplayCompleteCustomTouchCalibrationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplayClearTouchCalibrationFunction>,
      SystemDisplayClearTouchCalibrationFunction::function_name(),
      SystemDisplayClearTouchCalibrationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemDisplaySetMirrorModeFunction>,
      SystemDisplaySetMirrorModeFunction::function_name(),
      SystemDisplaySetMirrorModeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemMemoryGetInfoFunction>,
      SystemMemoryGetInfoFunction::function_name(),
      SystemMemoryGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemNetworkGetNetworkInterfacesFunction>,
      SystemNetworkGetNetworkInterfacesFunction::function_name(),
      SystemNetworkGetNetworkInterfacesFunction::histogram_value(),
    },
    #if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<SystemPowerSourceGetPowerSourceInfoFunction>,
      SystemPowerSourceGetPowerSourceInfoFunction::function_name(),
      SystemPowerSourceGetPowerSourceInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemPowerSourceRequestStatusUpdateFunction>,
      SystemPowerSourceRequestStatusUpdateFunction::function_name(),
      SystemPowerSourceRequestStatusUpdateFunction::histogram_value(),
    },
    #endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<SystemStorageGetInfoFunction>,
      SystemStorageGetInfoFunction::function_name(),
      SystemStorageGetInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemStorageEjectDeviceFunction>,
      SystemStorageEjectDeviceFunction::function_name(),
      SystemStorageEjectDeviceFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<SystemStorageGetAvailableCapacityFunction>,
      SystemStorageGetAvailableCapacityFunction::function_name(),
      SystemStorageGetAvailableCapacityFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestGetConfigFunction>,
      TestGetConfigFunction::function_name(),
      TestGetConfigFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestNotifyFailFunction>,
      TestNotifyFailFunction::function_name(),
      TestNotifyFailFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestNotifyPassFunction>,
      TestNotifyPassFunction::function_name(),
      TestNotifyPassFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestLogFunction>,
      TestLogFunction::function_name(),
      TestLogFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestSendMessageFunction>,
      TestSendMessageFunction::function_name(),
      TestSendMessageFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<TestWaitForRoundTripFunction>,
      TestWaitForRoundTripFunction::function_name(),
      TestWaitForRoundTripFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetDevicesFunction>,
      UsbGetDevicesFunction::function_name(),
      UsbGetDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetUserSelectedDevicesFunction>,
      UsbGetUserSelectedDevicesFunction::function_name(),
      UsbGetUserSelectedDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetConfigurationsFunction>,
      UsbGetConfigurationsFunction::function_name(),
      UsbGetConfigurationsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbRequestAccessFunction>,
      UsbRequestAccessFunction::function_name(),
      UsbRequestAccessFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbOpenDeviceFunction>,
      UsbOpenDeviceFunction::function_name(),
      UsbOpenDeviceFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbFindDevicesFunction>,
      UsbFindDevicesFunction::function_name(),
      UsbFindDevicesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbCloseDeviceFunction>,
      UsbCloseDeviceFunction::function_name(),
      UsbCloseDeviceFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbSetConfigurationFunction>,
      UsbSetConfigurationFunction::function_name(),
      UsbSetConfigurationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbGetConfigurationFunction>,
      UsbGetConfigurationFunction::function_name(),
      UsbGetConfigurationFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbListInterfacesFunction>,
      UsbListInterfacesFunction::function_name(),
      UsbListInterfacesFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbClaimInterfaceFunction>,
      UsbClaimInterfaceFunction::function_name(),
      UsbClaimInterfaceFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbReleaseInterfaceFunction>,
      UsbReleaseInterfaceFunction::function_name(),
      UsbReleaseInterfaceFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbSetInterfaceAlternateSettingFunction>,
      UsbSetInterfaceAlternateSettingFunction::function_name(),
      UsbSetInterfaceAlternateSettingFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbControlTransferFunction>,
      UsbControlTransferFunction::function_name(),
      UsbControlTransferFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbBulkTransferFunction>,
      UsbBulkTransferFunction::function_name(),
      UsbBulkTransferFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbInterruptTransferFunction>,
      UsbInterruptTransferFunction::function_name(),
      UsbInterruptTransferFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbIsochronousTransferFunction>,
      UsbIsochronousTransferFunction::function_name(),
      UsbIsochronousTransferFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<UsbResetDeviceFunction>,
      UsbResetDeviceFunction::function_name(),
      UsbResetDeviceFunction::histogram_value(),
    },
    #if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<VirtualKeyboardRestrictFeaturesFunction>,
      VirtualKeyboardRestrictFeaturesFunction::function_name(),
      VirtualKeyboardRestrictFeaturesFunction::histogram_value(),
    },
    #endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    #if (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<VirtualKeyboardPrivateInsertTextFunction>,
      VirtualKeyboardPrivateInsertTextFunction::function_name(),
      VirtualKeyboardPrivateInsertTextFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSendKeyEventFunction>,
      VirtualKeyboardPrivateSendKeyEventFunction::function_name(),
      VirtualKeyboardPrivateSendKeyEventFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateHideKeyboardFunction>,
      VirtualKeyboardPrivateHideKeyboardFunction::function_name(),
      VirtualKeyboardPrivateHideKeyboardFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetHotrodKeyboardFunction>,
      VirtualKeyboardPrivateSetHotrodKeyboardFunction::function_name(),
      VirtualKeyboardPrivateSetHotrodKeyboardFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateLockKeyboardFunction>,
      VirtualKeyboardPrivateLockKeyboardFunction::function_name(),
      VirtualKeyboardPrivateLockKeyboardFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateKeyboardLoadedFunction>,
      VirtualKeyboardPrivateKeyboardLoadedFunction::function_name(),
      VirtualKeyboardPrivateKeyboardLoadedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateGetKeyboardConfigFunction>,
      VirtualKeyboardPrivateGetKeyboardConfigFunction::function_name(),
      VirtualKeyboardPrivateGetKeyboardConfigFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateOpenSettingsFunction>,
      VirtualKeyboardPrivateOpenSettingsFunction::function_name(),
      VirtualKeyboardPrivateOpenSettingsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetContainerBehaviorFunction>,
      VirtualKeyboardPrivateSetContainerBehaviorFunction::function_name(),
      VirtualKeyboardPrivateSetContainerBehaviorFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetDraggableAreaFunction>,
      VirtualKeyboardPrivateSetDraggableAreaFunction::function_name(),
      VirtualKeyboardPrivateSetDraggableAreaFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetKeyboardStateFunction>,
      VirtualKeyboardPrivateSetKeyboardStateFunction::function_name(),
      VirtualKeyboardPrivateSetKeyboardStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetOccludedBoundsFunction>,
      VirtualKeyboardPrivateSetOccludedBoundsFunction::function_name(),
      VirtualKeyboardPrivateSetOccludedBoundsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetHitTestBoundsFunction>,
      VirtualKeyboardPrivateSetHitTestBoundsFunction::function_name(),
      VirtualKeyboardPrivateSetHitTestBoundsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction>,
      VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction::function_name(),
      VirtualKeyboardPrivateSetAreaToRemainOnScreenFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<VirtualKeyboardPrivateSetWindowBoundsInScreenFunction>,
      VirtualKeyboardPrivateSetWindowBoundsInScreenFunction::function_name(),
      VirtualKeyboardPrivateSetWindowBoundsInScreenFunction::histogram_value(),
    },
    #endif  // (defined(OS_CHROMEOS) && !BUILDFLAG(IS_LACROS))
    {
      &NewExtensionFunction<WebRequestHandlerBehaviorChangedFunction>,
      WebRequestHandlerBehaviorChangedFunction::function_name(),
      WebRequestHandlerBehaviorChangedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGetAudioStateFunction>,
      WebViewInternalGetAudioStateFunction::function_name(),
      WebViewInternalGetAudioStateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAudioMutedFunction>,
      WebViewInternalSetAudioMutedFunction::function_name(),
      WebViewInternalSetAudioMutedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalIsAudioMutedFunction>,
      WebViewInternalIsAudioMutedFunction::function_name(),
      WebViewInternalIsAudioMutedFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalExecuteScriptFunction>,
      WebViewInternalExecuteScriptFunction::function_name(),
      WebViewInternalExecuteScriptFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalInsertCSSFunction>,
      WebViewInternalInsertCSSFunction::function_name(),
      WebViewInternalInsertCSSFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalAddContentScriptsFunction>,
      WebViewInternalAddContentScriptsFunction::function_name(),
      WebViewInternalAddContentScriptsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalRemoveContentScriptsFunction>,
      WebViewInternalRemoveContentScriptsFunction::function_name(),
      WebViewInternalRemoveContentScriptsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetZoomFunction>,
      WebViewInternalSetZoomFunction::function_name(),
      WebViewInternalSetZoomFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGetZoomFunction>,
      WebViewInternalGetZoomFunction::function_name(),
      WebViewInternalGetZoomFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetZoomModeFunction>,
      WebViewInternalSetZoomModeFunction::function_name(),
      WebViewInternalSetZoomModeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGetZoomModeFunction>,
      WebViewInternalGetZoomModeFunction::function_name(),
      WebViewInternalGetZoomModeFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalFindFunction>,
      WebViewInternalFindFunction::function_name(),
      WebViewInternalFindFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalStopFindingFunction>,
      WebViewInternalStopFindingFunction::function_name(),
      WebViewInternalStopFindingFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalLoadDataWithBaseUrlFunction>,
      WebViewInternalLoadDataWithBaseUrlFunction::function_name(),
      WebViewInternalLoadDataWithBaseUrlFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalGoFunction>,
      WebViewInternalGoFunction::function_name(),
      WebViewInternalGoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalOverrideUserAgentFunction>,
      WebViewInternalOverrideUserAgentFunction::function_name(),
      WebViewInternalOverrideUserAgentFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalReloadFunction>,
      WebViewInternalReloadFunction::function_name(),
      WebViewInternalReloadFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAllowTransparencyFunction>,
      WebViewInternalSetAllowTransparencyFunction::function_name(),
      WebViewInternalSetAllowTransparencyFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetAllowScalingFunction>,
      WebViewInternalSetAllowScalingFunction::function_name(),
      WebViewInternalSetAllowScalingFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetNameFunction>,
      WebViewInternalSetNameFunction::function_name(),
      WebViewInternalSetNameFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetPermissionFunction>,
      WebViewInternalSetPermissionFunction::function_name(),
      WebViewInternalSetPermissionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalNavigateFunction>,
      WebViewInternalNavigateFunction::function_name(),
      WebViewInternalNavigateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalStopFunction>,
      WebViewInternalStopFunction::function_name(),
      WebViewInternalStopFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalTerminateFunction>,
      WebViewInternalTerminateFunction::function_name(),
      WebViewInternalTerminateFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalCaptureVisibleRegionFunction>,
      WebViewInternalCaptureVisibleRegionFunction::function_name(),
      WebViewInternalCaptureVisibleRegionFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalSetSpatialNavigationEnabledFunction>,
      WebViewInternalSetSpatialNavigationEnabledFunction::function_name(),
      WebViewInternalSetSpatialNavigationEnabledFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalIsSpatialNavigationEnabledFunction>,
      WebViewInternalIsSpatialNavigationEnabledFunction::function_name(),
      WebViewInternalIsSpatialNavigationEnabledFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebViewInternalClearDataFunction>,
      WebViewInternalClearDataFunction::function_name(),
      WebViewInternalClearDataFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebRequestInternalAddEventListenerFunction>,
      WebRequestInternalAddEventListenerFunction::function_name(),
      WebRequestInternalAddEventListenerFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebRequestInternalEventHandledFunction>,
      WebRequestInternalEventHandledFunction::function_name(),
      WebRequestInternalEventHandledFunction::histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
