
/* Copyright © 2015-2021 Intel Corporation
 * Copyright © 2021 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_commands_gen.py, don't edit directly. */

#define VK_PROTOTYPES
#include <vulkan/vulkan.h>

#include "lvp_private.h"
#include "pipe/p_context.h"
#include "vk_util.h"

VKAPI_ATTR void VKAPI_CALL lvp_CmdBindPipeline (VkCommandBuffer commandBuffer
, VkPipelineBindPoint pipelineBindPoint
, VkPipeline pipeline
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_pipeline(&cmd_buffer->queue
, pipelineBindPoint
, pipeline
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetViewport (VkCommandBuffer commandBuffer
, uint32_t firstViewport
, uint32_t viewportCount
, const VkViewport* pViewports
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_viewport(&cmd_buffer->queue
, firstViewport
, viewportCount
, pViewports
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetScissor (VkCommandBuffer commandBuffer
, uint32_t firstScissor
, uint32_t scissorCount
, const VkRect2D* pScissors
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_scissor(&cmd_buffer->queue
, firstScissor
, scissorCount
, pScissors
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetLineWidth (VkCommandBuffer commandBuffer
, float lineWidth
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_line_width(&cmd_buffer->queue
, lineWidth
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthBias (VkCommandBuffer commandBuffer
, float depthBiasConstantFactor
, float depthBiasClamp
, float depthBiasSlopeFactor
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_bias(&cmd_buffer->queue
, depthBiasConstantFactor
, depthBiasClamp
, depthBiasSlopeFactor
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetBlendConstants (VkCommandBuffer commandBuffer
, const float blendConstants[4]
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_blend_constants(&cmd_buffer->queue
, blendConstants
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthBounds (VkCommandBuffer commandBuffer
, float minDepthBounds
, float maxDepthBounds
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_bounds(&cmd_buffer->queue
, minDepthBounds
, maxDepthBounds
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetStencilCompareMask (VkCommandBuffer commandBuffer
, VkStencilFaceFlags faceMask
, uint32_t compareMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_stencil_compare_mask(&cmd_buffer->queue
, faceMask
, compareMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetStencilWriteMask (VkCommandBuffer commandBuffer
, VkStencilFaceFlags faceMask
, uint32_t writeMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_stencil_write_mask(&cmd_buffer->queue
, faceMask
, writeMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetStencilReference (VkCommandBuffer commandBuffer
, VkStencilFaceFlags faceMask
, uint32_t reference
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_stencil_reference(&cmd_buffer->queue
, faceMask
, reference
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindIndexBuffer (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, VkIndexType indexType
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_index_buffer(&cmd_buffer->queue
, buffer
, offset
, indexType
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindVertexBuffers (VkCommandBuffer commandBuffer
, uint32_t firstBinding
, uint32_t bindingCount
, const VkBuffer* pBuffers
, const VkDeviceSize* pOffsets
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_vertex_buffers(&cmd_buffer->queue
, firstBinding
, bindingCount
, pBuffers
, pOffsets
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDraw (VkCommandBuffer commandBuffer
, uint32_t vertexCount
, uint32_t instanceCount
, uint32_t firstVertex
, uint32_t firstInstance
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw(&cmd_buffer->queue
, vertexCount
, instanceCount
, firstVertex
, firstInstance
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndexed (VkCommandBuffer commandBuffer
, uint32_t indexCount
, uint32_t instanceCount
, uint32_t firstIndex
, int32_t vertexOffset
, uint32_t firstInstance
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indexed(&cmd_buffer->queue
, indexCount
, instanceCount
, firstIndex
, vertexOffset
, firstInstance
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndirect (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, uint32_t drawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indirect(&cmd_buffer->queue
, buffer
, offset
, drawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndexedIndirect (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, uint32_t drawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indexed_indirect(&cmd_buffer->queue
, buffer
, offset
, drawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDispatch (VkCommandBuffer commandBuffer
, uint32_t groupCountX
, uint32_t groupCountY
, uint32_t groupCountZ
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_dispatch(&cmd_buffer->queue
, groupCountX
, groupCountY
, groupCountZ
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDispatchIndirect (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_dispatch_indirect(&cmd_buffer->queue
, buffer
, offset
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSubpassShadingHUAWEI (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_subpass_shading_huawei(&cmd_buffer->queue
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdUpdateBuffer (VkCommandBuffer commandBuffer
, VkBuffer dstBuffer
, VkDeviceSize dstOffset
, VkDeviceSize dataSize
, const void* pData
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_update_buffer(&cmd_buffer->queue
, dstBuffer
, dstOffset
, dataSize
, pData
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdFillBuffer (VkCommandBuffer commandBuffer
, VkBuffer dstBuffer
, VkDeviceSize dstOffset
, VkDeviceSize size
, uint32_t data
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_fill_buffer(&cmd_buffer->queue
, dstBuffer
, dstOffset
, size
, data
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdClearColorImage (VkCommandBuffer commandBuffer
, VkImage image
, VkImageLayout imageLayout
, const VkClearColorValue* pColor
, uint32_t rangeCount
, const VkImageSubresourceRange* pRanges
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_clear_color_image(&cmd_buffer->queue
, image
, imageLayout
, pColor
, rangeCount
, pRanges
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdClearDepthStencilImage (VkCommandBuffer commandBuffer
, VkImage image
, VkImageLayout imageLayout
, const VkClearDepthStencilValue* pDepthStencil
, uint32_t rangeCount
, const VkImageSubresourceRange* pRanges
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_clear_depth_stencil_image(&cmd_buffer->queue
, image
, imageLayout
, pDepthStencil
, rangeCount
, pRanges
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdClearAttachments (VkCommandBuffer commandBuffer
, uint32_t attachmentCount
, const VkClearAttachment* pAttachments
, uint32_t rectCount
, const VkClearRect* pRects
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_clear_attachments(&cmd_buffer->queue
, attachmentCount
, pAttachments
, rectCount
, pRects
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetEvent (VkCommandBuffer commandBuffer
, VkEvent event
, VkPipelineStageFlags stageMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_event(&cmd_buffer->queue
, event
, stageMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdResetEvent (VkCommandBuffer commandBuffer
, VkEvent event
, VkPipelineStageFlags stageMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_reset_event(&cmd_buffer->queue
, event
, stageMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWaitEvents (VkCommandBuffer commandBuffer
, uint32_t eventCount
, const VkEvent* pEvents
, VkPipelineStageFlags srcStageMask
, VkPipelineStageFlags dstStageMask
, uint32_t memoryBarrierCount
, const VkMemoryBarrier* pMemoryBarriers
, uint32_t bufferMemoryBarrierCount
, const VkBufferMemoryBarrier* pBufferMemoryBarriers
, uint32_t imageMemoryBarrierCount
, const VkImageMemoryBarrier* pImageMemoryBarriers
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_wait_events(&cmd_buffer->queue
, eventCount
, pEvents
, srcStageMask
, dstStageMask
, memoryBarrierCount
, pMemoryBarriers
, bufferMemoryBarrierCount
, pBufferMemoryBarriers
, imageMemoryBarrierCount
, pImageMemoryBarriers
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdPipelineBarrier (VkCommandBuffer commandBuffer
, VkPipelineStageFlags srcStageMask
, VkPipelineStageFlags dstStageMask
, VkDependencyFlags dependencyFlags
, uint32_t memoryBarrierCount
, const VkMemoryBarrier* pMemoryBarriers
, uint32_t bufferMemoryBarrierCount
, const VkBufferMemoryBarrier* pBufferMemoryBarriers
, uint32_t imageMemoryBarrierCount
, const VkImageMemoryBarrier* pImageMemoryBarriers
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_pipeline_barrier(&cmd_buffer->queue
, srcStageMask
, dstStageMask
, dependencyFlags
, memoryBarrierCount
, pMemoryBarriers
, bufferMemoryBarrierCount
, pBufferMemoryBarriers
, imageMemoryBarrierCount
, pImageMemoryBarriers
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginQuery (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t query
, VkQueryControlFlags flags
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_query(&cmd_buffer->queue
, queryPool
, query
, flags
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndQuery (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t query
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_query(&cmd_buffer->queue
, queryPool
, query
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginConditionalRenderingEXT (VkCommandBuffer commandBuffer
, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_conditional_rendering_ext(&cmd_buffer->queue
, pConditionalRenderingBegin
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndConditionalRenderingEXT (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_conditional_rendering_ext(&cmd_buffer->queue
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdResetQueryPool (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t firstQuery
, uint32_t queryCount
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_reset_query_pool(&cmd_buffer->queue
, queryPool
, firstQuery
, queryCount
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteTimestamp (VkCommandBuffer commandBuffer
, VkPipelineStageFlagBits pipelineStage
, VkQueryPool queryPool
, uint32_t query
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_timestamp(&cmd_buffer->queue
, pipelineStage
, queryPool
, query
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyQueryPoolResults (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t firstQuery
, uint32_t queryCount
, VkBuffer dstBuffer
, VkDeviceSize dstOffset
, VkDeviceSize stride
, VkQueryResultFlags flags
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_query_pool_results(&cmd_buffer->queue
, queryPool
, firstQuery
, queryCount
, dstBuffer
, dstOffset
, stride
, flags
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdPushConstants (VkCommandBuffer commandBuffer
, VkPipelineLayout layout
, VkShaderStageFlags stageFlags
, uint32_t offset
, uint32_t size
, const void* pValues
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_push_constants(&cmd_buffer->queue
, layout
, stageFlags
, offset
, size
, pValues
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginRenderPass (VkCommandBuffer commandBuffer
, const VkRenderPassBeginInfo* pRenderPassBegin
, VkSubpassContents contents
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_render_pass(&cmd_buffer->queue
, pRenderPassBegin
, contents
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdNextSubpass (VkCommandBuffer commandBuffer
, VkSubpassContents contents
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_next_subpass(&cmd_buffer->queue
, contents
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndRenderPass (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_render_pass(&cmd_buffer->queue
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdExecuteCommands (VkCommandBuffer commandBuffer
, uint32_t commandBufferCount
, const VkCommandBuffer* pCommandBuffers
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_execute_commands(&cmd_buffer->queue
, commandBufferCount
, pCommandBuffers
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDebugMarkerBeginEXT (VkCommandBuffer commandBuffer
, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_debug_marker_begin_ext(&cmd_buffer->queue
, pMarkerInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDebugMarkerEndEXT (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_debug_marker_end_ext(&cmd_buffer->queue
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDebugMarkerInsertEXT (VkCommandBuffer commandBuffer
, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_debug_marker_insert_ext(&cmd_buffer->queue
, pMarkerInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdExecuteGeneratedCommandsNV (VkCommandBuffer commandBuffer
, VkBool32 isPreprocessed
, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_execute_generated_commands_nv(&cmd_buffer->queue
, isPreprocessed
, pGeneratedCommandsInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdPreprocessGeneratedCommandsNV (VkCommandBuffer commandBuffer
, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_preprocess_generated_commands_nv(&cmd_buffer->queue
, pGeneratedCommandsInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindPipelineShaderGroupNV (VkCommandBuffer commandBuffer
, VkPipelineBindPoint pipelineBindPoint
, VkPipeline pipeline
, uint32_t groupIndex
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_pipeline_shader_group_nv(&cmd_buffer->queue
, pipelineBindPoint
, pipeline
, groupIndex
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDeviceMask (VkCommandBuffer commandBuffer
, uint32_t deviceMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_device_mask(&cmd_buffer->queue
, deviceMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDispatchBase (VkCommandBuffer commandBuffer
, uint32_t baseGroupX
, uint32_t baseGroupY
, uint32_t baseGroupZ
, uint32_t groupCountX
, uint32_t groupCountY
, uint32_t groupCountZ
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_dispatch_base(&cmd_buffer->queue
, baseGroupX
, baseGroupY
, baseGroupZ
, groupCountX
, groupCountY
, groupCountZ
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetViewportWScalingNV (VkCommandBuffer commandBuffer
, uint32_t firstViewport
, uint32_t viewportCount
, const VkViewportWScalingNV* pViewportWScalings
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_viewport_wscaling_nv(&cmd_buffer->queue
, firstViewport
, viewportCount
, pViewportWScalings
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDiscardRectangleEXT (VkCommandBuffer commandBuffer
, uint32_t firstDiscardRectangle
, uint32_t discardRectangleCount
, const VkRect2D* pDiscardRectangles
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_discard_rectangle_ext(&cmd_buffer->queue
, firstDiscardRectangle
, discardRectangleCount
, pDiscardRectangles
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetSampleLocationsEXT (VkCommandBuffer commandBuffer
, const VkSampleLocationsInfoEXT* pSampleLocationsInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_sample_locations_ext(&cmd_buffer->queue
, pSampleLocationsInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginDebugUtilsLabelEXT (VkCommandBuffer commandBuffer
, const VkDebugUtilsLabelEXT* pLabelInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_debug_utils_label_ext(&cmd_buffer->queue
, pLabelInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndDebugUtilsLabelEXT (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_debug_utils_label_ext(&cmd_buffer->queue
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdInsertDebugUtilsLabelEXT (VkCommandBuffer commandBuffer
, const VkDebugUtilsLabelEXT* pLabelInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_insert_debug_utils_label_ext(&cmd_buffer->queue
, pLabelInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteBufferMarkerAMD (VkCommandBuffer commandBuffer
, VkPipelineStageFlagBits pipelineStage
, VkBuffer dstBuffer
, VkDeviceSize dstOffset
, uint32_t marker
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_buffer_marker_amd(&cmd_buffer->queue
, pipelineStage
, dstBuffer
, dstOffset
, marker
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginRenderPass2 (VkCommandBuffer commandBuffer
, const VkRenderPassBeginInfo*      pRenderPassBegin
, const VkSubpassBeginInfo*      pSubpassBeginInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_render_pass2(&cmd_buffer->queue
, pRenderPassBegin
, pSubpassBeginInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdNextSubpass2 (VkCommandBuffer commandBuffer
, const VkSubpassBeginInfo*      pSubpassBeginInfo
, const VkSubpassEndInfo*        pSubpassEndInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_next_subpass2(&cmd_buffer->queue
, pSubpassBeginInfo
, pSubpassEndInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndRenderPass2 (VkCommandBuffer commandBuffer
, const VkSubpassEndInfo*        pSubpassEndInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_render_pass2(&cmd_buffer->queue
, pSubpassEndInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndirectCount (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, VkBuffer countBuffer
, VkDeviceSize countBufferOffset
, uint32_t maxDrawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indirect_count(&cmd_buffer->queue
, buffer
, offset
, countBuffer
, countBufferOffset
, maxDrawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndexedIndirectCount (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, VkBuffer countBuffer
, VkDeviceSize countBufferOffset
, uint32_t maxDrawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indexed_indirect_count(&cmd_buffer->queue
, buffer
, offset
, countBuffer
, countBufferOffset
, maxDrawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetCheckpointNV (VkCommandBuffer commandBuffer
, const void* pCheckpointMarker
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_checkpoint_nv(&cmd_buffer->queue
, pCheckpointMarker
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindTransformFeedbackBuffersEXT (VkCommandBuffer commandBuffer
, uint32_t firstBinding
, uint32_t bindingCount
, const VkBuffer* pBuffers
, const VkDeviceSize* pOffsets
, const VkDeviceSize* pSizes
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_transform_feedback_buffers_ext(&cmd_buffer->queue
, firstBinding
, bindingCount
, pBuffers
, pOffsets
, pSizes
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginTransformFeedbackEXT (VkCommandBuffer commandBuffer
, uint32_t firstCounterBuffer
, uint32_t counterBufferCount
, const VkBuffer* pCounterBuffers
, const VkDeviceSize* pCounterBufferOffsets
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_transform_feedback_ext(&cmd_buffer->queue
, firstCounterBuffer
, counterBufferCount
, pCounterBuffers
, pCounterBufferOffsets
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndTransformFeedbackEXT (VkCommandBuffer commandBuffer
, uint32_t firstCounterBuffer
, uint32_t counterBufferCount
, const VkBuffer* pCounterBuffers
, const VkDeviceSize* pCounterBufferOffsets
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_transform_feedback_ext(&cmd_buffer->queue
, firstCounterBuffer
, counterBufferCount
, pCounterBuffers
, pCounterBufferOffsets
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginQueryIndexedEXT (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t query
, VkQueryControlFlags flags
, uint32_t index
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_query_indexed_ext(&cmd_buffer->queue
, queryPool
, query
, flags
, index
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndQueryIndexedEXT (VkCommandBuffer commandBuffer
, VkQueryPool queryPool
, uint32_t query
, uint32_t index
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_query_indexed_ext(&cmd_buffer->queue
, queryPool
, query
, index
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawIndirectByteCountEXT (VkCommandBuffer commandBuffer
, uint32_t instanceCount
, uint32_t firstInstance
, VkBuffer counterBuffer
, VkDeviceSize counterBufferOffset
, uint32_t counterOffset
, uint32_t vertexStride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_indirect_byte_count_ext(&cmd_buffer->queue
, instanceCount
, firstInstance
, counterBuffer
, counterBufferOffset
, counterOffset
, vertexStride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetExclusiveScissorNV (VkCommandBuffer commandBuffer
, uint32_t firstExclusiveScissor
, uint32_t exclusiveScissorCount
, const VkRect2D* pExclusiveScissors
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_exclusive_scissor_nv(&cmd_buffer->queue
, firstExclusiveScissor
, exclusiveScissorCount
, pExclusiveScissors
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindShadingRateImageNV (VkCommandBuffer commandBuffer
, VkImageView imageView
, VkImageLayout imageLayout
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_shading_rate_image_nv(&cmd_buffer->queue
, imageView
, imageLayout
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetViewportShadingRatePaletteNV (VkCommandBuffer commandBuffer
, uint32_t firstViewport
, uint32_t viewportCount
, const VkShadingRatePaletteNV* pShadingRatePalettes
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_viewport_shading_rate_palette_nv(&cmd_buffer->queue
, firstViewport
, viewportCount
, pShadingRatePalettes
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetCoarseSampleOrderNV (VkCommandBuffer commandBuffer
, VkCoarseSampleOrderTypeNV sampleOrderType
, uint32_t customSampleOrderCount
, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_coarse_sample_order_nv(&cmd_buffer->queue
, sampleOrderType
, customSampleOrderCount
, pCustomSampleOrders
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawMeshTasksNV (VkCommandBuffer commandBuffer
, uint32_t taskCount
, uint32_t firstTask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_mesh_tasks_nv(&cmd_buffer->queue
, taskCount
, firstTask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawMeshTasksIndirectNV (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, uint32_t drawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_mesh_tasks_indirect_nv(&cmd_buffer->queue
, buffer
, offset
, drawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdDrawMeshTasksIndirectCountNV (VkCommandBuffer commandBuffer
, VkBuffer buffer
, VkDeviceSize offset
, VkBuffer countBuffer
, VkDeviceSize countBufferOffset
, uint32_t maxDrawCount
, uint32_t stride
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_draw_mesh_tasks_indirect_count_nv(&cmd_buffer->queue
, buffer
, offset
, countBuffer
, countBufferOffset
, maxDrawCount
, stride
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindInvocationMaskHUAWEI (VkCommandBuffer commandBuffer
, VkImageView imageView
, VkImageLayout imageLayout
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_invocation_mask_huawei(&cmd_buffer->queue
, imageView
, imageLayout
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyAccelerationStructureNV (VkCommandBuffer commandBuffer
, VkAccelerationStructureNV dst
, VkAccelerationStructureNV src
, VkCopyAccelerationStructureModeKHR mode
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_acceleration_structure_nv(&cmd_buffer->queue
, dst
, src
, mode
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyAccelerationStructureKHR (VkCommandBuffer commandBuffer
, const VkCopyAccelerationStructureInfoKHR* pInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_acceleration_structure_khr(&cmd_buffer->queue
, pInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyAccelerationStructureToMemoryKHR (VkCommandBuffer commandBuffer
, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_acceleration_structure_to_memory_khr(&cmd_buffer->queue
, pInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyMemoryToAccelerationStructureKHR (VkCommandBuffer commandBuffer
, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_memory_to_acceleration_structure_khr(&cmd_buffer->queue
, pInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteAccelerationStructuresPropertiesKHR (VkCommandBuffer commandBuffer
, uint32_t accelerationStructureCount
, const VkAccelerationStructureKHR* pAccelerationStructures
, VkQueryType queryType
, VkQueryPool queryPool
, uint32_t firstQuery
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_acceleration_structures_properties_khr(&cmd_buffer->queue
, accelerationStructureCount
, pAccelerationStructures
, queryType
, queryPool
, firstQuery
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteAccelerationStructuresPropertiesNV (VkCommandBuffer commandBuffer
, uint32_t accelerationStructureCount
, const VkAccelerationStructureNV* pAccelerationStructures
, VkQueryType queryType
, VkQueryPool queryPool
, uint32_t firstQuery
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_acceleration_structures_properties_nv(&cmd_buffer->queue
, accelerationStructureCount
, pAccelerationStructures
, queryType
, queryPool
, firstQuery
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBuildAccelerationStructureNV (VkCommandBuffer commandBuffer
, const VkAccelerationStructureInfoNV* pInfo
, VkBuffer instanceData
, VkDeviceSize instanceOffset
, VkBool32 update
, VkAccelerationStructureNV dst
, VkAccelerationStructureNV src
, VkBuffer scratch
, VkDeviceSize scratchOffset
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_build_acceleration_structure_nv(&cmd_buffer->queue
, pInfo
, instanceData
, instanceOffset
, update
, dst
, src
, scratch
, scratchOffset
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdTraceRaysKHR (VkCommandBuffer commandBuffer
, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable
, uint32_t width
, uint32_t height
, uint32_t depth
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_trace_rays_khr(&cmd_buffer->queue
, pRaygenShaderBindingTable
, pMissShaderBindingTable
, pHitShaderBindingTable
, pCallableShaderBindingTable
, width
, height
, depth
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdTraceRaysNV (VkCommandBuffer commandBuffer
, VkBuffer raygenShaderBindingTableBuffer
, VkDeviceSize raygenShaderBindingOffset
, VkBuffer missShaderBindingTableBuffer
, VkDeviceSize missShaderBindingOffset
, VkDeviceSize missShaderBindingStride
, VkBuffer hitShaderBindingTableBuffer
, VkDeviceSize hitShaderBindingOffset
, VkDeviceSize hitShaderBindingStride
, VkBuffer callableShaderBindingTableBuffer
, VkDeviceSize callableShaderBindingOffset
, VkDeviceSize callableShaderBindingStride
, uint32_t width
, uint32_t height
, uint32_t depth
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_trace_rays_nv(&cmd_buffer->queue
, raygenShaderBindingTableBuffer
, raygenShaderBindingOffset
, missShaderBindingTableBuffer
, missShaderBindingOffset
, missShaderBindingStride
, hitShaderBindingTableBuffer
, hitShaderBindingOffset
, hitShaderBindingStride
, callableShaderBindingTableBuffer
, callableShaderBindingOffset
, callableShaderBindingStride
, width
, height
, depth
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdTraceRaysIndirectKHR (VkCommandBuffer commandBuffer
, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable
, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable
, VkDeviceAddress indirectDeviceAddress
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_trace_rays_indirect_khr(&cmd_buffer->queue
, pRaygenShaderBindingTable
, pMissShaderBindingTable
, pHitShaderBindingTable
, pCallableShaderBindingTable
, indirectDeviceAddress
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetRayTracingPipelineStackSizeKHR (VkCommandBuffer commandBuffer
, uint32_t pipelineStackSize
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_ray_tracing_pipeline_stack_size_khr(&cmd_buffer->queue
, pipelineStackSize
   );

}
VKAPI_ATTR VkResult VKAPI_CALL lvp_CmdSetPerformanceMarkerINTEL (VkCommandBuffer commandBuffer
, const VkPerformanceMarkerInfoINTEL* pMarkerInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_performance_marker_intel(&cmd_buffer->queue
, pMarkerInfo
   );

   return VK_SUCCESS;
}
VKAPI_ATTR VkResult VKAPI_CALL lvp_CmdSetPerformanceStreamMarkerINTEL (VkCommandBuffer commandBuffer
, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_performance_stream_marker_intel(&cmd_buffer->queue
, pMarkerInfo
   );

   return VK_SUCCESS;
}
VKAPI_ATTR VkResult VKAPI_CALL lvp_CmdSetPerformanceOverrideINTEL (VkCommandBuffer commandBuffer
, const VkPerformanceOverrideInfoINTEL* pOverrideInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_performance_override_intel(&cmd_buffer->queue
, pOverrideInfo
   );

   return VK_SUCCESS;
}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetLineStippleEXT (VkCommandBuffer commandBuffer
, uint32_t lineStippleFactor
, uint16_t lineStipplePattern
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_line_stipple_ext(&cmd_buffer->queue
, lineStippleFactor
, lineStipplePattern
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBuildAccelerationStructuresKHR (VkCommandBuffer commandBuffer
, uint32_t infoCount
, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos
, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_build_acceleration_structures_khr(&cmd_buffer->queue
, infoCount
, pInfos
, ppBuildRangeInfos
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBuildAccelerationStructuresIndirectKHR (VkCommandBuffer commandBuffer
, uint32_t                                           infoCount
, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos
, const VkDeviceAddress*             pIndirectDeviceAddresses
, const uint32_t*                    pIndirectStrides
, const uint32_t* const*             ppMaxPrimitiveCounts
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_build_acceleration_structures_indirect_khr(&cmd_buffer->queue
, infoCount
, pInfos
, pIndirectDeviceAddresses
, pIndirectStrides
, ppMaxPrimitiveCounts
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetCullMode (VkCommandBuffer commandBuffer
, VkCullModeFlags cullMode
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_cull_mode(&cmd_buffer->queue
, cullMode
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetFrontFace (VkCommandBuffer commandBuffer
, VkFrontFace frontFace
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_front_face(&cmd_buffer->queue
, frontFace
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetPrimitiveTopology (VkCommandBuffer commandBuffer
, VkPrimitiveTopology primitiveTopology
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_primitive_topology(&cmd_buffer->queue
, primitiveTopology
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetViewportWithCount (VkCommandBuffer commandBuffer
, uint32_t viewportCount
, const VkViewport* pViewports
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_viewport_with_count(&cmd_buffer->queue
, viewportCount
, pViewports
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetScissorWithCount (VkCommandBuffer commandBuffer
, uint32_t scissorCount
, const VkRect2D* pScissors
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_scissor_with_count(&cmd_buffer->queue
, scissorCount
, pScissors
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBindVertexBuffers2 (VkCommandBuffer commandBuffer
, uint32_t firstBinding
, uint32_t bindingCount
, const VkBuffer* pBuffers
, const VkDeviceSize* pOffsets
, const VkDeviceSize* pSizes
, const VkDeviceSize* pStrides
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_bind_vertex_buffers2(&cmd_buffer->queue
, firstBinding
, bindingCount
, pBuffers
, pOffsets
, pSizes
, pStrides
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthTestEnable (VkCommandBuffer commandBuffer
, VkBool32 depthTestEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_test_enable(&cmd_buffer->queue
, depthTestEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthWriteEnable (VkCommandBuffer commandBuffer
, VkBool32 depthWriteEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_write_enable(&cmd_buffer->queue
, depthWriteEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthCompareOp (VkCommandBuffer commandBuffer
, VkCompareOp depthCompareOp
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_compare_op(&cmd_buffer->queue
, depthCompareOp
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthBoundsTestEnable (VkCommandBuffer commandBuffer
, VkBool32 depthBoundsTestEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_bounds_test_enable(&cmd_buffer->queue
, depthBoundsTestEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetStencilTestEnable (VkCommandBuffer commandBuffer
, VkBool32 stencilTestEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_stencil_test_enable(&cmd_buffer->queue
, stencilTestEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetStencilOp (VkCommandBuffer commandBuffer
, VkStencilFaceFlags faceMask
, VkStencilOp failOp
, VkStencilOp passOp
, VkStencilOp depthFailOp
, VkCompareOp compareOp
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_stencil_op(&cmd_buffer->queue
, faceMask
, failOp
, passOp
, depthFailOp
, compareOp
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetPatchControlPointsEXT (VkCommandBuffer commandBuffer
, uint32_t patchControlPoints
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_patch_control_points_ext(&cmd_buffer->queue
, patchControlPoints
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetRasterizerDiscardEnable (VkCommandBuffer commandBuffer
, VkBool32 rasterizerDiscardEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_rasterizer_discard_enable(&cmd_buffer->queue
, rasterizerDiscardEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetDepthBiasEnable (VkCommandBuffer commandBuffer
, VkBool32 depthBiasEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_depth_bias_enable(&cmd_buffer->queue
, depthBiasEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetLogicOpEXT (VkCommandBuffer commandBuffer
, VkLogicOp logicOp
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_logic_op_ext(&cmd_buffer->queue
, logicOp
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetPrimitiveRestartEnable (VkCommandBuffer commandBuffer
, VkBool32 primitiveRestartEnable
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_primitive_restart_enable(&cmd_buffer->queue
, primitiveRestartEnable
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyBuffer2 (VkCommandBuffer commandBuffer
, const VkCopyBufferInfo2* pCopyBufferInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_buffer2(&cmd_buffer->queue
, pCopyBufferInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyImage2 (VkCommandBuffer commandBuffer
, const VkCopyImageInfo2* pCopyImageInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_image2(&cmd_buffer->queue
, pCopyImageInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdBlitImage2 (VkCommandBuffer commandBuffer
, const VkBlitImageInfo2* pBlitImageInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_blit_image2(&cmd_buffer->queue
, pBlitImageInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyBufferToImage2 (VkCommandBuffer commandBuffer
, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_buffer_to_image2(&cmd_buffer->queue
, pCopyBufferToImageInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdCopyImageToBuffer2 (VkCommandBuffer commandBuffer
, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_copy_image_to_buffer2(&cmd_buffer->queue
, pCopyImageToBufferInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdResolveImage2 (VkCommandBuffer commandBuffer
, const VkResolveImageInfo2* pResolveImageInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_resolve_image2(&cmd_buffer->queue
, pResolveImageInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetFragmentShadingRateKHR (VkCommandBuffer commandBuffer
, const VkExtent2D*                           pFragmentSize
, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_fragment_shading_rate_khr(&cmd_buffer->queue
, pFragmentSize
, combinerOps
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetFragmentShadingRateEnumNV (VkCommandBuffer commandBuffer
, VkFragmentShadingRateNV                     shadingRate
, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_fragment_shading_rate_enum_nv(&cmd_buffer->queue
, shadingRate
, combinerOps
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetVertexInputEXT (VkCommandBuffer commandBuffer
, uint32_t vertexBindingDescriptionCount
, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions
, uint32_t vertexAttributeDescriptionCount
, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_vertex_input_ext(&cmd_buffer->queue
, vertexBindingDescriptionCount
, pVertexBindingDescriptions
, vertexAttributeDescriptionCount
, pVertexAttributeDescriptions
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetColorWriteEnableEXT (VkCommandBuffer commandBuffer
, uint32_t                                attachmentCount
, const VkBool32*   pColorWriteEnables
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_color_write_enable_ext(&cmd_buffer->queue
, attachmentCount
, pColorWriteEnables
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdSetEvent2 (VkCommandBuffer commandBuffer
, VkEvent                                             event
, const VkDependencyInfo*                             pDependencyInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_set_event2(&cmd_buffer->queue
, event
, pDependencyInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdResetEvent2 (VkCommandBuffer commandBuffer
, VkEvent                                             event
, VkPipelineStageFlags2               stageMask
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_reset_event2(&cmd_buffer->queue
, event
, stageMask
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWaitEvents2 (VkCommandBuffer commandBuffer
, uint32_t                                            eventCount
, const VkEvent*                     pEvents
, const VkDependencyInfo*            pDependencyInfos
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_wait_events2(&cmd_buffer->queue
, eventCount
, pEvents
, pDependencyInfos
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdPipelineBarrier2 (VkCommandBuffer commandBuffer
, const VkDependencyInfo*                             pDependencyInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_pipeline_barrier2(&cmd_buffer->queue
, pDependencyInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteTimestamp2 (VkCommandBuffer commandBuffer
, VkPipelineStageFlags2               stage
, VkQueryPool                                         queryPool
, uint32_t                                            query
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_timestamp2(&cmd_buffer->queue
, stage
, queryPool
, query
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdWriteBufferMarker2AMD (VkCommandBuffer commandBuffer
, VkPipelineStageFlags2               stage
, VkBuffer                                            dstBuffer
, VkDeviceSize                                        dstOffset
, uint32_t                                            marker
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_write_buffer_marker2_amd(&cmd_buffer->queue
, stage
, dstBuffer
, dstOffset
, marker
   );

}
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdDecodeVideoKHR (VkCommandBuffer commandBuffer
, const VkVideoDecodeInfoKHR* pFrameInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_decode_video_khr(&cmd_buffer->queue
, pFrameInfo
   );

}
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdBeginVideoCodingKHR (VkCommandBuffer commandBuffer
, const VkVideoBeginCodingInfoKHR* pBeginInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_begin_video_coding_khr(&cmd_buffer->queue
, pBeginInfo
   );

}
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdControlVideoCodingKHR (VkCommandBuffer commandBuffer
, const VkVideoCodingControlInfoKHR* pCodingControlInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_control_video_coding_khr(&cmd_buffer->queue
, pCodingControlInfo
   );

}
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndVideoCodingKHR (VkCommandBuffer commandBuffer
, const VkVideoEndCodingInfoKHR* pEndCodingInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_video_coding_khr(&cmd_buffer->queue
, pEndCodingInfo
   );

}
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdEncodeVideoKHR (VkCommandBuffer commandBuffer
, const VkVideoEncodeInfoKHR* pEncodeInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_encode_video_khr(&cmd_buffer->queue
, pEncodeInfo
   );

}
#endif // VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL lvp_CmdCuLaunchKernelNVX (VkCommandBuffer commandBuffer
, const VkCuLaunchInfoNVX* pLaunchInfo
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_cu_launch_kernel_nvx(&cmd_buffer->queue
, pLaunchInfo
   );

}
VKAPI_ATTR void VKAPI_CALL lvp_CmdEndRendering (VkCommandBuffer commandBuffer
)
{
   LVP_FROM_HANDLE(lvp_cmd_buffer, cmd_buffer, commandBuffer);

   vk_enqueue_cmd_end_rendering(&cmd_buffer->queue
   );

}

