/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.factory;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;
import sun.reflect.generics.scope.Scope;
import sun.reflect.generics.tree.FieldTypeSignature;

public class CoreReflectionFactory
implements GenericsFactory {
    private final GenericDeclaration decl;
    private final Scope scope;

    private CoreReflectionFactory(GenericDeclaration genericDeclaration, Scope scope) {
        this.decl = genericDeclaration;
        this.scope = scope;
    }

    private GenericDeclaration getDecl() {
        return this.decl;
    }

    private Scope getScope() {
        return this.scope;
    }

    private ClassLoader getDeclsLoader() {
        if (this.decl instanceof Class) {
            return ((Class)this.decl).getClassLoader();
        }
        if (this.decl instanceof Method) {
            return ((Method)this.decl).getDeclaringClass().getClassLoader();
        }
        assert (this.decl instanceof Constructor) : "Constructor expected";
        return ((Constructor)this.decl).getDeclaringClass().getClassLoader();
    }

    public static CoreReflectionFactory make(GenericDeclaration genericDeclaration, Scope scope) {
        return new CoreReflectionFactory(genericDeclaration, scope);
    }

    @Override
    public TypeVariable<?> makeTypeVariable(String string, FieldTypeSignature[] fieldTypeSignatureArray) {
        return TypeVariableImpl.make(this.getDecl(), string, fieldTypeSignatureArray, this);
    }

    @Override
    public WildcardType makeWildcard(FieldTypeSignature[] fieldTypeSignatureArray, FieldTypeSignature[] fieldTypeSignatureArray2) {
        return WildcardTypeImpl.make(fieldTypeSignatureArray, fieldTypeSignatureArray2, this);
    }

    @Override
    public ParameterizedType makeParameterizedType(Type type, Type[] typeArray, Type type2) {
        return ParameterizedTypeImpl.make((Class)type, typeArray, type2);
    }

    @Override
    public TypeVariable<?> findTypeVariable(String string) {
        return this.getScope().lookup(string);
    }

    @Override
    public Type makeNamedType(String string) {
        try {
            return Class.forName(string, false, this.getDeclsLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
    }

    @Override
    public Type makeArrayType(Type type) {
        if (type instanceof Class) {
            return Array.newInstance((Class)type, 0).getClass();
        }
        return GenericArrayTypeImpl.make(type);
    }

    @Override
    public Type makeByte() {
        return Byte.TYPE;
    }

    @Override
    public Type makeBool() {
        return Boolean.TYPE;
    }

    @Override
    public Type makeShort() {
        return Short.TYPE;
    }

    @Override
    public Type makeChar() {
        return Character.TYPE;
    }

    @Override
    public Type makeInt() {
        return Integer.TYPE;
    }

    @Override
    public Type makeLong() {
        return Long.TYPE;
    }

    @Override
    public Type makeFloat() {
        return Float.TYPE;
    }

    @Override
    public Type makeDouble() {
        return Double.TYPE;
    }

    @Override
    public Type makeVoid() {
        return Void.TYPE;
    }
}

