/* contacts-contact-editor.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-contact-editor.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2019 Purism SPC
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <adwaita.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include "contacts.h"

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_EDITOR (contacts_contact_editor_get_type ())
#define CONTACTS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor))
#define CONTACTS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))
#define CONTACTS_IS_CONTACT_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_IS_CONTACT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_EDITOR))
#define CONTACTS_CONTACT_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditorClass))

typedef struct _ContactsContactEditor ContactsContactEditor;
typedef struct _ContactsContactEditorClass ContactsContactEditorClass;
typedef struct _ContactsContactEditorPrivate ContactsContactEditorPrivate;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
enum  {
	CONTACTS_CONTACT_EDITOR_0_PROPERTY,
	CONTACTS_CONTACT_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_editor_properties[CONTACTS_CONTACT_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_EDITOR_PERSONA (contacts_editor_persona_get_type ())
#define CONTACTS_EDITOR_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_EDITOR_PERSONA, ContactsEditorPersona))
#define CONTACTS_EDITOR_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_EDITOR_PERSONA, ContactsEditorPersonaClass))
#define CONTACTS_IS_EDITOR_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_EDITOR_PERSONA))
#define CONTACTS_IS_EDITOR_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_EDITOR_PERSONA))
#define CONTACTS_EDITOR_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_EDITOR_PERSONA, ContactsEditorPersonaClass))

typedef struct _ContactsEditorPersona ContactsEditorPersona;
typedef struct _ContactsEditorPersonaClass ContactsEditorPersonaClass;

#define CONTACTS_TYPE_AVATAR_SELECTOR (contacts_avatar_selector_get_type ())
#define CONTACTS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelector))
#define CONTACTS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))
#define CONTACTS_IS_AVATAR_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_IS_AVATAR_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_SELECTOR))
#define CONTACTS_AVATAR_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_SELECTOR, ContactsAvatarSelectorClass))

typedef struct _ContactsAvatarSelector ContactsAvatarSelector;
typedef struct _ContactsAvatarSelectorClass ContactsAvatarSelectorClass;
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ContactsContactEditor {
	GtkBox parent_instance;
	ContactsContactEditorPrivate * priv;
};

struct _ContactsContactEditorClass {
	GtkBoxClass parent_class;
};

struct _ContactsContactEditorPrivate {
	FolksIndividual* individual;
	GtkEntry* name_entry;
	ContactsAvatar* avatar;
};

struct _Block11Data {
	int _ref_count_;
	ContactsContactEditor* self;
	ContactsAvatarSelector* avatar_selector;
};

static gint ContactsContactEditor_private_offset;
static gpointer contacts_contact_editor_parent_class = NULL;

VALA_EXTERN GType contacts_contact_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactEditor, g_object_unref)
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_new (FolksIndividual* individual,
                                                    FolksIndividualAggregator* aggregator);
VALA_EXTERN ContactsContactEditor* contacts_contact_editor_construct (GType object_type,
                                                          FolksIndividual* individual,
                                                          FolksIndividualAggregator* aggregator);
static GtkWidget* contacts_contact_editor_create_avatar_button (ContactsContactEditor* self);
static GtkWidget* contacts_contact_editor_create_name_entry (ContactsContactEditor* self);
VALA_EXTERN ContactsEditorPersona* contacts_editor_persona_new (FolksPersona* persona,
                                                    FolksIndividualAggregator* aggregator);
VALA_EXTERN ContactsEditorPersona* contacts_editor_persona_construct (GType object_type,
                                                          FolksPersona* persona,
                                                          FolksIndividualAggregator* aggregator);
VALA_EXTERN GType contacts_editor_persona_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsEditorPersona, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
static void contacts_contact_editor_on_avatar_button_clicked (ContactsContactEditor* self,
                                                       GtkButton* avatar_button);
static void _contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
VALA_EXTERN GType contacts_avatar_selector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatarSelector, g_object_unref)
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_new (FolksIndividual* individual,
                                                      GtkWindow* window);
VALA_EXTERN ContactsAvatarSelector* contacts_avatar_selector_construct (GType object_type,
                                                            FolksIndividual* individual,
                                                            GtkWindow* window);
static void __lambda18_ (Block11Data* _data11_,
                  gint response);
VALA_EXTERN void contacts_avatar_selector_save_selection (ContactsAvatarSelector* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void contacts_avatar_selector_save_selection_finish (ContactsAvatarSelector* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void ___lambda19_ (Block11Data* _data11_,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN void contacts_avatar_set_pixbuf (ContactsAvatar* self,
                                 GdkPixbuf* a_pixbuf);
VALA_EXTERN GdkPixbuf* contacts_avatar_selector_get_selected_avatar (ContactsAvatarSelector* self);
static void ____lambda19__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void __lambda20_ (ContactsContactEditor* self);
static void ___lambda20__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static GObject * contacts_contact_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void contacts_contact_editor_finalize (GObject * obj);
static GType contacts_contact_editor_get_type_once (void);

static inline gpointer
contacts_contact_editor_get_instance_private (ContactsContactEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactEditor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsContactEditor*
contacts_contact_editor_construct (GType object_type,
                                   FolksIndividual* individual,
                                   FolksIndividualAggregator* aggregator)
{
	ContactsContactEditor * self = NULL;
	FolksIndividual* _tmp0_;
	GtkBox* header = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkBox* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkBox* _tmp8_;
	g_return_val_if_fail (individual != NULL, NULL);
	g_return_val_if_fail (aggregator != NULL, NULL);
	self = (ContactsContactEditor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (individual);
	_g_object_unref0 (self->priv->individual);
	self->priv->individual = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp1_);
	header = _tmp1_;
	_tmp2_ = header;
	_tmp3_ = contacts_contact_editor_create_avatar_button (self);
	_tmp4_ = _tmp3_;
	gtk_box_append (_tmp2_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = header;
	_tmp6_ = contacts_contact_editor_create_name_entry (self);
	_tmp7_ = _tmp6_;
	gtk_box_append (_tmp5_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = header;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp8_);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp9_;
		GeeSet* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp9_ = folks_individual_get_personas (individual);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_p_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			FolksPersona* _tmp15_;
			ContactsEditorPersona* _tmp16_;
			ContactsEditorPersona* _tmp17_;
			_tmp12_ = _p_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _p_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			p = (FolksPersona*) _tmp14_;
			_tmp15_ = p;
			_tmp16_ = contacts_editor_persona_new (_tmp15_, aggregator);
			g_object_ref_sink (_tmp16_);
			_tmp17_ = _tmp16_;
			gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp17_);
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_g_object_unref0 (header);
	return self;
}

ContactsContactEditor*
contacts_contact_editor_new (FolksIndividual* individual,
                             FolksIndividualAggregator* aggregator)
{
	return contacts_contact_editor_construct (CONTACTS_TYPE_CONTACT_EDITOR, individual, aggregator);
}

static void
_contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	contacts_contact_editor_on_avatar_button_clicked ((ContactsContactEditor*) self, _sender);
}

static GtkWidget*
contacts_contact_editor_create_avatar_button (ContactsContactEditor* self)
{
	ContactsAvatar* avatar = NULL;
	FolksIndividual* _tmp0_;
	ContactsAvatar* _tmp1_;
	GtkButton* button = NULL;
	GtkButton* _tmp2_;
	ContactsAvatar* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->individual;
	_tmp1_ = contacts_avatar_new (PROFILE_SIZE, _tmp0_);
	g_object_ref_sink (_tmp1_);
	avatar = _tmp1_;
	self->priv->avatar = avatar;
	_tmp2_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp2_);
	button = _tmp2_;
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _ ("Change avatar"));
	_tmp3_ = self->priv->avatar;
	gtk_button_set_child (button, (GtkWidget*) _tmp3_);
	g_signal_connect_object (button, "clicked", (GCallback) _contacts_contact_editor_on_avatar_button_clicked_gtk_button_clicked, self, 0);
	result = (GtkWidget*) button;
	_g_object_unref0 (avatar);
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ContactsContactEditor* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->avatar_selector);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda19_ (Block11Data* _data11_,
              GObject* obj,
              GAsyncResult* res)
{
	ContactsContactEditor* self;
	GError* _inner_error0_ = NULL;
	self = _data11_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsAvatar* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		contacts_avatar_selector_save_selection_finish (_data11_->avatar_selector, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = self->priv->avatar;
		_tmp1_ = contacts_avatar_selector_get_selected_avatar (_data11_->avatar_selector);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		contacts_avatar_set_pixbuf (_tmp0_, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GtkRoot* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("contacts-contact-editor.vala:74: Failed to set avatar: %s", _tmp5_);
		_tmp6_ = gtk_widget_get_root ((GtkWidget*) self);
		contacts_utils_show_error_dialog (_ ("Failed to set avatar."), G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp6_) : NULL);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda19__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda19_ (self, source_object, res);
	block11_data_unref (self);
}

static void
__lambda18_ (Block11Data* _data11_,
             gint response)
{
	ContactsContactEditor* self;
	self = _data11_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		contacts_avatar_selector_save_selection (_data11_->avatar_selector, ____lambda19__gasync_ready_callback, block11_data_ref (_data11_));
	}
	gtk_window_destroy ((GtkWindow*) _data11_->avatar_selector);
}

static void
___lambda18__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda18_ (self, response_id);
}

static void
contacts_contact_editor_on_avatar_button_clicked (ContactsContactEditor* self,
                                                  GtkButton* avatar_button)
{
	Block11Data* _data11_;
	FolksIndividual* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsAvatarSelector* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (avatar_button != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = self->priv->individual;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = contacts_avatar_selector_new (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
	g_object_ref_sink (_tmp2_);
	_data11_->avatar_selector = _tmp2_;
	g_signal_connect_data ((GtkDialog*) _data11_->avatar_selector, "response", (GCallback) ___lambda18__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data11_->avatar_selector);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
__lambda20_ (ContactsContactEditor* self)
{
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->priv->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksNameDetails* name_p = NULL;
			FolksPersona* _tmp7_;
			FolksNameDetails* _tmp8_;
			_tmp4_ = _p_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			p = (FolksPersona*) _tmp6_;
			_tmp7_ = p;
			name_p = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _tmp7_) : NULL;
			_tmp8_ = name_p;
			if (_tmp8_ != NULL) {
				FolksNameDetails* _tmp9_;
				GtkEntry* _tmp10_;
				const gchar* _tmp11_;
				_tmp9_ = name_p;
				_tmp10_ = self->priv->name_entry;
				_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
				folks_name_details_set_full_name (_tmp9_, _tmp11_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}

static void
___lambda20__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda20_ ((ContactsContactEditor*) self);
}

static GtkWidget*
contacts_contact_editor_create_name_entry (ContactsContactEditor* self)
{
	FolksNameDetails* name = NULL;
	FolksIndividual* _tmp0_;
	FolksNameDetails* _tmp1_;
	GtkEntry* entry = NULL;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->individual;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _tmp0_) : NULL);
	name = _tmp1_;
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp2_);
	entry = _tmp2_;
	self->priv->name_entry = entry;
	_tmp3_ = self->priv->name_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->name_entry;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	_tmp5_ = self->priv->name_entry;
	gtk_entry_set_input_purpose (_tmp5_, GTK_INPUT_PURPOSE_NAME);
	_tmp6_ = self->priv->name_entry;
	gtk_entry_set_placeholder_text (_tmp6_, _ ("Add name"));
	_tmp7_ = self->priv->name_entry;
	_tmp8_ = folks_name_details_get_full_name (name);
	_tmp9_ = _tmp8_;
	gtk_editable_set_text ((GtkEditable*) _tmp7_, _tmp9_);
	_tmp10_ = self->priv->name_entry;
	g_signal_connect_object ((GtkEditable*) _tmp10_, "changed", (GCallback) ___lambda20__gtk_editable_changed, self, 0);
	_tmp11_ = self->priv->name_entry;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (entry);
	_g_object_unref0 (name);
	return result;
}

static GObject *
contacts_contact_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactEditor * self;
	parent_class = G_OBJECT_CLASS (contacts_contact_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-contact-editor");
	return obj;
}

static void
contacts_contact_editor_class_init (ContactsContactEditorClass * klass,
                                    gpointer klass_data)
{
	contacts_contact_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactEditor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_editor_finalize;
}

static void
contacts_contact_editor_instance_init (ContactsContactEditor * self,
                                       gpointer klass)
{
	self->priv = contacts_contact_editor_get_instance_private (self);
}

static void
contacts_contact_editor_finalize (GObject * obj)
{
	ContactsContactEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_EDITOR, ContactsContactEditor);
	_g_object_unref0 (self->priv->individual);
	G_OBJECT_CLASS (contacts_contact_editor_parent_class)->finalize (obj);
}

/**
 * A widget that allows the user to edit a given {@link Contact}.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactEditor), 0, (GInstanceInitFunc) contacts_contact_editor_instance_init, NULL };
	GType contacts_contact_editor_type_id;
	contacts_contact_editor_type_id = g_type_register_static (gtk_box_get_type (), "ContactsContactEditor", &g_define_type_info, 0);
	ContactsContactEditor_private_offset = g_type_add_instance_private (contacts_contact_editor_type_id, sizeof (ContactsContactEditorPrivate));
	return contacts_contact_editor_type_id;
}

GType
contacts_contact_editor_get_type (void)
{
	static volatile gsize contacts_contact_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_editor_type_id__once)) {
		GType contacts_contact_editor_type_id;
		contacts_contact_editor_type_id = contacts_contact_editor_get_type_once ();
		g_once_init_leave (&contacts_contact_editor_type_id__once, contacts_contact_editor_type_id);
	}
	return contacts_contact_editor_type_id__once;
}

