/* currency.c generated by valac 0.56.0, the Vala compiler
 * generated from currency.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

enum  {
	CURRENCY_MANAGER_0_PROPERTY,
	CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY,
	CURRENCY_MANAGER_LOADED_PROPERTY,
	CURRENCY_MANAGER_NUM_PROPERTIES
};
static GParamSpec* currency_manager_properties[CURRENCY_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CURRENCY_MANAGER_UPDATED_SIGNAL,
	CURRENCY_MANAGER_NUM_SIGNALS
};
static guint currency_manager_signals[CURRENCY_MANAGER_NUM_SIGNALS] = {0};
enum  {
	CURRENCY_0_PROPERTY,
	CURRENCY_NAME_PROPERTY,
	CURRENCY_DISPLAY_NAME_PROPERTY,
	CURRENCY_SYMBOL_PROPERTY,
	CURRENCY_SOURCE_PROPERTY,
	CURRENCY_NUM_PROPERTIES
};
static GParamSpec* currency_properties[CURRENCY_NUM_PROPERTIES];

struct _CurrencyManagerPrivate {
	GList* currencies;
	GList* providers;
	gint _refresh_interval;
	gboolean _loaded;
};

struct _CurrencyPrivate {
	Number* value;
	gchar* _name;
	gchar* _display_name;
	gchar* _symbol;
	gchar* _source;
};

VALA_EXTERN CurrencyManager* default_currency_manager;
CurrencyManager* default_currency_manager = NULL;
static gint CurrencyManager_private_offset;
static gpointer currency_manager_parent_class = NULL;
static gint Currency_private_offset;
static gpointer currency_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void currency_manager_set_loaded (CurrencyManager* self,
                                  gboolean value);
static void currency_manager_update (CurrencyManager* self);
static void ____lambda9_ (CurrencyManager* self);
static void _____lambda9__currency_provider_updated (CurrencyProvider* _sender,
                                              gpointer self);
static void _vala_array_add1 (Currency** * array,
                       gint* length,
                       gint* size,
                       Currency* value);
static void currency_manager_finalize (GObject * obj);
static GType currency_manager_get_type_once (void);
static void _vala_currency_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_currency_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void currency_finalize (GObject * obj);
static GType currency_get_type_once (void);
static void _vala_currency_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_currency_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

static inline gpointer
currency_manager_get_instance_private (CurrencyManager* self)
{
	return G_STRUCT_MEMBER_P (self, CurrencyManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
currency_manager_add_provider (CurrencyManager* self,
                               CurrencyProvider* provider)
{
	CurrencyProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (provider != NULL);
	_tmp0_ = _g_object_ref0 (provider);
	self->priv->providers = g_list_append (self->priv->providers, _tmp0_);
}

void
currency_manager_refresh_sync (CurrencyManager* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	currency_manager_set_loaded (self, FALSE);
	_tmp0_ = self->priv->providers;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			CurrencyProvider* _tmp1_;
			CurrencyProvider* p = NULL;
			_tmp1_ = _g_object_ref0 ((CurrencyProvider*) p_it->data);
			p = _tmp1_;
			{
				CurrencyProvider* _tmp2_;
				_tmp2_ = p;
				currency_provider_set_refresh_interval (_tmp2_, self->priv->_refresh_interval, FALSE);
				_g_object_unref0 (p);
			}
		}
	}
}

void
currency_manager_refresh_async (CurrencyManager* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	currency_manager_set_loaded (self, FALSE);
	_tmp0_ = self->priv->providers;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			CurrencyProvider* _tmp1_;
			CurrencyProvider* p = NULL;
			_tmp1_ = _g_object_ref0 ((CurrencyProvider*) p_it->data);
			p = _tmp1_;
			{
				CurrencyProvider* _tmp2_;
				_tmp2_ = p;
				currency_provider_set_refresh_interval (_tmp2_, self->priv->_refresh_interval, TRUE);
				_g_object_unref0 (p);
			}
		}
	}
}

CurrencyManager*
currency_manager_get_default (gboolean asyncLoad,
                              gboolean defaultProviders)
{
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	Currency* _tmp5_;
	CurrencyManager* _tmp6_;
	Currency* _tmp7_;
	CurrencyManager* _tmp8_;
	Currency* _tmp9_;
	CurrencyManager* _tmp10_;
	Currency* _tmp11_;
	CurrencyManager* _tmp12_;
	Currency* _tmp13_;
	CurrencyManager* _tmp14_;
	Currency* _tmp15_;
	CurrencyManager* _tmp16_;
	Currency* _tmp17_;
	CurrencyManager* _tmp18_;
	Currency* _tmp19_;
	CurrencyManager* _tmp20_;
	Currency* _tmp21_;
	CurrencyManager* _tmp22_;
	Currency* _tmp23_;
	CurrencyManager* _tmp24_;
	Currency* _tmp25_;
	CurrencyManager* _tmp26_;
	Currency* _tmp27_;
	CurrencyManager* _tmp28_;
	Currency* _tmp29_;
	CurrencyManager* _tmp30_;
	Currency* _tmp31_;
	CurrencyManager* _tmp32_;
	Currency* _tmp33_;
	CurrencyManager* _tmp34_;
	Currency* _tmp35_;
	CurrencyManager* _tmp36_;
	Currency* _tmp37_;
	CurrencyManager* _tmp38_;
	Currency* _tmp39_;
	CurrencyManager* _tmp40_;
	Currency* _tmp41_;
	CurrencyManager* _tmp42_;
	Currency* _tmp43_;
	CurrencyManager* _tmp44_;
	Currency* _tmp45_;
	CurrencyManager* _tmp46_;
	Currency* _tmp47_;
	CurrencyManager* _tmp48_;
	Currency* _tmp49_;
	CurrencyManager* _tmp50_;
	Currency* _tmp51_;
	CurrencyManager* _tmp52_;
	Currency* _tmp53_;
	CurrencyManager* _tmp54_;
	Currency* _tmp55_;
	CurrencyManager* _tmp56_;
	Currency* _tmp57_;
	CurrencyManager* _tmp58_;
	Currency* _tmp59_;
	CurrencyManager* _tmp60_;
	Currency* _tmp61_;
	CurrencyManager* _tmp62_;
	Currency* _tmp63_;
	CurrencyManager* _tmp64_;
	Currency* _tmp65_;
	CurrencyManager* _tmp66_;
	Currency* _tmp67_;
	CurrencyManager* _tmp68_;
	Currency* _tmp69_;
	CurrencyManager* _tmp70_;
	Currency* _tmp71_;
	CurrencyManager* _tmp72_;
	Currency* _tmp73_;
	CurrencyManager* _tmp74_;
	Currency* _tmp75_;
	CurrencyManager* _tmp76_;
	Currency* _tmp77_;
	CurrencyManager* _tmp78_;
	Currency* _tmp79_;
	CurrencyManager* _tmp80_;
	Currency* _tmp81_;
	CurrencyManager* _tmp82_;
	Currency* _tmp83_;
	CurrencyManager* _tmp84_;
	Currency* _tmp85_;
	CurrencyManager* _tmp86_;
	Currency* _tmp87_;
	CurrencyManager* _tmp88_;
	Currency* _tmp89_;
	CurrencyManager* _tmp90_;
	Currency* _tmp91_;
	CurrencyManager* _tmp92_;
	Currency* _tmp93_;
	CurrencyManager* _tmp94_;
	Currency* _tmp95_;
	CurrencyManager* _tmp96_;
	Currency* _tmp97_;
	CurrencyManager* _tmp98_;
	Currency* _tmp99_;
	CurrencyManager* _tmp100_;
	Currency* _tmp101_;
	CurrencyManager* _tmp102_;
	Currency* _tmp103_;
	CurrencyManager* _tmp104_;
	Currency* _tmp105_;
	CurrencyManager* _tmp106_;
	Currency* _tmp107_;
	CurrencyManager* _tmp108_;
	Currency* _tmp109_;
	CurrencyManager* _tmp110_;
	Currency* _tmp111_;
	CurrencyManager* _tmp112_;
	Currency* _tmp113_;
	CurrencyManager* _tmp114_;
	Currency* _tmp115_;
	CurrencyManager* _tmp116_;
	Currency* _tmp117_;
	CurrencyManager* _tmp118_;
	Currency* _tmp119_;
	CurrencyManager* _tmp120_;
	Currency* _tmp121_;
	CurrencyManager* _tmp122_;
	Currency* _tmp123_;
	CurrencyManager* _tmp131_;
	CurrencyManager* _tmp132_;
	CurrencyManager* result;
	_tmp0_ = default_currency_manager;
	if (_tmp0_ != NULL) {
		CurrencyManager* _tmp1_;
		CurrencyManager* _tmp2_;
		_tmp1_ = default_currency_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = currency_manager_new ();
	_g_object_unref0 (default_currency_manager);
	default_currency_manager = _tmp3_;
	_tmp4_ = default_currency_manager;
	_tmp5_ = currency_new ("AED", _ ("UAE Dirham"), "إ.د");
	_tmp4_->priv->currencies = g_list_append (_tmp4_->priv->currencies, _tmp5_);
	_tmp6_ = default_currency_manager;
	_tmp7_ = currency_new ("AUD", _ ("Australian Dollar"), "$");
	_tmp6_->priv->currencies = g_list_append (_tmp6_->priv->currencies, _tmp7_);
	_tmp8_ = default_currency_manager;
	_tmp9_ = currency_new ("BDT", _ ("Bangladeshi Taka"), "৳");
	_tmp8_->priv->currencies = g_list_append (_tmp8_->priv->currencies, _tmp9_);
	_tmp10_ = default_currency_manager;
	_tmp11_ = currency_new ("BGN", _ ("Bulgarian Lev"), "лв");
	_tmp10_->priv->currencies = g_list_append (_tmp10_->priv->currencies, _tmp11_);
	_tmp12_ = default_currency_manager;
	_tmp13_ = currency_new ("BHD", _ ("Bahraini Dinar"), ".ب.د");
	_tmp12_->priv->currencies = g_list_append (_tmp12_->priv->currencies, _tmp13_);
	_tmp14_ = default_currency_manager;
	_tmp15_ = currency_new ("BND", _ ("Brunei Dollar"), "$");
	_tmp14_->priv->currencies = g_list_append (_tmp14_->priv->currencies, _tmp15_);
	_tmp16_ = default_currency_manager;
	_tmp17_ = currency_new ("BRL", _ ("Brazilian Real"), "R$");
	_tmp16_->priv->currencies = g_list_append (_tmp16_->priv->currencies, _tmp17_);
	_tmp18_ = default_currency_manager;
	_tmp19_ = currency_new ("BWP", _ ("Botswana Pula"), "P");
	_tmp18_->priv->currencies = g_list_append (_tmp18_->priv->currencies, _tmp19_);
	_tmp20_ = default_currency_manager;
	_tmp21_ = currency_new ("CAD", _ ("Canadian Dollar"), "$");
	_tmp20_->priv->currencies = g_list_append (_tmp20_->priv->currencies, _tmp21_);
	_tmp22_ = default_currency_manager;
	_tmp23_ = currency_new ("CFA", _ ("CFA Franc"), "Fr");
	_tmp22_->priv->currencies = g_list_append (_tmp22_->priv->currencies, _tmp23_);
	_tmp24_ = default_currency_manager;
	_tmp25_ = currency_new ("CHF", _ ("Swiss Franc"), "Fr");
	_tmp24_->priv->currencies = g_list_append (_tmp24_->priv->currencies, _tmp25_);
	_tmp26_ = default_currency_manager;
	_tmp27_ = currency_new ("CLP", _ ("Chilean Peso"), "$");
	_tmp26_->priv->currencies = g_list_append (_tmp26_->priv->currencies, _tmp27_);
	_tmp28_ = default_currency_manager;
	_tmp29_ = currency_new ("CNY", _ ("Chinese Yuan"), "¥");
	_tmp28_->priv->currencies = g_list_append (_tmp28_->priv->currencies, _tmp29_);
	_tmp30_ = default_currency_manager;
	_tmp31_ = currency_new ("COP", _ ("Colombian Peso"), "$");
	_tmp30_->priv->currencies = g_list_append (_tmp30_->priv->currencies, _tmp31_);
	_tmp32_ = default_currency_manager;
	_tmp33_ = currency_new ("CZK", _ ("Czech Koruna"), "Kč");
	_tmp32_->priv->currencies = g_list_append (_tmp32_->priv->currencies, _tmp33_);
	_tmp34_ = default_currency_manager;
	_tmp35_ = currency_new ("DKK", _ ("Danish Krone"), "kr");
	_tmp34_->priv->currencies = g_list_append (_tmp34_->priv->currencies, _tmp35_);
	_tmp36_ = default_currency_manager;
	_tmp37_ = currency_new ("DZD", _ ("Algerian Dinar"), "ج.د");
	_tmp36_->priv->currencies = g_list_append (_tmp36_->priv->currencies, _tmp37_);
	_tmp38_ = default_currency_manager;
	_tmp39_ = currency_new ("EEK", _ ("Estonian Kroon"), "KR");
	_tmp38_->priv->currencies = g_list_append (_tmp38_->priv->currencies, _tmp39_);
	_tmp40_ = default_currency_manager;
	_tmp41_ = currency_new ("EUR", _ ("Euro"), "€");
	_tmp40_->priv->currencies = g_list_append (_tmp40_->priv->currencies, _tmp41_);
	_tmp42_ = default_currency_manager;
	_tmp43_ = currency_new ("GBP", _ ("British Pound Sterling"), "£");
	_tmp42_->priv->currencies = g_list_append (_tmp42_->priv->currencies, _tmp43_);
	_tmp44_ = default_currency_manager;
	_tmp45_ = currency_new ("HKD", _ ("Hong Kong Dollar"), "$");
	_tmp44_->priv->currencies = g_list_append (_tmp44_->priv->currencies, _tmp45_);
	_tmp46_ = default_currency_manager;
	_tmp47_ = currency_new ("HRK", _ ("Croatian Kuna"), "kn");
	_tmp46_->priv->currencies = g_list_append (_tmp46_->priv->currencies, _tmp47_);
	_tmp48_ = default_currency_manager;
	_tmp49_ = currency_new ("HUF", _ ("Hungarian Forint"), "Ft");
	_tmp48_->priv->currencies = g_list_append (_tmp48_->priv->currencies, _tmp49_);
	_tmp50_ = default_currency_manager;
	_tmp51_ = currency_new ("IDR", _ ("Indonesian Rupiah"), "Rp");
	_tmp50_->priv->currencies = g_list_append (_tmp50_->priv->currencies, _tmp51_);
	_tmp52_ = default_currency_manager;
	_tmp53_ = currency_new ("ILS", _ ("Israeli New Shekel"), "₪");
	_tmp52_->priv->currencies = g_list_append (_tmp52_->priv->currencies, _tmp53_);
	_tmp54_ = default_currency_manager;
	_tmp55_ = currency_new ("INR", _ ("Indian Rupee"), "₹");
	_tmp54_->priv->currencies = g_list_append (_tmp54_->priv->currencies, _tmp55_);
	_tmp56_ = default_currency_manager;
	_tmp57_ = currency_new ("IRR", _ ("Iranian Rial"), "﷼");
	_tmp56_->priv->currencies = g_list_append (_tmp56_->priv->currencies, _tmp57_);
	_tmp58_ = default_currency_manager;
	_tmp59_ = currency_new ("ISK", _ ("Icelandic Krona"), "kr");
	_tmp58_->priv->currencies = g_list_append (_tmp58_->priv->currencies, _tmp59_);
	_tmp60_ = default_currency_manager;
	_tmp61_ = currency_new ("JPY", _ ("Japanese Yen"), "¥");
	_tmp60_->priv->currencies = g_list_append (_tmp60_->priv->currencies, _tmp61_);
	_tmp62_ = default_currency_manager;
	_tmp63_ = currency_new ("KRW", _ ("South Korean Won"), "₩");
	_tmp62_->priv->currencies = g_list_append (_tmp62_->priv->currencies, _tmp63_);
	_tmp64_ = default_currency_manager;
	_tmp65_ = currency_new ("KWD", _ ("Kuwaiti Dinar"), "ك.د");
	_tmp64_->priv->currencies = g_list_append (_tmp64_->priv->currencies, _tmp65_);
	_tmp66_ = default_currency_manager;
	_tmp67_ = currency_new ("KZT", _ ("Kazakhstani Tenge"), "₸");
	_tmp66_->priv->currencies = g_list_append (_tmp66_->priv->currencies, _tmp67_);
	_tmp68_ = default_currency_manager;
	_tmp69_ = currency_new ("LKR", _ ("Sri Lankan Rupee"), "Rs");
	_tmp68_->priv->currencies = g_list_append (_tmp68_->priv->currencies, _tmp69_);
	_tmp70_ = default_currency_manager;
	_tmp71_ = currency_new ("LYD", _ ("Libyan Dinar"), "د.ل");
	_tmp70_->priv->currencies = g_list_append (_tmp70_->priv->currencies, _tmp71_);
	_tmp72_ = default_currency_manager;
	_tmp73_ = currency_new ("MUR", _ ("Mauritian Rupee"), "Rs");
	_tmp72_->priv->currencies = g_list_append (_tmp72_->priv->currencies, _tmp73_);
	_tmp74_ = default_currency_manager;
	_tmp75_ = currency_new ("MXN", _ ("Mexican Peso"), "$");
	_tmp74_->priv->currencies = g_list_append (_tmp74_->priv->currencies, _tmp75_);
	_tmp76_ = default_currency_manager;
	_tmp77_ = currency_new ("MYR", _ ("Malaysian Ringgit"), "RM");
	_tmp76_->priv->currencies = g_list_append (_tmp76_->priv->currencies, _tmp77_);
	_tmp78_ = default_currency_manager;
	_tmp79_ = currency_new ("NOK", _ ("Norwegian Krone"), "kr");
	_tmp78_->priv->currencies = g_list_append (_tmp78_->priv->currencies, _tmp79_);
	_tmp80_ = default_currency_manager;
	_tmp81_ = currency_new ("NPR", _ ("Nepalese Rupee"), "Rs");
	_tmp80_->priv->currencies = g_list_append (_tmp80_->priv->currencies, _tmp81_);
	_tmp82_ = default_currency_manager;
	_tmp83_ = currency_new ("NZD", _ ("New Zealand Dollar"), "$");
	_tmp82_->priv->currencies = g_list_append (_tmp82_->priv->currencies, _tmp83_);
	_tmp84_ = default_currency_manager;
	_tmp85_ = currency_new ("OMR", _ ("Omani Rial"), "ع.ر.");
	_tmp84_->priv->currencies = g_list_append (_tmp84_->priv->currencies, _tmp85_);
	_tmp86_ = default_currency_manager;
	_tmp87_ = currency_new ("PEN", _ ("Peruvian Nuevo Sol"), "S/.");
	_tmp86_->priv->currencies = g_list_append (_tmp86_->priv->currencies, _tmp87_);
	_tmp88_ = default_currency_manager;
	_tmp89_ = currency_new ("PHP", _ ("Philippine Peso"), "₱");
	_tmp88_->priv->currencies = g_list_append (_tmp88_->priv->currencies, _tmp89_);
	_tmp90_ = default_currency_manager;
	_tmp91_ = currency_new ("PKR", _ ("Pakistani Rupee"), "Rs");
	_tmp90_->priv->currencies = g_list_append (_tmp90_->priv->currencies, _tmp91_);
	_tmp92_ = default_currency_manager;
	_tmp93_ = currency_new ("PLN", _ ("Polish Zloty"), "zł");
	_tmp92_->priv->currencies = g_list_append (_tmp92_->priv->currencies, _tmp93_);
	_tmp94_ = default_currency_manager;
	_tmp95_ = currency_new ("QAR", _ ("Qatari Riyal"), "ق.ر");
	_tmp94_->priv->currencies = g_list_append (_tmp94_->priv->currencies, _tmp95_);
	_tmp96_ = default_currency_manager;
	_tmp97_ = currency_new ("RON", _ ("New Romanian Leu"), "L");
	_tmp96_->priv->currencies = g_list_append (_tmp96_->priv->currencies, _tmp97_);
	_tmp98_ = default_currency_manager;
	_tmp99_ = currency_new ("RUB", _ ("Russian Rouble"), "руб.");
	_tmp98_->priv->currencies = g_list_append (_tmp98_->priv->currencies, _tmp99_);
	_tmp100_ = default_currency_manager;
	_tmp101_ = currency_new ("SAR", _ ("Saudi Riyal"), "س.ر");
	_tmp100_->priv->currencies = g_list_append (_tmp100_->priv->currencies, _tmp101_);
	_tmp102_ = default_currency_manager;
	_tmp103_ = currency_new ("RSD", _ ("Serbian Dinar"), "дин");
	_tmp102_->priv->currencies = g_list_append (_tmp102_->priv->currencies, _tmp103_);
	_tmp104_ = default_currency_manager;
	_tmp105_ = currency_new ("SEK", _ ("Swedish Krona"), "kr");
	_tmp104_->priv->currencies = g_list_append (_tmp104_->priv->currencies, _tmp105_);
	_tmp106_ = default_currency_manager;
	_tmp107_ = currency_new ("SGD", _ ("Singapore Dollar"), "$");
	_tmp106_->priv->currencies = g_list_append (_tmp106_->priv->currencies, _tmp107_);
	_tmp108_ = default_currency_manager;
	_tmp109_ = currency_new ("THB", _ ("Thai Baht"), "฿");
	_tmp108_->priv->currencies = g_list_append (_tmp108_->priv->currencies, _tmp109_);
	_tmp110_ = default_currency_manager;
	_tmp111_ = currency_new ("TND", _ ("Tunisian Dinar"), "ت.د");
	_tmp110_->priv->currencies = g_list_append (_tmp110_->priv->currencies, _tmp111_);
	_tmp112_ = default_currency_manager;
	_tmp113_ = currency_new ("TRY", _ ("Turkish Lira"), "₺");
	_tmp112_->priv->currencies = g_list_append (_tmp112_->priv->currencies, _tmp113_);
	_tmp114_ = default_currency_manager;
	_tmp115_ = currency_new ("TTD", _ ("T&T Dollar (TTD)"), "$");
	_tmp114_->priv->currencies = g_list_append (_tmp114_->priv->currencies, _tmp115_);
	_tmp116_ = default_currency_manager;
	_tmp117_ = currency_new ("USD", _ ("US Dollar"), "$");
	_tmp116_->priv->currencies = g_list_append (_tmp116_->priv->currencies, _tmp117_);
	_tmp118_ = default_currency_manager;
	_tmp119_ = currency_new ("UYU", _ ("Uruguayan Peso"), "$");
	_tmp118_->priv->currencies = g_list_append (_tmp118_->priv->currencies, _tmp119_);
	_tmp120_ = default_currency_manager;
	_tmp121_ = currency_new ("VEF", _ ("Venezuelan Bolívar"), "Bs F");
	_tmp120_->priv->currencies = g_list_append (_tmp120_->priv->currencies, _tmp121_);
	_tmp122_ = default_currency_manager;
	_tmp123_ = currency_new ("ZAR", _ ("South African Rand"), "R");
	_tmp122_->priv->currencies = g_list_append (_tmp122_->priv->currencies, _tmp123_);
	if (defaultProviders) {
		CurrencyManager* _tmp124_;
		ImfCurrencyProvider* _tmp125_;
		ImfCurrencyProvider* _tmp126_;
		CurrencyManager* _tmp127_;
		EcbCurrencyProvider* _tmp128_;
		EcbCurrencyProvider* _tmp129_;
		CurrencyManager* _tmp130_;
		_tmp124_ = default_currency_manager;
		_tmp125_ = imf_currency_provider_new (_tmp124_);
		_tmp126_ = _tmp125_;
		_g_object_unref0 (_tmp126_);
		_tmp127_ = default_currency_manager;
		_tmp128_ = ecb_currency_provider_new (_tmp127_);
		_tmp129_ = _tmp128_;
		_g_object_unref0 (_tmp129_);
		_tmp130_ = default_currency_manager;
		currency_manager_initialize_providers (_tmp130_, asyncLoad);
	}
	_tmp131_ = default_currency_manager;
	_tmp132_ = _g_object_ref0 (_tmp131_);
	result = _tmp132_;
	return result;
}

static void
currency_manager_update (CurrencyManager* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	currency_manager_set_loaded (self, FALSE);
	_tmp0_ = self->priv->providers;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			CurrencyProvider* _tmp1_;
			CurrencyProvider* p = NULL;
			_tmp1_ = _g_object_ref0 ((CurrencyProvider*) p_it->data);
			p = _tmp1_;
			{
				CurrencyProvider* _tmp2_;
				_tmp2_ = p;
				if (currency_provider_is_loaded (_tmp2_)) {
					currency_manager_set_loaded (self, TRUE);
					_g_object_unref0 (p);
					break;
				}
				_g_object_unref0 (p);
			}
		}
	}
	g_signal_emit (self, currency_manager_signals[CURRENCY_MANAGER_UPDATED_SIGNAL], 0);
}

static void
____lambda9_ (CurrencyManager* self)
{
	currency_manager_update (self);
}

static void
_____lambda9__currency_provider_updated (CurrencyProvider* _sender,
                                         gpointer self)
{
	____lambda9_ ((CurrencyManager*) self);
}

void
currency_manager_initialize_providers (CurrencyManager* self,
                                       gboolean asyncLoad)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->providers;
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
		p_collection = _tmp0_;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			CurrencyProvider* _tmp1_;
			CurrencyProvider* p = NULL;
			_tmp1_ = _g_object_ref0 ((CurrencyProvider*) p_it->data);
			p = _tmp1_;
			{
				CurrencyProvider* _tmp2_;
				CurrencyProvider* _tmp3_;
				_tmp2_ = p;
				g_signal_connect_object (_tmp2_, "updated", (GCallback) _____lambda9__currency_provider_updated, self, 0);
				_tmp3_ = p;
				currency_provider_update_rates (_tmp3_, asyncLoad);
				_g_object_unref0 (p);
			}
		}
	}
}

GList*
currency_manager_get_currencies (CurrencyManager* self)
{
	GList* r = NULL;
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				Currency* _tmp3_;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}

Currency*
currency_manager_get_currency (CurrencyManager* self,
                               const gchar* name)
{
	GList* _tmp0_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = c;
				_tmp3_ = currency_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (name, _tmp5_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					Number* value = NULL;
					Currency* _tmp7_;
					Number* _tmp8_;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					Number* _tmp11_;
					_tmp7_ = c;
					_tmp8_ = currency_get_value (_tmp7_);
					value = _tmp8_;
					_tmp11_ = value;
					if (_tmp11_ == NULL) {
						_tmp10_ = TRUE;
					} else {
						Number* _tmp12_;
						_tmp12_ = value;
						_tmp10_ = number_is_negative (_tmp12_);
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						Number* _tmp13_;
						_tmp13_ = value;
						_tmp9_ = number_is_zero (_tmp13_);
					}
					if (_tmp9_) {
						result = NULL;
						_g_object_unref0 (value);
						_g_object_unref0 (c);
						return result;
					} else {
						result = c;
						_g_object_unref0 (value);
						return result;
					}
					_g_object_unref0 (value);
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}

Number*
currency_manager_get_value (CurrencyManager* self,
                            const gchar* currency)
{
	Currency* c = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	_tmp0_ = currency_manager_get_currency (self, currency);
	c = _tmp0_;
	_tmp1_ = c;
	if (_tmp1_ != NULL) {
		Currency* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = c;
		_tmp3_ = currency_get_value (_tmp2_);
		result = _tmp3_;
		_g_object_unref0 (c);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (c);
		return result;
	}
}

Currency*
currency_manager_add_currency (CurrencyManager* self,
                               const gchar* short_name,
                               const gchar* source)
{
	GList* _tmp0_;
	Currency* c = NULL;
	Currency* _tmp9_;
	Currency* _tmp10_;
	gchar* _tmp11_;
	Currency* _tmp12_;
	Currency* _tmp13_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (short_name != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = c;
				_tmp3_ = currency_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, short_name) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					Currency* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = c;
					_tmp8_ = g_strdup (source);
					currency_set_source (_tmp7_, _tmp8_);
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	g_warning ("currency.vala:189: Currency %s is not in the currency table", short_name);
	_tmp9_ = currency_new (short_name, short_name, short_name);
	c = _tmp9_;
	_tmp10_ = c;
	_tmp11_ = g_strdup (source);
	currency_set_source (_tmp10_, _tmp11_);
	_tmp12_ = c;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	self->priv->currencies = g_list_append (self->priv->currencies, _tmp13_);
	result = c;
	return result;
}

static void
_vala_array_add1 (Currency** * array,
                  gint* length,
                  gint* size,
                  Currency* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Currency*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

Currency**
currency_manager_currencies_eligible_for_autocompletion_for_text (CurrencyManager* self,
                                                                  const gchar* display_text,
                                                                  gint* result_length1)
{
	Currency** eligible_currencies = NULL;
	Currency** _tmp0_;
	gint eligible_currencies_length1;
	gint _eligible_currencies_size_;
	gchar* display_text_case_insensitive = NULL;
	gchar* _tmp1_;
	GList* _tmp2_;
	Currency** _tmp14_;
	gint _tmp14__length1;
	Currency** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display_text != NULL, NULL);
	_tmp0_ = g_new0 (Currency*, 0 + 1);
	eligible_currencies = _tmp0_;
	eligible_currencies_length1 = 0;
	_eligible_currencies_size_ = eligible_currencies_length1;
	_tmp1_ = g_utf8_strup (display_text, (gssize) -1);
	display_text_case_insensitive = _tmp1_;
	_tmp2_ = self->priv->currencies;
	{
		GList* currency_collection = NULL;
		GList* currency_it = NULL;
		currency_collection = _tmp2_;
		for (currency_it = currency_collection; currency_it != NULL; currency_it = currency_it->next) {
			Currency* _tmp3_;
			Currency* currency = NULL;
			_tmp3_ = _g_object_ref0 ((Currency*) currency_it->data);
			currency = _tmp3_;
			{
				gchar* currency_name_case_insensitive = NULL;
				Currency* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp4_ = currency;
				_tmp5_ = currency_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = _tmp6_;
				_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				currency_name_case_insensitive = _tmp9_;
				_tmp10_ = currency_name_case_insensitive;
				_tmp11_ = display_text_case_insensitive;
				if (g_str_has_prefix (_tmp10_, _tmp11_)) {
					Currency* _tmp12_;
					Currency* _tmp13_;
					_tmp12_ = currency;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_vala_array_add1 (&eligible_currencies, &eligible_currencies_length1, &_eligible_currencies_size_, _tmp13_);
				}
				_g_free0 (currency_name_case_insensitive);
				_g_object_unref0 (currency);
			}
		}
	}
	_tmp14_ = eligible_currencies;
	_tmp14__length1 = eligible_currencies_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_free0 (display_text_case_insensitive);
	return result;
}

CurrencyManager*
currency_manager_construct (GType object_type)
{
	CurrencyManager * self = NULL;
	self = (CurrencyManager*) g_object_new (object_type, NULL);
	return self;
}

CurrencyManager*
currency_manager_new (void)
{
	return currency_manager_construct (TYPE_CURRENCY_MANAGER);
}

gint
currency_manager_get_refresh_interval (CurrencyManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_refresh_interval;
	return result;
}

void
currency_manager_set_refresh_interval (CurrencyManager* self,
                                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_refresh_interval = value;
	g_object_notify_by_pspec ((GObject *) self, currency_manager_properties[CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY]);
}

gboolean
currency_manager_get_loaded (CurrencyManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded;
	return result;
}

static void
currency_manager_set_loaded (CurrencyManager* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = currency_manager_get_loaded (self);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, currency_manager_properties[CURRENCY_MANAGER_LOADED_PROPERTY]);
	}
}

static void
currency_manager_class_init (CurrencyManagerClass * klass,
                             gpointer klass_data)
{
	currency_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CurrencyManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_currency_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_currency_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = currency_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY, currency_manager_properties[CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY] = g_param_spec_int ("refresh-interval", "refresh-interval", "refresh-interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_MANAGER_LOADED_PROPERTY, currency_manager_properties[CURRENCY_MANAGER_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	currency_manager_signals[CURRENCY_MANAGER_UPDATED_SIGNAL] = g_signal_new ("updated", TYPE_CURRENCY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
currency_manager_instance_init (CurrencyManager * self,
                                gpointer klass)
{
	self->priv = currency_manager_get_instance_private (self);
}

static void
currency_manager_finalize (GObject * obj)
{
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY_MANAGER, CurrencyManager);
	(self->priv->currencies == NULL) ? NULL : (self->priv->currencies = (_g_list_free__g_object_unref0_ (self->priv->currencies), NULL));
	(self->priv->providers == NULL) ? NULL : (self->priv->providers = (_g_list_free__g_object_unref0_ (self->priv->providers), NULL));
	G_OBJECT_CLASS (currency_manager_parent_class)->finalize (obj);
}

static GType
currency_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyManager), 0, (GInstanceInitFunc) currency_manager_instance_init, NULL };
	GType currency_manager_type_id;
	currency_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CurrencyManager", &g_define_type_info, 0);
	CurrencyManager_private_offset = g_type_add_instance_private (currency_manager_type_id, sizeof (CurrencyManagerPrivate));
	return currency_manager_type_id;
}

GType
currency_manager_get_type (void)
{
	static volatile gsize currency_manager_type_id__once = 0;
	if (g_once_init_enter (&currency_manager_type_id__once)) {
		GType currency_manager_type_id;
		currency_manager_type_id = currency_manager_get_type_once ();
		g_once_init_leave (&currency_manager_type_id__once, currency_manager_type_id);
	}
	return currency_manager_type_id__once;
}

static void
_vala_currency_manager_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY_MANAGER, CurrencyManager);
	switch (property_id) {
		case CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY:
		g_value_set_int (value, currency_manager_get_refresh_interval (self));
		break;
		case CURRENCY_MANAGER_LOADED_PROPERTY:
		g_value_set_boolean (value, currency_manager_get_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_currency_manager_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY_MANAGER, CurrencyManager);
	switch (property_id) {
		case CURRENCY_MANAGER_REFRESH_INTERVAL_PROPERTY:
		currency_manager_set_refresh_interval (self, g_value_get_int (value));
		break;
		case CURRENCY_MANAGER_LOADED_PROPERTY:
		currency_manager_set_loaded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
currency_get_instance_private (Currency* self)
{
	return G_STRUCT_MEMBER_P (self, Currency_private_offset);
}

Currency*
currency_construct (GType object_type,
                    const gchar* name,
                    const gchar* display_name,
                    const gchar* symbol)
{
	Currency * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (Currency*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = g_strdup (display_name);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	_tmp2_ = g_strdup (symbol);
	_g_free0 (self->priv->_symbol);
	self->priv->_symbol = _tmp2_;
	return self;
}

Currency*
currency_new (const gchar* name,
              const gchar* display_name,
              const gchar* symbol)
{
	return currency_construct (TYPE_CURRENCY, name, display_name, symbol);
}

void
currency_set_value (Currency* self,
                    Number* value)
{
	Number* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->value);
	self->priv->value = _tmp0_;
}

Number*
currency_get_value (Currency* self)
{
	Number* _tmp0_;
	Number* _tmp1_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
currency_get_name (Currency* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
currency_get_display_name (Currency* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
currency_get_symbol (Currency* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
currency_get_source (Currency* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
currency_set_source (Currency* self,
                     gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_source);
	self->priv->_source = _tmp0_;
	_g_free0 (value);
	g_object_notify_by_pspec ((GObject *) self, currency_properties[CURRENCY_SOURCE_PROPERTY]);
}

static void
currency_class_init (CurrencyClass * klass,
                     gpointer klass_data)
{
	currency_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Currency_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_currency_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_currency_set_property;
	G_OBJECT_CLASS (klass)->finalize = currency_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_NAME_PROPERTY, currency_properties[CURRENCY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_DISPLAY_NAME_PROPERTY, currency_properties[CURRENCY_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_SYMBOL_PROPERTY, currency_properties[CURRENCY_SYMBOL_PROPERTY] = g_param_spec_string ("symbol", "symbol", "symbol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_SOURCE_PROPERTY, currency_properties[CURRENCY_SOURCE_PROPERTY] = g_param_spec_string ("source", "source", "source", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
currency_instance_init (Currency * self,
                        gpointer klass)
{
	self->priv = currency_get_instance_private (self);
}

static void
currency_finalize (GObject * obj)
{
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY, Currency);
	_g_object_unref0 (self->priv->value);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_symbol);
	_g_free0 (self->priv->_source);
	G_OBJECT_CLASS (currency_parent_class)->finalize (obj);
}

static GType
currency_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Currency), 0, (GInstanceInitFunc) currency_instance_init, NULL };
	GType currency_type_id;
	currency_type_id = g_type_register_static (G_TYPE_OBJECT, "Currency", &g_define_type_info, 0);
	Currency_private_offset = g_type_add_instance_private (currency_type_id, sizeof (CurrencyPrivate));
	return currency_type_id;
}

GType
currency_get_type (void)
{
	static volatile gsize currency_type_id__once = 0;
	if (g_once_init_enter (&currency_type_id__once)) {
		GType currency_type_id;
		currency_type_id = currency_get_type_once ();
		g_once_init_leave (&currency_type_id__once, currency_type_id);
	}
	return currency_type_id__once;
}

static void
_vala_currency_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY, Currency);
	switch (property_id) {
		case CURRENCY_NAME_PROPERTY:
		g_value_take_string (value, currency_get_name (self));
		break;
		case CURRENCY_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, currency_get_display_name (self));
		break;
		case CURRENCY_SYMBOL_PROPERTY:
		g_value_take_string (value, currency_get_symbol (self));
		break;
		case CURRENCY_SOURCE_PROPERTY:
		g_value_take_string (value, currency_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_currency_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY, Currency);
	switch (property_id) {
		case CURRENCY_SOURCE_PROPERTY:
		currency_set_source (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

