// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATtiny80.atdf, see http://packs.download.atmel.com/

//go:build avr && attiny80
// +build avr,attiny80

// Device information for the ATtiny80.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATtiny80"
	ARCH   = "AVR8"
	FAMILY = "tinyAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_PCINT0       = 3  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 4  // Pin Change Interrupt Request 0
	IRQ_PCINT2       = 5  // Pin Change Interrupt Request 1
	IRQ_WDT          = 6  // Watchdog Time-out Interrupt
	IRQ_TIMER2_COMPA = 7  // Timer/Counter2 Compare Match A
	IRQ_TIMER2_COMPB = 8  // Timer/Counter2 Compare Match A
	IRQ_TIMER2_OVF   = 9  // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 10 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 11 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 12 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 13 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 14 // TimerCounter0 Compare Match A
	IRQ_TIMER0_COMPB = 15 // TimerCounter0 Compare Match B
	IRQ_TIMER0_OVF   = 16 // Timer/Couner0 Overflow
	IRQ_SPI_STC      = 17 // SPI Serial Transfer Complete
	IRQ_CLI          = 21 // Custom Logic Interrupt
	IRQ_EE_READY     = 22 // EEPROM Ready
	IRQ_ANALOG_COMP  = 23 // Analog Comparator
	IRQ_SPM_Ready    = 25 // Store Program Memory Read
	IRQ_USART_RX     = 28 // USART Rx Complete
	IRQ_USART_UDRE   = 29 // USART, Data Register Empty
	IRQ_USART_TX     = 30 // USART Tx Complete
	IRQ_USART_START  = 31 // USART Start Edge Interrupt
	IRQ_TIMER3_CAPT  = 32 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 33 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 34 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_OVF   = 35 // Timer/Counter3 Overflow
	IRQ_PTC_EOC      = 37 // PTC End of conversion
	IRQ_PTC_WCOMP    = 38 // PTC Window comparator mode
	IRQ_max          = 38 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_PCINT2
//go:interrupt
func interruptPCINT2() {
	callHandlers(IRQ_PCINT2)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_TIMER2_COMPA
//go:interrupt
func interruptTIMER2_COMPA() {
	callHandlers(IRQ_TIMER2_COMPA)
}

//export __vector_TIMER2_COMPB
//go:interrupt
func interruptTIMER2_COMPB() {
	callHandlers(IRQ_TIMER2_COMPB)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_CLI
//go:interrupt
func interruptCLI() {
	callHandlers(IRQ_CLI)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_ANALOG_COMP
//go:interrupt
func interruptANALOG_COMP() {
	callHandlers(IRQ_ANALOG_COMP)
}

//export __vector_SPM_Ready
//go:interrupt
func interruptSPM_Ready() {
	callHandlers(IRQ_SPM_Ready)
}

//export __vector_USART_RX
//go:interrupt
func interruptUSART_RX() {
	callHandlers(IRQ_USART_RX)
}

//export __vector_USART_UDRE
//go:interrupt
func interruptUSART_UDRE() {
	callHandlers(IRQ_USART_UDRE)
}

//export __vector_USART_TX
//go:interrupt
func interruptUSART_TX() {
	callHandlers(IRQ_USART_TX)
}

//export __vector_USART_START
//go:interrupt
func interruptUSART_START() {
	callHandlers(IRQ_USART_START)
}

//export __vector_TIMER3_CAPT
//go:interrupt
func interruptTIMER3_CAPT() {
	callHandlers(IRQ_TIMER3_CAPT)
}

//export __vector_TIMER3_COMPA
//go:interrupt
func interruptTIMER3_COMPA() {
	callHandlers(IRQ_TIMER3_COMPA)
}

//export __vector_TIMER3_COMPB
//go:interrupt
func interruptTIMER3_COMPB() {
	callHandlers(IRQ_TIMER3_COMPB)
}

//export __vector_TIMER3_OVF
//go:interrupt
func interruptTIMER3_OVF() {
	callHandlers(IRQ_TIMER3_OVF)
}

//export __vector_PTC_EOC
//go:interrupt
func interruptPTC_EOC() {
	callHandlers(IRQ_PTC_EOC)
}

//export __vector_PTC_WCOMP
//go:interrupt
func interruptPTC_WCOMP() {
	callHandlers(IRQ_PTC_WCOMP)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Device ID
	DEVID0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	DEVID1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	DEVID2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	DEVID3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	DEVID4 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	DEVID5 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	DEVID6 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	DEVID7 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	DEVID8 = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))

	// USART
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UCSR1D = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))

	// Timer/Counter, 8-bit Async
	TIMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TIFR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	TCCR2A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	TCCR2B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb1)))
	TCNT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	OCR2B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb4)))
	OCR2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	ACMUX = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	CLCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	CLSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))

	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// CPU Registers
	PRR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))
	PRR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0    = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1    = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2    = 0x4 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL_Msk = 0x7 // Brown-out Detector trigger level

	// HIGH
	HIGH_RSTDISBL     = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_RSTDISBL_Msk = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_DWEN         = 0x40 // Debug Wire enable
	HIGH_DWEN_Msk     = 0x40 // Debug Wire enable
	HIGH_SPIEN        = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON        = 0x10 // Watch-dog Timer always on
	HIGH_WDTON_Msk    = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE       = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0      = 0x2  // Select boot size
	HIGH_BOOTSZ1      = 0x4  // Select boot size
	HIGH_BOOTSZ_Msk   = 0x6  // Select boot size
	HIGH_BOOTRST      = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk  = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on Port
	LOW_CKOUT_Msk     = 0x40 // Clock output on Port
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for USART: USART
const (
	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1      = 0x80 // USART Receive Complete
	UCSR1A_RXC1_Msk  = 0x80 // USART Receive Complete
	UCSR1A_TXC1      = 0x40 // USART Transmitt Complete
	UCSR1A_TXC1_Msk  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1     = 0x20 // USART Data Register Empty
	UCSR1A_UDRE1_Msk = 0x20 // USART Data Register Empty
	UCSR1A_FE1       = 0x10 // Framing Error
	UCSR1A_FE1_Msk   = 0x10 // Framing Error
	UCSR1A_DOR1      = 0x8  // Data overRun
	UCSR1A_DOR1_Msk  = 0x8  // Data overRun
	UCSR1A_UPE1      = 0x4  // Parity Error
	UCSR1A_UPE1_Msk  = 0x4  // Parity Error
	UCSR1A_U2X1      = 0x2  // Double the USART transmission speed
	UCSR1A_U2X1_Msk  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1     = 0x1  // Multi-processor Communication Mode
	UCSR1A_MPCM1_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1     = 0x80 // RX Complete Interrupt Enable
	UCSR1B_RXCIE1_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1     = 0x40 // TX Complete Interrupt Enable
	UCSR1B_TXCIE1_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_UDRIE1_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1      = 0x10 // Receiver Enable
	UCSR1B_RXEN1_Msk  = 0x10 // Receiver Enable
	UCSR1B_TXEN1      = 0x8  // Transmitter Enable
	UCSR1B_TXEN1_Msk  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12     = 0x4  // Character Size
	UCSR1B_UCSZ12_Msk = 0x4  // Character Size
	UCSR1B_RXB81      = 0x2  // Receive Data Bit 8
	UCSR1B_RXB81_Msk  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81      = 0x1  // Transmit Data Bit 8
	UCSR1B_TXB81_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10    = 0x40 // USART Mode Select
	UCSR1C_UMSEL11    = 0x80 // USART Mode Select
	UCSR1C_UMSEL1_Msk = 0xc0 // USART Mode Select
	UCSR1C_UPM10      = 0x10 // Parity Mode Bits
	UCSR1C_UPM11      = 0x20 // Parity Mode Bits
	UCSR1C_UPM1_Msk   = 0x30 // Parity Mode Bits
	UCSR1C_USBS1      = 0x8  // Stop Bit Select
	UCSR1C_USBS1_Msk  = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10     = 0x2  // Character Size
	UCSR1C_UCSZ11     = 0x4  // Character Size
	UCSR1C_UCSZ1_Msk  = 0x6  // Character Size
	UCSR1C_UCPOL1     = 0x1  // Clock Polarity
	UCSR1C_UCPOL1_Msk = 0x1  // Clock Polarity

	// UCSR1D: USART Control and Status Register D
	UCSR1D_RXSIE     = 0x80 // RX Start Interrupt Enable
	UCSR1D_RXSIE_Msk = 0x80 // RX Start Interrupt Enable
	UCSR1D_RXS       = 0x40 // RX Start
	UCSR1D_RXS_Msk   = 0x40 // RX Start
	UCSR1D_SFDE      = 0x20 // Start Frame Detection Enable
	UCSR1D_SFDE_Msk  = 0x20 // Start Frame Detection Enable
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A     = 0x80
	TCCR1C_FOC1A_Msk = 0x80
	TCCR1C_FOC1B     = 0x40
	TCCR1C_FOC1B_Msk = 0x40

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRASY      = 0x2  // Prescaler Reset Timer/Counter2
	GTCCR_PSRASY_Msk  = 0x2  // Prescaler Reset Timer/Counter2

	// TIMSK3: Timer/Counter3 Interrupt Mask Register
	TIMSK3_ICIE3      = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_ICIE3_Msk  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3B     = 0x4  // Timer/Counter3 Output CompareB Match Interrupt Enable
	TIMSK3_OCIE3B_Msk = 0x4  // Timer/Counter3 Output CompareB Match Interrupt Enable
	TIMSK3_OCIE3A     = 0x2  // Timer/Counter3 Output CompareA Match Interrupt Enable
	TIMSK3_OCIE3A_Msk = 0x2  // Timer/Counter3 Output CompareA Match Interrupt Enable
	TIMSK3_TOIE3      = 0x1  // Timer/Counter3 Overflow Interrupt Enable
	TIMSK3_TOIE3_Msk  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter Interrupt Flag register
	TIFR3_ICF3      = 0x20 // Input Capture Flag 1
	TIFR3_ICF3_Msk  = 0x20 // Input Capture Flag 1
	TIFR3_OCF3B     = 0x4  // Output Compare Flag 1B
	TIFR3_OCF3B_Msk = 0x4  // Output Compare Flag 1B
	TIFR3_OCF3A     = 0x2  // Output Compare Flag 1A
	TIFR3_OCF3A_Msk = 0x2  // Output Compare Flag 1A
	TIFR3_TOV3      = 0x1  // Timer/Counter3 Overflow Flag
	TIFR3_TOV3_Msk  = 0x1  // Timer/Counter3 Overflow Flag

	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0    = 0x40 // Compare Output Mode 3A, bits
	TCCR3A_COM3A1    = 0x80 // Compare Output Mode 3A, bits
	TCCR3A_COM3A_Msk = 0xc0 // Compare Output Mode 3A, bits
	TCCR3A_COM3B0    = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1    = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3B_Msk = 0x30 // Compare Output Mode 3B, bits
	TCCR3A_WGM30     = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31     = 0x2  // Waveform Generation Mode
	TCCR3A_WGM3_Msk  = 0x3  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3     = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICNC3_Msk = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3     = 0x40 // Input Capture 3 Edge Select
	TCCR3B_ICES3_Msk = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30     = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31     = 0x10 // Waveform Generation Mode
	TCCR3B_WGM3_Msk  = 0x18 // Waveform Generation Mode
	TCCR3B_CS30      = 0x1  // Prescaler source of Timer/Counter 3
	TCCR3B_CS31      = 0x2  // Prescaler source of Timer/Counter 3
	TCCR3B_CS32      = 0x4  // Prescaler source of Timer/Counter 3
	TCCR3B_CS3_Msk   = 0x7  // Prescaler source of Timer/Counter 3

	// TCCR3C: Timer/Counter3 Control Register C
	TCCR3C_FOC3A     = 0x80
	TCCR3C_FOC3A_Msk = 0x80
	TCCR3C_FOC3B     = 0x40
	TCCR3C_FOC3B_Msk = 0x40
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TIMSK2: Timer/Counter2 Interrupt Mask register
	TIMSK2_OCIE2B     = 0x4 // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2B_Msk = 0x4 // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2A     = 0x2 // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_OCIE2A_Msk = 0x2 // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_TOIE2      = 0x1 // Timer/Counter2 Overflow Interrupt Enable
	TIMSK2_TOIE2_Msk  = 0x1 // Timer/Counter2 Overflow Interrupt Enable

	// TIFR2: Timer/Counter2 Interrupt Flag Register
	TIFR2_OCF2B     = 0x4 // Output Compare Flag 2B
	TIFR2_OCF2B_Msk = 0x4 // Output Compare Flag 2B
	TIFR2_OCF2A     = 0x2 // Output Compare Flag 2A
	TIFR2_OCF2A_Msk = 0x2 // Output Compare Flag 2A
	TIFR2_TOV2      = 0x1 // Timer/Counter2 Overflow Flag
	TIFR2_TOV2_Msk  = 0x1 // Timer/Counter2 Overflow Flag

	// TCCR2A: Timer/Counter2 Control Register A
	TCCR2A_COM2A0    = 0x40 // Compare Output Mode bits
	TCCR2A_COM2A1    = 0x80 // Compare Output Mode bits
	TCCR2A_COM2A_Msk = 0xc0 // Compare Output Mode bits
	TCCR2A_COM2B0    = 0x10 // Compare Output Mode bits
	TCCR2A_COM2B1    = 0x20 // Compare Output Mode bits
	TCCR2A_COM2B_Msk = 0x30 // Compare Output Mode bits
	TCCR2A_WGM20     = 0x1  // Waveform Genration Mode
	TCCR2A_WGM21     = 0x2  // Waveform Genration Mode
	TCCR2A_WGM2_Msk  = 0x3  // Waveform Genration Mode

	// TCCR2B: Timer/Counter2 Control Register B
	TCCR2B_FOC2A     = 0x80 // Force Output Compare A
	TCCR2B_FOC2A_Msk = 0x80 // Force Output Compare A
	TCCR2B_FOC2B     = 0x40 // Force Output Compare B
	TCCR2B_FOC2B_Msk = 0x40 // Force Output Compare B
	TCCR2B_WGM22     = 0x8  // Waveform Generation Mode
	TCCR2B_WGM22_Msk = 0x8  // Waveform Generation Mode
	TCCR2B_CS20      = 0x1  // Clock Select bits
	TCCR2B_CS21      = 0x2  // Clock Select bits
	TCCR2B_CS22      = 0x4  // Clock Select bits
	TCCR2B_CS2_Msk   = 0x7  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_EXCLK       = 0x40 // Enable External Clock Input
	ASSR_EXCLK_Msk   = 0x40 // Enable External Clock Input
	ASSR_AS2         = 0x20 // Asynchronous Timer/Counter2
	ASSR_AS2_Msk     = 0x20 // Asynchronous Timer/Counter2
	ASSR_TCN2UB      = 0x10 // Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk  = 0x10 // Timer/Counter2 Update Busy
	ASSR_OCR2AUB     = 0x8  // Output Compare Register2 Update Busy
	ASSR_OCR2AUB_Msk = 0x8  // Output Compare Register2 Update Busy
	ASSR_OCR2BUB     = 0x4  // Output Compare Register 2 Update Busy
	ASSR_OCR2BUB_Msk = 0x4  // Output Compare Register 2 Update Busy
	ASSR_TCR2AUB     = 0x2  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2AUB_Msk = 0x2  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2BUB     = 0x1  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2BUB_Msk = 0x1  // Timer/Counter Control Register2 Update Busy
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits

	// DIDR: Digital Input Disable Register 1
	DIDR_AINP0D     = 0x1  // AINP0 Digital Input Disable
	DIDR_AINP0D_Msk = 0x1  // AINP0 Digital Input Disable
	DIDR_AINP1D     = 0x2  // AINP1 Digital Input Disable
	DIDR_AINP1D_Msk = 0x2  // AINP1 Digital Input Disable
	DIDR_AINN0D     = 0x4  // AINN0 Digital Input Disable
	DIDR_AINN0D_Msk = 0x4  // AINN0 Digital Input Disable
	DIDR_AINN1D     = 0x8  // AINN1 Digital Input Disable
	DIDR_AINN1D_Msk = 0x8  // AINN1 Digital Input Disable
	DIDR_AINN2D     = 0x10 // AINN2 Digital Input Disable
	DIDR_AINN2D_Msk = 0x10 // AINN2 Digital Input Disable

	// ACMUX: Analog Comparator Mux register
	ACMUX_MUXNEG0    = 0x1  // Analog Comparator Negative input select
	ACMUX_MUXNEG1    = 0x2  // Analog Comparator Negative input select
	ACMUX_MUXNEG_Msk = 0x3  // Analog Comparator Negative input select
	ACMUX_MUXPOS     = 0x4  // Analog Comparator Positive input select
	ACMUX_MUXPOS_Msk = 0x4  // Analog Comparator Positive input select
	ACMUX_ACOE       = 0x8  // Analog Comparator Output Enable
	ACMUX_ACOE_Msk   = 0x8  // Analog Comparator Output Enable
	ACMUX_CLIS0      = 0x10 // Custom Logic Interrupt Select
	ACMUX_CLIS1      = 0x20 // Custom Logic Interrupt Select
	ACMUX_CLIS_Msk   = 0x30 // Custom Logic Interrupt Select
	ACMUX_CLIE       = 0x40 // Custom Logic Interrupt Enable
	ACMUX_CLIE_Msk   = 0x40 // Custom Logic Interrupt Enable

	// CLCR: Custom Logic Control Register
	CLCR_CLSET         = 0x80 // Custom Logic Set
	CLCR_CLSET_Msk     = 0x80 // Custom Logic Set
	CLCR_CLCLR         = 0x40 // Custom Logic Clear
	CLCR_CLCLR_Msk     = 0x40 // Custom Logic Clear
	CLCR_TC3TRIGEN     = 0x20 // Custom Logic Trigger Timer/Counter 3
	CLCR_TC3TRIGEN_Msk = 0x20 // Custom Logic Trigger Timer/Counter 3
	CLCR_CLOEN0        = 0x8  // Custom Logic Output Enable
	CLCR_CLOEN1        = 0x10 // Custom Logic Output Enable
	CLCR_CLOEN_Msk     = 0x18 // Custom Logic Output Enable
	CLCR_SEL           = 0x4  // Custom Logic Demux Select
	CLCR_SEL_Msk       = 0x4  // Custom Logic Demux Select
	CLCR_INVEN         = 0x2  // Custom Logic Inverter Enable
	CLCR_INVEN_Msk     = 0x2  // Custom Logic Inverter Enable
	CLCR_CLEN          = 0x1  // Custom Logic Enable
	CLCR_CLEN_Msk      = 0x1  // Custom Logic Enable

	// CLSR: Custom Logic Status Register
	CLSR_CLIF      = 0x2 // Custom Logic Interrupt Flag
	CLSR_CLIF_Msk  = 0x2 // Custom Logic Interrupt Flag
	CLSR_STATE     = 0x1 // Custom Logic Latch State
	CLSR_STATE_Msk = 0x1 // Custom Logic Latch State
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC10    = 0x4 // External Interrupt Sense Control 1 Bits
	EICRA_ISC11    = 0x8 // External Interrupt Sense Control 1 Bits
	EICRA_ISC1_Msk = 0xc // External Interrupt Sense Control 1 Bits
	EICRA_ISC00    = 0x1 // External Interrupt Sense Control 0 Bits
	EICRA_ISC01    = 0x2 // External Interrupt Sense Control 0 Bits
	EICRA_ISC0_Msk = 0x3 // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Request 1 Enable
	EIMSK_INT1    = 0x2 // External Interrupt Request 1 Enable
	EIMSK_INT_Msk = 0x3 // External Interrupt Request 1 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF_Msk = 0x3 // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0    = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1    = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2    = 0x4 // Pin Change Interrupt Enables
	PCICR_PCIE_Msk = 0x7 // Pin Change Interrupt Enables

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK2_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK2_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK2_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT_Msk = 0x7f // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK0_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0    = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1    = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2    = 0x4 // Pin Change Interrupt Flags
	PCIFR_PCIF_Msk = 0x7 // Pin Change Interrupt Flags
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEPE      = 0x2  // EEPROM Write Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for CPU: CPU Registers
const (
	// PRR0: Power Reduction Register 0
	PRR0_PRTIM2       = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM2_Msk   = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM0       = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM0_Msk   = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM1       = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRTIM1_Msk   = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI        = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRSPI_Msk    = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRUSART1     = 0x10 // Power Reduction USART
	PRR0_PRUSART1_Msk = 0x10 // Power Reduction USART

	// PRR1: Power Reduction Register 1
	PRR1_PRTIM3     = 0x1 // Power Reduction Timer/Counter3
	PRR1_PRTIM3_Msk = 0x1 // Power Reduction Timer/Counter3

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR: Clock Prescale Register
	CLKPR_CLKPCE     = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPCE_Msk = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPS0     = 0x1  // Clock Prescaler Select Bits
	CLKPR_CLKPS1     = 0x2  // Clock Prescaler Select Bits
	CLKPR_CLKPS2     = 0x4  // Clock Prescaler Select Bits
	CLKPR_CLKPS3     = 0x8  // Clock Prescaler Select Bits
	CLKPR_CLKPS_Msk  = 0xf  // Clock Prescaler Select Bits

	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// SPMCSR: Store Program Memory Control and Status Register
	SPMCSR_SPMIE         = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk     = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB         = 0x40 // Read-While-Write Section Busy
	SPMCSR_RWWSB_Msk     = 0x40 // Read-While-Write Section Busy
	SPMCSR_RWWSRE        = 0x10 // Read-While-Write section read enable
	SPMCSR_RWWSRE_Msk    = 0x10 // Read-While-Write section read enable
	SPMCSR_BLBSET        = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk    = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT         = 0x4  // Page Write
	SPMCSR_PGWRT_Msk     = 0x4  // Page Write
	SPMCSR_PGERS         = 0x2  // Page Erase
	SPMCSR_PGERS_Msk     = 0x2  // Page Erase
	SPMCSR_SELFPRGEN     = 0x1  // Self Programming Enable
	SPMCSR_SELFPRGEN_Msk = 0x1  // Self Programming Enable

	// MCUCR: MCU Control Register
	MCUCR_BODS      = 0x40 // BOD Sleep
	MCUCR_BODS_Msk  = 0x40 // BOD Sleep
	MCUCR_BODSE     = 0x20 // BOD Sleep Enable
	MCUCR_BODSE_Msk = 0x20 // BOD Sleep Enable
	MCUCR_PUD       = 0x10
	MCUCR_PUD_Msk   = 0x10
	MCUCR_IVSEL     = 0x2
	MCUCR_IVSEL_Msk = 0x2
	MCUCR_IVCE      = 0x1
	MCUCR_IVCE_Msk  = 0x1

	// MCUSR: MCU Status Register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1 // Power-on reset flag

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select Bits
	SMCR_SM1    = 0x4 // Sleep Mode Select Bits
	SMCR_SM2    = 0x8 // Sleep Mode Select Bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select Bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable
)
