// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega32C1.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega32c1
// +build avr,atmega32c1

// Device information for the ATmega32C1.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega32C1"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset, Watchdog Reset and JTAG AVR Reset
	IRQ_ANACOMP0     = 1  // Analog Comparator 0
	IRQ_ANACOMP1     = 2  // Analog Comparator 1
	IRQ_ANACOMP2     = 3  // Analog Comparator 2
	IRQ_ANACOMP3     = 4  // Analog Comparator 3
	IRQ_PSC_FAULT    = 5  // PSC Fault
	IRQ_PSC_EC       = 6  // PSC End of Cycle
	IRQ_INT0         = 7  // External Interrupt Request 0
	IRQ_INT1         = 8  // External Interrupt Request 1
	IRQ_INT2         = 9  // External Interrupt Request 2
	IRQ_INT3         = 10 // External Interrupt Request 3
	IRQ_TIMER1_CAPT  = 11 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 12 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 13 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 14 // Timer1/Counter1 Overflow
	IRQ_TIMER0_COMPA = 15 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 16 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 17 // Timer/Counter0 Overflow
	IRQ_CAN_INT      = 18 // CAN MOB, Burst, General Errors
	IRQ_CAN_TOVF     = 19 // CAN Timer Overflow
	IRQ_LIN_TC       = 20 // LIN Transfer Complete
	IRQ_LIN_ERR      = 21 // LIN Error
	IRQ_PCINT0       = 22 // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 23 // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 24 // Pin Change Interrupt Request 2
	IRQ_PCINT3       = 25 // Pin Change Interrupt Request 3
	IRQ_SPI_STC      = 26 // SPI Serial Transfer Complete
	IRQ_ADC          = 27 // ADC Conversion Complete
	IRQ_WDT          = 28 // Watchdog Time-Out Interrupt
	IRQ_EE_READY     = 29 // EEPROM Ready
	IRQ_SPM_READY    = 30 // Store Program Memory Read
	IRQ_max          = 30 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_ANACOMP0
//go:interrupt
func interruptANACOMP0() {
	callHandlers(IRQ_ANACOMP0)
}

//export __vector_ANACOMP1
//go:interrupt
func interruptANACOMP1() {
	callHandlers(IRQ_ANACOMP1)
}

//export __vector_ANACOMP2
//go:interrupt
func interruptANACOMP2() {
	callHandlers(IRQ_ANACOMP2)
}

//export __vector_ANACOMP3
//go:interrupt
func interruptANACOMP3() {
	callHandlers(IRQ_ANACOMP3)
}

//export __vector_PSC_FAULT
//go:interrupt
func interruptPSC_FAULT() {
	callHandlers(IRQ_PSC_FAULT)
}

//export __vector_PSC_EC
//go:interrupt
func interruptPSC_EC() {
	callHandlers(IRQ_PSC_EC)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_CAN_INT
//go:interrupt
func interruptCAN_INT() {
	callHandlers(IRQ_CAN_INT)
}

//export __vector_CAN_TOVF
//go:interrupt
func interruptCAN_TOVF() {
	callHandlers(IRQ_CAN_TOVF)
}

//export __vector_LIN_TC
//go:interrupt
func interruptLIN_TC() {
	callHandlers(IRQ_LIN_TC)
}

//export __vector_LIN_ERR
//go:interrupt
func interruptLIN_ERR() {
	callHandlers(IRQ_LIN_ERR)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_PCINT2
//go:interrupt
func interruptPCINT2() {
	callHandlers(IRQ_PCINT2)
}

//export __vector_PCINT3
//go:interrupt
func interruptPCINT3() {
	callHandlers(IRQ_PCINT3)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))

	// Controller Area Network
	CANGCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	CANGSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	CANGIT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	CANGIE   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdb)))
	CANEN2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdc)))
	CANEN1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	CANIE2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	CANIE1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	CANSIT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	CANSIT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	CANBT1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	CANBT2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	CANBT3   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	CANTCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	CANTIML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	CANTIMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe7)))
	CANTTCL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	CANTTCH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	CANTEC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	CANREC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	CANHPMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	CANPAGE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	CANSTMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	CANCDMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	CANIDT4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	CANIDT3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	CANIDT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	CANIDT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	CANIDM4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	CANIDM3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	CANIDM2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	CANIDM1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	CANSTML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	CANSTMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	CANMSG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfa)))

	// Analog Comparator
	AC0CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	AC1CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	AC2CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	AC3CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	ACSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// Digital-to-Analog Converter
	DACL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	DACH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	DACON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))

	// CPU Registers
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	PRR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Timer/Counter, 8-bit
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Analog-to-Digital Converter
	ADMUX   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	DIDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	AMP0CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	AMP1CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x76)))
	AMP2CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))

	// Local Interconnect Network
	LINCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	LINSIR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	LINENIR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	LINERR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	LINBTR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	LINBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))
	LINBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	LINDLR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcf)))
	LINIDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	LINSEL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	LINDAT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_PSCRB        = 0x20 // PSC Reset Behavior
	EXTENDED_PSCRB_Msk    = 0x20 // PSC Reset Behavior
	EXTENDED_PSCRVA       = 0x10 // PSCOUTnA Reset Value
	EXTENDED_PSCRVA_Msk   = 0x10 // PSCOUTnA Reset Value
	EXTENDED_PSCRVB       = 0x8  // PSC0UTnB Reset Value
	EXTENDED_PSCRVB_Msk   = 0x8  // PSC0UTnB Reset Value
	EXTENDED_BODLEVEL0    = 0x1  // Brown-out Detector Trigger Level
	EXTENDED_BODLEVEL1    = 0x2  // Brown-out Detector Trigger Level
	EXTENDED_BODLEVEL2    = 0x4  // Brown-out Detector Trigger Level
	EXTENDED_BODLEVEL_Msk = 0x7  // Brown-out Detector Trigger Level

	// HIGH
	HIGH_RSTDISBL     = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_RSTDISBL_Msk = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_DWEN         = 0x40 // Debug Wire enable
	HIGH_DWEN_Msk     = 0x40 // Debug Wire enable
	HIGH_SPIEN        = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON        = 0x10 // Watch-dog Timer always on
	HIGH_WDTON_Msk    = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE       = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0      = 0x2  // Select Boot Size
	HIGH_BOOTSZ1      = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk   = 0x6  // Select Boot Size
	HIGH_BOOTRST      = 0x1  // Select Reset Vector
	HIGH_BOOTRST_Msk  = 0x1  // Select Reset Vector

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTD1
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTD1
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for CAN: Controller Area Network
const (
	// CANGCON: CAN General Control Register
	CANGCON_ABRQ       = 0x80 // Abort Request
	CANGCON_ABRQ_Msk   = 0x80 // Abort Request
	CANGCON_OVRQ       = 0x40 // Overload Frame Request
	CANGCON_OVRQ_Msk   = 0x40 // Overload Frame Request
	CANGCON_TTC        = 0x20 // Time Trigger Communication
	CANGCON_TTC_Msk    = 0x20 // Time Trigger Communication
	CANGCON_SYNTTC     = 0x10 // Synchronization of TTC
	CANGCON_SYNTTC_Msk = 0x10 // Synchronization of TTC
	CANGCON_LISTEN     = 0x8  // Listening Mode
	CANGCON_LISTEN_Msk = 0x8  // Listening Mode
	CANGCON_TEST       = 0x4  // Test Mode
	CANGCON_TEST_Msk   = 0x4  // Test Mode
	CANGCON_ENASTB     = 0x2  // Enable / Standby
	CANGCON_ENASTB_Msk = 0x2  // Enable / Standby
	CANGCON_SWRES      = 0x1  // Software Reset Request
	CANGCON_SWRES_Msk  = 0x1  // Software Reset Request

	// CANGSTA: CAN General Status Register
	CANGSTA_OVFG      = 0x40 // Overload Frame Flag
	CANGSTA_OVFG_Msk  = 0x40 // Overload Frame Flag
	CANGSTA_TXBSY     = 0x10 // Transmitter Busy
	CANGSTA_TXBSY_Msk = 0x10 // Transmitter Busy
	CANGSTA_RXBSY     = 0x8  // Receiver Busy
	CANGSTA_RXBSY_Msk = 0x8  // Receiver Busy
	CANGSTA_ENFG      = 0x4  // Enable Flag
	CANGSTA_ENFG_Msk  = 0x4  // Enable Flag
	CANGSTA_BOFF      = 0x2  // Bus Off Mode
	CANGSTA_BOFF_Msk  = 0x2  // Bus Off Mode
	CANGSTA_ERRP      = 0x1  // Error Passive Mode
	CANGSTA_ERRP_Msk  = 0x1  // Error Passive Mode

	// CANGIT: CAN General Interrupt Register Flags
	CANGIT_CANIT      = 0x80 // General Interrupt Flag
	CANGIT_CANIT_Msk  = 0x80 // General Interrupt Flag
	CANGIT_BOFFIT     = 0x40 // Bus Off Interrupt Flag
	CANGIT_BOFFIT_Msk = 0x40 // Bus Off Interrupt Flag
	CANGIT_OVRTIM     = 0x20 // Overrun CAN Timer Flag
	CANGIT_OVRTIM_Msk = 0x20 // Overrun CAN Timer Flag
	CANGIT_BXOK       = 0x10 // Burst Receive Interrupt Flag
	CANGIT_BXOK_Msk   = 0x10 // Burst Receive Interrupt Flag
	CANGIT_SERG       = 0x8  // Stuff Error General Flag
	CANGIT_SERG_Msk   = 0x8  // Stuff Error General Flag
	CANGIT_CERG       = 0x4  // CRC Error General Flag
	CANGIT_CERG_Msk   = 0x4  // CRC Error General Flag
	CANGIT_FERG       = 0x2  // Form Error General Flag
	CANGIT_FERG_Msk   = 0x2  // Form Error General Flag
	CANGIT_AERG       = 0x1  // Ackknowledgement Error General Flag
	CANGIT_AERG_Msk   = 0x1  // Ackknowledgement Error General Flag

	// CANGIE: CAN General Interrupt Enable Register
	CANGIE_ENIT       = 0x80 // Enable all Interrupts
	CANGIE_ENIT_Msk   = 0x80 // Enable all Interrupts
	CANGIE_ENBOFF     = 0x40 // Enable Bus Off Interrupt
	CANGIE_ENBOFF_Msk = 0x40 // Enable Bus Off Interrupt
	CANGIE_ENRX       = 0x20 // Enable Receive Interrupt
	CANGIE_ENRX_Msk   = 0x20 // Enable Receive Interrupt
	CANGIE_ENTX       = 0x10 // Enable Transmitt Interrupt
	CANGIE_ENTX_Msk   = 0x10 // Enable Transmitt Interrupt
	CANGIE_ENERR      = 0x8  // Enable MOb Error Interrupt
	CANGIE_ENERR_Msk  = 0x8  // Enable MOb Error Interrupt
	CANGIE_ENBX       = 0x4  // Enable Burst Receive Interrupt
	CANGIE_ENBX_Msk   = 0x4  // Enable Burst Receive Interrupt
	CANGIE_ENERG      = 0x2  // Enable General Error Interrupt
	CANGIE_ENERG_Msk  = 0x2  // Enable General Error Interrupt
	CANGIE_ENOVRT     = 0x1  // Enable CAN Timer Overrun Interrupt
	CANGIE_ENOVRT_Msk = 0x1  // Enable CAN Timer Overrun Interrupt

	// CANEN2: Enable MOb Register 2
	CANEN2_ENMOB0    = 0x1  // Enable MObs
	CANEN2_ENMOB1    = 0x2  // Enable MObs
	CANEN2_ENMOB2    = 0x4  // Enable MObs
	CANEN2_ENMOB3    = 0x8  // Enable MObs
	CANEN2_ENMOB4    = 0x10 // Enable MObs
	CANEN2_ENMOB5    = 0x20 // Enable MObs
	CANEN2_ENMOB_Msk = 0x3f // Enable MObs

	// CANIE2: Enable Interrupt MOb Register 2
	CANIE2_IEMOB0    = 0x1  // Interrupt Enable  MObs
	CANIE2_IEMOB1    = 0x2  // Interrupt Enable  MObs
	CANIE2_IEMOB2    = 0x4  // Interrupt Enable  MObs
	CANIE2_IEMOB3    = 0x8  // Interrupt Enable  MObs
	CANIE2_IEMOB4    = 0x10 // Interrupt Enable  MObs
	CANIE2_IEMOB5    = 0x20 // Interrupt Enable  MObs
	CANIE2_IEMOB_Msk = 0x3f // Interrupt Enable  MObs

	// CANSIT2: CAN Status Interrupt MOb Register 2
	CANSIT2_SIT0    = 0x1  // Status of Interrupt MObs
	CANSIT2_SIT1    = 0x2  // Status of Interrupt MObs
	CANSIT2_SIT2    = 0x4  // Status of Interrupt MObs
	CANSIT2_SIT3    = 0x8  // Status of Interrupt MObs
	CANSIT2_SIT4    = 0x10 // Status of Interrupt MObs
	CANSIT2_SIT5    = 0x20 // Status of Interrupt MObs
	CANSIT2_SIT_Msk = 0x3f // Status of Interrupt MObs

	// CANBT1: CAN Bit Timing Register 1
	CANBT1_BRP0    = 0x2  // Baud Rate Prescaler bits
	CANBT1_BRP1    = 0x4  // Baud Rate Prescaler bits
	CANBT1_BRP2    = 0x8  // Baud Rate Prescaler bits
	CANBT1_BRP3    = 0x10 // Baud Rate Prescaler bits
	CANBT1_BRP4    = 0x20 // Baud Rate Prescaler bits
	CANBT1_BRP5    = 0x40 // Baud Rate Prescaler bits
	CANBT1_BRP_Msk = 0x7e // Baud Rate Prescaler bits

	// CANBT2: CAN Bit Timing Register 2
	CANBT2_SJW0    = 0x20 // Re-Sync Jump Width bits
	CANBT2_SJW1    = 0x40 // Re-Sync Jump Width bits
	CANBT2_SJW_Msk = 0x60 // Re-Sync Jump Width bits
	CANBT2_PRS0    = 0x2  // Propagation Time Segment bits
	CANBT2_PRS1    = 0x4  // Propagation Time Segment bits
	CANBT2_PRS2    = 0x8  // Propagation Time Segment bits
	CANBT2_PRS_Msk = 0xe  // Propagation Time Segment bits

	// CANBT3: CAN Bit Timing Register 3
	CANBT3_PHS20    = 0x10 // Phase Segment 2 bits
	CANBT3_PHS21    = 0x20 // Phase Segment 2 bits
	CANBT3_PHS22    = 0x40 // Phase Segment 2 bits
	CANBT3_PHS2_Msk = 0x70 // Phase Segment 2 bits
	CANBT3_PHS10    = 0x2  // Phase Segment 1 bits
	CANBT3_PHS11    = 0x4  // Phase Segment 1 bits
	CANBT3_PHS12    = 0x8  // Phase Segment 1 bits
	CANBT3_PHS1_Msk = 0xe  // Phase Segment 1 bits
	CANBT3_SMP      = 0x1  // Sample Type
	CANBT3_SMP_Msk  = 0x1  // Sample Type

	// CANTCON: Timer Control Register
	CANTCON_TPRSC0    = 0x1  // Timer Control bits
	CANTCON_TPRSC1    = 0x2  // Timer Control bits
	CANTCON_TPRSC2    = 0x4  // Timer Control bits
	CANTCON_TPRSC3    = 0x8  // Timer Control bits
	CANTCON_TPRSC4    = 0x10 // Timer Control bits
	CANTCON_TPRSC5    = 0x20 // Timer Control bits
	CANTCON_TPRSC6    = 0x40 // Timer Control bits
	CANTCON_TPRSC7    = 0x80 // Timer Control bits
	CANTCON_TPRSC_Msk = 0xff // Timer Control bits

	// CANTIML: Timer Register

	// CANTIMH: Timer Register
	CANTIM_CANTIM0    = 0x1    // CAN Timer bits
	CANTIM_CANTIM1    = 0x2    // CAN Timer bits
	CANTIM_CANTIM2    = 0x4    // CAN Timer bits
	CANTIM_CANTIM3    = 0x8    // CAN Timer bits
	CANTIM_CANTIM4    = 0x10   // CAN Timer bits
	CANTIM_CANTIM5    = 0x20   // CAN Timer bits
	CANTIM_CANTIM6    = 0x40   // CAN Timer bits
	CANTIM_CANTIM7    = 0x80   // CAN Timer bits
	CANTIM_CANTIM_Msk = 0xffff // CAN Timer bits

	// CANTTCL: TTC Timer Register

	// CANTTCH: TTC Timer Register
	CANTTC_TIMTTC0    = 0x1    // TTC Timer Count
	CANTTC_TIMTTC1    = 0x2    // TTC Timer Count
	CANTTC_TIMTTC2    = 0x4    // TTC Timer Count
	CANTTC_TIMTTC3    = 0x8    // TTC Timer Count
	CANTTC_TIMTTC4    = 0x10   // TTC Timer Count
	CANTTC_TIMTTC5    = 0x20   // TTC Timer Count
	CANTTC_TIMTTC6    = 0x40   // TTC Timer Count
	CANTTC_TIMTTC7    = 0x80   // TTC Timer Count
	CANTTC_TIMTTC_Msk = 0xffff // TTC Timer Count

	// CANTEC: Transmit Error Counter Register
	CANTEC_TEC0    = 0x1  // Transmit Error Counter bits
	CANTEC_TEC1    = 0x2  // Transmit Error Counter bits
	CANTEC_TEC2    = 0x4  // Transmit Error Counter bits
	CANTEC_TEC3    = 0x8  // Transmit Error Counter bits
	CANTEC_TEC4    = 0x10 // Transmit Error Counter bits
	CANTEC_TEC5    = 0x20 // Transmit Error Counter bits
	CANTEC_TEC6    = 0x40 // Transmit Error Counter bits
	CANTEC_TEC7    = 0x80 // Transmit Error Counter bits
	CANTEC_TEC_Msk = 0xff // Transmit Error Counter bits

	// CANREC: Receive Error Counter Register
	CANREC_REC0    = 0x1  // Receive Error Counter bits
	CANREC_REC1    = 0x2  // Receive Error Counter bits
	CANREC_REC2    = 0x4  // Receive Error Counter bits
	CANREC_REC3    = 0x8  // Receive Error Counter bits
	CANREC_REC4    = 0x10 // Receive Error Counter bits
	CANREC_REC5    = 0x20 // Receive Error Counter bits
	CANREC_REC6    = 0x40 // Receive Error Counter bits
	CANREC_REC7    = 0x80 // Receive Error Counter bits
	CANREC_REC_Msk = 0xff // Receive Error Counter bits

	// CANHPMOB: Highest Priority MOb Register
	CANHPMOB_HPMOB0    = 0x10 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB1    = 0x20 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB2    = 0x40 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB3    = 0x80 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB_Msk = 0xf0 // Highest Priority MOb Number bits
	CANHPMOB_CGP0      = 0x1  // CAN General Purpose bits
	CANHPMOB_CGP1      = 0x2  // CAN General Purpose bits
	CANHPMOB_CGP2      = 0x4  // CAN General Purpose bits
	CANHPMOB_CGP3      = 0x8  // CAN General Purpose bits
	CANHPMOB_CGP_Msk   = 0xf  // CAN General Purpose bits

	// CANPAGE: Page MOb Register
	CANPAGE_MOBNB0    = 0x10 // MOb Number bits
	CANPAGE_MOBNB1    = 0x20 // MOb Number bits
	CANPAGE_MOBNB2    = 0x40 // MOb Number bits
	CANPAGE_MOBNB3    = 0x80 // MOb Number bits
	CANPAGE_MOBNB_Msk = 0xf0 // MOb Number bits
	CANPAGE_AINC      = 0x8  // MOb Data Buffer Auto Increment (Active Low)
	CANPAGE_AINC_Msk  = 0x8  // MOb Data Buffer Auto Increment (Active Low)
	CANPAGE_INDX0     = 0x1  // Data Buffer Index bits
	CANPAGE_INDX1     = 0x2  // Data Buffer Index bits
	CANPAGE_INDX2     = 0x4  // Data Buffer Index bits
	CANPAGE_INDX_Msk  = 0x7  // Data Buffer Index bits

	// CANSTMOB: MOb Status Register
	CANSTMOB_DLCW     = 0x80 // Data Length Code Warning on MOb
	CANSTMOB_DLCW_Msk = 0x80 // Data Length Code Warning on MOb
	CANSTMOB_TXOK     = 0x40 // Transmit OK on MOb
	CANSTMOB_TXOK_Msk = 0x40 // Transmit OK on MOb
	CANSTMOB_RXOK     = 0x20 // Receive OK on MOb
	CANSTMOB_RXOK_Msk = 0x20 // Receive OK on MOb
	CANSTMOB_BERR     = 0x10 // Bit Error on MOb
	CANSTMOB_BERR_Msk = 0x10 // Bit Error on MOb
	CANSTMOB_SERR     = 0x8  // Stuff Error on MOb
	CANSTMOB_SERR_Msk = 0x8  // Stuff Error on MOb
	CANSTMOB_CERR     = 0x4  // CRC Error on MOb
	CANSTMOB_CERR_Msk = 0x4  // CRC Error on MOb
	CANSTMOB_FERR     = 0x2  // Form Error on MOb
	CANSTMOB_FERR_Msk = 0x2  // Form Error on MOb
	CANSTMOB_AERR     = 0x1  // Ackknowledgement Error on MOb
	CANSTMOB_AERR_Msk = 0x1  // Ackknowledgement Error on MOb

	// CANCDMOB: MOb Control and DLC Register
	CANCDMOB_CONMOB0    = 0x40 // MOb Config bits
	CANCDMOB_CONMOB1    = 0x80 // MOb Config bits
	CANCDMOB_CONMOB_Msk = 0xc0 // MOb Config bits
	CANCDMOB_RPLV       = 0x20 // Reply Valid
	CANCDMOB_RPLV_Msk   = 0x20 // Reply Valid
	CANCDMOB_IDE        = 0x10 // Identifier Extension
	CANCDMOB_IDE_Msk    = 0x10 // Identifier Extension
	CANCDMOB_DLC0       = 0x1  // Data Length Code bits
	CANCDMOB_DLC1       = 0x2  // Data Length Code bits
	CANCDMOB_DLC2       = 0x4  // Data Length Code bits
	CANCDMOB_DLC3       = 0x8  // Data Length Code bits
	CANCDMOB_DLC_Msk    = 0xf  // Data Length Code bits

	// CANIDT4: Identifier Tag Register 4
	CANIDT4_IDT0       = 0x8  // Identifier Tag
	CANIDT4_IDT1       = 0x10 // Identifier Tag
	CANIDT4_IDT2       = 0x20 // Identifier Tag
	CANIDT4_IDT3       = 0x40 // Identifier Tag
	CANIDT4_IDT4       = 0x80 // Identifier Tag
	CANIDT4_IDT_Msk    = 0xf8 // Identifier Tag
	CANIDT4_RTRTAG     = 0x4  // Remote Transmission Request Tag
	CANIDT4_RTRTAG_Msk = 0x4  // Remote Transmission Request Tag
	CANIDT4_RB1TAG     = 0x2  // Reserved Bit 1 Tag
	CANIDT4_RB1TAG_Msk = 0x2  // Reserved Bit 1 Tag
	CANIDT4_RB0TAG     = 0x1  // Reserved Bit 0 Tag
	CANIDT4_RB0TAG_Msk = 0x1  // Reserved Bit 0 Tag

	// CANIDT3: Identifier Tag Register 3
	CANIDT3_IDT0    = 0x1  // Identifier Tag
	CANIDT3_IDT1    = 0x2  // Identifier Tag
	CANIDT3_IDT2    = 0x4  // Identifier Tag
	CANIDT3_IDT3    = 0x8  // Identifier Tag
	CANIDT3_IDT4    = 0x10 // Identifier Tag
	CANIDT3_IDT5    = 0x20 // Identifier Tag
	CANIDT3_IDT6    = 0x40 // Identifier Tag
	CANIDT3_IDT7    = 0x80 // Identifier Tag
	CANIDT3_IDT_Msk = 0xff // Identifier Tag

	// CANIDT2: Identifier Tag Register 2
	CANIDT2_IDT0    = 0x1  // Identifier Tag
	CANIDT2_IDT1    = 0x2  // Identifier Tag
	CANIDT2_IDT2    = 0x4  // Identifier Tag
	CANIDT2_IDT3    = 0x8  // Identifier Tag
	CANIDT2_IDT4    = 0x10 // Identifier Tag
	CANIDT2_IDT5    = 0x20 // Identifier Tag
	CANIDT2_IDT6    = 0x40 // Identifier Tag
	CANIDT2_IDT7    = 0x80 // Identifier Tag
	CANIDT2_IDT_Msk = 0xff // Identifier Tag

	// CANIDT1: Identifier Tag Register 1
	CANIDT1_IDT0    = 0x1  // Identifier Tag
	CANIDT1_IDT1    = 0x2  // Identifier Tag
	CANIDT1_IDT2    = 0x4  // Identifier Tag
	CANIDT1_IDT3    = 0x8  // Identifier Tag
	CANIDT1_IDT4    = 0x10 // Identifier Tag
	CANIDT1_IDT5    = 0x20 // Identifier Tag
	CANIDT1_IDT6    = 0x40 // Identifier Tag
	CANIDT1_IDT7    = 0x80 // Identifier Tag
	CANIDT1_IDT_Msk = 0xff // Identifier Tag

	// CANIDM4: Identifier Mask Register 4
	CANIDM4_IDEMSK     = 0x1  // Identifier Extension Mask
	CANIDM4_IDEMSK_Msk = 0x1  // Identifier Extension Mask
	CANIDM4_RTRMSK     = 0x4  // Remote Transmission Request Mask
	CANIDM4_RTRMSK_Msk = 0x4  // Remote Transmission Request Mask
	CANIDM4_IDMSK0     = 0x8  // Identifier Mask
	CANIDM4_IDMSK1     = 0x10 // Identifier Mask
	CANIDM4_IDMSK2     = 0x20 // Identifier Mask
	CANIDM4_IDMSK3     = 0x40 // Identifier Mask
	CANIDM4_IDMSK4     = 0x80 // Identifier Mask
	CANIDM4_IDMSK_Msk  = 0xf8 // Identifier Mask

	// CANIDM3: Identifier Mask Register 3
	CANIDM3_IDMSK0    = 0x1  // Identifier Mask
	CANIDM3_IDMSK1    = 0x2  // Identifier Mask
	CANIDM3_IDMSK2    = 0x4  // Identifier Mask
	CANIDM3_IDMSK3    = 0x8  // Identifier Mask
	CANIDM3_IDMSK4    = 0x10 // Identifier Mask
	CANIDM3_IDMSK5    = 0x20 // Identifier Mask
	CANIDM3_IDMSK6    = 0x40 // Identifier Mask
	CANIDM3_IDMSK7    = 0x80 // Identifier Mask
	CANIDM3_IDMSK_Msk = 0xff // Identifier Mask

	// CANIDM2: Identifier Mask Register 2
	CANIDM2_IDMSK0    = 0x1  // Identifier Mask
	CANIDM2_IDMSK1    = 0x2  // Identifier Mask
	CANIDM2_IDMSK2    = 0x4  // Identifier Mask
	CANIDM2_IDMSK3    = 0x8  // Identifier Mask
	CANIDM2_IDMSK4    = 0x10 // Identifier Mask
	CANIDM2_IDMSK5    = 0x20 // Identifier Mask
	CANIDM2_IDMSK6    = 0x40 // Identifier Mask
	CANIDM2_IDMSK7    = 0x80 // Identifier Mask
	CANIDM2_IDMSK_Msk = 0xff // Identifier Mask

	// CANIDM1: Identifier Mask Register 1
	CANIDM1_IDMSK0    = 0x1  // Identifier Mask
	CANIDM1_IDMSK1    = 0x2  // Identifier Mask
	CANIDM1_IDMSK2    = 0x4  // Identifier Mask
	CANIDM1_IDMSK3    = 0x8  // Identifier Mask
	CANIDM1_IDMSK4    = 0x10 // Identifier Mask
	CANIDM1_IDMSK5    = 0x20 // Identifier Mask
	CANIDM1_IDMSK6    = 0x40 // Identifier Mask
	CANIDM1_IDMSK7    = 0x80 // Identifier Mask
	CANIDM1_IDMSK_Msk = 0xff // Identifier Mask

	// CANSTML: Time Stamp Register

	// CANSTMH: Time Stamp Register
	CANSTM_TIMSTM0    = 0x1    // TIMSTM
	CANSTM_TIMSTM1    = 0x2    // TIMSTM
	CANSTM_TIMSTM2    = 0x4    // TIMSTM
	CANSTM_TIMSTM3    = 0x8    // TIMSTM
	CANSTM_TIMSTM4    = 0x10   // TIMSTM
	CANSTM_TIMSTM5    = 0x20   // TIMSTM
	CANSTM_TIMSTM6    = 0x40   // TIMSTM
	CANSTM_TIMSTM7    = 0x80   // TIMSTM
	CANSTM_TIMSTM_Msk = 0xffff // TIMSTM

	// CANMSG: Message Data Register
	CANMSG_MSG0    = 0x1  // Message Data bits
	CANMSG_MSG1    = 0x2  // Message Data bits
	CANMSG_MSG2    = 0x4  // Message Data bits
	CANMSG_MSG3    = 0x8  // Message Data bits
	CANMSG_MSG4    = 0x10 // Message Data bits
	CANMSG_MSG5    = 0x20 // Message Data bits
	CANMSG_MSG6    = 0x40 // Message Data bits
	CANMSG_MSG7    = 0x80 // Message Data bits
	CANMSG_MSG_Msk = 0xff // Message Data bits
)

// Bitfields for AC: Analog Comparator
const (
	// AC0CON: Analog Comparator 0 Control Register
	AC0CON_AC0EN       = 0x80 // Analog Comparator 0 Enable Bit
	AC0CON_AC0EN_Msk   = 0x80 // Analog Comparator 0 Enable Bit
	AC0CON_AC0IE       = 0x40 // Analog Comparator 0 Interrupt Enable Bit
	AC0CON_AC0IE_Msk   = 0x40 // Analog Comparator 0 Interrupt Enable Bit
	AC0CON_AC0IS0      = 0x10 // Analog Comparator 0  Interrupt Select Bits
	AC0CON_AC0IS1      = 0x20 // Analog Comparator 0  Interrupt Select Bits
	AC0CON_AC0IS_Msk   = 0x30 // Analog Comparator 0  Interrupt Select Bits
	AC0CON_ACCKSEL     = 0x8  // Analog Comparator Clock Select
	AC0CON_ACCKSEL_Msk = 0x8  // Analog Comparator Clock Select
	AC0CON_AC0M0       = 0x1  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M1       = 0x2  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M2       = 0x4  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M_Msk    = 0x7  // Analog Comparator 0 Multiplexer Register

	// AC1CON: Analog Comparator 1 Control Register
	AC1CON_AC1EN      = 0x80 // Analog Comparator 1 Enable Bit
	AC1CON_AC1EN_Msk  = 0x80 // Analog Comparator 1 Enable Bit
	AC1CON_AC1IE      = 0x40 // Analog Comparator 1 Interrupt Enable Bit
	AC1CON_AC1IE_Msk  = 0x40 // Analog Comparator 1 Interrupt Enable Bit
	AC1CON_AC1IS0     = 0x10 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1IS1     = 0x20 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1IS_Msk  = 0x30 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1ICE     = 0x8  // Analog Comparator 1 Interrupt Capture Enable Bit
	AC1CON_AC1ICE_Msk = 0x8  // Analog Comparator 1 Interrupt Capture Enable Bit
	AC1CON_AC1M0      = 0x1  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M1      = 0x2  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M2      = 0x4  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M_Msk   = 0x7  // Analog Comparator 1 Multiplexer Register

	// AC2CON: Analog Comparator 2 Control Register
	AC2CON_AC2EN     = 0x80 // Analog Comparator 2 Enable Bit
	AC2CON_AC2EN_Msk = 0x80 // Analog Comparator 2 Enable Bit
	AC2CON_AC2IE     = 0x40 // Analog Comparator 2 Interrupt Enable Bit
	AC2CON_AC2IE_Msk = 0x40 // Analog Comparator 2 Interrupt Enable Bit
	AC2CON_AC2IS0    = 0x10 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2IS1    = 0x20 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2IS_Msk = 0x30 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2M0     = 0x1  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M1     = 0x2  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M2     = 0x4  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M_Msk  = 0x7  // Analog Comparator 2 Multiplexer Register

	// AC3CON: Analog Comparator 3 Control Register
	AC3CON_AC3EN     = 0x80 // Analog Comparator 3 Enable Bit
	AC3CON_AC3EN_Msk = 0x80 // Analog Comparator 3 Enable Bit
	AC3CON_AC3IE     = 0x40 // Analog Comparator 3 Interrupt Enable Bit
	AC3CON_AC3IE_Msk = 0x40 // Analog Comparator 3 Interrupt Enable Bit
	AC3CON_AC3IS0    = 0x10 // Analog Comparator 3  Interrupt Select Bit
	AC3CON_AC3IS1    = 0x20 // Analog Comparator 3  Interrupt Select Bit
	AC3CON_AC3IS_Msk = 0x30 // Analog Comparator 3  Interrupt Select Bit
	AC3CON_AC3M0     = 0x1  // Analog Comparator 3 Multiplexer Register
	AC3CON_AC3M1     = 0x2  // Analog Comparator 3 Multiplexer Register
	AC3CON_AC3M2     = 0x4  // Analog Comparator 3 Multiplexer Register
	AC3CON_AC3M_Msk  = 0x7  // Analog Comparator 3 Multiplexer Register

	// ACSR: Analog Comparator Status Register
	ACSR_AC3IF     = 0x80 // Analog Comparator 3 Interrupt Flag Bit
	ACSR_AC3IF_Msk = 0x80 // Analog Comparator 3 Interrupt Flag Bit
	ACSR_AC2IF     = 0x40 // Analog Comparator 2 Interrupt Flag Bit
	ACSR_AC2IF_Msk = 0x40 // Analog Comparator 2 Interrupt Flag Bit
	ACSR_AC1IF     = 0x20 // Analog Comparator 1  Interrupt Flag Bit
	ACSR_AC1IF_Msk = 0x20 // Analog Comparator 1  Interrupt Flag Bit
	ACSR_AC0IF     = 0x10 // Analog Comparator 0 Interrupt Flag Bit
	ACSR_AC0IF_Msk = 0x10 // Analog Comparator 0 Interrupt Flag Bit
	ACSR_AC3O      = 0x8  // Analog Comparator 3 Output Bit
	ACSR_AC3O_Msk  = 0x8  // Analog Comparator 3 Output Bit
	ACSR_AC2O      = 0x4  // Analog Comparator 2 Output Bit
	ACSR_AC2O_Msk  = 0x4  // Analog Comparator 2 Output Bit
	ACSR_AC1O      = 0x2  // Analog Comparator 1 Output Bit
	ACSR_AC1O_Msk  = 0x2  // Analog Comparator 1 Output Bit
	ACSR_AC0O      = 0x1  // Analog Comparator 0 Output Bit
	ACSR_AC0O_Msk  = 0x1  // Analog Comparator 0 Output Bit
)

// Bitfields for DAC: Digital-to-Analog Converter
const (
	// DACL: DAC Data Register

	// DACH: DAC Data Register
	DAC_DACH_Msk = 0xff00 // DAC Data Register High Byte Bits
	DAC_DACL0    = 0x1    // DAC Data Register Low Byte Bits
	DAC_DACL1    = 0x2    // DAC Data Register Low Byte Bits
	DAC_DACL2    = 0x4    // DAC Data Register Low Byte Bits
	DAC_DACL3    = 0x8    // DAC Data Register Low Byte Bits
	DAC_DACL4    = 0x10   // DAC Data Register Low Byte Bits
	DAC_DACL5    = 0x20   // DAC Data Register Low Byte Bits
	DAC_DACL6    = 0x40   // DAC Data Register Low Byte Bits
	DAC_DACL7    = 0x80   // DAC Data Register Low Byte Bits
	DAC_DACL_Msk = 0xff   // DAC Data Register Low Byte Bits

	// DACON: DAC Control Register
	DACON_DAATE     = 0x80 // DAC Auto Trigger Enable Bit
	DACON_DAATE_Msk = 0x80 // DAC Auto Trigger Enable Bit
	DACON_DATS0     = 0x10 // DAC Trigger Selection Bits
	DACON_DATS1     = 0x20 // DAC Trigger Selection Bits
	DACON_DATS2     = 0x40 // DAC Trigger Selection Bits
	DACON_DATS_Msk  = 0x70 // DAC Trigger Selection Bits
	DACON_DALA      = 0x4  // DAC Left Adjust
	DACON_DALA_Msk  = 0x4  // DAC Left Adjust
	DACON_DAOE      = 0x2  // DAC Output Enable
	DACON_DAOE_Msk  = 0x2  // DAC Output Enable
	DACON_DAEN      = 0x1  // DAC Enable Bit
	DACON_DAEN_Msk  = 0x1  // DAC Enable Bit
)

// Bitfields for CPU: CPU Registers
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD      = 0x20 // Signature Row Read
	SPMCSR_SIGRD_Msk  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable

	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_SPIPS     = 0x80 // SPI Pin Select
	MCUCR_SPIPS_Msk = 0x80 // SPI Pin Select
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_WDRF      = 0x8 // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF      = 0x4 // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2 // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2 // External Reset Flag
	MCUSR_PORF      = 0x1 // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1 // Power-on reset flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE     = 0x80
	CLKPR_CLKPCE_Msk = 0x80
	CLKPR_CLKPS0     = 0x1
	CLKPR_CLKPS1     = 0x2
	CLKPR_CLKPS2     = 0x4
	CLKPR_CLKPS3     = 0x8
	CLKPR_CLKPS_Msk  = 0xf

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0    = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1    = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2    = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3    = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4    = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5    = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6    = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7    = 0x80 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR_Msk = 0xff // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0    = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1    = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2    = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3    = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4    = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5    = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6    = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7    = 0x80 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR_Msk = 0xff // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07     = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR07_Msk = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06     = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR06_Msk = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05     = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR05_Msk = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04     = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR04_Msk = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03     = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR03_Msk = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02     = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR02_Msk = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01     = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR01_Msk = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00     = 0x1  // General Purpose IO Register 0 bit 0
	GPIOR0_GPIOR00_Msk = 0x1  // General Purpose IO Register 0 bit 0

	// PLLCSR: PLL Control And Status Register
	PLLCSR_PLLF      = 0x4 // PLL Factor
	PLLCSR_PLLF_Msk  = 0x4 // PLL Factor
	PLLCSR_PLLE      = 0x2 // PLL Enable
	PLLCSR_PLLE_Msk  = 0x2 // PLL Enable
	PLLCSR_PLOCK     = 0x1 // PLL Lock Detector
	PLLCSR_PLOCK_Msk = 0x1 // PLL Lock Detector

	// PRR: Power Reduction Register
	PRR_PRCAN      = 0x40 // Power Reduction CAN
	PRR_PRCAN_Msk  = 0x40 // Power Reduction CAN
	PRR_PRPSC      = 0x20 // Power Reduction PSC
	PRR_PRPSC_Msk  = 0x20 // Power Reduction PSC
	PRR_PRTIM1     = 0x10 // Power Reduction Timer/Counter1
	PRR_PRTIM1_Msk = 0x10 // Power Reduction Timer/Counter1
	PRR_PRTIM0     = 0x8  // Power Reduction Timer/Counter0
	PRR_PRTIM0_Msk = 0x8  // Power Reduction Timer/Counter0
	PRR_PRSPI      = 0x4  // Power Reduction Serial Peripheral Interface
	PRR_PRSPI_Msk  = 0x4  // Power Reduction Serial Peripheral Interface
	PRR_PRLIN      = 0x2  // Power Reduction LIN UART
	PRR_PRLIN_Msk  = 0x2  // Power Reduction LIN UART
	PRR_PRADC      = 0x1  // Power Reduction ADC
	PRR_PRADC_Msk  = 0x1  // Power Reduction ADC
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCNT0: Timer/Counter0
	TCNT0_TCNT00    = 0x1  // Timer/Counter0 bits
	TCNT0_TCNT01    = 0x2  // Timer/Counter0 bits
	TCNT0_TCNT02    = 0x4  // Timer/Counter0 bits
	TCNT0_TCNT03    = 0x8  // Timer/Counter0 bits
	TCNT0_TCNT04    = 0x10 // Timer/Counter0 bits
	TCNT0_TCNT05    = 0x20 // Timer/Counter0 bits
	TCNT0_TCNT06    = 0x40 // Timer/Counter0 bits
	TCNT0_TCNT07    = 0x80 // Timer/Counter0 bits
	TCNT0_TCNT0_Msk = 0xff // Timer/Counter0 bits

	// OCR0A: Timer/Counter0 Output Compare Register
	OCR0A_OCR0A0    = 0x1  // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A1    = 0x2  // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A2    = 0x4  // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A3    = 0x8  // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A4    = 0x10 // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A5    = 0x20 // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A6    = 0x40 // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A7    = 0x80 // Timer/Counter0 Output Compare bits
	OCR0A_OCR0A_Msk = 0xff // Timer/Counter0 Output Compare bits

	// OCR0B: Timer/Counter0 Output Compare Register
	OCR0B_OCR0B0    = 0x1  // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B1    = 0x2  // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B2    = 0x4  // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B3    = 0x8  // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B4    = 0x10 // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B5    = 0x20 // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B6    = 0x40 // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B7    = 0x80 // Timer/Counter0 Output Compare bits
	OCR0B_OCR0B_Msk = 0xff // Timer/Counter0 Output Compare bits

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_ICPSEL1     = 0x40 // Timer1 Input Capture Selection Bit
	GTCCR_ICPSEL1_Msk = 0x40 // Timer1 Input Capture Selection Bit
	GTCCR_PSR10       = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSR10_Msk   = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A     = 0x80
	TCCR1C_FOC1A_Msk = 0x80
	TCCR1C_FOC1B     = 0x40
	TCCR1C_FOC1B_Msk = 0x40

	// TCNT1L: Timer/Counter1 Bytes

	// TCNT1H: Timer/Counter1 Bytes
	TCNT1_TCNT10    = 0x1    // Timer/Counter1 bits
	TCNT1_TCNT11    = 0x2    // Timer/Counter1 bits
	TCNT1_TCNT12    = 0x4    // Timer/Counter1 bits
	TCNT1_TCNT13    = 0x8    // Timer/Counter1 bits
	TCNT1_TCNT14    = 0x10   // Timer/Counter1 bits
	TCNT1_TCNT15    = 0x20   // Timer/Counter1 bits
	TCNT1_TCNT16    = 0x40   // Timer/Counter1 bits
	TCNT1_TCNT17    = 0x80   // Timer/Counter1 bits
	TCNT1_TCNT1_Msk = 0xffff // Timer/Counter1 bits

	// OCR1AL: Timer/Counter1 Output Compare Register Bytes

	// OCR1AH: Timer/Counter1 Output Compare Register Bytes
	OCR1A_OCR1A0    = 0x1    // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A1    = 0x2    // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A2    = 0x4    // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A3    = 0x8    // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A4    = 0x10   // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A5    = 0x20   // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A6    = 0x40   // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A7    = 0x80   // Timer/Counter1 Output Compare bits
	OCR1A_OCR1A_Msk = 0xffff // Timer/Counter1 Output Compare bits

	// OCR1BL: Timer/Counter1 Output Compare Register Bytes

	// OCR1BH: Timer/Counter1 Output Compare Register Bytes
	OCR1B_OCR1B0    = 0x1    // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B1    = 0x2    // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B2    = 0x4    // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B3    = 0x8    // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B4    = 0x10   // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B5    = 0x20   // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B6    = 0x40   // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B7    = 0x80   // Timer/Counter1 Output Compare bits
	OCR1B_OCR1B_Msk = 0xffff // Timer/Counter1 Output Compare bits

	// ICR1L: Timer/Counter1 Input Capture Register Bytes

	// ICR1H: Timer/Counter1 Input Capture Register Bytes
	ICR1_ICR10    = 0x1    // Timer/Counter1 Input Capture bits
	ICR1_ICR11    = 0x2    // Timer/Counter1 Input Capture bits
	ICR1_ICR12    = 0x4    // Timer/Counter1 Input Capture bits
	ICR1_ICR13    = 0x8    // Timer/Counter1 Input Capture bits
	ICR1_ICR14    = 0x10   // Timer/Counter1 Input Capture bits
	ICR1_ICR15    = 0x20   // Timer/Counter1 Input Capture bits
	ICR1_ICR16    = 0x40   // Timer/Counter1 Input Capture bits
	ICR1_ICR17    = 0x80   // Timer/Counter1 Input Capture bits
	ICR1_ICR1_Msk = 0xffff // Timer/Counter1 Input Capture bits
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC  Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC  Prescaler Select Bits

	// ADCL: ADC Data Register Bytes

	// ADCH: ADC Data Register Bytes
	ADC_ADC0    = 0x1   // ADC Data bits
	ADC_ADC1    = 0x2   // ADC Data bits
	ADC_ADC2    = 0x4   // ADC Data bits
	ADC_ADC3    = 0x8   // ADC Data bits
	ADC_ADC4    = 0x10  // ADC Data bits
	ADC_ADC5    = 0x20  // ADC Data bits
	ADC_ADC6    = 0x40  // ADC Data bits
	ADC_ADC7    = 0x80  // ADC Data bits
	ADC_ADC_Msk = 0x3ff // ADC Data bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM      = 0x80 // ADC High Speed Mode
	ADCSRB_ADHSM_Msk  = 0x80 // ADC High Speed Mode
	ADCSRB_ISRCEN     = 0x40 // Current Source Enable
	ADCSRB_ISRCEN_Msk = 0x40 // Current Source Enable
	ADCSRB_AREFEN     = 0x20 // Analog Reference pin Enable
	ADCSRB_AREFEN_Msk = 0x20 // Analog Reference pin Enable
	ADCSRB_ADTS0      = 0x1  // ADC Auto Trigger Sources
	ADCSRB_ADTS1      = 0x2  // ADC Auto Trigger Sources
	ADCSRB_ADTS2      = 0x4  // ADC Auto Trigger Sources
	ADCSRB_ADTS3      = 0x8  // ADC Auto Trigger Sources
	ADCSRB_ADTS_Msk   = 0xf  // ADC Auto Trigger Sources

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D     = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC7D_Msk = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D     = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC6D_Msk = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D     = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC5D_Msk = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D     = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC4D_Msk = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D     = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC3D_Msk = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D     = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC2D_Msk = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D     = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC1D_Msk = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D     = 0x1  // ADC0 Digital input Disable
	DIDR0_ADC0D_Msk = 0x1  // ADC0 Digital input Disable

	// DIDR1: Digital Input Disable Register 0
	DIDR1_AMP2PD     = 0x40 // AMP2P Pin Digital input Disable
	DIDR1_AMP2PD_Msk = 0x40 // AMP2P Pin Digital input Disable
	DIDR1_ACMP0D     = 0x20 // ACMP0 Pin Digital input Disable
	DIDR1_ACMP0D_Msk = 0x20 // ACMP0 Pin Digital input Disable
	DIDR1_AMP0PD     = 0x10 // AMP0P Pin Digital input Disable
	DIDR1_AMP0PD_Msk = 0x10 // AMP0P Pin Digital input Disable
	DIDR1_AMP0ND     = 0x8  // AMP0N Pin Digital input Disable
	DIDR1_AMP0ND_Msk = 0x8  // AMP0N Pin Digital input Disable
	DIDR1_ADC10D     = 0x4  // ADC10 Pin Digital input Disable
	DIDR1_ADC10D_Msk = 0x4  // ADC10 Pin Digital input Disable
	DIDR1_ADC9D      = 0x2  // ADC9 Pin Digital input Disable
	DIDR1_ADC9D_Msk  = 0x2  // ADC9 Pin Digital input Disable
	DIDR1_ADC8D      = 0x1  // ADC8 Pin Digital input Disable
	DIDR1_ADC8D_Msk  = 0x1  // ADC8 Pin Digital input Disable

	// AMP0CSR
	AMP0CSR_AMP0EN      = 0x80
	AMP0CSR_AMP0EN_Msk  = 0x80
	AMP0CSR_AMP0IS      = 0x40
	AMP0CSR_AMP0IS_Msk  = 0x40
	AMP0CSR_AMP0G0      = 0x10
	AMP0CSR_AMP0G1      = 0x20
	AMP0CSR_AMP0G_Msk   = 0x30
	AMP0CSR_AMPCMP0     = 0x8 // Amplifier 0 - Comparator 0 Connection
	AMP0CSR_AMPCMP0_Msk = 0x8 // Amplifier 0 - Comparator 0 Connection
	AMP0CSR_AMP0TS0     = 0x1
	AMP0CSR_AMP0TS1     = 0x2
	AMP0CSR_AMP0TS2     = 0x4
	AMP0CSR_AMP0TS_Msk  = 0x7

	// AMP1CSR
	AMP1CSR_AMP1EN      = 0x80
	AMP1CSR_AMP1EN_Msk  = 0x80
	AMP1CSR_AMP1IS      = 0x40
	AMP1CSR_AMP1IS_Msk  = 0x40
	AMP1CSR_AMP1G0      = 0x10
	AMP1CSR_AMP1G1      = 0x20
	AMP1CSR_AMP1G_Msk   = 0x30
	AMP1CSR_AMPCMP1     = 0x8 // Amplifier 1 - Comparator 1 Connection
	AMP1CSR_AMPCMP1_Msk = 0x8 // Amplifier 1 - Comparator 1 Connection
	AMP1CSR_AMP1TS0     = 0x1
	AMP1CSR_AMP1TS1     = 0x2
	AMP1CSR_AMP1TS2     = 0x4
	AMP1CSR_AMP1TS_Msk  = 0x7

	// AMP2CSR
	AMP2CSR_AMP2EN      = 0x80
	AMP2CSR_AMP2EN_Msk  = 0x80
	AMP2CSR_AMP2IS      = 0x40
	AMP2CSR_AMP2IS_Msk  = 0x40
	AMP2CSR_AMP2G0      = 0x10
	AMP2CSR_AMP2G1      = 0x20
	AMP2CSR_AMP2G_Msk   = 0x30
	AMP2CSR_AMPCMP2     = 0x8 // Amplifier 2 - Comparator 2 Connection
	AMP2CSR_AMPCMP2_Msk = 0x8 // Amplifier 2 - Comparator 2 Connection
	AMP2CSR_AMP2TS0     = 0x1
	AMP2CSR_AMP2TS1     = 0x2
	AMP2CSR_AMP2TS2     = 0x4
	AMP2CSR_AMP2TS_Msk  = 0x7
)

// Bitfields for LINUART: Local Interconnect Network
const (
	// LINCR: LIN Control Register
	LINCR_LSWRES     = 0x80 // Software Reset
	LINCR_LSWRES_Msk = 0x80 // Software Reset
	LINCR_LIN13      = 0x40 // LIN Standard
	LINCR_LIN13_Msk  = 0x40 // LIN Standard
	LINCR_LCONF0     = 0x10 // LIN Configuration bits
	LINCR_LCONF1     = 0x20 // LIN Configuration bits
	LINCR_LCONF_Msk  = 0x30 // LIN Configuration bits
	LINCR_LENA       = 0x8  // LIN or UART Enable
	LINCR_LENA_Msk   = 0x8  // LIN or UART Enable
	LINCR_LCMD0      = 0x1  // LIN Command and Mode bits
	LINCR_LCMD1      = 0x2  // LIN Command and Mode bits
	LINCR_LCMD2      = 0x4  // LIN Command and Mode bits
	LINCR_LCMD_Msk   = 0x7  // LIN Command and Mode bits

	// LINSIR: LIN Status and Interrupt Register
	LINSIR_LIDST0    = 0x20 // Identifier Status bits
	LINSIR_LIDST1    = 0x40 // Identifier Status bits
	LINSIR_LIDST2    = 0x80 // Identifier Status bits
	LINSIR_LIDST_Msk = 0xe0 // Identifier Status bits
	LINSIR_LBUSY     = 0x10 // Busy Signal
	LINSIR_LBUSY_Msk = 0x10 // Busy Signal
	LINSIR_LERR      = 0x8  // Error Interrupt
	LINSIR_LERR_Msk  = 0x8  // Error Interrupt
	LINSIR_LIDOK     = 0x4  // Identifier Interrupt
	LINSIR_LIDOK_Msk = 0x4  // Identifier Interrupt
	LINSIR_LTXOK     = 0x2  // Transmit Performed Interrupt
	LINSIR_LTXOK_Msk = 0x2  // Transmit Performed Interrupt
	LINSIR_LRXOK     = 0x1  // Receive Performed Interrupt
	LINSIR_LRXOK_Msk = 0x1  // Receive Performed Interrupt

	// LINENIR: LIN Enable Interrupt Register
	LINENIR_LENERR      = 0x8 // Enable Error Interrupt
	LINENIR_LENERR_Msk  = 0x8 // Enable Error Interrupt
	LINENIR_LENIDOK     = 0x4 // Enable Identifier Interrupt
	LINENIR_LENIDOK_Msk = 0x4 // Enable Identifier Interrupt
	LINENIR_LENTXOK     = 0x2 // Enable Transmit Performed Interrupt
	LINENIR_LENTXOK_Msk = 0x2 // Enable Transmit Performed Interrupt
	LINENIR_LENRXOK     = 0x1 // Enable Receive Performed Interrupt
	LINENIR_LENRXOK_Msk = 0x1 // Enable Receive Performed Interrupt

	// LINERR: LIN Error Register
	LINERR_LABORT     = 0x80 // Abort Flag
	LINERR_LABORT_Msk = 0x80 // Abort Flag
	LINERR_LTOERR     = 0x40 // Frame Time Out Error Flag
	LINERR_LTOERR_Msk = 0x40 // Frame Time Out Error Flag
	LINERR_LOVERR     = 0x20 // Overrun Error Flag
	LINERR_LOVERR_Msk = 0x20 // Overrun Error Flag
	LINERR_LFERR      = 0x10 // Framing Error Flag
	LINERR_LFERR_Msk  = 0x10 // Framing Error Flag
	LINERR_LSERR      = 0x8  // Synchronization Error Flag
	LINERR_LSERR_Msk  = 0x8  // Synchronization Error Flag
	LINERR_LPERR      = 0x4  // Parity Error Flag
	LINERR_LPERR_Msk  = 0x4  // Parity Error Flag
	LINERR_LCERR      = 0x2  // Checksum Error Flag
	LINERR_LCERR_Msk  = 0x2  // Checksum Error Flag
	LINERR_LBERR      = 0x1  // Bit Error Flag
	LINERR_LBERR_Msk  = 0x1  // Bit Error Flag

	// LINBTR: LIN Bit Timing Register
	LINBTR_LDISR     = 0x80 // Disable Bit Timing Resynchronization
	LINBTR_LDISR_Msk = 0x80 // Disable Bit Timing Resynchronization
	LINBTR_LBT0      = 0x1  // LIN Bit Timing bits
	LINBTR_LBT1      = 0x2  // LIN Bit Timing bits
	LINBTR_LBT2      = 0x4  // LIN Bit Timing bits
	LINBTR_LBT3      = 0x8  // LIN Bit Timing bits
	LINBTR_LBT4      = 0x10 // LIN Bit Timing bits
	LINBTR_LBT5      = 0x20 // LIN Bit Timing bits
	LINBTR_LBT_Msk   = 0x3f // LIN Bit Timing bits

	// LINBRRL: LIN Baud Rate Register

	// LINBRRH: LIN Baud Rate Register
	LINBRR_LDIV0    = 0x1
	LINBRR_LDIV1    = 0x2
	LINBRR_LDIV2    = 0x4
	LINBRR_LDIV3    = 0x8
	LINBRR_LDIV4    = 0x10
	LINBRR_LDIV5    = 0x20
	LINBRR_LDIV6    = 0x40
	LINBRR_LDIV7    = 0x80
	LINBRR_LDIV_Msk = 0xfff

	// LINDLR: LIN Data Length Register
	LINDLR_LTXDL0    = 0x10 // LIN Transmit Data Length bits
	LINDLR_LTXDL1    = 0x20 // LIN Transmit Data Length bits
	LINDLR_LTXDL2    = 0x40 // LIN Transmit Data Length bits
	LINDLR_LTXDL3    = 0x80 // LIN Transmit Data Length bits
	LINDLR_LTXDL_Msk = 0xf0 // LIN Transmit Data Length bits
	LINDLR_LRXDL0    = 0x1  // LIN Receive Data Length bits
	LINDLR_LRXDL1    = 0x2  // LIN Receive Data Length bits
	LINDLR_LRXDL2    = 0x4  // LIN Receive Data Length bits
	LINDLR_LRXDL3    = 0x8  // LIN Receive Data Length bits
	LINDLR_LRXDL_Msk = 0xf  // LIN Receive Data Length bits

	// LINIDR: LIN Identifier Register
	LINIDR_LP0     = 0x40 // Parity bits
	LINIDR_LP1     = 0x80 // Parity bits
	LINIDR_LP_Msk  = 0xc0 // Parity bits
	LINIDR_LID0    = 0x1  // Identifier bit 5 or Data Length bits
	LINIDR_LID1    = 0x2  // Identifier bit 5 or Data Length bits
	LINIDR_LID2    = 0x4  // Identifier bit 5 or Data Length bits
	LINIDR_LID3    = 0x8  // Identifier bit 5 or Data Length bits
	LINIDR_LID4    = 0x10 // Identifier bit 5 or Data Length bits
	LINIDR_LID5    = 0x20 // Identifier bit 5 or Data Length bits
	LINIDR_LID_Msk = 0x3f // Identifier bit 5 or Data Length bits

	// LINSEL: LIN Data Buffer Selection Register
	LINSEL_LAINC     = 0x8 // Auto Increment of Data Buffer Index (Active Low)
	LINSEL_LAINC_Msk = 0x8 // Auto Increment of Data Buffer Index (Active Low)
	LINSEL_LINDX0    = 0x1 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX1    = 0x2 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX2    = 0x4 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX_Msk = 0x7 // FIFO LIN Data Buffer Index bits

	// LINDAT: LIN Data Register
	LINDAT_LDATA0    = 0x1
	LINDAT_LDATA1    = 0x2
	LINDAT_LDATA2    = 0x4
	LINDAT_LDATA3    = 0x8
	LINDAT_LDATA4    = 0x10
	LINDAT_LDATA5    = 0x20
	LINDAT_LDATA6    = 0x40
	LINDAT_LDATA7    = 0x80
	LINDAT_LDATA_Msk = 0xff
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPDR: SPI Data Register
	SPDR_SPDR0    = 0x1  // SPI Data bits
	SPDR_SPDR1    = 0x2  // SPI Data bits
	SPDR_SPDR2    = 0x4  // SPI Data bits
	SPDR_SPDR3    = 0x8  // SPI Data bits
	SPDR_SPDR4    = 0x10 // SPI Data bits
	SPDR_SPDR5    = 0x20 // SPI Data bits
	SPDR_SPDR6    = 0x40 // SPI Data bits
	SPDR_SPDR7    = 0x80 // SPI Data bits
	SPDR_SPDR_Msk = 0xff // SPI Data bits
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control Bit
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control Bit
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control 1 Bits
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control 1 Bits
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control 1 Bits
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control 0 Bits
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control 0 Bits
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1 // External Interrupt Request 3 Enable
	EIMSK_INT1    = 0x2 // External Interrupt Request 3 Enable
	EIMSK_INT2    = 0x4 // External Interrupt Request 3 Enable
	EIMSK_INT3    = 0x8 // External Interrupt Request 3 Enable
	EIMSK_INT_Msk = 0xf // External Interrupt Request 3 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1 // External Interrupt Flags
	EIFR_INTF1    = 0x2 // External Interrupt Flags
	EIFR_INTF2    = 0x4 // External Interrupt Flags
	EIFR_INTF3    = 0x8 // External Interrupt Flags
	EIFR_INTF_Msk = 0xf // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0    = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1    = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2    = 0x4 // Pin Change Interrupt Enables
	PCICR_PCIE3    = 0x8 // Pin Change Interrupt Enables
	PCICR_PCIE_Msk = 0xf // Pin Change Interrupt Enables

	// PCMSK3: Pin Change Mask Register 3
	PCMSK3_PCINT0    = 0x1 // Pin Change Enable Masks
	PCMSK3_PCINT1    = 0x2 // Pin Change Enable Masks
	PCMSK3_PCINT2    = 0x4 // Pin Change Enable Masks
	PCMSK3_PCINT_Msk = 0x7 // Pin Change Enable Masks

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK2_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK2_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK2_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK1_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0    = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1    = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2    = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3    = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4    = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5    = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6    = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7    = 0x80 // Pin Change Enable Masks
	PCMSK0_PCINT_Msk = 0xff // Pin Change Enable Masks

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0    = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1    = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2    = 0x4 // Pin Change Interrupt Flags
	PCIFR_PCIF3    = 0x8 // Pin Change Interrupt Flags
	PCIFR_PCIF_Msk = 0xf // Pin Change Interrupt Flags
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Read/Write Access

	// EEARH: EEPROM Read/Write Access
	EEAR_EEAR0    = 0x1   // EEPROM Address bits
	EEAR_EEAR1    = 0x2   // EEPROM Address bits
	EEAR_EEAR2    = 0x4   // EEPROM Address bits
	EEAR_EEAR3    = 0x8   // EEPROM Address bits
	EEAR_EEAR4    = 0x10  // EEPROM Address bits
	EEAR_EEAR5    = 0x20  // EEPROM Address bits
	EEAR_EEAR6    = 0x40  // EEPROM Address bits
	EEAR_EEAR7    = 0x80  // EEPROM Address bits
	EEAR_EEAR_Msk = 0x3ff // EEPROM Address bits

	// EEDR: EEPROM Data Register
	EEDR_EEDR0    = 0x1  // EEPROM Data bits
	EEDR_EEDR1    = 0x2  // EEPROM Data bits
	EEDR_EEDR2    = 0x4  // EEPROM Data bits
	EEDR_EEDR3    = 0x8  // EEPROM Data bits
	EEDR_EEDR4    = 0x10 // EEPROM Data bits
	EEDR_EEDR5    = 0x20 // EEPROM Data bits
	EEDR_EEDR6    = 0x40 // EEPROM Data bits
	EEDR_EEDR7    = 0x80 // EEPROM Data bits
	EEDR_EEDR_Msk = 0xff // EEPROM Data bits

	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming mode
	EECR_EEPM1     = 0x20 // EEPROM Programming mode
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming mode
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEWE      = 0x2  // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)
