
[//]: # (Generated 2022-04-15T22:23:35.627472. Changes belong into template/documentation/readme.template)

# Tembro

Program version 0.5.0


![Screenshot](https://git.laborejo.org/lss/Tembro/raw/branch/master/documentation/screenshot.png "Screenshot")



Tembro (which is Esperanto for musical "Timbre") is a virtual software instrument based on
samples. All instruments are permanently built-in, there is no option to load your own files.
New instruments are only added with new releases, old ones are never removed.

That makes Tembro reliable, predictable, portable and compatible.
All projects and all users have the same "instrument" with the same instrument sounds,
numbering system, midi controls… ; a solid basis for communication and collaboration.



This README is just a short introduction. Consult the manual (see below) for more information.

# Contact and Information

* Website https://www.laborejo.org
* Bugs and Issues: https://www.laborejo.org/bugs
* Git Repositories for all programs: https://git.laborejo.org
* Documentation and Manual https://www.laborejo.org/documentation/tembro

# Installation and Starting

## Download

### Release Version
If the latest release is not available through your package manger you can build it yourself:
Download the latest code release on https://www.laborejo.org/downloads and extract it.

### Git Version
It is possible to clone a git repository.

`git clone https://git.laborejo.org/lss/tembro.git`

## Dependencies
* Python 3.6 (maybe earlier)
* PyQt5 for Python 3
* DejaVu Sans Sarif TTF (Font) (recommended, but not technically necessary)
* libcalfbox-lss  https://git.laborejo.org/lss/libcalfbox-lss

### Environment:
* Jack Audio Connection Kit must be running
* Optional: Agordejo / New Session Manager ("NSM")

## Build
    ./configure --prefix=/usr/local
    make
    sudo make install


## Starting

There are multiple ways to run Tembro which should give you the flexibility to configure your
system as you want.

We make no distinction if you installed Tembro yourself or through the distributions package-manager.

The differences are: With or without Agordejo, with or without sound, installed or from the source dir.

### Installed , running through Agordejo (New Session Manager) (recommended)
Starting Tembro through Agordejo after you installed tembro system-wide
is the recommended and only supported way. Start agordejo and load or create a new
session. Then use the program launcher to add `tembro`.
It should appear with an icon in the list and open its GUI.

### Installed without Agordejo
If you start tembro directly it will present you with a dialog to choose your session directory.

You can also start tembro from a terminal (or create a starter script).

`tembro --save DIRECTORY`

Uses the given directory to save. The dir will be created or loaded from if already present. Use
the applications file menu to save (Ctrl+s).

You can use this to load and save the files from an existing NSM session. If you create a new
directory you can copy it manually to an NSM session directory, but that requires renaming the
directory to append the unique ID provided by NSM.

Sending SIGUSR1 to the program in this mode will trigger a save.

Closing through your window manager in this mode will actually quit the application without a
prompt to save changes.

## From source directory
You can run Tembro after extracting the release archive or cloning from git, without installation.

### From source directory with NSM
The developer uses this way to develop and use the software, so it will always be as stable as the
compiled version. But it is a bit less performant than building and installing it.

After extracting the release archive create a symlink from `tembro` into your PATH. e.g. /usr/bin
or ~/bin, if that exists on your system.

If you compiled without installing you can also symlink to `./tembro.bin`

### From source dir without NSM
Use `./tembro --save` (see above). If you compiled without installing you can also run `./tembro.bin`

### No NSM, no Make, No Sound
Combining the above options you can start the program directly after unpacking or cloning from git:

`./tembro --save /tmp --mute`

Or even shorter:

`./tembro -s /tmp -m`

This is the minimal run mode which is only useful for testing and development. But if you only want
to look at the GUI and are not in the mood to install anything -including dependencies-, go ahead.
