SELECT
  DB_NAME() AS TABLE_CATALOG,
  SCHEMA_NAME(O.SCHEMA_ID) AS TABLE_SCHEMA,
  O.NAME AS TABLE_NAME,
  C.NAME AS COLUMN_NAME,
  EP.VALUE AS REMARKS
FROM
  SYS.COLUMNS AS C
  INNER JOIN SYS.ALL_OBJECTS O
    ON C.OBJECT_ID = O.OBJECT_ID
  INNER JOIN SYS.EXTENDED_PROPERTIES EP
    ON EP.MAJOR_ID = C.OBJECT_ID AND EP.MINOR_ID = C.COLUMN_ID
WHERE
  O.TYPE = 'U'
  AND EP.CLASS = 1
  AND EP.NAME = 'MS_Description'
