/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxGssMsgHdr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class IfxGssCsm
implements IfxCsm {
    private static final int ENC_CSM_FLAG_INITSTRING_PENDING = 1;
    private static final String ENC_CSM_CONTEXT_ID = "CSMENC";
    private static final int GSS_CSM_STATE_UNINITIALIZED = -1;
    private static final int ENC_CSM_STATE_INITIAL = 0;
    private static final int ENC_CSM_STATE_INITSTRING = 1;
    private static final int ENC_CSM_STATE_INITSTRINGDEFER = 21;
    private static final int ENC_CSM_STATE_INITSTRINGPENDING = 3;
    private static final int ENC_CSM_STATE_AUTHPENDING = 4;
    private static final int ENC_CSM_STATE_INITSTRING_SEND = 5;
    private static final int ENC_CSM_STATE_INITPW_SEND = 6;
    private static final int ENC_CSM_STATE_INITDONE = 7;
    private static final int ENC_CSM_STATE_ACTIVE = 8;
    private static final int ENC_CSM_STATE_MORE_INPUT_NEEDED = 9;
    private static final int ENC_CSM_STATE_MORE_OUTPUT_AVAILABLE = 10;
    private static final int ENC_CSM_STATE_SENDTOPEER_DONE = 11;
    private static final int ENC_CSM_STATE_RELEASE_CONTEXT = 12;
    private static final int ENC_CSM_STATE_READY = 13;
    private static final int ENC_CSM_STATE_ABORT = 14;
    private static final int ENC_CSM_STATE_ABORT_FINAL = 15;
    private static final int ENC_CSM_STATE_INIT_SEND = 20;
    private static final int ENC_CSM_MSG_TYPE_INITSTRING = 9;
    private static final int ENC_CSM_MSG_TYPE_AUTHENTICATION = 8;
    private static final int ENC_CSM_MSG_TYPE_DATA = 10;
    private static final int ENC_CSM_MSG_TYPE_RELEASE_CONTEXT = 4;
    private static final int ENC_CSM_MSG_TYPE_ABORT = 5;
    private static final int ENC_CSM_MSG_TYPE_PWD = 6;
    private static final int ENC_CSM_MSG_TYPE_ID = 7;
    private static final int CSM_GSS_MSG_TYPE_DATA = 1;
    private static final int CSM_GSS_MSG_TYPE_CREATE_CONTEXT = 2;
    private static final int CSM_GSS_MSG_TYPE_RELEASE_CONTEXT = 3;
    private static final String GSS_KRB5_OID = "1.2.840.113554.1.2.2";
    private static final int ENC_CSM_PWD_REQD_FLAG = 1;
    private static final int ENC_CSM_PWD_NOT_GIVEN = 16;
    String csmContextId;
    int contextFlags;
    int state = -1;
    int csm_error;
    GSSManager manager = null;
    GSSContext context = null;
    byte[] token = new byte[0];
    IfxCsmDescriptor csmDesc;
    IfxCsmBuffer savedBuffer;
    IfxCryptoSession cryptoSession;
    IfxCsmBuffer outHandshake;
    IfxCsmBuffer outPw;
    String csmString;

    public IfxGssCsm(IfxCsmDescriptor csmdescr) throws IfxCsmException {
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        this.csmDesc = csmdescr;
        this.savedBuffer = new IfxCsmBuffer();
        this.state = -1;
        this.csmDesc.setLoadState(0);
        this.csmDesc.setLoadState(2);
        this.csmString = this.csmDesc.getInitString();
        this.csmDesc.setLoadState(1);
    }

    public IfxCsmDescriptor getDescriptor() {
        return this.csmDesc;
    }

    @Override
    public int ifxCsmInit(String csmInitString, long flags, IfxCsm.Status status) throws IfxCsmException {
        int csmStatus = 0;
        status.reset();
        this.cryptoSession = new IfxCryptoSession();
        csmStatus = this.cryptoSession.csmCryptoInit(csmInitString, flags);
        if (csmStatus != 0) {
            status.setCsmErr(-5006);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(csmStatus));
            return 1;
        }
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmTerminate(IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    @Override
    public long ifxCsmGetAttributeFlags(IfxCsm.Status status) {
        return 2L;
    }

    @Override
    public int ifxCsmCreateContext(IfxCsm.Credentials credentials, IfxCsmReadBuffer inHndShk, IfxCsmBuffer outHndShk, String contextInitString, IfxCsm.Status status) throws IfxCsmException {
        boolean retVal = false;
        IfxCsmBuffer outputToken = new IfxCsmBuffer();
        IfxCsmBuffer inputToken = new IfxCsmBuffer();
        IfxCsmBuffer IDBuff = new IfxCsmBuffer();
        IfxGssMsgHdr msgHeader = new IfxGssMsgHdr();
        boolean cryptoStatus = false;
        int ctxFlags = 0;
        boolean rtnStatus = false;
        int msgType = 0;
        outHndShk.reset();
        status.reset();
        if (this.state == -1) {
            try {
                this.gssInitializeCsmContext();
                this.token = this.context.initSecContext(this.token, 0, this.token.length);
                outputToken.write(this.token);
            }
            catch (Exception e) {
                this.gssDestroyCsmContext();
                status.setCsmErr(-5010);
                throw IfxCryptoSession.getCsmErrException(-5010, e);
            }
            this.savedBuffer = new IfxCsmBuffer();
            this.contextFlags = ctxFlags;
            this.outHandshake = new IfxCsmBuffer();
            msgType = 2;
            if (this.encPackBuffer(outputToken, this.outHandshake, msgType, status) == 1) {
                status.setCsmErr(-5010);
                outputToken.reset();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            outputToken.reset();
            if (inHndShk != null && inHndShk.available() > 0) {
                this.outHandshake.reset();
                this.outHandshake.write(outHndShk.toByteArray());
                this.state = 3;
            } else {
                this.state = 1;
            }
        }
        if (this.state == 7) {
            return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
        }
        if (this.state == 14) {
            this.state = 15;
        } else if (inHndShk != null && inHndShk.available() > 0) {
            if (this.encSaveInBuffer(inHndShk, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (this.encProcessSavedBuffer(msgHeader, inputToken, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Unable to process a staged buffer");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (status.getCsmCode() == 5L) {
                return 0;
            }
            if (msgHeader.getType() == 5) {
                this.encGetAbortToken(inputToken, status);
                this.state = 15;
                this.savedBuffer.reset();
                return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
            }
            if (msgHeader.getType() != 2) {
                status.setCsmErr(-5012);
                status.setCsmString("Received message type %d but expecting %d" + msgHeader.getType() + 2);
                this.gssDestroyCsmContext();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            if (!this.context.isEstablished()) {
                this.token = new byte[inputToken.getCount()];
                this.token = inputToken.toByteArrayWithReset();
                try {
                    this.token = this.context.initSecContext(this.token, 0, this.token.length);
                    if (this.context.isEstablished()) {
                        if (this.context.getMutualAuthState()) {
                            this.state = 7;
                        }
                        return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
                    }
                    outputToken.write(this.token);
                }
                catch (Exception e) {
                    this.gssDestroyCsmContext();
                    status.setCsmErr(-5010);
                    throw IfxCryptoSession.getCsmErrException(-5010, e);
                }
            }
            this.outPw = new IfxCsmBuffer();
            msgType = 2;
            if (this.encPackBuffer(outputToken, this.outPw, msgType, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Can not pack output buffer");
                this.gssDestroyCsmContext();
                outputToken.reset();
                return this.err1IfxCsmCreateContext(outHndShk, status);
            }
            outputToken.reset();
            if (this.state == 1) {
                this.state = 6;
            } else if (this.state == 3) {
                this.state = 5;
            }
        }
        return this.exitIfxCsmCreateContext(inputToken, outputToken, outHndShk, status);
    }

    @Override
    public int ifxCsmProcessOutMessage(IfxCsmReadBuffer inBuffer, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        status.reset();
        if (inBuffer == null || inBuffer.available() == 0) {
            status.setCsmCode(1L);
            return 0;
        }
        IfxCsmBuffer tempBuffer = new IfxCsmBuffer();
        MessageProp prop = null;
        prop = this.csmDesc.getSsoEnc() ? new MessageProp(0, true) : new MessageProp(0, false);
        this.token = new byte[inBuffer.getCount()];
        this.token = inBuffer.getBuf();
        try {
            byte[] outTok = this.context.wrap(this.token, 0, this.token.length, prop);
            tempBuffer.write(outTok);
        }
        catch (Exception e) {
            status.setCsmErr(-5010);
            status.setCsmString("Failure attempting to combine buffers");
            this.gssDestroyCsmContext();
            throw IfxCryptoSession.getCsmErrException(-5010);
        }
        int msgType = 1;
        if (this.encPackBuffer(tempBuffer, outBuffer, msgType, status) == 1) {
            tempBuffer = null;
            return 1;
        }
        tempBuffer = null;
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmProcessInMessage(IfxCsmReadBuffer inBuffer, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        status.reset();
        if (this.state != 10 && (inBuffer == null || inBuffer.available() == 0)) {
            status.setCsmCode(5L);
            return 0;
        }
        if (this.state != 10 && this.encSaveInBuffer(inBuffer, status) == 1) {
            return 1;
        }
        this.state = 13;
        IfxGssMsgHdr msgHdr = new IfxGssMsgHdr();
        if (outBuffer.getCount() > 0) {
            IfxCsmBuffer tempBuffer = new IfxCsmBuffer();
            retVal = this.encProcessSavedBuffer(msgHdr, tempBuffer, status);
            try {
                tempBuffer.writeTo(outBuffer);
            }
            catch (IOException ex) {
                status.setCsmErr(-5010);
                return 1;
            }
        } else {
            retVal = this.encProcessSavedBuffer(msgHdr, outBuffer, status);
        }
        if (msgHdr.MsgType == 5) {
            this.encGetAbortToken(outBuffer, status);
            return 1;
        }
        return retVal;
    }

    private int encSaveInBuffer(IfxCsmReadBuffer inBuffer, IfxCsm.Status status) throws IfxCsmException {
        if (inBuffer == null || inBuffer.available() == 0) {
            return 0;
        }
        IfxCsmBuffer tempBuff = new IfxCsmBuffer();
        tempBuff.initialize(inBuffer);
        try {
            tempBuff.writeTo(this.savedBuffer);
        }
        catch (IOException ex) {
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private int encProcessSavedBuffer(IfxGssMsgHdr msgHdr, IfxCsmBuffer outBuffer, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        if (this.savedBuffer.getCount() < 8) {
            status.setCsmCode(5L);
            return 0;
        }
        this.getMsgHdr(this.savedBuffer, msgHdr);
        if (this.savedBuffer.getCount() < msgHdr.MsgSize + 8) {
            status.setCsmCode(5L);
            return 0;
        }
        switch (msgHdr.MsgType) {
            case 3: 
            case 4: {
                status.setCsmErr(-5008);
                this.state = 12;
                return 1;
            }
            case 5: {
                retVal = this.encProcessSavedBufferAbort(outBuffer, status);
                if (retVal != 0) {
                    outBuffer.reset();
                }
                return retVal;
            }
            case 1: 
            case 8: {
                return this.encProcessSavedBufferData(outBuffer, status, true);
            }
            case 2: 
            case 9: {
                return this.encProcessSavedBufferData(outBuffer, status, false);
            }
        }
        status.setCsmErr(-5000);
        return 1;
    }

    private int encGetAbortToken(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    @Override
    public int ifxCsmAbortContext(Object csmContext, IfxCsm.AbortInfo abortInfo, IfxCsm.Status status) {
        int retVal = 0;
        return retVal;
    }

    private void getMsgHdr(IfxCsmBuffer buff, IfxGssMsgHdr msgHdr) {
        byte[] hdrArray = new byte[8];
        buff.read(hdrArray, 0, 8);
        msgHdr.setMsgHdr(hdrArray);
    }

    private int encProcessSavedBufferAbort(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        return this.encGetTokenFromSavedBuffer(outBuffer, status);
    }

    private int encGetTokenFromSavedBuffer(ByteArrayOutputStream outBuffer, IfxCsm.Status status) {
        IfxGssMsgHdr msgHdr = new IfxGssMsgHdr();
        this.getMsgHdr(this.savedBuffer, msgHdr);
        byte[] tempArray = new byte[msgHdr.MsgSize + 8];
        this.savedBuffer.readWithReset(tempArray, 0, msgHdr.MsgSize + 8);
        outBuffer.reset();
        outBuffer.write(tempArray, 8, msgHdr.MsgSize);
        if (this.savedBuffer.getCount() == 0) {
            this.savedBuffer.reset();
            status.setCsmCode(1L);
            return 0;
        }
        this.state = 10;
        status.setCsmCode(2L);
        return 0;
    }

    private int encProcessSavedBufferData(IfxCsmBuffer outBuffer, IfxCsm.Status status, boolean decrypt) throws IfxCsmException {
        IfxCsmBuffer inputMessageBuffer = new IfxCsmBuffer();
        if (this.encGetTokenFromSavedBuffer(inputMessageBuffer, status) == 1) {
            return 1;
        }
        if (decrypt) {
            MessageProp prop = new MessageProp(0, false);
            this.token = new byte[inputMessageBuffer.getCount()];
            this.token = inputMessageBuffer.toByteArrayWithReset();
            try {
                byte[] outTok = this.context.unwrap(this.token, 0, this.token.length, prop);
                outBuffer.write(outTok);
            }
            catch (Exception e) {
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                this.gssDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
        }
        try {
            inputMessageBuffer.writeTo(outBuffer);
        }
        catch (IOException ex) {
            outBuffer.reset();
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private void gssDestroyCsmContext() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
    }

    private int encPackBuffer(IfxCsmBuffer inBuff, IfxCsmBuffer outBuff, int msgType, IfxCsm.Status status) {
        int tokenLen = 0;
        if (inBuff != null) {
            tokenLen = inBuff.getCount();
        }
        IfxGssMsgHdr msgHdr = new IfxGssMsgHdr(msgType, tokenLen);
        int outBuffLenEstimate = outBuff.size() + 8 + tokenLen;
        IfxCsmBuffer newOutBuff = new IfxCsmBuffer(outBuffLenEstimate);
        try {
            if (outBuff.size() > 0) {
                outBuff.writeTo(newOutBuff);
            }
            newOutBuff.write(msgHdr.getCMsgHdr());
            if (tokenLen > 0) {
                inBuff.writeTo(newOutBuff);
            }
        }
        catch (IOException ex) {
            status.setCsmErr(-5010);
            return 1;
        }
        outBuff.initialize(newOutBuff);
        return 0;
    }

    private void gssInitializeCsmContext() throws GSSException {
        this.state = 0;
        this.csmContextId = ENC_CSM_CONTEXT_ID;
        this.manager = GSSManager.getInstance();
        Oid krb5Oid = new Oid(GSS_KRB5_OID);
        GSSName serverName = this.manager.createName(this.csmDesc.getSsoString(), null);
        this.context = this.manager.createContext(serverName, krb5Oid, null, 0);
        this.context.requestMutualAuth(true);
        if (this.csmDesc.getSsoEnc()) {
            this.context.requestConf(true);
            this.context.requestInteg(true);
        } else {
            this.context.requestConf(false);
            this.context.requestInteg(false);
        }
        if (this.savedBuffer != null) {
            this.savedBuffer.reset();
        }
        this.outHandshake = null;
    }

    private int exitIfxCsmCreateContext(IfxCsmBuffer inputToken, IfxCsmBuffer outputToken, IfxCsmBuffer outHndShk, IfxCsm.Status status) throws IfxCsmException {
        if (inputToken != null) {
            inputToken.reset();
        }
        switch (this.state) {
            case 7: {
                status.setCsmCode(1L);
                this.state = 13;
                return 0;
            }
            case 1: {
                outHndShk.reset();
                outHndShk.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 5: {
                outHndShk.reset();
                outHndShk.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 6;
                return 0;
            }
            case 6: {
                outHndShk.reset();
                outHndShk.write(this.outPw.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 14: {
                if (outHndShk.size() > 0) {
                    outHndShk.reset();
                }
                outputToken = new IfxCsmBuffer();
                this.encMakeAbortToken(outputToken, status);
                int msgType = 5;
                if (this.encPackBuffer(outputToken, outHndShk, msgType, status) == 1) {
                    status.setCsmErr(-5010);
                    status.setCsmString("Can not pack output buffer");
                    this.gssDestroyCsmContext();
                    return this.err1IfxCsmCreateContext(outHndShk, status);
                }
                status.setCsmCode(4L);
                status.setCsmErr(0);
                return 0;
            }
            case 15: {
                status.setCsmErr(-5000);
                status.setCsmString("CSM abort");
                this.gssDestroyCsmContext();
                status.setCsmCode(1L);
                return 1;
            }
            case 13: {
                status.setCsmCode(1L);
                return 1;
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    private int err1IfxCsmCreateContext(ByteArrayOutputStream outHndShk, IfxCsm.Status status) throws IfxCsmException {
        outHndShk.reset();
        status.setCsmCode(1L);
        throw IfxCryptoSession.getCsmErrException(-5010);
    }

    private void encMakeAbortToken(IfxCsmBuffer outputToken, IfxCsm.Status status) {
    }

    @Override
    public int ifxCsmReleaseContext(IfxCsmReadBuffer inHandshake, IfxCsmBuffer outHandShake, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        return retVal;
    }

    @Override
    public int ifxCsmAcceptContext(Object csmContext, IfxCsm.Credentials cred, IfxCsmReadBuffer inHandshake, IfxCsmBuffer outHandShake, String contextInitString, IfxCsm.Status status) throws IfxCsmException {
        int retVal = 1;
        return retVal;
    }
}

