# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
TCollection module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_tcollection.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _TCollection
else:
    import _TCollection

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _TCollection.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _TCollection.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TCollection.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TCollection.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _TCollection.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _TCollection.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _TCollection.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _TCollection.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _TCollection.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _TCollection.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TCollection.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _TCollection.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _TCollection.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TCollection.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TCollection.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TCollection.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _TCollection.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _TCollection:
_TCollection.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _TCollection.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection

from enum import IntEnum
from OCC.Core.Exception import *

TCollection_Left = _TCollection.TCollection_Left
TCollection_Right = _TCollection.TCollection_Right


class TCollection_Side(IntEnum):
	TCollection_Left = 0
	TCollection_Right = 1
TCollection_Left = TCollection_Side.TCollection_Left
TCollection_Right = TCollection_Side.TCollection_Right


def Handle_TCollection_HAsciiString_Create() -> "opencascade::handle< TCollection_HAsciiString >":
    return _TCollection.Handle_TCollection_HAsciiString_Create()

def Handle_TCollection_HAsciiString_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TCollection_HAsciiString >":
    return _TCollection.Handle_TCollection_HAsciiString_DownCast(t)

def Handle_TCollection_HAsciiString_IsNull(t: "opencascade::handle< TCollection_HAsciiString > const &") -> "bool":
    return _TCollection.Handle_TCollection_HAsciiString_IsNull(t)

def Handle_TCollection_HExtendedString_Create() -> "opencascade::handle< TCollection_HExtendedString >":
    return _TCollection.Handle_TCollection_HExtendedString_Create()

def Handle_TCollection_HExtendedString_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TCollection_HExtendedString >":
    return _TCollection.Handle_TCollection_HExtendedString_DownCast(t)

def Handle_TCollection_HExtendedString_IsNull(t: "opencascade::handle< TCollection_HExtendedString > const &") -> "bool":
    return _TCollection.Handle_TCollection_HExtendedString_IsNull(t)

def Handle_TCollection_MapNode_Create() -> "opencascade::handle< TCollection_MapNode >":
    return _TCollection.Handle_TCollection_MapNode_Create()

def Handle_TCollection_MapNode_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TCollection_MapNode >":
    return _TCollection.Handle_TCollection_MapNode_DownCast(t)

def Handle_TCollection_MapNode_IsNull(t: "opencascade::handle< TCollection_MapNode > const &") -> "bool":
    return _TCollection.Handle_TCollection_MapNode_IsNull(t)

def Handle_TCollection_SeqNode_Create() -> "opencascade::handle< TCollection_SeqNode >":
    return _TCollection.Handle_TCollection_SeqNode_Create()

def Handle_TCollection_SeqNode_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TCollection_SeqNode >":
    return _TCollection.Handle_TCollection_SeqNode_DownCast(t)

def Handle_TCollection_SeqNode_IsNull(t: "opencascade::handle< TCollection_SeqNode > const &") -> "bool":
    return _TCollection.Handle_TCollection_SeqNode_IsNull(t)
class tcollection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def NextPrimeForMap(*args) -> "Standard_Integer":
        r"""
        Returns a prime number greater than <i> suitable to dimension a map. when <i> becomes great there is a limit on the result (today the limit is around 1 000 000). this is not a limit of the number of items but a limit in the number of buckets. i.e. there will be more collisions in the map.

        Parameters
        ----------
        I: int

        Returns
        -------
        int

        """
        return _TCollection.tcollection_NextPrimeForMap(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _TCollection.tcollection_swiginit(self, _TCollection.new_tcollection())
    __swig_destroy__ = _TCollection.delete_tcollection

# Register tcollection in _TCollection:
_TCollection.tcollection_swigregister(tcollection)

def tcollection_NextPrimeForMap(*args) -> "Standard_Integer":
    r"""
    Returns a prime number greater than <i> suitable to dimension a map. when <i> becomes great there is a limit on the result (today the limit is around 1 000 000). this is not a limit of the number of items but a limit in the number of buckets. i.e. there will be more collisions in the map.

    Parameters
    ----------
    I: int

    Returns
    -------
    int

    """
    return _TCollection.tcollection_NextPrimeForMap(*args)

class TCollection_AsciiString(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes a asciistring to an empty asciistring.

        Returns
        -------
        None
        Initializes a asciistring with a cstring.

        Parameters
        ----------
        message: char *

        Returns
        -------
        None
        Initializes a asciistring with a cstring.

        Parameters
        ----------
        message: char *
        aLen: int

        Returns
        -------
        None
        Initializes a asciistring with a single character.

        Parameters
        ----------
        aChar: Standard_Character

        Returns
        -------
        None
        Initializes an asciistring with <length> space allocated. and filled with <filler>. this is usefull for buffers.

        Parameters
        ----------
        length: int
        filler: Standard_Character

        Returns
        -------
        None
        Initializes an asciistring with an integer value.

        Parameters
        ----------
        value: int

        Returns
        -------
        None
        Initializes an asciistring with a real value.

        Parameters
        ----------
        value: float

        Returns
        -------
        None
        Initializes a asciistring with another asciistring.

        Parameters
        ----------
        astring: TCollection_AsciiString

        Returns
        -------
        None
        Move constructor.

        Parameters
        ----------
        theOther: TCollection_AsciiString

        Returns
        -------
        None
        Initializes a asciistring with copy of another asciistring concatenated with the message character.

        Parameters
        ----------
        astring: TCollection_AsciiString
        message: Standard_Character

        Returns
        -------
        None
        Initializes a asciistring with copy of another asciistring concatenated with the message string.

        Parameters
        ----------
        astring: TCollection_AsciiString
        message: char *

        Returns
        -------
        None
        Initializes a asciistring with copy of another asciistring concatenated with the message string.

        Parameters
        ----------
        astring: TCollection_AsciiString
        message: TCollection_AsciiString

        Returns
        -------
        None
        Creation by converting an extended string to an ascii string. if replacenonascii is non-null charecter, it will be used in place of any non-ascii character found in the source string. otherwise, creates utf-8 unicode string.

        Parameters
        ----------
        astring: TCollection_ExtendedString
        replaceNonAscii: Standard_Character,optional
        	default value is 0

        Returns
        -------
        None
        Initialize utf-8 unicode string from wide-char string considering it as unicode string (the size of wide char is a platform-dependent - e.g. on windows wchar_t is utf-16). //! this constructor is unavailable if application is built with deprecated msvc option '-zc:wchar_t-', since occt itself is never built with this option.

        Parameters
        ----------
        theStringUtf: Standard_WideChar *

        Returns
        -------
        None

        """
        _TCollection.TCollection_AsciiString_swiginit(self, _TCollection.new_TCollection_AsciiString(*args))

    def AssignCat(self, *args) -> "void":
        r"""
        Appends <other> to me. this is an unary operator.

        Parameters
        ----------
        other: Standard_Character

        Returns
        -------
        None
        Appends <other> to me. this is an unary operator.

        Parameters
        ----------
        other: int

        Returns
        -------
        None
        Appends <other> to me. this is an unary operator.

        Parameters
        ----------
        other: float

        Returns
        -------
        None
        Appends <other> to me. this is an unary operator. ex: astring += 'dummy' to catenate more than one cstring, you must put a asciistring before. example: astring += 'hello ' + 'dolly' is not valid ! but astring += anotherstring + 'hello ' + 'dolly' is valid.

        Parameters
        ----------
        other: char *

        Returns
        -------
        None
        Appends <other> to me. this is an unary operator. example: astring += anotherstring.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_AssignCat(self, *args)

    def Capitalize(self, *args) -> "void":
        r"""
        Converts the first character into its corresponding upper-case character and the other characters into lowercase example: before me = 'hello ' after me = 'hello '.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Capitalize(self, *args)

    def Cat(self, *args) -> "TCollection_AsciiString":
        r"""
        Appends <other> to me. syntax: astring = astring + 'dummy' example: astring contains 'i say ' astring = astring + 'hello ' + 'dolly' gives 'i say hello dolly' to catenate more than one cstring, you must put a string before. so the following example is wrong ! astring = 'hello ' + 'dolly' this is not allowed this rule is applicable to assigncat (operator +=) too.

        Parameters
        ----------
        other: Standard_Character

        Returns
        -------
        TCollection_AsciiString
        Appends <other> to me. syntax: astring = astring + 15; example: astring contains 'i say ' gives 'i say 15' to catenate more than one cstring, you must put a string before. so the following example is wrong ! astring = 'hello ' + 'dolly' this is not allowed this rule is applicable to assigncat (operator +=) too.

        Parameters
        ----------
        other: int

        Returns
        -------
        TCollection_AsciiString
        Appends <other> to me. syntax: astring = astring + 15.15; example: astring contains 'i say ' gives 'i say 15.15' to catenate more than one cstring, you must put a string before. so the following example is wrong ! astring = 'hello ' + 'dolly' this is not allowed this rule is applicable to assigncat (operator +=) too.

        Parameters
        ----------
        other: float

        Returns
        -------
        TCollection_AsciiString
        Appends <other> to me. syntax: astring = astring + 'dummy' example: astring contains 'i say ' astring = astring + 'hello ' + 'dolly' gives 'i say hello dolly' to catenate more than one cstring, you must put a string before. so the following example is wrong ! astring = 'hello ' + 'dolly' this is not allowed this rule is applicable to assigncat (operator +=) too.

        Parameters
        ----------
        other: char *

        Returns
        -------
        TCollection_AsciiString
        Appends <other> to me. example: astring = astring + anotherstring.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_AsciiString_Cat(self, *args)

    def Center(self, *args) -> "void":
        r"""
        Modifies this ascii string so that its length becomes equal to width and the new characters are equal to filler. new characters are added both at the beginning and at the end of this string. if width is less than the length of this ascii string, nothing happens. example tcollection_asciistring myalphabet('abcdef'); myalphabet.center(9,' '); assert ( myalphabet == ' abcdef ' );.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Center(self, *args)

    def ChangeAll(self, *args) -> "void":
        r"""
        Substitutes all the characters equal to achar by newchar in the asciistring <self>. the substitution can be case sensitive. if you don't use default case sensitive, no matter wether achar is uppercase or not. example: me = 'histake' -> changeall('h','m',standard_true) gives me = 'mistake'.

        Parameters
        ----------
        aChar: Standard_Character
        NewChar: Standard_Character
        CaseSensitive: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_ChangeAll(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Removes all characters contained in <self>. this produces an empty asciistring.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Clear(self, *args)

    def Copy(self, *args) -> "void":
        r"""
        Copy <fromwhere> to <self>. used as operator = example: astring = anothercstring;.

        Parameters
        ----------
        fromwhere: char *

        Returns
        -------
        None
        Copy <fromwhere> to <self>. used as operator = example: astring = anotherstring;.

        Parameters
        ----------
        fromwhere: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Copy(self, *args)

    def EndsWith(self, *args) -> "Standard_Boolean":
        r"""
        Determines whether the end of this string instance matches the specified string.

        Parameters
        ----------
        theEndString: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_EndsWith(self, *args)

    def FirstLocationInSet(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the first character of <self> that is present in <set>. the search begins to the index fromindex and ends to the the index toindex. returns zero if failure. raises an exception if fromindex or toindex is out of range. example: before me = 'aabacaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabacaa' returns 1.

        Parameters
        ----------
        Set: TCollection_AsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_FirstLocationInSet(self, *args)

    def FirstLocationNotInSet(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the first character of <self> that is not present in the set <set>. the search begins to the index fromindex and ends to the the index toindex in <self>. returns zero if failure. raises an exception if fromindex or toindex is out of range. example: before me = 'aabacaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabacaa' returns 3.

        Parameters
        ----------
        Set: TCollection_AsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_FirstLocationNotInSet(self, *args)

    @staticmethod
    def HashCode(*args) -> "Standard_Integer":
        r"""
        Computes a hash code for the given ascii string, in the range [1, theupperbound]. returns the same integer value as the hash function for tcollection_extendedstring @param theasciistring the ascii string which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theAsciiString: TCollection_AsciiString
        theUpperBound: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_HashCode(*args)

    def Insert(self, *args) -> "void":
        r"""
        Inserts a character at position <where>. example: astring contains 'hy not ?' astring.insert(1,'w'); gives 'why not ?' astring contains 'wh' astring.insert(3,'y'); gives 'why' astring contains 'way' astring.insert(2,'h'); gives 'why'.

        Parameters
        ----------
        where: int
        what: Standard_Character

        Returns
        -------
        None
        Inserts a cstring at position <where>. example: astring contains 'o more' astring.insert(2,'nce'); gives 'once more'.

        Parameters
        ----------
        where: int
        what: char *

        Returns
        -------
        None
        Inserts a asciistring at position <where>.

        Parameters
        ----------
        where: int
        what: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Insert(self, *args)

    def InsertAfter(self, *args) -> "void":
        r"""
        Pushing a string after a specific index in the string <self>. raises an exception if index is out of bounds. - less than 0 (insertafter), or less than 1 (insertbefore), or - greater than the number of characters in this ascii string. example: before me = 'cde' , index = 0 , other = 'ab' after me = 'abcde' , other = 'ab'.

        Parameters
        ----------
        Index: int
        other: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_InsertAfter(self, *args)

    def InsertBefore(self, *args) -> "void":
        r"""
        Pushing a string before a specific index in the string <self>. raises an exception if index is out of bounds. - less than 0 (insertafter), or less than 1 (insertbefore), or - greater than the number of characters in this ascii string. example: before me = 'cde' , index = 1 , other = 'ab' after me = 'abcde' , other = 'ab'.

        Parameters
        ----------
        Index: int
        other: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_InsertBefore(self, *args)

    def IntegerValue(self, *args) -> "Standard_Integer":
        r"""
        Converts a asciistring containing a numeric expression to an integer. example: '215' returns 215.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_IntegerValue(self, *args)

    def IsAscii(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the asciistring contains only ascii characters between ' ' and '~'. this means no control character and no extended ascii code.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsAscii(self, *args)

    def IsDifferent(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there are differences between the characters in this ascii string and ascii string other. note that this method is an alias of operator !=.

        Parameters
        ----------
        other: char *

        Returns
        -------
        bool
        Returns true if there are differences between the characters in this ascii string and ascii string other. note that this method is an alias of operator !=.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsDifferent(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string <self> contains zero character.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsEmpty(self, *args)

    @staticmethod
    def IsEqual(*args) -> "Standard_Boolean":
        r"""
        Returns true if the characters in this ascii string are identical to the characters in ascii string other. note that this method is an alias of operator ==.

        Parameters
        ----------
        other: char *

        Returns
        -------
        bool
        Returns true if the characters in this ascii string are identical to the characters in ascii string other. note that this method is an alias of operator ==.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        bool
        Returns true when the two strings are the same. (just for hashcode for asciistring).

        Parameters
        ----------
        string1: TCollection_AsciiString
        string2: TCollection_AsciiString

        Returns
        -------
        bool
        Returns true when the two strings are the same. (just for hashcode for asciistring).

        Parameters
        ----------
        string1: TCollection_AsciiString
        string2: char *

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsEqual(*args)

    def IsGreater(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is 'ascii' greater than <other>.

        Parameters
        ----------
        other: char *

        Returns
        -------
        bool
        Returns true if <self> is 'ascii' greater than <other>.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsGreater(self, *args)

    def IsIntegerValue(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the asciistring contains an integer value. note: an integer value is considered to be a real value as well.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsIntegerValue(self, *args)

    def IsLess(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is 'ascii' less than <other>.

        Parameters
        ----------
        other: char *

        Returns
        -------
        bool
        Returns true if <self> is 'ascii' less than <other>.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsLess(self, *args)

    def IsRealValue(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the asciistring contains a real value. note: an integer value is considered to be a real value as well.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsRealValue(self, *args)

    @staticmethod
    def IsSameString(*args) -> "Standard_Boolean":
        r"""
        Returns true if the strings contain same characters.

        Parameters
        ----------
        theString1: TCollection_AsciiString
        theString2: TCollection_AsciiString
        theIsCaseSensitive: bool

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_IsSameString(*args)

    def LeftAdjust(self, *args) -> "void":
        r"""
        Removes all space characters in the begining of the string.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_LeftAdjust(self, *args)

    def LeftJustify(self, *args) -> "void":
        r"""
        Left justify length becomes equal to width and the new characters are equal to filler. if width < length nothing happens. raises an exception if width is less than zero. example: before me = 'abcdef' , width = 9 , filler = ' ' after me = 'abcdef '.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_LeftJustify(self, *args)

    def Length(self, *args) -> "Standard_Integer":
        r"""
        Returns number of characters in <self>. this is the same functionality as 'strlen' in c. example tcollection_asciistring myalphabet('abcdef'); assert ( myalphabet.length() == 6 ); - 1 is the position of the first character in this string. - the length of this string gives the position of its last character. - positions less than or equal to zero, or greater than the length of this string are invalid in functions which identify a character of this string by its position.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_Length(self, *args)

    def Location(self, *args) -> "Standard_Integer":
        r"""
        Returns an index in the string <self> of the first occurence of the string s in the string <self> from the starting index fromindex to the ending index toindex returns zero if failure raises an exception if fromindex or toindex is out of range. example: before me = 'aabaaaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabaaaa' returns 4.

        Parameters
        ----------
        other: TCollection_AsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int
        Returns the index of the nth occurence of the character c in the string <self> from the starting index fromindex to the ending index toindex. returns zero if failure. raises an exception if fromindex or toindex is out of range. example: before me = 'aabaa', n = 3, c = 'a', fromindex = 1, toindex = 5 after me = 'aabaa' returns 5.

        Parameters
        ----------
        N: int
        C: Standard_Character
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_Location(self, *args)

    def LowerCase(self, *args) -> "void":
        r"""
        Converts <self> to its lower-case equivalent. example tcollection_asciistring mystring('hello dolly'); mystring.uppercase(); assert ( mystring == 'hello dolly' ); mystring.lowercase(); assert ( mystring == 'hello dolly' );.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_LowerCase(self, *args)

    def Prepend(self, *args) -> "void":
        r"""
        Inserts the string other at the beginning of this ascii string. example tcollection_asciistring myalphabet('cde'); tcollection_asciistring mybegin('ab'); myalphabet.prepend(mybegin); assert ( myalphabet == 'abcde' );.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Prepend(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(TCollection_AsciiString self) -> std::string"""
        return _TCollection.TCollection_AsciiString_PrintToString(self)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(TCollection_AsciiString self, std::string src)"""
        return _TCollection.TCollection_AsciiString_ReadFromString(self, src)

    def RealValue(self, *args) -> "Standard_Real":
        r"""
        Converts an asciistring containing a numeric expression. to a real. example: ex: '215' returns 215.0. ex: '3.14159267' returns 3.14159267.

        Returns
        -------
        float

        """
        return _TCollection.TCollection_AsciiString_RealValue(self, *args)

    def Remove(self, *args) -> "void":
        r"""
        Erases <ahowmany> characters from position <where>, <where> included. example: astring contains 'hello' astring.remove(2,2) erases 2 characters from position 2 this gives 'hlo'.

        Parameters
        ----------
        where: int
        ahowmany: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Remove(self, *args)

    def RemoveAll(self, *args) -> "void":
        r"""
        Remove all the occurences of the character c in the string. example: before me = 'hellllo', c = 'l' , casesensitive = true after me = 'hello'.

        Parameters
        ----------
        C: Standard_Character
        CaseSensitive: bool

        Returns
        -------
        None
        Removes every <what> characters from <self>.

        Parameters
        ----------
        what: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_RemoveAll(self, *args)

    def RightAdjust(self, *args) -> "void":
        r"""
        Removes all space characters at the end of the string.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_RightAdjust(self, *args)

    def RightJustify(self, *args) -> "void":
        r"""
        Right justify. length becomes equal to width and the new characters are equal to filler. if width < length nothing happens. raises an exception if width is less than zero. example: before me = 'abcdef' , width = 9 , filler = ' ' after me = ' abcdef'.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_RightJustify(self, *args)

    def Search(self, *args) -> "Standard_Integer":
        r"""
        Searches a cstring in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found. example: astring contains 'sample single test' astring.search('le') returns 5.

        Parameters
        ----------
        what: char *

        Returns
        -------
        int
        Searches an asciistring in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_AsciiString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_Search(self, *args)

    def SearchFromEnd(self, *args) -> "Standard_Integer":
        r"""
        Searches a cstring in a asciistring from the end and returns position of first item <what> matching. it returns -1 if not found. example: astring contains 'sample single test' astring.searchfromend('le') returns 12.

        Parameters
        ----------
        what: char *

        Returns
        -------
        int
        Searches a asciistring in another asciistring from the end and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_AsciiString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_SearchFromEnd(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces one character in the asciistring at position <where>. if <where> is less than zero or greater than the length of <self> an exception is raised. example: astring contains 'garbake' astring.replace(6,'g') gives <self> = 'garbage'.

        Parameters
        ----------
        where: int
        what: Standard_Character

        Returns
        -------
        None
        Replaces a part of <self> by a cstring. if <where> is less than zero or greater than the length of <self> an exception is raised. example: astring contains 'abcde' astring.setvalue(4,'1234567') gives <self> = 'abc1234567'.

        Parameters
        ----------
        where: int
        what: char *

        Returns
        -------
        None
        Replaces a part of <self> by another asciistring.

        Parameters
        ----------
        where: int
        what: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_SetValue(self, *args)

    def Split(self, *args) -> "TCollection_AsciiString":
        r"""
        Splits a asciistring into two sub-strings. example: astring contains 'abcdefg' astring.split(3) gives <self> = 'abc' and returns 'defg'.

        Parameters
        ----------
        where: int

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_AsciiString_Split(self, *args)

    def StartsWith(self, *args) -> "Standard_Boolean":
        r"""
        Determines whether the beginning of this string instance matches the specified string.

        Parameters
        ----------
        theStartString: TCollection_AsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_AsciiString_StartsWith(self, *args)

    def SubString(self, *args) -> "TCollection_AsciiString":
        r"""
        Creation of a sub-string of the string <self>. the sub-string starts to the index fromindex and ends to the index toindex. raises an exception if toindex or fromindex is out of bounds example: before me = 'abcdefg', toindex=3, fromindex=6 after me = 'abcdefg' returns 'cdef'.

        Parameters
        ----------
        FromIndex: int
        ToIndex: int

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_AsciiString_SubString(self, *args)

    def Swap(self, *args) -> "void":
        r"""
        Exchange the data of two strings (without reallocating memory).

        Parameters
        ----------
        theOther: TCollection_AsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Swap(self, *args)

    def ToCString(self, *args) -> "char const *":
        r"""
        Returns pointer to asciistring (char *). this is useful for some casual manipulations. warning: because this 'char *' is 'const', you can't modify its contents.

        Returns
        -------
        char *

        """
        return _TCollection.TCollection_AsciiString_ToCString(self, *args)

    def Token(self, *args) -> "TCollection_AsciiString":
        r"""
        Extracts <whichone> token from <self>. by default, the <separators> is set to space and tabulation. by default, the token extracted is the first one (whichone = 1). <separators> contains all separators you need. if no token indexed by <whichone> is found, it returns empty asciistring. example: astring contains 'this is a message' astring.token() returns 'this' astring.token(' ',4) returns 'message' astring.token(' ',2) returns 'is' astring.token(' ',9) returns '' other separators than space character and tabulation are allowed : astring contains '1234; test:message , value' astring.token('; :,',4) returns 'value' astring.token('; :,',2) returns 'test'.

        Parameters
        ----------
        separators: char *,optional
        	default value is '	'
        whichone: int,optional
        	default value is 1

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_AsciiString_Token(self, *args)

    def Trunc(self, *args) -> "void":
        r"""
        Truncates <self> to <ahowmany> characters. example: me = 'hello dolly' -> trunc(3) -> me = 'hel'.

        Parameters
        ----------
        ahowmany: int

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_Trunc(self, *args)

    def UpperCase(self, *args) -> "void":
        r"""
        Converts <self> to its upper-case equivalent.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_AsciiString_UpperCase(self, *args)

    def UsefullLength(self, *args) -> "Standard_Integer":
        r"""
        Length of the string ignoring all spaces (' ') and the control character at the end.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_AsciiString_UsefullLength(self, *args)

    def Value(self, *args) -> "Standard_Character":
        r"""
        Returns character at position <where> in <self>. if <where> is less than zero or greater than the lenght of <self>, an exception is raised. example: astring contains 'hello' astring.value(2) returns 'e'.

        Parameters
        ----------
        where: int

        Returns
        -------
        Standard_Character

        """
        return _TCollection.TCollection_AsciiString_Value(self, *args)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __ne_wrapper__(self, *args) -> "bool":
        r"""
        __ne_wrapper__(TCollection_AsciiString self, Standard_CString const other) -> bool
        __ne_wrapper__(TCollection_AsciiString self, TCollection_AsciiString other) -> bool
        """
        return _TCollection.TCollection_AsciiString___ne_wrapper__(self, *args)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __add__(self, *args) -> "TCollection_AsciiString":
        r"""
        No available documentation.

        Parameters
        ----------
        other: Standard_Character

        Returns
        -------
        TCollection_AsciiString
        No available documentation.

        Parameters
        ----------
        other: int

        Returns
        -------
        TCollection_AsciiString
        No available documentation.

        Parameters
        ----------
        other: float

        Returns
        -------
        TCollection_AsciiString
        No available documentation.

        Parameters
        ----------
        other: char *

        Returns
        -------
        TCollection_AsciiString
        No available documentation.

        Parameters
        ----------
        other: TCollection_AsciiString

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_AsciiString___add__(self, *args)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __iadd_wrapper__(self, *args) -> "void":
        r"""
        __iadd_wrapper__(TCollection_AsciiString self, Standard_Character const other)
        __iadd_wrapper__(TCollection_AsciiString self, Standard_Integer const other)
        __iadd_wrapper__(TCollection_AsciiString self, Standard_Real const other)
        __iadd_wrapper__(TCollection_AsciiString self, Standard_CString const other)
        __iadd_wrapper__(TCollection_AsciiString self, TCollection_AsciiString other)
        """
        return _TCollection.TCollection_AsciiString___iadd_wrapper__(self, *args)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    def __eq_wrapper__(self, *args) -> "bool":
        r"""
        __eq_wrapper__(TCollection_AsciiString self, Standard_CString const other) -> bool
        __eq_wrapper__(TCollection_AsciiString self, TCollection_AsciiString other) -> bool
        """
        return _TCollection.TCollection_AsciiString___eq_wrapper__(self, *args)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_AsciiString

# Register TCollection_AsciiString in _TCollection:
_TCollection.TCollection_AsciiString_swigregister(TCollection_AsciiString)

def TCollection_AsciiString_HashCode(*args) -> "Standard_Integer":
    r"""
    Computes a hash code for the given ascii string, in the range [1, theupperbound]. returns the same integer value as the hash function for tcollection_extendedstring @param theasciistring the ascii string which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

    Parameters
    ----------
    theAsciiString: TCollection_AsciiString
    theUpperBound: int

    Returns
    -------
    int

    """
    return _TCollection.TCollection_AsciiString_HashCode(*args)

def TCollection_AsciiString_IsEqual(*args) -> "Standard_Boolean":
    r"""
    Returns true if the characters in this ascii string are identical to the characters in ascii string other. note that this method is an alias of operator ==.

    Parameters
    ----------
    other: char *

    Returns
    -------
    bool
    Returns true if the characters in this ascii string are identical to the characters in ascii string other. note that this method is an alias of operator ==.

    Parameters
    ----------
    other: TCollection_AsciiString

    Returns
    -------
    bool
    Returns true when the two strings are the same. (just for hashcode for asciistring).

    Parameters
    ----------
    string1: TCollection_AsciiString
    string2: TCollection_AsciiString

    Returns
    -------
    bool
    Returns true when the two strings are the same. (just for hashcode for asciistring).

    Parameters
    ----------
    string1: TCollection_AsciiString
    string2: char *

    Returns
    -------
    bool

    """
    return _TCollection.TCollection_AsciiString_IsEqual(*args)

def TCollection_AsciiString_IsSameString(*args) -> "Standard_Boolean":
    r"""
    Returns true if the strings contain same characters.

    Parameters
    ----------
    theString1: TCollection_AsciiString
    theString2: TCollection_AsciiString
    theIsCaseSensitive: bool

    Returns
    -------
    bool

    """
    return _TCollection.TCollection_AsciiString_IsSameString(*args)

class TCollection_BaseSequence(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Exchange(self, *args) -> "void":
        r"""
        Swaps elements which are located at positions <i> and <j> in <self>. raises an exception if i or j is out of bound. example: before me = (a b c), i = 1, j = 3 after me = (c b a).

        Parameters
        ----------
        I: int
        J: int

        Returns
        -------
        None

        """
        return _TCollection.TCollection_BaseSequence_Exchange(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the sequence <self> contains no elements.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_BaseSequence_IsEmpty(self, *args)

    def Length(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of element(s) in the sequence. returns zero if the sequence is empty.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_BaseSequence_Length(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the order of items on <self>. example: before me = (a b c) after me = (c b a).

        Returns
        -------
        None

        """
        return _TCollection.TCollection_BaseSequence_Reverse(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_BaseSequence

# Register TCollection_BaseSequence in _TCollection:
_TCollection.TCollection_BaseSequence_swigregister(TCollection_BaseSequence)

class TCollection_BasicMap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Extent(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of keys already stored in <self>.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_BasicMap_Extent(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true when the map contains no keys. this is exactly extent() == 0.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_BasicMap_IsEmpty(self, *args)

    def NbBuckets(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of buckets in <self>.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_BasicMap_NbBuckets(self, *args)

    def StatisticsToString(self) -> "std::string":
        r"""StatisticsToString(TCollection_BasicMap self) -> std::string"""
        return _TCollection.TCollection_BasicMap_StatisticsToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_BasicMap

# Register TCollection_BasicMap in _TCollection:
_TCollection.TCollection_BasicMap_swigregister(TCollection_BasicMap)

class TCollection_BasicMapIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there is a current entry for this iterator in the map. use the function next to set this iterator to the position of the next entry, if it exists.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_BasicMapIterator_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Sets this iterator to the position of the next entry of the map. nothing is changed if there is no more entry to explore in the map: this iterator is always positioned on the last entry of the map but the function more returns false.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_BasicMapIterator_Next(self, *args)

    def Reset(self, *args) -> "void":
        r"""
        Resets the iterator to the first node.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_BasicMapIterator_Reset(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_BasicMapIterator

# Register TCollection_BasicMapIterator in _TCollection:
_TCollection.TCollection_BasicMapIterator_swigregister(TCollection_BasicMapIterator)

class TCollection_ExtendedString(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes a extendedstring to an empty extendedstring.

        Returns
        -------
        None
        Creation by converting a cstring to an extended string. if <ismultibyte> is true then the string is treated as having utf-8 coding. if it is not a utf-8 then <ismultibyte> is ignored and each character is copied to extcharacter.

        Parameters
        ----------
        astring: char *
        isMultiByte: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Creation by converting an extstring to an extended string.

        Parameters
        ----------
        astring: Standard_ExtString

        Returns
        -------
        None
        Initialize from wide-char string considering it as unicode string (the size of wide char is a platform-dependent - e.g. on windows wchar_t is utf-16). //! this constructor is unavailable if application is built with deprecated msvc option '-zc:wchar_t-', since occt itself is never built with this option.

        Parameters
        ----------
        theStringUtf: Standard_WideChar *

        Returns
        -------
        None
        Initializes a asciistring with a single character.

        Parameters
        ----------
        aChar: Standard_Character

        Returns
        -------
        None
        Initializes a extendedstring with a single character.

        Parameters
        ----------
        aChar: Standard_ExtCharacter

        Returns
        -------
        None
        Initializes a extendedstring with <length> space allocated. and filled with <filler>.this is useful for buffers.

        Parameters
        ----------
        length: int
        filler: Standard_ExtCharacter

        Returns
        -------
        None
        Initializes an extendedstring with an integer value.

        Parameters
        ----------
        value: int

        Returns
        -------
        None
        Initializes an extendedstring with a real value.

        Parameters
        ----------
        value: float

        Returns
        -------
        None
        Initializes a extendedstring with another extendedstring.

        Parameters
        ----------
        astring: TCollection_ExtendedString

        Returns
        -------
        None
        Move constructor.

        Parameters
        ----------
        theOther: TCollection_ExtendedString

        Returns
        -------
        None
        Creation by converting an ascii string to an extended string. the string is treated as having utf-8 coding. if it is not a utf-8 or multi byte then each character is copied to extcharacter.

        Parameters
        ----------
        astring: TCollection_AsciiString
        isMultiByte: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _TCollection.TCollection_ExtendedString_swiginit(self, _TCollection.new_TCollection_ExtendedString(*args))

    def AssignCat(self, *args) -> "void":
        r"""
        Appends the other extended string to this extended string. note that this method is an alias of operator +=. example: astring += anotherstring.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        None
        Appends the utf16 char to this extended string.

        Parameters
        ----------
        theChar: Standard_Utf16Char

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_AssignCat(self, *args)

    def Cat(self, *args) -> "TCollection_ExtendedString":
        r"""
        Appends <other> to me.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        TCollection_ExtendedString

        """
        return _TCollection.TCollection_ExtendedString_Cat(self, *args)

    def ChangeAll(self, *args) -> "void":
        r"""
        Substitutes all the characters equal to achar by newchar in the extendedstring <self>. the substitution can be case sensitive. if you don't use default case sensitive, no matter wether achar is uppercase or not.

        Parameters
        ----------
        aChar: Standard_ExtCharacter
        NewChar: Standard_ExtCharacter

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_ChangeAll(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Removes all characters contained in <self>. this produces an empty extendedstring.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Clear(self, *args)

    def Copy(self, *args) -> "void":
        r"""
        Copy <fromwhere> to <self>. used as operator =.

        Parameters
        ----------
        fromwhere: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Copy(self, *args)

    def EndsWith(self, *args) -> "Standard_Boolean":
        r"""
        Determines whether the end of this string instance matches the specified string.

        Parameters
        ----------
        theEndString: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_EndsWith(self, *args)

    @staticmethod
    def HashCode(*args) -> "Standard_Integer":
        r"""
        Returns a hashed value for the extended string within the range 1 .. theupper. note: if string is ascii, the computed value is the same as the value computed with the hashcode function on a tcollection_asciistring string composed with equivalent ascii characters. @param theextendedstring the extended string which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

        Parameters
        ----------
        theString: TCollection_ExtendedString
        theUpperBound: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_HashCode(*args)

    def Insert(self, *args) -> "void":
        r"""
        Insert a character at position <where>.

        Parameters
        ----------
        where: int
        what: Standard_ExtCharacter

        Returns
        -------
        None
        Insert a extendedstring at position <where>.

        Parameters
        ----------
        where: int
        what: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Insert(self, *args)

    def IsAscii(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the extendedstring contains only 'ascii range' characters .

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsAscii(self, *args)

    def IsDifferent(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there are differences between the characters in this extended string and the other extended string. note that this method is an alias of operator !=.

        Parameters
        ----------
        other: Standard_ExtString

        Returns
        -------
        bool
        Returns true if there are differences between the characters in this extended string and the other extended string. note that this method is an alias of operator !=.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsDifferent(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this string contains no characters.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsEmpty(self, *args)

    @staticmethod
    def IsEqual(*args) -> "Standard_Boolean":
        r"""
        Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

        Parameters
        ----------
        other: Standard_ExtString

        Returns
        -------
        bool
        Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        bool
        Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

        Parameters
        ----------
        theString1: TCollection_ExtendedString
        theString2: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsEqual(*args)

    def IsGreater(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is greater than <other>.

        Parameters
        ----------
        other: Standard_ExtString

        Returns
        -------
        bool
        Returns true if <self> is greater than <other>.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsGreater(self, *args)

    def IsLess(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is less than <other>.

        Parameters
        ----------
        other: Standard_ExtString

        Returns
        -------
        bool
        Returns true if <self> is less than <other>.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_IsLess(self, *args)

    def Length(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of 16-bit code units (might be greater than number of unicode symbols if string contains surrogate pairs).

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_Length(self, *args)

    def LengthOfCString(self, *args) -> "Standard_Integer":
        r"""
        Returns expected cstring length in utf8 coding. it can be used for memory calculation before converting to cstring containing symbols in utf8 coding.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_LengthOfCString(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(TCollection_ExtendedString self) -> std::string"""
        return _TCollection.TCollection_ExtendedString_PrintToString(self)

    def Remove(self, *args) -> "void":
        r"""
        Erases <ahowmany> characters from position <where>,<where> included.

        Parameters
        ----------
        where: int
        ahowmany: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Remove(self, *args)

    def RemoveAll(self, *args) -> "void":
        r"""
        Removes every <what> characters from <self>.

        Parameters
        ----------
        what: Standard_ExtCharacter

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_RemoveAll(self, *args)

    def Search(self, *args) -> "Standard_Integer":
        r"""
        Searches a extendedstring in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_ExtendedString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_Search(self, *args)

    def SearchFromEnd(self, *args) -> "Standard_Integer":
        r"""
        Searches a extendedstring in another extendedstring from the end and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_ExtendedString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_SearchFromEnd(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces one character in the extendedstring at position <where>. if <where> is less than zero or greater than the length of <self> an exception is raised.

        Parameters
        ----------
        where: int
        what: Standard_ExtCharacter

        Returns
        -------
        None
        Replaces a part of <self> by another extendedstring see above.

        Parameters
        ----------
        where: int
        what: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_SetValue(self, *args)

    def Split(self, *args) -> "TCollection_ExtendedString":
        r"""
        Splits this extended string into two sub-strings at position where. - the second sub-string (from position where + 1 of this string to the end) is returned in a new extended string. - this extended string is modified: its last characters are removed, it becomes equal to the first sub-string (from the first character to position where). example: astring contains 'abcdefg' astring.split(3) gives <self> = 'abc' and returns 'defg'.

        Parameters
        ----------
        where: int

        Returns
        -------
        TCollection_ExtendedString

        """
        return _TCollection.TCollection_ExtendedString_Split(self, *args)

    def StartsWith(self, *args) -> "Standard_Boolean":
        r"""
        Determines whether the beginning of this string instance matches the specified string.

        Parameters
        ----------
        theStartString: TCollection_ExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_ExtendedString_StartsWith(self, *args)

    def Swap(self, *args) -> "void":
        r"""
        Exchange the data of two strings (without reallocating memory).

        Parameters
        ----------
        theOther: TCollection_ExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Swap(self, *args)

    def ToExtString(self, *args) -> "Standard_ExtString":
        r"""
        Returns pointer to extstring.

        Returns
        -------
        Standard_ExtString

        """
        return _TCollection.TCollection_ExtendedString_ToExtString(self, *args)

    def ToUTF8CString(self, *args) -> "Standard_Integer":
        r"""
        Converts the internal <mystring> to utf8 coding and returns length of the out cstring. a memory for the <thecstring> should be allocated before call!.

        Parameters
        ----------
        theCString: Standard_PCharacter

        Returns
        -------
        int

        """
        return _TCollection.TCollection_ExtendedString_ToUTF8CString(self, *args)

    def Token(self, *args) -> "TCollection_ExtendedString":
        r"""
        Extracts <whichone> token from <self>. by default, the <separators> is set to space and tabulation. by default, the token extracted is the first one (whichone = 1). <separators> contains all separators you need. if no token indexed by <whichone> is found, it returns an empty asciistring. example: astring contains 'this is a message' astring.token() returns 'this' astring.token(' ',4) returns 'message' astring.token(' ',2) returns 'is' astring.token(' ',9) returns '' other separators than space character and tabulation are allowed : astring contains '1234; test:message , value' astring.token('; :,',4) returns 'value' astring.token('; :,',2) returns 'test'.

        Parameters
        ----------
        separators: Standard_ExtString
        whichone: int,optional
        	default value is 1

        Returns
        -------
        TCollection_ExtendedString

        """
        return _TCollection.TCollection_ExtendedString_Token(self, *args)

    def Trunc(self, *args) -> "void":
        r"""
        Truncates <self> to <ahowmany> characters. example: me = 'hello dolly' -> trunc(3) -> me = 'hel' exceptions standard_outofrange if ahowmany is greater than the length of this string.

        Parameters
        ----------
        ahowmany: int

        Returns
        -------
        None

        """
        return _TCollection.TCollection_ExtendedString_Trunc(self, *args)

    def Value(self, *args) -> "Standard_ExtCharacter":
        r"""
        Returns character at position <where> in <self>. if <where> is less than zero or greater than the lenght of <self>, an exception is raised. example: astring contains 'hello' astring.value(2) returns 'e' exceptions standard_outofrange if where lies outside the bounds of this extended string.

        Parameters
        ----------
        where: int

        Returns
        -------
        Standard_ExtCharacter

        """
        return _TCollection.TCollection_ExtendedString_Value(self, *args)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __ne_wrapper__(self, *args) -> "bool":
        r"""
        __ne_wrapper__(TCollection_ExtendedString self, Standard_ExtString const other) -> bool
        __ne_wrapper__(TCollection_ExtendedString self, TCollection_ExtendedString other) -> bool
        """
        return _TCollection.TCollection_ExtendedString___ne_wrapper__(self, *args)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __add__(self, *args) -> "TCollection_ExtendedString":
        r"""
        No available documentation.

        Parameters
        ----------
        other: TCollection_ExtendedString

        Returns
        -------
        TCollection_ExtendedString

        """
        return _TCollection.TCollection_ExtendedString___add__(self, *args)

    def __iadd_wrapper__(self, other: "TCollection_ExtendedString") -> "void":
        r"""__iadd_wrapper__(TCollection_ExtendedString self, TCollection_ExtendedString other)"""
        return _TCollection.TCollection_ExtendedString___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    def __eq_wrapper__(self, *args) -> "bool":
        r"""
        __eq_wrapper__(TCollection_ExtendedString self, Standard_ExtString const other) -> bool
        __eq_wrapper__(TCollection_ExtendedString self, TCollection_ExtendedString other) -> bool
        """
        return _TCollection.TCollection_ExtendedString___eq_wrapper__(self, *args)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    @methodnotwrapped
    def ToWideString(self):
    	pass

    __swig_destroy__ = _TCollection.delete_TCollection_ExtendedString

# Register TCollection_ExtendedString in _TCollection:
_TCollection.TCollection_ExtendedString_swigregister(TCollection_ExtendedString)

def TCollection_ExtendedString_HashCode(*args) -> "Standard_Integer":
    r"""
    Returns a hashed value for the extended string within the range 1 .. theupper. note: if string is ascii, the computed value is the same as the value computed with the hashcode function on a tcollection_asciistring string composed with equivalent ascii characters. @param theextendedstring the extended string which hash code is to be computed @param theupperbound the upper bound of the range a computing hash code must be within returns a computed hash code, in the range [1, theupperbound].

    Parameters
    ----------
    theString: TCollection_ExtendedString
    theUpperBound: int

    Returns
    -------
    int

    """
    return _TCollection.TCollection_ExtendedString_HashCode(*args)

def TCollection_ExtendedString_IsEqual(*args) -> "Standard_Boolean":
    r"""
    Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

    Parameters
    ----------
    other: Standard_ExtString

    Returns
    -------
    bool
    Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

    Parameters
    ----------
    other: TCollection_ExtendedString

    Returns
    -------
    bool
    Returns true if the characters in this extended string are identical to the characters in the other extended string. note that this method is an alias of operator ==.

    Parameters
    ----------
    theString1: TCollection_ExtendedString
    theString2: TCollection_ExtendedString

    Returns
    -------
    bool

    """
    return _TCollection.TCollection_ExtendedString_IsEqual(*args)

class TCollection_HAsciiString(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes a hasciistring to an empty asciistring.

        Returns
        -------
        None
        Initializes a hasciistring with a cstring.

        Parameters
        ----------
        message: char *

        Returns
        -------
        None
        Initializes a hasciistring with a single character.

        Parameters
        ----------
        aChar: Standard_Character

        Returns
        -------
        None
        Initializes a hasciistring with <length> space allocated. and filled with <filler>.this is useful for buffers.

        Parameters
        ----------
        length: int
        filler: Standard_Character

        Returns
        -------
        None
        Initializes a hasciistring with an integer value.

        Parameters
        ----------
        value: int

        Returns
        -------
        None
        Initializes a hasciistring with a real value.

        Parameters
        ----------
        value: float

        Returns
        -------
        None
        Initializes a hasciistring with a asciistring.

        Parameters
        ----------
        aString: TCollection_AsciiString

        Returns
        -------
        None
        Initializes a hasciistring with a hasciistring.

        Parameters
        ----------
        aString: TCollection_HAsciiString

        Returns
        -------
        None
        Initializes a hasciistring with a hextendedstring. if replacenonascii is non-null charecter, it will be used in place of any non-ascii character found in the source string. otherwise, creates utf-8 unicode string.

        Parameters
        ----------
        aString: TCollection_HExtendedString
        replaceNonAscii: Standard_Character

        Returns
        -------
        None

        """
        _TCollection.TCollection_HAsciiString_swiginit(self, _TCollection.new_TCollection_HAsciiString(*args))

    def AssignCat(self, *args) -> "void":
        r"""
        Appends <other> to me.

        Parameters
        ----------
        other: char *

        Returns
        -------
        None
        Appends <other> to me. example: astring = astring + anotherstring.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_AssignCat(self, *args)

    def Capitalize(self, *args) -> "void":
        r"""
        Converts the first character into its corresponding upper-case character and the other characters into lowercase. example: before me = 'hello ' after me = 'hello '.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Capitalize(self, *args)

    def Cat(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Creates a new string by concatenation of this ascii string and the other ascii string. example: astring = astring + anotherstring astring = astring + 'dummy' astring contains 'i say ' astring = astring + 'hello ' + 'dolly' gives 'i say hello dolly' warning: to catenate more than one cstring, you must put a string before. so the following example is wrong ! astring = 'hello ' + 'dolly' this is not allowed this rule is applicable to assigncat (operator +=) too.

        Parameters
        ----------
        other: char *

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>
        Creates a new string by concatenation of this ascii string and the other ascii string. example: astring = astring + anotherstring.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _TCollection.TCollection_HAsciiString_Cat(self, *args)

    def Center(self, *args) -> "void":
        r"""
        Modifies this ascii string so that its length becomes equal to width and the new characters are equal to filler. new characters are added both at the beginning and at the end of this string. if width is less than the length of this ascii string, nothing happens. example opencascade::handle<tcollection_hasciistring> myalphabet = new tcollection_hasciistring ('abcdef'); myalphabet->center(9,' '); assert ( !strcmp( myalphabet->tocstring(), ' abcdef ') );.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Center(self, *args)

    def ChangeAll(self, *args) -> "void":
        r"""
        Replaces all characters equal to achar by newchar in this ascii string. the substitution is case sensitive if casesensitive is true (default value). if you do not use the default case sensitive option, it does not matter whether achar is upper-case or not. example opencascade::handle<tcollection_hasciistring> mymistake = new tcollection_hasciistring ('hather'); mymistake->changeall('h','f'); assert ( !strcmp( mymistake->tocstring(), 'father') );.

        Parameters
        ----------
        aChar: Standard_Character
        NewChar: Standard_Character
        CaseSensitive: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_ChangeAll(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Removes all characters contained in <self>. this produces an empty hasciistring.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Clear(self, *args)

    def FirstLocationInSet(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the first character of <self> that is present in <set>. the search begins to the index fromindex and ends to the the index toindex. returns zero if failure. raises an exception if fromindex or toindex is out of range example: before me = 'aabacaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabacaa' returns 1.

        Parameters
        ----------
        Set: TCollection_HAsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_FirstLocationInSet(self, *args)

    def FirstLocationNotInSet(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the first character of <self> that is not present in the set <set>. the search begins to the index fromindex and ends to the the index toindex in <self>. returns zero if failure. raises an exception if fromindex or toindex is out of range. example: before me = 'aabacaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabacaa' returns 3.

        Parameters
        ----------
        Set: TCollection_HAsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_FirstLocationNotInSet(self, *args)

    def Insert(self, *args) -> "void":
        r"""
        Insert a character at position <where>. example: astring contains 'hy not ?' astring.insert(1,'w'); gives 'why not ?' astring contains 'wh' astring.insert(3,'y'); gives 'why' astring contains 'way' astring.insert(2,'h'); gives 'why'.

        Parameters
        ----------
        where: int
        what: Standard_Character

        Returns
        -------
        None
        Insert a hasciistring at position <where>.

        Parameters
        ----------
        where: int
        what: char *

        Returns
        -------
        None
        Insert a hasciistring at position <where>.

        Parameters
        ----------
        where: int
        what: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Insert(self, *args)

    def InsertAfter(self, *args) -> "void":
        r"""
        Inserts the other ascii string a after a specific index in the string <self> example: before me = 'cde' , index = 0 , other = 'ab' after me = 'abcde' , other = 'ab'.

        Parameters
        ----------
        Index: int
        other: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_InsertAfter(self, *args)

    def InsertBefore(self, *args) -> "void":
        r"""
        Inserts the other ascii string a before a specific index in the string <self> raises an exception if index is out of bounds example: before me = 'cde' , index = 1 , other = 'ab' after me = 'abcde' , other = 'ab'.

        Parameters
        ----------
        Index: int
        other: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_InsertBefore(self, *args)

    def IntegerValue(self, *args) -> "Standard_Integer":
        r"""
        Converts a hasciistring containing a numeric expression to an integer. example: '215' returns 215.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_IntegerValue(self, *args)

    def IsAscii(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string contains only ascii characters between ' ' and '~'. this means no control character and no extended ascii code.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsAscii(self, *args)

    def IsDifferent(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string s not contains same characters than the string <self>.

        Parameters
        ----------
        S: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsDifferent(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string <self> contains zero character.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsEmpty(self, *args)

    def IsGreater(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is 'ascii' greater than <other>.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsGreater(self, *args)

    def IsIntegerValue(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string contains an integer value.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsIntegerValue(self, *args)

    def IsLess(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is 'ascii' less than <other>.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsLess(self, *args)

    def IsRealValue(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string contains a real value.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsRealValue(self, *args)

    def IsSameState(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsSameState(self, *args)

    def IsSameString(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string s contains same characters than the string <self>.

        Parameters
        ----------
        S: TCollection_HAsciiString

        Returns
        -------
        bool
        Returns true if the string s contains same characters than the string <self>.

        Parameters
        ----------
        S: TCollection_HAsciiString
        CaseSensitive: bool

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HAsciiString_IsSameString(self, *args)

    def LeftAdjust(self, *args) -> "void":
        r"""
        Removes all space characters in the begining of the string.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_LeftAdjust(self, *args)

    def LeftJustify(self, *args) -> "void":
        r"""
        Left justify. length becomes equal to width and the new characters are equal to filler if width < length nothing happens raises an exception if width is less than zero example: before me = 'abcdef' , width = 9 , filler = ' ' after me = 'abcdef '.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_LeftJustify(self, *args)

    def Length(self, *args) -> "Standard_Integer":
        r"""
        Returns number of characters in <self>. this is the same functionality as 'strlen' in c.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_Length(self, *args)

    def Location(self, *args) -> "Standard_Integer":
        r"""
        Returns an index in the string <self> of the first occurence of the string s in the string <self> from the starting index fromindex to the ending index toindex returns zero if failure raises an exception if fromindex or toindex is out of range. example: before me = 'aabaaaa', s = 'aa', fromindex = 1, toindex = 7 after me = 'aabaaaa' returns 4.

        Parameters
        ----------
        other: TCollection_HAsciiString
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int
        Returns the index of the nth occurence of the character c in the string <self> from the starting index fromindex to the ending index toindex. returns zero if failure. raises an exception if fromindex or toindex is out of range example: before me = 'aabaa', n = 3, c = 'a', fromindex = 1, toindex = 5 after me = 'aabaa' returns 5.

        Parameters
        ----------
        N: int
        C: Standard_Character
        FromIndex: int
        ToIndex: int

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_Location(self, *args)

    def LowerCase(self, *args) -> "void":
        r"""
        Converts <self> to its lower-case equivalent.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_LowerCase(self, *args)

    def Prepend(self, *args) -> "void":
        r"""
        Inserts the other string at the begining of the string <self> example: before me = 'cde' , s = 'ab' after me = 'abcde' , s = 'ab'.

        Parameters
        ----------
        other: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Prepend(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(TCollection_HAsciiString self) -> std::string"""
        return _TCollection.TCollection_HAsciiString_PrintToString(self)

    def RealValue(self, *args) -> "Standard_Real":
        r"""
        Converts a string containing a numeric expression to a real. example: '215' returns 215.0. '3.14159267' returns 3.14159267.

        Returns
        -------
        float

        """
        return _TCollection.TCollection_HAsciiString_RealValue(self, *args)

    def Remove(self, *args) -> "void":
        r"""
        Erases <ahowmany> characters from position <where>, <where> included. example: astring contains 'hello' astring.erase(2,2) erases 2 characters from position 1 this gives 'hlo'.

        Parameters
        ----------
        where: int
        ahowmany: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Remove(self, *args)

    def RemoveAll(self, *args) -> "void":
        r"""
        Remove all the occurences of the character c in the string example: before me = 'hellllo', c = 'l' , casesensitive = true after me = 'hello'.

        Parameters
        ----------
        C: Standard_Character
        CaseSensitive: bool

        Returns
        -------
        None
        Removes every <what> characters from <self>.

        Parameters
        ----------
        what: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_RemoveAll(self, *args)

    def RightAdjust(self, *args) -> "void":
        r"""
        Removes all space characters at the end of the string.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_RightAdjust(self, *args)

    def RightJustify(self, *args) -> "void":
        r"""
        Right justify. length becomes equal to width and the new characters are equal to filler if width < length nothing happens raises an exception if width is less than zero example: before me = 'abcdef' , width = 9 , filler = ' ' after me = ' abcdef'.

        Parameters
        ----------
        Width: int
        Filler: Standard_Character

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_RightJustify(self, *args)

    def Search(self, *args) -> "Standard_Integer":
        r"""
        Searches a cstring in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found. example: astring contains 'sample single test' astring.search('le') returns 5.

        Parameters
        ----------
        what: char *

        Returns
        -------
        int
        Searches a string in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_HAsciiString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_Search(self, *args)

    def SearchFromEnd(self, *args) -> "Standard_Integer":
        r"""
        Searches a cstring in a string from the end and returns position of first item <what> matching. it returns -1 if not found. example: astring contains 'sample single test' astring.searchfromend('le') returns 12.

        Parameters
        ----------
        what: char *

        Returns
        -------
        int
        Searches a hasciistring in another hasciistring from the end and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_HAsciiString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_SearchFromEnd(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces one character in the string at position <where>. if <where> is less than zero or greater than the length of <self> an exception is raised. example: astring contains 'garbake' astring.replace(6,'g') gives <self> = 'garbage'.

        Parameters
        ----------
        where: int
        what: Standard_Character

        Returns
        -------
        None
        Replaces a part of <self> in the string at position <where>. if <where> is less than zero or greater than the length of <self> an exception is raised. example: astring contains 'garbake' astring.replace(6,'g') gives <self> = 'garbage'.

        Parameters
        ----------
        where: int
        what: char *

        Returns
        -------
        None
        Replaces a part of <self> by another string.

        Parameters
        ----------
        where: int
        what: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_SetValue(self, *args)

    def Split(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Splits a hasciistring into two sub-strings. example: astring contains 'abcdefg' astring.split(3) gives <self> = 'abc' and returns 'defg'.

        Parameters
        ----------
        where: int

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _TCollection.TCollection_HAsciiString_Split(self, *args)

    def String(self, *args) -> "TCollection_AsciiString const &":
        r"""
        Returns the field mystring.

        Returns
        -------
        TCollection_AsciiString

        """
        return _TCollection.TCollection_HAsciiString_String(self, *args)

    def SubString(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Creation of a sub-string of the string <self>. the sub-string starts to the index fromindex and ends to the index toindex. raises an exception if toindex or fromindex is out of bounds example: before me = 'abcdefg', toindex=3, fromindex=6 after me = 'abcdefg' returns 'cdef'.

        Parameters
        ----------
        FromIndex: int
        ToIndex: int

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _TCollection.TCollection_HAsciiString_SubString(self, *args)

    def ToCString(self, *args) -> "char const *":
        r"""
        Returns pointer to string (char *) this is useful for some casual manipulations because this 'char *' is 'const', you can't modify its contents.

        Returns
        -------
        char *

        """
        return _TCollection.TCollection_HAsciiString_ToCString(self, *args)

    def Token(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Extracts <whichone> token from <self>. by default, the <separators> is set to space and tabulation. by default, the token extracted is the first one (whichone = 1). <separators> contains all separators you need. if no token indexed by <whichone> is found, it returns an empty string. example: astring contains 'this is a message' astring.token() returns 'this' astring.token(' ',4) returns 'message' astring.token(' ',2) returns 'is' astring.token(' ',9) returns '' other separators than space character and tabulation are allowed astring contains '1234; test:message , value' astring.token('; :,',4) returns 'value' astring.token('; :,',2) returns 'test'.

        Parameters
        ----------
        separators: char *,optional
        	default value is '	'
        whichone: int,optional
        	default value is 1

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _TCollection.TCollection_HAsciiString_Token(self, *args)

    def Trunc(self, *args) -> "void":
        r"""
        Truncates <self> to <ahowmany> characters. example: me = 'hello dolly' -> trunc(3) -> me = 'hel'.

        Parameters
        ----------
        ahowmany: int

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_Trunc(self, *args)

    def UpperCase(self, *args) -> "void":
        r"""
        Converts <self> to its upper-case equivalent.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HAsciiString_UpperCase(self, *args)

    def UsefullLength(self, *args) -> "Standard_Integer":
        r"""
        Length of the string ignoring all spaces (' ') and the control character at the end.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HAsciiString_UsefullLength(self, *args)

    def Value(self, *args) -> "Standard_Character":
        r"""
        Returns character at position <where> in <self>. if <where> is less than zero or greater than the lenght of <self>, an exception is raised. example: astring contains 'hello' astring.value(2) returns 'e'.

        Parameters
        ----------
        where: int

        Returns
        -------
        Standard_Character

        """
        return _TCollection.TCollection_HAsciiString_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TCollection_HAsciiString_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_HAsciiString

# Register TCollection_HAsciiString in _TCollection:
_TCollection.TCollection_HAsciiString_swigregister(TCollection_HAsciiString)

class TCollection_HExtendedString(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes a hextendedstring to an empty extendedstring.

        Returns
        -------
        None
        Initializes a hextendedstring with a cstring.

        Parameters
        ----------
        message: char *

        Returns
        -------
        None
        Initializes a hextendedstring with an extstring.

        Parameters
        ----------
        message: Standard_ExtString

        Returns
        -------
        None
        Initializes a hextendedstring with a single character.

        Parameters
        ----------
        aChar: Standard_ExtCharacter

        Returns
        -------
        None
        Initializes a hextendedstring with <length> space allocated. and filled with <filler>.this is usefull for buffers.

        Parameters
        ----------
        length: int
        filler: Standard_ExtCharacter

        Returns
        -------
        None
        Initializes a hextendedstring with a hextendedstring.

        Parameters
        ----------
        aString: TCollection_ExtendedString

        Returns
        -------
        None
        Initializes a hextendedstring with an hasciistring.

        Parameters
        ----------
        aString: TCollection_HAsciiString

        Returns
        -------
        None
        Initializes a hextendedstring with a hextendedstring.

        Parameters
        ----------
        aString: TCollection_HExtendedString

        Returns
        -------
        None

        """
        _TCollection.TCollection_HExtendedString_swiginit(self, _TCollection.new_TCollection_HExtendedString(*args))

    def AssignCat(self, *args) -> "void":
        r"""
        Appends <other> to me.

        Parameters
        ----------
        other: TCollection_HExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_AssignCat(self, *args)

    def Cat(self, *args) -> "opencascade::handle< TCollection_HExtendedString >":
        r"""
        Returns a string appending <other> to me.

        Parameters
        ----------
        other: TCollection_HExtendedString

        Returns
        -------
        opencascade::handle<TCollection_HExtendedString>

        """
        return _TCollection.TCollection_HExtendedString_Cat(self, *args)

    def ChangeAll(self, *args) -> "void":
        r"""
        Substitutes all the characters equal to achar by newchar in the string <self>.

        Parameters
        ----------
        aChar: Standard_ExtCharacter
        NewChar: Standard_ExtCharacter

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_ChangeAll(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Removes all characters contained in <self>. this produces an empty extendedstring.

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_Clear(self, *args)

    def Insert(self, *args) -> "void":
        r"""
        Insert a extcharacter at position <where>. example: astring contains 'hy not ?' astring.insert(1,'w'); gives 'why not ?' astring contains 'wh' astring.insert(3,'y'); gives 'why' astring contains 'way' astring.insert(2,'h'); gives 'why'.

        Parameters
        ----------
        where: int
        what: Standard_ExtCharacter

        Returns
        -------
        None
        Insert a hextendedstring at position <where>.

        Parameters
        ----------
        where: int
        what: TCollection_HExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_Insert(self, *args)

    def IsAscii(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string contains only 'ascii range' characters.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HExtendedString_IsAscii(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the string <self> contains zero character.

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HExtendedString_IsEmpty(self, *args)

    def IsGreater(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is greater than <other>.

        Parameters
        ----------
        other: TCollection_HExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HExtendedString_IsGreater(self, *args)

    def IsLess(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <self> is less than <other>.

        Parameters
        ----------
        other: TCollection_HExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HExtendedString_IsLess(self, *args)

    def IsSameState(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        other: TCollection_HExtendedString

        Returns
        -------
        bool

        """
        return _TCollection.TCollection_HExtendedString_IsSameState(self, *args)

    def Length(self, *args) -> "Standard_Integer":
        r"""
        Returns number of characters in <self>. this is the same functionality as 'strlen' in c.

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HExtendedString_Length(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(TCollection_HExtendedString self) -> std::string"""
        return _TCollection.TCollection_HExtendedString_PrintToString(self)

    def Remove(self, *args) -> "void":
        r"""
        Erases <ahowmany> characters from position <where>, <where> included. example: astring contains 'hello' astring.erase(2,2) erases 2 characters from position 1 this gives 'hlo'.

        Parameters
        ----------
        where: int
        ahowmany: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_Remove(self, *args)

    def RemoveAll(self, *args) -> "void":
        r"""
        Removes every <what> characters from <self>.

        Parameters
        ----------
        what: Standard_ExtCharacter

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_RemoveAll(self, *args)

    def Search(self, *args) -> "Standard_Integer":
        r"""
        Searches a string in <self> from the beginning and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_HExtendedString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HExtendedString_Search(self, *args)

    def SearchFromEnd(self, *args) -> "Standard_Integer":
        r"""
        Searches a extendedstring in another extendedstring from the end and returns position of first item <what> matching. it returns -1 if not found.

        Parameters
        ----------
        what: TCollection_HExtendedString

        Returns
        -------
        int

        """
        return _TCollection.TCollection_HExtendedString_SearchFromEnd(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces one character in the string at position <where>. if <where> is less than zero or greater than the length of <self> an exception is raised. example: astring contains 'garbake' astring.replace(6,'g') gives <self> = 'garbage'.

        Parameters
        ----------
        where: int
        what: Standard_ExtCharacter

        Returns
        -------
        None
        Replaces a part of <self> by another string.

        Parameters
        ----------
        where: int
        what: TCollection_HExtendedString

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_SetValue(self, *args)

    def Split(self, *args) -> "opencascade::handle< TCollection_HExtendedString >":
        r"""
        Splits a extendedstring into two sub-strings. example: astring contains 'abcdefg' astring.split(3) gives <self> = 'abc' and returns 'defg'.

        Parameters
        ----------
        where: int

        Returns
        -------
        opencascade::handle<TCollection_HExtendedString>

        """
        return _TCollection.TCollection_HExtendedString_Split(self, *args)

    def String(self, *args) -> "TCollection_ExtendedString const &":
        r"""
        Returns the field mystring.

        Returns
        -------
        TCollection_ExtendedString

        """
        return _TCollection.TCollection_HExtendedString_String(self, *args)

    def ToExtString(self, *args) -> "Standard_ExtString":
        r"""
        Returns pointer to extstring.

        Returns
        -------
        Standard_ExtString

        """
        return _TCollection.TCollection_HExtendedString_ToExtString(self, *args)

    def Token(self, *args) -> "opencascade::handle< TCollection_HExtendedString >":
        r"""
        Extracts <whichone> token from <self>. by default, the <separators> is set to space and tabulation. by default, the token extracted is the first one (whichone = 1). <separators> contains all separators you need. if no token indexed by <whichone> is found, it returns an empty string. example: astring contains 'this is a message' astring.token() returns 'this' astring.token(' ',4) returns 'message' astring.token(' ',2) returns 'is' astring.token(' ',9) returns '' other separators than space character and tabulation are allowed astring contains '1234; test:message , value' astring.token('; :,',4) returns 'value' astring.token('; :,',2) returns 'test'.

        Parameters
        ----------
        separators: Standard_ExtString
        whichone: int,optional
        	default value is 1

        Returns
        -------
        opencascade::handle<TCollection_HExtendedString>

        """
        return _TCollection.TCollection_HExtendedString_Token(self, *args)

    def Trunc(self, *args) -> "void":
        r"""
        Truncates <self> to <ahowmany> characters. example: me = 'hello dolly' -> trunc(3) -> me = 'hel'.

        Parameters
        ----------
        ahowmany: int

        Returns
        -------
        None

        """
        return _TCollection.TCollection_HExtendedString_Trunc(self, *args)

    def Value(self, *args) -> "Standard_ExtCharacter":
        r"""
        Returns extcharacter at position <where> in <self>. if <where> is less than zero or greater than the length of <self>, an exception is raised. example: astring contains 'hello' astring.value(2) returns 'e'.

        Parameters
        ----------
        where: int

        Returns
        -------
        Standard_ExtCharacter

        """
        return _TCollection.TCollection_HExtendedString_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TCollection_HExtendedString_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_HExtendedString

# Register TCollection_HExtendedString in _TCollection:
_TCollection.TCollection_HExtendedString_swigregister(TCollection_HExtendedString)

class TCollection_MapNode(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        n: TCollection_MapNodePtr

        Returns
        -------
        None

        """
        _TCollection.TCollection_MapNode_swiginit(self, _TCollection.new_TCollection_MapNode(*args))

    def Next(self, *args) -> "TCollection_MapNodePtr &":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_MapNodePtr

        """
        return _TCollection.TCollection_MapNode_Next(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TCollection_MapNode_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_MapNode

# Register TCollection_MapNode in _TCollection:
_TCollection.TCollection_MapNode_swigregister(TCollection_MapNode)

class TCollection_SeqNode(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        n: TCollection_SeqNodePtr
        p: TCollection_SeqNodePtr

        Returns
        -------
        None

        """
        _TCollection.TCollection_SeqNode_swiginit(self, _TCollection.new_TCollection_SeqNode(*args))

    def Next(self, *args) -> "TCollection_SeqNodePtr &":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_SeqNodePtr

        """
        return _TCollection.TCollection_SeqNode_Next(self, *args)

    def Previous(self, *args) -> "TCollection_SeqNodePtr &":
        r"""
        No available documentation.

        Returns
        -------
        TCollection_SeqNodePtr

        """
        return _TCollection.TCollection_SeqNode_Previous(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TCollection_SeqNode_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TCollection.delete_TCollection_SeqNode

# Register TCollection_SeqNode in _TCollection:
_TCollection.TCollection_SeqNode_swigregister(TCollection_SeqNode)





