/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.legacy.AtomText;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.tikz.DriverAtomTextTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverCenteredCharacterTikz2;
import net.sourceforge.plantuml.ugraphic.tikz.DriverDotPathTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverEllipseTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverImageTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverLineTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverPathTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverPolygonTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverRectangleTikz;
import net.sourceforge.plantuml.ugraphic.tikz.DriverTextTikz;

public class UGraphicTikz
extends AbstractUGraphic<TikzGraphics>
implements ClipContainer {
    public UGraphicTikz(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, double scale, boolean withPreamble) {
        super(defaultBackground, colorMapper, stringBounder, new TikzGraphics(scale, withPreamble, colorMapper));
        this.register();
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTikz(this);
    }

    private UGraphicTikz(UGraphicTikz other) {
        super(other);
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleTikz());
        this.registerDriver(UText.class, new DriverTextTikz());
        this.registerDriver(AtomText.class, new DriverAtomTextTikz());
        this.registerDriver(ULine.class, new DriverLineTikz());
        this.registerDriver(UPolygon.class, new DriverPolygonTikz());
        this.registerDriver(UEllipse.class, new DriverEllipseTikz());
        this.registerDriver(UImage.class, new DriverImageTikz());
        this.ignoreShape(UImageSvg.class);
        this.registerDriver(UPath.class, new DriverPathTikz());
        this.registerDriver(DotPath.class, new DriverDotPathTikz());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterTikz2());
    }

    @Override
    public void startUrl(Url url) {
        ((TikzGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip());
    }

    @Override
    public void closeUrl() {
        ((TikzGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ((TikzGraphics)this.getGraphicObject()).createData(os);
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return "SPECIALTXT".equalsIgnoreCase(propertyName);
    }
}

