/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ComponentRoseActiveLine
extends AbstractComponent {
    private final SymbolContext symbolContext;
    private final boolean closeUp;
    private final boolean closeDown;

    public ComponentRoseActiveLine(ThemeStyle themeStyle, Style style, SymbolContext symbolContext, boolean closeUp, boolean closeDown, HColorSet set) {
        super(style);
        if (UseStyle.useBetaStyle()) {
            symbolContext = style.getSymbolContext(themeStyle, set);
        }
        this.symbolContext = symbolContext;
        this.closeUp = closeUp;
        this.closeDown = closeDown;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int x = (int)(dimensionToUse.getWidth() - this.getPreferredWidth(stringBounder)) / 2;
        if (dimensionToUse.getHeight() == 0.0) {
            return;
        }
        URectangle rect = new URectangle(this.getPreferredWidth(stringBounder), dimensionToUse.getHeight());
        if (this.symbolContext.isShadowing()) {
            rect.setDeltaShadow(1.0);
        }
        ug = ug.apply(this.symbolContext.getForeColor());
        if (this.closeUp && this.closeDown) {
            ug.apply(this.symbolContext.getBackColor().bg()).apply(UTranslate.dx(x)).draw(rect);
            return;
        }
        ug.apply(this.symbolContext.getBackColor().bg()).apply(this.symbolContext.getBackColor()).apply(UTranslate.dx(x)).draw(rect);
        ULine vline = ULine.vline(dimensionToUse.getHeight());
        ug.apply(UTranslate.dx(x)).draw(vline);
        ug.apply(UTranslate.dx((double)x + this.getPreferredWidth(stringBounder))).draw(vline);
        ULine hline = ULine.hline(this.getPreferredWidth(stringBounder));
        if (this.closeUp) {
            ug.apply(UTranslate.dx(x)).draw(hline);
        }
        if (this.closeDown) {
            ug.apply(new UTranslate(x, dimensionToUse.getHeight())).draw(hline);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 10.0;
    }
}

