/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.script.SV;
import org.jmol.util.C;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.MeshCapper;
import org.jmol.util.Node;
import org.jmol.util.Normix;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Polyhedron {
    Map<String, Object> info;
    public String id;
    public P3 center;
    public Atom centralAtom;
    public P3[] vertices;
    public int[][] triangles;
    public int[][] faces;
    int nVertices;
    public boolean collapsed;
    private BS bsFlat;
    private float distanceRef;
    private V3[] normals;
    private short[] normixes;
    P4[] planes;
    public String smiles;
    public String smarts;
    public String polySmiles;
    private SymmetryInterface pointGroup;
    private SymmetryInterface pointGroupFamily;
    private Float volume;
    boolean visible = true;
    boolean isFullyLit;
    public boolean isValid = true;
    public short colixEdge = 0;
    public int visibilityFlags = 0;
    public short colix = (short)23;
    public int modelIndex = Integer.MIN_VALUE;
    private P3 offset;
    public float scale = 1.0f;
    public float pointScale;
    private int[][] faceTriangles;
    private int[] elemNos;

    Polyhedron() {
    }

    Polyhedron set(String id, int modelIndex, P3 atomOrPt, P3[] points, int nPoints, int vertexCount, int[][] triangles, int triangleCount, int[][] faces, int[][] faceTriangles, V3[] normals, BS bsFlat, boolean collapsed, float distanceRef, float pointScale) {
        this.pointScale = pointScale;
        this.distanceRef = distanceRef;
        if (id == null) {
            this.centralAtom = (Atom)atomOrPt;
            this.modelIndex = this.centralAtom.mi;
        } else {
            this.id = id;
            this.center = atomOrPt;
            this.modelIndex = modelIndex;
        }
        this.nVertices = vertexCount;
        this.vertices = new P3[nPoints + 1];
        this.normals = new V3[triangleCount];
        this.faces = faces;
        this.faceTriangles = faceTriangles;
        this.bsFlat = bsFlat;
        this.triangles = AU.newInt2(triangleCount);
        int i = nPoints + 1;
        while (--i >= 0) {
            this.vertices[i] = points[i];
        }
        i = triangleCount;
        while (--i >= 0) {
            this.normals[i] = V3.newV(normals[i]);
        }
        i = triangleCount;
        while (--i >= 0) {
            this.triangles[i] = triangles[i];
        }
        this.collapsed = collapsed;
        return this;
    }

    Polyhedron setInfo(Viewer vwr, Map<String, Object> info, Atom[] at) {
        try {
            boolean isSV;
            Object o = info.get("id");
            this.collapsed = info.containsKey("collapsed");
            boolean bl = isSV = !(o instanceof String);
            if (o != null) {
                String string = this.id = isSV ? ((SV)info.get("id")).asString() : o.toString();
            }
            if (this.id == null) {
                this.centralAtom = at[((SV)info.get((Object)"atomIndex")).intValue];
                this.modelIndex = this.centralAtom.mi;
            } else {
                o = info.get("center");
                this.center = P3.newP(isSV ? SV.ptValue((SV)o) : (P3)o);
                o = info.get("modelIndex");
                this.modelIndex = o == null ? vwr.am.cmi : (isSV ? ((SV)o).intValue : (Integer)o);
                o = info.get("color");
                this.colix = C.getColixS(o == null ? "gold" : (isSV ? ((SV)o).asString() : (String)o));
                o = info.get("colorEdge");
                if (o != null) {
                    this.colixEdge = C.getColixS(isSV ? ((SV)o).asString() : o.toString());
                }
                if ((o = info.get("offset")) != null) {
                    this.offset = P3.newP(isSV ? SV.ptValue((SV)o) : (P3)o);
                }
                if ((o = info.get("scale")) != null) {
                    this.scale = isSV ? SV.fValue((SV)o) : ((Float)o).floatValue();
                }
            }
            o = info.get("vertices");
            Lst<SV> lst = isSV ? ((SV)o).getList() : (Lst<SV>)o;
            o = info.get("vertexCount");
            boolean needTriangles = false;
            if (o != null) {
                this.nVertices = isSV ? ((SV)o).intValue : (Integer)o;
                this.vertices = new P3[lst.size()];
                o = info.get("r");
                if (o != null) {
                    this.distanceRef = isSV ? ((SV)o).asFloat() : ((Float)o).floatValue();
                }
            } else {
                this.nVertices = lst.size();
                this.vertices = new P3[this.nVertices + 1];
                if (this.center == null) {
                    this.vertices[this.nVertices] = SV.ptValue((SV)info.get("ptRef"));
                } else {
                    this.vertices[this.nVertices] = this.center;
                    needTriangles = true;
                }
            }
            int i = lst.size();
            while (--i >= 0) {
                o = lst.get(i);
                this.vertices[i] = isSV ? SV.ptValue((SV)o) : (P3)o;
            }
            o = info.get("elemNos");
            if (o != null) {
                lst = isSV ? ((SV)o).getList() : (Lst<SV>)o;
                i = this.nVertices;
                while (--i >= 0) {
                    o = lst.get(i);
                    int n = isSV ? ((SV)o).intValue : (Integer)o;
                    if (n <= 0) continue;
                    Point3fi p = new Point3fi();
                    p.setT(this.vertices[i]);
                    p.sD = (short)n;
                    this.vertices[i] = p;
                }
            }
            if ((o = info.get("pointScale")) != null) {
                this.pointScale = Math.max(0.0f, isSV ? SV.fValue((SV)o) : ((Float)o).floatValue());
            }
            this.faces = this.toInt2(isSV, info.get("faces"));
            o = info.get("triangles");
            if (o == null) {
                if (needTriangles) {
                    this.faceTriangles = AU.newInt2(this.faces.length);
                    this.triangles = ((MeshCapper)Interface.getInterface("org.jmol.util.MeshCapper", vwr, "script")).set(null).triangulateFaces(this.faces, this.vertices, this.faceTriangles);
                } else {
                    this.triangles = this.faces;
                    this.faces = null;
                }
            } else {
                this.triangles = this.toInt2(isSV, o);
            }
            this.normals = new V3[this.triangles.length];
            V3 vAB = new V3();
            int i2 = this.triangles.length;
            while (--i2 >= 0) {
                this.normals[i2] = new V3();
                int[] a = this.triangles[i2];
                Measure.getNormalThroughPoints(this.vertices[a[0]], this.vertices[a[1]], this.vertices[a[2]], this.normals[i2], vAB);
            }
            o = info.get("bsFlat");
            this.bsFlat = o == null ? new BS() : (isSV ? SV.getBitSet((SV)o, false) : (BS)o);
        }
        catch (Exception e) {
            return null;
        }
        return this;
    }

    private int[][] toInt2(boolean isSV, Object o) {
        Lst<SV> lst = isSV ? ((SV)o).getList() : (Lst<SV>)o;
        int[][] ai = AU.newInt2(lst.size());
        int i = ai.length;
        while (--i >= 0) {
            o = lst.get(i);
            if (isSV) {
                Lst<SV> lst2 = ((SV)o).getList();
                ai[i] = new int[lst2.size()];
                int[] a = ai[i];
                int j = a.length;
                while (--j >= 0) {
                    a[j] = ((SV)lst2.get((int)j)).intValue;
                }
                continue;
            }
            ai[i] = (int[])o;
        }
        return ai;
    }

    Map<String, Object> getInfo(Viewer vwr, String property) {
        boolean isState = property == null;
        boolean isFaceCalc = !isState;
        Map<String, Object> info = this.info;
        if (!(isState || info == null || isFaceCalc && !info.containsKey("face_types") || Logger.debugging)) {
            return info;
        }
        info = new Hashtable<String, Object>();
        info.put("vertexCount", this.nVertices);
        int nv = isState ? this.vertices.length : this.nVertices;
        P3[] pts = new P3[nv];
        for (int i = 0; i < nv; ++i) {
            pts[i] = P3.newP(this.vertices[i]);
        }
        info.put("vertices", pts);
        info.put("elemNos", this.getElemNos());
        if (this.id == null) {
            info.put("atomIndex", this.centralAtom.i);
        } else {
            info.put("id", this.id);
            info.put("center", P3.newP(this.center));
            info.put("color", C.getHexCode(this.colix));
            info.put("colorEdge", C.getHexCode(this.colixEdge == 0 ? this.colix : this.colixEdge));
            if (this.offset != null) {
                info.put("offset", this.offset);
            }
            if (this.scale != 1.0f) {
                info.put("scale", Float.valueOf(this.scale));
            }
        }
        if (this.id != null || !isState) {
            info.put("modelIndex", this.modelIndex);
        }
        if (!isState) {
            this.info = info;
            if (this.id == null) {
                info.put("center", P3.newP(this.centralAtom));
                info.put("modelNumber", this.centralAtom.getModelNumber());
                info.put("atomNumber", this.centralAtom.getAtomNumber());
                info.put("atomName", this.centralAtom.getInfo());
                info.put("element", this.centralAtom.getElementSymbol());
                Object energy = vwr.ms.getInfo(this.centralAtom.mi, "Energy");
                if (energy != null) {
                    info.put("energy", energy);
                }
            }
            info.put("triangleCount", this.triangles.length);
            info.put("volume", this.getVolume());
            String[] names = new String[this.nVertices];
            int[] indices = new int[this.nVertices];
            int i = this.nVertices;
            while (--i >= 0) {
                P3 pt = this.vertices[i];
                boolean isNode = pt instanceof Node;
                names[i] = isNode ? ((Node)((Object)pt)).getAtomName() : (pt instanceof Point3fi ? Elements.elementSymbolFromNumber(((Point3fi)pt).sD) : "");
                indices[i] = isNode ? ((Node)((Object)pt)).getIndex() : -1;
            }
            info.put("atomNames", names);
            info.put("vertexIndices", indices);
            if (this.faces != null && !this.collapsed && this.faceTriangles != null) {
                info.put("faceCount", this.faces.length);
                info.put("faceTriangles", this.faceTriangles);
                if (isFaceCalc) {
                    int[] faceTypes = new int[this.faces.length];
                    float[] faceAreas = new float[this.faces.length];
                    Lst<P3[]> facePoints = new Lst<P3[]>();
                    V3 vAB = new V3();
                    V3 vAC = new V3();
                    V3 vTemp = new V3();
                    int i2 = this.faces.length;
                    while (--i2 >= 0) {
                        int[] face = this.faces[i2];
                        faceTypes[i2] = face.length;
                        float f = 0.0f;
                        int[] ft = this.faceTriangles[i2];
                        int j = ft.length;
                        while (--j >= 0) {
                            int[] t = this.triangles[ft[j]];
                            f += this.triangleArea(t[0], t[1], t[2], vAB, vAC, vTemp);
                        }
                        faceAreas[i2] = f;
                        P3[] fpts = new P3[face.length];
                        int j2 = face.length;
                        while (--j2 >= 0) {
                            fpts[j2] = this.vertices[face[j2]];
                        }
                        facePoints.addLast(fpts);
                    }
                    info.put("face_types", faceTypes);
                    info.put("face_areas", faceAreas);
                    info.put("face_points", facePoints);
                }
            }
            if (this.smarts != null) {
                info.put("smarts", this.smarts);
            }
            if (this.smiles != null) {
                info.put("smiles", this.smiles);
            }
            if (this.polySmiles != null) {
                info.put("polySmiles", this.polySmiles);
            }
            if (this.pointGroup != null) {
                info.put("pointGroup", this.pointGroup.getPointGroupName());
            }
            if (this.pointGroupFamily != null) {
                info.put("pointGroupFamily", this.pointGroupFamily.getPointGroupName());
            }
        }
        if (this.pointScale > 0.0f) {
            info.put("pointScale", Float.valueOf(this.pointScale));
        }
        if (this.faces != null) {
            info.put("faces", this.faces);
        }
        if (isState || Logger.debugging) {
            info.put("bsFlat", this.bsFlat);
            if (this.collapsed) {
                info.put("collapsed", this.collapsed);
            }
            if (this.distanceRef != 0.0f) {
                info.put("r", Float.valueOf(this.distanceRef));
            }
            P3[] n = new P3[this.normals.length];
            int i = n.length;
            while (--i >= 0) {
                n[i] = P3.newP(this.normals[i]);
            }
            if (!isState) {
                info.put("normals", n);
            }
            info.put("triangles", AU.arrayCopyII(this.triangles, this.triangles.length));
        }
        return info;
    }

    public int[] getElemNos() {
        if (this.elemNos == null) {
            this.elemNos = new int[this.nVertices];
            for (int i = 0; i < this.nVertices; ++i) {
                P3 pt = this.vertices[i];
                this.elemNos[i] = pt instanceof Node ? ((Node)((Object)pt)).getElementNumber() : (pt instanceof Point3fi ? (int)((Point3fi)pt).sD : -2);
            }
        }
        return this.elemNos;
    }

    String getSymmetry(Viewer vwr, boolean withPointGroup) {
        if (this.id == null && this.smarts == null) {
            this.info = null;
            SmilesMatcherInterface sm = vwr.getSmilesMatcher();
            try {
                String details = this.distanceRef <= 0.0f ? null : "r=" + this.distanceRef;
                this.polySmiles = sm.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 0x10001 | (Logger.debugging ? 131072 : 0), details);
                this.smarts = sm.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, null, 16384, null);
                this.smiles = sm.polyhedronToSmiles(this.centralAtom, this.faces, this.nVertices, this.vertices, 1, null);
            }
            catch (Exception details) {
                // empty catch block
            }
        }
        if (!withPointGroup) {
            return null;
        }
        if (this.pointGroup == null) {
            T3[] pts = new T3[this.nVertices];
            int i = pts.length;
            while (--i >= 0) {
                pts[i] = this.vertices[i];
            }
            this.pointGroup = vwr.getSymTemp().setPointGroup(null, null, pts, null, false, vwr.getFloat(0x22000026), vwr.getFloat(0x22000028), true);
            i = pts.length;
            while (--i >= 0) {
                pts[i] = P3.newP(this.vertices[i]);
            }
            this.pointGroupFamily = vwr.getSymTemp().setPointGroup(null, null, pts, null, false, vwr.getFloat(0x22000026), vwr.getFloat(0x22000028), true);
        }
        return (this.center == null ? this.centralAtom : this.center) + "    \t" + this.pointGroup.getPointGroupName() + "\t" + this.pointGroupFamily.getPointGroupName();
    }

    private Float getVolume() {
        if (this.volume != null) {
            return this.volume;
        }
        V3 vAB = new V3();
        V3 vAC = new V3();
        V3 vTemp = new V3();
        float v = 0.0f;
        if (this.bsFlat.cardinality() < this.triangles.length) {
            int i = this.triangles.length;
            while (--i >= 0) {
                int[] t = this.triangles[i];
                v += this.triangleVolume(t[0], t[1], t[2], vAB, vAC, vTemp);
            }
        }
        return Float.valueOf(v / 6.0f);
    }

    private float triangleArea(int i, int j, int k, V3 vAB, V3 vAC, V3 vTemp) {
        vAB.sub2(this.vertices[j], this.vertices[i]);
        vAC.sub2(this.vertices[k], this.vertices[i]);
        vTemp.cross(vAB, vAC);
        return vTemp.length();
    }

    private float triangleVolume(int i, int j, int k, V3 vAB, V3 vAC, V3 vTemp) {
        vAB.setT(this.vertices[i]);
        vAC.setT(this.vertices[j]);
        vTemp.cross(vAB, vAC);
        vAC.setT(this.vertices[k]);
        return vAC.dot(vTemp);
    }

    String getState(Viewer vwr) {
        String ident = this.id == null ? "({" + this.centralAtom.i + "})" : "ID " + Escape.e(this.id);
        return "  polyhedron @{" + Escape.e(this.getInfo(vwr, null)) + "} " + (this.isFullyLit ? " fullyLit" : "") + ";" + (this.visible ? "" : "polyhedra " + ident + " off;") + "\n";
    }

    void move(M4 mat, BS bsMoved) {
        int i;
        this.info = null;
        for (i = 0; i < this.nVertices; ++i) {
            P3 p = this.vertices[i];
            if (p instanceof Atom) {
                if (bsMoved.get(((Atom)p).i)) continue;
                p = this.vertices[i] = P3.newP(p);
            }
            mat.rotTrans(p);
        }
        i = this.normals.length;
        while (--i >= 0) {
            mat.rotate(this.normals[i]);
        }
        this.normixes = null;
    }

    public short[] getNormixes() {
        if (this.normixes == null) {
            this.normixes = new short[this.normals.length];
            BS bsTemp = new BS();
            int i = this.normals.length;
            while (--i >= 0) {
                this.normixes[i] = this.bsFlat.get(i) ? Normix.get2SidedNormix(this.normals[i], bsTemp) : Normix.getNormixV(this.normals[i], bsTemp);
            }
        }
        return this.normixes;
    }

    void setOffset(P3 value) {
        this.planes = null;
        if (this.center == null) {
            return;
        }
        P3 v = P3.newP(value);
        if (this.offset != null) {
            value.sub(this.offset);
        }
        this.offset = v;
        int i = this.vertices.length;
        while (--i >= 0) {
            this.vertices[i].add(value);
        }
    }
}

