/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.Lst;
import org.jmol.minimize.MMConstraint;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.UFFAngleCalc;
import org.jmol.minimize.forcefield.UFFDistanceCalc;
import org.jmol.minimize.forcefield.UFFOOPCalc;
import org.jmol.minimize.forcefield.UFFTorsionCalc;
import org.jmol.minimize.forcefield.UFFVDWCalc;

class CalculationsUFF
extends Calculations {
    static final double KCAL332 = 1390.2842991599998;
    static final double KCAL644 = 2696.8016159999997;
    static final double KCAL6 = 25.1208;
    static final double KCAL22 = 92.1096;
    static final double KCAL44 = 184.2192;
    static final int PAR_R = 0;
    static final int PAR_THETA = 1;
    static final int PAR_X = 2;
    static final int PAR_D = 3;
    static final int PAR_ZETA = 4;
    static final int PAR_Z = 5;
    static final int PAR_V = 6;
    static final int PAR_U = 7;
    static final int PAR_XI = 8;
    static final int PAR_HARD = 9;
    static final int PAR_RADIUS = 10;
    Calculation bondCalc;
    Calculation angleCalc;
    Calculation torsionCalc;
    Calculation oopCalc;
    Calculation vdwCalc;

    CalculationsUFF(ForceField ff, Map<Object, Object> ffParams, MinAtom[] minAtoms, MinBond[] minBonds, MinAngle[] minAngles, MinTorsion[] minTorsions, MinPosition[] minPositions, Lst<MMConstraint> constraints) {
        super(ff, minAtoms, minBonds, minAngles, minTorsions, minPositions, constraints);
        this.ffParams = ffParams;
        this.bondCalc = new UFFDistanceCalc().set(this);
        this.angleCalc = new UFFAngleCalc().set(this);
        this.torsionCalc = new UFFTorsionCalc().set(this);
        this.oopCalc = new UFFOOPCalc().set(this);
        this.vdwCalc = new UFFVDWCalc().set(this);
    }

    @Override
    String getUnits() {
        return "kJ";
    }

    @Override
    boolean setupCalculations() {
        Calculation distanceCalc = new UFFDistanceCalc().set(this);
        Lst<Object> calc = this.calculations[0] = new Lst<Object[]>();
        for (int i = 0; i < this.bondCount; ++i) {
            MinBond bond = this.minBonds[i];
            double bondOrder = bond.order;
            if (bond.isAromatic) {
                bondOrder = 1.5;
            }
            if (bond.isAmide) {
                bondOrder = 1.41;
            }
            distanceCalc.setData(calc, bond.data[0], bond.data[1], bondOrder);
        }
        this.calculations[1] = new Lst();
        calc = this.calculations[1];
        UFFAngleCalc angleCalc = (UFFAngleCalc)new UFFAngleCalc().set(this);
        int i = this.minAngles.length;
        while (--i >= 0) {
            angleCalc.setData(calc, this.minAngles[i].data);
        }
        this.calculations[2] = new Lst();
        calc = this.calculations[2];
        UFFTorsionCalc torsionCalc = (UFFTorsionCalc)new UFFTorsionCalc().set(this);
        int i2 = this.minTorsions.length;
        while (--i2 >= 0) {
            torsionCalc.setData(calc, this.minTorsions[i2].data);
        }
        this.calculations[4] = new Lst();
        calc = this.calculations[4];
        Calculation oopCalc = new UFFOOPCalc().set(this);
        for (int i3 = 0; i3 < this.ac; ++i3) {
            int elemNo;
            MinAtom a = this.minAtoms[i3];
            if (a.nBonds != 3 || a.sType == "C_3" || !CalculationsUFF.isInvertible(elemNo = a.atom.getElementNumber())) continue;
            oopCalc.setData(calc, i3, elemNo, 0.0);
        }
        this.calculations[5] = new Lst<Object[]>();
        this.pairSearch(this.calculations[5], new UFFVDWCalc().set(this), null, null);
        return true;
    }

    private static boolean isInvertible(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 33: 
            case 51: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    static double calculateR0(double ri, double rj, double chiI, double chiJ, double bondorder) {
        double rbo = -0.1332 * (ri + rj) * Math.log(bondorder);
        double dchi = Math.sqrt(chiI) - Math.sqrt(chiJ);
        double ren = ri * rj * dchi * dchi / (chiI * ri + chiJ * rj);
        return ri + rj + rbo - ren;
    }

    @Override
    double compute(int iType, Object[] dataIn) {
        switch (iType) {
            case 0: {
                return this.bondCalc.compute(dataIn);
            }
            case 1: {
                return this.angleCalc.compute(dataIn);
            }
            case 2: {
                return this.torsionCalc.compute(dataIn);
            }
            case 4: {
                return this.oopCalc.compute(dataIn);
            }
            case 5: {
                return this.vdwCalc.compute(dataIn);
            }
        }
        return 0.0;
    }

    @Override
    String getDebugHeader(int iType) {
        switch (iType) {
            case -1: {
                return "Universal Force Field -- Rappe, A. K., et. al.; J. Am. Chem. Soc. (1992) 114(25) p. 10024-10035\n";
            }
        }
        return this.getDebugHeader2(iType);
    }

    @Override
    protected Object getParameterObj(MinObject o) {
        return null;
    }
}

