/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import tim.prune.gui.map.CacheFailure;
import tim.prune.gui.map.MapTile;

public class DiskTileCacher
implements Runnable {
    private URL _url = null;
    private File _file = null;
    private ImageObserver _observer = null;
    private boolean _active = false;
    private static final long CACHE_TIME_LIMIT = 1728000000L;
    private static final HashSet<String> BLOCKED_URLS = new HashSet();
    private static final HashSet<String> DOWNLOADING_FILES = new HashSet();
    private static int NUMBER_ACTIVE_THREADS = 0;
    private static boolean CONNECTION_ACTIVE = true;
    private static boolean TRIED_TO_CREATE_BASEPATH = false;

    private DiskTileCacher(URL uRL, File file, ImageObserver imageObserver) {
        this._url = uRL;
        this._file = file;
        this._observer = imageObserver;
        this._active = DiskTileCacher.registerCacher(file.getAbsolutePath());
    }

    public static MapTile getTile(String string, String string2) {
        if (string == null) {
            return null;
        }
        File file = new File(string, string2);
        Image image = null;
        if (file.exists() && file.canRead() && file.length() > 0L) {
            long l = file.lastModified();
            boolean bl = System.currentTimeMillis() - l > 1728000000L;
            try {
                image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
                return new MapTile(image, bl);
            }
            catch (Exception exception) {
                System.err.println("createImage: " + exception.getClass().getName() + " _ " + exception.getMessage());
            }
        }
        return null;
    }

    public static void saveTile(URL uRL, String string, String string2, ImageObserver imageObserver) throws CacheFailure {
        if (string == null || string2 == null) {
            return;
        }
        File file = new File(string);
        if (!DiskTileCacher.checkBasePath(file)) {
            throw new CacheFailure();
        }
        File file2 = new File(file, string2);
        if (BLOCKED_URLS.contains(uRL.toString())) {
            return;
        }
        File file3 = file2.getParentFile();
        if ((file3.exists() || file3.mkdirs()) && file3.canWrite()) {
            DiskTileCacher diskTileCacher = new DiskTileCacher(uRL, file2, imageObserver);
            diskTileCacher.startDownloading();
        }
    }

    private static boolean checkBasePath(File file) {
        if (!file.exists() && !TRIED_TO_CREATE_BASEPATH) {
            TRIED_TO_CREATE_BASEPATH = true;
            System.out.println("Base path '" + file.getAbsolutePath() + "' does not exist, trying to create");
            return file.mkdirs();
        }
        return file.exists() && file.isDirectory() && file.canWrite();
    }

    private void startDownloading() {
        if (this._active) {
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        this.waitUntilAllowedToRun();
        if (this.doDownload() && !CONNECTION_ACTIVE) {
            BLOCKED_URLS.clear();
            CONNECTION_ACTIVE = true;
        }
        DiskTileCacher.unregisterCacher(this._file.getAbsolutePath());
        DiskTileCacher.threadFinished();
    }

    private void waitUntilAllowedToRun() {
        while (!DiskTileCacher.canStartNewThread()) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean doDownload() {
        File file;
        block30: {
            boolean bl = false;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            file = new File(String.valueOf(this._file.getAbsolutePath()) + ".temp");
            if (file.exists()) {
                file.delete();
            }
            try {
                if (!file.createNewFile()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    URLConnection uRLConnection = this._url.openConnection();
                    uRLConnection.setRequestProperty("User-Agent", "GpsPrune v21.1");
                    inputStream = uRLConnection.getInputStream();
                    int n = 0;
                    while ((n = inputStream.read()) >= 0) {
                        fileOutputStream.write(n);
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    System.err.println("ioe: " + iOException.getClass().getName() + " - " + iOException.getMessage());
                    BLOCKED_URLS.add(this._url.toString());
                    CONNECTION_ACTIVE = false;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                    if (!bl) {
                        file.delete();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                if (!bl) {
                    file.delete();
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            if (!bl) {
                file.delete();
            }
        }
        boolean bl = false;
        if (file.exists() && file.length() > 0L) {
            if (file.renameTo(this._file)) {
                bl = true;
            } else if (this._file.delete() && file.renameTo(this._file)) {
                bl = true;
            } else {
                System.out.println("Failed to rename temp file: " + file.getAbsolutePath());
                file.delete();
            }
        }
        this._observer.imageUpdate(null, 32, 0, 0, 0, 0);
        return bl;
    }

    private static synchronized boolean registerCacher(String string) {
        if (DOWNLOADING_FILES.contains(string)) {
            return false;
        }
        DOWNLOADING_FILES.add(string);
        return true;
    }

    private static synchronized void unregisterCacher(String string) {
        DOWNLOADING_FILES.remove(string);
    }

    private static synchronized boolean canStartNewThread() {
        if (NUMBER_ACTIVE_THREADS < 8) {
            ++NUMBER_ACTIVE_THREADS;
            return true;
        }
        return false;
    }

    private static synchronized void threadFinished() {
        if (NUMBER_ACTIVE_THREADS > 0) {
            --NUMBER_ACTIVE_THREADS;
        }
    }
}

