/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.api.selection;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizArchitecture;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.opengl.AbstractEngine;

public class SelectionManager
implements VizArchitecture {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private VizConfig vizConfig;
    private AbstractEngine engine;
    private int mouseSelectionDiameter;
    private boolean mouseSelectionZoomProportionnal;
    private boolean selectionUpdateWhileDragging;
    private boolean blocked = false;

    @Override
    public void initArchitecture() {
        this.vizConfig = VizController.getInstance().getVizConfig();
        this.engine = VizController.getInstance().getEngine();
        this.mouseSelectionDiameter = this.vizConfig.getMouseSelectionDiameter();
        this.selectionUpdateWhileDragging = this.vizConfig.isMouseSelectionUpdateWhileDragging();
    }

    public void blockSelection(boolean block) {
        if (this.vizConfig.isRectangleSelection()) {
            this.blocked = block;
            this.vizConfig.setSelectionEnable(!block);
            this.fireChangeEvent();
        } else {
            this.setDirectMouseSelection();
        }
    }

    public void disableSelection() {
        this.vizConfig.setSelectionEnable(false);
        this.blocked = false;
        this.fireChangeEvent();
    }

    public void setDraggingEnable(boolean dragging) {
        this.vizConfig.setMouseSelectionUpdateWhileDragging(!dragging);
        this.fireChangeEvent();
    }

    public void setRectangleSelection() {
        this.engine.setRectangleSelection(true);
        this.vizConfig.setDraggingEnable(false);
        this.vizConfig.setCustomSelection(false);
        this.vizConfig.setSelectionEnable(true);
        this.blocked = false;
        this.fireChangeEvent();
    }

    public void setDirectMouseSelection() {
        this.engine.setRectangleSelection(false);
        this.vizConfig.setSelectionEnable(true);
        this.vizConfig.setDraggingEnable(false);
        this.vizConfig.setCustomSelection(false);
        this.blocked = false;
        this.fireChangeEvent();
    }

    public void setDraggingMouseSelection() {
        this.engine.setRectangleSelection(false);
        this.vizConfig.setDraggingEnable(true);
        this.vizConfig.setMouseSelectionUpdateWhileDragging(false);
        this.vizConfig.setSelectionEnable(true);
        this.vizConfig.setCustomSelection(false);
        this.blocked = false;
        this.fireChangeEvent();
    }

    public void setCustomSelection() {
        this.engine.setRectangleSelection(false);
        this.vizConfig.setSelectionEnable(false);
        this.vizConfig.setDraggingEnable(false);
        this.vizConfig.setCustomSelection(true);
        this.fireChangeEvent();
    }

    public void resetSelection() {
        if (this.isCustomSelection()) {
            this.vizConfig.setCustomSelection(false);
            this.setDirectMouseSelection();
        }
        this.engine.resetSelection();
    }

    public List<Node> getSelectedNodes() {
        return this.engine.getSelectedUnderlyingNodes();
    }

    public List<Edge> getSelectedEdges() {
        return this.engine.getSelectedUnderlyingEdges();
    }

    public void selectNode(Node node) {
        this.selectNodes(new Node[]{node});
    }

    public void selectEdge(Edge edge) {
        this.selectEdges(new Edge[]{edge});
    }

    public void selectNodes(Node[] nodes) {
        if (!this.isCustomSelection()) {
            this.setCustomSelection();
        }
        Model[] models = this.engine.getNodeModelsForNodes(nodes);
        this.engine.selectObject(models);
    }

    public void selectEdges(Edge[] edges) {
        if (!this.isCustomSelection()) {
            this.setCustomSelection();
        }
        Model[] models = this.engine.getEdgeModelsForEdges(edges);
        this.engine.selectObject(models);
    }

    public void centerOnNode(Node node) {
        if (node != null) {
            VizController.getInstance().getGraphIO().centerOnCoordinate(node.x(), node.y(), node.z() + node.size() * 8.0f);
            this.engine.getScheduler().requireUpdateVisible();
        }
    }

    public int getMouseSelectionDiameter() {
        return this.mouseSelectionDiameter;
    }

    public void setMouseSelectionDiameter(int mouseSelectionDiameter) {
        this.mouseSelectionDiameter = mouseSelectionDiameter;
    }

    public boolean isMouseSelectionZoomProportionnal() {
        return this.mouseSelectionZoomProportionnal;
    }

    public void setMouseSelectionZoomProportionnal(boolean mouseSelectionZoomProportionnal) {
        this.mouseSelectionZoomProportionnal = mouseSelectionZoomProportionnal;
    }

    public boolean isSelectionUpdateWhileDragging() {
        return this.selectionUpdateWhileDragging;
    }

    public void setSelectionUpdateWhileDragging(boolean selectionUpdateWhileDragging) {
        this.selectionUpdateWhileDragging = selectionUpdateWhileDragging;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isRectangleSelection() {
        return this.vizConfig.isSelectionEnable() && this.vizConfig.isRectangleSelection();
    }

    public boolean isDirectMouseSelection() {
        return this.vizConfig.isSelectionEnable() && !this.vizConfig.isRectangleSelection() && !this.vizConfig.isDraggingEnable();
    }

    public boolean isCustomSelection() {
        return this.vizConfig.isCustomSelection();
    }

    public boolean isSelectionEnabled() {
        return this.vizConfig.isSelectionEnable();
    }

    public boolean isDraggingEnabled() {
        return this.vizConfig.isDraggingEnable();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(evt);
        }
    }
}

