/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterDL;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterDLPanel;
import org.openide.util.NbBundle;

public class UIExporterDL
implements ExporterUI {
    private final ExporterDLSettings settings = new ExporterDLSettings();
    private UIExporterDLPanel panel;
    private ExporterDL exporter;

    public JPanel getPanel() {
        this.panel = new UIExporterDLPanel();
        return this.panel;
    }

    public void setup(Exporter exporter) {
        this.exporter = (ExporterDL)exporter;
        this.settings.load(this.exporter);
        this.panel.setup(this.exporter);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporter);
            this.settings.save(this.exporter);
        }
        this.panel = null;
        this.exporter = null;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterDL;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterDL.class, (String)"UIExporterDL.name");
    }

    private static class ExporterDLSettings
    extends AbstractExporterSettings {
        private static final String USE_LIST_FORMAT = "DL_useListFormat";
        private static final String USE_MATRIX_FORMAT = "DL_useMatrixFormat";
        private static final String MAKE_SYMMETRIC_MATRIX = "DL_makeSymmetricMatrix";
        private static final ExporterDL DEFAULT = new ExporterDL();

        private ExporterDLSettings() {
        }

        private void load(ExporterDL exporterDL) {
            exporterDL.setUseListFormat(this.get(USE_LIST_FORMAT, DEFAULT.isUseListFormat()));
            exporterDL.setUseMatrixFormat(this.get(USE_MATRIX_FORMAT, DEFAULT.isUseMatrixFormat()));
            exporterDL.setMakeSymmetricMatrix(this.get(MAKE_SYMMETRIC_MATRIX, DEFAULT.isMakeSymmetricMatrix()));
        }

        private void save(ExporterDL exporterDL) {
            this.put(USE_LIST_FORMAT, exporterDL.isUseListFormat());
            this.put(USE_MATRIX_FORMAT, exporterDL.isUseMatrixFormat());
            this.put(MAKE_SYMMETRIC_MATRIX, exporterDL.isMakeSymmetricMatrix());
        }
    }
}

