/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Origin;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.GraphStore;

public class DefaultColumnsImpl
implements GraphModel.DefaultColumns {
    protected final GraphStore store;
    protected final ColumnImpl degreeColumn;
    protected final ColumnImpl inDegreeColumn;
    protected final ColumnImpl outDegreeColumn;
    protected final ColumnImpl typeColumn;

    public DefaultColumnsImpl(GraphStore store) {
        this.store = store;
        this.degreeColumn = new ColumnImpl(store.nodeTable, "degree", Integer.class, "Degree", null, Origin.PROPERTY, false, true);
        this.inDegreeColumn = new ColumnImpl(store.nodeTable, "indegree", Integer.class, "In-Degree", null, Origin.PROPERTY, false, true);
        this.outDegreeColumn = new ColumnImpl(store.nodeTable, "outdegree", Integer.class, "Out-Degree", null, Origin.PROPERTY, false, true);
        this.typeColumn = new ColumnImpl(store.edgeTable, "type", Integer.class, "Type", null, Origin.PROPERTY, false, true);
    }

    @Override
    public Column nodeId() {
        return this.store.nodeTable.getColumn(0);
    }

    @Override
    public Column edgeId() {
        return this.store.edgeTable.getColumn(0);
    }

    @Override
    public Column edgeWeight() {
        return this.store.edgeTable.getColumn(3);
    }

    @Override
    public Column nodeLabel() {
        return this.store.nodeTable.getColumn(1);
    }

    @Override
    public Column edgeLabel() {
        return this.store.edgeTable.getColumn(1);
    }

    @Override
    public Column nodeTimeSet() {
        return this.store.nodeTable.getColumn(2);
    }

    @Override
    public Column edgeTimeSet() {
        return this.store.edgeTable.getColumn(2);
    }

    @Override
    public Column degree() {
        return this.degreeColumn;
    }

    @Override
    public Column inDegree() {
        return this.inDegreeColumn;
    }

    @Override
    public Column outDegree() {
        return this.outDegreeColumn;
    }

    @Override
    public Column edgeType() {
        return this.typeColumn;
    }
}

