/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.gephi.desktop.tools.SelectionBar;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PropertiesBar
extends JPanel {
    private final SelectionBar selectionBar;
    private JPanel propertiesBar;

    public PropertiesBar() {
        super(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setOpaque(true);
        leftPanel.add((Component)this.getFullScreenIcon(), "West");
        this.selectionBar = new SelectionBar();
        leftPanel.add((Component)this.selectionBar, "Center");
        this.add((Component)leftPanel, "West");
        this.setOpaque(true);
    }

    public void select(JPanel propertiesBar) {
        this.propertiesBar = propertiesBar;
        propertiesBar.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add((Component)propertiesBar, "Center");
        propertiesBar.setOpaque(true);
        for (Component c : propertiesBar.getComponents()) {
            if (!(c instanceof JPanel) && !(c instanceof JToolBar)) continue;
            ((JComponent)c).setOpaque(true);
        }
        this.revalidate();
    }

    public void unselect() {
        if (this.propertiesBar != null) {
            this.remove(this.propertiesBar);
            this.revalidate();
            this.repaint();
            this.propertiesBar = null;
        }
    }

    private JComponent getFullScreenIcon() {
        int logoWidth = 27;
        int logoHeight = 28;
        if (UIUtils.isAquaLookAndFeel()) {
            logoWidth = 34;
        }
        JPanel c = new JPanel(new BorderLayout());
        c.setBackground(Color.WHITE);
        if (!UIUtils.isAquaLookAndFeel()) {
            JButton fullScreenButton = new JButton();
            fullScreenButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/tools/gephilogo_std.png")));
            fullScreenButton.setRolloverEnabled(true);
            fullScreenButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/tools/gephilogo_glow.png")));
            fullScreenButton.setToolTipText(NbBundle.getMessage(PropertiesBar.class, (String)"PropertiesBar.fullScreenButton.tooltip"));
            fullScreenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lookup lookup = Lookups.forPath((String)"org-gephi-desktop-tools/Actions/ToggleFullScreenAction");
                    for (Action a : lookup.lookupAll(Action.class)) {
                        a.actionPerformed(null);
                    }
                }
            });
            fullScreenButton.setBorderPainted(false);
            fullScreenButton.setContentAreaFilled(false);
            fullScreenButton.setCursor(Cursor.getPredefinedCursor(12));
            fullScreenButton.setBorder(BorderFactory.createEmptyBorder());
            fullScreenButton.setPreferredSize(new Dimension(logoWidth, logoHeight));
            c.add((Component)fullScreenButton, "Center");
        }
        return c;
    }

    @Override
    public void setEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : PropertiesBar.this.getComponents()) {
                    c.setEnabled(enabled);
                }
                PropertiesBar.this.selectionBar.setEnabled(enabled);
            }
        });
    }
}

