/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;

public final class GoodsType
extends FreeColSpecObjectType {
    public static final String TAG = "goods-type";
    private static final float DEFAULT_PRODUCTION_WEIGHT = 1.0f;
    private static final float DEFAULT_LOW_PRODUCTION_THRESHOLD = 0.0f;
    private static final float DEFAULT_ZERO_PRODUCTION_FACTOR = 1.0f;
    public static final Comparator<GoodsType> goodsTypeComparator = Comparator.comparingInt(GoodsType::getRank).thenComparing(Function.identity());
    private boolean isFarmed;
    private boolean isFood;
    private boolean ignoreLimit;
    private boolean newWorldGoods;
    private boolean isMilitary = false;
    private boolean buildingMaterial = false;
    private boolean tradeGoods;
    private boolean storable;
    private GoodsType storedAs;
    private GoodsType madeFrom;
    private GoodsType makes = null;
    private int initialAmount;
    private int initialPrice;
    private int priceDiff;
    private int breedingNumber = Integer.MAX_VALUE;
    private int price = Integer.MAX_VALUE;
    private float productionWeight = 1.0f;
    private float lowProductionThreshold = 0.0f;
    private float zeroProductionFactor = 1.0f;
    private static final String BREEDING_NUMBER_TAG = "breeding-number";
    private static final String IGNORE_LIMIT_TAG = "ignore-limit";
    private static final String INITIAL_AMOUNT_TAG = "initial-amount";
    private static final String INITIAL_PRICE_TAG = "initial-price";
    private static final String IS_FARMED_TAG = "is-farmed";
    private static final String IS_FOOD_TAG = "is-food";
    private static final String IS_MILITARY_TAG = "is-military";
    private static final String LOW_PRODUCTION_THRESHOLD_TAG = "low-production-threshold";
    private static final String MADE_FROM_TAG = "made-from";
    private static final String MARKET_TAG = "market";
    private static final String NEW_WORLD_GOODS_TAG = "new-world-goods";
    private static final String PRICE_TAG = "price";
    private static final String PRICE_DIFFERENCE_TAG = "price-difference";
    private static final String PRODUCTION_WEIGHT_TAG = "production-weight";
    private static final String STORABLE_TAG = "storable";
    private static final String STORED_AS_TAG = "stored-as";
    private static final String TRADE_GOODS_TAG = "trade-goods";
    private static final String ZERO_PRODUCTION_FACTOR_TAG = "zero-production-factor";

    public GoodsType(String id, Specification specification) {
        super(id, specification);
    }

    public boolean isFarmed() {
        return this.isFarmed;
    }

    public boolean isFoodType() {
        return this.isFood;
    }

    public boolean getMilitary() {
        return this.isMilitary;
    }

    public void setMilitary() {
        this.isMilitary = true;
    }

    public boolean limitIgnored() {
        return this.ignoreLimit;
    }

    public boolean isNewWorldGoodsType() {
        return this.newWorldGoods;
    }

    public boolean isNewWorldLuxuryType() {
        return this.madeFrom != null && this.madeFrom.isNewWorldGoodsType();
    }

    public boolean isBuildingMaterial() {
        return this.buildingMaterial;
    }

    public boolean isTradeGoods() {
        return this.tradeGoods;
    }

    public boolean isLibertyType() {
        return this.containsModifierKey("model.modifier.liberty");
    }

    public boolean isImmigrationType() {
        return this.containsModifierKey("model.modifier.immigration");
    }

    public boolean isStorable() {
        return this.storable;
    }

    public boolean isStoredAs() {
        return this.storedAs != null;
    }

    public GoodsType getStoredAs() {
        return this.storedAs == null ? this : this.storedAs;
    }

    public boolean isRawMaterial() {
        return this.makes != null;
    }

    public boolean isRefined() {
        return this.madeFrom != null;
    }

    public GoodsType getOutputType() {
        return this.makes;
    }

    public GoodsType getInputType() {
        return this.madeFrom;
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    int getInitialSellPrice() {
        return this.initialPrice;
    }

    int getInitialBuyPrice() {
        return this.initialPrice + this.priceDiff;
    }

    int getPriceDifference() {
        return this.priceDiff;
    }

    public int getBreedingNumber() {
        return this.breedingNumber;
    }

    public boolean isBreedable() {
        return this.breedingNumber != Integer.MAX_VALUE;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int newPrice) {
        this.price = newPrice;
    }

    public float getProductionWeight() {
        return this.productionWeight;
    }

    public float getLowProductionThreshold() {
        return this.lowProductionThreshold;
    }

    public float getZeroProductionFactor() {
        return this.zeroProductionFactor;
    }

    public StringTemplate getLabel() {
        return StringTemplate.key(this.getNameKey());
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public List<GoodsType> getProductionChain() {
        ArrayList<GoodsType> result = new ArrayList<GoodsType>();
        GoodsType currentGoods = this;
        while (currentGoods != null) {
            result.add(0, currentGoods);
            currentGoods = currentGoods.madeFrom;
        }
        return result;
    }

    public boolean isRawBuildingMaterial() {
        if (this.madeFrom != null) {
            return false;
        }
        GoodsType refinedType = this.makes;
        while (refinedType != null) {
            if (refinedType.isBuildingMaterial()) {
                return true;
            }
            refinedType = refinedType.makes;
        }
        return false;
    }

    public Set<GoodsType> getEquivalentTypes() {
        return CollectionUtils.transform(this.getSpecification().getGoodsTypeList(), gt -> gt == this || gt.getStoredAs() == this, Function.identity(), Collectors.toSet());
    }

    public static void setDerivedAttributes(Specification spec) {
        for (GoodsType g : spec.getGoodsTypeList()) {
            g.buildingMaterial = false;
            g.makes = null;
        }
        ArrayList<BuildableType> buildableTypes = new ArrayList<BuildableType>();
        buildableTypes.addAll(spec.getBuildingTypeList());
        buildableTypes.addAll(spec.getUnitTypeList());
        buildableTypes.addAll(spec.getRolesList());
        CollectionUtils.forEach(CollectionUtils.flatten(buildableTypes, BuildableType::getRequiredGoods), ag -> {
            ag.getType().buildingMaterial = true;
        });
        for (GoodsType g : spec.getGoodsTypeList()) {
            if (g.madeFrom == null) continue;
            g.madeFrom.makes = g;
        }
    }

    private int getRank() {
        return !this.isStorable() || this.isTradeGoods() ? -1 : (this.isFoodType() ? 1 : (this.isNewWorldGoodsType() ? 2 : (this.isFarmed() ? 3 : (this.isRawMaterial() ? 4 : (this.isNewWorldLuxuryType() ? 5 : (this.isRefined() ? 6 : -1))))));
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        GoodsType o = this.copyInCast(other, GoodsType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.isFarmed = o.isFarmed();
        this.isFood = o.isFoodType();
        this.ignoreLimit = o.limitIgnored();
        this.newWorldGoods = o.isNewWorldGoodsType();
        this.isMilitary = o.getMilitary();
        this.buildingMaterial = o.isBuildingMaterial();
        this.tradeGoods = o.isTradeGoods();
        this.storable = o.isStorable();
        this.storedAs = o.getStoredAs();
        this.madeFrom = o.getInputType();
        this.makes = o.getOutputType();
        this.initialAmount = o.getInitialAmount();
        this.initialPrice = o.getInitialSellPrice();
        this.priceDiff = o.getPriceDifference();
        this.breedingNumber = o.getBreedingNumber();
        this.price = o.getPrice();
        this.productionWeight = o.getProductionWeight();
        this.lowProductionThreshold = o.getLowProductionThreshold();
        this.zeroProductionFactor = o.getZeroProductionFactor();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(IS_FARMED_TAG, this.isFarmed);
        xw.writeAttribute(IS_FOOD_TAG, this.isFood);
        xw.writeAttribute(IS_MILITARY_TAG, this.isMilitary);
        xw.writeAttribute(IGNORE_LIMIT_TAG, this.ignoreLimit);
        xw.writeAttribute(NEW_WORLD_GOODS_TAG, this.newWorldGoods);
        xw.writeAttribute(TRADE_GOODS_TAG, this.tradeGoods);
        xw.writeAttribute(STORABLE_TAG, this.storable);
        if (this.breedingNumber != Integer.MAX_VALUE) {
            xw.writeAttribute(BREEDING_NUMBER_TAG, this.breedingNumber);
        }
        if (this.price != Integer.MAX_VALUE) {
            xw.writeAttribute(PRICE_TAG, this.price);
        }
        if (this.madeFrom != null) {
            xw.writeAttribute(MADE_FROM_TAG, this.madeFrom);
        }
        if (this.storedAs != null) {
            xw.writeAttribute(STORED_AS_TAG, this.storedAs);
        }
        xw.writeAttribute(PRODUCTION_WEIGHT_TAG, this.productionWeight);
        if (this.lowProductionThreshold > 0.0f) {
            xw.writeAttribute(LOW_PRODUCTION_THRESHOLD_TAG, this.lowProductionThreshold);
        }
        if (0.0 <= (double)this.zeroProductionFactor && this.zeroProductionFactor < 1.0f) {
            xw.writeAttribute(ZERO_PRODUCTION_FACTOR_TAG, this.zeroProductionFactor);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.initialAmount > 0) {
            xw.writeStartElement(MARKET_TAG);
            xw.writeAttribute(INITIAL_AMOUNT_TAG, this.initialAmount);
            xw.writeAttribute(INITIAL_PRICE_TAG, this.initialPrice);
            xw.writeAttribute(PRICE_DIFFERENCE_TAG, this.priceDiff);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.isFarmed = xr.getAttribute(IS_FARMED_TAG, false);
        this.isFood = xr.getAttribute(IS_FOOD_TAG, false);
        this.isMilitary = xr.getAttribute(IS_MILITARY_TAG, false);
        this.ignoreLimit = xr.getAttribute(IGNORE_LIMIT_TAG, false);
        this.newWorldGoods = xr.getAttribute(NEW_WORLD_GOODS_TAG, false);
        this.tradeGoods = xr.getAttribute(TRADE_GOODS_TAG, false);
        this.breedingNumber = xr.getAttribute(BREEDING_NUMBER_TAG, Integer.MAX_VALUE);
        this.price = xr.getAttribute(PRICE_TAG, Integer.MAX_VALUE);
        this.madeFrom = xr.getType(spec, MADE_FROM_TAG, GoodsType.class, null);
        this.storable = xr.getAttribute(STORABLE_TAG, true);
        this.storedAs = xr.getType(spec, STORED_AS_TAG, GoodsType.class, null);
        this.productionWeight = xr.getAttribute(PRODUCTION_WEIGHT_TAG, 1.0f);
        this.lowProductionThreshold = xr.getAttribute(LOW_PRODUCTION_THRESHOLD_TAG, 0.0f);
        this.zeroProductionFactor = xr.getAttribute(ZERO_PRODUCTION_FACTOR_TAG, 1.0f);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (MARKET_TAG.equals(tag)) {
            this.initialAmount = xr.getAttribute(INITIAL_AMOUNT_TAG, 0);
            this.initialPrice = xr.getAttribute(INITIAL_PRICE_TAG, 1);
            this.priceDiff = xr.getAttribute(PRICE_DIFFERENCE_TAG, 1);
            xr.closeTag(MARKET_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }
}

