/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public class ColonyTile
extends WorkLocation {
    private static final Logger logger = Logger.getLogger(ColonyTile.class.getName());
    public static final String TAG = "colonyTile";
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    public static final int UNIT_CAPACITY = 1;
    protected Tile workTile;
    private static final String WORK_TILE_TAG = "workTile";

    protected ColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.colony = colony;
        this.workTile = workTile;
        this.updateProductionType();
    }

    public ColonyTile(Game game, String id) {
        super(game, id);
    }

    public boolean isColonyCenterTile() {
        return this.workTile == this.getTile();
    }

    @Override
    public Tile getWorkTile() {
        return this.workTile;
    }

    public void setWorkTile(Tile workTile) {
        this.workTile = workTile;
    }

    public Unit getOccupyingUnit() {
        return this.workTile.getOccupyingUnit();
    }

    public boolean isOccupied() {
        return this.workTile.isOccupied();
    }

    public ProductionInfo getBasicProductionInfo() {
        Colony colony = this.getColony();
        ProductionInfo pi = new ProductionInfo();
        if (this.isColonyCenterTile()) {
            CollectionUtils.forEach(this.getOutputs(), output -> {
                boolean onlyNaturalImprovements = this.getSpecification().getBoolean("model.option.onlyNaturalImprovements") && !output.getType().isFoodType();
                int potential = output.getAmount();
                if (this.workTile.getTileItemContainer() != null) {
                    potential = this.workTile.getTileItemContainer().getTotalBonusPotential(output.getType(), null, potential, onlyNaturalImprovements);
                }
                AbstractGoods production = new AbstractGoods(output.getType(), potential += Math.max(0, colony.getProductionBonus()));
                pi.addProduction(production);
            });
        } else {
            CollectionUtils.forEach(CollectionUtils.map(this.getOutputs(), AbstractGoods::getType), gt -> {
                int n = CollectionUtils.sum(this.getUnits(), u -> this.getUnitProduction((Unit)u, (GoodsType)gt));
                if (n > 0) {
                    pi.addProduction(new AbstractGoods((GoodsType)gt, n));
                }
            });
        }
        return pi;
    }

    public int improvedBy(TileImprovementType ti) {
        Tile tile = this.getWorkTile();
        Colony colony = this.getColony();
        if (tile == null || tile.getOwningSettlement() != colony || tile.hasTileImprovement(ti)) {
            return 0;
        }
        TileType oldType = tile.getType();
        if (!ti.isTileTypeAllowed(oldType)) {
            return 0;
        }
        ProductionType productionType = this.getProductionType();
        if (productionType == null) {
            return 0;
        }
        Resource resource = tile.getResource();
        TileType newType = ti.getChange(oldType);
        if (productionType.getUnattended()) {
            if (newType == null) {
                return CollectionUtils.sum(this.getSpecification().getFoodGoodsTypeList(), gt -> ti.getBonus((GoodsType)gt));
            }
            List<AbstractGoods> newProd = CollectionUtils.toList(newType.getPossibleProduction(true));
            int food = CollectionUtils.sum(newProd, AbstractGoods::isFoodType, AbstractGoods::getAmount);
            for (AbstractGoods ag : this.getProduction()) {
                int change;
                GoodsType goodsType = ag.getType();
                if (goodsType.isFoodType()) {
                    food -= ag.getAmount();
                    continue;
                }
                if (!colony.isConsuming(goodsType) || (change = -ag.getAmount() + CollectionUtils.sum(newProd, AbstractGoods.matches(goodsType), AbstractGoods::getAmount)) >= 0 || change + colony.getNetProductionOf(goodsType) >= 0) continue;
                return change;
            }
            return food;
        }
        Unit unit = this.getFirstUnit();
        if (unit == null) {
            return 0;
        }
        GoodsType work = this.getCurrentWorkType();
        UnitType unitType = unit.getType();
        return work == null ? 0 : (newType == null ? ti.getBonus(work) : (resource == null ? newType.getPotentialProduction(work, unitType) - oldType.getPotentialProduction(work, unitType) : newType.getPotentialProduction(work, unitType) - resource.applyBonus(work, unitType, oldType.getPotentialProduction(work, unitType))));
    }

    @Override
    public int evaluateFor(Player player) {
        return super.evaluateFor(player) + CollectionUtils.sum(this.getProductionInfo().getProduction(), ag -> ag.evaluateFor(player));
    }

    @Override
    public StringTemplate getLocationLabel() {
        return this.workTile == null ? null : this.workTile.getColonyTileLocationLabel(this.getColony());
    }

    @Override
    public Location up() {
        return this.getColony();
    }

    @Override
    public String toShortString() {
        return this.getColony().getName() + "-" + this.getWorkTile().getType().getSuffix() + "-" + this.getTile().getDirection(this.getWorkTile());
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = super.getNoAddReason(locatable);
        return reason != UnitLocation.NoAddReason.NONE ? reason : this.getNoWorkReason();
    }

    @Override
    public int getUnitCapacity() {
        return this.isColonyCenterTile() ? 0 : 1;
    }

    @Override
    protected boolean goodSuggestionCheck(UnitType unitType, Unit unit, GoodsType goodsType) {
        Tile tile = this.getWorkTile();
        Player owner = this.getOwner();
        return owner.owns(tile) || owner.canClaimForSettlement(tile);
    }

    @Override
    public StringTemplate getLabel() {
        return this.workTile == null ? null : this.workTile.getLabel();
    }

    @Override
    public boolean isAvailable() {
        return this.isCurrent() || this.getOwner().canClaimForSettlement(this.getWorkTile());
    }

    @Override
    public boolean isCurrent() {
        return this.getWorkTile().getOwningSettlement() == this.getColony();
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        Player.NoClaimReason claim;
        Tile tile = this.getWorkTile();
        UnitLocation.NoAddReason noAddReason = this.isColonyCenterTile() ? UnitLocation.NoAddReason.COLONY_CENTER : (!this.getColony().hasAbility("model.ability.produceInWater") && !tile.isLand() ? UnitLocation.NoAddReason.MISSING_ABILITY : (tile.getOwningSettlement() == this.getColony() ? UnitLocation.NoAddReason.NONE : ((claim = this.getOwner().canClaimForSettlementReason(tile)) == Player.NoClaimReason.NONE ? UnitLocation.NoAddReason.CLAIM_REQUIRED : (claim == Player.NoClaimReason.TERRAIN || claim == Player.NoClaimReason.RUMOUR || claim == Player.NoClaimReason.WATER ? UnitLocation.NoAddReason.MISSING_ABILITY : (claim == Player.NoClaimReason.SETTLEMENT ? (this.getOwner().owns(tile.getSettlement()) ? UnitLocation.NoAddReason.ANOTHER_COLONY : UnitLocation.NoAddReason.OWNED_BY_ENEMY) : (claim == Player.NoClaimReason.OCCUPIED ? UnitLocation.NoAddReason.OCCUPIED_BY_ENEMY : (claim == Player.NoClaimReason.WORKED ? UnitLocation.NoAddReason.ANOTHER_COLONY : (claim == Player.NoClaimReason.EUROPEANS ? UnitLocation.NoAddReason.OWNED_BY_ENEMY : (claim == Player.NoClaimReason.NATIVES ? UnitLocation.NoAddReason.CLAIM_REQUIRED : UnitLocation.NoAddReason.WRONG_TYPE)))))))));
        return noAddReason;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean canAutoProduce() {
        return this.isColonyCenterTile();
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        Tile workTile = this.getWorkTile();
        return workTile != null && workTile.canProduce(goodsType, unitType);
    }

    @Override
    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        Tile tile = this.getWorkTile();
        return tile == null ? 0 : tile.getBaseProduction(productionType, goodsType, unitType);
    }

    @Override
    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return Stream.empty();
        }
        Tile workTile = this.getWorkTile();
        TileType type = workTile.getType();
        String id = goodsType.getId();
        Colony colony = this.getColony();
        Player owner = colony.getOwner();
        Turn turn = this.getGame().getTurn();
        return unitType != null ? CollectionUtils.concat(workTile.getProductionModifiers(goodsType, unitType), colony.getProductionModifiers(goodsType, unitType, this), unitType.getModifiers(id, type, turn), owner == null ? null : owner.getModifiers(id, unitType, turn)) : (this.isColonyCenterTile() ? CollectionUtils.concat(workTile.getProductionModifiers(goodsType, null), colony.getProductionModifiers(goodsType, null, this), colony.getModifiers(id, null, turn), owner == null ? null : owner.getModifiers(id, type, turn)) : Stream.empty());
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.workTile == null || this.workTile.getType() == null || unattended != this.isColonyCenterTile() ? Collections.emptyList() : this.workTile.getType().getAvailableProductionTypes(unattended);
    }

    @Override
    public float getCompetenceFactor() {
        return 1.0f;
    }

    @Override
    public float getRebelFactor() {
        return 1.0f;
    }

    @Override
    public StringTemplate getClaimTemplate() {
        return this.isColonyCenterTile() ? super.getClaimTemplate() : StringTemplate.template("model.colonyTile.claim").addNamed("%direction%", this.getTile().getDirection(this.workTile));
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ColonyTile o = this.copyInCast(other, ColonyTile.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.workTile = game.updateRef(o.getWorkTile());
        return true;
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getTile().getDisplayObject();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(WORK_TILE_TAG, this.workTile);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.workTile = xr.makeFreeColObject(this.getGame(), WORK_TILE_TAG, Tile.class, true);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        Colony c = this.getColony();
        sb.append('[').append(this.getId()).append(' ').append(this.getWorkTile()).append('/').append(c == null ? "NO-COLONY" : c.getName()).append(']');
        return sb.toString();
    }
}

