/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaDetailPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public abstract class ColopediaGameObjectTypePanel<T extends FreeColSpecObjectType>
extends FreeColPanel
implements ColopediaDetailPanel<T> {
    private static final Logger logger = Logger.getLogger(ColopediaGameObjectTypePanel.class.getName());
    private ColopediaPanel colopediaPanel;
    private final String id;

    protected ColopediaGameObjectTypePanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel, String id) {
        super(freeColClient);
        this.colopediaPanel = colopediaPanel;
        this.id = "colopediaAction." + id;
    }

    protected String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return Messages.getName(this.id);
    }

    protected void addSubTrees(DefaultMutableTreeNode root, List<T> types) {
        this.addSubTrees(root, this.id, types);
    }

    protected void addSubTrees(DefaultMutableTreeNode root, String id, List<T> types) {
        ImageLibrary lib = this.getImageLibrary();
        String name = this.getName();
        ColopediaTreeItem cti = new ColopediaTreeItem(this, id, name, null);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(cti);
        for (FreeColSpecObjectType type : types) {
            BufferedImage image = ImageUtils.createCenteredImage(lib.getObjectImage(type), this.getListItemIconSize());
            node.add(this.buildItem(type, new ImageIcon(image)));
        }
        root.add(node);
    }

    protected DefaultMutableTreeNode buildItem(FreeColSpecObjectType type, ImageIcon icon) {
        String name = Messages.getName(type);
        return new DefaultMutableTreeNode(new ColopediaTreeItem(this, type.getId(), name, icon));
    }

    protected JButton getButton(FreeColSpecObjectType type, String text, ImageIcon icon) {
        JButton button = Utility.getLinkButton(text != null ? text : Messages.getName(type), icon, type.getId());
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(ColopediaAction.PanelType panelType, String text, ImageIcon icon) {
        JButton button = Utility.getLinkButton(text, icon, "colopediaAction." + panelType.getKey());
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(FreeColSpecObjectType type) {
        return this.getButton(type, null, null);
    }

    protected JButton getResourceButton(ResourceType resourceType) {
        return this.getButton(resourceType, null, new ImageIcon(this.getImageLibrary().getScaledResourceTypeImage(resourceType)));
    }

    protected JButton getGoodsButton(GoodsType goodsType) {
        return this.getGoodsButton(goodsType, null);
    }

    protected JButton getGoodsButton(GoodsType goodsType, int amount) {
        return this.getGoodsButton(goodsType, Integer.toString(amount));
    }

    protected JButton getGoodsButton(AbstractGoods goods) {
        return this.getGoodsButton(goods.getType(), goods.getAmount());
    }

    protected JButton getGoodsButton(GoodsType goodsType, String text) {
        JButton result = this.getButton(goodsType, text, new ImageIcon(this.getImageLibrary().getScaledGoodsTypeImage(goodsType)));
        result.setToolTipText(Messages.getName(goodsType));
        return result;
    }

    protected JButton getUnitButton(AbstractUnit au) {
        return this.getUnitButton(au.getType(this.getSpecification()), au.getRoleId());
    }

    protected JButton getUnitButton(UnitType unitType, String roleId) {
        ImageIcon unitIcon = new ImageIcon(this.getImageLibrary().getSmallUnitTypeImage(unitType, roleId, false));
        JButton unitButton = this.getButton(unitType, null, unitIcon);
        unitButton.setHorizontalAlignment(2);
        return unitButton;
    }

    protected JButton getUnitButton(UnitType unitType) {
        return this.getUnitButton(unitType, unitType.getDisplayRoleId());
    }

    public JComponent getModifierComponent(Modifier modifier) {
        try {
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            String bonus = ModifierFormat.getModifierAsString(modifier);
            return this.getGoodsButton(goodsType, bonus);
        }
        catch (Exception e) {
            JLabel label = new JLabel(ModifierFormat.getFeatureAsString(modifier) + ": " + ModifierFormat.getModifierAsString(modifier));
            label.setToolTipText(Messages.getShortDescription(modifier));
            return label;
        }
    }

    public JLabel getAbilityComponent(Ability ability) {
        if (ability.getValue()) {
            JLabel label = new JLabel(ModifierFormat.getFeatureAsString(ability));
            label.setToolTipText(Messages.getShortDescription(ability));
            return label;
        }
        return null;
    }

    public void appendRequiredAbility(StyledDocument doc, String key, boolean value) {
        Specification spec = this.getSpecification();
        try {
            doc.insertString(doc.getLength(), Messages.getName(key), doc.getStyle("regular"));
            List<JButton> requiredTypes = CollectionUtils.transform(spec.getTypesProviding(key, value), CollectionUtils.alwaysTrue(), t -> {
                JButton typeButton = this.getButton((FreeColSpecObjectType)t);
                typeButton.addActionListener(this);
                return typeButton;
            });
            JButton rt = CollectionUtils.first(requiredTypes);
            if (rt != null) {
                doc.insertString(doc.getLength(), " (", doc.getStyle("regular"));
                StyleConstants.setComponent(doc.getStyle("button"), rt);
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                for (int index = 1; index < requiredTypes.size(); ++index) {
                    JButton button = requiredTypes.get(index);
                    doc.insertString(doc.getLength(), " / ", doc.getStyle("regular"));
                    StyleConstants.setComponent(doc.getStyle("button"), button);
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                }
                doc.insertString(doc.getLength(), ")", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
        }
        catch (BadLocationException ble) {
            logger.log(Level.WARNING, "Insert fail", ble);
        }
    }

    public Dimension getListItemIconSize() {
        return this.colopediaPanel.getListItemIconSize();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.colopediaPanel = null;
    }
}

