/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.mapviewer.GUIMessage;

class ChatDisplay {
    private static final int MESSAGE_COUNT = 5;
    private static final int LEFT_MARGIN = 40;
    private static final int TOP_MARGIN = 300;
    private static final int MESSAGE_AGE = 30000;
    private final ImageLibrary lib;
    private final Font font;
    private final List<GUIMessage> messages;

    ChatDisplay(FreeColClient freeColClient) {
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.font = FontLibrary.getScaledFont("normal-plain-tiny");
        this.messages = new ArrayList<GUIMessage>(5);
    }

    synchronized void addMessage(GUIMessage message) {
        if (this.messages.size() >= 5) {
            this.messages.remove(0);
        }
        this.messages.add(message);
    }

    private synchronized List<GUIMessage> prepareMessages() {
        long currentTime = new Date().getTime();
        ArrayList<GUIMessage> ret = new ArrayList<GUIMessage>();
        int i = 0;
        while (i < this.messages.size()) {
            GUIMessage m = this.messages.get(i);
            long creationTime = m.getCreationTime();
            if (currentTime - creationTime >= 30000L) {
                this.messages.remove(i);
                continue;
            }
            ret.add(m);
            ++i;
        }
        return ret;
    }

    void display(Graphics2D g, Dimension size) {
        List<GUIMessage> msgs = this.prepareMessages();
        if (msgs.isEmpty()) {
            return;
        }
        int yy = -1;
        int xx = this.lib.scaleInt(40);
        for (GUIMessage m : msgs) {
            BufferedImage si = this.lib.getStringImage(g, m.getMessage(), m.getColor(), this.font);
            if (yy < 0) {
                yy = size.height - this.lib.scaleInt(300) - msgs.size() * ((Image)si).getHeight(null);
            }
            g.drawImage((Image)si, xx, yy, null);
            yy += ((Image)si).getHeight(null);
        }
    }
}

