/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.FreeColFrame;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.dialog.CaptureGoodsDialog;
import net.sf.freecol.client.gui.dialog.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.dialog.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.dialog.DifficultyDialog;
import net.sf.freecol.client.gui.dialog.DumpCargoDialog;
import net.sf.freecol.client.gui.dialog.EditOptionDialog;
import net.sf.freecol.client.gui.dialog.EditSettlementDialog;
import net.sf.freecol.client.gui.dialog.EmigrationDialog;
import net.sf.freecol.client.gui.dialog.EndTurnDialog;
import net.sf.freecol.client.gui.dialog.FirstContactDialog;
import net.sf.freecol.client.gui.dialog.FreeColChoiceDialog;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.dialog.FreeColStringInputDialog;
import net.sf.freecol.client.gui.dialog.GameOptionsDialog;
import net.sf.freecol.client.gui.dialog.LoadDialog;
import net.sf.freecol.client.gui.dialog.LoadingSavegameDialog;
import net.sf.freecol.client.gui.dialog.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.dialog.MapSizeDialog;
import net.sf.freecol.client.gui.dialog.MonarchDialog;
import net.sf.freecol.client.gui.dialog.NativeDemandDialog;
import net.sf.freecol.client.gui.dialog.NegotiationDialog;
import net.sf.freecol.client.gui.dialog.Parameters;
import net.sf.freecol.client.gui.dialog.ParametersDialog;
import net.sf.freecol.client.gui.dialog.PreCombatDialog;
import net.sf.freecol.client.gui.dialog.RiverStyleDialog;
import net.sf.freecol.client.gui.dialog.SaveDialog;
import net.sf.freecol.client.gui.dialog.ScaleMapSizeDialog;
import net.sf.freecol.client.gui.dialog.SelectAmountDialog;
import net.sf.freecol.client.gui.dialog.SelectDestinationDialog;
import net.sf.freecol.client.gui.dialog.SelectTributeAmountDialog;
import net.sf.freecol.client.gui.dialog.VictoryDialog;
import net.sf.freecol.client.gui.dialog.WarehouseDialog;
import net.sf.freecol.client.gui.panel.AboutPanel;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;
import net.sf.freecol.client.gui.panel.DeclarationPanel;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FindSettlementPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationPanel;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.PurchasePanel;
import net.sf.freecol.client.gui.panel.RecruitPanel;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StatisticsPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteInputPanel;
import net.sf.freecol.client.gui.panel.TradeRoutePanel;
import net.sf.freecol.client.gui.panel.TrainPanel;
import net.sf.freecol.client.gui.panel.WorkProductionPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.report.CompactLabourReport;
import net.sf.freecol.client.gui.panel.report.LabourData;
import net.sf.freecol.client.gui.panel.report.ReportCargoPanel;
import net.sf.freecol.client.gui.panel.report.ReportClassicColonyPanel;
import net.sf.freecol.client.gui.panel.report.ReportCompactColonyPanel;
import net.sf.freecol.client.gui.panel.report.ReportContinentalCongressPanel;
import net.sf.freecol.client.gui.panel.report.ReportEducationPanel;
import net.sf.freecol.client.gui.panel.report.ReportExplorationPanel;
import net.sf.freecol.client.gui.panel.report.ReportForeignAffairPanel;
import net.sf.freecol.client.gui.panel.report.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.report.ReportHistoryPanel;
import net.sf.freecol.client.gui.panel.report.ReportIndianPanel;
import net.sf.freecol.client.gui.panel.report.ReportLabourDetailPanel;
import net.sf.freecol.client.gui.panel.report.ReportLabourPanel;
import net.sf.freecol.client.gui.panel.report.ReportMilitaryPanel;
import net.sf.freecol.client.gui.panel.report.ReportNavalPanel;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.client.gui.panel.report.ReportProductionPanel;
import net.sf.freecol.client.gui.panel.report.ReportReligiousPanel;
import net.sf.freecol.client.gui.panel.report.ReportRequirementsPanel;
import net.sf.freecol.client.gui.panel.report.ReportTradePanel;
import net.sf.freecol.client.gui.panel.report.ReportTurnPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.Utils;

public final class Widgets {
    private static final Logger logger = Logger.getLogger(Widgets.class.getName());
    private final FreeColClient freeColClient;
    private final Canvas canvas;

    public Widgets(FreeColClient freeColClient, Canvas canvas) {
        this.freeColClient = freeColClient;
        this.canvas = canvas;
    }

    private FreeColFrame getFrame() {
        return this.canvas.getParentFrame();
    }

    public boolean confirm(StringTemplate tmpl, ImageIcon icon, String okKey, String cancelKey, SwingGUI.PopupPosition pos) {
        FreeColConfirmDialog dialog = new FreeColConfirmDialog(this.freeColClient, (JFrame)this.getFrame(), true, tmpl, icon, okKey, cancelKey);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public <T> T getChoice(StringTemplate tmpl, ImageIcon icon, String cancelKey, List<ChoiceItem<T>> choices, SwingGUI.PopupPosition pos) {
        if (choices.isEmpty()) {
            return null;
        }
        FreeColChoiceDialog<T> dialog = new FreeColChoiceDialog<T>(this.freeColClient, (JFrame)this.getFrame(), true, tmpl, icon, cancelKey, choices);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public String getInput(StringTemplate tmpl, String defaultValue, String okKey, String cancelKey, SwingGUI.PopupPosition pos) {
        FreeColStringInputDialog dialog = new FreeColStringInputDialog(this.freeColClient, (JFrame)this.getFrame(), true, tmpl, defaultValue, okKey, cancelKey);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public FreeColPanel showAboutPanel() {
        AboutPanel panel = new AboutPanel(this.freeColClient);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public FreeColPanel showBuildQueuePanel(Colony colony) {
        BuildQueuePanel panel = this.canvas.getExistingFreeColPanel(BuildQueuePanel.class);
        if (panel == null || panel.getColony() != colony) {
            panel = new BuildQueuePanel(this.freeColClient, colony);
            return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
        new DialogCallback<List<Goods>>(new CaptureGoodsDialog(this.freeColClient, this.getFrame(), unit, gl), null, handler);
    }

    public FreeColPanel showChatPanel() {
        ChatPanel panel = new ChatPanel(this.freeColClient);
        this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        panel.requestFocus();
        return panel;
    }

    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
        new DialogCallback<FoundingFather>(new ChooseFoundingFatherDialog(this.freeColClient, this.getFrame(), ffs), null, handler);
    }

    public FreeColPanel showColopediaPanel(String nodeId) {
        ColopediaPanel panel = new ColopediaPanel(this.freeColClient, nodeId);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showColorChooserPanel(ActionListener al) {
        ColorChooserPanel panel = new ColorChooserPanel(this.freeColClient, al);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public FreeColPanel showCompactLabourReport() {
        CompactLabourReport panel = new CompactLabourReport(this.freeColClient);
        panel.initialize();
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public FreeColPanel showCompactLabourReport(LabourData.UnitData unitData) {
        CompactLabourReport panel = new CompactLabourReport(this.freeColClient, unitData);
        panel.initialize();
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public List<String> showConfirmDeclarationDialog() {
        ConfirmDeclarationDialog dialog = new ConfirmDeclarationDialog(this.freeColClient, this.getFrame());
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public void showDeclarationPanel(Runnable afterClosing) {
        DeclarationPanel panel = new DeclarationPanel(this.freeColClient, afterClosing);
        this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public OptionGroup showDifficultyDialog(Specification spec, OptionGroup group, boolean editable) {
        DifficultyDialog dialog = new DifficultyDialog(this.freeColClient, this.getFrame(), spec, group, editable);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public void showDumpCargoDialog(Unit unit, SwingGUI.PopupPosition pos, DialogHandler<List<Goods>> handler) {
        new DialogCallback<List<Goods>>(new DumpCargoDialog(this.freeColClient, this.getFrame(), unit), pos, handler);
    }

    public boolean showEditOptionDialog(Option op) {
        if (op == null) {
            return false;
        }
        EditOptionDialog dialog = new EditOptionDialog(this.freeColClient, this.getFrame(), op);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public IndianSettlement showEditSettlementDialog(IndianSettlement is) {
        EditSettlementDialog dialog = new EditSettlementDialog(this.freeColClient, this.getFrame(), is);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
        new DialogCallback<Integer>(new EmigrationDialog(this.freeColClient, this.getFrame(), player.getEurope(), fountainOfYouth), null, handler);
    }

    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
        new DialogCallback<Boolean>(new EndTurnDialog(this.freeColClient, this.getFrame(), units), null, handler);
    }

    public FreeColPanel showErrorPanel(String message) {
        if (message == null) {
            return null;
        }
        ErrorPanel panel = new ErrorPanel(this.freeColClient, message);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showEuropePanel(Runnable callback) {
        if (this.freeColClient.getGame() == null) {
            return null;
        }
        EuropePanel panel = this.canvas.getExistingFreeColPanel(EuropePanel.class);
        if (panel == null) {
            panel = new EuropePanel(this.freeColClient, this.canvas.getHeight() > 780);
            if (callback != null) {
                panel.addClosingCallback(callback);
            }
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showEventPanel(String header, String image, String footer) {
        EventPanel panel = new EventPanel(this.freeColClient, header, image, footer);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public FreeColPanel showFindSettlementPanel() {
        FindSettlementPanel panel = new FindSettlementPanel(this.freeColClient);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.ORIGIN, true);
    }

    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, SwingGUI.PopupPosition pos, DialogHandler<Boolean> handler) {
        new DialogCallback<Boolean>(new FirstContactDialog(this.freeColClient, this.getFrame(), player, other, tile, settlementCount), pos, handler);
    }

    public OptionGroup showGameOptionsDialog(boolean editable) {
        GameOptionsDialog dialog = new GameOptionsDialog(this.freeColClient, this.getFrame(), editable);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public FreeColPanel showHighScoresPanel(String messageId, List<HighScore> scores) {
        ReportHighScoresPanel panel = new ReportHighScoresPanel(this.freeColClient, messageId, scores);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showIndianSettlementPanel(IndianSettlement is, SwingGUI.PopupPosition pos) {
        IndianSettlementPanel panel = new IndianSettlementPanel(this.freeColClient, is);
        return this.canvas.showFreeColPanel(panel, pos, true);
    }

    public FreeColPanel showInformationPanel(FreeColObject displayObject, SwingGUI.PopupPosition pos, ImageIcon icon, StringTemplate tmpl) {
        InformationPanel panel = new InformationPanel(this.freeColClient, new String[]{Messages.message(tmpl)}, new FreeColObject[]{displayObject}, new ImageIcon[]{icon});
        return this.canvas.showFreeColPanel(panel, pos, true);
    }

    public File showLoadDialog(File directory, FileFilter[] filters) {
        LoadDialog dialog = new LoadDialog(this.freeColClient, this.getFrame(), directory, filters);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public LoadingSavegameInfo showLoadingSavegameDialog(boolean pubSer, boolean single) {
        LoadingSavegameDialog dialog = new LoadingSavegameDialog(this.freeColClient, this.getFrame());
        return this.canvas.showFreeColDialog(dialog, null) != false ? dialog.getInfo() : null;
    }

    public FreeColPanel showLogFilePanel() {
        ErrorPanel panel = new ErrorPanel(this.freeColClient);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        MapGeneratorOptionsDialog dialog = new MapGeneratorOptionsDialog(this.freeColClient, this.getFrame(), editable);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public Dimension showMapSizeDialog() {
        MapSizeDialog dialog = new MapSizeDialog(this.freeColClient, this.getFrame());
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate tmpl, String monarchKey, DialogHandler<Boolean> handler) {
        new DialogCallback<Boolean>(new MonarchDialog(this.freeColClient, this.getFrame(), action, tmpl, monarchKey), null, handler);
    }

    public void showNamingDialog(StringTemplate tmpl, String defaultName, SwingGUI.PopupPosition pos, DialogHandler<String> handler) {
        new DialogCallback<String>(new FreeColStringInputDialog(this.freeColClient, (JFrame)this.getFrame(), false, tmpl, defaultName, "ok", null), pos, handler);
    }

    public void showNativeDemandDialog(Unit unit, Colony colony, GoodsType type, int amount, SwingGUI.PopupPosition pos, DialogHandler<Boolean> handler) {
        new DialogCallback<Boolean>(new NativeDemandDialog(this.freeColClient, this.getFrame(), unit, colony, type, amount), pos, handler);
    }

    public DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment, SwingGUI.PopupPosition pos) {
        NegotiationDialog dialog = new NegotiationDialog(this.freeColClient, this.getFrame(), our, other, agreement, comment);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public FreeColPanel showNewPanel(Specification specification) {
        NewPanel panel = new NewPanel(this.freeColClient, specification);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public Parameters showParametersDialog() {
        ParametersDialog dialog = new ParametersDialog(this.freeColClient, this.getFrame());
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, SwingGUI.PopupPosition pos) {
        PreCombatDialog dialog = new PreCombatDialog(this.freeColClient, this.getFrame(), attacker, defender);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public FreeColPanel showPurchasePanel() {
        PurchasePanel panel = this.canvas.getExistingFreeColPanel(PurchasePanel.class);
        if (panel == null) {
            panel = new PurchasePanel(this.freeColClient);
            panel.update();
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
        }
        return panel;
    }

    public FreeColPanel showRecruitPanel() {
        RecruitPanel panel = this.canvas.getExistingFreeColPanel(RecruitPanel.class);
        if (panel == null) {
            panel = new RecruitPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
        }
        return panel;
    }

    public FreeColPanel showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        ReportLabourDetailPanel panel = new ReportLabourDetailPanel(this.freeColClient, unitType, data, unitCount, colonies);
        panel.initialize();
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public String showRiverStyleDialog(List<String> styles) {
        RiverStyleDialog dialog = new RiverStyleDialog(this.freeColClient, this.getFrame(), styles);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public File showSaveDialog(File directory, FileFilter[] filters, String defaultName) {
        SaveDialog dialog = new SaveDialog(this.freeColClient, this.getFrame(), directory, filters, defaultName);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public Dimension showScaleMapSizeDialog() {
        ScaleMapSizeDialog dialog = new ScaleMapSizeDialog(this.freeColClient, this.getFrame());
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        SelectAmountDialog dialog = new SelectAmountDialog(this.freeColClient, this.getFrame(), goodsType, available, defaultAmount, needToPay);
        Integer result = this.canvas.showFreeColDialog(dialog, null);
        return result == null ? -1 : result;
    }

    public Location showSelectDestinationDialog(Unit unit, SwingGUI.PopupPosition pos) {
        SelectDestinationDialog dialog = new SelectDestinationDialog(this.freeColClient, this.getFrame(), unit);
        return this.canvas.showFreeColDialog(dialog, pos);
    }

    public FreeColPanel showServerListPanel(List<ServerInfo> serverList) {
        ServerListPanel panel = new ServerListPanel(this.freeColClient, this.freeColClient.getConnectController());
        panel.initialize(serverList);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        SelectTributeAmountDialog dialog = new SelectTributeAmountDialog(this.freeColClient, this.getFrame(), question, maximum);
        Integer result = this.canvas.showFreeColDialog(dialog, null);
        return result == null ? -1 : result;
    }

    public FreeColPanel showStatisticsPanel(Map<String, String> serverStats, Map<String, String> clientStats) {
        StatisticsPanel panel = new StatisticsPanel(this.freeColClient, serverStats, clientStats);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showTilePanel(Tile tile) {
        if (tile == null || !tile.isExplored()) {
            return null;
        }
        TilePanel panel = new TilePanel(this.freeColClient, tile);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
    }

    public FreeColPanel showTradeRouteInputPanel(TradeRoute newRoute) {
        TradeRouteInputPanel panel = new TradeRouteInputPanel(this.freeColClient, newRoute);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showTradeRoutePanel(Unit unit, SwingGUI.PopupPosition pos) {
        TradeRoutePanel panel = new TradeRoutePanel(this.freeColClient, unit);
        return this.canvas.showFreeColPanel(panel, pos, true);
    }

    public FreeColPanel showTrainPanel() {
        TrainPanel panel = this.canvas.getExistingFreeColPanel(TrainPanel.class);
        if (panel == null) {
            panel = new TrainPanel(this.freeColClient);
            panel.update();
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, false);
        }
        return panel;
    }

    public void showVictoryDialog(DialogHandler<Boolean> handler) {
        new DialogCallback<Boolean>(new VictoryDialog(this.freeColClient, this.getFrame()), null, handler);
    }

    public boolean showWarehouseDialog(Colony colony) {
        WarehouseDialog dialog = new WarehouseDialog(this.freeColClient, this.getFrame(), colony);
        return this.canvas.showFreeColDialog(dialog, null);
    }

    public FreeColPanel showWorkProductionPanel(Unit unit) {
        WorkProductionPanel panel = new WorkProductionPanel(this.freeColClient, unit);
        return this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
    }

    public FreeColPanel showReportCargoPanel() {
        ReportCargoPanel panel = this.canvas.getExistingFreeColPanel(ReportCargoPanel.class);
        if (panel == null) {
            panel = new ReportCargoPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportColonyPanel(boolean compact) {
        ReportPanel panel;
        if (compact) {
            panel = this.canvas.getExistingFreeColPanel(ReportCompactColonyPanel.class);
            if (panel == null) {
                panel = new ReportCompactColonyPanel(this.freeColClient);
                this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
            }
        } else {
            panel = this.canvas.getExistingFreeColPanel(ReportClassicColonyPanel.class);
            if (panel == null) {
                panel = new ReportClassicColonyPanel(this.freeColClient);
                this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
            }
        }
        return panel;
    }

    public FreeColPanel showReportContinentalCongressPanel() {
        ReportContinentalCongressPanel panel = this.canvas.getExistingFreeColPanel(ReportContinentalCongressPanel.class);
        if (panel == null) {
            panel = new ReportContinentalCongressPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportEducationPanel() {
        ReportEducationPanel panel = this.canvas.getExistingFreeColPanel(ReportEducationPanel.class);
        if (panel == null) {
            panel = new ReportEducationPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportExplorationPanel() {
        ReportExplorationPanel panel = this.canvas.getExistingFreeColPanel(ReportExplorationPanel.class);
        if (panel == null) {
            panel = new ReportExplorationPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportForeignAffairPanel() {
        ReportForeignAffairPanel panel = this.canvas.getExistingFreeColPanel(ReportForeignAffairPanel.class);
        if (panel == null) {
            panel = new ReportForeignAffairPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportHistoryPanel() {
        ReportHistoryPanel panel = this.canvas.getExistingFreeColPanel(ReportHistoryPanel.class);
        if (panel == null) {
            panel = new ReportHistoryPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportIndianPanel() {
        ReportIndianPanel panel = this.canvas.getExistingFreeColPanel(ReportIndianPanel.class);
        if (panel == null) {
            panel = new ReportIndianPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportLabourPanel() {
        ReportLabourPanel panel = this.canvas.getExistingFreeColPanel(ReportLabourPanel.class);
        if (panel == null) {
            panel = new ReportLabourPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportMilitaryPanel() {
        ReportMilitaryPanel panel = this.canvas.getExistingFreeColPanel(ReportMilitaryPanel.class);
        if (panel == null) {
            panel = new ReportMilitaryPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportNavalPanel() {
        ReportNavalPanel panel = this.canvas.getExistingFreeColPanel(ReportNavalPanel.class);
        if (panel == null) {
            panel = new ReportNavalPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportProductionPanel() {
        ReportProductionPanel panel = this.canvas.getExistingFreeColPanel(ReportProductionPanel.class);
        if (panel == null) {
            panel = new ReportProductionPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportReligiousPanel() {
        ReportReligiousPanel panel = this.canvas.getExistingFreeColPanel(ReportReligiousPanel.class);
        if (panel == null) {
            panel = new ReportReligiousPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportRequirementsPanel() {
        ReportRequirementsPanel panel = this.canvas.getExistingFreeColPanel(ReportRequirementsPanel.class);
        if (panel == null) {
            panel = new ReportRequirementsPanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportTradePanel() {
        ReportTradePanel panel = this.canvas.getExistingFreeColPanel(ReportTradePanel.class);
        if (panel == null) {
            panel = new ReportTradePanel(this.freeColClient);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        }
        return panel;
    }

    public FreeColPanel showReportTurnPanel(List<ModelMessage> messages) {
        ReportTurnPanel panel = this.canvas.getExistingFreeColPanel(ReportTurnPanel.class);
        if (panel == null) {
            panel = new ReportTurnPanel(this.freeColClient, messages);
            this.canvas.showFreeColPanel(panel, SwingGUI.PopupPosition.CENTERED, true);
        } else {
            panel.setMessages(messages);
        }
        return panel;
    }

    private class DialogCallback<T>
    implements Runnable {
        private final FreeColDialog<T> fcd;
        private final SwingGUI.PopupPosition pos;
        private final DialogHandler<T> handler;

        public DialogCallback(FreeColDialog<T> fcd, SwingGUI.PopupPosition pos, DialogHandler<T> handler) {
            this.fcd = fcd;
            this.pos = pos;
            this.handler = handler;
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Widgets.this.canvas.viewFreeColDialog(this.fcd, this.pos);
            new Thread(this.fcd.toString()){

                @Override
                public void run() {
                    while (!DialogCallback.this.fcd.responded()) {
                        Utils.delay(500L, "Dialog interrupted.");
                    }
                    DialogCallback.this.handler.handle(DialogCallback.this.fcd.getResponse());
                }
            }.start();
        }
    }
}

