/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.functional.renderer.OWLFunctionalSyntaxRenderer;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.utilities.Injector;

public class OwlStringTools {
    private static final Injector injector = OwlStringTools.injector();

    @Nullable
    public static String translate(@Nullable Set<OWLAxiom> axioms, @Nonnull OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            OWLOntologyManager m = injector.inject(injector.getImplementation(OWLOntologyManager.class, new Annotation[0]));
            HashSet<OWLOntologyFactory> set = new HashSet<OWLOntologyFactory>();
            translationManager.getOntologyFactories().forEach(set::add);
            m.setOntologyFactories(set);
            OWLOntology ontology = m.createOntology();
            ontology.getOWLOntologyManager().addAxioms(ontology, axioms);
            OWLFunctionalSyntaxRenderer r = new OWLFunctionalSyntaxRenderer();
            StringWriter writer = new StringWriter();
            r.render(ontology, writer);
            return ((Object)writer).toString();
        }
        catch (OWLRendererException e) {
            throw new OwlStringException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new OwlStringException(e);
        }
    }

    private static Injector injector() {
        Injector i = new Injector();
        i.bindToOne(() -> new ReentrantReadWriteLock(), ReadWriteLock.class, new Annotation[0]);
        i.bindToOne(() -> new OWLOntologyBuilder(){

            @Override
            public OWLOntology createOWLOntology(OWLOntologyManager manager, OWLOntologyID ontologyID) {
                return null;
            }
        }, OWLOntologyBuilder.class, new Annotation[0]);
        return i;
    }

    @Nullable
    public static Set<OWLAxiom> translate(@Nullable String axioms, @Nonnull OWLOntologyManager translationManager) throws OwlStringException {
        if (axioms == null || axioms.isEmpty()) {
            return null;
        }
        try {
            StringDocumentSource documentSource = new StringDocumentSource(axioms, IRI.generateDocumentIRI(), new FunctionalSyntaxDocumentFormat(), null);
            OWLOntologyManager m = injector.inject(injector.getImplementation(OWLOntologyManager.class, new Annotation[0]));
            HashSet<OWLOntologyFactory> set = new HashSet<OWLOntologyFactory>();
            translationManager.getOntologyFactories().forEach(set::add);
            m.setOntologyFactories(set);
            return m.loadOntologyFromOntologyDocument(documentSource).getAxioms();
        }
        catch (UnloadableImportException e) {
            throw new OwlStringException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new OwlStringException(e);
        }
        catch (OWLParserException e) {
            throw new OwlStringException(e);
        }
    }

    public static class OwlStringException
    extends Exception {
        private static final long serialVersionUID = 40000L;

        protected OwlStringException(Throwable cause) {
            super(cause);
        }
    }
}

