/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SimpleNonSelectQueryPlan;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.StandardSqmTranslation;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.AbstractUpdateOrDeleteStatement;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SimpleDeleteQueryPlan
extends SimpleNonSelectQueryPlan {
    private final EntityPersister entityDescriptor;
    private volatile List<JdbcOperationQueryMutation> collectionTableDeletes;

    public SimpleDeleteQueryPlan(EntityPersister entityDescriptor, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref) {
        super(sqmDelete, domainParameterXref);
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    protected SimpleNonSelectQueryPlan.Interpretation buildInterpretation(SqmDmlStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        SimpleNonSelectQueryPlan.Interpretation sqmInterpretation = super.buildInterpretation(sqm, domainParameterXref, context);
        SessionFactoryImplementor factory = context.getSession().getFactory();
        AbstractUpdateOrDeleteStatement statement = (AbstractUpdateOrDeleteStatement)sqmInterpretation.interpretation().statement();
        ArrayList<JdbcOperationQueryMutation> collectionTableDeletes = new ArrayList<JdbcOperationQueryMutation>();
        SqmMutationStrategyHelper.visitCollectionTableDeletes(this.entityDescriptor, (tableReference, attributeMapping) -> {
            MutatingTableReferenceGroupWrapper collectionTableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference);
            MutableObject additionalPredicate = new MutableObject();
            attributeMapping.applyBaseRestrictions(p -> additionalPredicate.set(Predicate.combinePredicates((Predicate)additionalPredicate.get(), p)), collectionTableGroup, factory.getJdbcServices().getDialect().getDmlTargetColumnQualifierSupport() == DmlTargetColumnQualifierSupport.TABLE_ALIAS, context.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, null);
            if (statement.getRestriction() == null) {
                return (Predicate)additionalPredicate.get();
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(collectionTableGroup, fkDescriptor.getKeyPart(), null, factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            MutatingTableReferenceGroupWrapper tableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, statement.getTargetTable());
            Expression fkTargetColumnExpression = MappingModelCreationHelper.buildColumnReferenceExpression(tableGroup, fkDescriptor.getTargetPart(), null, factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot(tableGroup);
            matchingIdSubQuery.applyPredicate(statement.getRestriction());
            return Predicate.combinePredicates((Predicate)additionalPredicate.get(), new InSubQueryPredicate(fkColumnExpression, matchingIdSubQuery, false));
        }, sqmInterpretation.jdbcParameterBindings(), context.getQueryOptions(), collectionTableDeletes::add);
        this.collectionTableDeletes = collectionTableDeletes;
        return sqmInterpretation;
    }

    protected List<JdbcOperationQueryMutation> getCollectionTableDeletes() {
        return this.collectionTableDeletes;
    }

    @Override
    protected int execute(CacheableSqmInterpretation<MutationStatement, JdbcOperationQueryMutation> sqmInterpretation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcMutationExecutor jdbcMutationExecutor = factory.getJdbcServices().getJdbcMutationExecutor();
        for (JdbcOperationQueryMutation delete : this.collectionTableDeletes) {
            jdbcMutationExecutor.execute(delete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        }
        return super.execute(sqmInterpretation, jdbcParameterBindings, executionContext);
    }

    @Override
    protected SqmTranslation<? extends MutationStatement> buildTranslation(SqmDmlStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SqmTranslation<? extends MutationStatement> sqmTranslation = super.buildTranslation(sqm, domainParameterXref, executionContext);
        SoftDeleteMapping columnMapping = this.entityDescriptor.getSoftDeleteMapping();
        if (columnMapping == null) {
            return sqmTranslation;
        }
        AbstractUpdateOrDeleteStatement sqlDeleteAst = (AbstractUpdateOrDeleteStatement)sqmTranslation.getSqlAst();
        NamedTableReference targetTable = sqlDeleteAst.getTargetTable();
        Assignment assignment = columnMapping.createSoftDeleteAssignment(targetTable);
        return new StandardSqmTranslation<UpdateStatement>(new UpdateStatement(sqlDeleteAst, targetTable, sqlDeleteAst.getFromClause(), Collections.singletonList(assignment), sqlDeleteAst.getRestriction(), sqlDeleteAst.getReturningColumns()), sqmTranslation.getJdbcParamsBySqmParam(), sqmTranslation.getSqmParameterMappingModelTypeResolutions(), sqmTranslation.getSqlExpressionResolver(), sqmTranslation.getFromClauseAccess());
    }
}

