/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

public final class NativeLong
extends Number
implements Comparable<NativeLong> {
    private static final NativeLong ZERO = new NativeLong(0);
    private static final NativeLong ONE = new NativeLong(1);
    private static final NativeLong MINUS_ONE = new NativeLong(-1);
    private final long value;

    public NativeLong(long value2) {
        this.value = value2;
    }

    public NativeLong(int value2) {
        this.value = value2;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof NativeLong && this.value == ((NativeLong)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final int compareTo(NativeLong other) {
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    private static NativeLong _valueOf(long value2) {
        return value2 >= -128L && value2 <= 127L ? Cache.cache[128 + (int)value2] : new NativeLong(value2);
    }

    private static NativeLong _valueOf(int value2) {
        return value2 >= -128 && value2 <= 127 ? Cache.cache[128 + value2] : new NativeLong(value2);
    }

    public static NativeLong valueOf(long value2) {
        return value2 == 0L ? ZERO : (value2 == 1L ? ONE : (value2 == -1L ? MINUS_ONE : NativeLong._valueOf(value2)));
    }

    public static NativeLong valueOf(int value2) {
        return value2 == 0 ? ZERO : (value2 == 1 ? ONE : (value2 == -1 ? MINUS_ONE : NativeLong._valueOf(value2)));
    }

    private static final class Cache {
        static final NativeLong[] cache = new NativeLong[256];

        private Cache() {
        }

        static {
            for (int i2 = 0; i2 < cache.length; ++i2) {
                Cache.cache[i2] = new NativeLong(i2 - 128);
            }
            Cache.cache[128] = ZERO;
            Cache.cache[129] = ONE;
            Cache.cache[127] = MINUS_ONE;
        }
    }
}

