﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/marketplace-catalog/MarketplaceCatalog_EXPORTS.h>
#include <aws/marketplace-catalog/model/MachineLearningProductSortBy.h>
#include <aws/marketplace-catalog/model/SortOrder.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MarketplaceCatalog {
namespace Model {

/**
 * <p>The sort options for machine learning products.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/MachineLearningProductSort">AWS
 * API Reference</a></p>
 */
class MachineLearningProductSort {
 public:
  AWS_MARKETPLACECATALOG_API MachineLearningProductSort() = default;
  AWS_MARKETPLACECATALOG_API MachineLearningProductSort(Aws::Utils::Json::JsonView jsonValue);
  AWS_MARKETPLACECATALOG_API MachineLearningProductSort& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MARKETPLACECATALOG_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The field to sort by. Valid values: <code>EntityId</code>,
   * <code>LastModifiedDate</code>, <code>ProductTitle</code>, and
   * <code>Visibility</code>.</p>
   */
  inline MachineLearningProductSortBy GetSortBy() const { return m_sortBy; }
  inline bool SortByHasBeenSet() const { return m_sortByHasBeenSet; }
  inline void SetSortBy(MachineLearningProductSortBy value) {
    m_sortByHasBeenSet = true;
    m_sortBy = value;
  }
  inline MachineLearningProductSort& WithSortBy(MachineLearningProductSortBy value) {
    SetSortBy(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sort order. Valid values are <code>ASC</code> (ascending) and
   * <code>DESC</code> (descending).</p>
   */
  inline SortOrder GetSortOrder() const { return m_sortOrder; }
  inline bool SortOrderHasBeenSet() const { return m_sortOrderHasBeenSet; }
  inline void SetSortOrder(SortOrder value) {
    m_sortOrderHasBeenSet = true;
    m_sortOrder = value;
  }
  inline MachineLearningProductSort& WithSortOrder(SortOrder value) {
    SetSortOrder(value);
    return *this;
  }
  ///@}
 private:
  MachineLearningProductSortBy m_sortBy{MachineLearningProductSortBy::NOT_SET};
  bool m_sortByHasBeenSet = false;

  SortOrder m_sortOrder{SortOrder::NOT_SET};
  bool m_sortOrderHasBeenSet = false;
};

}  // namespace Model
}  // namespace MarketplaceCatalog
}  // namespace Aws
